<p align="center"> 
  <br/>  
  <a href="https://opensource.org/license/agpl-v3"><img src="https://img.shields.io/badge/License-AGPL_v3-blue.svg?color=3F51B5&style=for-the-badge&label=License&logoColor=000000&labelColor=ececec" alt="License: AGPLv3"></a>
  <a href="https://discord.immich.app">
    <img src="https://img.shields.io/discord/979116623879368755.svg?label=Discord&logo=Discord&style=for-the-badge&logoColor=000000&labelColor=ececec" alt="Discord"/>
  </a>
  <br/>  
  <br/>   
</p>

<p align="center">
<img src="../design/immich-logo-stacked-light.svg" width="300" title="Login With Custom URL">
</p>
<h3 align="center">Högpresterande self-hostad lösning för hantering av foton och videor</h3>
<br/>
<a href="https://immich.app">
<img src="../design/immich-screenshots.png" title="Main Screenshot">
</a>
<br/>
<p align="center">

  <a href="../README.md">English</a>
  <a href="README_ca_ES.md">Català</a>
  <a href="README_es_ES.md">Español</a>
  <a href="README_fr_FR.md">Français</a>
  <a href="README_it_IT.md">Italiano</a>
  <a href="README_ja_JP.md">日本語</a>
  <a href="README_ko_KR.md">한국어</a>
  <a href="README_de_DE.md">Deutsch</a>
  <a href="README_nl_NL.md">Nederlands</a>
  <a href="README_tr_TR.md">Türkçe</a>
  <a href="README_zh_CN.md">中文</a>
  <a href="README_ru_RU.md">Русский</a>
  <a href="README_pt_BR.md">Português Brasileiro</a>
  <a href="README_ar_JO.md">العربية</a>
  <a href="README_th_TH.md">ภาษาไทย</a>
</p>

## Ansvarsfriskrivning

- ⚠️ Projektet är under **mycket aktiv** utveckling.
- ⚠️ Förvänta dig buggar och brytande förändringar.
- ⚠️ **Använd inte appen som enda lagringssätt för dina foton och videor.**
- ⚠️ Tillämpa alltid [3-2-1](https://www.backblaze.com/blog/the-3-2-1-backup-strategy/)-strategin för säkerhetskopiering av dina foton och videor!

## Innehåll

- [Officiell Dokumentation](https://immich.app/docs)
- [Roadmap](https://github.com/orgs/immich-app/projects/1)
- [Demo](#demo)
- [Funktioner](#features)
- [Introduktion](https://immich.app/docs/overview/introduction)
- [Installation](https://immich.app/docs/install/requirements)
- [Riktlinjer för Bidrag](https://immich.app/docs/overview/support-the-project)

## Dokumentation

Dokumentation och installationsguider hittas på https://imiich.app/.

## Demo

Ett webb-demo finns att testa på https://demo.immich.app

Använd `https://demo.immich.app/api` i mobilappen som `Server Endpoint URL`

```bash title="Inloggningsuppgifter För Demo"
Inloggsningsuppgifter
epost: demo@immich.app
lösenord: demo
```

```
Spec: Free-tier Oracle VM - Amsterdam - 2.4Ghz quad-core ARM64 CPU, 24GB RAM
```

## Aktiviteter

![Activities](https://repobeats.axiom.co/api/embed/9e86d9dc3ddd137161f2f6d2e758d7863b1789cb.svg "Repobeats analytics image")

## Funktioner


| Funktioner                                                  | Mobil | Webb |
| :-----------------------------------------------------------| ----- | ---- |
| Ladda upp och visa videor och foton                         | Ja    | Ja   |
| Automatisk säkerhetskopiering när appen öppnas              | Ja    | N/A  |
| Förhindra duplicering av resurser                           | Ja    | Ja   |
| Valbara album för säkerhetskopiering                        | Ja    | N/A  |
| Ladda ner foton och videor lokalt till en enhet             | Ja    | Ja   |
| Stöd för flera användare                                    | Ja    | Ja   |
| Album and Delade album                                      | Ja    | Ja   |
| Rullningslist                                               | Ja    | Ja   |
| Stöd för råformat                                           | Ja    | Ja   |
| Visning av metadata (EXIF, karta)                           | Ja    | Ja   |
| Sök via metadata, objekt, ansikten och CLIP                 | Ja    | Ja   |
| Administrative functions (user management)                  | Nej   | Ja   |
| Administrativa funktioner (hantering av användare)          | Nej   | Ja   |
| Säkerhetskopiering i bakgrunden                             | Ja    | N/A  |
| Virtuell skroll                                             | Ja    | Ja   |
| Stöd för OAuth                                              | Ja    | Ja   |
| API-nycklar                                                 | N/A   | Ja   |
| Säkerhetskopiering och uppspelning av LivePhoto/MotionPhoto | Ja    | Ja   |
| Stöd för visning av 360-graders bilder                      | Nej   | Ja   |
| Användardefinierad lagringsstruktur                         | Ja    | Ja   |
| Publik Delning                                              | Nej   | Ja   |
| Arkiv och Favoriter                                         | Ja    | Ja   |
| Världskarta                                                 | Ja    | Ja   |
| Dela med Partner                                            | Ja    | Ja   |
| Ansiktsigenkänning och klustring                            | Ja    | Ja   |
| Minnen (x år sedan)                                         | Ja    | Ja   |
| Offline-stöd                                                | Ja    | Nej  |
| Skrivskyddat galleri                                        | Ja    | Ja   |
| Bildstapling                                                | Ja    | Ja   |

## Medverkande

<a href="https://github.com/alextran1502/immich/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=immich-app/immich" width="100%"/>
</a>

## Stjärn-Historik

<a href="https://star-history.com/#immich-app/immich&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=immich-app/immich&type=Date" width="100%" />
 </picture>
</a>
