# Enlite Starter - React Admin Dashboard Template For Full-Stack Developer
----------
Enlite Starter - React Dashboard Starter Template with Firebase Auth http://enlite.ux-maestro.com

### Read documentation here
https://ilhammeidi.github.io/enlite-docs/#firebase

### Template Feature
-   Modern Technologies. Built with one of most popular javascript library React.JS and Redux
-   Premium designs. Simple and elegant theme color along with dark and lightmode
-   Multiple layout and RTL Support. Sidebar and Topbar navigation layout. Auto RTL adjustment styling with jss-rtl
-   Authentication. Use Firebase social and email login
-   Pre-build apps. Sample CRUD app with Redux-Saga and Realtime DB integration.
-   Support multilanguage. Including 6 translation English, Deutsch, Arabic, Chinese, Bahasa Indonesia, Español.
-   30+ react components and modules which reusable and easy to modify.
-   Various sample pages Landing page, 2 Dashboards variant, and many more
-   Next Generation JavaScript written in ES6
-   Responsive design Based on standard 12 Grid System
-   Starter Project. Build app from scratch without without being distracted from innate feature.
-   Test Unit. Material UI Components functional test with Mocha and Chai
-   High Performance. Styling with JSS (CSS in JS) and Async Code Splitting.
-   Clean code maintained by eslint.
-   Fully vector icons and font icons.
-   Direct code preview. Get source code easier without open files.
-   And many more…

# Get Prime Version
![enlite prime](https://cdn.dribbble.com/users/1866020/screenshots/6824785/enlite_4x.jpg)

[GET IT NOW on Envato Market](https://themeforest.net/item/enlite-prime-reactjs-fullstack-website-template/23803960)

[SEE DEMO](http://enlite.ux-maestro.com)

### Installation

 - Clone this project
 - Install module dependencies by run this script in terminal
    `npm install`
 - After finish downloading, then build Build Webpack DLL dependencies(If necessary).
	 `npm run build:dll`
 - Finally run the app.
	 `npm start`
 - Navigate to  [http://localhost:3001](http://localhost:3001)

### Deployment

 - First you need to build the production assets first
    `npm run build`
 - Then start the app
    `npm run start:prod`
 - If you want run it in background you may try PM2 [https://www.npmjs.com/package/pm2]( https://www.npmjs.com/package/pm2) Then run this command:
    `node node_modules/.bin/cross-env NODE_ENV=production pm2 start server`
 - Navigate to  [http://localhost:3001](http://localhost:3001)

### Enable Direct Code Preview
To make documenation easy and effective to access and implement, we attached source code in every component demos. We call it Direct Code Preview. This feature can be used in purchased product only (not available in demo).

 - Open config file  `/app/config/codePreview.js`
 - By default set by false
 - Change to  `enable: true`, to enabled direct code preview
 -   Test with any component demo, example in  [http://localhost:8080/app/tables/advanced-table](http://localhost:8080/app/tables/advanced-table).
-   Then at the bottom of every components you will see  **<> Show Code**  Button. Just click it.
-   The source code of that components will show as well.
-   You can see through, copy and paste directly any component in front of your eyes.

### License
This project is licensed under the terms of the [MIT license](https://github.com/ilhammeidi/boss-lite/blob/master/LICENSE.txt).