﻿define(function(require, exports, module) {
	"use strict";

	if (typeof jQuery == 'undefined') { return; }

	require('jq_hoverIntent');

	var _common = {

		/* 域名搜索 */
		domain_search : function() {
			var _factory = {
				init_form : function() {
					var __this = this;
					var diyDomainDef = '';
					var searchbox = $(".searchForm"),
						optchange = searchbox.find('#domainSel'),
						domain_group = $(".domainSearch hgroup a"),
						suffix = $(".domainSelBox p");

					optchange.hoverIntent(
						function() {
							$(this).find('dl').show();
							$(this).find('.defSel i[class*=fa]').removeClass('fa-caret-down').addClass('fa-caret-up');
							$(this).addClass('hover');
						},
						function() {
							$(this).find('dl').hide();
							$(this).find('.defSel i[class*=fa]').removeClass('fa-caret-up').addClass('fa-caret-down');
							$(this).removeClass('hover');
						}
					).find('dl > dd').hover(
						function() {
							$(this).addClass('current');
						},
						function() {
							$(this).removeClass('current');
						}
					).click(function() {
						optchange.find('.defSel span').html($(this).attr('relValue').Trim());
						optchange.removeClass('hover').find('dl').hide();

						$('#domainType').val($(this).attr('relValue'));
						if ($(this).attr('relValue') == '多选'){
							$('.domainModeBox').css('display','');
							$('.domainSelBox').css('display','');
						}else{
							$('.domainModeBox').css('display','none');
							$('.domainSelBox').css('display','none');
						}
						if ($(this).attr('relValue') == '自定义'){
							diyDomainDef = $('#defaultKey').html();
							$('#defaultKey').html('请输入您想要注册的自定义域名（含域名后缀），如：xxxxx.com');
							//$('#domainCont').attr('placeholder','请输入您想要注册的自定义域名（含后缀），如：idccms.com');
						}else{
							if (diyDomainDef.length > 3){
								$('#defaultKey').html(diyDomainDef);
								//$('#domainCont').attr('placeholder',diyDomainDef);
							}
						}

						if (!$.trim($("#domainCont").val())) {
							searchbox.find('#defaultKey').show();
							$("#domainCont").val('');
						}
					}).first().click();

					//域名分类点击
					domain_group.each(function(val){
                        $(this).click(function(){
							domain_group.removeClass('active');
							suffix.hide();
							// searchbox.find('ul').hide();
							domain_group.eq(val).addClass('active');
							$('.'+$(this).attr('data-input')).show().find('#domainCont').attr('placeholder',$(this).attr('data-placeholder'));	//搜索框显示
							$('#'+$(this).attr('data-suffix')).show();			// 后缀显示
							if ($(this).attr('data-suffix') == 'regDomain'){
								$('.searchForm').css('display','none');
							}else{
								$('.searchForm').css('display','');
							}
							if(val==1){
								optchange.find('span').html(optchange.find('dd').eq(1).attr('data-text'));// 修改搜索框右侧下拉菜单的默认
								$('#defaultKey').html(optchange.find('dd').eq(1).attr('data-defaultkey'));// 修改搜索框默认值
								$('#domainSearBtn').attr('data-checkname','chsuffix');
							}else if(val==0){
								optchange.find('span').html(optchange.find('dd').eq(0).attr('data-text'));// 修改搜索框右侧下拉菜单的默认值
								$('#defaultKey').html(optchange.find('dd').eq(1).attr('data-defaultkey'));// 修改搜索框默认值
								$('#domainSearBtn').attr('data-checkname','ensuffix');
							}
							//$("#hotDomain label").tooltip();
                            $("#domainMode").val(val);
						});
                    });

					searchbox.find("#domainCont").focus(function() {
						searchbox.find('#defaultKey').hide();
					}).blur(function() {
						if (!$.trim($(this).val())) {
							searchbox.find('#defaultKey').show();
							$(this).val('');
						}
					});

					$(".domainSelBox").iCheck({
						checkboxClass: 'icheckbox_blue',
						radioClass: 'iradio_blue',
						increaseArea: '20%'
					});

					// 域名后缀全选项
					$('#domainAll').on('ifChecked', function(event){
						$('#hotDomain input').iCheck('check');
					});
					$('#domainAll').on('ifUnchecked', function(event){
						$('#hotDomain input').iCheck('uncheck');
					});

					// 域名搜索表单提交按钮
/*					$("#domainSearBtn").bind("click", function(e) {
						e.stopPropagation();
						// alert($("#domainType").val());
						if ($("#domainCont").val() == '') { alert('请先输入要注册的域名。');$("#domainCont").focus();return false; }
						if ($("#domainType").val() == '自定义'){
							var re=new RegExp("^[a-zA-Z0-9\-\.]+$");
							if (! re.test($("#domainCont").val())){
								alert('自定义域名只允许数字字母点符号和-连接符');$("#domainCont").focus();return false;
							}

						}else{
							var re=new RegExp("^[a-zA-Z0-9\-]+$");
							if (! re.test($("#domainCont").val())){
								alert('域名只允许数字字母和-');$("#domainCont").focus();return false;
							}

						}
						$("#searForm").submit();
						return;
					});*/
				}

			};
			return _factory;
		}()

	};

	module.exports =  {
		common : _common || {},
	};

});

function CheckDomainSearchForm(){
	if ($("#domainCont").val() == '') { alert('请先输入要注册的域名。');$("#domainCont").focus();return false; }
	if ($("#domainType").val() == '自定义'){
		var re=new RegExp("^[a-zA-Z0-9\-\.]+$");
		if (! re.test($("#domainCont").val())){
			alert('自定义域名只允许数字字母点符号和-连接符');$("#domainCont").focus();return false;
		}

	}else{
		var re=new RegExp("^[a-zA-Z0-9\-]+$");
		if (! re.test($("#domainCont").val())){
			alert('域名只允许数字字母和-');$("#domainCont").focus();return false;
		}

	}
	return true;
}

function CheckMoreRegForm(){
	if ($("#domainList").val() == '') { alert('请先输入要批量注册的域名。');$("#domainList").focus();return false; }
	$("#domainCont").val('otcms');
	$("#searForm").attr('action','domainReg.php');
	$("#searForm").submit();
	return true;
}