<?php
header('Content-Type: text/html; charset=UTF-8');

define('OT_ROOT', dirname(__FILE__) .'/');
if (! in_array(trim(''. @$_GET['m']), array('softInfo'))){
	define('OT_Charset',	'utf-8');
}


// 自动加载类文件
if (version_compare(PHP_VERSION, '5.3.0', '>=')) {
	spl_autoload_register('OTautoload', true, true);
}else{
	spl_autoload_register('OTautoload');
}

function OTautoload($className){
	$judStrrev = false;
	if ( in_array(substr($className,0,3),array('App','Api')) ){
		$judStrrev = true;
		$classPath = OT_ROOT .'plugin/class'. $className .'.php';

	}else{
		$classPath = OT_ROOT .'inc/class'. $className .'.php';
	}
	if (file_exists($classPath)){
		include_once($classPath);
	}else{
		if ($judStrrev){
			$classPath = OT_ROOT .'pluDef/class'. $className .'.php';
		}else{
			$classPath = OT_ROOT .'inc/class'. $className .'.php';
		}
		if (file_exists($classPath)){
			include_once($classPath);
		}else{
			echo('类路径错误或不存在.'. $classPath .'或'. OT_ROOT .'inc/class'. $className .'.php');
		}
	}
}


$m = OT::GetStr2( OT::ParaArr('mudi') );

switch ($m){
	case 'getKeyWord':
		// 获取文章关键词
		KeyWord::GetDeal();
		break;

	case 'getUrlencode':
		// 字符串url编码化
		echo(urlencode(OT::GetStr('str')));
		break;

	case 'getGeetest':
		// 获取滑动验证码
		GetGeetest();
		break;

	case 'pinyin':
		// 获取中文拼音化
		PinYin::GetDeal();
		break;

	case 'encPwd':
		// 加密密码
		Encrypt::GetDeal();
		break;

	case 'getCityData':
		// 获取省份城市信息
		ProvCity::GetDeal();
		break;

	case 'goWapUrl':
		// 跳转wap手机版
		AreaApp::GoWapUrl();
		break;

	case 'outUrl':
		// 外部网址温馨提醒页
		Area::OutUrl('pc');
		break;

	case 'qrcode':
		// 显示二维码图
		Area::MakeQRcode();
		break;

	case 'softInfo':
		// 网站信息
		SoftInfo();
		break;

	case 'panelLogin':
		IdcArea::PanelLoginDecode();
		break;

	default :
		die('[该访问地址存在]');
		// die('err');
}



// 获取验证码结果
function GetGeetest(){
	$geetest = new Geetest();
	$geetest->ShowRes('web');
}


function SoftInfo(){
	require(OT_ROOT .'config.php');
	require(OT_ROOT .'configVer.php');

	$systemArr = Cache::PhpFile('system');
	$sysAdminArr = Cache::PhpFile('sysAdmin');

	$rndStr = trim(''. @$_GET['rndStr']);
		if (strlen($rndStr) != 32){ die('校验码应为32位.'); }

	$retArr = ReqUrl::UseAuto($sysAdminArr['SA_getUrlMode'],'GET',ReqUrl::SelUpdateUrl($sysAdminArr['SA_updateUrlMode']) .'otcmsUserIp.php?OT_VERSION='. OT_VERSION .'&OT_UPDATETIME='. OT_UPDATETIME .'&dataVer='. OT_UPDATEVER .'&softID='. $sysAdminArr['SA_softID'] .'&softCode='. $sysAdminArr['SA_softCode'] .'&dbVersion='. $sysAdminArr['SA_dbVersion'] .'&dbTimeStr='. $sysAdminArr['SA_dbTimeStr'] .'&softUrl='. urlencode($_SERVER['HTTP_HOST']) .'&rndStr='. $rndStr .'&rnd='. time());
	if (! $retArr['res']){
		die($retArr['note']);
	}else{
		if (strpos($retArr['note'],$rndStr) === false){
			die('校验码错误（'. $rndStr .'）【'. $retArr['note'] .'】.');
		}
	}

	echo('[网站名称]'. $systemArr['SYS_title'] .''. $retArr['note']);

}

?>