<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class AppVpsApiDeal{
	public static $appName = 'IDC云服务器模块_处理';

	// 云服务器 开通处理
	public static function Kaitong(){
		global $DB,$UE_ID,$userRow;

		@ini_set('max_execution_time', 0);
		@set_time_limit(0);

		$backURL	= OT::PostStr('backURL');
		$dataID		= OT::PostInt('dataID');
		$comServID	= OT::PostInt('comServID');
		$vpsPwd		= OT::PostStr('vpsPwd');
		$system		= OT::PostStr('system');
		$payMode	= OT::PostStr('payMode');
		$userPrice	= OT::PostFloat('userPrice');
		$userNote	= OT::PostStr('userNote');
			if ($dataID <= 0){ JS::AlertBackEnd('该记录ID错误.'); }
			if ($userPrice == 0){ JS::AlertBackEnd('扣款金额不能为0。'); }

		$todayTime = TimeDate::Get();
		$endTime = IdcArea::NewEndTime($payMode, $todayTime);
		$userID = $UE_ID;
		$username = $userRow['UE_username'];
		$backURL = 'usersCenter.php?mudi=vpsManage';

		$vpsSysArr = Cache::PhpFile('vpsSys');
		if (strpos($vpsSysArr['VS_funcStr'],'|vpsApiKaitong|') === false){
			JS::AlertBackEnd('开通功能已被关闭，如有开通需求请联系管理员。');
		}

		// 判断开通试用机器是否超过限额
		IdcArea::CheckVpsState3Num('vpsApi', $userID, $vpsSysArr['VS_vpsApiState3Num']);

		$proexe = $DB->query('select VAD_typeID,VAD_theme,VAD_companyID,VAD_apiID,VAD_useMenuStr,VAD_useTimeStr,VAD_priceDay,VAD_priceWeek,VAD_priceMonth,VAD_price3Month,VAD_price6Month,VAD_priceYear,VAD_price2Year,VAD_price3Year,VAD_price4Year,VAD_price5Year,VAD_costDay,VAD_costWeek,VAD_costMonth,VAD_cost3Month,VAD_cost6Month,VAD_costYear,VAD_cost2Year,VAD_cost3Year,VAD_cost4Year,VAD_cost5Year,VAD_minPrice from '. OT_dbPref .'vpsApiData where VAD_ID='. $dataID);
			if (! $rs = $proexe->fetch()){ JS::AlertBackEnd('搜索不到该记录所属的产品相关信息'); }

		if (strpos($rs['VAD_useMenuStr'],'|noKaitong|') !== false){
			JS::AlertBackEnd('该款机器（'. $rs['VAD_theme'] .'）要直接联系网站客服进行开通。');
		}

		$price = IdcInfo::VpsPayPrice($payMode, $rs, 'VAD_');
		$cost = IdcInfo::VpsPayCost($payMode, $rs, 'VAD_');
		if ($price <= 0 || $price == 99999 || $cost <= 0){
			switch ($payMode){
				case '24hour':
					if (strpos($rs['VAD_useTimeStr'],'|24hour|') === false){ JS::AlertBackEnd('该机器没开放 试用24小时'); }
					$price = floatval($rs['VAD_priceMonth']);	$cost = floatval($rs['VAD_costMonth']);	break;
					// $price = 0;	$cost = 0; break;
				case '48hour':
					if (strpos($rs['VAD_useTimeStr'],'|48hour|') === false){ JS::AlertBackEnd('该机器没开放 试用48小时'); }
					$price = floatval($rs['VAD_priceYear']);	$cost = floatval($rs['VAD_costYear']);	break;
					// $price = 0;	$cost = 0; break;
				case 'day':		$price = floatval($rs['VAD_priceDay']);		$cost = floatval($rs['VAD_costDay']);	break;
				case 'week':	$price = floatval($rs['VAD_priceWeek']);	$cost = floatval($rs['VAD_costWeek']);	break;
				default :		JS::AlertBackEnd('付款方式选择有问题.');	break;
			}
		}

		$priceStr = '价格：'. $userPrice .'元';
		$agentErrStr = 'group'. $userRow['UE_groupID'] .'；proid'. $dataID .'；minPrice'. $rs['VAD_minPrice'] .'';
		if ($userRow['UE_groupID'] > 0){
			// 走代理折扣价
			$agentArr = AppAgent::CheckPrice('vpsApi', $dataID, $userRow['UE_groupID'], $rs['VAD_minPrice']);
			if ($agentArr['isAgent'] == 1){
				$agentPrice = IdcInfo::VpsAgentPrice($payMode, $agentArr['agentPrice']);
				if ($agentPrice != 99999){
					$priceStr = $agentArr['agentName'] .'价：'. $agentPrice .'元，原价：'. $price .'元';
					$price = $agentPrice;
				}
			}
			$agentErrStr .= '；is'. $agentArr['isAgent'] .'；name'. $agentArr['agentName'] .'；price'. $agentArr['agentPrice'] .'';
		}

		if (OT::FloatCmp($userPrice, $price) != 0){
			JS::AlertBackEnd('开通价格（'. $userPrice .'元）与系统计算价格（'. $price .'元）不匹配（错误参考信息：'. $agentErrStr .'）.');
		}

		$urs = $DB->GetRow('select UE_recomId,UE_recomUser,UE_money,UE_weixinID from '. OT_dbPref .'users where UE_ID='. $userID);
		$recomId		= $urs['UE_recomId'];
		$recomUser		= $urs['UE_recomUser'];
		$userMoney		= floatval($urs['UE_money']);
		$UE_weixinID	= $urs['UE_weixinID'];
		unset($urs);

		if ( OT::FloatCmp($userMoney, $userPrice) < 0 ){
			JS::AlertBackEnd('用户余额'. $userMoney .'元，扣款'. $userPrice .'元，余额不足，没法扣款。');
		}

		$result = $DB->UpdateParam('users',array('UE_money'=>'UE_money-'. $userPrice,'UE_payMoney'=>'UE_payMoney+'. $userPrice),'UE_ID='. $userID);
			if (! $result){
				JS::AlertBackEnd('用户余额扣款失败，请刷新页面重试下。');
			}

		$classID = $DB->GetOne('select VT_classID from '. OT_dbPref .'vpsType where VT_ID='. $rs['VAD_typeID']);
		$proDataID = $dataID;
		$proDataName = $rs['VAD_theme'];

		$vpsNameArr = IdcArea::GetNewVpsName('vpsApi',$classID);
		$VC_useNum = $vpsNameArr['useNum'];
		$vpsName = $vpsNameArr['vpsName'];

		$alertStr = '\n用户金额 '. $userMoney .' 元，扣款 '. $userPrice .' 元，剩余 '. OT::NumFormat($userMoney - $userPrice) .' 元';

		$record=array();
		$record['VAU_time']			= $todayTime;
		$record['VAU_endTime']		= $endTime;
		$record['VAU_adminID']		= 0;
		$record['VAU_adminName']	= '';
		$record['VAU_apiID']		= $rs['VAD_apiID'];
		$record['VAU_companyID']	= $rs['VAD_companyID'];
		$record['VAU_proDataID']	= $proDataID;
		$record['VAU_proDataName']	= $proDataName;
		$record['VAU_userID']		= $userID;
		$record['VAU_username']		= $username;
		$record['VAU_comServID']	= $comServID;
		$record['VAU_vpsName']		= $vpsName;
		$record['VAU_vpsPwd']		= Encrypt::SyEnDe('en',$vpsPwd);
		$record['VAU_system']		= $system;
		$record['VAU_payMode']		= $payMode;
		$record['VAU_price']		= $price;
		$record['VAU_cost']			= $cost;
		$record['VAU_userNote']		= $userNote;
		$record['VAU_note']			= '';
		$record['VAU_isUserPay']	= 1;
		$record['VAU_adminNote']	= '';
		if ($rs['VAD_apiID'] > 0){
			$record['VAU_type']			= 'api';
			$record['VAU_state']		= 3;
		}else{
			$record['VAU_type']			= 'pro';
			$record['VAU_state']		= 5;
			$record['VAU_vpsEndTime']	= $endTime;
		}

		$result = $DB->InsertParam('vpsApiUsers', $record);
		if ($result){
			$alertRes='成功';
			if ($VC_useNum > 0){ $DB->UpdateParam('vpsClass',array('VC_useNum'=>$VC_useNum),'VC_ID='. $classID); }
			$DB->UpdateParam('users',array('UE_vpsApiNum'=>'UE_vpsApiNum+1'),'UE_ID='. $userID);

			$dataID = $DB->GetOne('select max(VAU_ID) from '. OT_dbPref .'vpsApiUsers where VAU_userID='. $userID);
			if ($rs['VAD_apiID'] > 0){
				$retArr = AppIdcVps::Kaitong($dataID);
				if (! $retArr['res']){
					if (strpos($vpsSysArr['VS_failMoneyStr'],'|vpsApiReg|') !== false){
						$DB->UpdateParam('users',array('UE_money'=>'UE_money+'. $userPrice,'UE_payMoney'=>'UE_payMoney-'. $userPrice),'UE_ID='. $userID);
						$MR_money = 0;
						$MR_remMoney = -9;
						$noteStr = '，不扣款';
					}else{
						$MR_money = $userPrice*(-1);
						$MR_remMoney = $userMoney - $userPrice;
						$noteStr = '，已扣款，请联系管理员处理';
					}
					$scoreArr = array();
					$scoreArr['MR_userID']		= $userID;
					$scoreArr['MR_username']	= $username;
					$scoreArr['MR_dataID']		= $dataID;
					$scoreArr['MR_dataName']	= $vpsName;
					$scoreArr['MR_type']		= 'vpsApi';
					$scoreArr['MR_type2']		= '开通';
					$scoreArr['MR_money']		= $MR_money;
					$scoreArr['MR_remMoney']	= $MR_remMoney;
					$scoreArr['MR_note']		= '开通失败'. $noteStr .'！产品：'. $proDataName .'；机器编码：'. $vpsName .'；使用期限：'. IdcInfo::PayTime($payMode) .'；'. $priceStr .'；';
					AppMoneyRecord::AddData($scoreArr);

					AreaApp::MessageSend('kaitongVps0', '『失败』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”开通失败'. $noteStr .'。【'. TimeDate::Get() .'】');

					JS::AlertBackEnd('开通失败，请联系管理员给你处理！'. $retArr['note']);

				}elseif (isset($retArr['state']) && $retArr['state']==3){
					$alertRes=$retArr['note'];
					$userGain = $userPrice - $cost;
					if ($userGain < 0){ $userGain = 0; }
					$scoreArr = array();
					$scoreArr['MR_userID']		= $userID;
					$scoreArr['MR_username']	= $username;
					$scoreArr['MR_dataID']		= $dataID;
					$scoreArr['MR_dataName']	= $vpsName;
					$scoreArr['MR_type']		= 'vpsApi';
					$scoreArr['MR_type2']		= '试用';
					$scoreArr['MR_money']		= $userPrice*(-1);
					$scoreArr['MR_remMoney']	= $userMoney - $userPrice;
					$scoreArr['MR_cost']		= $cost;
					$scoreArr['MR_gain']		= $userGain;
					$scoreArr['MR_bank']		= '账户余额';
					$scoreArr['MR_note']		= '申请试用成功，请联系管理员开通试用！产品：'. $proDataName .'；机器编码：'. $vpsName .'；使用期限：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；'. $priceStr .'；';
					$mrRes = AppMoneyRecord::AddData($scoreArr);
						if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }

					AreaApp::MessageSend('kaitongVps0', '『试用』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”申请试用，请管理员开通试用。【'. TimeDate::Get() .'】');

				}else{
					$userGain = $userPrice - $cost;
					if ($userGain < 0){ $userGain = 0; }
					$scoreArr = array();
					$scoreArr['MR_userID']		= $userID;
					$scoreArr['MR_username']	= $username;
					$scoreArr['MR_dataID']		= $dataID;
					$scoreArr['MR_dataName']	= $vpsName;
					$scoreArr['MR_type']		= 'vpsApi';
					$scoreArr['MR_type2']		= '开通';
					$scoreArr['MR_money']		= $userPrice*(-1);
					$scoreArr['MR_remMoney']	= $userMoney - $userPrice;
					$scoreArr['MR_cost']		= $cost;
					$scoreArr['MR_gain']		= $userGain;
					$scoreArr['MR_bank']		= '账户余额';
					$scoreArr['MR_note']		= '开通成功！产品：'. $proDataName .'；机器编码：'. $vpsName .'；使用期限：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；'. $priceStr .'；';
					$mrRes = AppMoneyRecord::AddData($scoreArr);
						if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }

					AreaApp::MessageSend('kaitongVps1', '会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”开通成功。【'. TimeDate::Get() .'】');

					// 如有推荐人，推荐人推广佣金处理
					if ($recomId > 0 && strpos($vpsSysArr['VS_commArea'],'|vpsApiKai|') !== false){
						$urs = $DB->GetRow('select UE_makeMoney,UE_makingMoney from '. OT_dbPref .'users where UE_ID='. $recomId);
						$makeMoney	= floatval($urs['UE_makeMoney']);
						$makingMoney= floatval($urs['UE_makingMoney']);
						unset($urs);

						$proPrice	= abs($userPrice);
						$money = $proPrice * $vpsSysArr['VS_vpsApiKaiRate'];
						if ($money > $vpsSysArr['VS_vpsApiKaiMax']){ $money = $vpsSysArr['VS_vpsApiKaiMax']; }
						$proArr = array(
							'GI_source'			=> '前台',
							'GI_userID'			=> $recomId,
							'GI_username'		=> $recomUser,
							'GI_proUserID'		=> $userID,
							'GI_proUsername'	=> $username,
							'GI_proType'		=> 'vpsApi',
							'GI_proID'			=> $dataID,
							'GI_proName'		=> $proDataName,
							'GI_proPrice'		=> $proPrice,
							'GI_vpsName'		=> $vpsName,
							'GI_endTime'		=> $endTime,
							'GI_mode'			=> '开通',
							'GI_rate'			=> $vpsSysArr['VS_vpsApiKaiRate'],
							'GI_money'			=> $money,
							);
						$listArr = array(
							'GH_makingMoney'	=> $makingMoney + $money,
							'GH_makeMoney'		=> $makeMoney,
							);
						AppGain::AddItemData($proArr, $listArr);
					}
				}
			}else{
				$recordArr = array();
				$recordArr['TX_time']		= TimeDate::Get();
				$recordArr['TX_type']		= 'vpsApi';
				$recordArr['TX_type2']		= '开通';
				$recordArr['TX_dataID']		= $dataID;
				$recordArr['TX_dataName']	= $proDataName;
				$recordArr['TX_vpsName']	= $vpsName;
				$recordArr['TX_ipStr']		= '';
				$recordArr['TX_userID']		= $UE_ID;
				$recordArr['TX_username']	= $username;
				$recordArr['TX_payMode']	= $payMode;
				$recordArr['TX_price']		= $userPrice;
				$recordArr['TX_cost']		= $cost;
				$recordArr['TX_startTime']	= $todayTime;
				$recordArr['TX_endTime']	= $endTime;
				$recordArr['TX_state']		= 0;
				$mrRes = $DB->InsertParam('tixing', $recordArr);
					if (! $mrRes){ $alertStr .= '\n提醒信息记录失败！'; }

				$scoreArr = array();
				$scoreArr['MR_userID']		= $userID;
				$scoreArr['MR_username']	= $username;
				$scoreArr['MR_dataID']		= $dataID;
				$scoreArr['MR_dataName']	= $vpsName;
				$scoreArr['MR_type']		= 'vpsApi';
				$scoreArr['MR_type2']		= '开通';
				$scoreArr['MR_money']		= $userPrice*(-1);
				$scoreArr['MR_remMoney']	= $userMoney - $userPrice;
				$scoreArr['MR_bank']		= '账户余额';
				$scoreArr['MR_note']		= '开通审核中！产品：'. $proDataName .'；机器编码：'. $vpsName .'；使用期限：'. IdcInfo::PayTime($payMode) .'；'. $priceStr .'；';
				$scoreArr['MR_adminID']		= 0;
				$scoreArr['MR_adminName']	= '';
				$mrRes = AppMoneyRecord::AddData($scoreArr);
					if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }

				AreaApp::MessageSend('kaitongVps9', '『审核』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”提交开通申请，请管理员审核开通。【'. TimeDate::Get() .'】');
			}
		}else{
			$alertRes='失败';
		}

		if ($rs['VAD_apiID'] > 0){
			JS::AlertHref('开通'. $alertRes .'！'. $alertStr,$backURL);
		}else{
			JS::AlertHref('开通'. $alertRes .'！当前状态开通中，请耐心等待管理员审核通过即可完成开通。'. $alertStr,$backURL);
		}
	}



	// 云服务器 续费处理
	public static function Xufei(){
		global $DB,$UE_ID,$userRow;

		@ini_set('max_execution_time', 0);
		@set_time_limit(0); 

		$backURL	= OT::PostStr('backURL');
		$dataID		= OT::PostInt('dataID');
		$payMode	= OT::PostStr('payMode');
		$userPrice	= OT::PostFloat('userPrice');
			if ($dataID <= 0){ JS::AlertBackEnd('该记录ID错误.'); }
			if ($userPrice == 0){ JS::AlertBackEnd('扣款金额不能为0。'); }

		$dataexe = $DB->query('select VAU_userID,VAU_username,VAU_endTime,VAU_xufeiNum,VAU_proDataID,VAU_proDataName,VAU_ipStr,VAU_vpsName,VAU_isNewPrice,VAU_priceMonth,VAU_price3Month,VAU_price6Month,VAU_priceYear,VAU_costMonth,VAU_cost3Month,VAU_cost6Month,VAU_costYear,VAU_useMenuStr from '. OT_dbPref .'vpsApiUsers where VAU_ID='. $dataID .' and VAU_userID='. $UE_ID);
			if (! $row = $dataexe->fetch()){ JS::AlertBackEnd('该记录不存在。'); }
			if (strpos($row['VAU_useMenuStr'],'|noXufei|') !== false){
				JS::AlertBackEnd('您的这款机器要直接联系网站客服进行续费。');
			}
		$endTime		= $row['VAU_endTime'];
		$xufeiNum		= $row['VAU_xufeiNum'];
		$userID			= $row['VAU_userID'];
		$username		= $row['VAU_username'];
		$proDataName	= $row['VAU_proDataName'];
		$ipStr			= $row['VAU_ipStr'];
		$vpsName		= $row['VAU_vpsName'];

		if (! strtotime($endTime)){
			JS::AlertBackEnd('到期时间获取异常（'. $endTime .'），请刷新页面后重新操作下。');
		}

		$vpsSysArr = Cache::PhpFile('vpsSys');
		if (strpos($vpsSysArr['VS_funcStr'],'|vpsApiXufei|') === false){
			JS::AlertBackEnd('续费功能已被关闭，如有续费需求请联系管理员。');
		}

		$oldEndTime = $endTime;		// apiID=0机器用到
		$endTime = IdcArea::NewEndTime($payMode, $endTime);

		$proexe = $DB->query('select VAD_apiID,VAD_theme,VAD_useMenuStr,VAD_priceMonth,VAD_price3Month,VAD_price6Month,VAD_priceYear,VAD_price2Year,VAD_price3Year,VAD_costMonth,VAD_cost3Month,VAD_cost6Month,VAD_costYear,VAD_cost2Year,VAD_cost3Year,VAD_minPrice from '. OT_dbPref .'vpsApiData where VAD_ID='. $row['VAU_proDataID']);
			if (! $rs = $proexe->fetch()){ JS::AlertBackEnd('搜索不到该记录所属的产品相关信息'); }

			if (strpos($rs['VAD_useMenuStr'],'|noXufei|') !== false){
				JS::AlertBackEnd('该款机器（'. $rs['VAD_theme'] .'）要直接联系网站客服进行续费。');
			}

		if ($row['VAU_isNewPrice'] == 1){
			$price = IdcInfo::VpsPayPrice($payMode, $row, 'VAU_');
			$cost = IdcInfo::VpsPayCost($payMode, $row, 'VAU_');
			if ($price <= 0 || $price == 99999 || $cost <= 0){
				JS::AlertBackEnd('续费时间选择有问题.');
			}
			$priceStr = '独立价：'. $price .'元';

		}else{
			$price = IdcInfo::VpsPayPrice($payMode, $rs, 'VAD_');
			$cost = IdcInfo::VpsPayCost($payMode, $rs, 'VAD_');
			if ($price <= 0 || $price == 99999 || $cost <= 0){
				JS::AlertBackEnd('续费时间选择有问题.');
			}

			$priceStr = '价格：'. $userPrice .'元';
			if ($userRow['UE_groupID'] > 0){
				// 走代理折扣价
				$agentArr = AppAgent::CheckPrice('vpsApi', $row['VAU_proDataID'], $userRow['UE_groupID'], $rs['VAD_minPrice']);
				if ($agentArr['isAgent'] == 1){
					$agentPrice = IdcInfo::VpsAgentPrice($payMode, $agentArr['agentPrice']);
					if ($agentPrice != 99999){
						$priceStr = $agentArr['agentName'] .'价：'. $agentPrice .'元，原价：'. $price .'元';
						$price = $agentPrice;
					}
				}
			}
		}

		if (OT::FloatCmp($userPrice, $price) != 0){
			JS::AlertBackEnd('续费价格（'. $userPrice .'元）与系统计算价格（'. $price .'元）不匹配.');
		}

		$urs = $DB->GetRow('select UE_recomId,UE_recomUser,UE_money,UE_weixinID from '. OT_dbPref .'users where UE_ID='. $userID);
		$recomId		= $urs['UE_recomId'];
		$recomUser		= $urs['UE_recomUser'];
		$userMoney		= floatval($urs['UE_money']);
		$UE_weixinID	= $urs['UE_weixinID'];
		unset($urs);

		if ( OT::FloatCmp($userMoney, $userPrice) < 0 ){
			JS::AlertBackEnd('用户余额'. $userMoney .'元，扣款'. $userPrice .'元，余额不足，没法扣款。');
		}

		$result = $DB->UpdateParam('users',array('UE_money'=>'UE_money-'. $userPrice,'UE_payMoney'=>'UE_payMoney+'. $userPrice),'UE_ID='. $userID);
			if (! $result){
				JS::AlertBackEnd('用户余额扣款失败，请刷新页面重试下。');
			}

		$alertStr = '\n用户金额 '. $userMoney .' 元，扣款 '. $userPrice .' 元，剩余 '. OT::NumFormat($userMoney - $userPrice) .' 元';

		if ($rs['VAD_apiID'] > 0){
			$retArr = AppIdcVps::Xufei($payMode,$price,$cost,$endTime,$dataID);
			if (! $retArr['res']){
				if (strpos($vpsSysArr['VS_failMoneyStr'],'|vpsApiXufei|') !== false){
					$DB->UpdateParam('users',array('UE_money'=>'UE_money+'. $userPrice,'UE_payMoney'=>'UE_payMoney-'. $userPrice),'UE_ID='. $userID);
					$MR_money = 0;
					$MR_remMoney = -9;
					$noteStr = '，不扣款';
				}else{
					$MR_money = $userPrice*(-1);
					$MR_remMoney = $userMoney - $userPrice;
					$noteStr = '，已扣款，请联系管理员处理';
				}
				$scoreArr = array();
				$scoreArr['MR_userID']		= $userID;
				$scoreArr['MR_username']	= $username;
				$scoreArr['MR_dataID']		= $dataID;
				$scoreArr['MR_dataName']	= $vpsName;
				$scoreArr['MR_type']		= 'vpsApi';
				$scoreArr['MR_type2']		= '续费';
				$scoreArr['MR_money']		= $MR_money;
				$scoreArr['MR_remMoney']	= $MR_remMoney;
				$scoreArr['MR_note']		= '续费失败'. $noteStr .'！产品：'. $proDataName .'；机器编码：'. $vpsName .'；续费期限：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；'. $priceStr .'；';
				AppMoneyRecord::AddData($scoreArr);

				AreaApp::MessageSend('xufeiVps0', '『失败』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”续费失败'. $noteStr .'。【'. TimeDate::Get() .'】');

				JS::AlertBackEnd('续费失败，请联系管理员给你处理！'. $retArr['note']);
			}

			$userGain = $userPrice - $cost;
			if ($userGain < 0){ $userGain = 0; }
			$scoreArr = array();
			$scoreArr['MR_userID']		= $userID;
			$scoreArr['MR_username']	= $username;
			$scoreArr['MR_dataID']		= $dataID;
			$scoreArr['MR_dataName']	= $vpsName;
			$scoreArr['MR_type']		= 'vpsApi';
			$scoreArr['MR_type2']		= '续费';
			$scoreArr['MR_money']		= $userPrice*(-1);
			$scoreArr['MR_remMoney']	= $userMoney - $userPrice;
			$scoreArr['MR_cost']		= $cost;
			$scoreArr['MR_gain']		= $userGain;
			$scoreArr['MR_bank']		= '账户余额';
			$scoreArr['MR_note']		= '续费成功！产品：'. $proDataName .'；机器编码：'. $vpsName .'；续费期限：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；'. $priceStr .'；';
			$mrRes = AppMoneyRecord::AddData($scoreArr);
				if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }

			AreaApp::MessageSend('xufeiVps1', '会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”续费成功。【'. TimeDate::Get() .'】');

			// 如有推荐人，推荐人推广佣金处理
			if ($recomId > 0 && strpos($vpsSysArr['VS_commArea'],'|vpsApiXu|') !== false && $xufeiNum < $vpsSysArr['VS_vpsApiXuNum']){
				$urs = $DB->GetRow('select UE_makeMoney,UE_makingMoney from '. OT_dbPref .'users where UE_ID='. $recomId);
				$makeMoney	= floatval($urs['UE_makeMoney']);
				$makingMoney= floatval($urs['UE_makingMoney']);
				unset($urs);

				$proPrice	= abs($userPrice);
				$money = $proPrice * $vpsSysArr['VS_vpsApiXuRate'];
				if ($money > $vpsSysArr['VS_vpsApiXuMax']){ $money = $vpsSysArr['VS_vpsApiXuMax']; }
				$proArr = array(
					'GI_source'			=> '前台',
					'GI_userID'			=> $recomId,
					'GI_username'		=> $recomUser,
					'GI_proUserID'		=> $userID,
					'GI_proUsername'	=> $username,
					'GI_proType'		=> 'vpsApi',
					'GI_proID'			=> $dataID,
					'GI_proName'		=> $proDataName,
					'GI_proPrice'		=> $proPrice,
					'GI_vpsName'		=> $vpsName,
					'GI_endTime'		=> $endTime,
					'GI_mode'			=> '续费',
					'GI_rate'			=> $vpsSysArr['VS_vpsApiXuRate'],
					'GI_money'			=> $money,
					);
				$listArr = array(
					'GH_makingMoney'	=> $makingMoney + $money,
					'GH_makeMoney'		=> $makeMoney,
					);
				AppGain::AddItemData($proArr, $listArr);
			}
			JS::AlertHref('续费成功！'. $alertStr,$backURL);
		}else{
			$dataArr = array('VAU_state' => 15);	// 状态改为续费中
			$result = $DB->UpdateParam('vpsApiUsers', $dataArr, 'VAU_ID='. $dataID);
			if ($result){
				$alertRes='成功';
				$recordArr = array();
				$recordArr['TX_time']		= TimeDate::Get();
				$recordArr['TX_type']		= 'vpsApi';
				$recordArr['TX_type2']		= '续费';
				$recordArr['TX_dataID']		= $dataID;
				$recordArr['TX_dataName']	= $proDataName;
				$recordArr['TX_vpsName']	= $vpsName;
				$recordArr['TX_ipStr']		= $ipStr;
				$recordArr['TX_userID']		= $UE_ID;
				$recordArr['TX_username']	= $userRow['UE_username'];
				$recordArr['TX_payMode']	= $payMode;
				$recordArr['TX_price']		= $userPrice;
				$recordArr['TX_cost']		= $cost;
				$recordArr['TX_startTime']	= $oldEndTime;
				$recordArr['TX_endTime']	= $endTime;
				$recordArr['TX_state']		= 0;
				$mrRes = $DB->InsertParam('tixing', $recordArr);
					if (! $mrRes){ $alertStr .= '\n提醒信息记录失败！'; }

				$scoreArr = array();
				$scoreArr['MR_userID']		= $userID;
				$scoreArr['MR_username']	= $username;
				$scoreArr['MR_dataID']		= $dataID;
				$scoreArr['MR_dataName']	= $vpsName;
				$scoreArr['MR_type']		= 'vpsApi';
				$scoreArr['MR_type2']		= '续费';
				$scoreArr['MR_money']		= $userPrice*(-1);
				$scoreArr['MR_remMoney']	= $userMoney - $userPrice;
				$scoreArr['MR_bank']		= '账户余额';
				$scoreArr['MR_note']		= '续费审核中！产品：'. $proDataName .'；机器编码：'. $vpsName .'；续费期限：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；'. $priceStr .'；';
				$scoreArr['MR_adminID']		= 0;
				$scoreArr['MR_adminName']	= '';
				$mrRes = AppMoneyRecord::AddData($scoreArr);
					if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }

				AreaApp::MessageSend('xufeiVps9', '『审核』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”提交续费申请，请管理员审核续费。【'. TimeDate::Get() .'】');
			}else{
				$alertRes='失败';
			}

			JS::AlertHref('续费'. $alertRes .'！当前状态续费中，请耐心等待管理员审核通过即可完成续费。'. $alertStr,$backURL);
		}
	}



	// 升级处理
	public static function Shengji(){
		global $DB,$UE_ID,$userRow;

		@ini_set('max_execution_time', 0);
		@set_time_limit(0); 

		$backURL		= OT::PostStr('backURL');
		$dataID			= OT::PostInt('dataID');
		// $oldProDataID	= OT::PostInt('oldProDataID');
		$newProDataID	= OT::PostInt('proDataID');
		$userPrice		= OT::PostFloat('userPrice');
			if ($dataID <= 0){ JS::AlertBackEnd('该记录ID错误.'); }
			if ($newProDataID <= 0){ JS::AlertBackEnd('升级产品ID错误.'); }
			if ($userPrice == 0){ JS::AlertBackEnd('扣款金额不能为0。'); }

		$vpsSysArr = Cache::PhpFile('vpsSys');
		if (strpos($vpsSysArr['VS_funcStr'],'|vpsApiUpdate|') === false){
			JS::AlertBackEnd('升级功能已被关闭，如有升级需求请联系管理员。');
		}

		$dataexe = $DB->query('select VAU_userID,VAU_username,VAU_proDataID,VAU_proDataName,VAU_payMode,VAU_vpsName,VAU_endTime from '. OT_dbPref .'vpsApiUsers where VAU_ID='. $dataID .' and VAU_userID='. $UE_ID);
		if (! $row = $dataexe->fetch()){ JS::AlertBackEnd('该记录不存在。'); }
		$userID			= $row['VAU_userID'];
		$username		= $row['VAU_username'];
		$proDataID		= $row['VAU_proDataID'];
		$proDataName	= $row['VAU_proDataName'];
		$payMode		= $row['VAU_payMode'];
		$vpsName		= $row['VAU_vpsName'];
		$proPriceMonth	= $DB->GetOne('select VAD_priceMonth from '. OT_dbPref .'vpsApiData where VAD_ID='. $proDataID);

		$fieldArr = IdcInfo::PayModeField($payMode,'VAD_');

		$newProexe = $DB->query('select VAD_theme,VAD_priceMonth,'. $fieldArr['price'] .','. $fieldArr['cost'] .' from '. OT_dbPref .'vpsApiData where VAD_ID='. $newProDataID);
			if (! $rs = $newProexe->fetch()){ JS::AlertBackEnd('该升级产品记录不存在。'); }
		$newProDataName		= $rs['VAD_theme'];
		$newProPriceMonth	= $rs['VAD_priceMonth'];
		$newPrice			= $rs[$fieldArr['price']];
		$newCost			= $rs[$fieldArr['cost']];

		$updatePrice = IdcArea::MonthDiffPrice($proPriceMonth, $newProPriceMonth, $row['VAU_endTime']);

		$priceStr = '价格：'. $userPrice .'元';
		if ($userRow['UE_groupID'] > 0){
			// 走代理折扣价
			$agentArr = AppAgent::CheckPriceUpdate('vpsApi', $proDataID, $newProDataID, $userRow['UE_groupID'], $row['VAU_endTime']);
			if ($agentArr['isAgent'] == 1){
				$priceStr = $agentArr['agentName'] .'价：'. $agentArr['agentPrice'] .'元，原价：'. $updatePrice .'元';;
				$updatePrice = $agentArr['agentPrice'];
				$newPrice = IdcInfo::VpsAgentPrice($payMode, $agentArr['newPrice']);
			}
		}

		if ( OT::FloatCmp($userPrice, $updatePrice) != 0 ){ JS::AlertBackEnd('升级价格不一致('. $userPrice .'|'. $updatePrice .')，请刷新页面重新试下.'); }

		$userMoney = floatval($DB->GetOne('select UE_money from '. OT_dbPref .'users where UE_ID='. $userID));
			if ( OT::FloatCmp($userMoney, $userPrice) < 0 ){
				JS::AlertBackEnd('用户余额'. $userMoney .'元，扣款'. $userPrice .'元，余额不足，没法扣款。');
			}
		$result = $DB->UpdateParam('users',array('UE_money'=>'UE_money-'. $userPrice,'UE_payMoney'=>'UE_payMoney+'. $userPrice),'UE_ID='. $userID);
			if (! $result){
				JS::AlertBackEnd('用户余额扣款失败，请刷新页面重试下。');
			}

		$alertStr = '\n用户金额 '. $userMoney .' 元，扣款 '. $userPrice .' 元，剩余 '. OT::NumFormat($userMoney - $userPrice) .' 元';

		$retArr = AppIdcVps::Update($newProDataID, $newPrice, $newCost, $dataID);
		if (! $retArr['res']){
			if (strpos($vpsSysArr['VS_failMoneyStr'],'|vpsApiUpdate|') !== false){
				$DB->UpdateParam('users',array('UE_money'=>'UE_money+'. $userPrice,'UE_payMoney'=>'UE_payMoney-'. $userPrice),'UE_ID='. $userID);
				$MR_money = 0;
				$MR_remMoney = -9;
				$noteStr = '，不扣款';
			}else{
				$MR_money = $userPrice*(-1);
				$MR_remMoney = $userMoney - $userPrice;
				$noteStr = '，已扣款，请联系管理员处理';
			}
			$scoreArr = array();
			$scoreArr['MR_userID']		= $userID;
			$scoreArr['MR_username']	= $username;
			$scoreArr['MR_dataID']		= $dataID;
			$scoreArr['MR_dataName']	= $vpsName;
			$scoreArr['MR_type']		= 'vpsApi';
			$scoreArr['MR_type2']		= '升级';
			$scoreArr['MR_money']		= $MR_money;
			$scoreArr['MR_remMoney']	= $MR_remMoney;
			$scoreArr['MR_note']		= '升级产品失败'. $noteStr .'！旧产品：'. $proDataName .'，新产品：'. $newProDataName .'；机器编码：'. $vpsName .'；'. $priceStr .'；';
			AppMoneyRecord::AddData($scoreArr);

			AreaApp::MessageSend('shengjiVps0', '『失败』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”升级“'. $newProDataName .'”失败'. $noteStr .'。【'. TimeDate::Get() .'】');

			JS::AlertBackEnd('升级失败，请联系管理员给你处理！'. $retArr['note']);
		}

		// $userGain = $userPrice - $newCost;
		// if ($userGain < 0){ $userGain = 0; }
		$scoreArr = array();
		$scoreArr['MR_userID']		= $userID;
		$scoreArr['MR_username']	= $username;
		$scoreArr['MR_dataID']		= $dataID;
		$scoreArr['MR_dataName']	= $vpsName;
		$scoreArr['MR_type']		= 'vpsApi';
		$scoreArr['MR_type2']		= '升级';
		$scoreArr['MR_money']		= $userPrice*(-1);
		$scoreArr['MR_remMoney']	= $userMoney - $userPrice;
		// $scoreArr['MR_cost']		= $newCost;
		// $scoreArr['MR_gain']		= $userGain;
		$scoreArr['MR_bank']		= '账户余额';
		$scoreArr['MR_note']		= '升级产品成功！旧产品：'. $proDataName .'，新产品：'. $newProDataName .'；机器编码：'. $vpsName .'；升级'. $priceStr .'；';
		$mrRes = AppMoneyRecord::AddData($scoreArr);
			if ($mrRes){ $mrAlertStr=''; }else{ $mrAlertStr='\n财务信息记录失败（需要“财务基础包”插件支持）！'; }
		$alertStr .= $mrAlertStr;

		AreaApp::MessageSend('shengjiVps1', '会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”升级“'. $newProDataName .'”成功。【'. TimeDate::Get() .'】');

		JS::AlertHref('升级成功！'. $alertStr,$backURL);
	}



	// 云服务器 转正处理
	public static function Zhuanzheng(){
		global $DB,$UE_ID,$userRow;

		@ini_set('max_execution_time', 0);
		@set_time_limit(0); 

		$backURL	= OT::PostStr('backURL');
		$dataID		= OT::PostInt('dataID');

		$vpsSysArr = Cache::PhpFile('vpsSys');
		if (strpos($vpsSysArr['VS_funcStr'],'|vpsApiZhuanzheng|') === false){
			JS::AlertHref('转正功能已被关闭，如有转正需求请联系管理员。',$backURL);
		}
		if ($vpsSysArr['VS_isVpsZhuanzheng'] == 0){
			JS::AlertHref('转正操作，请联系网站客服处理。',$backURL);
		}

		$dataexe = $DB->query('select VAU_userID,VAU_username,VAU_time,VAU_endTime,VAU_proDataID,VAU_proDataName,VAU_vpsName,VAU_payMode,VAU_isNewPrice,VAU_priceYear,VAU_costYear from '. OT_dbPref .'vpsApiUsers where VAU_ID='. $dataID .' and VAU_userID='. $UE_ID);
		if (! $row = $dataexe->fetch()){ JS::AlertBackEnd('该记录不存在。'); }
		$startTime		= $row['VAU_time'];
//		$endTime		= $row['VAU_endTime'];
		$userID			= $row['VAU_userID'];
		$username		= $row['VAU_username'];
		$proDataName	= $row['VAU_proDataName'];
		$vpsName		= $row['VAU_vpsName'];
		if ($row['VAU_payMode'] == '24hour'){
			$payMode = 'month';
		}elseif ($row['VAU_payMode'] == '48hour'){
			$payMode = 'year';
		}else{
			JS::AlertBackEnd('之前付款方式不对（'. $row['VAU_payMode'] .'）。');
		}
//			if (! strtotime($endTime)){
//				JS::AlertBackEnd('到期时间获取异常（'. $endTime .'），请刷新页面后重新操作下。');
//			}

		$endTime = IdcArea::NewEndTime($payMode, $startTime);

		$alertStr = '';

		$retArr = AppIdcVps::Zhuanzheng($payMode,$endTime,$dataID);
		if (! $retArr['res']){
			$scoreArr = array();
			$scoreArr['MR_userID']		= $userID;
			$scoreArr['MR_username']	= $username;
			$scoreArr['MR_dataID']		= $dataID;
			$scoreArr['MR_dataName']	= $vpsName;
			$scoreArr['MR_type']		= 'vpsApi';
			$scoreArr['MR_type2']		= '转正';
			$scoreArr['MR_money']		= 0;
			$scoreArr['MR_remMoney']	= -9;
			$scoreArr['MR_note']		= '转正失败！产品：'. $proDataName .'；机器编码：'. $vpsName .'；转正期限：'. IdcInfo::PayTime($payMode) .'；';
			AppMoneyRecord::AddData($scoreArr);

			AreaApp::MessageSend('zhuanzhengVps0', '『失败』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”转正失败。【'. TimeDate::Get() .'】');

			JS::AlertBackEnd('转正失败，请联系管理员给你处理！'. $retArr['note']);
		}

		$scoreArr = array();
		$scoreArr['MR_userID']		= $userID;
		$scoreArr['MR_username']	= $username;
		$scoreArr['MR_dataID']		= $dataID;
		$scoreArr['MR_dataName']	= $vpsName;
		$scoreArr['MR_type']		= 'vpsApi';
		$scoreArr['MR_type2']		= '转正';
		$scoreArr['MR_money']		= 0;
		$scoreArr['MR_remMoney']	= -9;
		$scoreArr['MR_note']		= '转正成功！产品：'. $proDataName .'；机器编码：'. $vpsName .'；转正期限：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；';
		$mrRes = AppMoneyRecord::AddData($scoreArr);
			if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }

		AreaApp::MessageSend('zhuanzhengVps1', '会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”转正成功。【'. TimeDate::Get() .'】');

		JS::AlertHref('转正成功！'. $alertStr,$backURL);
	}



	// 云服务器 退款处理
	public static function Tuikuan(){
		global $DB,$UE_ID,$userRow;

		@ini_set('max_execution_time', 0);
		@set_time_limit(0); 

		$backURL	= OT::PostStr('backURL');
		$dataID		= OT::PostInt('dataID');

		$dataexe = $DB->query('select VAU_userID,VAU_username,VAU_time,VAU_endTime,VAU_proDataID,VAU_proDataName,VAU_ipStr,VAU_vpsName,VAU_payMode,VAU_price,VAU_cost,VAU_isUserPay,VAU_state from '. OT_dbPref .'vpsApiUsers where VAU_ID='. $dataID .' and VAU_userID='. $UE_ID);
		if (! $row = $dataexe->fetch()){ JS::AlertBackEnd('该记录不存在。'); }
		$startTime		= $row['VAU_time'];
		$endTime		= $row['VAU_endTime'];
		$userID			= $row['VAU_userID'];
		$username		= $row['VAU_username'];
		$proDataName	= $row['VAU_proDataName'];
		$ipStr			= $row['VAU_ipStr'];
		$vpsName		= $row['VAU_vpsName'];
		$payMode		= $row['VAU_payMode'];
		$userPrice		= $row['VAU_price'];
		$cost			= $row['VAU_cost'];
		if ($row['VAU_isUserPay'] != 1){
			JS::AlertBackEnd('该机器未付款不支持退款操作。');
		}
		if ($row['VAU_state'] != 12){
			JS::AlertBackEnd('该机器不是试用中状态，不支持退款操作。');
		}

		$alertStr = '';
		$dataArr = array('VAU_state' => 8);	// 状态改为退款中
		$result = $DB->UpdateParam('vpsApiUsers', $dataArr, 'VAU_ID='. $dataID);
		if ($result){
			$alertRes='成功';
			$recordArr = array();
			$recordArr['TX_time']		= TimeDate::Get();
			$recordArr['TX_type']		= 'vpsApi';
			$recordArr['TX_type2']		= '退款';
			$recordArr['TX_dataID']		= $dataID;
			$recordArr['TX_dataName']	= $proDataName;
			$recordArr['TX_vpsName']	= $vpsName;
			$recordArr['TX_ipStr']		= $ipStr;
			$recordArr['TX_userID']		= $UE_ID;
			$recordArr['TX_username']	= $userRow['UE_username'];
			$recordArr['TX_payMode']	= $payMode;
			$recordArr['TX_price']		= $userPrice;
			$recordArr['TX_cost']		= $cost;
			$recordArr['TX_startTime']	= $startTime;
			$recordArr['TX_endTime']	= $endTime;
			$recordArr['TX_state']		= 0;
			$mrRes = $DB->InsertParam('tixing', $recordArr);
				if (! $mrRes){ $alertStr .= '\n提醒信息记录失败！'; }

			$scoreArr = array();
			$scoreArr['MR_userID']		= $userID;
			$scoreArr['MR_username']	= $username;
			$scoreArr['MR_dataID']		= $dataID;
			$scoreArr['MR_dataName']	= $vpsName;
			$scoreArr['MR_type']		= 'vpsApi';
			$scoreArr['MR_type2']		= '退款';
			$scoreArr['MR_money']		= 0;
			$scoreArr['MR_remMoney']	= -9;
			$scoreArr['MR_note']		= '退款审核中！产品：'. $proDataName .'；机器编码：'. $vpsName .'；付款方式：'. IdcInfo::PayTime($payMode) .'（'. TimeDate::Get('date',$endTime) .'到期）；预计退款：'. $userPrice .'元；';
			$mrRes = AppMoneyRecord::AddData($scoreArr);
				if (! $mrRes){ $alertStr .= '\n财务信息记录失败（需要“财务基础包”插件支持）！'; }
		}else{
			$alertRes='失败';
		}

		AreaApp::MessageSend('tuikuanVps9', '『退款』会员“'. $username .'”云服务器['. $vpsName .']“'. $proDataName .'”提交退款申请'. $alertRes .'，请管理员处理退款。【'. TimeDate::Get() .'】');

		JS::AlertHref('退款申请提交'. $alertRes .'！请耐心等待管理员审核通过即可完成退款。'. $alertStr,$backURL);
	}



	// 云服务器 挂机宝剩余台数
	public static function GuajibaoNum($dataID, $proID){
		global $DB;

		$webHtml = new WebHtml();
		$getStr	= $webHtml->GetCode('http://api.ipcomserver.com/user/vps-serverID.asp?id='. $proID,'GBK');
		$mjList	= $webHtml->GetStr($getStr, '"list":[', ']}');
		$mjArrStr = $webHtml->GetArrStr($mjList,'(剩余','台');
		$num = 0;
		$tempArr = explode('[OT]',$mjArrStr);
		$tempCount = count($tempArr);
		for ($i=0; $i<$tempCount; $i++){
			if (strlen($tempArr[$i]) == 0 || is_numeric($tempArr[$i]) == false){
				$num = -1;
				break;
			}else{
				$num += intval($tempArr[$i]);
			}
		}

		$DB->UpdateParam('vpsApiData', array('VAD_guajibaoNum'=>$num,'VAD_guajibaoTime'=>TimeDate::Get()), 'VAD_ID='. $dataID);

		return $num;
	}

}
?>