<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class AppTplIdc{
	public static $appName = 'IDC蓝色默认模板';


	// 顶部栏目菜单
	public static function TopMenu($paraStr,$judGet=true){
		global $DB,$tpl;

		$judCache = false;
		$cacheName='func_TopMenu_'. $paraStr .'_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){
			$retStr = $webTarget = '';
			$webexe=$DB->query('select IW_ID,IW_theme,IW_themeStyle,IW_mode,IW_URL,IW_isEncUrl from '. OT_dbPref .'infoWeb where IW_state=1 and IW_type="top" order by IW_rank DESC');
			while ($row = $webexe->fetch()){
				if ($row['IW_mode'] == 'sitemap'){
					// 网站地图
					$webURL		= $tpl->webHost .'sitemap.html';
					$webTarget	= ' target="_blank"';
				}elseif ($row['IW_mode'] == 'message'){
					// 留言板
					$webURL		= $tpl->webHost .'message.php';
					$webTarget	= ' target="_blank"';
				}elseif ($row['IW_mode'] == 'url'){
					// 外部链接
					$webURL		= Url::WebUrl($row['IW_URL'],$row['IW_isEncUrl'],$row['IW_ID'],$tpl->webPathPart);
					$webTarget	= ' target="_blank"';
				}elseif ($row['IW_mode'] == 'saveUrl'){
					// 保存到桌面
					$webURL		= 'javascript:void(0);" onclick="document.location.href=\''. $tpl->webPathPart .'deal.php?mudi=desktopUrl\';return false;';
				}elseif ($row['IW_mode'] == 'addFavo'){
					// 加入收藏
					$webURL		= 'javascript:void(0);" onclick="AddFavorite(document.location.href,document.title);return false;';
				}elseif ($row['IW_mode'] == 'setHome'){
					// 设为首页
					$webURL		= 'javascript:void(0);" id="setHomeA" onclick="SetHome($id(\'setHomeA\'),document.location.href);return false;';
				}else{
					// 单篇页
					$webURL		= Url::WebID($row['IW_ID'],0,$tpl->webPathPart);
				}
				$retStr .= '<li class="menu"><div class="menuDiv"><a href="'. $webURL .'" style="'. $row['IW_themeStyle'] .'" '. $webTarget .'>'. $row['IW_theme'] .'</a></div></li>';
			}
			unset($webexe);

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}



	// 导航菜单
	public static function NavMenu($paraStr,$judGet=true){
		global $DB,$tpl;

		$judCache = false;
		$cacheName='tpl_NavMenu_'. $paraStr .'_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){
			$retStr = '';
			if ($tpl->webHost == ''){ $GB_NavHost=$tpl->webPathPart; }else{ $GB_NavHost=$tpl->webHost; }

			$menuListStr = $subMenuStr = '';
			$menuRow = $DB->GetLimit('select IT_ID,IT_theme,IT_themeStyle,IT_mode,IT_webID,IT_URL,IT_isEncUrl,IT_openMode,IT_level,IT_htmlName from '. OT_dbPref .'infoType where IT_state=1 and IT_isMenu=1 order by IT_rank ASC',20);
			if ($menuRow){
				$rowCount = count($menuRow);
				for ($i=0; $i<$rowCount; $i++){
					$hrefStr = Area::InfoTypeUrl(array(
						'IT_mode'		=> $menuRow[$i]['IT_mode'],
						'IT_ID'			=> $menuRow[$i]['IT_ID'],
						'IT_webID'		=> $menuRow[$i]['IT_webID'],
						'IT_URL'		=> $menuRow[$i]['IT_URL'],
						'IT_isEncUrl'	=> $menuRow[$i]['IT_isEncUrl'],
						'IT_htmlName'	=> $menuRow[$i]['IT_htmlName'],
						'mainUrl'		=> '',
						'webPathPart'	=> $tpl->webPathPart,
						));
					//  '. (strlen($menuListStr) > 0 ? '' : 'active') .'
					$menuListStr .= '
						<li class="itemLi" dataRel="subMenu_'. $menuRow[$i]['IT_ID'] .'">
							<h2><a class="fontTrans" href="'. $hrefStr .'" style="'. $menuRow[$i]['IT_themeStyle'] .'" target="'. $menuRow[$i]['IT_openMode'] .'">'. $menuRow[$i]['IT_theme'] .'</a></h2>
						</li>'. PHP_EOL;

					if ($menuRow[$i]['IT_level'] == 1){
						$menu2exe = $DB->query('select IT_ID,IT_theme,IT_themeStyle,IT_mode,IT_webID,IT_URL,IT_isEncUrl,IT_openMode,IT_htmlName from '. OT_dbPref .'infoType where IT_state=1 and IT_fatID='. $menuRow[$i]['IT_ID'] .' and IT_isSubMenu=1 order by IT_rank ASC');
						if ($row2 = $menu2exe->fetch()){
							$subMenuStr .= '
								<div id="subMenu_'. $menuRow[$i]['IT_ID'] .'" class="subMenuDiv menuDz" style="display:none;" dataRel="subMenu_'. $menuRow[$i]['IT_ID'] .'">
									<div class="subMenuItem">
									<nav class="subMenuOne">
										<dl>
										<dt>'. $menuRow[$i]['IT_theme'] .'：</dt>
										<dd>
											<ul class="subOneList clearFix">
											';
							do {
								$hrefStr = Area::InfoTypeUrl(array(
									'IT_mode'		=> $row2['IT_mode'],
									'IT_ID'			=> $row2['IT_ID'],
									'IT_webID'		=> $row2['IT_webID'],
									'IT_URL'		=> $row2['IT_URL'],
									'IT_isEncUrl'	=> $row2['IT_isEncUrl'],
									'IT_htmlName'	=> $row2['IT_htmlName'],
									'mainUrl'		=> '',
									'webPathPart'	=> $tpl->webPathPart,
									));
								$subMenuStr .= '<li><a href="'. $hrefStr .'" target="'. $row2['IT_openMode'] .'" style="'. $row2['IT_themeStyle'] .'" class="aFont">'. $row2['IT_theme'] .'</a></li>';
							}while ($row2 = $menu2exe->fetch());
								$subMenuStr .= '
											</ul>
										</dd>
										</dl>
									</nav>
									</div>
								</div>
								';
						}
						$menu2exe = null;
					}

				}
			}
			unset($menuexe);

			if (strlen($tpl->tplSysArr['TS_logo']) < 3){
				$logo = $tpl->webPathPart . $tpl->tplDir .'images/logo.png';
			}else{
				if (Is::AbsUrl($tpl->tplSysArr['TS_logo'])){
					$logo = $tpl->tplSysArr['TS_logo'];
				}else{
					$logo = $tpl->webPathPart . ImagesFileDir . $tpl->tplSysArr['TS_logo'];
				}
			}
			$retStr = '
				<div class="navMenuMain clearFix">
					<h1 class="logoBox"><a href="'. $tpl->webHost .'" title="'. $tpl->sysArr['SYS_title'] .'" class="donghua zoomIn" style="background: url('. $logo .') no-repeat left center;"></a></h1>
					<nav id="navMenuBox">
					<div class="clearFix">
						<ul class="navItem">
						'. $menuListStr .'
						</ul>
					</div>
					</nav>
				</div>
				<!-- 横向二级菜单 start -->
				<div class="subMenuBox">
					'. $subMenuStr .'
				</div>
				<!-- 横向二级菜单 start -->
				';

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}


	// banner广告
	public static function NavBanner($paraStr,$judGet=true){
		global $DB,$tpl;

		if ($tpl->tplSysArr['TS_isImgBanner'] == 0){ return ''; }

		$judCache = false;
		$cacheName='func_NavBanner_'. $paraStr .'_'. strlen($tpl->webPathPart);

		$retStr = '';
		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){

			$banexe = $DB->query('select * from '. OT_dbPref .'banner where BN_state=1 and BN_type='. $DB->ForStr('homeNav') .' order by BN_rank DESC');
			if ($row = $banexe->fetch()){
				$retStr .= '
					<div class="bannerArea">
					<div id="bannerSlider" class="sliderBox clearFix">
						<div class="hd"><ul></ul></div>
						<div class="bd">
							<ul>
							';
				$dataNum = 0;
				do {
					$dataNum ++;
					$retStr .= '
						<li style="'. ($dataNum > 1 ? 'display:none; ' : '') .'background:url('. Area::InfoImgUrl($row['BN_img'],$tpl->webPathPart .ImagesFileDir) .') no-repeat center 0 '. $row['BN_bgColor'] .';">
							<a href="'. $row['BN_url'] .'" target="_blank">
							<div class="contDiv sliderCont">
							</div>
							</a>
						</li>
						';
				}while ($row = $banexe->fetch());

				$retStr .= '
						</ul>
					</div>
					<a class="prev arrow" href="javascript:void(0)"><i class="fa fa-angle-left"></i></a>
					<a class="next arrow" href="javascript:void(0)"><i class="fa fa-angle-right"></i></a>
				</div>
				</div>
				';
			}
			unset($marexe);

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}


	// 信息栏目
	public static function ItemList($paraStr,$judGet=true){
		global $DB,$tpl,$systemArr;

		$judCache = false;
		$cacheName='idc_ItemList_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){

			$retStr = '<li><a href="'. Url::ListStr('announ') .'" class="fontTrans" target="_blank">'. $systemArr['SYS_announName'] .'</a></li>';
			$ret2Str = self::ItemOne('announ',0,6);

			$typeexe = $DB->query('select IT_ID,IT_level,IT_isHomeImg,IT_openMode,IT_theme,IT_mode,IT_webID,IT_URL,IT_isEncUrl,IT_homeNum,IT_isItemDate,IT_isItemType,IT_htmlName from '. OT_dbPref .'infoType where IT_isHome=1 order by IT_itemRank ASC,IT_rank ASC limit 10');
			$typeRow = $typeexe->fetchAll();
			$rowCount = count($typeRow);

			for ($i=0; $i<$rowCount; $i++){
				if ($typeRow[$i]['IT_mode'] == 'web'){
					$moreHref = Url::WebID($typeRow[$i]['IT_webID']);
				}elseif ($typeRow[$i]['IT_mode'] == 'topic'){
					$moreHref = Url::ListTypeID('topic',$typeRow[$i]['IT_webID']);
				}elseif (substr($typeRow[$i]['IT_mode'],0,3) == 'url'){
					$moreHref = Url::ListUrl($typeRow[$i]['IT_mode'],$typeRow[$i]['IT_URL'],$typeRow[$i]['IT_isEncUrl'],$typeRow[$i]['IT_ID'],$tpl->webPathPart);
				}else{
					$moreHref = Url::ListID('',$typeRow[$i]['IT_htmlName'],$typeRow[$i]['IT_ID']);
				}
				$retStr .= '<li><a href="'. $moreHref .'" class="fontTrans" target="'. $typeRow[$i]['IT_openMode'] .'">'. $typeRow[$i]['IT_theme'] .'</a></li>';
				$ret2Str .= self::ItemOne($typeRow[$i]['IT_ID'],$typeRow[$i]['IT_level'],6);	// $typeRow[$i]['IT_homeNum']
				
			}
			unset($typeexe);

			$retStr = '
				<nav class="newsTabs clearFix">
					<ul id="jsNewsTabs">
					'. $retStr .'
					</ul>
				</nav>
				<div class="newsCont">
					<div id="jsNewsCont" class="clearFix">
					'. $ret2Str .'
					</div>
				</div>
				';

			Cache::WriteWebCache($cacheName,$retStr);
		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}


	// 栏目项目
	public static function ItemOne($typeStr,$typeLevel,$num,$judGet=true){
		global $DB,$tpl;

		$judCache = false;
		$cacheName='idc_ItemOne_'. $typeStr .'_'. $typeLevel .'_'. $num .'_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){

			$retStr = '';
			$whereStr = '';
			if ($typeStr == 'announ'){
				$whereStr	= ' and IF_type1ID=-1';

			}elseif ($typeLevel>=1 && $typeLevel<=3){
				$whereStr	= ' and IF_type'. $typeLevel .'ID='. $typeStr .'';

			}else{
				$whereStr	= " and IF_typeStr like '%,". $typeStr .",%'";
			}

			$retStr .= '<ul>'. PHP_EOL;
			if ($num>0){
				$itemexe = $DB->query('select IF1.IF_ID,IF2.IF_time,IF2.IF_theme,IF2.IF_typeStr,IF2.IF_themeStyle,IF2.IF_contentKey,IF2.IF_URL,IF2.IF_isEncUrl,IF2.IF_infoTypeDir,IF2.IF_datetimeDir from (select IF_ID from '. OT_dbPref .'info where IF_state=1 and IF_isAudit=1'. $whereStr .''. OT_TimeInfoWhereStr .' order by IF_time DESC limit 0,'. $num .') as IF1 inner join '. OT_dbPref .'info as IF2 on IF1.IF_ID=IF2.IF_ID order by IF2.IF_time DESC');
				$itemRow = $itemexe->fetchAll();
				$rowCount = count($itemRow);

				for ($i=0; $i<$rowCount; $i++){
					if ($itemRow[$i]['IF_URL'] != ''){
						$hrefStr = Url::NewsUrl($itemRow[$i]['IF_URL'],$itemRow[$i]['IF_isEncUrl'],$itemRow[$i]['IF_ID'],$tpl->webPathPart);
					}else{
						$hrefStr = Url::NewsID($itemRow[$i]['IF_infoTypeDir'],$itemRow[$i]['IF_datetimeDir'],$itemRow[$i]['IF_ID']);
					}
					$retStr .= '
						<li>
							<div class="dateBox"><span data-sign="day">'. TimeDate::Get('d',$itemRow[$i]['IF_time']) .'</span><span data-sign="yyyymm">'. TimeDate::Get('Y-m',$itemRow[$i]['IF_time']) .'</span></div>
							<div class="txtBox">
							<dl>
								<dt><a href="'. $hrefStr .'" title="'. Str::MoreReplace($itemRow[$i]['IF_theme'],'input') .'" target="_blank">'. $itemRow[$i]['IF_theme'] .'</a></dt>
								<dd>'. $itemRow[$i]['IF_contentKey'] .'</dd>
							</dl>
							</div>
						</li>
						';
				}
				unset($itemexe);
			}
			$retStr .= '</ul>'. PHP_EOL;

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}


	// 热销产品
	public static function HomeProBox($paraStr,$judGet=true){
		global $DB,$tpl;

		$judCache = false;
		$cacheName='idc_HomeProBox_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){
			$retStr = '';
			$proexe = $DB->query('select * from '. OT_dbPref .'homePro where HP_state=1 order by HP_rank DESC');
			while ($row = $proexe->fetch()){
				$retStr .= '
					<li class="proItem fontTrans">
						<div class="proIco"><img src="'. $tpl->webPathPart .'inc_img/idc/'. $row['HP_img'] .'.png" /></div>
						<div class="proCont">
							<h3>'. $row['HP_theme'] .'</h3>
							<div class="proNote">'. $row['HP_desc'] .'</div>
							<div class="proPrice"><span class="price">'. $row['HP_price1'] .'</span><span class="text">'. $row['HP_price2'] .'</span></div>
							<div class="proBtn"><a href="'. $row['HP_url'] .'" class="defBtn defBtn2 fontTrans" target="_blank">'. $row['HP_btnName'] .'</a></div>
						</div>
					</li>
					';
			}

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}


	// 域名注册框
	public static function HomeDomainBox($paraStr,$judGet=true){
		global $DB,$tpl;
		if ($tpl->tplSysArr['TS_isHomeDomain'] != 1){ return ''; }

		$judCache = false;
		$cacheName='idc_HomeDomainBox_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){
			$formStr = $modeStr = '';
			if (in_array($tpl->webTypeName, array('domainCheck','domain'))){
				$modeStr = '
					<hgroup class="domainModeBox">
						<a href="javascript:void(0)" data-suffix="hotDomain" data-input="ench" class="active" data-placeholder="请输入您想要注册的域名，如：otcms">热销域名</a>
						<a href="javascript:void(0)" data-suffix="newDomain" data-input="ench" data-placeholder="请输入您想要注册的域名，如：网钛" class="">新顶级域名</a>
						<a href="javascript:void(0)" data-suffix="cnDomain" data-input="cndomain" class="">CN域名</a>
						<a href="javascript:void(0)" data-suffix="cityDomain" data-input="cndomain" class="">国别域名</a>
						<a href="javascript:void(0)" data-suffix="chDomain" data-input="batch" class="">中文域名</a>
						<a href="javascript:void(0)" data-suffix="regDomain" data-input="batch" class="">批量注册域名</a>
					</hgroup>
					';
			}else{
				$formStr = 'target="_blank"';
			}

			$retStr = '
				<div id="domainArea" class="boxArea">
				<div class="boxDiv">
				<div class="row">
					<div class="shareDiv">
					<section class="domainSearch">
						<h2 class="fn-dn"><span>域名注册查询</span></h2>
						<form id="searForm" name="searForm" method="post" action="domainCheck.php" '. $formStr .' onsubmit="return CheckDomainSearchForm();">
						<input type="hidden" id="domainMode" name="domainMode" value="0">
						<input type="hidden" id="domainType" name="domainType" value="">
						'. $modeStr .'
						<div class="searchForm clearFix">
							<ul class="s clearFix">
								<li class="searInput">
									<input type="text" id="domainCont" name="domain" class="domainInput" maxlength="100" accesskey="s" autocomplete="off" x-webkit-speech="" value="">
								</li>
								<li class="drop">
									<div id="domainSel" class="domainOption">
										<div class="defSel"><i class="fa fa-caret-down"></i><span>.com</span></div>
										<dl style="height:280px;overflow-y:auto;">
											<dd relType="多选" relValue="多选">多选</dd>
											<dd relType="自定义" relValue="自定义">自定义</dd>
											<dd relType=".com" relValue=".com">.com</dd>
											<dd relType=".cn" relValue=".cn">.cn</dd>
											<dd relType=".net" relValue=".net">.net</dd>
											<dd relType=".org" relValue=".org">.org</dd>
											<dd relType=".com.cn" relValue=".com.cn">.com.cn</dd>
											<dd relType=".net.cn" relValue=".net.cn">.net.cn</dd>
											<dd relType=".org.cn" relValue=".org.cn">.org.cn</dd>
											<dd relType=".gov.cn" relValue=".gov.cn">.gov.cn</dd>
											<dd relType=".xin" relValue=".xin">.xin</dd>
											<dd relType=".xyz" relValue=".xyz">.xyz</dd>
											<dd relType=".club" relValue=".club">.club</dd>
											<dd relType=".top" relValue=".top">.top</dd>
											<dd relType=".wang" relValue=".wang">.wang</dd>
											<dd relType=".win" relValue=".win">.win</dd>
											<dd relType=".site" relValue=".site">.site</dd>
											<dd relType=".vip" relValue=".vip">.vip</dd>
											<dd relType=".store" relValue=".store">.store</dd>
											<dd relType=".pub" relValue=".pub">.pub</dd>
											<dd relType=".bid" relValue=".bid">.bid</dd>
											<dd relType=".cc" relValue=".cc">.cc</dd>
											<dd relType=".ltd" relValue=".ltd">.ltd</dd>
											<dd relType=".ren" relValue=".ren">.ren</dd>
											<dd relType=".lol" relValue=".lol">.lol</dd>
											<dd relType=".mom" relValue=".mom">.mom</dd>
											<dd relType=".online" relValue=".online">.online</dd>
											<dd relType=".tech" relValue=".tech">.tech</dd>
											<dd relType=".biz" relValue=".biz">.biz</dd>
											<dd relType=".red" relValue=".red">.red</dd>
											<dd relType=".website" relValue=".website">.website</dd>
											<dd relType=".space" relValue=".space">.space</dd>
											<dd relType=".link" relValue=".link">.link</dd>
											<dd relType=".news" relValue=".news">.news</dd>
											<dd relType=".date" relValue=".date">.date</dd>
											<dd relType=".loan" relValue=".loan">.loan</dd>
											<dd relType=".mobi" relValue=".mobi">.mobi</dd>
											<dd relType=".press" relValue=".press">.press</dd>
											<dd relType=".video" relValue=".video">.video</dd>
											<dd relType=".market" relValue=".market">.market</dd>
											<dd relType=".live" relValue=".live">.live</dd>
											<dd relType=".studio" relValue=".studio">.studio</dd>
											<dd relType=".help" relValue=".help">.help</dd>
											<dd relType=".info" relValue=".info">.info</dd>
											<dd relType=".click" relValue=".click">.click</dd>
											<dd relType=".pics" relValue=".pics">.pics</dd>
											<dd relType=".photo" relValue=".photo">.photo</dd>
											<dd relType=".trade" relValue=".trade">.trade</dd>
											<dd relType=".science" relValue=".science">.science</dd>
											<dd relType=".party" relValue=".party">.party</dd>
											<dd relType=".rocks" relValue=".rocks">.rocks</dd>
											<dd relType=".band" relValue=".band">.band</dd>
											<dd relType=".gift" relValue=".gift">.gift</dd>
											<dd relType=".wiki" relValue=".wiki">.wiki</dd>
											<dd relType=".design" relValue=".design">.design</dd>
											<dd relType=".software" relValue=".software">.software</dd>
											<dd relType=".social" relValue=".social">.social</dd>
											<dd relType=".lawyer" relValue=".lawyer">.lawyer</dd>
											<dd relType=".engineer" relValue=".engineer">.engineer</dd>
											<dd relType=".name" relValue=".name">.name</dd>
											<dd relType=".tv" relValue=".tv">.tv</dd>
											<dd relType=".me" relValue=".me">.me</dd>
											<dd relType=".asia" relValue=".asia">.asia</dd>
											<dd relType=".co" relValue=".co">.co</dd>
											<dd relType=".work" relValue=".work">.work</dd>
											<dd relType=".game" relValue=".game">.game</dd>
											<dd relType=".games" relValue=".games">.games</dd>
											<dd relType=".pro" relValue=".pro">.pro</dd>
											<dd relType=".kim" relValue=".kim">.kim</dd>
											<dd relType=".中国" relValue=".中国">.中国</dd>
											<dd relType=".公司" relValue=".公司">.公司</dd>
											<dd relType=".网络" relValue=".网络">.网络</dd>
										</dl>
									</div>
								</li>
								<li class="domainBtnBox">
									<input type="submit" id="domainSearBtn" class="subBtn" value="立即注册域名" />
								</li>
							</ul>
							<label class="defaultKey" id="defaultKey" for="domainCont">请输入您想要注册的域名，如：otcms</label>
						</div>

						<div class="domainSelBox">
							<p id="hotDomain" style="display:">
								<label><input type="checkbox" name="hotExt[]" value="com" checked="checked" /> .com</label>
								<label><input type="checkbox" name="hotExt[]" value="cn" checked="checked" /> .cn</label>
								<label><input type="checkbox" name="hotExt[]" value="net" checked="checked" /> .net</label>
								<label><input type="checkbox" name="hotExt[]" value="com.cn" /> .com.cn</label>
								<label><input type="checkbox" name="hotExt[]" value="top" /> .top</label>
								<label><input type="checkbox" name="hotExt[]" value="cc" /> .cc</label>
								<label><input type="checkbox" name="hotExt[]" value="hk" /> .hk</label>
								<label><input type="checkbox" name="hotExt[]" value="org" /> .org</label>
								<label><input type="checkbox" name="hotExt[]" value="xin" /> .xin</label>
								<label><input type="checkbox" name="hotExt[]" value="vip" /> .vip</label>
								<label><input type="checkbox" name="hotExt[]" value="xyz" /> .xyz</label>
								<label><input type="checkbox" name="hotExt[]" value="club" /> .club</label>
								<label><input type="checkbox" name="hotExt[]" value="me" /> .me</label>
								<label><input type="checkbox" name="hotExt[]" value="win" /> .win</label>
								<!-- <label><input type="checkbox" name="hotExt[]" value="site" /> .site</label>
								<label><input type="checkbox" name="hotExt[]" value="store" /> .store</label> -->
								<label><input type="checkbox" name="hotExt[]" value="co" /> .co</label>
								<!-- <label><input type="checkbox" name="hotExt[]" value="news" /> .news</label>
								<label><input type="checkbox" name="hotExt[]" value="name" /> .name</label> -->
								<label><input type="checkbox" name="hotExt[]" value="pro" /> .pro</label>
								<label><input type="checkbox" name="hotExt[]" value="in" /> .in</label>
								<label><input type="checkbox" name="hotExt[]" value="wang" /> .wang</label>
								<label><input type="checkbox" name="hotExt[]" value="biz" /> .biz</label>
								<!-- <label><input type="checkbox" name="hotExt[]" value="tv" /> .tv</label>
								<label><input type="checkbox" name="hotExt[]" value="mobi" /> .mobi</label>
								<label><input type="checkbox" name="hotExt[]" value="tw" /> .tw</label>
								<label><input type="checkbox" name="hotExt[]" value="tel" /> .tel</label> -->
								<label class="all"><input type="checkbox" id="domainAll" name="all" value="" />全选</label>
							</p>
							<p id="newDomain" style="display:none">
								<label><input type="checkbox" name="newExt[]" value="top" checked="checked" /> .top</label>
								<label><input type="checkbox" name="newExt[]" value="xyz" checked="checked" /> .xyz</label>
								<label><input type="checkbox" name="newExt[]" value="vip" checked="checked" /> .vip</label>
								<label><input type="checkbox" name="newExt[]" value="shop" /> .shop</label>
								<label><input type="checkbox" name="newExt[]" value="club" /> .club</label>
								<label><input type="checkbox" name="newExt[]" value="site" /> .site</label>
								<label><input type="checkbox" name="newExt[]" value="xin" /> .xin</label>
								<label><input type="checkbox" name="newExt[]" value="online" /> .online</label>
								<label><input type="checkbox" name="newExt[]" value="space" /> .space</label>
								<label><input type="checkbox" name="newExt[]" value="wang" /> .wang</label>
								<label><input type="checkbox" name="newExt[]" value="win" /> .win</label>
								<label><input type="checkbox" name="newExt[]" value="ren" /> .ren</label>
								<label><input type="checkbox" name="newExt[]" value="date" /> .date</label>
								<label><input type="checkbox" name="newExt[]" value="red" /> .red</label>
								<label style="font-size:16px;"><input type="checkbox" name="newExt[]" value="website" /> .website</label>
								<label><input type="checkbox" name="newExt[]" value="bid" /> .bid</label>
								<label><input type="checkbox" name="newExt[]" value="tech" /> .tech</label>
								<label><input type="checkbox" name="newExt[]" value="loan" /> .loan</label>
								<label><input type="checkbox" name="newExt[]" value="ltd" /> .ltd</label>
								<label><input type="checkbox" name="newExt[]" value="ink" /> .ink</label>
								<label><input type="checkbox" name="newExt[]" value="kim" /> .kim</label>
								<label><input type="checkbox" name="newExt[]" value="store" /> .store</label>
								<label><input type="checkbox" name="newExt[]" value="news" /> .news</label>
								<label><input type="checkbox" name="newExt[]" value="name" /> .name</label>
								<label><input type="checkbox" name="newExt[]" value="pro" /> .pro</label>
								<label><input type="checkbox" name="newExt[]" value="in" /> .in</label>
								<label><input type="checkbox" name="newExt[]" value="biz" /> .biz</label>
								<label><input type="checkbox" name="newExt[]" value="info" /> .info</label>
								<label><input type="checkbox" name="newExt[]" value="mobi" /> .mobi</label>
								<label><input type="checkbox" name="newExt[]" value="pw" /> .pw</label>
							</p>
							<p id="cnDomain" style="display:none">
								<label><input type="checkbox" name="cnExt[]" value="cn" checked="checked" />.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="com.cn" checked="checked" />.com.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="net.cn" checked="checked" />.net.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="org.cn" />.org.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="gov.cn" />.gov.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="ac.cn" />.ac.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="bj.cn" />.bj.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="sh.cn" />.sh.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="tj.cn" />.tj.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="cq.cn" />.cq.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="he.cn" />.he.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="sn.cn" />.sn.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="sx.cn" />.sx.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="nm.cn" />.nm.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="ln.cn" />.ln.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="jl.cn" />.jl.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="hl.cn" />.hl.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="js.cn" />.js.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="zj.cn" />.zj.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="ah.cn" />.ah.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="fj.cn" />.fj.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="jx.cn" />.jx.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="sd.cn" />.sd.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="ha.cn" />.ha.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="hb.cn" />.hb.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="hn.cn" />.hn.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="gd.cn" />.gd.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="gx.cn" />.gx.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="hi.cn" />.hi.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="sc.cn" />.sc.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="gz.cn" />.gz.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="yn.cn" />.yn.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="gs.cn" />.gs.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="qh.cn" />.qh.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="nx.cn" />.nx.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="xj.cn" />.xj.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="tw.cn" />.tw.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="hk.cn" />.hk.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="mo.cn" />.mo.cn</label>
								<label><input type="checkbox" name="cnExt[]" value="xz.cn" />.xz.cn</label>
							</p>
							<p id="cityDomain" style="display:none">
								<label><input type="checkbox" name="cityExt[]" value="cn" checked="checked" /> .cn</label>
								<label><input type="checkbox" name="cityExt[]" value="cc" checked="checked" /> .cc</label>
								<label><input type="checkbox" name="cityExt[]" value="hk" checked="checked" /> .hk</label>
								<label><input type="checkbox" name="cityExt[]" value="pw" /> .pw</label>
								<label><input type="checkbox" name="cityExt[]" value="in" /> .in</label>
								<label><input type="checkbox" name="cityExt[]" value="us" /> .us</label>
								<label><input type="checkbox" name="cityExt[]" value="me" /> .me</label>
								<label><input type="checkbox" name="cityExt[]" value="gg" /> .gg</label>
								<label><input type="checkbox" name="cityExt[]" value="asia" /> .asia</label>
								<label><input type="checkbox" name="cityExt[]" value="la" /> .la</label>
								<label><input type="checkbox" name="cityExt[]" value="tm" /> .tm</label>
								<label><input type="checkbox" name="cityExt[]" value="co" /> .co</label>
								<label><input type="checkbox" name="cityExt[]" value="gs" /> .gs</label>
								<label><input type="checkbox" name="cityExt[]" value="tw" /> .tw</label>
								<label><input type="checkbox" name="cityExt[]" value="sc" /> .sc</label>
								<label><input type="checkbox" name="cityExt[]" value="vc" /> .vc</label>
								<label><input type="checkbox" name="cityExt[]" value="lc" /> .lc</label>
								<label><input type="checkbox" name="cityExt[]" value="cx" /> .cx</label>
								<label><input type="checkbox" name="cityExt[]" value="name" /> .name</label>
								<label><input type="checkbox" name="cityExt[]" value="tv" /> .tv</label>
							</p>
							<p id="chDomain" style="display:none">
								<label><input type="checkbox" name="chExt[]" value="中国" checked="checked" /> .中国</label>
								<label><input type="checkbox" name="chExt[]" value="公司" checked="checked" /> .公司</label>
								<label><input type="checkbox" name="chExt[]" value="网络" checked="checked" /> .网络</label>
								<label><input type="checkbox" name="chExt[]" value="网店" /> .网店</label>
								<label><input type="checkbox" name="chExt[]" value="集团" /> .集团</label>
								<label><input type="checkbox" name="chExt[]" value="信息" /> .信息</label>
								<label><input type="checkbox" name="chExt[]" value="我爱你" /> .我爱你</label>
								<label><input type="checkbox" name="chExt[]" value="广东" /> .广东</label>
								<label><input type="checkbox" name="chExt[]" value="佛山" /> .佛山</label>
							</p>
							<p id="regDomain" style="display:none">
								<textarea id="domainList" name="domainList" style="width:1163px;height:200px;margin-left:20px;padding:5px;" placeholder="请输入要注册的域名，每行一个，最多支持200个域名，如：&#13;&#10;otcms.com&#13;&#10;yuntaiidc.com&#13;&#10;idccms.com"></textarea><br />
								<input type="button" style="margin:5px 0 0 20px;" class="newBtn1 green" value="确定批量注册" onclick="CheckMoreRegForm()" />
							</p>
							<div style="padding:6px 0;color:red;font-size:16px;">'. $tpl->tplSysArr['TS_homeDomainAnnoun'] .'</div>
						</div>
						</form>

					</section>
					</div>
				</div>
				</div>
				</div>
				';

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}

	}


	// 域名教程
	public static function DomainItem($paraStr,$judGet=true){
		global $DB,$tpl;

		$paraArr = explode(",",$paraStr);
		$typeStr	= $paraArr[0];
		$typeLevel	= $paraArr[1];
		$num		= $paraArr[2];

		$judCache = false;
		$cacheName='idc_DomainItem_'. strlen($tpl->webPathPart);

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){

			$retStr = '';
			$whereStr = '';
			if ($typeStr == 'announ'){
				$whereStr	= ' and IF_type1ID=-1';

			}elseif ($typeLevel>=1 && $typeLevel<=3){
				$whereStr	= ' and IF_type'. $typeLevel .'ID='. $typeStr .'';

			}else{
				$whereStr	= " and IF_typeStr like '%,". $typeStr .",%'";
			}

			$retStr .= '<ul>'. PHP_EOL;
			if ($num>0){
				$itemexe = $DB->query('select IF1.IF_ID,IF2.IF_time,IF2.IF_theme,IF2.IF_typeStr,IF2.IF_themeStyle,IF2.IF_contentKey,IF2.IF_URL,IF2.IF_isEncUrl,IF2.IF_infoTypeDir,IF2.IF_datetimeDir from (select IF_ID from '. OT_dbPref .'info where IF_state=1 and IF_isAudit=1'. $whereStr .''. OT_TimeInfoWhereStr .' order by IF_time DESC limit 0,'. $num .') as IF1 inner join '. OT_dbPref .'info as IF2 on IF1.IF_ID=IF2.IF_ID order by IF2.IF_time DESC');
				$itemRow = $itemexe->fetchAll();
				$rowCount = count($itemRow);

				for ($i=0; $i<$rowCount; $i++){
					if ($itemRow[$i]['IF_URL'] != ''){
						$hrefStr = Url::NewsUrl($itemRow[$i]['IF_URL'],$itemRow[$i]['IF_isEncUrl'],$itemRow[$i]['IF_ID'],$tpl->webPathPart);
					}else{
						$hrefStr = Url::NewsID($itemRow[$i]['IF_infoTypeDir'],$itemRow[$i]['IF_datetimeDir'],$itemRow[$i]['IF_ID']);
					}
					$retStr .= '
						<li><i class="fa fa-angle-double-right ta tt"></i> <a href="'. $hrefStr .'" title="'. Str::MoreReplace($itemRow[$i]['IF_theme'],'input') .'" target="_blank" class="cols">'. $itemRow[$i]['IF_theme'] .'</a></li>
						';
				}
				unset($itemexe);
			}
			$retStr .= '</ul>'. PHP_EOL;

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}



	// 友情链接
	public static function LogoBox($judGet=true){
		global $DB,$tpl;

		$judCache = false;
		$cacheName='idc_LogoBox_'. strlen($tpl->webPathPart);
		$todayDate=TimeDate::Get('date');

		if ($retStr = Cache::CheckWebCache($cacheName)){ $judCache = true; }
		if ($judCache == false){
			$retStr = '';

			$logoexe=$DB->query("select IM_ID,IM_theme,IM_URL,IM_alt from OT_infoMove where IM_state=1 and IM_isImg=0 and IM_type='logo' and IM_startDate<=". $DB->ForTime($todayDate) ." and IM_endDate>=". $DB->ForTime($todayDate) ." order by IM_rank ASC");
				if ($row = $logoexe->fetch()){
					do {
						$retStr .= '<a href="'. $row['IM_URL'] .'" target="_blank" title="'. $row['IM_alt'] .'">'. $row['IM_theme'] .'</a>';
					}while ($row = $logoexe->fetch());

					$retStr .= '<div class="clr"></div>';
				}
			unset($logoexe);

			$logoexe=$DB->query("select IM_ID,IM_theme,IM_URL,IM_imgMode,IM_img,IM_alt from OT_infoMove where IM_state=1 and IM_isImg>=1 and IM_type='logo' and IM_startDate<=". $DB->ForTime($todayDate) ." and IM_endDate>=". $DB->ForTime($todayDate) ." order by IM_rank ASC");
				while ($row = $logoexe->fetch()){
					if ($row['IM_imgMode'] == 'upImg'){ $imgUrl = $tpl->webPathPart . InfoMoveFileDir . $row['IM_img']; }else{ $imgUrl = $row['IM_img']; }
					$imgAlt = Str::MoreReplace($row['IM_theme'],'input');
					$retStr .= '<li><a href="'. $row['IM_URL'] .'" target="_blank" title="'. $row['IM_alt'] .'"><img src="'. $imgUrl .'" alt="'. $imgAlt .'" title="'. $imgAlt .'" class="img" /></a></li>';
				}
			unset($logoexe);

			Cache::WriteWebCache($cacheName,$retStr);

		}

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}


	// 列表页
	public static function NewsList($paraStr,$judGet=true){
		global $DB,$tpl;

		$paraArr = explode(",",$paraStr);
		$areaName	= $paraArr[0];
		$showMode	= $paraArr[1];
		$showNum	= intval($paraArr[2]);
		$typeStr	= $paraArr[3];
		$typeLevel	= $paraArr[4];
		if ($showNum == 0){ $showNum=10; }
		$typeStrID = 0;
		$listHtmlName = '';
		if ($showMode == 0){ $showMode=2; }
		if ($showMode == 4){
			$showModeClass = 2;
		}elseif ($showMode == 7){
			$showModeClass = 5;
		}else{
			$showModeClass = $showMode;
		}
		$retStr = '
			<div class="listBox'. $showModeClass .'">
			';

		$newRecordNum = 0;
		if ($typeStr == 'new' && $tpl->tplSysArr['TS_homeNewMoreNum']>0){
			$SQLstr = 'select IF_ID,IF_URL,IF_isEncUrl,IF_isTop,IF_readNum,IF_replyNum,IF_img,IF_time,IF_theme,IF_themeStyle,IF_themeKey,IF_contentKey,IF_infoTypeDir,IF_datetimeDir from '. OT_dbPref .'info where IF_state=1 and IF_isAudit=1 and IF_isNew=1'. OT_TimeInfoWhereStr;
			$newRecordNum = $tpl->tplSysArr['TS_homeNewMoreNum'];
		}else{
			$SQLstr = 'select IF_ID,IF_URL,IF_isEncUrl,IF_isTop,IF_readNum,IF_replyNum,IF_img,IF_time,IF_theme,IF_themeStyle,IF_themeKey,IF_contentKey,IF_infoTypeDir,IF_datetimeDir from '. OT_dbPref .'info where IF_state=1 and IF_isAudit=1'. OT_TimeInfoWhereStr;
		}
		switch ($typeStr){
			case 'announ':
				$SQLstr .= ' and IF_type1ID=-1 order by IF_isTop DESC,IF_time DESC';
				if ($tpl->tplSysArr['TS_homeAnnounListNum']>0){ $showNum=$tpl->tplSysArr['TS_homeAnnounListNum']; }
				break;

			case 'refer':
				if (strlen($tpl->refType) == 0){ $tpl->refType = OT::GetStr('refType'); }
				if (strlen($tpl->refContent) == 0){ $tpl->refContent = OT::GetRegExpStr('refContent','sql+ '); }
				if (strpos('|content|source|writer|','|'. $tpl->refType .'|') === false){ $tpl->refType='theme'; }
				$SQLstr .= ' and IF_'. $tpl->refType ." like '%". $DB->ForStr($tpl->refContent,false) ."%' order by IF_isTop DESC,IF_time DESC";
				if ($tpl->sysArr['SYS_searchListNum']>0){ $showNum = $tpl->sysArr['SYS_searchListNum']; }
				break;

			case 'mark':
				if ($tpl->sysArr['SYS_isMark'] == 0){
					// header('HTTP/1.0 404 Not Found');
					// header('Status: 404 Not Found');
					JS::AlertHrefEnd('标签页已被关闭。',$tpl->dbPathPart . $tpl->sysArr['SYS_subWeb404']);
				}
				if (strlen($tpl->markName) == 0){ $tpl->markName = OT::GetRegExpStr('markName','sql'); }
				if ($tpl->markName != ''){
					$SQLstr .= " and IF_themeKey like '%". $DB->ForStr($tpl->markName,false) ."%'";
				}
				$SQLstr .= ' order by IF_time DESC';
				if ($tpl->sysArr['SYS_markListNum']>0){ $showNum=$tpl->sysArr['SYS_markListNum']; }
				break;

			case 'user':
				if (strlen($tpl->markName) == 0){ $tpl->markName = OT::GetStr('markName'); }
				$SQLstr .= ' and IF_userID='. intval($tpl->markName) .' order by IF_time DESC';
				break;

			case 'topic':
				if (strlen($tpl->markName) == 0){ $tpl->markName = OT::GetStr('markName'); }
				$tpl->markName = intval($tpl->markName);
				$SQLstr .= ' and IF_topicID='. $tpl->markName .' order by IF_time DESC';
				$topicPageNum = intval($DB->GetOne('select IW_pageNum from '. OT_dbPref .'infoWeb where IW_ID='. $tpl->markName));
					if ($topicPageNum>0){ $showNum=$topicPageNum; }
				break;

			default :
				$typeStrID = intval($typeStr);
				if ($typeStrID>0){
					if ($typeLevel>=1 && $typeLevel<=3){
						$SQLstr .= ' and IF_type'. $typeLevel .'ID='. $typeStrID .' order by IF_isTop DESC,IF_time DESC';
					}else{
						$SQLstr .= " and IF_typeStr like '%,". $typeStrID .",%' order by IF_isTop DESC,IF_time DESC";
					}
					$listHtmlName = $DB->GetOne('select IT_htmlName from '. OT_dbPref .'infoType where IT_ID='. $typeStrID);
				}else{
					if ($typeStr == 'new'){
						$SQLstr .= ' and IF_isNew=1 order by IF_time DESC';
					}else{
						$SQLstr .= ' order by IF_isTop DESC,IF_time DESC';
					}
					if ($tpl->tplSysArr['TS_homeNewListNum']>0){ $showNum=$tpl->tplSysArr['TS_homeNewListNum']; }
				}
				break;
		}

		$pageSize	= $showNum;		//每页条数
		if ($tpl->page ==0){ $tpl->page = OT::GetInt('page'); }
		$showRow = $DB->GetLimit($SQLstr,$pageSize,$tpl->page);
		if (! $showRow){
			if ($typeStr == 'mark'){
				// header('HTTP/1.0 404 Not Found');
				// header('Status: 404 Not Found');
				JS::AlertHrefEnd('没搜索到相关标签文章。',$tpl->dbPathPart . $tpl->sysArr['SYS_subWeb404']);
			}elseif ($typeStr == 'refer'){
				$retStr .= '
					<meta name="robots" content="noindex">
					<br /><center class="font1_1">暂无内容</center><br />
					</div>
					';
			}else{
				$retStr .= '
					<br /><center class="font1_1">暂无内容</center><br />
					</div>
					';
			}
		}else{
			if ($newRecordNum > 0){ $recordCount = $newRecordNum; }else{ $recordCount=$DB->GetRowCount(); }
			$pageCount=ceil($recordCount/$pageSize);
			if ($tpl->page < 1 || $tpl->page > $pageCount){$tpl->page=1;}

			$number=1+($tpl->page-1)*$pageSize;
			$rowCount = count($showRow);
			
			$retStr .= '<ul>';
			switch ($showMode){
				case 2: case 4:
					for ($i=0; $i<$rowCount; $i++){
						if ($showRow[$i]['IF_URL'] != ''){
							$hrefStr = Url::NewsUrl($showRow[$i]['IF_URL'],$showRow[$i]['IF_isEncUrl'],$showRow[$i]['IF_ID'],$tpl->webPathPart);
						}else{
							$hrefStr = Url::NewsID($showRow[$i]['IF_infoTypeDir'],$showRow[$i]['IF_datetimeDir'],$showRow[$i]['IF_ID']);
						}
						if ($showRow[$i]['IF_isTop'] == 1){
							$topImg='<img src="'. $tpl->webPathPart .'inc_img/share_top.gif" alt="置顶" title="置顶" style="margin-right:5px;" />';
						}else{
							$topImg='';
						}
						if ($tpl->sysArr['SYS_newsListUrlMode'] == 'html-2.x'){
							$readAndReplyStr='';
						}else{
							$readAndReplyStr='&ensp;&ensp;评论：'. $showRow[$i]['IF_replyNum'] .'';
							if ($tpl->tplSysArr['TS_isReadNum'] == 1){ $readAndReplyStr='&ensp;&ensp;阅读：'. $showRow[$i]['IF_readNum'] . $readAndReplyStr; }
						}
						$themeStr = Str::MoreReplace($showRow[$i]['IF_theme'],'input');

						if ($showRow[$i]['IF_img'] != '' || $showMode == 4){ 
							$retStr .= '
							<li>
								<div class="a">
									<div class="img"><a href="'. $hrefStr .'" class="font1_1" target="_blank"><img src="'. Area::InfoImgUrl($showRow[$i]['IF_img'],$tpl->webPathPart . InfoImgDir) .'" alt="'. $themeStr .'" title="'. $themeStr .'" onerror="if(this.value!=\'1\'){this.value=\'1\';this.src=\''. $tpl->webPathPart .'inc_img/noPic.gif\';}" /></a></div>
								</div>
								<div class="b">
									<h4><a href="'. $hrefStr .'" class="font1_1" style="'. $showRow[$i]['IF_themeStyle'] .'" target="_blank">'. $topImg . TplList::RefFontColor($showRow[$i]['IF_theme']) .'</a></h4>
									<div class="clr"></div>
									<div class="note">'. TplList::RefFontColor($showRow[$i]['IF_contentKey']) .'&ensp;<a href="'. $hrefStr .'" class="font2_2" target="_blank">&ensp;阅读全文&gt;&gt;</a></div>
									<div class="clr"></div>
									<div class="mark"><div class="addi">&ensp;'. $showRow[$i]['IF_time'] .''. $readAndReplyStr .'</div>'. TplIndex::MarkStr($showRow[$i]['IF_themeKey']) .'</div>
								</div><div class="clr"></div>
							</li><div class="clr"></div>
							';
						}else{
							$retStr .= '
							<li>
								<div class="b" style="width:665px;">
									<div class="addi">&ensp;'. $showRow[$i]['IF_time'] .''. $readAndReplyStr .'</div><h4><a href="'. $hrefStr .'" class="font1_1" style="'. $showRow[$i]['IF_themeStyle'] .'" target="_blank">'. $topImg . TplList::RefFontColor($showRow[$i]['IF_theme']) .'</a></h4>
									<div class="clr"></div>
									<div class="note">'. TplList::RefFontColor($showRow[$i]['IF_contentKey']) .'&ensp;<a href="'. $hrefStr .'" class="font2_2" target="_blank">&ensp;阅读全文&gt;&gt;</a></div>
									<div class="clr"></div><div class="mark">'. TplIndex::MarkStr($showRow[$i]['IF_themeKey']) .'</div>
								</div><div class="clr"></div>
							</li><div class="clr"></div>
							';
						}
					}
					break;

				case 3:
					for ($i=0; $i<$rowCount; $i++){
						if ($showRow[$i]['IF_URL'] != ''){
							$hrefStr = Url::NewsUrl($showRow[$i]['IF_URL'],$showRow[$i]['IF_isEncUrl'],$showRow[$i]['IF_ID'],$tpl->webPathPart);
						}else{
							$hrefStr = Url::NewsID($showRow[$i]['IF_infoTypeDir'],$showRow[$i]['IF_datetimeDir'],$showRow[$i]['IF_ID']);
						}
						if ($showRow[$i]['IF_isTop'] == 1){
							$topImg='<img src="'. $tpl->webPathPart .'inc_img/share_top.gif" alt="置顶" title="置顶" style="margin-right:5px;" />';
						}else{
							$topImg='';
						}
						$themeStr = Str::MoreReplace($showRow[$i]['IF_theme'],'input');

						$retStr .= '
						<li>
							<div class="a"><a href="'. $hrefStr .'" target="_blank"><img src="'. Area::InfoImgUrl($showRow[$i]['IF_img'],$tpl->webPathPart . InfoImgDir) .'" alt="'. $themeStr .'" title="'. $themeStr .'" onerror="if(this.value!=\'1\'){this.value=\'1\';this.src=\''. $tpl->webPathPart .'inc_img/noPic.gif\';}" /></a></div>
							<div class="b"><a href="'. $hrefStr .'" class="font1_1 f14" style="'. $showRow[$i]['IF_themeStyle'] .'" target="_blank">'. $topImg . TplList::RefFontColor($showRow[$i]['IF_theme']) .'</a></div>
						</li>
						';
					}
					break;

				case 7:
					for ($i=0; $i<$rowCount; $i++){
						if ($showRow[$i]['IF_URL'] != ''){
							$hrefStr = Url::NewsUrl($showRow[$i]['IF_URL'],$showRow[$i]['IF_isEncUrl'],$showRow[$i]['IF_ID'],$tpl->webPathPart);
						}else{
							$hrefStr = Url::NewsID($showRow[$i]['IF_infoTypeDir'],$showRow[$i]['IF_datetimeDir'],$showRow[$i]['IF_ID']);
						}
						if ($showRow[$i]['IF_isTop'] == 1){
							$topImg='<img src="'. $tpl->webPathPart .'inc_img/share_top.gif" alt="置顶" title="置顶" style="margin-right:5px;" />';
						}else{
							$topImg='';
						}
						$retStr .= '
						<li>
							<div class="addi">&ensp;'. $showRow[$i]['IF_time'] .'</div>
							<a href="'. $hrefStr .'" class="font1_1" style="'. $showRow[$i]['IF_themeStyle'] .'" target="_blank">'. $topImg . $showRow[$i]['IF_theme'] .'</a>
						</li>
						';
					}
					break;

				default :
					for ($i=0; $i<$rowCount; $i++){
						if ($showRow[$i]['IF_URL'] != ''){
							$hrefStr = Url::NewsUrl($showRow[$i]['IF_URL'],$showRow[$i]['IF_isEncUrl'],$showRow[$i]['IF_ID'],$tpl->webPathPart);
						}else{
							$hrefStr = Url::NewsID($showRow[$i]['IF_infoTypeDir'],$showRow[$i]['IF_datetimeDir'],$showRow[$i]['IF_ID']);
						}
						if ($showRow[$i]['IF_isTop'] == 1){
							$topImg = '<img src="'. $tpl->webPathPart .'inc_img/share_top.gif" alt="置顶" title="置顶" style="margin-right:5px;" />';
						}else{
							$topImg = '';
						}
						if ($tpl->sysArr['SYS_newsListUrlMode'] == 'html-2.x'){
							$readAndReplyStr='';
						}else{
							$readAndReplyStr='&ensp;&ensp;评论：'. $showRow[$i]['IF_replyNum'] .'';
							if ($tpl->tplSysArr['TS_isReadNum'] == 1){ $readAndReplyStr='&ensp;&ensp;阅读：'. $showRow[$i]['IF_readNum'] . $readAndReplyStr; }
						}
						$retStr .= '
						<li>
							<div class="addi">&ensp;'. $showRow[$i]['IF_time'] .''. $readAndReplyStr .'</div><h4><a href="'. $hrefStr .'" class="font1_1" style="'. $showRow[$i]['IF_themeStyle'] .'" target="_blank">'. $topImg . TplList::RefFontColor($showRow[$i]['IF_theme']) .'</a></h4>
							<div class="note">'. TplList::RefFontColor($showRow[$i]['IF_contentKey']) .'&ensp;<a href="'. $hrefStr .'" class="font2_2" target="_blank">&ensp;阅读全文&gt;&gt;</a></div><div class="clr"></div>
							<div class="mark">'. TplIndex::MarkStr($showRow[$i]['IF_themeKey']) .'</div>
						</li>
						';
					}
					break;
			
			}

			$retStr .= '
			</ul><div class="clr"></div>

			<center>'. TplList::NewsListNav($typeStr,$listHtmlName,$tpl->typeID,$tpl->page,$pageCount,$pageSize,$recordCount) .'</center>
			</div>
			';
		}
		unset($showRow);

		if ($judGet){
			return $retStr;
		}else{
			echo($retStr);
		}
	}
}
?>