<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class AppIdcVps{
	public static $appName = 'IDC云服务器模块';


	// 获取配置信息
	public static function GetConfArr($type, $dataID, $dataArr=array()){
		global $DB;

		switch ($type){
			case 'kaitong':
				$dataArr = array(
					'usersField'	=> ',VAU_payMode,VAU_system,VAU_vpsPwd',
					'state'			=> 3,
					'stateCN'		=> '待开通',
					);
				break;

			case 'zhuanzheng':
				$dataArr = array(
					'usersField'	=> ',VAU_workId',
					'state'			=> 12,
					'stateCN'		=> '试用',
					);
				break;

			case 'xufei': case 'update': case 'auth':
				$dataArr = array(
					'usersField'	=> ',VAU_workId',
					'state'			=> 10,
					'stateCN'		=> '开通',
					);
				break;

			case 'sync':
				$dataArr = array(
					'usersField'	=> ',VAU_orderId,VAU_workId',
					'state'			=> 10,
					'stateCN'		=> '开通',
					);
				break;

			default :
				return array('res'=>false,'note'=>'获取配置信息模式错误['. $type .']');
				break;
		}

		$recexe = $DB->query('select VAU_proDataID,VAU_comServID,VAU_username,VAU_vpsName,VAU_endTime,VAU_state'. $dataArr['usersField'] .' from '. OT_dbPref .'vpsApiUsers where VAU_ID='. $dataID);
			if (! $ru = $recexe->fetch()){ return array('res'=>false,'note'=>'搜索不到相关记录['. $dataID .']'); }
			if ($ru['VAU_state'] != $dataArr['state'] && $type != 'sync'){ return array('res'=>false,'note'=>'云服务器状态不是'. $dataArr['stateCN'] .'状态['. $ru['VAU_state'] .']'); }

		$proexe = $DB->query('select VAD_typeID,VAD_pcountry,VAD_ptype,VAD_pname,VAD_comProID,VAD_comServID,VAD_rateDayApi,VAD_rateWeekApi,VAD_rateMonthApi,VAD_rate3MonthApi,VAD_rate6MonthApi,VAD_rateYearApi,VAD_rate2YearApi,VAD_rate3YearApi,VAD_rate4YearApi,VAD_rate5YearApi from '. OT_dbPref .'vpsApiData where VAD_ID='. $ru['VAU_proDataID']);
			if (! $row = $proexe->fetch()){ return array('res'=>false,'note'=>'搜索不到相关产品记录['. $ru['VAU_proDataID'] .']'); }

		$typeexe = $DB->query('select VT_classID,VT_companyID from '. OT_dbPref .'vpsType where VT_ID='. $row['VAD_typeID'] .'');
			if (! $row2 = $typeexe->fetch()){ return array('res'=>false,'note'=>'搜索不到产品类型['. $row['VAD_typeID'] .']'); }
			if ($row2['VT_classID'] != 2){ return array('res'=>false,'note'=>'该通道只处理云服务器的['. $row2['VT_classID'] .']'); }

		$companyexe = $DB->query('select VC_apiID,VC_apiDomain,VC_apiUsername,VC_apiUserPwd from '. OT_dbPref .'vpsCompany where VC_ID='. $row2['VT_companyID'] .'');
			if (! $rs = $companyexe->fetch()){ return array('res'=>false,'note'=>'搜索不到上级渠道商记录['. $row2['VT_companyID'] .']'); }

		return array_merge($ru, $row, $row2, $rs);
	}


	// 开通
	public static function Kaitong($dataID){
		global $DB;

		$confArr = self::GetConfArr('kaitong',$dataID);
			if (isset($confArr['res'])){ return $confArr; }

		$paraArr = array('dataID' => $dataID);
		switch ($confArr['VC_apiID']){
			case 1:		// 星外
				return AppXingwai::ApiVpsKaitong($confArr, $paraArr);

			case 2:		// 景安
				return AppJingan::ApiVpsKaitong($confArr, $paraArr);

			case 6:		// 网钛IDC
				return AppIdccms::ApiVpsKaitong($confArr, $paraArr);

			default :
				return array('res'=>false, 'note'=>'接口信息错误（'. $confArr['VC_apiID'] .'）');
		}
	}


	// 转正
	public static function Zhuanzheng($payMode, $endTime, $dataID){
		global $DB;

		$confArr = self::GetConfArr('zhuanzheng',$dataID);
			if (isset($confArr['res'])){ return $confArr; }

		$paraArr = array('payMode' => $payMode, 'endTime' => $endTime, 'dataID' => $dataID);
		switch ($confArr['VC_apiID']){
			case 2:		// 景安
				return AppJingan::ApiVpsZhuanzheng($confArr, $paraArr);
		
			default :
				return array('res'=>false, 'note'=>'接口信息错误（'. $confArr['VC_apiID'] .'）');
		}
	}


	// 续费
	public static function Xufei($payMode, $price, $cost, $endTime, $dataID, $paramArr=array()){
		global $DB;

		$confArr = self::GetConfArr('xufei',$dataID);
			if (isset($confArr['res'])){ return $confArr; }

		$paraArr = array_merge(array('payMode' => $payMode, 'price' => $price, 'cost' => $cost, 'endTime' => $endTime, 'dataID' => $dataID), $paramArr);
		switch ($confArr['VC_apiID']){
			case 1:		// 星外
				return AppXingwai::ApiVpsXufei($confArr, $paraArr);

			case 2:		// 景安
				return AppJingan::ApiVpsXufei($confArr, $paraArr);

			case 6:		// 网钛IDC
				return AppIdccms::ApiVpsXufei($confArr, $paraArr);

			default :
				return array('res'=>false,'note'=>'接口信息错误（'. $confArr['VC_apiID'] .'）');
		}
	}


	// 升级
	public static function Update($newProDataID, $price, $cost, $dataID){
		global $DB;

		$confArr = self::GetConfArr('update',$dataID);
			if (isset($confArr['res'])){ return $confArr; }

		$newProexe = $DB->query('select VAD_theme,VAD_comProID,VAD_pname from '. OT_dbPref .'vpsApiData where VAD_ID='. $newProDataID);
		if (! $row3 = $newProexe->fetch()){ return array('res'=>false,'note'=>'搜索不到相关新产品记录['. $newProDataID .']'); }
		$newProDataName		= $row3['VAD_theme'];

		$paraArr = array('newProDataID' => $newProDataID, 'price' => $price, 'cost' => $cost, 'dataID' => $dataID, 'newProDataName' => $newProDataName);
		switch ($confArr['VC_apiID']){
			case 1:		// 星外
				$newComProID = $row3['VAD_comProID'];
				if ($newComProID == 0){ return array('res'=>false,'note'=>'搜索不到新产品id['. $newProDataID .']'); }
				$paraArr['newComProID'] = $newComProID;

				return AppXingwai::ApiVpsUpdate($confArr, $paraArr);
		
			case 2:		// 景安
				$newPname = $row3['VAD_pname'];
				if ($newPname==''){ return array('res'=>false,'note'=>'搜索不到升级产品名称['. $newPname .']'); }
				$paraArr['newPname'] = $newPname;

				return AppJingan::ApiVpsUpdate($confArr, $paraArr);

			case 6:		// 网钛IDC
				$newComProID = $row3['VAD_comProID'];
				if ($newComProID == 0){ return array('res'=>false,'note'=>'搜索不到新产品id['. $newProDataID .']'); }
				$paraArr['newComProID'] = $newComProID;

				return AppIdccms::ApiVpsUpdate($confArr, $paraArr);
		
			default :
				return array('res'=>false,'note'=>'接口信息错误（'. $confArr['VC_apiID'] .'）');
		}
	}


	// 同步
	public static function Sync($dataID, $mode='api'){
		global $DB;

		$confArr = self::GetConfArr('sync',$dataID);
			if (isset($confArr['res'])){ return $confArr; }

		$paraArr = array('dataID' => $dataID);
		switch ($confArr['VC_apiID']){
			case 1:		// 星外
				return AppXingwai::ApiVpsSync($confArr, $paraArr);

			case 2:		// 景安
				return AppJingan::ApiVpsSync($confArr, $paraArr);

			case 6:		// 网钛IDC
				return AppIdccms::ApiVpsSync($confArr, $paraArr);

			default :
				return array('res'=>false,'note'=>'接口信息错误（'. $confArr['VC_apiID'] .'）');
				break;
		}
	}


	// 实名认证		$dataID：当前记录ID，$authId：已认证的机器业务编码
	public static function Auth($dataID, $authId){
		global $DB;

		$confArr = self::GetConfArr('auth',$dataID);
			if (isset($confArr['res'])){ return $confArr; }

		$paraArr = array('type' => 'vps', 'dataID' => $dataID, 'authId' => $authId);
		switch ($confArr['VC_apiID']){
			case 2:		// 景安
				return AppJingan::ApiAuth($confArr, $paraArr);
		
			default :
				return array('res'=>false,'note'=>'接口信息错误（'. $confArr['VC_apiID'] .'）');
		}
	}
}
?>