<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}

// 网钛IDC财务管理系统(idcCMS) 接口

class ApiIdccms{

	// 云服务器 开通
	// ret=true&vpsName=机器编码&vpsPwd=系统密码&endTime=到期时间&attach=备注信息
	// ret=false&errStr=错误信息
	public static function VpsKaitong($confArr, $type='idcServ', $isRetArr=true){
		$dataArr = array(
			'action'	=> 'kaitong',
			'servID'	=> $confArr['servID'],
			'proID'		=> $confArr['proID'],
			'buyUser'	=> $confArr['buyUser'],
			'vpsName'	=> $confArr['vpsName'],
			'vpsPwd'	=> $confArr['vpsPwd'],
			'payMode'	=> $confArr['payMode'],
			'attach'	=> $confArr['note']
			);
		return self::GetReturn($confArr, $dataArr, $type, '开通云服务器', $isRetArr);
	}


	// 云服务器 续费
	// ret=true&vpsName=机器编码&endTime=到期时间&attach=备注信息
	public static function VpsXufei($confArr, $type='idcServ', $isRetArr=true){
		$dataArr = array(
			'action'	=> 'xufei',
			'buyUser'	=> $confArr['buyUser'],
			'vpsName'	=> $confArr['vpsName'],
			'payMode'	=> $confArr['payMode'],
			'attach'	=> $confArr['note']
			);
		return self::GetReturn($confArr, $dataArr, $type, '续费云服务器', $isRetArr);
	}


	// 云服务器 升级
	// ret=true&vpsName=机器编码&status=ok状态&endTime=到期时间&attach=备注信息
	public static function VpsUpdate($confArr, $type='idcServ', $isRetArr=true){
		$dataArr = array(
			'action'	=> 'shengji',
			'proID'		=> $confArr['proID'],
			'vpsName'	=> $confArr['vpsName'],
			'attach'	=> $confArr['note']
			);
		return self::GetReturn($confArr, $dataArr, $type, '升级云服务器', $isRetArr);
	}


	// 云服务器 查询信息同步
	// ret=true&vpsName=机器编码&vpsPwd=系统密码&ip=IP地址&status=正常&startTime=开通时间&endTime=到期时间&servID=母机ID&proID=产品ID&osType=系统类型（Windows/Linux）&osName=操作系统名称&attach=备注信息
	public static function VpsSync($confArr, $type='idcServ', $isRetArr=true){
		$dataArr = array(
			'action'	=> 'chaxun',
			'vpsName'	=> $confArr['vpsName'],
			'attach'	=> $confArr['note']
			);
		return self::GetReturn($confArr, $dataArr, $type, '查询云服务器', $isRetArr);
	}


	// 云服务器 查询账户信息
	// ret=true&username=用户名userMoney=余额&userRate=折扣比例&attach=备注信息
	public static function UserInfo($confArr, $type='idcServ', $isRetArr=true){
		$dataArr = array(
			'action'	=> 'userInfo',
			'attach'	=> $confArr['note']
			);
		return self::GetReturn($confArr, $dataArr, $type, '查询账户信息', $isRetArr);
	}


	// 提交获取反馈
	public static function GetReturn($confArr, $dataArr, $type, $errName, $isRetArr=true){
		$sysAdminArr = Cache::PhpFile('sysAdmin');

		$dataArr['username'] = $confArr['apiUsername'];
		$dataArr['timeStamp'] = time();
		ksort($dataArr);
		$dataArr['sign'] = md5(implode('',array_values($dataArr)) . $confArr['apiUserPwd']);
		$data = http_build_query($dataArr);
		$getUrlMode = $sysAdminArr['SA_getUrlMode'];

		if (! Is::HttpUrl($confArr['apiDomain'])){ $confArr['apiDomain'] = 'http://'. $confArr['apiDomain']; }
		if (substr($confArr['apiDomain'],-1) != '/'){ $confArr['apiDomain'] .= '/'; }
		if ($type == 'idcServ'){
			$apiFile = 'idcServ.php';
		}else{
			$apiFile = 'vpsApi.php';
		}

		$retArr = ReqUrl::UseAuto($getUrlMode,'POST',$confArr['apiDomain'] . $apiFile, 'UTF-8', $dataArr);
		if (! $retArr['res']){
			return array('res'=>false, 'ori'=>'', 'note'=>$errName .'发生错误:'. $retArr['note']);
		}else{
			$temp = $retArr['note'];
		}

		parse_str($temp, $tempArr);
		if (is_array($tempArr) && isset($tempArr['ret']) && $tempArr['ret']=='true'){
			return array_merge($tempArr, array('res'=>true,'ori'=>$temp));
		}else{
			if ($isRetArr){
				return array('res'=>false, 'ori'=>$temp, 'note'=>$errName .'发生错误:'. $temp);
			}else{
				die($errName .'发生错误:'. $temp);
			}
		}
	}


	// 反馈付款方式对应的费率值
	public static function PayModeToRate($rateArr,$mode,$tabPart='ISP_'){
		switch ($mode){
			case '24hour': case '48hour':	return 999;
			case 'day':			return floatval($rateArr[$tabPart .'rateDayApi']);
			case 'week':		return floatval($rateArr[$tabPart .'rateWeekApi']);
			case 'month':		return floatval($rateArr[$tabPart .'rateMonthApi']);
			case '3month':		return floatval($rateArr[$tabPart .'rate3MonthApi']);
			case '6month':		return floatval($rateArr[$tabPart .'rate6MonthApi']);
			case 'year':		return floatval($rateArr[$tabPart .'rateYearApi']);
			case '2year':		return floatval($rateArr[$tabPart .'rate2YearApi']);
			case '3year':		return floatval($rateArr[$tabPart .'rate3YearApi']);
			case '4year':		return floatval($rateArr[$tabPart .'rate4YearApi']);
			case '5year':		return floatval($rateArr[$tabPart .'rate5YearApi']);
			default :			return -1;
		}
	}
}
?>