<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class StrCN{

	// 会员积分记录 类别
	public static function ScoreType($str){
		$typeArr = self::ScoreTypeArr();

		if (isset($typeArr[$str])){
			return $typeArr[$str];
		}else{
			return '['. $str .']';
		}
	}

	// 会员积分记录 类别
	public static function ScoreTypeArr(){
		return array(
			// 会员类
			'reg'			=> '注册',
			'login'			=> '登录',
			'qiandao'		=> '签到',
			'recom'			=> '邀请',
			'groupKaitong'	=> '会员组开通',
			'groupXufei'	=> '会员组续费',
			'userState1'	=> '会员转正',
			'stateTo'		=> '积分互换',
			// 财务类
			'suff'			=> '用户充值',
			'diyPay'		=> '手动充值',
			'moneyGive'		=> '充值满送',
			'work'			=> '领工资',
			'time'			=> '时长卡密',
			'userScoreMul'	=> '金额兑换积分',
			// 文章类
			'addInfo'		=> '投稿',
			'newsAdd'		=> '投稿',
			'read'			=> '阅读文章',
			'delInfo'		=> '删除文章',
			'newsGain'		=> '文章积分分成',
			'audit1'		=> '文章审核',
			'audit0'		=> '文章拒审',
			// 其他
			'infoMessage'	=> '评论',
			'message'		=> '留言',
			'bbsWriteAdd'	=> '论坛发帖',
			'bbsReplyAdd'	=> '帖子回复',
			'gift'			=> '积分兑换',
			'getGift'		=> '抽奖',
			'orders'		=> '订单记录',
			'taokeOrder'	=> '淘宝订单结算',
			'workCenter'	=> '任务',
			'admin'			=> '后台',
			'other'			=> '其他'
			);
	}

	// 积分商城 用户兑换记录 状态
	public static function GiftUsersState($num){
		switch ($num){
			case -2:	return '<span style="color:red;">待付款</span>';
			case -1:	return '<span style="color:red;">作废</span>';
			case 0:		return '<span style="color:#000;">待审核</span>';
			case 1:		return '<span style="color:green;">待发货</span>';
			case 2:		return '<span style="color:blue;font-weight:bold;">已发货</span>';
			case 3:		return '<span style="color:blue;font-weight:bold;">自动发货</span>';
			default:	return '['. $num .']';
		}
	}

	// 会员订单记录 状态
	public static function BuyOrdersState($num){
		switch ($num){
			case -1:	return '<span style="color:red;">作废</span>';
			case 0:		return '<span style="color:#000;">待审核</span>';
			case 1:		return '<span style="color:green;">待结算</span>';
			case 2:		return '<span style="color:blue;">已结算</span>';
			case 9:		return '<span style="color:blue;">已完成</span>';
			case 10:	return '<span style="color:#000;">记录</span>';
			default :	return '['. $num .']';
		}
	}

	// 邀请好友 状态
	public static function RecomState($num){
		switch ($num){
			case 1:		return '<span style="color:green;">有效</span>';		
			case 0:		return '<span style="color:red;">无效</span>';		
			default :	return '['. $num .']';
		}
	}

	// 推广提现 提现状态
	public static function GainMoneyState($num){
		switch ($num){
			case 9:		return '<span style="color:red;">已拒绝</span>';		
			case 6:		return '<span style="color:red;">处理失败</span>';		
			case 1:		return '<span style="color:green;">已处理</span>';		
			case 0:		return '<span style="color:#000;">待处理</span>';		
			default :	return '['. $num .']';
		}
	}

	// 推广提现 佣金记录状态
	public static function GainItemState($num, $mode=''){
		switch ($num){
			case 9:		return $mode=='cn' ? '已退款' : '<span style="color:red;">已退款</span>';		
			case 6:		return $mode=='cn' ? '处理失败' : '<span style="color:red;">处理失败</span>';		
			case 1:		return $mode=='cn' ? '已结算' : '<span style="color:green;">已结算</span>';		
			case 0:		return $mode=='cn' ? '待结算' : '<span style="color:#000;">待结算</span>';		
			default :	return '['. $num .']';
		}
	}

	// 推广提现 产品类型
	public static function GainItemType($str){
		switch ($str){
			case 'taoke':	return '淘客';
			case 'domain':	return '域名';
			case 'host':	return '虚拟主机';
			case 'vpsPro':	return '云主机';
			case 'vpsApi':	return '云服务器';
			case 'dialing':	return '拨号VPS';
			case 'pptp':	return 'PPTP';
			case 'serv':	return '服务器租用';
			case 'ssl':		return 'SSL证书';
			case 'other':	return '其他';
			default :		return '['. $str .']';
		}
	}

	// 未付/已付
	public static function IsPay($num, $mode=''){
		switch ($num){
			case 2:		return $mode=='cn' ? '已付(GET网址反馈)' : '<span style="color:green;" title="GET网址反馈">已付2</span>';	// 客户端反馈
			case 1:		return $mode=='cn' ? '已付(服务端反馈)' : '<span style="color:green;" title="服务端反馈">已付</span>';		// 服务端反馈
			case 0:		return $mode=='cn' ? '未付' : '<span style="color:red;">未付</span>';
			default:	return $num;
		}
	}


	// 打赏类型
	public static function DashangIcoCN($str,$mode=''){
		switch ($str){
			case 'weixin':
				if ($mode=='color'){
					return '#4cbe0d';
				}elseif ($mode=='theme'){
					return '微信扫一扫，打赏作者吧～';
				}else{
					return '微信';
				}
				break;
		
			case 'alipay':
				if ($mode=='color'){
					return '#089fd2';
				}elseif ($mode=='theme'){
					return '支付宝扫一扫，打赏作者吧～';
				}else{
					return '支付宝';
				}
				break;
		
			case 'qq':
				if ($mode=='color'){
					return '#0bb2ff';
				}elseif ($mode=='theme'){
					return 'QQ扫一扫，打赏作者吧～';
				}else{
					return 'QQ钱包';
				}
				break;
		
			case 'baifubao':
				if ($mode=='color'){
					return '#d70100';
				}elseif ($mode=='theme'){
					return '百度钱包扫一扫，打赏作者吧～';
				}else{
					return '百度钱包';
				}
				break;
		
			default :			return $str;
				break;
		}
	}

	// 登录状态保存时间
	public static function LoginExp($num){
		switch ($num){
			case 1:		return '30天';
			case 2:		return '15天';
			case 3:		return '7天';
			case 4:		return '3天';
			case 5:		return '1天';
			case 21:	return '12小时';
			case 22:	return '6小时';
			case 23:	return '3小时';
			case 24:	return '2小时';
			case 25:	return '1小时';
			case 31:	return '30分钟';
			case 32:	return '15分钟';
			default:	return $num;
		}
	}

	// 网址跳转 来源类型
	public static function GoUrlTypeCN($str){
		switch ($str){
			case 'alipay':		return '支付宝';
			case 'weixin':		return '微信';
			case 'QQ':			return 'QQ';
			case 'IE':			return 'IE浏览器';
			case 'opera':		return 'opera浏览器';
			case 'chrome':		return '谷歌浏览器';
			case 'safari':		return '苹果浏览器';
			case 'firefox':		return '火狐浏览器';
			case 'android':		return '安卓手机';
			case 'iphone':		return '苹果手机';
			case 'other':		return '其他';
			default:			return $str;
		}
	}

	// 检查收录情况 状态
	public static function ResCN($str, $num, $mode=''){
		switch ($num){
			case 0:		return $mode=='cn' ? '未检测' : '<span style="color:#c9c9c9;" title="'. $str .'未检测">['. $str .'-]</span>';		
			case 1:		return $mode=='cn' ? '已收录' : '<span style="color:green;" title="'. $str .'已收录">['. $str .'√]</span>';		
			case 2:		return $mode=='cn' ? '已收录API' : '<span style="color:green;" title="'. $str .'已收录（API）">['. $str .'★]</span>';		
			case 11:	return $mode=='cn' ? '未收录' : '<span style="color:red;" title="'. $str .'未收录">['. $str .'×]</span>';		
			case 12:	return $mode=='cn' ? '未收录API' : '<span style="color:red;" title="'. $str .'未收录（API）">['. $str .'✖]</span>';		
			default :	return '['. $num .']';
		}
	}

	// 举报类型
	public static function ReportTypeCN($str){
		switch ($str){
			case 'info':	return '文章';
			case 'reply':	return '评论';
			case 'message':	return '留言';
			default :		return '['. $str .']';
		}
	}

	// 阅读状态
	public static function ReadState($num){
		switch ($num){
			case 0:		return '<span style="color:red;">未读</span>';
			case 1:		return '<span>已读</span>';
			default :	return '['. $num .']';
		}
	}

	// 代理子用户 状态
	public static function AgentUsersState($num){
		switch ($num){
			case 1:		return '<span style="color:green;">启用</span>';		
			case 0:		return '<span style="color:red;">禁用</span>';		
			default :	return '['. $num .']';
		}
	}


	// 获取tabField表类型中文
	public static function TabFieldType($type){
		switch ($type){
			case 'apiUsers':	return '数据同步API';
			case 'onePage':		return '功能单页';
			default :			return '['. $type .']';
		}
	}


	// 通过访问者Agent判断浏览器
	public static function BrowserArr($agent){
		$retArr = null;
		if(stripos($agent, 'AlipayClient') !== false){
			$retArr = array('type'=>'alipay',		'name'=>'支付宝');

		}elseif(stripos($agent, 'MicroMessenger') !== false){
			$retArr = array('type'=>'weixin',		'name'=>'微信');

		}elseif(stripos($agent, 'NewsArticle') !== false || stripos($agent, 'TTWebView') !== false){
			$retArr = array('type'=>'toutiaoApp',	'name'=>'今日头条app');

		}elseif(stripos($agent, 'Quark') !== false){
			$retArr = array('type'=>'quark',		'name'=>'夸克app');

		}elseif(stripos($agent, 'VivoBrowser') !== false){
			$retArr = array('type'=>'vivoPhone',	'name'=>'vivo手机浏览器');

		}elseif(stripos($agent, 'HuaweiBrowser') !== false){
			$retArr = array('type'=>'huaweiPhone',	'name'=>'华为手机浏览器');

		}elseif(stripos($agent, 'HeyTapBrowser') !== false || stripos($agent, 'OppoBrowser') !== false){
			$retArr = array('type'=>'oppoPhone',	'name'=>'OPPO手机浏览器');

		}elseif(stripos($agent, 'MiuiBrowser') !== false){
			$retArr = array('type'=>'miBrowser',	'name'=>'小米手机浏览器');

		}elseif(stripos($agent, 'SogouMobileBrowser') !== false){
			$retArr = array('type'=>'sogouBrowser',	'name'=>'搜狗手机浏览器');

		}elseif(stripos($agent, 'SogouBrowser') !== false || stripos($agent, 'SE 2.X MetaSr') !== false){	//  || stripos($agent, 'SE&ensp;2.X&ensp;MetaSr') !== false
			$retArr = array('type'=>'sogouBrowser',	'name'=>'搜狗浏览器');

		}elseif(stripos($agent, 'UCBrowser') !== false || stripos($agent, 'UCWEB') !== false){
			$retArr = array('type'=>'ucBrowser',	'name'=>'UC浏览器');

		}elseif(stripos($agent, '360se') !== false || stripos($agent, '360 Alitephone Browser') !== false){	//  || stripos($agent, '360&ensp;Alitephone&ensp;Browser') !== false
			$retArr = array('type'=>'360Browser',	'name'=>'360浏览器');

		}elseif(stripos($agent, 'MQQBrowser') !== false){
			$retArr = array('type'=>'qqBrowser',	'name'=>'QQ手机浏览器');

		}elseif(stripos($agent, 'TencentTraveler') !== false || stripos($agent, 'QQBrowser') !== false){
			$retArr = array('type'=>'qqBrowser',	'name'=>'QQ浏览器');

		}elseif(stripos($agent, 'baidubrowser') !== false){
			$retArr = array('type'=>'baiduBrowser',	'name'=>'百度浏览器');

		}elseif(stripos($agent, 'LieBaoFast') !== false){
			$retArr = array('type'=>'lieBaoBrowser','name'=>'猎豹浏览器');

		}elseif(stripos($agent, 'Maxthon') !== false){
			$retArr = array('type'=>'maxthon',		'name'=>'遨游浏览器');

		}elseif(stripos($agent, 'Edg/') !== false){ 
			$retArr = array('type'=>'edge',			'name'=>'Edge浏览器');

		}elseif(stripos($agent, 'Opera') !== false) {
			$retArr = array('type'=>'opera',		'name'=>'opera浏览器');

		}elseif(stripos($agent, 'Firefox') !== false){
			$retArr = array('type'=>'firefox',		'name'=>'火狐浏览器');

		}elseif(stripos($agent, 'BytedanceWebview') !== false){
			$retArr = array('type'=>'bytedance',	'name'=>'字节跳动浏览器');

		}elseif(stripos($agent, 'QQ') !== false){ 
			$retArr = array('type'=>'QQ',			'name'=>'QQ');

		}elseif(stripos($agent, 'MSIE') !== false){
			$retArr = array('type'=>'IE',			'name'=>'IE浏览器');

		}elseif(stripos($agent, 'Safari') !== false && stripos($agent, 'chrome') === false){
			$retArr = array('type'=>'safari',		'name'=>'苹果浏览器');

		}elseif(stripos($agent, 'android') !== false){
			$retArr = array('type'=>'android',		'name'=>'安卓');

		}elseif(stripos($agent,'iphone') !== false || stripos($agent, 'ipad') !== false){
			$retArr = array('type'=>'iphone',		'name'=>'苹果');

		}elseif(stripos($agent, 'Chrome') !== false){
			$retArr = array('type'=>'chrome',		'name'=>'谷歌浏览器/未知');

		}
		return $retArr;
	}


	// 通过访问者Agent判断蜘蛛名称
	public static function RobotArr($agent){
		$retArr = null;
		if(stripos($agent, 'Baiduspider-image') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-image',	'name'=>'百度图片');

		}elseif(stripos($agent, 'Baiduspider-video') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-video',	'name'=>'百度视频');

		}elseif(stripos($agent, 'Baiduspider-news') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-news',	'name'=>'百度新闻');

		}elseif(stripos($agent, 'Baiduspider-favo') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-favo',	'name'=>'百度搜藏');

		}elseif(stripos($agent, 'Baiduspider-cpro') !== false) {
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-cpro',	'name'=>'百度联盟');

		}elseif(stripos($agent, 'Baiduspider-render') !== false) {
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-render',	'name'=>'百度渲染');

		}elseif(stripos($agent, 'baiduboxapp') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'baiduboxapp',			'name'=>'百度app');

		}elseif(stripos($agent, 'Baiduspider-mobile') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider-mobile',	'name'=>'百度移动');

		}elseif(stripos($agent, 'Baiduspider') !== false){
			$retArr = array('type'=>'baidu',	'type2'=>'Baiduspider',			'name'=>'百度蜘蛛');

		}elseif(stripos($agent, 'Googlebot-Image') !== false){
			$retArr = array('type'=>'google',	'type2'=>'Googlebot-Image',		'name'=>'谷歌图片');

		}elseif(stripos($agent, 'Googlebot-Video') !== false){
			$retArr = array('type'=>'google',	'type2'=>'Googlebot-Video',		'name'=>'谷歌视频');

		}elseif(stripos($agent, 'Google-Read-Aloud') !== false){
			$retArr = array('type'=>'google',	'type2'=>'Google-Read-Aloud',	'name'=>'谷歌蜘蛛');

		}elseif(stripos($agent, 'Googlebot-Mobile') !== false){
			$retArr = array('type'=>'google',	'type2'=>'Googlebot-Mobile',	'name'=>'谷歌移动');

		}elseif(stripos($agent, 'GoogleBot') !== false){
			$retArr = array('type'=>'google',	'type2'=>'GoogleBot',			'name'=>'谷歌蜘蛛');

		}elseif(stripos($agent, '360Spider') !== false){
			$retArr = array('type'=>'360',		'type2'=>'360Spider',			'name'=>'360蜘蛛');

		}elseif(stripos($agent,'SogouSpider') !== false || stripos($agent,'Sogou web spider') !== false){
			$retArr = array('type'=>'sogou',	'type2'=>'SogouSpider',			'name'=>'搜狗蜘蛛');

		}elseif(stripos($agent, 'YisouSpider') !== false){
			$retArr = array('type'=>'shenma',	'type2'=>'YisouSpider',			'name'=>'神马蜘蛛');

		}elseif(stripos($agent, 'bingbot') !== false){
			$retArr = array('type'=>'bing',		'type2'=>'bingbot',				'name'=>'必应蜘蛛');

		}elseif(stripos($agent, 'Bytespider') !== false){
			$retArr = array('type'=>'toutiao',	'type2'=>'Bytespider',			'name'=>'头条蜘蛛');

		}elseif(stripos($agent, 'AspiegelBot') !== false){
			$retArr = array('type'=>'huawei',	'type2'=>'AspiegelBot',			'name'=>'华为蜘蛛');

		}elseif(stripos($agent, 'YoudaoBot') !== false || stripos($agent,'YodaoBot') !== false){
			$retArr = array('type'=>'youdao',	'type2'=>'YoudaoBot',			'name'=>'有道蜘蛛');

		}elseif(stripos($agent, 'msnbot') !== false){
			$retArr = array('type'=>'msn',		'type2'=>'msnbot',				'name'=>'MSN蜘蛛');

		}elseif(stripos($agent, 'Yahoo!') !== false){
			$retArr = array('type'=>'yahoo',	'type2'=>'Yahoo',				'name'=>'雅虎蜘蛛');

		}elseif(stripos($agent, 'YandexBot') !== false){
			$retArr = array('type'=>'yandex',	'type2'=>'YandexBot',			'name'=>'俄罗斯搜索');

		}elseif(stripos($agent, 'DNSPod-Monitor') !== false){
			$retArr = array('type'=>'DNSPod',	'type2'=>'DNSPod-Monitor',		'name'=>'DNSPOD监控');

		}elseif(stripos($agent, 'MJ12bot') !== false){
			$retArr = array('type'=>'MJ12',		'type2'=>'MJ12bot',				'name'=>'英国SEO分析');

		}elseif(stripos($agent, 'SemrushBot') !== false){
			$retArr = array('type'=>'semrush',	'type2'=>'SemrushBot',			'name'=>'美国SEO分析');

		}elseif(stripos($agent, 'AhrefsBot') !== false){
			$retArr = array('type'=>'ahrefs',	'type2'=>'AhrefsBot',			'name'=>'国外SEO分析');

		}
		return $retArr;
	}

}

?>