<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class PayInfo{

	// 在线支付 类型
	public static function TypeCN($str, $str2=''){
		switch ($str){
			case 'userMoney':	return '余额';
			case 'tenpay':		return '财付通';
			case 'qqpay':		return 'QQ钱包';
			case 'alipay':		return '支付宝';
			case 'weixin':
			case 'wxpay':		return '微信';
			case 'f2fpay':		return '当面付';
			case 'jdpay':		return '京东';
			case 'bank':		return '云闪付';
			case 'diypay':		return '自定义支付';
			case 'codepay':
				if ($str2 == 'alipay'){
					return '[码]支付宝';
				}elseif ($str2 == 'qqpay'){
					return '[码]QQ钱包';
				}elseif ($str2 == 'weixin'){
					return '[码]微信';
				}else{
					return '码支付';
				}
			case 'epay':
				if ($str2 == 'alipay'){
					return '[易]支付宝';
				}elseif ($str2 == 'wxpay'){
					return '[易]微信支付';
				}elseif ($str2 == 'qqpay'){
					return '[易]QQ钱包';
				}elseif ($str2 == 'jdpay'){
					return '[易]京东支付';
				}elseif ($str2 == 'bank'){
					return '[易]云闪付';
				}else{
					return '易支付';
				}
			case 'hpjpay':
				if ($str2 == 'alipay'){
					return '[HPJ]支付宝';
				}elseif ($str2 == 'weixin'){
					return '[HPJ]微信';
				}else{
					return '虎皮椒支付';
				}
			default:			return $str;
		}
	}


	// 在线支付 付款方式 数组
	public static function ModeArr($str=''){
		$retArr = array(
			'suff'		=> '充值',
			'pay'		=> '支付',
			'buy'		=> '购买',
			'goods'		=> '购买商品',
			'web'		=> '付款',
			'regCode'		=> '注册邀请码',
			'infoRead'		=> '文章付费阅读',
			'groupKaitong'	=> '会员组开通',
			'groupXufei'	=> '会员组续费',
			'dashang'		=> '文章打赏',
			'authSoft'		=> '授权软件',
			'diyPay'		=> '手动充值',
			'quan'			=> '卡密自动销售',
			'quan1'			=> '卡密自动销售渠道1',
			'quan2'			=> '卡密自动销售渠道2',
			'quan3'			=> '卡密自动销售渠道3',
			'quan4'			=> '卡密自动销售渠道4',
			'quan5'			=> '卡密自动销售渠道5'
			);
		if ($str == 'key'){
			return array_keys($retArr);
		}else{
			return $retArr;
		}
	}

	// 在线支付 付款方式
	public static function ModeCN($str, $def=null){
		$arr = self::ModeArr();
		if (isset($arr[$str])){
			return $arr[$str];
		}else{
			if ($def == null){
				return '['. $str .']';
			}else{
				return $def;
			}
		}
	}

	// 进出账 类型数组
	public static function RecordTypeArr($str=''){
		$retArr = array(
			'diy'			=> '手动',
			'host'			=> '虚拟主机',
			'vpsPro'		=> '云主机',
			'vpsApi'		=> '云服务器',
			'serv'			=> '服务器租用',
			'domain'		=> '域名',
			'suff'			=> '充值',
			'tixian'		=> '提现',
			'moneyPay'		=> '在线支付',
			'workCenter'	=> '任务中心',
			'moneyGive'		=> '充值满送',
			'userScoreMul'	=> '金额兑换积分',
			'quan'			=> '卡密卡券',
			'groupXufei'	=> '会员组续费',
			'groupKaitong'	=> '会员组开通',
			'groupWork'		=> '领工资',
			'userState1'	=> '会员转正',
			'diyPay'		=> '手动充值',
			'taoke'			=> '淘客',
			'taokeOrder'	=> '淘宝订单',
			'authSoft'		=> '授权软件',
			'admin'			=> '后台',
			'system'		=> '系统',
			'dashang'		=> '打赏',
			'admin'			=> '后台'
			);
		if ($str == 'key'){
			return array_keys($retArr);
		}else{
			return $retArr;
		}
	}

	// 进出账 类型
	public static function RecordTypeCN($str, $def=null){
		$arr = self::RecordTypeArr();
		if (isset($arr[$str])){
			return $arr[$str];
		}else{
			if ($def == null){
				return '['. $str .']';
			}else{
				return $def;
			}
		}
	}

	// 在线支付 直接支付类型 数组
	public static function QuickTypeArr($str=''){
		$retArr = array(
			'regCode'		=> '注册邀请码',
			'infoRead'		=> '文章付费阅读',
			'groupKaitong'	=> '会员组开通',
			'groupXufei'	=> '会员组续费',
			'dashang'		=> '文章打赏',
			'authSoft'		=> '授权软件',
			'quan'			=> '卡密自动销售',
			'quan1'			=> '卡密自动销售渠道1',
			'quan2'			=> '卡密自动销售渠道2',
			'quan3'			=> '卡密自动销售渠道3',
			'quan4'			=> '卡密自动销售渠道4',
			'quan5'			=> '卡密自动销售渠道5'
			);
		if ($str == 'key'){
			return array_keys($retArr);
		}else{
			return $retArr;
		}
	}

	// 在线支付 付款方式
	public static function QuickTypeCN($str, $def='empty'){
		$arr = self::QuickTypeArr();
		if (isset($arr[$str])){
			return $arr[$str];
		}else{
			if ($def == 'empty'){
				return '['. $str .']';
			}else{
				return $def;
			}
		}
	}


	// 颜色数值比较显示 >=$minNum 显示 红色或自定义色  否则 默认黑色
	public static function ColorThan($num, $color='red', $minNum=1){
		if ($num >= $minNum){
			return '<span style="color:'. $color .'">'. $num .'</span>';
		}else{
			return $num;
		}
	}


	// 颜色数值显示 >0 蓝色 <0 红色  =0黑色
	public static function ColorNum($num, $remMoney=0){
		if ($remMoney == -9){
			return '';
		}elseif ($remMoney == -7){
			return $num;
		}elseif ($num > 0){
			return '<span style="color:green;">+ '. $num .'</span>';
		}elseif ($num < 0){
			return '<span style="color:red;">'. str_replace('-','- ',$num) .'</span>';
		}else{
			return $num;
		}
	}

	// 账户余额处理
	public static function RemMoney($num){
		if (in_array($num, array(-9,-8,-7))){	// -9发生额和余额都不显示；-8余额不显示，发生额有+-符；-8余额不显示，发生额无+-符
			return '';
		}elseif ($num < 0){
			return '<span style="color:red;">'. str_replace('-','- ',$num) .'</span>';
		}else{
			return $num;
		}
	}

}

?>