<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class IdcInfo{

	// 类型
	public static function TypeCN($str){
		switch ($str){
			case 'domain':	return '域名';
			case 'host':	return '虚拟主机';
			case 'vpsPro':	return '云主机';
			case 'vpsApi':	return '云服务器';
			case 'dialing':	return '拨号VPS';
			case 'pptp':	return 'PPTP';
			case 'serv':	return '服务器租用';
			case 'ssl':		return 'SSL证书';
			case 'other':	return '其他';
			default :		return '['. $str .']';
		}
	}


	// 详细页文件
	public static function DetFile($str){
		switch ($str){
			case 'domain':		return 'domainData.php';
			case 'host':		return 'hostUsers.php';
			case 'vpsApi':		return 'vpsApiUsers.php';
			case 'dialing':		return 'dialingUsers.php';
			case 'serv':		return 'servUsers.php';
			case 'ssl':			return 'sslUsers.php';
			default :			return '['. $str .']';
		}
	}

	// 付费方式
	public static function PayMode($str){
		switch ($str){
			case 'doing':		return '开通中';
			case '24hour': case '48hour':		return '试用';
//			case '24hour':		return '试用24小时';
//			case '48hour':		return '试用48小时';
			case 'day':			return '日付';
			case 'week':		return '周付';
			case 'month':		return '月付';
			case '3month':		return '季付';
			case '6month':		return '半年付';
			case 'year':		return '年付';
			case '2year':		return '二年付';
			case '3year':		return '三年付';
			case '4year':		return '四年付';
			case '5year':		return '五年付';
			default :			return '['. $str .']';
		}
	}

	// 付费方式对应字段
	public static function PayModeField($str, $part=''){
		switch ($str){
			case 'day':			return array('price'=>$part .'priceDay', 'cost'=>$part .'costDay');
			case 'week':		return array('price'=>$part .'priceWeek', 'cost'=>$part .'costWeek');
			case 'month':		return array('price'=>$part .'priceMonth', 'cost'=>$part .'costMonth');
			case '3month':		return array('price'=>$part .'price3Month', 'cost'=>$part .'cost3Month');
			case '6month':		return array('price'=>$part .'price6Month', 'cost'=>$part .'cost6Month');
			case 'year':		return array('price'=>$part .'priceYear', 'cost'=>$part .'costYear');
			case '2year':		return array('price'=>$part .'price2Year', 'cost'=>$part .'cost2Year');
			case '3year':		return array('price'=>$part .'price3Year', 'cost'=>$part .'cost3Year');
			case '4year':		return array('price'=>$part .'price4Year', 'cost'=>$part .'cost4Year');
			case '5year':		return array('price'=>$part .'price5Year', 'cost'=>$part .'cost5Year');
			default :			JS::AlertEnd('PayModeField '. $str);
		}
	}

	// 付费时间
	public static function PayTime($str){
		switch ($str){
			case '24hour':		return '试用1天';
			case '48hour':		return '试用2天';
			case 'day':			return '一天';
			case 'week':		return '一周';
			case 'month':		return '一个月';
			case '3month':		return '一季度';
			case '6month':		return '半年';
			case 'year':		return '一年';
			case '2year':		return '二年';
			case '3year':		return '三年';
			case '4year':		return '四年';
			case '5year':		return '五年';
			default :			return '['. $str .']';
		}
	}

	// 状态
	public static function State($num, $mode=''){
		switch ($num){
			case 15:	return $mode=='cn'?'续费中':'<span style="color:blue;">续费中</span>';
			case 12:	return $mode=='cn'?'试用中':'<span style="color:blue;">试用中</span>';
			case 10:	return '正常';
			case 9:		return $mode=='cn'?'已退款':'<span style="color:red;">已退款</span>';
			case 8:		return $mode=='cn'?'退款中':'<span style="color:red;">退款中</span>';
			case 6:		return $mode=='cn'?'开通失败':'<span style="color:red;">开通失败</span>';
			case 5:		return $mode=='cn'?'开通中':'<span style="color:blue;">开通中</span>';
			case 3:		return $mode=='cn'?'待开通':'<span style="color:green;">待开通</span>';
			case 0:		return $mode=='cn'?'停止':'<span style="color:red;">停止</span>';
			default :	return '['. $num .']';
		}
	}

	// 开通期限
	public static function UseTimeStrCN($str){
		$strArr = array();
		if (strpos($str,'|24hour|') !== false){ $strArr[] = '试用24小时'; }
		if (strpos($str,'|48hour|') !== false){ $strArr[] = '试用48小时'; }
		if (strpos($str,'|day|') !== false){ $strArr[] = '日付'; }
		if (strpos($str,'|week|') !== false){ $strArr[] = '周付'; }
		if (strpos($str,'|month|') !== false){ $strArr[] = '月付'; }
		if (strpos($str,'|3month|') !== false){ $strArr[] = '季付'; }
		if (strpos($str,'|6month|') !== false){ $strArr[] = '半年付'; }
		if (strpos($str,'|year|') !== false){ $strArr[] = '一年付'; }
		if (strpos($str,'|2year|') !== false){ $strArr[] = '二年付'; }
		if (strpos($str,'|3year|') !== false){ $strArr[] = '三年付'; }
		if (strpos($str,'|4year|') !== false){ $strArr[] = '四年付'; }
		if (strpos($str,'|5year|') !== false){ $strArr[] = '五年付'; }
		return implode('，',$strArr);
	}


	// 云主机/云服务器/服务器租用 付款时间代理价格
	public static function VpsAgentPrice($payMode, $payPrice){
		$price = 99999;
		switch ($payMode){
			case 'month':		$price = floatval($payPrice);		break;
			case '3month':		$price = floatval($payPrice)*3;		break;
			case '6month':		$price = floatval($payPrice)*6;		break;
			case 'year':		$price = floatval($payPrice)*10;	break;
			case '2year':		$price = floatval($payPrice)*20;	break;
			case '3year':		$price = floatval($payPrice)*30;	break;
			case '4year':		$price = floatval($payPrice)*40;	break;
			case '5year':		$price = floatval($payPrice)*50;	break;
		}
		return $price;
	}

	// 云主机/云服务器/服务器租用 付款时间价格
	public static function VpsPayPrice($payMode, $dataArr, $pref){
		$price = 99999;
		switch ($payMode){
			case 'day':			$price = floatval($dataArr[$pref .'priceDay']);		break;
			case 'week':		$price = floatval($dataArr[$pref .'priceWeek']);	break;
			case 'month':		$price = floatval($dataArr[$pref .'priceMonth']);	break;
			case '3month':		$price = floatval($dataArr[$pref .'price3Month']);	break;
			case '6month':		$price = floatval($dataArr[$pref .'price6Month']);	break;
			case 'year':		$price = floatval($dataArr[$pref .'priceYear']);	break;
			case '2year':		$price = floatval($dataArr[$pref .'priceYear'])*2;	break;
			case '3year':		$price = floatval($dataArr[$pref .'priceYear'])*3;	break;
			case '4year':		$price = floatval($dataArr[$pref .'priceYear'])*4;	break;
			case '5year':		$price = floatval($dataArr[$pref .'priceYear'])*5;	break;
		}
		return $price;
	}

	// 云主机/云服务器/服务器租用 付款时间成本
	public static function VpsPayCost($payMode, $dataArr, $pref){
		$cost = 99999;
		switch ($payMode){
			case 'day':			$cost = floatval($dataArr[$pref .'costDay']);		break;
			case 'week':		$cost = floatval($dataArr[$pref .'costWeek']);		break;
			case 'month':		$cost = floatval($dataArr[$pref .'costMonth']);		break;
			case '3month':		$cost = floatval($dataArr[$pref .'cost3Month']);	break;
			case '6month':		$cost = floatval($dataArr[$pref .'cost6Month']);	break;
			case 'year':		$cost = floatval($dataArr[$pref .'costYear']);		break;
			case '2year':
				if (in_array($pref, array('VAD_','VPD_'))){
					$cost = floatval($dataArr[$pref .'cost2Year']);
				}else{
					$cost = floatval($dataArr[$pref .'costYear'])*2;
				}
				break;
			case '3year':
				if (in_array($pref, array('VAD_','VPD_'))){
					$cost = floatval($dataArr[$pref .'cost3Year']);
				}else{
					$cost = floatval($dataArr[$pref .'costYear'])*3;
				}
				break;
			case '4year':
				if (in_array($pref, array('VAD_','VPD_'))){
					$cost = floatval($dataArr[$pref .'cost4Year']);
				}else{
					$cost = floatval($dataArr[$pref .'costYear'])*4;
				}
				break;
			case '5year':
				if (in_array($pref, array('VAD_','VPD_'))){
					$cost = floatval($dataArr[$pref .'cost5Year']);
				}else{
					$cost = floatval($dataArr[$pref .'costYear'])*5;
				}
				break;
		}
		return $cost;
	}

	// 云主机/云服务器/服务器租用 系统
	public static function VpsSystem($system, $type=''){
		$retStr = '';
		switch ($system){
			case '106':		$retStr = ($type == 'det' ? 'WD 1.0 64-bit' : 'linux');		break;
			case '128':		$retStr = ($type == 'det' ? 'CentOS 5.11 32-bit' : 'linux');	break;
			case '101':		$retStr = ($type == 'det' ? 'CentOS 5.8 64-bit' : 'linux');	break;
			case '425':		$retStr = ($type == 'det' ? 'CentOS 6.5 64-bit' : 'linux');	break;
			case '102':		$retStr = ($type == 'det' ? 'CentOS 6.7 64-bit' : 'linux');	break;
			case '126':		$retStr = ($type == 'det' ? 'CentOS 6.8 32-bit' : 'linux');	break;
			case '125':		$retStr = ($type == 'det' ? 'CentOS 6.8 64-bit' : 'linux');	break;
			case '103':		$retStr = ($type == 'det' ? 'CentOS 7.1 64-bit' : 'linux');	break;
			case '123':		$retStr = ($type == 'det' ? 'CentOS 7.2 64-bit' : 'linux');	break;
			case '124':		$retStr = ($type == 'det' ? 'CentOS 7.3 64-bit' : 'linux');	break;
			case '332':		$retStr = ($type == 'det' ? 'CentOS 7.4 64-bit' : 'linux');	break;
			case '480':		$retStr = ($type == 'det' ? 'CentOS 7.5 64-bit' : 'linux');	break;
			case '505':		$retStr = ($type == 'det' ? 'CentOS 7.6 64-bit' : 'linux');	break;
			case '138':		$retStr = ($type == 'det' ? 'Debian 7.11 64-bit' : 'linux');	break;
			case '105':		$retStr = ($type == 'det' ? 'Debian 7.8 64-bit' : 'linux');	break;
			case '136':		$retStr = ($type == 'det' ? 'Debian 8.7 32-bit' : 'linux');	break;
			case '137':		$retStr = ($type == 'det' ? 'Debian 8.7 64-bit' : 'linux');	break;
			case '482':		$retStr = ($type == 'det' ? 'Debian 9.5 64-bit' : 'linux');	break;
			case '226':		$retStr = ($type == 'det' ? 'Ubuntu 12.04 64-bit' : 'linux');	break;
			case '135':		$retStr = ($type == 'det' ? 'Ubuntu 14.04 32-bit' : 'linux');	break;
			case '104':		$retStr = ($type == 'det' ? 'Ubuntu 14.04 64-bit' : 'linux');	break;
			case '134':		$retStr = ($type == 'det' ? 'Ubuntu 16.04 32-bit' : 'linux');	break;
			case '133':		$retStr = ($type == 'det' ? 'Ubuntu 16.04 64-bit' : 'linux');	break;
			case '248':		$retStr = ($type == 'det' ? 'Windows 7 专业版 SP1 32位中文' : 'window');	break;
			case '520':		$retStr = ($type == 'det' ? 'Windows 7 专业版 SP1 64位中文' : 'window');	break;
			case '250':		$retStr = ($type == 'det' ? 'Windows 2003 企业版 sp2 64位中文' : 'window');	break;
			case '202':		$retStr = ($type == 'det' ? 'Windows 2003 企业版 R2 32位中文' : 'window');	break;
			case '230':		$retStr = ($type == 'det' ? 'Windows 2008 企业版 R2 64位中文' : 'window');	break;
			case '144':		$retStr = ($type == 'det' ? 'Windows 2008 数据中心版 R2 64位中文' : 'window');	break;
			case '297':		$retStr = ($type == 'det' ? 'Windows 2008 标准版 R2 64位中文' : 'window');	break;
			case '475':		$retStr = ($type == 'det' ? 'Windows 2012 数据中心版 R2 64位中文' : 'window');	break;
			case '360':		$retStr = ($type == 'det' ? 'Windows 2012 标准版 R2 64位中文' : 'window');	break;
			case '129':		$retStr = ($type == 'det' ? 'Windows 2016 数据中心版 64位中文' : 'window');	break;
			case '503':		$retStr = ($type == 'det' ? 'Windows 2016 标准版 64位中文' : 'window');	break;
			case '511':		$retStr = ($type == 'det' ? 'Windows 2019 数据中心版 64位中文' : 'window');	break;
			case '512':		$retStr = ($type == 'det' ? 'Windows 2019 标准版 64位中文' : 'window');	break;
			case 'linux':	$retStr = ($type == 'det' ? 'Linux' : 'linux');	break;
			case 'win2003':	$retStr = ($type == 'det' ? 'windows 2003' : 'window');	break;
			case 'win2008':	$retStr = ($type == 'det' ? 'windows 2008' : 'window');	break;
			case 'win2012':	$retStr = ($type == 'det' ? 'windows 2012' : 'window');	break;
			case 'win2016':	$retStr = ($type == 'det' ? 'windows 2016' : 'window');	break;
			case 'win2019':	$retStr = ($type == 'det' ? 'windows 2019' : 'window');	break;
			default :		$retStr = ($type == 'det' ? '未知'. $system : 'window');	break;
		}
		return $retStr;
	}


	// 实名认证 文字
	public static function AuthCN($num){
		switch ($num){
			case 1:		return '<span style="color:green;">已实名</span>';	break;
			case 2:		return '<span style="color:red;">未实名</span>';	break;
			case 0:		return '';	break;	// <span style="color:#c9c9c9;">未知</span>
			default :	return '<span style="color:#c9c9c9;">未知['. $num .']</span>';	break;
		}
	}


	// 提醒待确认 状态
	public static function TixingStateCN($num){
		switch ($num){
			case 1:		return '<span style="color:green;">已同意</span>';	break;
			case 2:		return '<span style="color:red;">已拒绝</span>';	break;
			case 0:		return '<span style="color:#000;">未处理</span>';	break;
			default :	return '<span style="color:#000;">未知['. $num .']</span>';	break;
		}
		if ($num == 1){ return '已处理'; }else{ return '<span style="color:red;">未处理</span>'; }
	}


	// 功能区
	public static function UseMenuCN($str){
		$retStr = '';
		if (strpos(''. $str,'|noKaitong|') !== false){
			$retStr .= '[前台开通✘]&ensp;';
		}
		if (strpos(''. $str,'|noXufei|') !== false){
			$retStr .= '[前台续费✘]&ensp;';
		}
		return $retStr;
	}


	// 付款方式
	public static function UseTimeCN($str){
		$retArr = array();
		if (strpos(''. $str,'|24hour|') !== false){
			$retArr[] = '试用1天';
		}
		if (strpos(''. $str,'|48hour|') !== false){
			$retArr[] = '试用2天';
		}
		if (strpos(''. $str,'|day|') !== false){
			$retArr[] = '日付';
		}
		if (strpos(''. $str,'|week|') !== false){
			$retArr[] = '周付';
		}
		if (strpos(''. $str,'|month|') !== false){
			$retArr[] = '月付';
		}
		if (strpos(''. $str,'|3month|') !== false){
			$retArr[] = '季付';
		}
		if (strpos(''. $str,'|6month|') !== false){
			$retArr[] = '半年付';
		}
		if (strpos(''. $str,'|year|') !== false){
			$retArr[] = '一年付';
		}
		if (strpos(''. $str,'|2year|') !== false){
			$retArr[] = '二年付';
		}
		if (strpos(''. $str,'|3year|') !== false){
			$retArr[] = '三年付';
		}
		if (strpos(''. $str,'|4year|') !== false){
			$retArr[] = '四年付';
		}
		if (strpos(''. $str,'|5year|') !== false){
			$retArr[] = '五年付';
		}
		return implode('、', $retArr);
	}

}

?>