<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class IdcArea{

	// IP字段信息格式化
	public static function IpStr($str, $tdStr='<br />'){
		return str_replace(array('|',PHP_EOL), $tdStr, $str .'');
	}

	// IP字段信息格式化 已废弃，仅为了兼容早期版本
	public static function ToIpArr($str, $point=-1){
		self::IpArr($str, $point);
	}

	// IP字段信息格式化
	public static function IpArr($str, $point=-1){
		if (strlen(''. $str) == 0){ return ''; }
		$retArr = explode('|', str_replace(PHP_EOL, '|', $str) );
		if ($point == -1){
			return $retArr;
		}else{
			return $retArr[$point];
		}
	}


	// 产品字段前缀数组
	public static function FieldArr($type){
		switch ($type){
			case 'host':	return array('user' => 'HU_',	'data' => 'HD_');
			case 'vpsPro':	return array('user' => 'VPU_',	'data' => 'VPD_');
			case 'vpsApi':	return array('user' => 'VAU_',	'data' => 'VAD_');
			case 'dialing':	return array('user' => 'DU_',	'data' => 'DD_');
			case 'pptp':	return array('user' => 'PU_',	'data' => 'PD_');
			case 'serv':	return array('user' => 'SU_',	'data' => 'SD_');
			default :		die($type .' 不是有效 TypeArr 类型');
		}
	}


	// VPS默认端口号
	public static function VpsDefPort($type, $port){
		if ( in_array($type, array('Linux', 'linux', '106','128','127','101','425','102','126','125','103','123','124','332','138','105','136','137','482','226','135','104','134','133')) ){
			if ($port == 0 || $port == 3389){
				$port = 22;
			}
		}else{
			if ($port == 0 || $port == 22){
				$port = 3389;
			}
		}
		return $port;
	}


	// VPS默认用户名
	public static function VpsDefUsername($type, $user){
		if ( in_array($type, array('Linux', 'linux', '106','128','127','101','425','102','126','125','103','123','124','332','138','105','136','137','482','226','135','104','134','133')) ){
			if (strlen(''. $user) == 0 || $user == 'administrator'){
				$user = 'root';
			}
		}else{
			if (strlen(''. $user) == 0 || $user == 'root'){
				$user = 'administrator';
			}
		}
		return $user;
	}


	// 管理面板内容解密处理
	public static function PanelLoginDecode(){
		$vpsType	= trim(@$_POST['vpsType']);
		if ($vpsType == 'west'){
			$vpsName	= trim(@$_POST['domain']);
			$vpsPwd		= trim(@$_POST['inipass']);
		}else{
			$vpsName	= trim(@$_POST['vpsname']);
			$vpsPwd		= trim(@$_POST['vpspassword']);
		}

		die(''.
		'$id("vpsName").value = "'. Encrypt::SyEnDe('de', Encrypt::AuthCode($vpsName, 'DECODE', 'OTCMSCOM2010')) .'";'.
		'$id("vpsPwd").value = "'. Encrypt::SyEnDe('de', Encrypt::AuthCode($vpsPwd, 'DECODE', 'OTCMSCOM2010')) .'";'.
		'');
	}


	// 管理面板跳转 域名 西部数码
	public static function PanelLoginWest($domain, $domainPwd, $webPathPart=''){
		echo('
		<meta http-equiv="content-type" content="text/html; charset=g'.'b2'.'312">
		<script language="javascript" type="text/javascript" src="'. $webPathPart .'js/inc/jquery.min.js?v='. OT_VERSION .'"></script>
		<script language="javascript" type="text/javascript" src="'. $webPathPart .'js/panelLogin.js?v='. OT_VERSION .'"></script>

		<form id="loginForm" name="loginForm" method="post" action="http://api.west263.com/dns/dnslogin.asp" style="font-size:14px;padding:8px;">
		<input type="hidden" id="webPathPart" name="webPathPart" value="'. $webPathPart .'">
		<input type="hidden" id="vpsType" name="vpsType" value="west">
		<input type="hidden" id="vpsName" name="domain" value="'. Encrypt::AuthCode($domain, 'ENCODE', 'OTCMSCOM2010', 60) .'">
		<input type="hidden" id="vpsPwd" name="inipass" value="'. Encrypt::AuthCode($domainPwd, 'ENCODE', 'OTCMSCOM2010', 60) .'">
		<input name="api" type="hidden" value="6">
		正在跳转中，请稍等……  8秒后如没自动跳转，<input type="submit" name="subBtn" value="请点此继续登录...........">
		</form>
		');
	}


	// 管理面板跳转 网钛IDC
	public static function PanelLoginIdccms($webPathPart, $apiUrl, $vpsName, $vpsPwd){
		$timeStamp = time();
		$userIP	= Users::GetIp();
		$vpsPwd = md5(md5($vpsName . $userIP . $timeStamp) . $vpsPwd);

		echo('
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

		<form id="loginForm" name="loginForm" method="post" action="http://'. $apiUrl .'/login.php" style="font-size:14px;padding:8px;">
		<input type="hidden" id="webPathPart" name="webPathPart" value="'. $webPathPart .'">
		<input type="hidden" id="timeStamp" name="timeStamp" value="'. $timeStamp .'">
		<input type="hidden" id="vpsName" name="vpsName" value="'. $vpsName .'">
		<input type="hidden" id="vpsPwd" name="vpsPwd" value="'. $vpsPwd .'">
		正在跳转中，请稍等……  8秒后如没自动跳转，<input type="submit" name="subBtn" value="请点此继续登录...........">
		</form>
		<script language="javascript" type="text/javascript">
		document.getElementById("loginForm").submit();
		</script>
		');
	}


	// 管理面板跳转 星外
	public static function PanelLoginXingwai($webPathPart, $apiUrl, $vpsName, $vpsPwd){
		echo('
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<script language="javascript" type="text/javascript" src="'. $webPathPart .'js/inc/jquery.min.js?v='. OT_VERSION .'"></script>
		<script language="javascript" type="text/javascript" src="'. $webPathPart .'js/panelLogin.js?v='. OT_VERSION .'"></script>

		<form id="loginForm" name="loginForm" method="post" action="http://'. $apiUrl .'/vpsadm/login.asp" style="font-size:14px;padding:8px;">
		<input type="hidden" id="webPathPart" name="webPathPart" value="'. $webPathPart .'">
		<input type="hidden" id="vpsType" name="vpsType" value="xw">
		<input type="hidden" id="vpsName" name="vpsname" value="'. Encrypt::AuthCode($vpsName, 'ENCODE', 'OTCMSCOM2010', 60) .'">
		<input type="hidden" id="vpsPwd" name="vpspassword" value="'. Encrypt::AuthCode($vpsPwd, 'ENCODE', 'OTCMSCOM2010', 60) .'">
		正在跳转中，请稍等……  8秒后如没自动跳转，<input type="submit" name="subBtn" value="请点此继续登录...........">
		</form>
		');
	}


	// 管理面板跳转 景安
	public static function PanelLoginJingan($type, $dataID, $row){
		global $DB;

		$fArr = self::FieldArr($type);

		$proID			= $row[$fArr['user'] .'proDataID'];
		$serverCode		= Encrypt::SyEnDe('de',$row[$fArr['user'] .'serverCode']);
		$serverPwd		= Encrypt::SyEnDe('de',$row[$fArr['user'] .'serverPwd']);

		$proexe = $DB->query('select '. $fArr['data'] .'typeID,'. $fArr['data'] .'pcountry,'. $fArr['data'] .'ptype,'. $fArr['data'] .'pname from '. OT_dbPref . $type .'Data where '. $fArr['data'] .'ID='. $proID);
			if (! $rs1 = $proexe->fetch()){ JS::AlertCloseEnd('搜索不到相关产品记录['. $proID .']'); }

		$typeexe = $DB->query('select VT_classID,VT_companyID from '. OT_dbPref .'vpsType where VT_ID='. $rs1[$fArr['data'] .'typeID'] .'');
			if (! $rs2 = $typeexe->fetch()){ JS::AlertCloseEnd('搜索不到产品类型['. $rs1[$fArr['data'] .'typeID'] .']'); }

		$comexe = $DB->query('select VC_apiID,VC_apiDomain,VC_apiUsername,VC_apiUserPwd from '. OT_dbPref .'vpsCompany where VC_ID='. $rs2['VT_companyID'] .'');
			if (! $rs3 = $comexe->fetch()){ JS::AlertCloseEnd('搜索不到上级渠道商记录['. $rs2['VT_companyID'] .']'); }

		ApiJingan::$accessId	= $rs3['VC_apiUsername'];
		ApiJingan::$accessKey	= Encrypt::SyEnDe('de',$rs3['VC_apiUserPwd']);
		ApiJingan::$urlMode		= $rs1[$fArr['data'] .'pcountry'];

		if (strlen(''. $serverCode)<3 || strlen(''. $serverPwd)<3){
			$dataArr = array(
				'ptype'		=> $rs1[$fArr['data'] .'ptype'],
				'pname'		=> $rs1[$fArr['data'] .'pname'],
				'workId'	=> $row[$fArr['user'] .'workId'],
				'workSign'	=> $row[$fArr['user'] .'workSign']
				);
			$resArr = ApiJingan::GetServCode($dataArr);
			if (! $resArr['res']){
				JS::AlertCloseEnd('获取服务码失败（'. $resArr['note'] .'）');
			}
			$serverCode		= $resArr['info']['serviceCode'];
			$serverPwd		= $resArr['info']['passwd'];
			$DB->UpdateParam($type .'Users', array($fArr['user'] .'serverCode'=>Encrypt::SyEnDe('en',$serverCode),$fArr['user'] .'serverPwd'=>Encrypt::SyEnDe('en',$serverPwd)), $fArr['user'] .'ID='. $dataID);
		}
		$dataArr = array(
			'serverCode'	=> $serverCode,
			'serverPwd'		=> $serverPwd
			);
		$resArr = ApiJingan::PanelKey($dataArr,true);
		if (! $resArr['res']){
			$dataArr = array(
				'ptype'		=> $rs1[$fArr['data'] .'ptype'],
				'pname'		=> $rs1[$fArr['data'] .'pname'],
				'workId'	=> $row[$fArr['user'] .'workId'],
				'workSign'	=> $row[$fArr['user'] .'workSign']
				);
			$resArr = ApiJingan::GetServCode($dataArr);
			if (! $resArr['res']){
				JS::AlertCloseEnd('获取服务码失败（'. $resArr['note'] .'）');
			}
			$serverCode		= $resArr['info']['serviceCode'];
			$serverPwd		= $resArr['info']['passwd'];
			$DB->UpdateParam($type .'Users', array($fArr['user'] .'serverCode'=>Encrypt::SyEnDe('en',$serverCode),$fArr['user'] .'serverPwd'=>Encrypt::SyEnDe('en',$serverPwd)), $fArr['user'] .'ID='. $dataID);

			$dataArr = array(
				'serverCode'	=> $serverCode,
				'serverPwd'		=> $serverPwd
				);
			$resArr = ApiJingan::PanelKey($dataArr);
			if (! $resArr['res']){
				JS::AlertCloseEnd('获取自助平台Key失败（'. $resArr['note'] .'）');
			}
		}
		if ($rs1[$fArr['data'] .'pcountry'] == 'hk'){
			$panlUrl = 'https://ssp.zzidc.hk/iremotelogin.action';
		}else{
			if (OT::GetStr('mode') == 'old'){
				$panlUrl = 'https://ssp.zzidc.com/iremotelogin.action';
			}else{
				$panlUrl = 'https://nssp.zzidc.com/iremotelogin.action';
			}
		}

		echo('
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

		<form id="loginForm" name="loginForm" method="post" action="'. $panlUrl .'" style="font-size:14px;padding:8px;">
		<input type="hidden" name="code" value="'. $resArr['info'] .'">
		正在跳转中，请稍等……  8秒后如没自动跳转，<input type="submit" name="subBtn" value="请点此继续登录...........">
		</form>
		<script language="javascript" type="text/javascript">
		document.getElementById("loginForm").submit();
		</script>
		');
		unset($rs1,$rs2,$rs3);
	}


	// 拨号VPS 省份
	public static function DialingProvOption($sel,$defVal='no'){
		$provArr = Cache::PhpFile('dialingProv');
		if ($defVal != 'no'){
			$retStr = '<option value="">'. $defVal .'</option>';
		}else{
			$retStr = '';
		}
		foreach ($provArr as $key => $val){
			$retStr .= '<option value="'. $key .'" '. Is::Selected($key,$sel) .'>'. $val .'</option>';
		}
		return $retStr;
	}


	// 景安 可用系统选择
	public static function JinganSystemOption($companyID,$defVal=''){
		global $DB;
		$retStr = '';

		$comRow = $DB->GetRow('select VC_apiDomain,VC_apiUsername,VC_apiUserPwd from '. OT_dbPref .'vpsCompany where VC_ID='. $companyID);
		ApiJingan::$accessId	= $comRow['VC_apiUsername'];
		ApiJingan::$accessKey	= Encrypt::SyEnDe('de',$comRow['VC_apiUserPwd']);
		$listArr = ApiJingan::GetSystemList();
		if (isset($listArr['info'])){
			foreach ($listArr['info'] as $key => $val){
				$retStr .= '<optgroup label="【'. $key .'】" style="font-weight:normal;"></optgroup>';
				sort($val);
				foreach ($val as $val2){
					$retStr .= '<option value="'. $val2['bh'] .'" '. (strlen(''. $defVal)>0 ? Is::Selected($defVal,$val2['bh']) : '') .'>'. $val2['displayName'] .'</option>';
				}
			}
		}

		if (strlen($retStr) < 5){
			$osArr = array();
			$osArr['Windows'] = array(
				'297'	=> 'Windows 2008 标准版 R2 64位中文（需自行激活）',
				'144'	=> 'Windows 2008 数据中心版 R2 64位中文（需自行激活）',
				'230'	=> 'Windows 2008 企业版 R2 64位中文（需自行激活）',
				'360'	=> 'Windows 2012 标准版 R2 64位中文（需自行激活）',
				'475'	=> 'Windows 2012 数据中心版 R2 64位中文（需自行激活）',
				'503'	=> 'Windows 2016 标准版 64位中文（需自行激活）',
				'129'	=> 'Windows 2016 数据中心版 64位中文（需自行激活）',
				'512'	=> 'Windows 2019 标准版 64位中文（需自行激活）',
				'511'	=> 'Windows 2019 数据中心版 64位中文（需自行激活）',
				'202'	=> 'Windows 2003 企业版 R2 32位中文',
				'250'	=> 'Windows 2003 企业版 sp2 64位中文',
				'248'	=> 'Windows 7 专业版 SP1 32位中文',
				'520'	=> 'Windows 7 专业版 SP1 64位中文'
				);
			$osArr['Linux'] = array(
				'480'	=> 'CentOS 7.5 64-bit',
				'505'	=> 'CentOS 7.6 64-bit',
				'570'	=> 'CentOS 8.3 64-bit',
				'574'	=> 'Ubuntu 20.04 64-bit',
				'579'	=> 'Debian 10.10 64-bit',
				'581'	=> 'Debian 9.13 64-bit',
				'582'	=> 'FreeBSD 12.2 64-bit',
				'106'	=> 'WD 1.0 64-bit',
				);
			/*
				'332'	=> 'CentOS 7.4 64-bit',
				'124'	=> 'CentOS 7.3 64-bit',
				'123'	=> 'CentOS 7.2 64-bit',
				'103'	=> 'CentOS 7.1 64-bit',
				'125'	=> 'CentOS 6.8 64-bit',
				'126'	=> 'CentOS 6.8 32-bit',
				'102'	=> 'CentOS 6.7 64-bit',
				'425'	=> 'CentOS 6.5 64-bit',
				'101'	=> 'CentOS 5.8 64-bit',
				'128'	=> 'CentOS 5.11 32-bit',

				'482'	=> 'Debian 9.5 64-bit',
				'581'	=> 'Debian 9.13 64-bit',
				'136'	=> 'Debian 8.7 32-bit',
				'137'	=> 'Debian 8.7 64-bit',
				'105'	=> 'Debian 7.8 64-bit',
				'138'	=> 'Debian 7.11 64-bit',
				'579'	=> 'Debian 10.10 64-bit',

				'594'	=> 'Ubuntu 22.04 64-bit',
				'574'	=> 'Ubuntu 20.04 64-bit',
				'133'	=> 'Ubuntu 16.04 64-bit',
				'134'	=> 'Ubuntu 16.04 32-bit',
				'104'	=> 'Ubuntu 14.04 64-bit',
				'135'	=> 'Ubuntu 14.04 32-bit',
				'226'	=> 'Ubuntu 12.04 64-bit',

				'106'	=> 'WD 1.0 64-bit',
				'582'	=> 'FreeBSD 12.2 64-bit',
				'236'	=> 'FreeBSD 10.3 64-bit',
				'595'	=> 'uniontechos-v20 1050e 64-bit',
				'596'	=> 'openEuler 22.03 64-bit',
			*/

			$retStr = '';
			foreach ($osArr as $key => $val){
				$retStr .= '<optgroup label="【'. $key .'】" style="font-weight:normal;">';
				
				foreach ($val as $k => $v){
					$retStr .= '<option value="'. $k .'">'. $v .'</option>';
				}

				$retStr .= '</optgroup>';
			}
			/* $retStr = '
				<optgroup label="【Windows】" style="font-weight:normal;">
					<option value=""></option>
				</optgroup>

				<optgroup label="【Linux】" style="font-weight:normal;">
					<option value=""></option>
				</optgroup>
				'; */
				/*
				<option value="win2003">windows 2003</option>
				<option value="win2008">windows 2008（内存至少2G才能安装）</option>
				<option value="linux">Linux</option>
				*/

		}
		return $retStr;
	}


	// 获取新的服务器名
	public static function GetNewVpsName($type,$classID){
		global $DB;

		switch ($type){
			case 'host':	$tabName = 'hostUsers';		$tabPart = 'HU_';	break;
			case 'serv':	$tabName = 'servUsers';		$tabPart = 'SU_';	break;
			case 'vpsApi':	$tabName = 'vpsApiUsers';	$tabPart = 'VAU_';	break;
			case 'dialing':	$tabName = 'dialingUsers';	$tabPart = 'DU_';	break;
			case 'pptp':	$tabName = 'pptpUsers';		$tabPart = 'PU_';	break;
			case 'idcServ':	$tabName = 'idcServVps';	$tabPart = 'ISV_';	break;
			default :
				JS::AlertBackEnd('vpsName类型错误（'. $type .'）');
				break;
		}
		$useNum = 0;
		$vpsName = '';
		$classexe = $DB->query('select VC_prefName,VC_useNum,VC_numLen from '. OT_dbPref .'vpsClass where VC_ID='. $classID);
		if (! $row = $classexe->fetch()){
			JS::AlertBackEnd('产品模块检测不出');
		}else{
			for ($i=1; $i<=50; $i++){
				$newVpsName = $row['VC_prefName'] . Str::FixLen($row['VC_useNum']+$i, $row['VC_numLen']);
				$chk2exe = $DB->QueryParam('select '. $tabPart .'ID from '. OT_dbPref . $tabName .' where '. $tabPart .'vpsName=? limit 1',array($newVpsName));
				if (! $chk2exe->fetch()){
					$vpsName = $newVpsName;
					$useNum = $row['VC_useNum']+$i;
					break;
				}
				$chk2exe=null;
			}
		}
		unset($classexe);

		return array('vpsName'=>$vpsName, 'useNum'=>$useNum);
	}


	// 判断未生效机器是否超出数量
	public static function CheckVpsState3Num($type, $userID, $maxNum){
		global $DB;

		if ($maxNum > 0){
			switch ($type){
				case 'host':	$tabName = 'hostUsers';		$tabPart = 'HU_';	break;
				case 'serv':	$tabName = 'servUsers';		$tabPart = 'SU_';	break;
				case 'vpsApi':	$tabName = 'vpsApiUsers';	$tabPart = 'VAU_';	break;
				case 'dialing':	$tabName = 'dialingUsers';	$tabPart = 'DU_';	break;
				case 'pptp':	$tabName = 'pptpUsers';		$tabPart = 'PU_';	break;
				default :
					JS::AlertBackEnd('vpsName类型错误（'. $type .'）');
					break;
			}
			// $vpsNum = $DB->GetOne('select count('. $tabPart .'ID) from '. OT_dbPref . $tabName .' where '. $tabPart .'userID='. $userID .' and '. $tabPart .'state>=3 and '. $tabPart .'state<=6 and '. $tabPart .'time>=date_sub(curdate(), INTERVAL 30 DAY)');
			$vpsNum = $DB->GetOne('select count('. $tabPart .'ID) from '. OT_dbPref . $tabName .' where '. $tabPart .'userID='. $userID .' and '. $tabPart .'state>=3 and '. $tabPart .'state<=6 and '. $tabPart .'time>='. $DB->ForTime(TimeDate::Add('d',-30)));
			if ($vpsNum > $maxNum){
				JS::AlertBackEnd('30天内 开通失败、开通中、待开通 状态机器超过'. $vpsNum .'台（规定最多'. $maxNum .'台），请先联系管理员处理这些状态机器。');
			}
		}
	}


	// PPTP到期时间计算
	public static function PptpEndTime($payNum, $payMode, $timeStr, $retMode='', $retStr=''){
		switch ($payMode){
			case '24hour':		return TimeDate::Add('min',60,$timeStr);
			// case '48hour':	return TimeDate::Add('min',60,$timeStr);
			case 'day':			return TimeDate::Add('d',$payNum,$timeStr);
			case 'week':		return TimeDate::Add('d',$payNum*7,$timeStr);
			case 'month':		return TimeDate::Add('m',$payNum,$timeStr);
			case '3month':		return TimeDate::Add('m',$payNum*3,$timeStr);
			case '6month':		return TimeDate::Add('m',$payNum*6,$timeStr);
			case 'year':		return TimeDate::Add('y',$payNum,$timeStr);
			default :
				if ($retMode == 'currTime'){
					return $timeStr;
				}else{
					if (strlen(''. $retStr) == 0){ $retStr='付款方式错误（'. $payMode .'）。'; }
					JS::AlertBackEnd($retStr);
				}
				break;
		}
	}


	// 到期时间计算
	public static function NewEndTime($payMode, $timeStr, $retMode='', $retStr=''){
		switch ($payMode){
			case 'doing':		return $timeStr;
			case '24hour':		return TimeDate::Add('d',1,$timeStr);
			case '48hour':		return TimeDate::Add('d',2,$timeStr);
			case 'day':			return TimeDate::Add('d',1,$timeStr);
			case 'week':		return TimeDate::Add('d',7,$timeStr);
			case 'month':		return TimeDate::Add('m',1,$timeStr);
			case '3month':		return TimeDate::Add('m',3,$timeStr);
			case '6month':		return TimeDate::Add('m',6,$timeStr);
			case 'year':		return TimeDate::Add('y',1,$timeStr);
			case '2year':		return TimeDate::Add('y',2,$timeStr);
			case '3year':		return TimeDate::Add('y',3,$timeStr);
			case '4year':		return TimeDate::Add('y',4,$timeStr);
			case '5year':		return TimeDate::Add('y',5,$timeStr);
			default :
				if ($retMode == 'currTime'){
					return $timeStr;
				}else{
					if (strlen(''. $retStr) == 0){ $retStr='付款方式错误（'. $payMode .'）。'; }
					JS::AlertBackEnd($retStr);
				}
				break;
		}
	}


	// 年付差价 虚拟主机
	public static function YearDiffPrice($oldPrice, $newPrice, $endTime){
		/* 按月算差价
		$monthPrice = (floatval($newPrice) - floatval($oldPrice))/12;
		$monthNum = TimeDate::Diff('m',TimeDate::Get(),$endTime,'ceil');
		return OT::ToFloat($monthPrice * $monthNum);
		*/
		// 按年算差价
		$yearPrice = floatval($newPrice) - floatval($oldPrice);
		$yearNum = TimeDate::Diff('y',TimeDate::Get(),$endTime,'ceil');
		return OT::ToFloat($yearPrice * $yearNum);
	}

	// 月付差价 服务器
	public static function MonthDiffPrice($oldPrice, $newPrice, $endTime){
		$monthPrice = floatval($newPrice) - floatval($oldPrice);
		$monthNum = TimeDate::Diff('m',TimeDate::Get(),$endTime,'ceil');
		return OT::ToFloat($monthPrice * $monthNum);
	}

	// idc随机密码
	public static function IdcRndPwd($type){
		return OT::RndChar(4,'ABC') . OT::RndChar(4,'num');
	}


	// VPS API接口列表
	public static function VpsApiArr($str='', $type=''){
		$rightArr = array('xufei', 'update');	// 通用权限 （续费，升级）
		$retArr = array(
			1	=> array(
				'id'	=> 1,			// 接口ID
				'type'	=> 'xingwai',	// 英文名
				'name'	=> '星外',		// 中文名
				'right'	=> $rightArr,	// 功能权限
				'appID'	=> 125,			// APP ID
				'state'	=> 1,			// 状态
				),
			2	=> array(
				'id'	=> 2,
				'type'	=> 'jingan',
				'name'	=> '景安网络',
				'right'	=> array('zhuanzheng', 'xufei', 'update', 'shiming'),	// 转正，续费，升级，实名
				'appID'	=> 124,
				'state'	=> 1,
				),
			3	=> array(
				'id'	=> 3,
				'type'	=> 'adream',
				'name'	=> '创梦',
				'right'	=> $rightArr,
				'appID'	=> 138,
				'state'	=> 0,
				),
			4	=> array(
				'id'	=> 4,
				'type'	=> 'zkeys',
				'name'	=> 'ZKEYS阿帕云',
				'right'	=> $rightArr,
				'appID'	=> 140,
				'state'	=> 0,
				),
			5	=> array(
				'id'	=> 5,
				'type'	=> 'pp',
				'name'	=> 'PP',
				'right'	=> $rightArr,
				'appID'	=> 0,
				'state'	=> 0,
				),
			6	=> array(
				'id'	=> 6,
				'type'	=> 'idccms',
				'name'	=> '网钛IDC系统',
				'right'	=> $rightArr,
				'appID'	=> 0,
				'state'	=> 1,
				),
			7	=> array(
				'id'	=> 7,
				'type'	=> 'yvsy',
				'name'	=> '一对一系统',
				'right'	=> $rightArr,
				'appID'	=> 150,
				'state'	=> 1,
				),
			8	=> array(
				'id'	=> 8,
				'type'	=> 'rstack',
				'name'	=> 'RStack',
				'right'	=> $rightArr,
				'appID'	=> 151,
				'state'	=> 0,
				),
			9	=> array(
				'id'	=> 9,
				'type'	=> 'idcsmart',
				'name'	=> '智简魔方',
				'right'	=> $rightArr,
				'appID'	=> 152,
				'state'	=> 0,
				),
			10	=> array(
				'id'	=> 10,
				'type'	=> 'bt',
				'name'	=> '宝塔',
				'right'	=> $rightArr,
				'appID'	=> 131,
				'state'	=> 0,
				)
			);
		if (strlen($str) == 0){
			if ( in_array($type, array('id','type','name','right','appID')) ){
				$retArr[0] = array(
					'id'	=> 0,
					'type'	=> '',
					'name'	=> '[无API]',
					'right'	=> array(),
					'appID'	=> 0,
					'state'	=> 0,
					);
				foreach ($retArr as $key => $val){
					$tempArr[$key] = $val[$type];
				}
				return $tempArr;
			}else{
				return $retArr;
			}
		}else{
			switch ($str){
				case 1: case 'xingwai':
					$retArr = $retArr[1];
					break;

				case 2: case 'jingan':
					$retArr = $retArr[2];
					break;

				case 3: case 'adream':
					$retArr = $retArr[3];
					break;

				case 4: case 'zkeys':
					$retArr = $retArr[4];
					break;

				case 6: case 'idccms':
					$retArr = $retArr[6];
					break;

				case 7: case 'yvsy':
					$retArr = $retArr[7];
					break;

				case 8: case 'rstack':
					$retArr = $retArr[8];
					break;

				case 9: case 'idcsmart':
					$retArr = $retArr[9];
					break;

				case 10: case 'bt':
					$retArr = $retArr[10];
					break;

				default :
					$retArr = array(
						'id'	=> 0,
						'type'	=> '',
						'name'	=> '['. $str .']',
						'right'	=> array(),
						'appID'	=> 0,
						'state'	=> 0,
						);
					break;
			}

			if ( in_array($type, array('id','type','name','right','appID')) ){
				return $retArr[$type];
			}else{
				return $retArr;
			}
		}
	}
}

?>