<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class BatchRun{
	// 大数据量数组
	public static function BigItemArr($key=''){
		$itemArr = array();
		$itemArr['prevNext']	= '上下篇文章ID更新';
		$itemArr['markNews']	=  '相关文章ID更新';
		/*
		$itemArr['host']		= '虚拟主机API更新';
		$itemArr['vpsApi']		= '云服务器API更新';
		$itemArr['idcServVpsClose']		= '主控机器到期关机检测';
		$itemArr['idcServVpsStatus']	= '主控机器状态更新';
		*/

		if (strlen($key) > 0){
			if (isset($itemArr[$key])){
				return $itemArr[$key];
			}else{
				return '['. $key .']';
			}
		}else{
			return $itemArr;
		}
	}


	// 批处理数组
	public static function DefItemArr($key=''){
		$itemArr = array();
		$itemArr['prevNext0']	= '上下篇文章未赋值处理';
		$itemArr['markNews0']	= '相关文章未赋值处理';
		$itemArr['autoImg']		= '缩略图为空自动配图';

		if (strlen($key) > 0){
			if (isset($itemArr[$key])){
				return $itemArr[$key];
			}else{
				return '['. $key .']';
			}
		}else{
			return $itemArr;
		}
	}


	// 上下篇文章ID更新
	public static function PrevNext($type=''){
		global $DB, $autoRunSysArr;

		$todayTime = TimeDate::Get();
		$checkTime = TimeDate::Add('s',-1,$todayTime);
		$day_1Time = TimeDate::Add('day',-1,$todayTime);
		$retArr = array('res'=>false, 'isEnd'=>true, 'note'=>'???');
		if ($type == 'empty'){
			// 上下篇文章未赋值处理
			$whereStr1 = ' and (IF_prevNewsId=0 or IF_nextNewsId=0) and (IF_prevNextTime is null or IF_prevNextTime<='. $DB->ForTime($day_1Time) .')';
			// $whereStr1 = ' and ((IF_prevNewsId=0 and IF_nextNewsId=0) or IF_prevNextTime is null)';
			$whereStr2 = $whereStr1;
		}else{
			$whereStr1 = '';
			$whereStr2 = $whereStr1 .' order by IF_type1ID DESC,IF_type2ID DESC,IF_time DESC';

		}
		
		if (empty($autoRunSysArr)){ $autoRunSysArr = Cache::PhpFile('autoRunSys'); }

		if ($autoRunSysArr['ARS_prevNextDay'] > 0 || $type == 'empty'){
			if ($type == 'empty' || strtotime($autoRunSysArr['ARS_prevNextTime']) + $autoRunSysArr['ARS_prevNextDay']*86400 < time()){	// 86400秒=1天
				$pageSize	= $autoRunSysArr['ARS_prevNextSize'];
					if ($pageSize <= 0){ $pageSize = 501; }
				$page		= $autoRunSysArr['ARS_prevNextPage'];
				$recordCount= $DB->GetOne('select count(1) from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. $whereStr1);
				$pageCount	= ceil($recordCount/$pageSize);
				if ($page < 1 || $page > $pageCount){ $page = 1; }
				$showRow=$DB->GetLimit('select IF_ID,IF_time,IF_prevNewsId,IF_nextNewsId,IF_type1ID,IF_type2ID from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. $whereStr2,$pageSize,$page);
				if (! $showRow){
					if ($type == 'empty'){
						$retArr['note'] = '暂无符合要求的文章';
					}else{
						$retArr['note'] = '无文章';
					}
					return $retArr;
				}else{
					$prevId = $nextId = $selId = 0;
					$number = 1+($page-1)*$pageSize;
					$rowCount = count($showRow);
					for ($i=0; $i<$rowCount; $i++){
						$prevNextWhereStr = '';
						if ($showRow[$i]['IF_type2ID'] > 0){
							$prevNextWhereStr = ' and IF_type2ID='. $showRow[$i]['IF_type2ID'] .'';
						}elseif ($showRow[$i]['IF_type1ID'] > 0 || $showRow[$i]['IF_type1ID'] == -1){
							$prevNextWhereStr = ' and IF_type1ID='. $showRow[$i]['IF_type1ID'] .'';
						}

						if ($type == 'empty'){
							$prevIdArr = Info::PrevIdArr($showRow[$i]['IF_time'], $prevNextWhereStr, 1);
							if (count($prevIdArr) == 0){
								$prevId = 0;
							}else{
								$prevId = $prevIdArr[0];
							}

							$nextIdArr = Info::NextIdArr($showRow[$i]['IF_time'], $prevNextWhereStr, 1);
							if (count($nextIdArr) == 0){
								$nextId = 0;
							}else{
								$nextId = $nextIdArr[0];
							}
						}else{
							if ($i == 0){
								if ($page > 1){
									$nextIdArr = Info::NextIdArr($showRow[$i]['IF_time'], $prevNextWhereStr, 1);
									if (count($nextIdArr) == 0){
										$nextId = 0;
									}else{
										$nextId = $nextIdArr[0];
									}
								}else{
									$nextId = 0;
								}
							}else{
								$nextId = $showRow[$i-1]['IF_ID'];
							}

							if ($i + 1 == $rowCount){
								if ($page < $pageCount){
									$prevIdArr = Info::PrevIdArr($showRow[$i]['IF_time'], $prevNextWhereStr, 1);
									if (count($prevIdArr) == 0){
										$prevId = 0;
									}else{
										$prevId = $prevIdArr[0];
									}
								}else{
									$prevId = 0;
								}
							}else{
								$prevId = $showRow[$i+1]['IF_ID'];
							}
						}

						$record = array();
						$record['IF_prevNewsId']	= $prevId;
						$record['IF_nextNewsId']	= $nextId;
						$record['IF_prevNextTime']	= $todayTime;
						$DB->UpdateParam('info', $record, 'IF_ID='. $showRow[$i]['IF_ID']);

						$number ++;
					}
				}
				unset($showRow);

				$retArr['res'] = true;
				$retArr['note'] = '完成 '. $page .'/'. $pageCount .'，总记录：'. $recordCount .'，每页：'. $pageSize;

				if ($page == $pageCount){
					$DB->query('update '. OT_dbPref .'autoRunSys set ARS_prevNextPage=0,ARS_prevNextPageCount='. $pageCount .',ARS_prevNextTime='. $DB->ForTime($todayTime));
				}else{
					$page ++;
					$DB->query('update '. OT_dbPref .'autoRunSys set ARS_prevNextPage='. $page .',ARS_prevNextPageCount='. $pageCount);
					$retArr['isEnd'] = false;
				}

				$Cache = new Cache();
				$Cache->Php('autoRunSys');
				return $retArr;

			}else{
				$retArr['note'] = '未到时间 '. $autoRunSysArr['ARS_prevNextTime'] .'['. $autoRunSysArr['ARS_prevNextDay'] .']';
				return $retArr;
			}
		}else{
			$retArr['note'] = '间隔天数为0，不作操作';
			return $retArr;
		}
	}


	// 相关文章ID更新
	public static function MarkNews($type=''){
		global $DB, $autoRunSysArr;

		$todayTime = TimeDate::Get();
		$checkTime = TimeDate::Add('s',-1,$todayTime);
		$day_1Time = TimeDate::Add('day',-1,$todayTime);
		$retArr = array('res'=>false, 'isEnd'=>true, 'note'=>'');
		if ($type == 'empty'){
			// 相关文章未赋值处理
			// $whereStr1 = ' and (IF_themeKeyIdStr = "" or IF_themeKeyIdStr is null) and IF_markNewsTime<='. $DB->ForTime($day_1Time) .'';
			$whereStr1 = ' and ((IF_themeKeyIdStr = "" or IF_themeKeyIdStr is null) and IF_markNewsTime is null)';
			$whereStr2 = $whereStr1;
		}else{
			$whereStr1 = ' and IF_markNewsTime<='. $DB->ForTime($checkTime) .'';
			$whereStr2 = $whereStr1 .' order by IF_markNewsTime ASC';

		}

		if (empty($autoRunSysArr)){ $autoRunSysArr = Cache::PhpFile('autoRunSys'); }
		if ($autoRunSysArr['ARS_markNewsDay'] > 0 || $type == 'empty'){
			if ($type == 'empty' || strtotime($autoRunSysArr['ARS_markNewsTime']) + $autoRunSysArr['ARS_markNewsDay']*86400 < time()){	// 86400秒=1天
				$pageSize	= $autoRunSysArr['ARS_markNewsSize'];
					if ($pageSize <= 0){ $pageSize = 51; }
				$page		= $autoRunSysArr['ARS_markNewsPage'];
				$recordCount= $DB->GetOne('select count(1) from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. $whereStr1);
				$pageCount	= ceil($recordCount/$pageSize);
				if ($page < 1 || $page > $pageCount){ $page = 1; }
				$showRow=$DB->GetLimit('select IF_ID,IF_themeKey,IF_themeKeyIdStr from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. $whereStr2,$pageSize,$page);
				if (! $showRow){
					if ($type == 'empty'){
						$retArr['note'] = '暂无符合要求的文章';
					}else{
						$retArr['note'] = '最后检查时间'. $checkTime .'之前无文章';
					}
					return $retArr;
				}else{
					$maxNum = 18;
					$number = 1+($page-1)*$pageSize;
					$rowCount = count($showRow);
					for ($i=0; $i<$rowCount; $i++){
						$idArr = Info::MarkNewsIdArr($showRow[$i]['IF_themeKey'], $showRow[$i]['IF_ID'], $maxNum);
						if (count($idArr) == 0){
							$idArr = array();
							$itemexe = $DB->query('select IF_ID from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1 and IF_ID<='. ($showRow[$i]['IF_ID']-1) . OT_TimeInfoWhereStr .' order by IF_time DESC limit '. $maxNum);
							while ($row = $itemexe->fetch()){
								$idArr[] = $row['IF_ID'];
							}
							$itemexe = null;
						}
						$idStr = implode(',',$idArr);

						$record = array();
						$record['IF_themeKeyIdStr']	= $idStr;
						$record['IF_markNewsTime']	= $todayTime;
						$DB->UpdateParam('info', $record, 'IF_ID='. $showRow[$i]['IF_ID']);

						$number ++;
					}
				}
				unset($showRow);

				$retArr['res'] = true;
				$retArr['note'] = '完成 '. $page .'/'. $pageCount .'，总记录：'. $recordCount .'，每页：'. $pageSize .'（只统计检查时间'. $checkTime .'之前记录）';

				if ($page == $pageCount){
					$DB->query('update '. OT_dbPref .'autoRunSys set ARS_markNewsPage=0,ARS_markNewsPageCount='. $pageCount .',ARS_markNewsTime='. $DB->ForTime($todayTime));
				}else{
					$page ++;
					$DB->query('update '. OT_dbPref .'autoRunSys set ARS_markNewsPage='. $page .',ARS_markNewsPageCount='. $pageCount);
					$retArr['isEnd'] = false;
				}

				$Cache = new Cache();
				$Cache->Php('autoRunSys');
				return $retArr;

			}else{
				$retArr['note'] = '未到时间 '. $autoRunSysArr['ARS_markNewsTime'] .'['. $autoRunSysArr['ARS_markNewsDay'] .']';
				return $retArr;
			}
		}else{
			$retArr['note'] = '间隔天数为0，不作操作';
			return $retArr;
		}
	}


	// 自动配图
	public static function AutoImg($type=''){
		global $DB;

		$todayTime = TimeDate::Get();
		$checkTime = TimeDate::Add('s',-1,$todayTime);
		$day_1Time = TimeDate::Add('day',-1,$todayTime);
		$retArr = array('res'=>false, 'isEnd'=>true, 'note'=>'');

		$succNum = $failNum = 0;
		$pageSize = 100;
		$recordCount = $DB->GetOne('select count(1) from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1 and IF_imgMode=0');

		$chkexe = $DB->query('select IF_ID,IF_theme,IF_img,IF_imgMode,IF_type1ID,IF_type2ID from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1 and IF_imgMode=0 limit '. $pageSize);
		while ($row = $chkexe->fetch()){
			$img = '';
			$jpgPath = AppAutoImg::ImgAbsPath($row['IF_ID'], $row['IF_theme']);
			if (file_exists($jpgPath)){
				$img = AppAutoImg::ImgRelPath($row['IF_ID'], $row['IF_theme']);
			}else{
				if ($row['IF_type2ID'] > 0){
					$typeCurrID = $row['IF_type2ID'];
				}else{
					$typeCurrID = $row['IF_type1ID'];
				}
				$infoType = $DB->GetOne('select IT_theme from '. OT_dbPref .'infoType where IT_ID='. $typeCurrID);
				$isSave = AppAutoImg::MakeImg($row['IF_ID'], $row['IF_theme'], $infoType, 'save');
				if ($isSave){
					$img = AppAutoImg::ImgRelPath($row['IF_ID'], $row['IF_theme']);
				}
			}
			if (strlen($img) > 0){
				if (empty($infoSysArr)){ $infoSysArr = Cache::PhpFile('infoSys'); }
				$addiArr = Info::AdditionArr($infoSysArr['IS_addition']);
				$revArr = array();
				$revArr['IF_img']			= $img;
				$revArr['IF_imgMode']		= 10;
				$revArr['IF_isHomeThumb']	= $addiArr['autoImg_homeThumb'];
				$revArr['IF_isThumb']		= 1;
				$revArr['IF_isImg']			= $addiArr['autoImg_img'];
				$revArr['IF_isFlash']		= $addiArr['autoImg_flash'];
				$judRes = $DB->UpdateParam('info',$revArr,'IF_ID='. $row['IF_ID']);
					if ($judRes){
						$succNum ++;
					}else{
						$failNum ++;
					}
			}else{
				$failNum ++;
			}
		}
		unset($chkexe);
		
		if ($recordCount > $pageSize){
			$retArr['isEnd'] = false;
		}
		$retArr['res'] = true;
		$retArr['note'] = '完成 '. ($succNum + $failNum) .'（成功 '. $succNum .' 个，失败 '. $failNum .' 个），总记录：'. $recordCount .'，每页：'. $pageSize .'';

		// $Cache = new Cache();
		// $Cache->Php('autoRunSys');
		return $retArr;
	}

}

?>