<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}



class AdmIdc{

	// 四大产品信息
	public static function TypeArr($type){
		switch ($type){
			case 'host':		return array('part' => 'HU_',	'part2' => 'HD_');
			case 'vpsPro':		return array('part' => 'VPU_',	'part2' => 'VPD_');
			case 'vpsApi':
			case 'vps':			return array('part' => 'VAU_',	'part2' => 'VAD_');
			case 'dialing':		return array('part' => 'DU_',	'part2' => 'DD_');
			case 'pptp':		return array('part' => 'PU_',	'part2' => 'PD_');
			case 'serv':		return array('part' => 'SU_',	'part2' => 'SD_');
			case 'ssl':			return array('part' => 'SU_',	'part2' => 'SD_');
			case 'idcServVps':	return array('part' => 'ISV_',	'part2' => 'ISP_');
			default :		die($type .' 不是有效 TypeArr 类型');
		}
	}


	// 打开上级渠道商信息
	public static function CompanyInfoImg($companyID){
		if ($companyID > 0){
			$retStr = '<img src="images/img_company.gif" style="cursor:pointer;margin-left:3px;" valign="top" alt="查看上级渠道商详细信息" title="查看上级渠道商详细信息" onclick=\'OT_OpenCompanyImg("'. $companyID .'")\' />';
		}else{
			$retStr = '';
		}
		return $retStr;
	}


	// 打开上家名单信息
	public static function DealerInfoImg($dealerID){
		if ($dealerID > 0){
			$retStr = '<img src="images/img_dealer.png" style="cursor:pointer;margin-left:3px;" valign="top" alt="查看上家名单详细信息" title="查看上家名单详细信息" onclick=\'OT_OpenDealerImg("'. $dealerID .'")\' />';
		}else{
			$retStr = '';
		}
		return $retStr;
	}

	// 多产品查询
	public static function MoreProInfo($refMorePro, $type, $SQLstr, $proArr=array()){
		global $DB;

		$retStr = '&ensp;&ensp;<label><input type="checkbox" name="refMorePro" value="1" '. Is::Checked(in_array($refMorePro,array(1,2)) ? 1 : 0,1) .' />多产品查询</label>';
		if ($refMorePro == 1){
			$queryStr = OT::GetParam(array('dataTypeCN'));
			$infoArr = array();
			if (AppHost::Jud() && ((count($proArr) == 0 && $type != 'host') || in_array('host',$proArr) !== false)){
				$queryStr = str_replace('refIpStr','refWorkSign',$queryStr);
				$num = $DB->GetOne(str_replace(array('[OT_pref]ipStr','[OT_pref]','[OT_tab]'), array('HU_workSign','HU_','hostUsers'), $SQLstr));
				$infoArr[] = '<a href="hostUsers.php'. $queryStr .'&dataTypeCN='. urlencode('虚拟主机') .'" class="font3_1">虚拟主机 <span style="color:red;font-weight:bold;">'. $num .'</span> 台</a>';
			}
			if ((count($proArr) == 0 && $type != 'vpsApi') || in_array('vpsApi',$proArr) !== false){
				$queryStr = str_replace('refWorkSign','refIpStr',$queryStr);
				$num = $DB->GetOne(str_replace(array('[OT_pref]','[OT_tab]'), array('VAU_','vpsApiUsers'), $SQLstr));
				$infoArr[] = '<a href="vpsApiUsers.php'. $queryStr .'&dataTypeCN='. urlencode('云服务器') .'" class="font3_1">云服务器 <span style="color:red;font-weight:bold;">'. $num .'</span> 台</a>';
			}
			if (AppDialing::Jud() && ((count($proArr) == 0 && $type != 'dialing') || in_array('dialing',$proArr) !== false)){
				$queryStr = str_replace('refWorkSign','refIpStr',$queryStr);
				$num = $DB->GetOne(str_replace(array('[OT_pref]','[OT_tab]'), array('DU_','dialingUsers'), $SQLstr));
				$infoArr[] = '<a href="dialingUsers.php'. $queryStr .'&dataTypeCN='. urlencode('拨号VPS') .'" class="font3_1">拨号VPS <span style="color:red;font-weight:bold;">'. $num .'</span> 台</a>';
			}
			if (AppPptp::Jud() && ((count($proArr) == 0 && $type != 'pptp') || in_array('pptp',$proArr) !== false)){
				$queryStr = str_replace('refWorkSign','refIpStr',$queryStr);
				$num = $DB->GetOne(str_replace(array('[OT_pref]ipStr','[OT_pref]','[OT_tab]'), array('PU_vpsUser','PU_','pptpUsers'), $SQLstr));
				$infoArr[] = '<a href="pptpUsers.php'. $queryStr .'&dataTypeCN='. urlencode('PPTP') .'" class="font3_1">PPTP <span style="color:red;font-weight:bold;">'. $num .'</span> 台</a>';
			}
			if (AppServ::Jud() && ((count($proArr) == 0 && $type != 'serv') || in_array('serv',$proArr) !== false)){
				$queryStr = str_replace('refWorkSign','refIpStr',$queryStr);
				$num = $DB->GetOne(str_replace(array('[OT_pref]','[OT_tab]'), array('SU_','servUsers'), $SQLstr));
				$infoArr[] = '<a href="servUsers.php'. $queryStr .'&dataTypeCN='. urlencode('服务器租用') .'" class="font3_1">服务器租用 <span style="color:red;font-weight:bold;">'. $num .'</span> 台</a>';
			}
			if ((count($proArr) == 0 && $type != 'vpsDel') || in_array('del',$proArr) !== false){
				$queryStr = str_replace('refWorkSign','refIpStr',$queryStr);
				$num = $DB->GetOne(str_replace(array('[OT_pref]','[OT_tab]'), array('VDU_','vpsDelUsers'), $SQLstr));
				$infoArr[] = '<a href="vpsDelUsers.php'. $queryStr .'&dataTypeCN='. urlencode('机器回收站') .'" class="font3_2">机器回收站 <span style="color:red;font-weight:bold;">'. $num .'</span> 台</a>';
			}/*  */
			if (count($infoArr) > 0){
				$retStr .= '<div style="padding-top:15px;">（'. implode('，', $infoArr) .'）</div>';
			}
		}
		return $retStr;
	}



	// 四大产品详细页 显示会员信息
	public static function UserInfoTab($userID){
		global $DB,$skin;

		$userRemMoney = '';
		$userGroupID = 0;
		if ($userID > 0){
			$userexe = $DB->query('select * from '. OT_dbPref .'users where UE_ID='. $userID);
			if ($rs = $userexe->fetch()){
				$userRemMoney = $rs['UE_money'];
				$userGroupID = $rs['UE_groupID'];

				$shimingStr = $mailStr = $phoneStr = '';
				if ($rs['UE_cardState'] == 1){
					// $shimingStr = '&ensp;<span title="已实名认证" style="color:blue;"><img src="images/img_shiming.png" /></span>';
					$shimingStr = '&ensp;<span title="已实名认证" style="color:blue;">[手动实名]</span>';
				}elseif ($rs['UE_cardState'] == 11){
					$shimingStr = '&ensp;<span title="已实名认证" style="color:green;">[微信实名]</span>';
				}elseif ($rs['UE_cardState'] == 21){
					$shimingStr = '&ensp;<span title="已实名认证" style="color:green;">[支付宝实名]</span>';
				}else{
					$shimingStr = '&ensp;<span title="未实名认证" style="color:red;">[未实名]</span>';
				}
				if (strpos(''. $rs['UE_authStr'],'|邮箱|') !== false){
					$mailStr = '&ensp;<span title="邮箱已验证" style="color:blue;"><img src="images/img_yanzheng.png" /></span>';
				}
				if (strpos(''. $rs['UE_authStr'],'|手机|') !== false){
					$phoneStr = '&ensp;<span title="手机已验证" style="color:blue;"><img src="images/img_yanzheng.png" /></span>';
				}

				$skin->TableTop('share_list.gif','','用户信息<div style="float:right;margin-left:20px;color:#fd8383;cursor:pointer;" onclick=\'document.location.href="users.php?mudi=rev&dataType=&dataTypeCN='. urlencode('会员') .'&dataID='. $rs['UE_ID'] .'&nohrefStr=close&backURL="+ encodeURIComponent(document.location.href)\'>[修改]</div>');

					echo('
					<input type="hidden" id="userMoney" name="userMoney" value="'. $rs['UE_money'] .'" />

					<table style="width:100%" align="center" cellpadding="0" cellspacing="0" border="0" class="padd3">
					<tr>
						<td style="width:20%;"><span class="font3_2">用户名：</span>'. $rs['UE_username'] . AdmArea::UserInfoImg($rs['UE_ID']) .'</td>
						<td style="width:20%;"><span class="font3_2">用户组：</span>'. $DB->GetOne('select UG_theme from '. OT_dbPref .'userGroup where UG_ID='. $rs['UE_groupID']) .'</td>
						<td style="width:20%;"><span class="font3_2">昵称：</span>'. $rs['UE_realname'] .'</td>
						<td style="width:20%;">
							<span class="font3_2">金额：</span><span style="color:red;">'. $rs['UE_money'] .'</span> 元 
							<span onclick=\'OT_OpenUserMoney("&userID='. $rs['UE_ID'] .'")\' class="pointer" style="color:green;">【财务管理】</span>
						</td>
						<td style="width:20%;">&ensp;&ensp;<span class="font3_2">已消费：</span><span>'. $rs['UE_payMoney'] .'</span> 元</td>
						<td></td>
					</tr>
					<tr>
						<td colspan="3">
							<span class="font3_2">&ensp;&ensp;&ensp;&ensp;QQ：</span>'. AdmArea::UserQQ($rs['UE_qq'],'span') .'
							'. (strlen(''. $rs['UE_ww']) > 0 ? '&ensp;&ensp;&ensp;&ensp;<span class="font3_2">&ensp;&ensp;旺旺：</span>'. AdmArea::UserWw($rs['UE_ww']) : '') .'
							'. (strlen(''. $rs['UE_weixin']) > 0 ? '&ensp;&ensp;&ensp;&ensp;<span class="font3_2">微信：</span>'. $rs['UE_weixin'] : '') .'
						</td>
						<td><span class="font3_2">邮箱：</span>'. $rs['UE_mail'] . $mailStr .'</td>
						<td><span class="font3_2">&ensp;&ensp;&ensp;&ensp;手机：</span>'. $rs['UE_phone'] . $phoneStr .'</td>
					</tr>
					<tr>
						<td colspan="4"><span class="font3_2">&ensp;&ensp;备注：</span>'. $rs['UE_note'] .'</td>
						<td title="实名类型：'. $rs['UE_cardType'] .'&#13;实名姓名：'. $rs['UE_cardUser'] .'&#13;实名证号：'. $rs['UE_cardID'] .'"><span class="font3_2">实名认证：</span>'. $rs['UE_cardUser'] .''. $shimingStr .'</td>
					</tr>
					</table>
					');
				$skin->TableBottom();
				echo('<div style="height:10px;"></div>');
			}
			unset($userexe);
		}

		return array($userRemMoney, $userGroupID);
	}



	// 四大产品分类页 显示提醒处理信息
	public static function TixingTypeTab($type){
		global $DB,$skin,$dataType,$dataTypeCN,$dataMode,$dataModeStr;

		$ipTitle = 'IP地址';
		switch ($type){
			case 'host':	$ipTitle = '业务标识';		break;
			case 'pptp':	$ipTitle = 'PPTP用户名';	break;
			case 'ssl':		$ipTitle = '绑定域名';	break;
			case 'vpsPro':
			case 'vpsApi':
			case 'dialing':
			case 'serv':
				break;
			default :		die($type .' 不是有效类型');	break;
		}

		$tixingNum = $DB->GetOne('select count(TX_ID) from '. OT_dbPref .'tixing where TX_state=0 and TX_type='. $DB->ForStr($type));
		if ($tixingNum > 0){
			$skin->TableTop2('share_list.gif','',''. '前10条待确认（共'. $tixingNum .'条）&ensp;&ensp;<label style="font-weight:normal;"><input type="checkbox" id="skipEndTime" name="skipEndTime" value="1" />忽略到期时间不匹配</label>&ensp;&ensp;<label style="font-weight:normal;"><input type="checkbox" id="skipState" name="skipState" value="1" />忽略状态不匹配</label>');
			$skin->TableItemTitle('4%,15%,12%,10%,11%,15%,15%,5%,13%','序号,产品名称,'. $ipTitle .',用户名,价格/费用,原到期/开通时间,延期至/到期时间,类型,财务&ensp;详细&ensp;同意&ensp;拒绝');

			$showexe=$DB->query('select TX_ID,TX_type,TX_type2,TX_userID,TX_username,TX_payMode,TX_price,TX_cost,TX_startTime,TX_endTime,TX_dataID,TX_dataName,TX_ipStr,TX_payNum,TX_vpsName from '. OT_dbPref .'tixing where TX_state=0 and TX_type='. $DB->ForStr($type) .' order by TX_ID DESC limit 10');
			echo('<tbody class="tabBody padd3td">');
			$number = 1;
			while ($row = $showexe->fetch()){
				if ($number % 2 == 1){ $bgcolor='class="tabColorTr"'; }else{ $bgcolor=''; }
				if ($type == 'pptp'){
					$ipStr = ''. $row['TX_ipStr'] .'['. $row['TX_payNum'] .']';
					$priceStr = AppPptp::PayMode($row['TX_payNum'],$row['TX_payMode']);
				}else{
					$ipStr = IdcArea::IpStr($row['TX_ipStr']);
					$priceStr = IdcInfo::PayMode($row['TX_payMode']);
				}

				echo('
				<tr id="tixingData'. $row['TX_ID'] .'" '. $bgcolor .'>
					<td align="center">'. $number .'</td>
					<td align="center">'. $row['TX_dataName'] .'</td>
					<td align="center" style="word-break:break-all;">'. $ipStr .'</td>
					<td align="center">'. $row['TX_username'] . AdmArea::UserInfoImg($row['TX_userID']) .'</td>
					<td align="center" title="成本：'. $row['TX_cost'] .'">'. $priceStr .'：'. $row['TX_price'] .'</td>
					<td align="center">'. $row['TX_startTime'] .'</td>
					<td align="center">'. $row['TX_endTime'] .'</td>
					<td align="center">'. $row['TX_type2'] .'</td>
					<td align="center">
						<img src="images/img_money.gif" class="pointer" onclick=\'OT_OpenMoneyRecord("&refVpsName='. $row['TX_vpsName'] .'")\' alt="财务信息" title="财务信息" />&ensp;&ensp;
						<img src="images/img_det.gif" style="cursor:pointer" onclick=\'var a=window.open("?mudi=show&nohrefStr=close&dataMode='. $dataMode .'&dataModeStr='. $dataModeStr .'&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&dataID='. $row['TX_dataID'] .'")\' alt="详细" title="详细" />&ensp;&ensp;
						<img src="images/img_yes.gif" class="pointer" onclick=\'TixingDeal("同意","'. $row['TX_type2'] .'","tixing_deal.php?mudi=deal&mode=yes&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&theme='. urlencode($row['TX_dataName']) .'&dataID='. $row['TX_ID'] .'")\' alt="同意" title="同意" />&ensp;
						<img src="images/img_err.gif" class="pointer" onclick=\'TixingDeal("拒绝","'. $row['TX_type2'] .'","tixing_deal.php?mudi=deal&mode=no&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&theme='. urlencode($row['TX_dataName']) .'&dataID='. $row['TX_ID'] .'")\' alt="拒绝" title="拒绝" />
					</td>
				</tr>
				');
				$number ++;
			
			}
			unset($showexe);

			echo('
			</table>
			<div style="height:10px;"></div>
			');
		}
	}



	// 四大产品详细页 显示提醒处理信息
	public static function TixingTab($type, $dataID, $proName, $vpsName, $ipStr){
		global $DB,$skin,$dataType,$dataTypeCN;

		$ipTitle = 'IP地址';
		switch ($type){
			case 'host':	$ipTitle = '业务标识';		break;
			case 'pptp':	$ipTitle = 'PPTP用户名';	break;
			case 'vpsPro':
			case 'vpsApi':
			case 'dialing':
			case 'serv':
			case 'ssl':
				break;
			default :		die($type .' 不是有效类型');	break;
		}

		$texe = $DB->query('select TX_ID,TX_type,TX_type2,TX_username,TX_payMode,TX_price,TX_cost,TX_startTime,TX_endTime,TX_dataID,TX_payNum from '. OT_dbPref .'tixing where TX_dataID='. $dataID .' and TX_type='. $DB->ForStr($type) .' and TX_state=0');
		if ($trow = $texe->fetch()){
			if ($type == 'pptp'){
				$payModeStr = AppPptp::PayMode($trow['PT_payNum'],$trow['PT_payMode']);
			}else{
				$payModeStr = IdcInfo::PayMode($trow['TX_payMode']);
			}
			$skin->TableTop2('share_list.gif','',''. '待确认处理&ensp;&ensp;<label style="font-weight:normal;"><input type="checkbox" id="skipEndTime" name="skipEndTime" value="1" />忽略到期时间不匹配</label>&ensp;&ensp;<label style="font-weight:normal;"><input type="checkbox" id="skipState" name="skipState" value="1" />忽略状态不匹配</label>');
			$skin->TableItemTitle('18%,13%,10%,11%,15%,15%,5%,13%','产品名称,'. $ipTitle .',用户名,价格/费用,原到期/开通时间,延期至/到期时间,类型,财务&ensp;同意&ensp;拒绝');
			echo('
			<tbody class="tabBody padd3td">
			<tr>
				<td align="center">'. $proName .'</td>
				<td align="center" style="word-break:break-all;">'. $ipStr .'</td>
				<td align="center">'. $trow['TX_username'] .'</td>
				<td align="center" title="成本：'. $trow['TX_cost'] .'">'. $payModeStr .'：'. $trow['TX_price'] .'</td>
				<td align="center">'. $trow['TX_startTime'] .'</td>
				<td align="center">'. $trow['TX_endTime'] .'</td>
				<td align="center">'. $trow['TX_type2'] .'</td>
				<td align="center">
					<img src="images/img_money.gif" class="pointer" onclick=\'OT_OpenMoneyRecord("&refVpsName='. $vpsName .'&refUsername='. $trow['TX_username'] .'")\' alt="财务信息" title="财务信息" />&ensp;&ensp;
					<img src="images/img_yes.gif" class="pointer" onclick=\'TixingDeal("同意","'. $trow['TX_type2'] .'","'. $type .'Users_deal.php?mudi=tixingDeal&mudi2=det&mode=yes&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&theme='. urlencode($proName) .'&dataID='. $trow['TX_ID'] .'")\' alt="同意" title="同意" />&ensp;
					<img src="images/img_err.gif" class="pointer" onclick=\'TixingDeal("拒绝","'. $trow['TX_type2'] .'","'. $type .'Users_deal.php?mudi=tixingDeal&mudi2=det&mode=no&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&theme='. urlencode($proName) .'&dataID='. $trow['TX_ID'] .'")\' alt="拒绝" title="拒绝" />
				</td>
			</tr>
			</table>
			<div style="height:10px;"></div>
			');
		}

	}



	// 四大产品详细页 显示提醒处理信息（后期废弃）
	public static function TixingTab222($type, $dataID, $proName, $vpsName, $ipStr){
		global $DB,$skin,$dataType,$dataTypeCN;

		$ipTitle = 'IP地址';
		$whereStr = '';
		switch ($type){
			case 'host':	$tabPart = 'HT_';	$ipTitle = '业务标识';		break;
			case 'vpsPro':	$tabPart = 'VPT_';		break;
			case 'vpsApi':	$tabPart = 'VAT_';		break;
			case 'dialing':	$tabPart = 'DT_';		break;
			case 'pptp':	$tabPart = 'PT_';	$ipTitle = 'PPTP用户名'; $whereStr = ',PT_payNum';	break;
			case 'serv':	$tabPart = 'ST_';		break;
			case 'ssl':		$tabPart = 'ST_';		break;
			default :		die($type .' 不是有效类型');	break;
		}

		$texe = $DB->query('select '. $tabPart .'ID,'. $tabPart .'type,'. $tabPart .'username,'. $tabPart .'payMode,'. $tabPart .'price,'. $tabPart .'cost,'. $tabPart .'startTime,'. $tabPart .'endTime,'. $tabPart .'dataID'. $whereStr .' from '. OT_dbPref . $type .'Tixing where '. $tabPart .'dataID='. $dataID .' and '. $tabPart .'state=0');
		if ($trow = $texe->fetch()){
			if ($type == 'pptp'){
				$payModeStr = AppPptp::PayMode($trow['PT_payNum'],$trow['PT_payMode']);
			}else{
				$payModeStr = IdcInfo::PayMode($trow[$tabPart .'payMode']);
			}
			$skin->TableTop2('share_list.gif','',''. '待确认处理&ensp;&ensp;<label style="font-weight:normal;"><input type="checkbox" id="skipEndTime" name="skipEndTime" value="1" />忽略到期时间不匹配</label>&ensp;&ensp;<label style="font-weight:normal;"><input type="checkbox" id="skipState" name="skipState" value="1" />忽略状态不匹配</label>');
			$skin->TableItemTitle('18%,13%,10%,11%,15%,15%,5%,13%','产品名称,'. $ipTitle .',用户名,价格/费用,原到期/开通时间,延期至/到期时间,类型,财务&ensp;同意&ensp;拒绝');
			echo('
			<tbody class="tabBody padd3td">
			<tr>
				<td align="center">'. $proName .'</td>
				<td align="center" style="word-break:break-all;">'. $ipStr .'</td>
				<td align="center">'. $trow[$tabPart .'username'] .'</td>
				<td align="center" title="成本：'. $trow[$tabPart .'cost'] .'">'. $payModeStr .'：'. $trow[$tabPart .'price'] .'</td>
				<td align="center">'. $trow[$tabPart .'startTime'] .'</td>
				<td align="center">'. $trow[$tabPart .'endTime'] .'</td>
				<td align="center">'. $trow[$tabPart .'type'] .'</td>
				<td align="center">
					<img src="images/img_money.gif" class="pointer" onclick=\'OT_OpenMoneyRecord("&refVpsName='. $vpsName .'&refUsername='. $trow[$tabPart .'username'] .'")\' alt="财务信息" title="财务信息" />&ensp;&ensp;
					<img src="images/img_yes.gif" class="pointer" onclick=\'TixingDeal("同意","'. $trow[$tabPart .'type'] .'","'. $type .'Users_deal.php?mudi=tixingDeal&mudi2=det&mode=yes&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&theme='. urlencode($proName) .'&dataID='. $trow[$tabPart .'ID'] .'")\' alt="同意" title="同意" />&ensp;
					<img src="images/img_err.gif" class="pointer" onclick=\'TixingDeal("拒绝","'. $trow[$tabPart .'type'] .'","'. $type .'Users_deal.php?mudi=tixingDeal&mudi2=det&mode=no&dataType='. $dataType .'&dataTypeCN='. urlencode($dataTypeCN) .'&theme='. urlencode($proName) .'&dataID='. $trow[$tabPart .'ID'] .'")\' alt="拒绝" title="拒绝" />
				</td>
			</tr>
			</table>
			<div style="height:10px;"></div>
			');
		}

	}


	// 四大产品详细页 产品资料管理
	public static function ProManageTab($type, $dataID, $vpsRow=null, $proRow=null){
		global $DB,$skin,$dataType,$dataTypeCN;

		$tabArr = self::TypeArr($type);
		$part = $tabArr['part'];
		$part2 = $tabArr['part2'];

		if (empty($vpsRow)){
			$vpsRow = $DB->GetRow('select * from '. OT_dbPref . $type .'Users where '. $part .'ID='. $dataID);
			if (! $vpsRow){ JS::AlertCloseEnd('指定机器ID错误'); }
		}
		if (empty($proRow)){
			$proRow = $DB->GetRow('select '. $part2 .'theme,'. $part2 .'companyID from '. OT_dbPref . $type .'Data where '. $part2 .'ID='. $vpsRow[$part .'proDataID']);
			if (! $proRow){ JS::AlertCloseEnd('搜索不到该记录所属的产品相关信息'); }
		}

		$ipStr = $note = '';
		$funStr = '无';
		switch ($type){
			case 'host':
				$itemName = '虚拟主机';

				if ($vpsRow['HU_apiID'] == 0){
					$trWidth = '4%,15%,12%,13%,11%,8%,8%,8%,5%,8%';
					$trTitile = '序号,产品名称,用户名/机器编码,业务标识,价格/成本,开通时间,到期时间,API到期,状态,操作';
					$ipStr = '
						<div id="ipStrBox">
							'. $vpsRow['HU_workSign'] .'
							<div style="color:blue;cursor:pointer;" onclick="OpenIpStrRevBox(1)">[修改]</div>
						</div>
						<div id="ipStrRevBox" style="text-align:left;display:none;">
							<form method="post" id="dealIpStrForm" name="dealIpStrForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=ipStr" onsubmit="return CheckMoreForm(\'ipStr\')">
							<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
							<input type="hidden" name="dataID" value="'. $dataID .'" />
							<textarea id="ipStr" name="ipStr" style="width:155px;height:30px;">'. $vpsRow['HU_workSign'] .'</textarea>
							<div style="width:155px;">
								<div style="float:right;margin-top:5px;color:blue;cursor:pointer;" onclick="OpenIpStrRevBox(0)">[取消]</div>
								<input type="submit" value="确定修改" style="margin-top:2px;" />
							</div>
							</form>
						</div>
						';
				}else{
					$trWidth = '4%,15%,12%,13%,11%,8%,8%,8%,5%,8%,8%';
					$trTitile = '序号,产品名称,用户名/机器编码,业务标识,价格/成本,开通时间,到期时间,API到期,状态,同步,操作';
					$ipStr = '
						'. $vpsRow['HU_workSign'] .'
						<div style="color:blue;cursor:pointer;" title="用户区面板打开有错误时，可以点击该按钮试试。" onclick=\'if(confirm("你确定要清空服务码和口令？\n\n用户区面板打开有错误时，可以点击该按钮试试。")==true){DataDeal.location.href="hostUsers_deal.php?mudi=clearServerCode&dataID='. $vpsRow['HU_ID'] .'"}\'>[清空服务码]</div>
						';
					$funStr = '<a href="hostUsers.php?mudi=cpManage&dataID='. $vpsRow['HU_ID'] .'" target="_blank" style="color:red;">用户区面板</a>';
				}
				break;

			case 'vpsApi':
				$itemName = '云服务器';
			case 'dialing':
				if (! isset($itemName)){ $itemName = '拨号VPS'; }
			case 'serv':
				if (! isset($itemName)){ $itemName = '服务器租用'; }

				if ($vpsRow[$part .'apiID'] == 0 || $type == 'serv'){
					$trWidth = '5%,13%,13%,15%,12%,10%,10%,10%,6%,6%';
					$trTitile = '序号,产品名称,用户名/机器编码,已分配IP地址,价格/成本,开通时间,到期时间,API到期,状态,操作';
					$ipStr = '
						<div id="ipStrBox">
							'. IdcArea::IpStr($vpsRow[$part .'ipStr']) .'
							<div style="color:blue;cursor:pointer;" onclick="OpenIpStrRevBox(1)">[修改]</div>
						</div>
						<div id="ipStrRevBox" style="text-align:left;display:none;">
							<form method="post" id="dealIpStrForm" name="dealIpStrForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=ipStr" onsubmit="return CheckMoreForm(\'ipStr\')">
							<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
							<input type="hidden" name="dataID" value="'. $dataID .'" />
							<textarea id="ipStr" name="ipStr" style="width:155px;height:100px;">'. $vpsRow[$part .'ipStr'] .'</textarea>
							<div style="width:155px;">
								<div style="float:right;margin-top:5px;color:blue;cursor:pointer;" onclick="OpenIpStrRevBox(0)">[取消]</div>
								<input type="submit" value="确定修改" style="margin-top:2px;" />
							</div>
							</form>
						</div>
						';
				}else{
					$trWidth = '4%,14%,12%,13%,11%,8%,8%,8%,6%,8%,8%';
					$trTitile = '序号,产品名称,用户名/机器编码,已分配IP地址,价格/成本,开通时间,到期时间,API到期,状态,同步,操作';
					if ($vpsRow[$part .'state'] == 3){
						if ($vpsRow[$part .'apiID'] == 2){	// 2景安网络
							$ipStr = '
								订单号：<span style="color:red;">'. $vpsRow[$part .'orderId'] .'</span>
								<div><a href="https://mc.zzidc.com/order/list?s=total" target="_blank" style="color:blue;">[景安我的订单]</a></div>
								<div><a href="https://mc.zzidc.com/gift/testcodelist" target="_blank" style="color:blue;">[景安产品测试码]</a></div>
								';
							$funStr = '
								<div style="margin-bottom:8px;"><a href="#" style="color:blue;" onclick="AjaxGetDeal(\''. $type .'Users_deal.php?mudi=useTestCode&dataID='. $vpsRow[$part .'ID'] .'\');">有'. $DB->GetOne('select count(JC_ID) from '. OT_dbPref .'jinganCode where JC_state=0') .'个测试码<br />用测试码开通</a></div>
								<a href="#" style="color:red;" onclick="AjaxGetDeal(\''. $type .'Users_deal.php?mudi=checkKaitong&dataID='. $vpsRow[$part .'ID'] .'\');">检测开通状态</a>
								';
							$note = '<div style="padding:6px;color:red;">提醒：【用测试码开通】直接使用预存的测试码开通试用；【检测开通状态】人为到景安平台上开通试用，然后点击该菜单获取信息及更正状态。</div>';
						}
					}else{
						$ipStr = '
							<div style="line-height:1.2;">'. IdcArea::IpStr($vpsRow[$part .'ipStr']) .'</div>
							<div style="color:blue;cursor:pointer;" onclick=\'DataDeal.location.href="'. $type .'Users_deal.php?mudi=updateWorkInfo&dataID='. $vpsRow[$part .'ID'] .'"\'>[更新业务信息]</div>
							';
						$funStr = '<a href="'. $type .'Users.php?mudi=cpManage&dataID='. $vpsRow[$part .'ID'] .'" target="_blank" style="color:red;">用户区面板</a>';
					}

					if ($vpsRow[$part .'apiID'] == 1 && in_array($vpsRow[$part .'state'],array(3,6))){
						$funStr = '<a href="#" style="color:red;" onclick="opener.location.href=\''. $type .'Users.php?mudi=add&mudi2=copy&proDataID='. $vpsRow[$part .'proDataID'] .'&dataTypeCN=%E4%BA%91%E6%9C%8D%E5%8A%A1%E5%99%A8&dataID='. $vpsRow[$part .'ID'] .'&backURL='. $type .'Users.php%3Fmudi%3Dmanage%26dataTypeCN%3D%25E4%25BA%2591%25E6%259C%258D%25E5%258A%25A1%25E5%2599%25A8\';window.close();">重新开通</a>';
					}
				}
				break;

			case 'pptp':
				$itemName = 'PPTP';
				$trWidth = '4%,14%,12%,13%,11%,8%,8%,8%,6%,8%,8%';
				$trTitile = '序号,产品名称,用户名/机器编码,用户名/连接数/用户数,价格/成本,开通时间,到期时间,API到期,状态,同步,操作';
				if ($vpsRow['PU_state'] == 3){
				}else{
					$ipStr = '<div style="line-height:1.2;">'. $vpsRow['PU_vpsUser'] .'<div>连接数:'. $vpsRow['PU_linkNum'] .'</div></div>';
					$funStr = '';
				}
				break;

			case 'ssl':
				$itemName = 'SSL证书';
				$trWidth = '5%,13%,13%,15%,12%,10%,10%,10%,6%,6%';
				$trTitile = '序号,产品名称,用户名/机器编码,绑定域名,价格/成本,开通时间,到期时间,API到期,状态,操作';
				$ipStr = '
					<div id="ipStrBox">
						'. IdcArea::IpStr($vpsRow['SU_domain']) .'
						<div id="pwd'. $vpsRow['SU_ID'] .'Box" style="color:red;display:none;">'. Encrypt::SyEnDe('de',$vpsRow['SU_vpsPwd']) .'</div>
						<div style="margin-top:5px;">
							<span style="color:red;cursor:pointer;" onclick="OpenIpStrRevBox(1)">[修改]</span>
							<a href="'. Area::InfoImgUrl($vpsRow['SU_sslFile'], DownloadFileAdminDir) .'" class="font3_2" target="_blank">[下载证书]</a>
							<span style="color:#bdbcbc;cursor:pointer;" onclick="ClickShowHidden(\'pwd'. $vpsRow['SU_ID'] .'Box\')">密码</span>
						</div>
					</div>
					<div id="ipStrRevBox" style="text-align:left;display:none;">
						<form method="post" id="dealIpStrForm" name="dealIpStrForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=domain" onsubmit="return CheckMoreForm(\'domain\')">
						<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
						<input type="hidden" name="dataID" value="'. $dataID .'" />
						<textarea id="domain" name="domain" style="width:155px;height:100px;">'. $vpsRow['SU_domain'] .'</textarea>
						<div style="width:155px;">
							<div style="float:right;margin-top:5px;color:blue;cursor:pointer;" onclick="OpenIpStrRevBox(0)">[取消]</div>
							<input type="submit" value="确定修改" style="margin-top:2px;" />
						</div>
						</form>
					</div>
					';
				break;

			case 'idcServVps':
				$itemName = '母机机器';
				$trWidth = '4%,14%,12%,13%,11%,8%,8%,6%,8%';
				$trTitile = '序号,产品名称,用户名/机器编码,已分配IP地址,价格/成本,开通时间,到期时间,状态,操作';
				$ipStr = '<div style="line-height:1.2;">'. IdcArea::IpStr($vpsRow['ISV_ipStr']) .'</div>';
				$funStr = '<a href="idcServVps.php?mudi=cpManage&dataID='. $vpsRow['ISV_ID'] .'" target="_blank" style="color:red;">用户区面板</a>';
				break;

			default :
				die($type .' 不是有效 TypeArr 类型');
		}

		$skin->TableTop2('share_list.gif','',$itemName .'管理');
		$skin->TableItemTitle($trWidth, $trTitile);
			if ($type == 'pptp'){
				$payModeStr = AppPptp::PayMode($vpsRow['PU_payNum'],$vpsRow['PU_payMode']);
			}else{
				$payModeStr = IdcInfo::PayMode($vpsRow[$part .'payMode']);
			}

			if ($type == 'ssl' || $type == 'idcServVps'){
				$companyStr = '';
			}else{
				$companyStr = AdmIdc::CompanyInfoImg($proRow[$part2 .'companyID']);
			}

			if ($type == 'idcServVps'){
				$vpsEndTimeStr = '';
				$priceStr = '
					'. $payModeStr .'：'. $vpsRow[$part .'price'] .'
					<div style="color:blue;cursor:pointer;margin-top:5px;" onclick=\'OT_OpenIdcMoneyRecord("&refVpsName='. $vpsRow[$part .'vpsName'] .'")\'>[此产品财务]</div><!-- <br />成本：'. $vpsRow[$part .'cost'] .' / &refUsername='. $vpsRow[$part .'username'] .' -->
					';
				$stateStr = AppIdcServ::State($vpsRow[$part .'state']);
			}else{
				$vpsEndTimeStr = '
					<td align="center">
						'. $vpsRow[$part .'vpsEndTime'] .'
						<div style="color:red;">['. TimeDate::DiffDayCN($vpsRow[$part .'vpsEndTime'],'剩') .']</div>
					</td>
					';
				$priceStr = '
					'. $payModeStr .'：'. $vpsRow[$part .'price'] .'<br />成本：'. $vpsRow[$part .'cost'] .'
					<div style="color:blue;cursor:pointer;margin-top:5px;" onclick=\'OT_OpenMoneyRecord("&refVpsName='. $vpsRow[$part .'vpsName'] .'")\'>[此产品财务]</div><!-- &refUsername='. $vpsRow[$part .'username'] .' -->
					';
				$stateStr = IdcInfo::State($vpsRow[$part .'state']);
			}

			if ( strlen(''. $proRow[$part2 .'theme']) > 1 ){
				$themeStr = $proRow[$part2 .'theme'];
			}else{
				$themeStr = '<span style="text-decoration:line-through;colr:#666;">'. $vpsRow[$part .'proDataName'] .'</span>';
			}

			$apiStr = '';
			if (in_array($type,array('host','vpsApi','dialing','pptp'))){
				if ($vpsRow[$part .'apiID'] == 0){
				
				}else{
					$lastApiTimeStr = '';
					if (in_array($type,array('host','vpsApi'))){
						$lastApiTimeStr = '，最后API更新时间：'. $vpsRow[$part .'lastApiTime'];
					}
					$apiStr = '
					<td align="center">
						<input type="button" value="API同步" style="width:65px;padding:3px 5px;" title="IP和API到期与上级同步'. $lastApiTimeStr .'" onclick=\'if(confirm("你确定要API同步？")==true){DataDeal.location.href="'. $type .'Users_deal.php?mudi=sync&mudi2=api&theme='. urlencode($vpsRow[$part .'vpsName']) .'&dataID='. $vpsRow[$part .'ID'] .'"}\' />
						<input type="button" value="到期同步" style="width:65px;padding:3px 5px;margin-top:3px;" title="“到期时间”改成和“API到期”一样" onclick=\'if(confirm("你确定要到期同步？")==true){DataDeal.location.href="'. $type .'Users_deal.php?mudi=sync&mudi2=endTime&theme='. urlencode($vpsRow[$part .'vpsName']) .'&dataID='. $vpsRow[$part .'ID'] .'"}\' />
					</td>
					';
					/* }elseif ($type == 'idcServVps'){
					$apiStr = '
					<td align="center">
						<input type="button" value="API同步" style="width:65px;padding:3px 5px;" title="IP和API到期与上级同步" onclick=\'if(confirm("你确定要API同步？")==true){DataDeal.location.href="'. $type .'_deal.php?mudi=sync&mudi2=api&theme='. urlencode($vpsRow[$part .'vpsName']) .'&dataID='. $vpsRow[$part .'ID'] .'"}\' />
					</td>
					'; */
				}
			}

			echo('
			<tbody class="tabBody padd5td">
			<tr>
				<td align="center">'. $vpsRow[$part .'ID'] .'</td>
				<td align="center">'. $themeStr . $companyStr .'</td>
				<td align="center">
					'. $vpsRow[$part .'username'] . AdmArea::UserInfoImg($vpsRow[$part .'userID']) .'
					<div style="margin-top:3px;">'. $vpsRow[$part .'vpsName'] .'</div>
				</td>
				<td align="center" style="line-height:1.6;">'. $ipStr .'</td>
				<td align="center">'. $priceStr .'</td>
				<td align="center">'. $vpsRow[$part .'time'] .'</td>
				<td align="center">
					'. $vpsRow[$part .'endTime'] .'
					<div style="color:red;">['. TimeDate::DiffDayCN($vpsRow[$part .'endTime'],'剩') .']</div>
				</td>
				'. $vpsEndTimeStr .'
				<td align="center">'. $stateStr .'</td>
				'. $apiStr .'
				<td align="center">'. $funStr .'</td>
			</tr>
			</tbody>
		</table>
		'. $note .'
		<div style="height:10px;"></div>
		');
	}


	// 四大产品详细页 查看资料
	public static function TrZiliao($type, $dataID, $vpsRow){
		global $DB,$skin,$dataType,$dataTypeCN;

		$tabArr = self::TypeArr($type);
		$part = $tabArr['part'];
		echo('
		<tr>
			<td align="center">查看资料</td>
			<td align="left">
				<table cellpadding="0" cellspacing="0">
				');
				if ( in_array($type,array('vpsPro','vpsApi','serv','dialing')) ){
					$vpsSysArr = Cache::PhpFile('vpsSys');
					$vpsRow[$part .'vpsPort'] = IdcArea::VpsDefPort($vpsRow[$part .'system'], $vpsRow[$part .'vpsPort']);
					$vpsRow[$part .'vpsUser'] = IdcArea::VpsDefUsername($vpsRow[$part .'system'], $vpsRow[$part .'vpsUser']);
					$oneIpArr = explode('<br />',IdcArea::IpStr($vpsRow[$part .'ipStr']));
					echo('
					<tr>
						<td style="padding:3px;" align="right" valign="top">默认远程账号：</td>
						<td style="padding:3px;line-height:1.4;">
							<div style="color:blue;">'. Str::MoreReplace($vpsSysArr['VS_ipInfoTishi1'],'html') .'</div>
							IP：'. $oneIpArr[0] .' &ensp;&ensp;
							'. ($type=='dialing' ? '' : '端口：'. $vpsRow[$part .'vpsPort'] .' &ensp;&ensp;') .'
							用户名：'. $vpsRow[$part .'vpsUser'] .' &ensp;&ensp;
							密码：'. Encrypt::SyEnDe('de',$vpsRow[$part .'vpsPwd']) .'
							<div style="color:red;">'. Str::MoreReplace($vpsSysArr['VS_ipInfoTishi2'],'html') .'</div>
						</td>
					</tr>
					');
				}elseif ($type == 'pptp'){
					echo('
					<tr>
						<td style="padding:3px;" align="right">PPTP账号：</td>
						<td style="padding:3px;">
							用户ID：'. $vpsRow[$part .'vpsID'] .'&ensp;&ensp;
							用户名：'. $vpsRow[$part .'vpsUser'] .'&ensp;&ensp;
							密码：'. Encrypt::SyEnDe('de',$vpsRow[$part .'vpsPwd']) .'&ensp;&ensp;
							连接数：'. $vpsRow[$part .'linkNum'] .'&ensp;&ensp;
						</td>
					</tr>
					');
				}elseif ($type == 'host'){
					echo('
					<tr>
						<td style="padding:3px;" align="right">状态：</td>
						<td style="padding:3px;">'. IdcInfo::AuthCN($vpsRow[$part .'isAuth']) .'</td>
					</tr>
					<tr>
						<td style="padding:3px;" align="right">域名：</td>
						<td style="padding:3px;">'. $vpsRow[$part .'domain'] .'</td>
					</tr>
					');
				}
				if ($vpsRow[$part .'apiID'] == 2){
					echo('
					<tr>
						<td style="padding:3px;" align="right">景安服务码：</td>
						<td style="padding:3px;">
							服务码：'. Encrypt::SyEnDe('de',$vpsRow[$part .'serverCode']) .' &ensp;&ensp;
							服务码口令：'. Encrypt::SyEnDe('de',$vpsRow[$part .'serverPwd']) .'
						</td>
					</tr>
					');
				}
				echo('
				<tr>
					<td style="padding:3px;" align="right">续费次数：</td>
					<td style="padding:3px;">'. $vpsRow[$part .'xufeiNum'] .'</td>
				</tr>
				<tr>
					<td style="padding:3px;" align="right" valign="top">用户备注：</td>
					<td style="padding:3px;">'. $vpsRow[$part .'userNote'] .'</td>
				</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td align="center">修改资料</td>
			<td align="left">
				<form method="post" id="noteForm" name="noteForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=ziliao" onsubmit="return CheckMoreForm(\'ziliao\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<input type="hidden" name="apiID" value="'. $vpsRow[$part .'apiID'] .'" />
				<table cellpadding="0" cellspacing="0">
				');
				// host、vpsPro、vpsApi、dialing、serv、pptp、ssl
				if (! in_array($type,array('pptp','ssl'))){
					if ( in_array($type,array('host')) ){
						$optionStr = '
							<option value=""></option>
							<option value="window" '. Is::Selected($vpsRow[$part .'system'],'window') .'>window（asp/asp.net）</option>
							<option value="linux" '. Is::Selected($vpsRow[$part .'system'],'linux') .'>linux（php）</option>
							';
					}else{
						if ($type == 'vpsApi' && $vpsRow[$part .'apiID'] == 6){
							$optionStr = '
								<option value="'. $vpsRow[$part .'system'] .'">'. $vpsRow[$part .'osName'] .'</option>
								';
						}else{
							$sysOption = '';
							if ($type == 'vpsApi' && $vpsRow[$part .'apiID'] == 2){
								$sysOption = IdcArea::JinganSystemOption($vpsRow[$part .'companyID'], $vpsRow[$part .'system']);
							}
							$optionStr = '
								<option value=""></option>
								'. $sysOption .'
								<option value="win2003" '. Is::Selected($vpsRow[$part .'system'],'win2003') .'>windows 2003</option>
								<option value="win2008" '. Is::Selected($vpsRow[$part .'system'],'win2008') .'>windows 2008</option>
								<option value="win2012" '. Is::Selected($vpsRow[$part .'system'],'win2012') .'>windows 2012</option>
								<option value="win2016" '. Is::Selected($vpsRow[$part .'system'],'win2016') .'>windows 2016</option>
								<option value="win2019" '. Is::Selected($vpsRow[$part .'system'],'win2019') .'>windows 2019</option>
								<option value="win2022" '. Is::Selected($vpsRow[$part .'system'],'win2022') .'>windows 2022</option>
								<option value="centos" '. Is::Selected($vpsRow[$part .'system'],'centos') .'>CentOS</option>
								<option value="ubuntu" '. Is::Selected($vpsRow[$part .'system'],'ubuntu') .'>Ubuntu</option>
								<option value="debian" '. Is::Selected($vpsRow[$part .'system'],'debian') .'>Debian</option>
								<option value="windows" '. Is::Selected($vpsRow[$part .'system'],'windows') .'>Windows</option>
								<option value="linux" '. Is::Selected($vpsRow[$part .'system'],'linux') .'>Linux</option>
								';
						}
					}
					echo('
					<tr>
						<td style="padding:3px;padding-top:6px;" align="right" valign="top">操作系统</td>
						<td style="padding:3px;">
							<select id="system" name="system">
							'. $optionStr .'
							</select>
						</td>
					</tr>
					');
					if ( in_array($type,array('vpsPro','vpsApi','serv','dialing')) ){
						echo('
						<tr>
							<td style="padding:3px;padding-top:6px;" align="right" valign="top">远程信息</td>
							<td style="padding:3px;">
								<label><input type="checkbox" id="isRevInfo" name="isRevInfo" value="1" onclick="CheckedShowHidden(\'isRevInfo\',\'revInfoBox\')" />修改</label>
								<span id="revInfoBox" style="display:none;">
								&ensp;&ensp;端口：<input type="text" name="vpsPort" style="width:70px;" value="'. $vpsRow[$part .'vpsPort'] .'" />
								&ensp;&ensp;用户名：<input type="text" name="vpsUser" style="width:150px;" value="'. $vpsRow[$part .'vpsUser'] .'" />
								&ensp;&ensp;密码：<input type="text" name="vpsPwd" style="width:150px;" value="'. Encrypt::SyEnDe('de',$vpsRow[$part .'vpsPwd']) .'" />
								</span>
							</td>
						</tr>
						');
					}
					if ( in_array($type,array('serv')) ){
						echo('
						<tr>
							<td style="padding:3px;padding-top:6px;" align="right" valign="top">所属上家</td>
							<td style="padding:3px;">
								<select id="dealerID" name="dealerID">
								<option value="0">无</option>
								');
								$typeexe = $DB->query('select VDL_ID,VDL_theme from '. OT_dbPref .'vpsDealerList where VDL_type="serv"');
								while ($rs = $typeexe->fetch()){
									echo('<option value="'. $rs['VDL_ID'] .'" '. Is::Selected($rs['VDL_ID'],$vpsRow[$part .'dealerID']) .'>'. $rs['VDL_theme'] .'</option>');
								}
								unset($typeexe);
								echo('
								</select>
							</td>
						</tr>
						<tr>
							<td style="padding:3px;padding-top:6px;" align="right" valign="top">IP地址明细</td>
							<td style="padding:3px;">
								<textarea id="ipFullStr" name="ipFullStr" style="width:180px;height:90px;">'. $vpsRow[$part .'ipFullStr'] .'</textarea>
								<span style="color:red;">（一行一个IP，如果跟【已分配IP地址】一致可以不用填，目前作用于【违禁词检测】功能）</span>
							</td>
						</tr>
						');
					}
					if ( in_array($type,array('vpsApi')) ){
						echo('
						<tr>
							<td style="padding:3px;" align="right">事项</td>
							<td style="padding:3px;">
								<label><input type="checkbox" name="isAutoXufei" value="1" '. Is::Checked($vpsRow[$part .'isAutoXufei'],1) .' />自动续费</label>&ensp;&ensp;
							</td>
						</tr>
						');
					}
				}
				if ( in_array($type,array('host','vpsApi','dialing','serv','pptp')) ){
					echo('
					<tr>
						<td style="padding:3px;" align="right">功能区</td>
						<td style="padding:3px;">
							<!-- <label><input type="checkbox" name="useMenuStr[]" value="|noKaitong|" '. Is::InstrChecked($vpsRow[$part .'useMenuStr'],'|noKaitong|') .' />关闭前台开通</label>&ensp;&ensp; -->
							<label><input type="checkbox" name="useMenuStr[]" value="|noXufei|" '. Is::InstrChecked($vpsRow[$part .'useMenuStr'],'|noXufei|') .' />关闭前台续费</label>&ensp;&ensp;
						</td>
					</tr>
					');
				}
				if ($type == 'host'){
					if ($vpsRow[$part .'apiID'] == 0){
						echo('
						<!-- <tr>
							<td style="padding:3px;" align="right">业务标识：</td>
							<td style="padding:3px;" align="left">
								<input type="text" id="workSign" name="workSign" size="50" style="width:250px;" value="'. $vpsRow[$part .'workSign'] .'" />
							</td>
						</tr> -->
						<tr>
							<td style="padding:3px;" align="right">订单号：</td>
							<td style="padding:3px;" align="left">
								<input type="text" id="orderId" name="orderId" size="50" style="width:250px;" value="'. $vpsRow[$part .'orderId'] .'" />
							</td>
						</tr>
						<tr>
							<td style="padding:3px;" align="right">域名：</td>
							<td style="padding:3px;" align="left">
								<input type="text" id="domain" name="domain" size="50" style="width:250px;" value="'. $vpsRow[$part .'domain'] .'" />
							</td>
						</tr>
						<tr>
							<td style="padding:3px;" align="right">管理面板地址：</td>
							<td style="padding:3px;" align="left">
								<input type="text" id="vpsCpUrl" name="vpsCpUrl" size="50" style="width:250px;" value="'. $vpsRow[$part .'vpsCpUrl'] .'" />
							</td>
						</tr>
						<tr>
							<td style="padding:3px;" align="right">管理面板用户名：</td>
							<td style="padding:3px;" align="left">
								<input type="text" id="vpsUser" name="vpsUser" size="50" style="width:250px;" value="'. $vpsRow[$part .'vpsUser'] .'" />
							</td>
						</tr>
						<tr>
							<td style="padding:3px;" align="right">管理面板密码：</td>
							<td style="padding:3px;" align="left">
								<input type="text" id="vpsPwd" name="vpsPwd" size="50" style="width:250px;" value="'. Encrypt::SyEnDe('de',$vpsRow[$part .'vpsPwd']) .'" />
							</td>
						</tr>
						');
					}
				}
				echo('
				<tr>
					<td style="padding:3px;padding-top:6px;" align="right" valign="top">前台用户备注</td>
					<td style="padding:3px;">'. $vpsRow[$part .'userNote'] .'</td>
				</tr>
				<tr>
					<td style="padding:3px;padding-top:6px;" align="right" valign="top">前台管理员备注</td>
					<td style="padding:3px;"><textarea id="note" name="note" style="width:650px;height:30px;">'. $vpsRow[$part .'note'] .'</textarea></td>
				</tr>
				<tr>
					<td style="padding:3px;padding-top:6px;" align="right" valign="top">内部备注</td>
					<td style="padding:3px;"><textarea id="adminNote" name="adminNote" style="width:650px;height:30px;color:blue;">'. $vpsRow[$part .'adminNote'] .'</textarea></td>
				</tr>
				<tr>
					<td style="padding:3px;" align="right">最后通知时间</td>
					<td style="padding:3px;"><input type="text" id="weixinTime" name="weixinTime" size="22" style="width:170px;" value="'. $vpsRow[$part .'weixinTime'] .'" onfocus=\'WdatePicker({dateFmt:"yyyy-MM-dd HH:mm:ss"})\' class="Wdate" /></td>
				</tr>
				<tr>
					<td style="padding:3px;" align="right">事件</td>
					<td style="padding:3px;">
						<label><input type="checkbox" name="event[]" value="|mark|" '. Is::InstrChecked($vpsRow[$part .'event'],'|mark|') .' />星标</label>&ensp;&ensp;
						<label><input type="checkbox" name="event[]" value="|noMail|" '. Is::InstrChecked($vpsRow[$part .'event'],'|noMail|') .' />禁止邮件通知</label>&ensp;&ensp;
						<label><input type="checkbox" name="event[]" value="|noPhone|" '. Is::InstrChecked($vpsRow[$part .'event'],'|noPhone|') .' />禁止短信通知</label>&ensp;&ensp;
						<label><input type="checkbox" name="event[]" value="|noWeixin|" '. Is::InstrChecked($vpsRow[$part .'event'],'|noWeixin|') .' />禁止公众号通知</label>&ensp;&ensp;
						'. (in_array($type,array('host','vpsApi')) ? '
							<!-- <label><input type="checkbox" name="event[]" value="[restart]" '. Is::InstrChecked($vpsRow[$part .'event'],'[restart]') .' />API授权【重启】</label>&ensp;&ensp; -->
							<label><input type="checkbox" name="event[]" value="[manage]" '. Is::InstrChecked($vpsRow[$part .'event'],'[manage]') .' />API授权【管理】</label>&ensp;&ensp;
						' : '') .'
					</td>
				</tr>
				</table>
				<div style="padding:8px 0 0 92px;"><input type="submit" value=" 保 存 " style="height:25px;" /></div>
				</form>
			</td>
		</tr>
		');
	}



	// 四大产品详细页 更改数据库中的状态
	public static function TrStateUser($type, $dataID, $vpsRow){
		global $DB,$skin,$dataType,$dataTypeCN;

		$tabArr = self::TypeArr($type);
		$part = $tabArr['part'];

		if ($type == 'ssl'){
			$newStateStr = '
				<option value="10">正常</option>
				<option value="9">已退款</option>
				<option value="0">停止</option>
				';
		}else{
			$newStateStr = '
				'. (in_array($type,array('vpsPro','serv')) ? '<option value="15">续费中</option>' : '') .'
				<option value="12">试用中</option>
				<option value="10">正常</option>
				<option value="9">已退款</option>
				<option value="8">退款中</option>
				<option value="6">开通失败</option>
				'. (in_array($type,array('vpsPro','serv')) ? '<option value="5">开通中</option>' : '') .'
				<option value="3">待开通</option>
				<option value="0">停止</option>
				';
		}
		echo('
		<tr>
			<td align="center">更改数据库中的状态</td>
			<td align="left">
				<form method="post" id="stateForm" name="stateForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=state" onsubmit="return CheckMoreForm(\'state\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<input type="hidden" id="stateOld" name="stateOld" value="'. $vpsRow[$part .'state'] .'" />
				当前状态：<span style="font-weight:bold;font-size:14px;">'. IdcInfo::State($vpsRow[$part .'state']) .'</span>&ensp;&ensp;
				<select id="newState" name="newState">
					<option value=""></option>
					'. $newStateStr .'
				</select>
				<input type="submit" value="确定" />
				');
/*				if ($vpsRow[$part .'state'] == 10){
					echo('<input type="hidden" id="newState" name="newState" value="0" /><input type="submit" value="设为停止" />');
				}else{
					echo('<input type="hidden" id="newState" name="newState" value="1" /><input type="submit" value="恢复正常" />');
				}*/
				echo('
				&ensp;&ensp;<span style="color:red;">（上级API中的状态并不会改变，用于纠正与实际状态不符，请谨慎使用！）</span>
				');
				if ($vpsRow[$part .'state'] == 9){
					echo('<div style="color:red;font-size:14px;margin-top:12px;">（已退款状态，单独设置续费价格、续费、调整时间、升级、手工退款 项目不显示。）</div>');
				}
				echo('
				</form>
			</td>
		</tr>
		<tr>
			<td align="center">转移产品</td>
			<td align="left">
				<form method="post" id="usernameForm" name="usernameForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=username" onsubmit="return CheckMoreForm(\'username\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<input type="hidden" name="usernameOld" value="'. $vpsRow[$part .'username'] .'" />
				转移到新用户 <input type="text" id="username" name="username" size="50" style="width:120px;" value="" onblur="CheckUserInfo(this.value,\'\')" />&ensp;&ensp;
				<input type="submit" value="马上转移" />
				<input type="button" value="选择用户" style="margin-left:20px;" onclick="OpenSelUserBox(\'username\',\'username\',\''. $type .'Users\')" />
				<input type="button" value="创建临时用户" onclick="OpenCreateUserBox(\'username\',\'username\',\''. $type .'Users\')" />
				<span id="usernameRes" style="color:red;"></span>
				<span id="createUserBox" style="display:none;"></span>
				&ensp;<span id="selUserBox" style="display:none;"></span>
				</form>
			</td>
		</tr>
		');
	}



	// 四大产品详细页 调整价格/成本、调整时间、调整API到期
	public static function TrTiaozheng($type, $dataID, $vpsRow){
		global $DB,$skin,$dataType,$dataTypeCN;

		$tabArr = self::TypeArr($type);
		$part = $tabArr['part'];

		$optionStr = $payNumStr = '';
		if ( in_array($type,array('vpsPro','vpsApi','serv')) ){
			$optionStr = '
				<option value="24hour" '. Is::Selected($vpsRow[$part .'payMode'],'24hour') .'>试用，后转正月付</option>
				<option value="48hour" '. Is::Selected($vpsRow[$part .'payMode'],'48hour') .'>试用，后转正年付</option>
				<option value="month" '. Is::Selected($vpsRow[$part .'payMode'],'month') .'>月付</option>
				<option value="3month" '. Is::Selected($vpsRow[$part .'payMode'],'3month') .'>季付</option>
				<option value="6month" '. Is::Selected($vpsRow[$part .'payMode'],'6month') .'>半年付</option>
				<option value="year" '. Is::Selected($vpsRow[$part .'payMode'],'year') .'>年付</option>
				<option value="2year" '. Is::Selected($vpsRow[$part .'payMode'],'2year') .'>两年付</option>
				<option value="3year" '. Is::Selected($vpsRow[$part .'payMode'],'3year') .'>三年付</option>
				';
		}elseif ( in_array($type,array('dialing')) ){
			$optionStr = '
				<option value="day" '. Is::Selected($vpsRow[$part .'payMode'],'day') .'>日付</option>
				<option value="week" '. Is::Selected($vpsRow[$part .'payMode'],'week') .'>周付</option>
				<option value="month" '. Is::Selected($vpsRow[$part .'payMode'],'month') .'>月付</option>
				<option value="3month" '. Is::Selected($vpsRow[$part .'payMode'],'3month') .'>季付</option>
				<option value="6month" '. Is::Selected($vpsRow[$part .'payMode'],'6month') .'>半年付</option>
				<option value="year" '. Is::Selected($vpsRow[$part .'payMode'],'year') .'>年付</option>
				';
		}elseif ($type == 'pptp'){
			$optionStr = '
				<option value="24hour" '. Is::Selected($vpsRow[$part .'payMode'],'24hour') .'>测试1小时</option>
				<option value="day" '. Is::Selected($vpsRow[$part .'payMode'],'day') .'>日付</option>
				<option value="week" '. Is::Selected($vpsRow[$part .'payMode'],'week') .'>周付</option>
				<option value="month" '. Is::Selected($vpsRow[$part .'payMode'],'month') .'>月付</option>
				';
			$payNumStr = '时长：<input type="text" id="priceNum" name="priceNum" size="10" style="width:70px;" value="" onkeyup="if (this.value!=FiltDecimal(this.value)){this.value=FiltDecimal(this.value);}LoadPrice(\'price\');" />&ensp;&ensp;';
		}else{
			$optionStr = '
				<option value="48hour" '. Is::Selected($vpsRow[$part .'payMode'],'48hour') .'>试用，后转正年付</option>
				<option value="year" '. Is::Selected($vpsRow[$part .'payMode'],'year') .'>年付</option>
				<option value="2year" '. Is::Selected($vpsRow[$part .'payMode'],'2year') .'>两年付</option>
				<option value="3year" '. Is::Selected($vpsRow[$part .'payMode'],'3year') .'>三年付</option>
				';
		}
		echo('
		<tr>
			<td align="center">调整价格/成本</td>
			<td align="left" style="line-height:2.5;">
				<form method="post" id="priceForm" name="priceForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=price" onsubmit="return CheckMoreForm(\'price\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				'. $payNumStr .'
				付款方式：<select id="priceMode" name="priceMode" onclick="LoadPrice(\'price\')">
								<option value=""></option>
								'. $optionStr .'
							</select>&ensp;&ensp;
				价格：<input type="text" id="pricePrice" name="pricePrice" size="10" style="width:70px;" value="'. $vpsRow[$part .'price'] .'" onkeyup="if (this.value!=FiltDecimal(this.value)){this.value=FiltDecimal(this.value);}CalcUserRemMoney(\'userXufeiRemMoney\',\'xufei\');" />元&ensp;&ensp;
				成本：<input type="text" id="priceCost" name="priceCost" style="width:70px;" value="'. $vpsRow[$part .'cost'] .'" />元&ensp;&ensp;
				<input type="submit" value="马上调整" />
				&ensp;&ensp;<span style="color:red;">（仅用于纠正错误信息，不会产生资金变动，请谨慎使用！）</span>
				</form>
			</td>
		</tr>
		<tr>
			<td align="center">调整开通/到期时间</td>
			<td align="left">
				<form method="post" id="timeForm" name="timeForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=setTime" onsubmit="return CheckMoreForm(\'setTime\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<div style="line-height:2.5;">
					手工指定开通时间：<input type="text" id="setTime" name="setTime" size="22" style="width:170px;" value="" onfocus=\'WdatePicker({dateFmt:"yyyy-MM-dd HH:mm:ss"})\' class="Wdate" />
					&ensp;&ensp;<span class="pointer" onclick="$id(\'setTime\').value=\''. $vpsRow[$part .'time'] .'\'">当前开通时间：'. $vpsRow[$part .'time'] .'</span>
					<br />
					手工指定到期时间：<input type="text" id="setEndTime" name="setEndTime" size="22" style="width:170px;" value="" onfocus=\'WdatePicker({dateFmt:"yyyy-MM-dd HH:mm:ss"})\' class="Wdate" />
					&ensp;&ensp;<span class="pointer" onclick="$id(\'setEndTime\').value=\''. $vpsRow[$part .'endTime'] .'\'">当前到期时间：'. $vpsRow[$part .'endTime'] .'</span>
					&ensp;&ensp;<span class="pointer" onclick="$id(\'setEndTime\').value=\''. $vpsRow[$part .'vpsEndTime'] .'\'">API到期时间：'. $vpsRow[$part .'vpsEndTime'] .'</span>
					<br />
					说明原因：<input type="text" id="setNote" name="setNote" size="22" style="width:350px;" value=""/>
					<select onchange="if (this.value!=\'\'){$id(\'setNote\').value = this.value;}">
						<option value="">候选项</option>
						'. Info::TypeOptionList('moneyNote', '在【IDC设置】-【不扣款说明管理】里设置候选项') .'
					</select>
					&ensp;(可选)
				</div>
				<div style="padding-top:10px;">
					<label><input type="radio" id="isPayTime0" name="isUserPay" value="0" />不扣款</label>&ensp;&ensp;
					<label><input type="radio" id="isPayTime1" name="isUserPay" value="1" checked="checked" onclick=\'CalcUserRemMoney("userTimeRemMoney","time");\' />从用户金额中扣款</label>:<input type="text" id="userPriceTime" name="userPrice" size="10" style="width:60px;" value="" onkeyup="if (this.value!=FiltDecimal(this.value)){this.value=FiltDecimal(this.value);}CalcUserRemMoney(\'userTimeRemMoney\',\'time\');" />元&ensp;&ensp;<span id="userTimeRemMoney" style="color:red;"></span>&ensp;&ensp;
					<input type="submit" value="马上调整" />
					<script language="javascript" type="text/javascript">CalcUserRemMoney("userTimeRemMoney","time");</script>
				</div>
				</form>
			</td>
		</tr>
		<tr>
			<td align="center">调整API到期时间</td>
			<td align="left">
				<form method="post" id="apiTimeForm" name="apiTimeForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=setApiTime" onsubmit="return CheckMoreForm(\'setApiTime\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<div style="line-height:2.5;">
					手工指定API到期时间：<input type="text" id="setApiTime" name="setApiTime" size="22" style="width:170px;" value="" onfocus=\'WdatePicker({dateFmt:"yyyy-MM-dd HH:mm:ss"})\' class="Wdate" />
					&ensp;&ensp;<span class="pointer" onclick="$id(\'setApiTime\').value=\''. $vpsRow[$part .'vpsEndTime'] .'\'">API到期时间：'. $vpsRow[$part .'vpsEndTime'] .'</span>
					&ensp;&ensp;&ensp;&ensp;
					<input type="submit" value="马上调整" />
				</div>
				</form>
			</td>
		</tr>
		');
	}



	// 四大产品详细页 手工退款
	public static function TrTuikuan($type, $dataID, $vpsRow){
		global $DB,$skin,$dataType,$dataTypeCN;

		$tabArr = self::TypeArr($type);
		$part = $tabArr['part'];

		echo('
		<tr>
			<td align="center">手工退款</td>
			<td align="left">
				<form method="post" id="backForm" name="backForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=back" onsubmit="return CheckMoreForm(\'back\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<div style="line-height:2.2;">
					退款金额：<input type="text" id="backMoney" name="backMoney" size="22" style="width:60px;" value="" onkeyup="if (this.value!=FiltDecimal(this.value)){this.value=FiltDecimal(this.value)}" />元<br />
					退款原因：<input type="text" id="backNote" name="backNote" size="22" style="width:500px;" value=""/>
					&ensp;&ensp;&ensp;&ensp;<input type="submit" value="马上退款" />
					<div class="font2_2">（注意：退款后此机器将过期(不删除)，款项退到用户账号下，还需在上级API网站做退款操作。）</div>
				</div>
				</form>
			</td>
		</tr>
		');
		/*
		<tr>
			<td align="center">
				该记录近6条财务信息
				<div style="color:blue;cursor:pointer;margin-top:5px;" onclick=\'OT_OpenMoneyRecord("&refUsername='. $vpsRow[$part .'username'] .'")\'>[此用户财务信息]</div>
			</td>
			<td align="left">
				<table style="width:100%;" cellpadding="0" cellspacing="0" class="tabList11">
				<tr>
					<td width="5%" align="center">序号</td>
					<td width="10%" align="center">用户名</td>
					<td width="10%" align="center">金额</td>
					<td width="65%" align="center">内容</td>
					<td width="10%" align="center">时间</td>
				</tr>
				');
				$recNum = 0;
				$recexe = $DB->query('select MR_time,MR_username,MR_money,MR_remMoney,MR_note from '. OT_dbPref .'moneyRecord where MR_dataID='. $dataID .' and MR_type="'. $type .'" order by MR_ID DESC limit 6');
				while ($rs = $recexe->fetch()){
					echo('
					<tr>
						<td align="center">'. ++$recNum .'</td>
						<td align="center">'. $rs['MR_username'] .'</td>
						<td>'. Area::ColorNum($rs['MR_money'],$rs['MR_remMoney']) .'</td>
						<td style="line-height:1.4;">'. $rs['MR_note'] .'</td>
						<td align="center">'. $rs['MR_time'] .'</td>
					</tr>
					');
				}
				unset($recexe);
				echo('
				</table>
			</td>
		</tr>
		*/
	}



	// 四大产品详细页 删除
	public static function TrDel($type, $dataID, $vpsRow){
		global $DB,$skin,$dataType,$dataTypeCN;

		$tabArr = self::TypeArr($type);
		$part = $tabArr['part'];

		echo('
		<tr>
			<td align="center">删除</td>
			<td align="left">
				<form method="post" id="delForm" name="delForm" action="'. $type .'Users_deal.php?mudi=moreDeal&mudi2=del" onsubmit="return CheckMoreForm(\'del\')">
				<script language="javascript" type="text/javascript">document.write(\'<input type="hidden" name="backURL" value="\'+ document.location.href +\'">\')</script>
				<input type="hidden" name="dataID" value="'. $dataID .'" />
				<input type="hidden" name="delMode" value="1" />
				<input type="submit" value="删除" />
				&ensp;&ensp;<span class="font2_2">（注意：删除是不可恢复的删除，但在上级API中并不会删除）</span>
				</form>
			</td>
		</tr>
		');
	}



	// 四大产品详细页 显示推广佣金记录
	public static function GainItemTab($type, $dataID){
		global $DB,$skin;

		$pageSize	= 10;		//每页条数
		$page		= 1;
		$showRow=$DB->GetLimit('select * from '. OT_dbPref .'gainItem where GI_proID='. $dataID .' and GI_proType="'. $type .'" order by GI_ID DESC',$pageSize,$page);
		if ($showRow){
			$skin->TableTop2('share_list.gif','','推广佣金记录');
			$skin->TableItemTitle('4%,12%,18%,12%,7%,7%,7%,14%,11%,8%','序号,推广者,购买产品,购买者,消费金额,类型,佣金,发生时间,备注,详细');
			echo('
			<tbody class="tabBody padd5">
			');
			$number=1;
			$rowCount = count($showRow);
			for ($i=0; $i<$rowCount; $i++){
				if ($i % 2 == 1){ $bgcolor='class="tabColorTr"'; }else{ $bgcolor=''; }
				echo('
				<tr id="data'. $showRow[$i]['GI_ID'] .'" '. $bgcolor .'>
					<td align="center">'. $number .'</td>
					<td align="center">'. $showRow[$i]['GI_username'] .'</td>
					<td align="center">'. $showRow[$i]['GI_proName'] .'</td>
					<td align="center">'. $showRow[$i]['GI_proUsername'] .'</td>
					<td align="center">'. $showRow[$i]['GI_proPrice'] .'</td>
					<td align="center">'. $showRow[$i]['GI_mode'] .'</td>
					<td align="right" style="padding-right:8px;">'. Area::ColorNum($showRow[$i]['GI_money']) .'</td>
					<td align="center">'. $showRow[$i]['GI_time'] .'</td>
					<td align="center">'. StrCN::GainItemState($showRow[$i]['GI_state']) .'</td>
					<td align="center">
						<img src="images/img_det.gif" style="cursor:pointer" onclick=\'var a=window.open("gainItem.php?mudi=show&nohrefStr=close&dataID='. $showRow[$i]['GI_ID'] .'")\' alt="" />
					</td>
				</tr>
				');
			$number ++;
			}
			echo('
			</tbody>
			</table>
			');
		}
		unset($showRow);

	}



	// 四大产品详细页 显示推广佣金历史记录
	public static function GainHistoryTab($type, $dataID){
		global $DB,$skin;

		$pageSize	= 20;		//每页条数
		$page		= 1;
		$showRow=$DB->GetLimit('select * from '. OT_dbPref .'gainHistory where GH_proID='. $dataID .' and GH_proType="'. $type .'" order by GH_ID DESC',$pageSize,$page);
		if ($showRow){
			$skin->TableTop2('share_list.gif','','推广佣金历史记录');
			$skin->TableItemTitle('4%,10%,20%,10%,7%,6%,7%,7%,7%,9%,13%','序号,推广者,购买产品,购买者,消费金额,类型,收益,未结算,未提现,发生时间,备注');
			echo('
			<tbody class="tabBody padd5">
			');
			$number=1;
			$rowCount = count($showRow);
			for ($i=0; $i<$rowCount; $i++){
				if ($i % 2 == 1){ $bgcolor='class="tabColorTr"'; }else{ $bgcolor=''; }
				echo('
				<tr id="data'. $showRow[$i]['GH_ID'] .'" '. $bgcolor .'>
					<td align="center">'. $number .'</td>
					<td align="center">'. $showRow[$i]['GH_username'] .'</td>
					<td align="center">'. $showRow[$i]['GH_proName'] .'</td>
					<td align="center">'. $showRow[$i]['GH_proUsername'] .'</td>
					<td align="center">'. $showRow[$i]['GH_proPrice'] .'</td>
					<td align="center">'. $showRow[$i]['GH_mode'] .'</td>
					<td align="right" style="padding-right:8px;">'. Area::ColorNum($showRow[$i]['GH_money']) .'</td>
					<td align="right" style="padding-right:8px;">'. $showRow[$i]['GH_makingMoney'] .'</td>
					<td align="right" style="padding-right:8px;">'. $showRow[$i]['GH_makeMoney'] .'</td>
					<td align="center">'. $showRow[$i]['GH_time'] .'</td>
					<td align="center">'. $showRow[$i]['GH_note'] .'</td>
				</tr>
				');
			$number ++;
			}
			echo('
			</tbody>
			</table>
			');
		}
		unset($showRow);

	}



	// 四大产品详细页 显示财务记录
	public static function MoneyListTab($type, $dataID){
		global $DB,$skin;

		$pageSize	= 10;		//每页条数
		$page		= 1;
		$showRow=$DB->GetLimit('select MR_time,MR_username,MR_money,MR_remMoney,MR_note from '. OT_dbPref .'moneyRecord where MR_dataID='. $dataID .' and MR_type="'. $type .'" order by MR_ID DESC',$pageSize,$page);
		if ($showRow){
			$skin->TableTop2('share_list.gif','','财务记录');
			$skin->TableItemTitle('5%,10%,10%,10%,55%,10%','序号,用户名,金额,余额,内容,时间');
			echo('
			<tbody class="tabBody padd5">
			');
			$number=1;
			$rowCount = count($showRow);
			for ($i=0; $i<$rowCount; $i++){
				if ($i % 2 == 1){ $bgcolor='class="tabColorTr"'; }else{ $bgcolor=''; }
				echo('
				<tr '. $bgcolor .'>
					<td align="center">'. $number .'</td>
					<td align="center">'. $showRow[$i]['MR_username'] .'</td>
					<td align="right" style="padding-right:8px;">'. Area::ColorNum($showRow[$i]['MR_money'], $showRow[$i]['MR_remMoney']) .'</td>
					<td align="right" style="padding-right:8px;">'. Area::RemMoney($showRow[$i]['MR_remMoney']) .'</td>
					<td align="left">'. $showRow[$i]['MR_note'] .'</td>
					<td align="center">'. $showRow[$i]['MR_time'] .'</td>
				</tr>
				');
			$number ++;
			}
			echo('
			</tbody>
			</table>
			');
		}
		unset($showRow);

	}



	// 四大产品 删除记录加入回收站
	public static function AddDelUsers($type, $dataID){
		global $DB,$MB,$skin,$dataType,$dataTypeCN;

		if ($type == 'idcServVps'){
			$row = $DB->GetRow('select * from '. OT_dbPref .'idcServVps where ISV_ID='. $dataID);
			if (! $row){ return false; }

			$record = array();
			$record['IVD_time']			= TimeDate::Get();
			$record['IVD_startTime']	= $row['ISV_time'];
			$record['IVD_endTime']		= $row['ISV_endTime'];
			$record['IVD_servID']		= $row['ISV_servID'];
			$record['IVD_servType']		= $row['ISV_servType'];
			$record['IVD_servIp']		= $row['ISV_servIp'];
			$record['IVD_proID']		= $row['ISV_proID'];
			$record['IVD_userID']		= $row['ISV_userID'];
			$record['IVD_username']		= $row['ISV_username'];
			$record['IVD_theme']		= $row['ISV_theme'];
			$record['IVD_cpuNum']		= $row['ISV_cpuNum'];
			$record['IVD_cpuRate']		= $row['ISV_cpuRate'];
			$record['IVD_disk']			= $row['ISV_disk'];
			$record['IVD_ram']			= $row['ISV_ram'];
			$record['IVD_dynRam']		= $row['ISV_dynRam'];
			$record['IVD_ipNum']		= $row['ISV_ipNum'];
			$record['IVD_maxMbps']		= $row['ISV_maxMbps'];
			$record['IVD_maxIOPS1']		= $row['ISV_maxIOPS1'];
			$record['IVD_maxIOPS2']		= $row['ISV_maxIOPS2'];
			$record['IVD_maxFlow']		= $row['ISV_maxFlow'];
			$record['IVD_vhdPath']		= $row['ISV_vhdPath'];
			$record['IVD_osType']		= $row['ISV_osType'];
			$record['IVD_osName']		= $row['ISV_osName'];
			if (strtotime($row['ISV_osInstallTime'])){
				$record['IVD_osInstallTime']= $row['ISV_osInstallTime'];
			}
			$record['IVD_vpsName']		= $row['ISV_vpsName'];
			$record['IVD_vpsUser']		= $row['ISV_vpsUser'];
			$record['IVD_vpsPwd']		= $row['ISV_vpsPwd'];
			$record['IVD_vpsPort']		= $row['ISV_vpsPort'];
			$record['IVD_vpsRunSec']	= $row['ISV_vpsRunSec'];
			$record['IVD_vpsStatus']	= $row['ISV_vpsStatus'];
			$record['IVD_vpsStatusTime']= $row['ISV_vpsStatusTime'];
			$record['IVD_ipStr']		= $row['ISV_ipStr'];
			$record['IVD_payMode']		= $row['ISV_payMode'];
			$record['IVD_price']		= $row['ISV_price'];
			$record['IVD_cost']			= $row['ISV_cost'];
			$record['IVD_event']		= $row['ISV_event'];
			$record['IVD_note']			= $row['ISV_note'];
			$record['IVD_state']		= $row['ISV_state'];
			$record['IVD_adminID']		= $row['ISV_adminID'];
			$record['IVD_adminName']	= $row['ISV_adminName'];

			$judRes = $DB->InsertParam('idcVpsDel', $record);

		}else{
			$tabArr = self::TypeArr($type);
			$part = $tabArr['part'];

			$row = $DB->GetRow('select * from '. OT_dbPref . $type .'Users where '. $part .'ID='. $dataID);
			if (! $row){ return false; }

			$record = array();
			$record['VDU_time']			= TimeDate::Get();
			$record['VDU_startTime']	= $row[$part .'time'];
			$record['VDU_endTime']		= $row[$part .'endTime'];
			$record['VDU_companyID']	= $row[$part .'companyID'];
		//	$record['VDU_typeID']		= $row[$part .'typeID'];
			$record['VDU_proType']		= $type;
			$record['VDU_proID']		= $dataID;
			$record['VDU_proDataID']	= $row[$part .'proDataID'];
			$record['VDU_proDataName']	= $row[$part .'proDataName'];
			$record['VDU_agentUserID']	= $row[$part .'agentUserID'];
			$record['VDU_userID']		= $row[$part .'userID'];
			$record['VDU_username']		= $row[$part .'username'];
			$record['VDU_vpsName']		= $row[$part .'vpsName'];
			$record['VDU_vpsUser']		= $row[$part .'vpsUser'];
			$record['VDU_vpsPwd']		= $row[$part .'vpsPwd'];
			$record['VDU_vpsEndTime']	= $row[$part .'vpsEndTime'];
			$record['VDU_payMode']		= $row[$part .'payMode'];
		//	$record['VDU_priceID']		= $row[$part .'priceID'];
			$record['VDU_price']		= $row[$part .'price'];
			$record['VDU_cost']			= $row[$part .'cost'];
		//	$record['VDU_score1']		= $row[$part .'score1'];
		//	$record['VDU_score2']		= $row[$part .'score2'];
		//	$record['VDU_score3']		= $row[$part .'score3'];
			$record['VDU_xufeiNum']		= $row[$part .'xufeiNum'];
			$record['VDU_note']			= $row[$part .'note'];
			$record['VDU_isUserPay']	= $row[$part .'isUserPay'];
			$record['VDU_userNote']		= $row[$part .'userNote'];
			$record['VDU_adminNote']	= $row[$part .'adminNote'];
			$record['VDU_state']		= $row[$part .'state'];
			$record['VDU_isNewPrice']	= $row[$part .'isNewPrice'];
			$record['VDU_priceYear']	= $row[$part .'priceYear'];
			$record['VDU_costYear']		= $row[$part .'costYear'];
			$record['VDU_adminID']		= $MB->mUserID;
			$record['VDU_adminName']	= $MB->mMbRow['MB_realname'];
			$record['VDU_weixinTime']	= $row[$part .'weixinTime'];
			$record['VDU_event']		= $row[$part .'event'];
			if ($type != 'pptp'){
				$record['VDU_vpsPort']		= intval($row[$part .'vpsPort']);
				$record['VDU_room']			= $row[$part .'room'];
				$record['VDU_system']		= $row[$part .'system'];
			}
			if (in_array($type,array('host'))){
				$record['VDU_ipStr']		= $row[$part .'workSign'];
			}elseif ($type == 'pptp'){
				$record['VDU_ipStr']		= $row[$part .'vpsUser'];
			}else{
				$record['VDU_ipStr']		= $row[$part .'ipStr'];
				$record['VDU_priceMonth']	= $row[$part .'priceMonth'];
				$record['VDU_price3Month']	= $row[$part .'price3Month'];
				$record['VDU_price6Month']	= $row[$part .'price6Month'];
				$record['VDU_costMonth']	= $row[$part .'costMonth'];
				$record['VDU_cost3Month']	= $row[$part .'cost3Month'];
				$record['VDU_cost6Month']	= $row[$part .'cost6Month'];
			}
			if (in_array($type,array('host','vpsApi'))){
				$record['VDU_apiID']		= $row[$part .'apiID'];
				$record['VDU_orderId']		= $row[$part .'orderId'];
				$record['VDU_workId']		= $row[$part .'workId'];
				$record['VDU_workSign']		= $row[$part .'workSign'];
				$record['VDU_serverCode']	= $row[$part .'serverCode'];
				$record['VDU_serverPwd']	= $row[$part .'serverPwd'];
				$record['VDU_vpsCpUrl']		= $row[$part .'vpsCpUrl'];
				$record['VDU_spaceSize']	= $row[$part .'spaceSize'];
			}
			if (in_array($type,array('vpsApi'))){
				$record['VDU_comServID']	= $row[$part .'comServID'];
			}
			$judRes = $DB->InsertParam('vpsDelUsers', $record);
		}
		return $judRes;
	}


	// 景安包销数信息
	public static function JinganBaoxiaoInfo($apiID, $proDataID, $proType='vpsApi', $type=''){
		global $DB;

		if ($type == 'xufei'){ $type = 'Xu'; }else{ $type = ''; }
		if ($proType != 'host'){ $proType = 'vpsApi'; }

		$retStr = '';
		if ($apiID == 2){
			if ($proType != 'host'){
				$rs = $DB->GetRow('select VR_time,VR_value from '. OT_dbPref .'vpsRecord where VR_dataID='. $proDataID .' and VR_type="'. $proType .'Baoxiao'. $type .'1" order by VR_time DESC limit 1');
				if ($rs){ $retStr .= '月包销数：'. $rs['VR_value'] .''; }
				$rs = null;
			}

			$rs = $DB->GetRow('select VR_time,VR_value from '. OT_dbPref .'vpsRecord where VR_dataID='. $proDataID .' and VR_type="'. $proType .'Baoxiao'. $type .'12" order by VR_time DESC limit 1');
			if ($rs){
				if (strlen($retStr) > 0){ $retStr .= '，'; }
				$retStr .= '年包销数：'. $rs['VR_value'] .'';
			}

			if (strlen($retStr) > 0){
				$retStr = '&ensp;&ensp;&ensp;&ensp;<span style="color:blue;" title="最后更新：'. $rs['VR_time'] .'">['. $retStr .'，更新于'. TimeDate::Get('m-d',$rs['VR_time']) .']<input type="button" value="更新" onclick=\'DataDeal.location.href="readIdc.php?mudi=getBaoxiaoNum&type='. $proType .'&dataID='. $proDataID .'";\' /></span>';
			}
			$rs = null;
		}

		return $retStr;
	}


	// 获取接口类型数组 废弃删除
	public static function GetApiArr(){
		global $DB;
	
		$apiArr = array(0=>'无API');
		$apiexe = $DB->query('select VA_ID,VA_theme from '. OT_dbPref .'vpsApi where VA_state=1');
		while ($row = $apiexe->fetch()){
			$apiArr[$row['VA_ID']] = $row['VA_theme'];
		}
		unset($apiexe);

		return $apiArr;
	}

}
?>