<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}



class AdmArea{

	// 用户QQ信息
	public static function UserQQ($qq, $mark='div'){
		$retStr = '';
		if (strlen(''. $qq) > 0){
			$qqArr = explode(',',$qq);
			for ($n=0; $n<count($qqArr); $n++){
				$retStr .= '<'. $mark .'>'. $qqArr[$n] .'<a href="https://wpa.qq.com/msgrd?v=3&uin='. $qqArr[$n] .'&site=OTCMS&menu=yes" target="_blank"><img height="17" alt="QQ" hspace="2" src="https://wpa.qq.com/pa?p=1:'. $qqArr[$n] .':17" onerror=\'this.src="../inc_img/qq.gif";\' width="25" align="absBottom" border="0" /></a></'. $mark .'>'. ($mark=='span'?'&ensp;&ensp;':'');
			}
		}
		return $retStr;
	}


	// 用户旺旺信息
	public static function UserWw($ww){
		$retStr = '';
		if (strlen(''. $ww)>0 ){
			$wwUrlEncode = urlencode($ww);
			$retStr = $ww .'<a target="blank" href="https://www.taobao.com/webww/ww.php?ver=3&touid='. $wwUrlEncode .'&siteid=cntaobao&status=1&charset=utf-8"><img border="0" src="https://amos.alicdn.com/realonline.aw?v=2&uid='. $wwUrlEncode .'&site=cntaobao&s=2&charset=utf-8" alt="旺旺('. $ww .')"  width="16" /></a>';
		}
		return $retStr;
	}


	// 打开用户信息
	public static function UserInfoImg($userID, $altL='', $altR='', $imgExt=''){
		if ($userID > 0){
			$retStr = '<a href="users.php?mudi=show&nohrefStr=close&dataMode=&dataModeStr=&dataType=&dataTypeCN='. urlencode('会员') .'&dataID='. $userID .'" target="_blank"><img src="images/img_user'. $imgExt .'.gif" style="cursor:pointer;margin-left:3px;" valign="top" alt="'. $altL .'查看会员详细信息（ID：'. $userID .'）'. $altR .'" title="'. $altL .'查看会员详细信息（ID：'. $userID .'）'. $altR .'" /></a>';
		}else{
			$retStr = '';
		}
		return $retStr;
	}


	// 读取模板
	public static function TplFileOption($mode, $type, $selVal){
		global $DB;
		$retStr = '';
		if ($mode == 'wap'){
			$WAP_templateDir = $DB->GetOne('select WAP_templateDir from '. OT_dbPref .'wap');
			$xmlFileStr = File::Read(OT_ROOT .'wap/template/'. $WAP_templateDir .'config.xml');
		}else{
			$SYS_templateDir = $DB->GetOne('select SYS_templateDir from '. OT_dbPref .'system');
			$xmlFileStr = File::Read(OT_ROOT .'template/'. $SYS_templateDir .'config.xml');
		}
		$fileListStr = Str::GetMark($xmlFileStr,'<'. $type .'File>','</'. $type .'File>');
		if (strlen(''. $fileListStr)>0){
			$fileListArr = explode(',',$fileListStr);
			$fileListCount = count($fileListArr);
			$noteListStr = Str::GetMark($xmlFileStr,'<'. $type .'FileNote>','</'. $type .'FileNote>') . str_repeat(',',$fileListCount);
			$noteListArr = explode(',',$noteListStr);
			for ($i=0; $i<$fileListCount; $i++){
				if (strlen(''. $noteListArr[$i]) > 0){ $noteListArr[$i] = '('. $noteListArr[$i] .')'; }
				$retStr .= '<option value="'. $fileListArr[$i] .'" '. Is::Selected($selVal,$fileListArr[$i]) .'>'. $fileListArr[$i] .' '. $noteListArr[$i] .'</option>';
			}
		}
		return $retStr;
	}



	// 生成cache/web/site.css
	public static function MakeSiteCss(){
		global $DB;

		$cssStr = '/* 后台设置的全局CSS样式 */'. PHP_EOL;
		// $eventStr = $DB->GetOne('select SYS_eventStr from '. OT_dbPref .'system');
		// $tplSysArr = $DB->GetRow('select TS_navWidthMode,TS_jieriImg,TS_jieriHeight,TS_subWebLR,TS_siteCss from '. OT_dbPref .'tplSys');
		$systemArr = Cache::PhpFile('system');
		$tplSysArr = Cache::PhpFile('tplSys');
		$infoSysArr = Cache::PhpFile('infoSys');
		$eventStr = $systemArr['SYS_eventStr'];

		if (strpos($eventStr,'|siteGray|') !== false){
			$cssStr .= '
				html {
					filter: grayscale(100%);
					-webkit-filter: grayscale(100%);
					-moz-filter: grayscale(100%);
					-ms-filter: grayscale(100%);
					-o-filter: grayscale(100%);
					filter: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale");
					filter: progid:DXImageTransform.Microsoft.BasicImage(grayscale=1);
					-webkit-filter: grayscale(1);
				}	/* 全站变灰 */
				';
		}elseif (strpos($eventStr,'|siteGrayHome|') !== false){
			$cssStr .= '
				html.site_home {
					filter: grayscale(100%);
					-webkit-filter: grayscale(100%);
					-moz-filter: grayscale(100%);
					-ms-filter: grayscale(100%);
					-o-filter: grayscale(100%);
					filter: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale");
					filter: progid:DXImageTransform.Microsoft.BasicImage(grayscale=1);
					-webkit-filter: grayscale(1);
				}	/* 全站变灰 */
				';
		}

		$wapCss = '';
		if (AppWap::Jud()){
			$wapArr = Cache::PhpFile('wap');
			$titleStyle = $wapArr['WAP_titleStyle'] . $wapArr['WAP_titleStyle2'];
			$contentStyle = $wapArr['WAP_contentStyle'] . $wapArr['WAP_contentStyle2'];
			if (strlen($titleStyle) > 0){
				$wapCss .= '#newsTitle { '. $titleStyle .' }';
			}
			if (strlen($contentStyle) > 0){
				$wapCss .= '#newsContent { '. $contentStyle .' } #newsContent p { '. $contentStyle .' }';
			}
			$wapCss .= $wapArr['WAP_siteCss'];
		}
		File::Write(OT_ROOT .'cache/web/siteWap.css', $cssStr . $wapCss);	// 生成手机版用到的css，下面附加PC版CSS


		if ($tplSysArr['TS_navWidthMode'] == 1 && strlen(''. $tplSysArr['TS_jieriImg']) > 3){
			$cssStr .= '
				body { background:#ffffff url(../../inc_img/jieriBg/'. $tplSysArr['TS_jieriImg'] .') no-repeat 50% 0; padding-top:'. $tplSysArr['TS_jieriHeight'] .'px; }	/* 头背景 */
				';
		}
		if ($tplSysArr['TS_subWebLR'] == 1){
			$cssStr .= '
				.subWebLR { float:right;padding-left:8px; padding-right:0px; }
				.subWebLR .itemBox { margin-right:6px; }
				';
		}

		$titleStyle = $infoSysArr['IS_titleStyle'] . $infoSysArr['IS_titleStyle2'];
		$contentStyle = $infoSysArr['IS_contentStyle'] . $infoSysArr['IS_contentStyle2'];
		if (strlen($titleStyle) > 0){
			$cssStr .= '#newsTitle { '. $titleStyle .' }';
		}
		if (strlen($contentStyle) > 0){
			$cssStr .= '#newsContent { '. $contentStyle .' } #newsContent p { '. $contentStyle .' }';
		}

		return File::Write(OT_ROOT .'cache/web/site.css', $cssStr . $tplSysArr['TS_siteCss']);
	}



	// 快捷登录管理 生成API
	public static function UserApiHtml(){
		global $DB;

		$fileStr1 = $fileStr2 = $fileStr3 = $fileWapStr2 = $fileWapStr3 = '';

		$apiexe = $DB->query('select UA_ID,UA_appType,UA_isHome,UA_isTop,UA_isReg,UA_isLogin from '. OT_dbPref .'userApi where UA_state=1 order by UA_rank ASC');
		while ($row = $apiexe->fetch()){
			if ($row['UA_isTop'] == 1){
				$fileStr1 .= self::UserApiImg($row['UA_appType'],$row['UA_ID'],'Small');
			}
			if ($row['UA_isReg'] == 1){
				$fileStr2 .= self::UserApiImg($row['UA_appType'],$row['UA_ID'],'Long');
				$fileWapStr2 .= self::UserApiImg($row['UA_appType'],$row['UA_ID'],'Long','wap');
			}
			if ($row['UA_isLogin'] == 1){
				$fileStr3 .= self::UserApiImg($row['UA_appType'],$row['UA_ID'],'Long');
				$fileWapStr3 .= self::UserApiImg($row['UA_appType'],$row['UA_ID'],'Long','wap');
			}
		}
		unset($apiexe);
		
		if ($fileStr1 != ''){ $fileStr1 = '<div class="left uebox_api">'. $fileStr1 .'</div>'; }
		
		$dataArr = array(
			'imgTop'		=> $fileStr1, 
			'imgReg'		=> $fileStr2, 
			'imgLogin'		=> $fileStr3, 
			'imgRegWap'		=> $fileWapStr2, 
			'imgLoginWap'	=> $fileWapStr3,
			);
		$Cache = new Cache();
		$Cache->ArrToPhp('userApi', $dataArr);

	}


	// 快捷登录管理 生成图片
	public static function UserApiImg($appType, $apiID, $apiMode, $mode='pc'){
		$goUrl = './p.php?m=userApiLogin&id='. $apiID .'&backURL=[backURL]';
		$target = 'target="_blank"';
		switch ($appType){
			case 'qq':		$appName = 'QQ';		break;
			case 'weibo':	$appName = '新浪微博';	break;
			case 'weixin':	$appName = '微信';		break;
			case 'wxmp':	$appName = '微信公众号'; $goUrl = './users.php?mudi=login&mode=wxmp'; $target = ''; break;
			case 'taobao':	$appName = '淘宝';		break;
			case 'alipay':	$appName = '支付宝';	break;
			default:		$appName = '未知';		break;
		}
		if ($mode == 'wap'){
			// $beforeURL	= GetUrl::CurrDir(1);
			if (in_array($appType, array('weixin','wxmp'))){
				return '';
			}else{
				return '<a href="'. $goUrl .'"><img src="./images/api/'. $appType .'.png" alt="用'. $appName .'账号登录" style="width:75px;margin:8px;" /></a>';
			}

		}else{
			return '<a href="'. $goUrl .'" '. $target .'><img src="./inc_img/api/'. $appType . $apiMode .'.png" alt="用'. $appName .'账号登录" style="margin-right:1px;" /></a>';
		}
	}


	// 插件平台 已购买插件 改插件文件名
	public static function PaySoftStateDeal($dataID=0,$type='ID'){
		global $DB;

		if ($dataID == 0){
			$whereStr = '';
		}else{
			if ($type != 'appID'){ $type = 'ID'; }
			$whereStr = ' where PS_'. $type .'='. $dataID;
		}

		$appArr = SysDiff::PluFileArr();	// 插件文件列表数组

		$appexe = $DB->query('select PS_ID,PS_appID,PS_state from '. OT_dbPref .'paySoft'. $whereStr);
		while ($row = $appexe->fetch()){
			if ($row['PS_state'] == 0){
				$oldPart = '';
				$newPart = 'del_';
			}else{
				$oldPart = 'del_';
				$newPart = '';
			}
			$appPath = OT_ROOT .'plugin/';
			if (! empty($appArr[$row['PS_appID']])){
				foreach ($appArr[$row['PS_appID']] as $val){
					if (file_exists($appPath . $oldPart . $val)){
						rename($appPath . $oldPart . $val, $appPath . $newPart . $val);
					}
				}
			}
		}
		unset($appexe);
	}


	// 列表页显示模式
	public static function ListMode($title, $name, $val=1, $className='', $note=''){
		return '
		<tr>
			<td align="right" class="'. $className .'">'. $title .'：</td>
			<td align="left" class="newsListImg">
				<label><input type="radio" id="'. $name .'_7" name="'. $name .'" value="7" '. Is::Checked($val,7) .' /><span><img src="temp/newsList7.jpg" style="display:none;" /></span>标题</label>&ensp;&ensp;
				<label><input type="radio" id="'. $name .'_1" name="'. $name .'" value="1" '. Is::Checked($val,1) .' /><span><img src="temp/newsList1.jpg" style="display:none;" /></span>标题+摘要</label>&ensp;&ensp;
				<label><input type="radio" name="'. $name .'" value="2" '. Is::Checked($val,2) .' /><span><img src="temp/newsList2.jpg" style="display:none;" /></span>图+摘要1</label>&ensp;&ensp;
				<label><input type="radio" name="'. $name .'" value="4" '. Is::Checked($val,4) .' /><span><img src="temp/newsList4.jpg" style="display:none;" /></span>图+摘要2</label>&ensp;&ensp;
				<label><input type="radio" name="'. $name .'" value="3" '. Is::Checked($val,3) .' /><span><img src="temp/newsList3.jpg" style="display:none;" /></span>图+标题</label>&ensp;&ensp;
				<label><input type="radio" id="'. $name .'_5" name="'. $name .'" value="5" '. Is::Checked($val,5) .' /><span><img src="temp/newsList5.jpg" style="display:none;" /></span>分类列表</label>&ensp;&ensp;
				<label><input type="radio" id="'. $name .'_6" name="'. $name .'" value="6" '. Is::Checked($val,6) .' /><span><img src="temp/newsList6.jpg" style="display:none;" /></span>分类列表2</label>&ensp;&ensp;
				<span class="font2_2">（仅对默认模板有效）</span>
				'. $note .'
			</td>
		</tr>
		';
	}

	// WAP列表页显示模式
	public static function WapListMode($title, $name, $val=1, $className='', $note=''){
		return '
		<tr>
			<td align="right" class="'. $className .'">'. $title .'：</td>
			<td align="left" class="newsListImg">
				<label><input type="radio" id="'. $name .'_7" name="'. $name .'" value="7" '. Is::Checked($val,7) .' /><span><img src="temp/newsList7.jpg" style="display:none;" /></span>标题</label>&ensp;&ensp;
				<label><input type="radio" id="'. $name .'_1" name="'. $name .'" value="1" '. Is::Checked($val,1) .' /><span><img src="temp/newsList1.jpg" style="display:none;" /></span>标题+摘要</label>&ensp;&ensp;
				<label><input type="radio" name="'. $name .'" value="2" '. Is::Checked($val,2) .' /><span><img src="temp/newsList2.jpg" style="display:none;" /></span>图+摘要1</label>&ensp;&ensp;
				<label><input type="radio" name="'. $name .'" value="4" '. Is::Checked($val,4) .' /><span><img src="temp/newsList4.jpg" style="display:none;" /></span>图+摘要2</label>&ensp;&ensp;
				<label><input type="radio" name="'. $name .'" value="3" '. Is::Checked($val,3) .' /><span><img src="temp/newsList3.jpg" style="display:none;" /></span>图+标题</label>&ensp;&ensp;
				<span class="font2_2">（仅对默认模板有效）</span>
				'. $note .'
			</td>
		</tr>
		';
	}


	public static function StyleInput($inputName,$inputStyle,$hiddenStr=''){
		$style_b		= Str::GetMark($inputStyle,'font-weight:',';');
		$style_color	= Str::GetMark($inputStyle,'color:',';');

		$retStr = '';
		if (strpos($hiddenStr,'|noB|') === false){
			$retStr .= '&ensp;<label><input type="checkbox" id="'. $inputName .'B" name="'. $inputName .'B" value="1" '. Is::Checked($style_b,'bold') .' onclick=\'StyleInput(this.id, "'. $inputName .'", "b")\'>加粗</label>&ensp;';
		}
		if (strpos($hiddenStr,'|noColor|') === false){
			$retStr .= '&ensp;颜色：<input type="text" id="'. $inputName .'Color" name="'. $inputName .'Color" style="width:90px;" value="'. $style_color .'" />'. Skin::ColorBox('input',$inputName .'Color',$inputName) .'&ensp;';
		}

		return $retStr;
	}

	// 通过会员ID显示实名图标
	public static function UserShimingImg($userID){
		global $DB;
		$cardState = $DB->GetOne('select UE_cardState from '. OT_dbPref .'users where UE_ID='. $userID);
		if ($cardState == 1){
			return '<span title="手动实名认证" style="color:blue;"><img src="images/img_shiming.png" style="margin-left:2px;" /></span>';
		}elseif ($cardState == 11){
			return '<span title="微信扫码实名认证" style="color:blue;"><img src="images/img_shiming11.png" style="margin-left:2px;" /></span>';
		}elseif ($cardState == 21){
			return '<span title="支付宝扫码实名认证" style="color:blue;"><img src="images/img_shiming21.png" style="margin-left:2px;" /></span>';
		}
	}


	// 获取已购买插件appID数组
	public static function GetAppIdArr(){
		global $DB;
	
		$payArr = array(0);
		$payexe = $DB->query('select PS_appID from '. OT_dbPref .'paySoft where PS_state=1');
		while ($row = $payexe->fetch()){
			$payArr[] = $row['PS_appID'];
		}
		unset($payexe);

		return $payArr;
	}


	// 获取参数表单字段信息（废弃，删除）
	public static function TabFieldArr($type){
		global $DB,$tabFieldArr;
		if (empty($tabFieldArr)){ $tabFieldArr = Cache::PhpFile('tabField'); }

		if (isset($tabFieldArr[$type])){
			return $tabFieldArr[$type];
		}else{
			return array();
		}
	}


	// 页头返回管理页按钮
	public static function TopBackBtn($url, $name='返回上级', $addiStr=''){
		return '<div class="padd8"><a href="'. $url .'" class="font2_1">&lt;&lt;&ensp;【'. $name .'】</a>'. $addiStr .'</div>';
	}


	// 日期修改框
	public static function DateRevBox($id, $str){
		return '
			<span id="'. $id .'Txt">'. $str .'</span>
			<input type="text" id="'. $id .'" name="'. $id .'" size="22" style="width:120px;display:none;" value="'. $str .'" onfocus=\'WdatePicker({dateFmt:"yyyy-MM-dd"})\' class="Wdate" />&ensp;
			<label><input type="checkbox" id="'. $id .'Jud" name="'. $id .'Jud" value="1" onclick="TimeBoxRev(this.id)" />修改</label>
			';
	}


	// 时间修改框
	public static function TimeRevBox($id, $str){
		return '
			<span id="'. $id .'Txt">'. $str .'</span>
			<input type="text" id="'. $id .'" name="'. $id .'" size="22" style="width:170px;display:none;" value="'. $str .'" onfocus=\'WdatePicker({dateFmt:"yyyy-MM-dd HH:mm:ss"})\' class="Wdate" />&ensp;
			<label><input type="checkbox" id="'. $id .'Jud" name="'. $id .'Jud" value="1" onclick="TimeBoxRev(this.id)" />修改</label>
			';
	}

	// 数值修改框
	public static function NumRevBox($id, $str, $startStr='', $endStr='', $width='60px'){
		return '
			'. $startStr .'<span id="'. $id .'Txt">'. $str .'</span>
			<input type="text" id="'. $id .'" name="'. $id .'" size="22" style="width:'. $width .';display:none;" value="'. $str .'" />'. $endStr .'
			<label><input type="checkbox" id="'. $id .'Jud" name="'. $id .'Jud" value="1" onclick="TimeBoxRev(this.id)" />修改</label>
			';
	}


	// 天数框
	public static function InputDayBox($id, $str, $mode=''){
		$retStr = '
			<input type="text" id="'. $id .'" name="'. $id .'" size="50" style="width:70px;" value="'. $str .'" />天&ensp;
			<input type="button" value="关闭" onclick=\'$id("'. $id .'").value="0";\' />
			';
		if ( in_array($id,array('bigItemDay')) ){
			$retStr .= '
				<input type="button" value="1天" onclick=\'$id("'. $id .'").value="1";\' />
				<input type="button" value="2天" onclick=\'$id("'. $id .'").value="2";\' />
				<input type="button" value="3天" onclick=\'$id("'. $id .'").value="3";\' />
				<input type="button" value="5天" onclick=\'$id("'. $id .'").value="5";\' />
				<input type="button" value="7天" onclick=\'$id("'. $id .'").value="7";\' />
				';
		}else{
			$retStr .= '
				<input type="button" value="7天" onclick=\'$id("'. $id .'").value="7";\' />
				<input type="button" value="15天" onclick=\'$id("'. $id .'").value="15";\' />
				<input type="button" value="30天" onclick=\'$id("'. $id .'").value="30";\' />
				<input type="button" value="60天" onclick=\'$id("'. $id .'").value="60";\' />
				<input type="button" value="90天" onclick=\'$id("'. $id .'").value="90";\' />
				';
		}

		return $retStr;
	}


	// 上传框 保存至
	public static function UploadSaveBox($upFileOss){
		$retStr = '
			<label><input type="radio" id="saveToWeb" name="saveTo" value="web" checked="checked" />网站&ensp;</label>'. 
			AppOssAliyun::UpImgItem($upFileOss) .
			AppOssQiniu::UpImgItem($upFileOss) . 
			AppOssUpyun::UpImgItem($upFileOss) . 
			AppOssFtp::UpImgItem($upFileOss) .
			'';
		return $retStr;
	}


	// 上传框 导航菜单
	public static function UploadNavBox($url, $defSel, $showMode=-1){
		$retStr = '';
		if ($defSel == 'upImg'){
			$retStr .= '<li class="selected">上传图片</li>';
		}else{
			$retStr .= '<li><a href="info_upImg.php'. $url .'" class="font3_1">上传图片</a></li>';
		}
		if ($defSel == 'upFile'){
			$retStr .= '<li class="selected">上传文件</li>';
		}else{
			$retStr .= '<li><a href="info_upFile.php'. $url .'" class="font3_1">上传文件</a></li>';
		}
		if (AppUpKeepBigFile::Jud()){
			if ($defSel == 'upKeepBigFile'){
				$retStr .= '<li class="selected">上传大文件</li>';
			}else{
				$retStr .= '<li><a href="info_upKeepBigFile.php'. $url .'" class="font3_1">上传大文件'. Skin::PluSign(AppUpKeepBigFile::$appName, 'bottom') .'</a></li>';
			}
		}
		if (AppUpload::Jud()){
			if ($defSel == 'upMoreFile'){
				$retStr .= '<li class="selected">批量上传</li>';
			}else{
				$retStr .= '<li><a href="info_upMoreFile.php'. $url .'" class="font3_1">批量上传'. Skin::PluSign(AppUpload::$appName, 'bottom') .'</a></li>';
			}
			/* if ($showMode == 2){
				$retStr .= '<li class="selected">批量图片上传</li>';
			}else{
				$retStr .= '<li><a href="info_upBigFile.php'. $url .'&showMode=2" class="font3_1">批量图片上传'. Skin::PluSign(AppUpload::$appName, 'bottom') .'</a></li>';
			}
			if ($showMode == 1){
				$retStr .= '<li class="selected">批量文件上传</li>';
			}else{
				$retStr .= '<li><a href="info_upBigFile.php'. $url .'&showMode=1" class="font3_1">批量文件上传'. Skin::PluSign(AppUpload::$appName, 'bottom') .'</a></li>';
			}
			if ($showMode == 1){
				$retStr .= '<li class="selected">批量文件上传2</li>';
			}else{
				$retStr .= '<li><a href="info_upBigFile2.php'. $url .'&showMode=1" class="font3_1">批量文件上传2'. Skin::PluSign(AppUpload::$appName, 'bottom') .'</a></li>';
			}
			if ($showMode == 2){
				$retStr .= '<li class="selected">大文件上传</li>';
			}else{
				$retStr .= '<li><a href="info_upBigFile2.php'. $url .'&showMode=2" class="font3_1">大文件上传'. Skin::PluSign(AppUpload::$appName, 'bottom') .'</a></li>';
			} */
		}
		if ($defSel == 'serverFile'){
			$retStr .= '<li class="selected">服务器文件</li>';
		}else{
			$retStr .= '<li><a href="serverFile.php'. $url .'" class="font3_1">服务器文件</a></li>';
		}
		return $retStr;
	}


	// 伪静态规则	tag/(.*)	news/?list_mark-$1.html&static
	public static function StaticRule($oldUrl, $newUrl, $cnName='', $enName='', $type=''){
		$retArr = array('httpd'=>'', 'htaccess'=>'', 'nginx'=>'', 'iis'=>'');

		if (strlen($cnName) > 0){
			$retArr['httpd']	.= '# '. $cnName . PHP_EOL;
			$retArr['htaccess']	.= '# '. $cnName . PHP_EOL;
			$retArr['nginx']	.= '# '. $cnName . PHP_EOL;
			$retArr['iis']		.= '<!-- '. $cnName .' -->'. PHP_EOL;
		}
		$retArr['httpd']	.= 'RewriteRule /'. $oldUrl .' /'. $newUrl .''. PHP_EOL;
		$retArr['htaccess']	.= 'RewriteRule ^'. $oldUrl .'$ '. str_replace(array('?'),array('\?'),$newUrl) .''. PHP_EOL;
		$retArr['nginx']	.= 'rewrite ^/'. $oldUrl .'$ /'. $newUrl .';'. PHP_EOL;
		$retArr['iis']		.= '<rule name="tag">'. PHP_EOL .
								'	<match url="^'. $oldUrl .'" ignoreCase="true"/>'. PHP_EOL .
								'	<action type="Rewrite" url="/'. str_replace(array('&','$1','$2','$3'), array('&amp;','{R:1}','{R:2}','{R:3}'), $newUrl) .'" />'. PHP_EOL .
								'</rule>'. PHP_EOL;
		return $retArr;
	}


	// 编辑器栏目
	public static function EditorList($type, $id, $def=''){
		global $user_ID;

		$retStr = '
			<label><input type="radio" name="'. $id .'" value="kindeditor4" '. Is::Checked($def,'kindeditor4') .' /><span><img src="temp/editor_kindeditor4.png" style="display:none;" /></span>KindEditor4.1.11<span style="color:red;">（默认）</span></label>&ensp;&ensp;&ensp;
			'. self::EditorItem($type, $id, 'ckeditor4', 'CKEditor4.22.1', $def) .'
			'. ($type != 'wap' ? self::EditorItem($type, $id, 'ckeditor3', 'CKEditor3.6.6', $def) : '') .'
			'. self::EditorItem($type, $id, 'kindeditor3', 'KindEditor3.5.6', $def, '<span style="color:red;">（不推荐，不兼容新版浏览器）</span>') .'
			'. self::EditorItem($type, $id, 'fckeditor', 'FCKeditor2.6.4', $def) .'
			'. self::EditorItem($type, $id, 'ueditor', 'UEditor1.4.3.3(百度编辑器)', $def) .'
			'. ($user_ID == 1 ? '<span style="color:blue;">（编辑器文件到【管理员区→程序文件检查】-[可选文件下载]下载）</span>' : '') .'
			';
			/*
			'. self::EditorItem($type, $id, 'ckeditor5', 'CKEditor5 v38.1.1', $def) .'
			*/
		return $retStr;
	}


	// 编辑器项目
	public static function EditorItem($type, $id, $value, $theme, $def='', $addi=''){
		if ($type == 'admin'){
			$filePath = OT_adminROOT;
			$pathCN = '后台目录/';
		}elseif ($type == 'qiantai'){
			$filePath = OT_ROOT;
			$pathCN = '';
		}elseif ($type == 'wap'){
			$filePath = OT_ROOT .'wap/';
			$pathCN = 'wap/';
		}else{
			die('AdmArea::EditorItem type参数值不存在');
		}

		switch ($value){
			case 'kindeditor4':
				$filePath .= 'tools/kindeditor4/kindeditor-all-min.js';
				$pathCN .= 'tools/kindeditor4/';
				break;

			case 'kindeditor3':
				$filePath .= 'tools/kindeditor3/kindeditor-min.js';
				$pathCN .= 'tools/kindeditor3/';
				break;

			case 'ckeditor5':
				$filePath .= 'tools/ckeditor5/ckeditor.js';
				$pathCN .= 'tools/ckeditor5/';
				break;

			case 'ckeditor4':
				$filePath .= 'tools/ckeditor4/ckeditor.js';
				$pathCN .= 'tools/ckeditor4/';
				break;

			case 'ckeditor3':
				$filePath .= 'tools/ckeditor3/ckeditor.js';
				$pathCN .= 'tools/ckeditor3/';
				break;

			case 'fckeditor':
				$filePath .= 'tools/fckeditor/fckeditor.js';
				$pathCN .= 'tools/fckeditor/';
				break;

			case 'ueditor':
				$filePath .= 'tools/ueditor/ueditor.config.js';
				$pathCN .= 'tools/ueditor/';
				break;

			default :
				die('AdmArea::EditorItem value参数值不存在');
		}

		$fileStr = File::Read($filePath);
		if (strlen($fileStr) <= 15){
			$retStr = '
				<label style="color:#ccc;" title="未检测到'. $value .'编辑器，请确定存在【'. $pathCN .'】该目录"><input type="radio" name="'. $id .'" value="'. $value .'" disabled="true" /><span><img src="temp/editor_'. $value .'.png" style="display:none;" /></span>'. $theme .'【不存在】</label>&ensp;&ensp;&ensp;
				';
		}else{
			$retStr = '
				<label><input type="radio" name="'. $id .'" value="'. $value .'" '. Is::Checked($def, $value) .' /><span><img src="temp/editor_'. $value .'.png" style="display:none;" /></span>'. $theme . $addi .'</label>&ensp;&ensp;&ensp;
				';
		}

		return $retStr;
	}

}
?>