- Apache环境在上传目录添加配置文件`.htaccess` 使上传目录不可运行PHP程序（默认已经存在)

```Apache
<FilesMatch "\.(?i:php|php3|php4|php5)">
Order allow,deny
Deny from all
</FilesMatch>
```

- Nginx环境禁止多个目录运行`PHP`程序：

```Nginx
    # "i|public"是你要禁止的目录 放到listen段落之后才生效
    location ~* ^/(config|docs|i|public)/.*\.(php|php5)$ {
      deny all;
    }
```

- Lighthttpd环境禁止多个目录运行`PHP`程序：

```Lighthttpd
$HTTP["url"] =~ "^/(config|docs|i|public)/" {
	fastcgi.server = ()
}
```
