﻿Imports System
Imports Wisej.Web

Public Class Page1

    Private Sub Page1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Me.navigationBar.SelectedItem = Me.navigationBarHome
    End Sub

    Private Sub ShowPanel(panelName As String)
        Me.panelMain.Controls.Clear()

        Dim panel = CType(Activator.CreateInstance(Type.GetType($"$safeprojectname$.{panelName}")), Control)
        panel.Dock = DockStyle.Fill
        panel.Parent = Me.panelMain

        Dim animationIn = Me.animationIn.GetAnimation(panel)
        animationIn.Event = "appear"
        animationIn.Name = "slideLeftIn"
    End Sub

    Private Sub navigationBar_SelectedItemChanged(sender As Object, e As EventArgs) Handles navigationBar.SelectedItemChanged
        ShowPanel(CType(Me.navigationBar.SelectedItem.Tag, String))
    End Sub

    Private Sub comboBoxTheme_SelectedIndexChanged(sender As Object, e As EventArgs) Handles comboBoxTheme.SelectedIndexChanged
        Wisej.Web.Application.LoadTheme(Me.comboBoxTheme.Text)
    End Sub

    Private Sub linkLabelAbout_LinkClicked(sender As Object, e As LinkLabelLinkClickedEventArgs) Handles linkLabelAbout.LinkClicked
        Wisej.Web.Application.Navigate("https://docs.wisej.com", target:="_blank")
    End Sub

    Private Sub navigationBar_TitleClick(sender As Object, e As EventArgs) Handles navigationBar.TitleClick
        Me.navigationBar.SelectedItem = Me.navigationBarHome
    End Sub

End Class
