﻿Imports System
Imports $safeprojectname$.Data
Imports Wisej.Web

''' <summary>
''' Represents a reusable control for hosting weather forecasts.
''' </summary>
Public Class WeatherForecastPanel
    Private Sub WeatherForecastPanel_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        LoadData()
    End Sub

    Private Async Sub LoadData()
        Dim count = 0

        Integer.TryParse(Me.comboBoxNumbeFetch.Text, count)

        Me.dataGridViewData.DataSource = Await New WeatherForecastService().GetForecastAsync(DateTime.Now, count)

        Me.dataGridViewData.Columns("CurrentDate").DefaultCellStyle.Format = "d"
        Me.dataGridViewData.Columns("TemperatureK").DefaultCellStyle.Format = "N3"
    End Sub

    Private Sub buttonClickMe_Click(sender As Object, e As EventArgs) Handles buttonClickMe.Click
        LoadData()
    End Sub
End Class
