﻿Imports System
Imports System.ComponentModel

Namespace Model
    ''' <summary>
    ''' Represents a weather forecast.
    ''' </summary>
    Public Class WeatherForecast
        Private _currentDate As DateTime
        <SRDisplayName("Current Date")>
        Public Property CurrentDate() As DateTime
            Get
                Return _currentDate
            End Get
            Set(ByVal value As DateTime)
                _currentDate = value
            End Set
        End Property

        Private _temperatureC As Integer
        <SRDisplayName("Temp. (C)")>
        Public Property TemperatureC() As Integer
            Get
                Return _temperatureC
            End Get
            Set(ByVal value As Integer)
                _temperatureC = value
            End Set
        End Property

        Private _summary As String
        <SRDisplayName("Temp. (C)")>
        Public Property Summary() As String
            Get
                Return _summary
            End Get
            Set(ByVal value As String)
                _summary = value
            End Set
        End Property

        <SRDisplayName("Temp. (K=F)")>
        Public ReadOnly Property TemperatureF() As Integer
            Get
                Return 32 + CType((TemperatureC / 0.5556), Integer)
            End Get
        End Property

        <SRDisplayName("Temp. (K)")>
        Public ReadOnly Property TemperatureK() As Double
            Get
                Return TemperatureC + 273.15
            End Get
        End Property

    End Class
End Namespace

