﻿Imports System.Resources
Imports System.ComponentModel

Namespace Model
    ''' <summary>
    ''' Provides a localized display name for a property, method, or event.
    ''' </summary>
    Public Class SRDisplayName
        Inherits DisplayNameAttribute

        Public Sub New(text As String)
            MyBase.New(text)
        End Sub

        Public Overrides ReadOnly Property DisplayName As String
            Get
                SR = If(SR Is Nothing, New ResourceManager("WisejNavigationApplication1.MyProject.Resource", GetType(DisplayNameAttribute).Assembly), SR)
                Try
                    Return SR.GetString(MyBase.DisplayNameValue)
                Catch ex As Exception
                    Return MyBase.DisplayNameValue
                End Try
            End Get
        End Property

        Private Shared SR As ResourceManager

    End Class
End Namespace
