﻿Imports System
Imports System.ComponentModel
Imports $safeprojectname$.Model

Namespace Data
    ''' <summary>
    ''' Represents a service for fetching random weather forestcasts.
    ''' </summary>
    Public Class WeatherForecastService
        Private Shared ReadOnly Summaries() As String = {"Freezing", "Bracing", "Chilly", "Cool", "Mild", "Warm", "Balmy", "Hot", "Sweltering", "Scorching"}

        Public Function GetForecastAsync(startDate As DateTime, count As Integer) As Task(Of BindingList(Of WeatherForecast))
            Dim rand = New Random()
            Dim list = New BindingList(Of WeatherForecast)
            For index = 0 To count
                Dim data = New WeatherForecast
                With data
                    .CurrentDate = DateTime.Now.AddDays(index)
                    .Summary = Summaries(rand.Next(Summaries.Length))
                    .TemperatureC = rand.Next(-20, 55)
                End With

                list.Add(data)
            Next index

            Return Task.FromResult(list)
        End Function

    End Class

End Namespace

