﻿Namespace Controls
    ''' <summary>
    ''' Represents a reusable survey prompt control
    ''' </summary>
    Public Class SurveyPrompt
        Inherits Wisej.Web.FlowLayoutPanel

        Private WithEvents pictureBoxEdit As Wisej.Web.PictureBox
        Private WithEvents labelDescription As Wisej.Web.Label
        Private WithEvents linkBriefSurvey As Wisej.Web.LinkLabel

        Public Sub New()
            InitializeComponent()
        End Sub

        Public Overrides Property Text As String
            Get
                Return Me.labelDescription.Text
            End Get
            Set(value As String)
                Me.labelDescription.Text = value
            End Set
        End Property

        Private Sub InitializeComponent()
            Me.pictureBoxEdit = New Wisej.Web.PictureBox()
            Me.labelDescription = New Wisej.Web.Label()
            Me.linkBriefSurvey = New Wisej.Web.LinkLabel()
            CType(Me.pictureBoxEdit, System.ComponentModel.ISupportInitialize).BeginInit()
            Me.SuspendLayout()
            '
            'pictureBoxEdit
            '
            Me.pictureBoxEdit.ImageSource = "resource.wx/Wisej.Ext.BootstrapIcons/info-circle.svg"
            Me.pictureBoxEdit.Location = New System.Drawing.Point(13, 13)
            Me.pictureBoxEdit.Name = "pictureBoxEdit"
            Me.pictureBoxEdit.Size = New System.Drawing.Size(22, 32)
            '
            'labelDescription
            '
            Me.labelDescription.AutoSize = True
            Me.labelDescription.Font = New System.Drawing.Font("@windowTitle", 16.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel)
            Me.labelDescription.Location = New System.Drawing.Point(41, 13)
            Me.labelDescription.MinimumSize = New System.Drawing.Size(0, 31)
            Me.labelDescription.Name = "labelDescription"
            Me.labelDescription.Size = New System.Drawing.Size(38, 31)
            Me.labelDescription.TabIndex = 6
            Me.labelDescription.Text = "Title"
            Me.labelDescription.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
            '
            'linkBriefSurvey
            '
            Me.linkBriefSurvey.Font = New System.Drawing.Font("default", 15.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel)
            Me.linkBriefSurvey.LinkArea = New Wisej.Web.LinkArea(16, 12)
            Me.linkBriefSurvey.Location = New System.Drawing.Point(85, 13)
            Me.linkBriefSurvey.Name = "linkBriefSurvey"
            Me.linkBriefSurvey.Size = New System.Drawing.Size(363, 32)
            Me.linkBriefSurvey.TabIndex = 7
            Me.linkBriefSurvey.Text = "Please take our brief survey and tell us what you think."
            Me.linkBriefSurvey.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
            '
            'SurveyPrompt
            '
            Me.AutoSize = True
            Me.AutoSizeMode = Wisej.Web.AutoSizeMode.GrowAndShrink
            Me.BackColor = System.Drawing.Color.FromName("@gray-200")
            Me.BorderStyle = Wisej.Web.BorderStyle.Solid
            Me.Controls.Add(Me.pictureBoxEdit)
            Me.Controls.Add(Me.labelDescription)
            Me.Controls.Add(Me.linkBriefSurvey)
            Me.Name = "SurveyPrompt"
            Me.Padding = New Wisej.Web.Padding(10)
            Me.Size = New System.Drawing.Size(463, 60)
            Me.Text = "SurveyPrompt"
            CType(Me.pictureBoxEdit, System.ComponentModel.ISupportInitialize).EndInit()
            Me.ResumeLayout(False)
            Me.PerformLayout()

        End Sub

        Private Sub linkBriefSurvey_LinkClicked(sender As Object, e As Wisej.Web.LinkLabelLinkClickedEventArgs) Handles linkBriefSurvey.LinkClicked
            Wisej.Web.Application.Navigate("https://us13.list-manage.com/survey?u=c8bb40d1323838a33db98836b&id=5172de174c&attribution=false", target:="_blank")
        End Sub
    End Class

End Namespace
