﻿///////////////////////////////////////////////////////////////////////////////
//
// (C) 2022 ICE TEA GROUP LLC - ALL RIGHTS RESERVED
//
// 
//
// ALL INFORMATION CONTAINED HEREIN IS, AND REMAINS
// THE PROPERTY OF ICE TEA GROUP LLC AND ITS SUPPLIERS, IF ANY.
// THE INTELLECTUAL PROPERTY AND TECHNICAL CONCEPTS CONTAINED
// HEREIN ARE PROPRIETARY TO ICE TEA GROUP LLC AND ITS SUPPLIERS
// AND MAY BE COVERED BY U.S. AND FOREIGN PATENTS, PATENT IN PROCESS, AND
// ARE PROTECTED BY TRADE SECRET OR COPYRIGHT LAW.
//
// DISSEMINATION OF THIS INFORMATION OR REPRODUCTION OF THIS MATERIAL
// IS STRICTLY FORBIDDEN UNLESS PRIOR WRITTEN PERMISSION IS OBTAINED
// FROM ICE TEA GROUP LLC.
//
///////////////////////////////////////////////////////////////////////////////

using System.ComponentModel;

namespace Wisej.Ext.WebAuthn
{
	/// <summary>
	/// Attestation conveyance preferences.
	/// </summary>
	/// <remarks>
	/// <See: href="https://w3c.github.io/webauthn/#attestation-conveyance"/>
	/// </remarks>
	[ApiCategory("WebAuthn")]
	public enum AttestationConveyancePreference
	{
		/// <summary>
		/// The Relying Party is not interested in authenticator attestation.
		/// </summary>
		None,

		/// <summary>
		/// The Relying Party wants to receive a verifiable attestation statement, 
		/// but allows the client to decide how to obtain such an attestation statement.
		/// </summary>
		Indirect,

		/// <summary>
		/// The Relying Party wants to receive the attestation statement as generated by the authenticator.
		/// </summary>
		Direct,

		/// <summary>
		/// The Relying Party wants to receive an attestation statement that may include uniquely identifying information. 
		/// </summary>
		/// <remarks>
		/// This is intended for controlled deployments within an enterprise where the organization 
		/// wishes to tie registrations to specific authenticators. User agents MUST NOT provide such 
		/// an attestation unless the user agent or authenticator configuration permits it for the requested RP ID.
		/// </remarks>
		Enterprise
	}
}
