/*
 * Decompiled with CFR 0.152.
 */
package com.abbyy.FREngine;

import com.abbyy.FREngine.IEngine;
import com.abbyy.FREngine.IEngineLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Engine {
    private static String jniDllFolder = null;
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final String platformShortName = Engine.determinePlatformShortName();
    private static final String freDataPath = "ABBYY/SDK/11/FineReader Engine";
    private static final String javaFolder = "Java";
    private static final String javaInteropName = Engine.getJavaInteropName();
    private static final String jniDllName = Engine.getPlatformDllName("FREngine.Jni");
    private static final String freDllName = Engine.getPlatformDllName("FREngine");
    private static final String x86Arch = "x86";
    private static final String x64Arch = "x64";
    private static final String[] jvmKeys = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};

    public static IEngine Load(String string, String string2) {
        try {
            Engine.loadFREngineJNIDll(string);
            return Engine.load(Engine.combinePaths(string, freDllName), string2, "", "", false, "", "");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static IEngine GetEngineObject(String string, String string2) throws Exception {
        Engine.loadFREngineJNIDll(string);
        return Engine.load(Engine.combinePaths(string, freDllName), string2, "", "", false, "", "");
    }

    public static IEngine LoadEx(String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
        try {
            Engine.loadFREngineJNIDll(string);
            return Engine.load(Engine.combinePaths(string, freDllName), string2, string3, string4, bl, string5, string6);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static IEngine GetEngineObjectEx(String string, String string2, String string3, String string4, boolean bl, String string5, String string6) throws Exception {
        Engine.loadFREngineJNIDll(string);
        return Engine.load(Engine.combinePaths(string, freDllName), string2, string3, string4, bl, string5, string6);
    }

    public static void Unload() {
        try {
            System.gc();
            System.runFinalization();
            Engine.unload();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public static void DeinitializeEngine() throws Exception {
        System.gc();
        System.runFinalization();
        Engine.unload();
    }

    public static IEngineLoader CreateEngineInprocLoader() {
        try {
            if (!Engine.isWindows()) {
                throw new Exception("IEngineLoader is not supported on this platform");
            }
            Engine.unpackJarAndLoadFREngineJNIDll();
            return Engine.createEngineInprocLoader();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static IEngineLoader GetEngineInprocLoader() throws Exception {
        if (!Engine.isWindows()) {
            throw new Exception("IEngineLoader is not supported on this platform");
        }
        Engine.unpackJarAndLoadFREngineJNIDll();
        return Engine.createEngineInprocLoader();
    }

    public static IEngineLoader CreateEngineOutprocLoader() {
        try {
            if (!Engine.isWindows()) {
                throw new Exception("IEngineLoader is not supported on this platform");
            }
            Engine.unpackJarAndLoadFREngineJNIDll();
            return Engine.createEngineOutprocLoader();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static IEngineLoader GetEngineOutprocLoader() throws Exception {
        if (!Engine.isWindows()) {
            throw new Exception("IEngineLoader is not supported on this platform");
        }
        Engine.unpackJarAndLoadFREngineJNIDll();
        return Engine.createEngineOutprocLoader();
    }

    public static void SetJNIDllFolder(String string) {
        jniDllFolder = string;
    }

    public static String GetJNIDllFolder() {
        if (jniDllFolder != null) {
            return jniDllFolder;
        }
        String string = System.getenv("PROGRAMDATA");
        if (string != null) {
            String string2 = Engine.combinePaths(string, freDataPath);
            if (Engine.canWriteToDir(string2)) {
                return string2;
            }
        } else {
            String string3;
            string = System.getenv("ALLUSERSPROFILE");
            if (string != null && Engine.canWriteToDir(string3 = Engine.combinePaths(string, freDataPath))) {
                return string3;
            }
        }
        return System.getProperty("java.io.tmpdir");
    }

    protected static native IEngine load(String var0, String var1, String var2, String var3, boolean var4, String var5, String var6);

    protected static native IEngineLoader createEngineInprocLoader();

    protected static native IEngineLoader createEngineOutprocLoader();

    protected static native void unload();

    private static void loadFREngineJNIDll(String string) throws Exception {
        if (Engine.isWindows()) {
            Engine.unpackJarAndLoadFREngineJNIDll();
        } else {
            Engine.loadFREngineJNIDllFromFolder(string);
        }
    }

    private static void unpackJarAndLoadFREngineJNIDll() throws Exception {
        Object object;
        String string = null;
        ClassLoader classLoader = Engine.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            object = (URLClassLoader)classLoader;
            for (URL uRL : ((URLClassLoader)object).getURLs()) {
                String string2 = uRL.toString();
                if (string2.indexOf(javaInteropName + ".jar") <= 0) continue;
                int n = "file:/".length();
                int n2 = string2.length();
                string = string2.substring(n, n2);
                string = string.replace("%20", " ");
            }
        }
        if (!Engine.canWriteToDir((String)(object = Engine.GetJNIDllFolder()))) {
            throw new Exception("Can't access to the JNI dll folder: \"" + (String)object + "\". Use method SetJNIDllFolder to set the correct path.");
        }
        if (string != null) {
            try {
                object = Engine.combinePaths((String)object, javaFolder);
                Engine.createPath((String)object);
                object = Engine.combinePaths((String)object, javaInteropName);
                Engine.createPath((String)object);
                Engine.unpackJar(string, (String)object, platformShortName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string5 = Engine.combinePaths((String)object, platformShortName);
        string5 = Engine.combinePaths(string5, Engine.getJVMArchitecture());
        string5 = Engine.combinePaths(string5, jniDllName);
        System.load(string5);
    }

    private static void loadFREngineJNIDllFromFolder(String string) {
        String string2 = Engine.combinePaths(string, jniDllName);
        System.load(string2);
    }

    private static String getJVMArchitecture() throws Exception {
        for (String string : jvmKeys) {
            String string2 = System.getProperty(string);
            if (string2 == null) continue;
            if (string2.indexOf("64") >= 0) {
                return x64Arch;
            }
            if (string2.indexOf("32") >= 0) {
                return x86Arch;
            }
            if (string2.indexOf("86") < 0) continue;
            return x86Arch;
        }
        throw new Exception("Can't determine the JVM architecture.");
    }

    private static void unpackJar(String string, String string2, String string3) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith(string3)) continue;
            if (zipEntry.isDirectory()) {
                new File(Engine.combinePaths(string2, zipEntry.getName())).mkdir();
                continue;
            }
            linkedList.add(zipEntry);
        }
        for (ZipEntry zipEntry : linkedList) {
            int n;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(Engine.combinePaths(string2, zipEntry.getName()));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        zipFile.close();
    }

    private static void createPath(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static void deletePath(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            Engine.deleteDir(file);
        }
    }

    private static void deleteDir(File file) throws IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Engine.deleteDir(new File(file, stringArray[i]));
            }
        }
        file.delete();
    }

    private static boolean canWriteToDir(String string) {
        File file = new File(string);
        return file.canWrite();
    }

    private static String combinePaths(String string, String string2) {
        File file = new File(string);
        File file2 = new File(file, string2);
        return file2.getPath();
    }

    private static boolean isWindows() {
        return osName.indexOf("windows") >= 0;
    }

    private static boolean isLinux() {
        return osName.indexOf("linux") >= 0;
    }

    private static boolean isMac() {
        return osName.indexOf("mac") >= 0;
    }

    private static String determinePlatformShortName() {
        if (Engine.isWindows()) {
            return "win";
        }
        return "unix";
    }

    private static String getPlatformDllName(String string) {
        if (Engine.isWindows()) {
            return string + ".dll";
        }
        if (Engine.isLinux()) {
            return "lib" + string + ".so";
        }
        if (Engine.isMac()) {
            return "lib" + string + ".dylib";
        }
        throw new Error("Can't determine the OS type.");
    }

    private static String getJavaInteropName() {
        String string = "com.abbyy.FREngine";
        try {
            String string2 = Engine.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            int n = string2.lastIndexOf("/");
            if (n == -1) {
                n = string2.lastIndexOf("\\");
            }
            int n2 = string2.lastIndexOf(".jar");
            string = string2.substring(n + 1, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

