# newsAN App - Andaman & Nicobar Local News App

This open-source project aims to create a local news app for the Andaman & Nicobar Islands. The app will provide users with access to local news articles, events, and updates.

## Features

1. User-Friendly Interface: A clean and intuitive user interface with a focus on legibility and ease of navigation.
2. Customizable Font Sizes: The ability for users to adjust font sizes to suit their preferences, ensuring comfortable reading for individuals with varying visual abilities.
3. Personalized Content: Customizable preferences for users to follow specific categories, topics, and sources of interest.
4. Offline Reading: The capability for users to save articles for offline reading, ensuring access to news even without an internet connection.
5. Receive push notifications for breaking news and important updates.

## Screenshots
### iOS Screens
<img src="/iOS/Screenshot.png"/> 

### Android Screens
<p align="left">
<img src="/android/NewsAN/assets/screenshot1.jpeg" width="265" height="550"/> <img src="/android/NewsAN/assets/screenshot2.jpeg" width="265" height="550"/>
   <img src="/android/NewsAN/assets/screenshot3.jpeg" width="265" height="550"/> <img src="/android/NewsAN/assets/screenshot4.jpeg" width="265" height="550"/>
   <img src="/android/NewsAN/assets/screenshot5.jpeg" width="265" height="550"/>
</p>

## Tech Stack

- Backend: Firebase
- Android App: Kotlin Jetpack compose
- iOS App: Swift

## Installation

1. Clone the repository: `git clone https://github.com/iampranabray/NewsAN.git`
2. Android App:
   - Open the `android-app` directory in Android Studio.
   - Build and run the app on an Android emulator or device.
3. iOS App:
   - Open the `ios-app` directory in Xcode.
   - Build and run the app on the iOS simulator or a physical device.

## Contributing

Contributions to this project are welcome! If you find any issues or want to add new features, please open an issue or submit a pull request.

## License

This project is open-source and available under the [MIT License](LICENSE).

## Disclaimer

Please note that this project is for educational and non-commercial purposes. Ensure you have the necessary rights to display news content and comply with all legal and ethical considerations.

---

For any questions or inquiries, please contact [impranabray@gmail.com](mailto:your@email.com).



