import '@/styles/alien-invasion.css'

const AlienInvasion = () => (
  <div className="mx-auto">
    <svg
      xmlns="http://www.w3.org/2000/svg"
      id="galinv"
      width="100%"
      height="100%"
      baseProfile="tiny"
      className="svgmate"
      version="1"
      viewBox="53 100 719 594"
    >
      <g id="Background_Gray" fill="#F3F3F3">
        <path
          id="Cloud1"
          d="M217 415c-3 0-6 1-8 3a18 18 0 1 0-18 23h26c7 0 13-6 13-13s-6-13-13-13z"
        />
        <path
          id="Cloud2"
          d="M478 384c-3 0-6 2-7 4a12 12 0 0 0-21-6c-2-8-8-13-16-13a17 17 0 1 0 0 34h44c5 0 9-4 9-10 0-4-4-9-9-9z"
        />
        <path
          id="Building_Right"
          d="M686 610c0-2 2-3 3-3h26c2 0 3 1 3 3v49c0 2-1 3-3 3h-26c-1 0-3-1-3-3v-49z"
        />
        <path
          id="Building_Left"
          d="M272 354c0-2-1-3-3-3h-26c-1 0-2 1-2 3v102c0 8-5 9-8 9h-37c-2 0-3 2-3 3v193c0 1 1 3 3 3h73c2 0 3-2 3-3v-1-306z"
        />
      </g>
      <g id="EXTRAS_Bubbles">
        <g
          id="Cross_1"
          fill="none"
          stroke="#020202"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          className="star1"
        >
          <path d="M436 272l11 16M449 274l-16 11" />
        </g>
        <g
          id="Cross_2"
          fill="none"
          stroke="#020202"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          className="star2"
        >
          <path d="M124 308l11 16M138 311l-16 10" />
        </g>
        <g
          id="Cross_3"
          fill="none"
          stroke="#020202"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          className="star3"
        >
          <path d="M708 170l11 16M722 173l-16 11" />
        </g>
        <g
          id="Cross_4"
          fill="none"
          stroke="#020202"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          className="star4"
        >
          <path d="M726 411l12 16M740 413l-16 11" />
        </g>
        <g
          id="Cross_5"
          fill="none"
          stroke="#020202"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          className="star5"
        >
          <path d="M160 190l17 9M173 186l-9 17" />
        </g>
        <g
          id="Cross_6"
          fill="none"
          stroke="#020202"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          className="star6"
        >
          <path d="M542 175h20M553 165l-1 19" />
        </g>
        <path
          id="LaserLine_1"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          d="M651 165l83 82"
        />
        <path
          id="LaserLine_2"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M230 272l84 82"
        />
        <path
          id="LaserLine_3"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M36 215l83 82"
        />
        <path
          id="LaserLine_4"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M507 137l84 82"
        />
        <path
          id="LaserLine_5"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M684 211l84 82"
        />
        <path
          id="LaserLine_6"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M363 195l129 158"
        />
        <path
          id="LaserLine_7"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M583 224l131 130"
        />
        <path
          id="LaserLine_8"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M29 442l83 82"
        />
        <path
          id="LaserLine_9"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M122 100l57 56"
        />
        <path
          id="LaserLine_10"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M223 316l101 100"
        />
        <path
          id="LaserLine_11"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M412 267l95 102"
        />
        <path
          id="LaserLine_12"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M518 178l62 61"
        />
        <path
          id="LaserLine_13"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M672 450l83 82"
        />
        <path
          id="LaserLine_14"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M255 169l131 131"
        />
        <path
          id="LaserLine_15"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M146 283l96 90"
        />
        <path
          id="LaserLine_16"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M78 527l83 82"
        />
        <path
          id="LaserLine_17"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          d="M559 224l45 44"
        />
        <path
          id="LaserLine_18"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M363 259l84 80"
        />
        <path
          id="LaserLine_19"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M151 293l50 49"
        />
        <path
          id="LaserLine_20"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M239 146l131 130"
        />
        <path
          id="LaserLine_21"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M436 177l94 103"
        />
        <path
          id="LaserLine_22"
          fill="none"
          stroke="#a855f7"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M14 178l225 204"
        />
        <path
          id="LaserLine_23"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="3"
          d="M417 312l90 99"
        />
        <path
          id="LaserLine_24"
          fill="none"
          stroke="#f7f755"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="4"
          d="M63 290l75 71"
        />
      </g>
      <g id="BUILDING_1">
        <g id="_x31_BUILDING_LINES">
          <path
            id="FRONT:_MainPlane"
            fill="#FFF"
            d="M279 538v125H174V539l52-30z"
          />
          <path
            id="Side_Plane_-_GRAY"
            fill="#ECECEC"
            d="M375 663V539l-69-33-80-1 53 33v125h96"
          />
          <path
            id="Side_-_Horizontal"
            fill="#FCFCFC"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M279 577h96v6h-96z"
          />
          <path
            id="Building_Lines_-_Vertical_1_"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M174 539v123"
          />
          <path
            id="Building_Lines_-_Vertical"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M279 662V539"
          />
          <path
            id="Building_Lines_-_Horizontal"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M375 628H175"
          />
          <path
            id="FRONT:_Building_Lines_-_Horizontal"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M279 621H175"
          />
          <path
            id="SIDE:_Building_Lines_-_Horizontal_1_"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M287 621h-2"
          />
          <path
            id="SIDE:_Building_Lines_-_Horizontal_2_"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M375 621h-86"
          />
          <path
            id="SIDE:_Building_Lines_-_Horizontal"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M375 539h-96"
          />
          <path
            id="Building_Lines_-_Roof_Line2"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M327 516l48 22"
          />
          <path
            id="Building_Lines_-_Roof_Line1"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M229 506h77l19 8"
          />
          <path
            id="FRONT:_1Builind_Horizonal_Lines_1_"
            fill="#FCFCFC"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M208 577h71c2 0 3 1 3 3s-1 3-3 3H174c-2 0-3-1-3-3s1-3 3-3h30"
          />
          <path
            id="SIDE:_Vertical_Line"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M375 663V538"
          />
          <path
            id="Chimny"
            fill="#FCFCFC"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M290 521l-8-4v-21h8z"
          />
          <path
            id="Roof_Arch"
            fill="#FFF"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M282 533l-53-27h-7l-52 28c-2 1-2 2-1 4 0 1 2 2 4 1l53-28 53 27c2 1 3 0 4-1s1-3-1-4z"
          />
        </g>
        <g id="ROW_1_1_">
          <path
            id="Door"
            fill="#ECECEC"
            stroke="#020202"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M211 662l-1 1h-12l-1-1v-21l1-1h12l1 1v21z"
          />
          <g id="Door_2">
            <path
              id="Door_1_"
              fill="#ECECEC"
              d="M255 662l-1 1h-13l-1-1v-21l1-1h13l1 1v21z"
            />
            <g
              id="Door_Dashed"
              fill="none"
              stroke="#020202"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path d="M240 648v-1M240 644v-3l1-1h13l1 1v21l-1 1h-13l-1-1v-11" />
            </g>
          </g>
        </g>
        <g id="ROW_2_1_">
          <g id="Row2:_Window_Pink">
            <path
              id="Wind:_Glass_1_"
              fill="#ECECEC"
              stroke="#020202"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M195 612h-14v-22l1-1h12l1 1v22z"
            />
            <g
              id="Wind:_AirVent_1_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path d="M195 608h-6M185 608h-4" />
            </g>
            <path
              id="Wind:Bench"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M198 612h-21"
            />
            <path
              id="PINK_-_70_x25_"
              fill="#f7f755"
              d="M198 612h-2v-22l-2-1h-13l-1 1v22h-3-1l1 1h21l1-1h-1z"
            />
          </g>
          <g
            id="Row2:_Wind"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path id="Wind:_Bench" fill="none" stroke="#000" d="M224 612h-21" />
            <path
              id="Wind:_Glass"
              fill="#ECECEC"
              stroke="#020202"
              d="M221 607h-15v-17l1-1h13l1 1v17z"
            />
            <path
              id="Wind:_AirVent"
              fill="none"
              stroke="#020202"
              d="M206 607h15v4l-1 1h-13l-1-1v-4z"
            />
          </g>
          <g
            id="Row2:_Wind_Long"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              id="Wind:_Bench_1_"
              fill="none"
              stroke="#000"
              d="M273 612h-43"
            />
            <path
              id="Wind:_Glass_2_"
              fill="#ECECEC"
              stroke="#020202"
              d="M272 607h-40v-17l1-1h38l1 1v17z"
            />
            <path
              id="Wind:_AirVent_2_"
              fill="none"
              stroke="#020202"
              d="M232 607h40v4l-1 1h-38l-1-1v-4z"
            />
          </g>
        </g>
        <g id="ROW_3_1_">
          <g
            id="Row3:_Wind"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              id="Wind:_Glass_3_"
              fill="#ECECEC"
              stroke="#020202"
              d="M195 565l-1 1h-12l-1-1v-20l1-1h12l1 1v20z"
            />
            <path
              id="Wind:_Bench_2_"
              fill="none"
              stroke="#000"
              d="M198 567h-21"
            />
            <g id="Wind:Frame" fill="none" stroke="#020202">
              <path d="M181 554h14M188 554v12" />
            </g>
          </g>
          <g id="Row3:_Wind_Pink">
            <path
              id="Wind:_Glass_4_"
              fill="#ECECEC"
              stroke="#020202"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M221 565l-1 1h-13l-1-1v-20l1-1h13l1 1v20z"
            />
            <path
              id="Wind:_Bench_3_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M224 567h-21"
            />
            <g
              id="Wind:Frame_1_"
              fill="none"
              stroke="#020202"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path d="M206 554h15M214 554v12" />
            </g>
            <path
              id="Row3:_Pink_-_70_x25_"
              fill="#f7f755"
              d="M224 566h-2v-21l-2-2h-13l-2 2v21h-2l-1 1 1 1h21l1-1-1-1z"
            />
          </g>
          <g
            id="Row3:_Wind_2_"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              id="Wind:_Glass_5_"
              fill="#ECECEC"
              stroke="#020202"
              d="M248 565l-1 1h-13l-1-1v-20l1-1h13l1 1v20z"
            />
            <path
              id="Wind:_Bench_4_"
              fill="none"
              stroke="#000"
              d="M251 567h-21"
            />
            <g id="Wind:Frame_2_" fill="none" stroke="#020202">
              <path d="M233 554h15M240 554v12" />
            </g>
          </g>
          <g
            id="Row3:_Wind_3_"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              id="Wind:_Glass_6_"
              fill="#ECECEC"
              stroke="#020202"
              d="M273 565l-1 1h-13l-1-1v-20l1-1h13l1 1v20z"
            />
            <path
              id="Wind:_Bench_5_"
              fill="none"
              stroke="#000"
              d="M276 567h-21"
            />
            <g id="Wind:Frame_3_" fill="none" stroke="#020202">
              <path d="M258 554h15M265 554v12" />
            </g>
          </g>
        </g>
      </g>
      <g id="Beam_Back" className="shipy">
        <path
          id="Beam_2_2_"
          fill="#a855f7"
          d="M304 230l-83 560 309-12-195-552z"
          className="beams2"
        />
      </g>
      <g id="BUILDING_2">
        <g id="Building_Structure">
          <path id="Building_MainPlane" fill="#FFF" d="M336 474h118v189H336z" />
          <path
            id="_x32__-_Building_Side_Plane"
            fill="#ECECEC"
            d="M454 470h33v193h-33z"
          />
          <g
            id="BUILDING_LNES"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path id="_x32_Building_Horizontal_Line_1_" d="M365 604h122" />
            <path id="_x32_Building_Horizontal_Line" d="M336 604h23" />
            <path id="_x32_Building_Vertical_Line" d="M454 503v160" />
            <path id="_x32_Building_Vertical_Line_2_" d="M454 503v160" />
            <path id="_x32_Building_Vertical_Line_1_" d="M454 474v22" />
            <path id="_x32_Building_Vertical_Line_3_" d="M487 474v189" />
            <path id="_x32_Building_Vertical_Line_4_" d="M336 474v189" />
          </g>
          <g
            id="Horizontal_Middle"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              fill="#ECECEC"
              d="M494 557c0 2-1 4-4 4H367c-2 0-4-2-4-4s2-4 4-4h123c3 0 4 2 4 4z"
            />
            <path
              fill="#FCFCFC"
              d="M461 557c0 2-2 4-4 4H334c-2 0-4-2-4-4s2-4 4-4h123c2 0 4 2 4 4z"
            />
          </g>
          <g
            id="Horizontal_Top"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              fill="#ECECEC"
              d="M494 470c0 2-1 4-4 4H367c-2 0-4-2-4-4s2-4 4-4h123c3 0 4 2 4 4z"
            />
            <path
              fill="#FCFCFC"
              d="M461 470c0 2-2 4-4 4H334c-2 0-4-2-4-4s2-4 4-4h123c2 0 4 2 4 4z"
            />
          </g>
          <g
            id="Horizontal_Top_Top"
            fill="#FCFCFC"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path d="M498 464c0 2-1 3-3 3H363c-2 0-3-1-3-3 0-1 1-2 3-2h132c2 0 3 1 3 2z" />
            <path
              strokeLinecap="round"
              d="M398 462h63l3 2c0 2-2 3-3 3H328c-2 0-3-1-3-3 0-1 1-2 3-2h65"
            />
          </g>
        </g>
        <g id="ROW_4" stroke="#000" strokeMiterlimit="10" strokeWidth="2">
          <g id="Row4:_Window_2_">
            <path
              id="Wind:_Bench_18_"
              fill="none"
              d="M372 506l-2 2h-24l-2-2 2-2h24l2 2z"
            />
            <path
              id="Wind:_Glass_17_"
              fill="#ECECEC"
              d="M368 497h-20v-13l1-1h17l2 1v13z"
            />
            <path
              id="Wind:_Air_Vent_9_"
              fill="none"
              d="M348 497h20v6l-1 1h-18l-1-1v-6z"
            />
          </g>
          <g id="Row4:_Window_1_">
            <path
              id="Wind:_Bench_17_"
              fill="none"
              d="M408 506l-2 2h-23l-2-2 2-2h23l2 2z"
            />
            <path
              id="Wind:_Glass_16_"
              fill="#ECECEC"
              d="M404 497h-19v-13l1-1h17l1 1v13z"
            />
            <path
              id="Wind:_Air_Vent_8_"
              fill="none"
              d="M385 497h19v6l-1 1h-17l-1-1v-6z"
            />
          </g>
          <g id="Row4:_Window">
            <path
              id="Wind:_Bench_14_"
              fill="none"
              strokeLinecap="round"
              d="M418 508l-2-2 2-2h24l2 2-2 2h-24z"
            />
            <path
              id="Wind:_Glass_15_"
              fill="#ECECEC"
              d="M440 495h-20v-10l1-1h17l2 1v10z"
            />
            <path
              id="Wind:_Air_Vent_7_"
              fill="none"
              d="M420 495h20v8l-1 1h-18l-1-1v-8z"
            />
          </g>
        </g>
        <g id="ROW_3" stroke="#000" strokeMiterlimit="10" strokeWidth="2">
          <g id="Row3:_Window">
            <path
              id="Wind:_Bench_9_"
              fill="none"
              d="M372 543l-2 2h-24l-2-2 2-2h24l2 2z"
            />
            <path
              id="Wind:_Glass_9_"
              fill="#ECECEC"
              d="M368 535h-20v-13l1-1h17l2 1v13z"
            />
            <path
              id="Wind:_Air_Vent_2_"
              fill="none"
              d="M348 535h20v5l-1 1h-18l-1-1v-5z"
            />
          </g>
          <g id="Row3:_Window_1_">
            <path
              id="Wind:_Bench_12_"
              fill="none"
              d="M408 543l-2 2h-23l-2-2 2-2h23l2 2z"
            />
            <path
              id="Wind:_Glass_13_"
              fill="#ECECEC"
              d="M404 527h-19v-5l1-1h17l1 1v5z"
            />
            <path
              id="Wind:_Air_Vent_5_"
              fill="none"
              d="M385 527h19v13l-1 1h-17l-1-1v-13z"
            />
          </g>
          <g id="Row3:_Window_2_">
            <path
              id="Wind:_Bench_15_"
              fill="none"
              strokeLinecap="round"
              d="M436 545h-2"
            />
            <path
              id="Wind:_Bench_13_"
              fill="none"
              strokeLinecap="round"
              d="M432 545h-14l-2-2 2-2h24l2 2-2 2h-4"
            />
            <path
              id="Wind:_Glass_14_"
              fill="#ECECEC"
              d="M440 535h-20v-13l1-1h17l2 1v13z"
            />
            <path
              id="Wind:_Air_Vent_6_"
              fill="none"
              d="M420 535h20v5l-1 1h-18l-1-1v-5z"
            />
          </g>
        </g>
        <g id="ROW_2">
          <g
            id="Row2:_Window"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              id="Wind:_Bench_10_"
              fill="none"
              d="M409 592l-2 2h-24l-2-2 2-2h24l2 2z"
            />
            <path
              id="Wind:_Glass_11_"
              fill="#ECECEC"
              d="M405 583h-20v-14l1-1h17l2 1v14z"
            />
            <path
              id="Wind:_Air_Vent_3_"
              fill="none"
              d="M385 583h19v7h-18l-1-1v-6z"
            />
          </g>
          <g
            id="Row2:_Window_1_"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path
              id="Wind:_Bench_11_"
              fill="none"
              d="M444 592l-2 2h-24l-2-2 2-2h24l2 2z"
            />
            <path
              id="Wind:_Glass_12_"
              fill="#ECECEC"
              d="M440 583h-20v-14l1-1h17l2 1v14z"
            />
            <path
              id="Wind:_Air_Vent_4_"
              fill="none"
              d="M420 583h20v6l-1 1h-18l-1-1v-6z"
            />
          </g>
          <g id="Row2:_Window_Pink_1_">
            <path
              id="Wind:_Bench_8_"
              fill="none"
              stroke="#000"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M371 592l-2 2h-22l-2-2 2-2h22l2 2z"
            />
            <path
              id="Wind:_AirVent_3_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M348 584h15"
            />
            <path
              id="Wind:_Glass_10_"
              fill="none"
              stroke="#000"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M366 568h-17l-1 1v19l1 2h17l1-1v-20l-1-1z"
            />
            <path
              id="Wind:_Pink_-_70_x25_"
              fill="#f7f755"
              d="M369 589h-1v-20l-2-1h-18l-1 1v20c-2 0-3 1-3 3 0 1 1 3 3 3h22l2-3c1-2-1-3-2-3zm0 4h-22l-1-1 1-2h22l1 2-1 1z"
            />
          </g>
        </g>
        <g id="ROW_1" stroke="#000" strokeMiterlimit="10" strokeWidth="2">
          <g id="FRONT_DOOR">
            <g id="Front_Door">
              <path
                fill="none"
                d="M409 617l-2 1h-28c-1 1-1 0-1-1l1-2h28l2 2z"
              />
              <path fill="#ECECEC" d="M381 619h25v36h-25z" />
              <path fill="none" d="M393 619v36" />
            </g>
            <g id="STAIRS">
              <g id="Stairs" fill="none">
                <path d="M411 657l-2 2h-36l-2-2 2-2h36l2 2zM399 656v3" />
              </g>
              <g id="Stairs_1_">
                <path fill="#ECECEC" d="M411 661l-2 1h-39l-2-1 2-2h41v2z" />
                <path fill="none" d="M397 659v3" />
              </g>
            </g>
          </g>
          <g id="Row1:_Wind">
            <path
              id="Wind:_Bench_7_"
              fill="none"
              d="M443 647l-2 2h-24l-2-2 2-2h24l2 2z"
            />
            <path
              id="Wind:_Glass_8_"
              fill="#ECECEC"
              d="M439 622h-19v-5l1-1h17l1 1v5z"
            />
            <path
              id="Wind:_Air_Vent_1_"
              fill="none"
              d="M420 622h19v22l-1 1h-17l-1-1v-22z"
            />
          </g>
          <g id="Row1:_Window">
            <path
              id="Wind:_Bench_6_"
              fill="none"
              d="M371 647l-2 2h-24l-2-2 2-2h24l2 2z"
            />
            <path
              id="Wind:_Glass_7_"
              fill="#ECECEC"
              d="M367 638h-19v-21l1-1h17l1 1v21z"
            />
            <path
              id="Wind:_Air_Vent"
              fill="none"
              d="M348 638h19v6l-1 1h-17l-1-1v-6z"
            />
          </g>
        </g>
      </g>
      <g id="SpaceShip__x2B__BeamFront" className="shipy">
        <path
          id="Beam_Front"
          fill="#7234ad"
          d="M551 743L335 224l-30 4 88 515z"
          className="beams"
        />
        <g id="Spaceahip" className="ufo">
          <g id="Light">
            <path
              id="Light_Line"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M309 177l2-5c2 0 3 2 4 4l-6 1z"
            />
            <path
              id="Light_Flash_70_x25_"
              fill="#f7f755"
              d="M308 178v-1l1-4 2-2c2 0 4 2 4 5v1l-7 1z"
            />
          </g>
          <g id="Dome">
            <g id="Underneath">
              <path
                id="Underneath_Bar_White"
                fill="#FFF"
                d="M273 219s2-5 7-5l73-11c2 0 7-1 9 4l-51 6-38 6z"
              />
              <path
                id="Underneath_Bar_1_"
                fill="none"
                stroke="#000"
                strokeLinecap="round"
                strokeMiterlimit="10"
                strokeWidth="2"
                d="M273 219s2-5 7-5l73-11c2 0 7-1 9 4"
              />
            </g>
            <path
              id="Dome_Shadow"
              fill="#E2E2E2"
              d="M320 177c-23 0-38 15-38 34v2l9-1s3-10 10-19c9-11 19-16 19-16z"
            />
            <path
              id="Dome_Line_2_"
              fill="#FFF"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M282 213v-2a35 35 0 0 1 69-8l-69 10z"
            />
            <g
              id="Dome_Shine_Line"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path d="M288 200c4-8 11-15 19-18M287 204v-2" />
            </g>
          </g>
          <g id="Saucer_1_">
            <path
              id="Saucer_Line_2_"
              fill="#FCFCFC"
              d="M284 217c-27 5-45 9-44 15 0 5 36 3 79-4s79-13 78-20c-1-4-38-3-81 4l-28 4"
            />
            <path
              id="Saucer_Shadow"
              fill="#E2E2E2"
              d="M397 208c-5-3-37 5-78 12-42 6-79 8-79 12s39 2 80-4c41-7 82-16 77-20z"
            />
            <path
              id="Saucer_Line_1_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M284 217c-27 5-45 9-44 15 0 5 36 3 79-4s79-13 78-20c-1-4-38-3-81 4l-28 4"
            />
          </g>
          <g className="winscale">
            <g id="Window">
              <path
                id="Window_Shadow"
                fill="#E2E2E2"
                d="M293 203c0 1 1 2 2 1h6l2-2-1-3-2-2-6 1c-1 0-2 1-1 2v3z"
              />
              <path
                id="Window_Frame"
                fill="none"
                stroke="#000"
                strokeLinecap="round"
                strokeMiterlimit="10"
                strokeWidth="2"
                d="M291 205c1 2 2 3 4 2l12-2c2 0 3-1 3-3l-1-5c0-2-2-3-4-3l-11 2c-2 0-4 2-4 4l1 5z"
              />
            </g>
          </g>
        </g>
      </g>
      <g id="BACK_EXTRAS">
        <path
          id="MOON"
          fill="#FFFDFD"
          stroke="#000"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
          d="M636 174l2 9a21 21 0 0 1-30 18 21 21 0 0 0 39-9c0-8-5-15-11-18z"
          className="themoon"
        />
        <g
          id="LADDER"
          fill="none"
          stroke="#000"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <path d="M465 608l33 54M475 608l33 55M478 613h-10M481 619h-10M485 625h-10M488 630h-10M492 636h-10M495 642h-10M499 648h-10M502 653h-10M505 659h-9" />
        </g>
      </g>
      <g id="BUILDING_3">
        <g id="_x33__-_BUILDING_STUCTURE">
          <path
            id="_x33_-Builing_MainPlane"
            fill="#FCFCFC"
            d="M505 277h120v385H505z"
          />
          <path
            id="_x33_-Builing_MainPlane_1_"
            fill="#ECECEC"
            d="M624 277h50v385h-50z"
          />
          <g
            id="_x33_-Building_Structure_Lines"
            fill="none"
            stroke="#020202"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path d="M505 663V277M624 663V277M674 411V277M674 419v-3M674 663V422" />
          </g>
          <g
            id="_x3C_3-Builing_-_HorizonralsTop_x3E__1_"
            fill="#FCFCFC"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path d="M678 275c0 1-1 2-3 2h-51v-5h51c2 0 3 1 3 3z" />
            <path d="M628 275l-2 2H504c-2 0-3-1-3-2 0-2 1-3 3-3h122c1 0 2 1 2 3z" />
          </g>
          <g
            id="_x3C_3-Builing_-_HorizonralsBottom_x3E_"
            fill="#FCFCFC"
            stroke="#000"
            strokeMiterlimit="10"
            strokeWidth="2"
          >
            <path d="M678 592c0 2-1 3-3 3h-51v-5h51c2 0 3 1 3 2z" />
            <path
              strokeLinecap="round"
              d="M527 595h-23c-2 0-3-1-3-3 0-1 1-2 3-2h122l2 2h1c0 2-2 3-3 3h-92"
            />
          </g>
        </g>
        <g
          id="Row1_BOTTOM_-_SqaureWindows"
          fill="#ECECEC"
          stroke="#000"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <path
            id="Row1:_WindowSqaure"
            d="M542 661l-1 1h-27l-1-1v-24l1-1h27l1 1v24z"
          />
          <path
            id="Row1:_WindowSqaure_1_"
            d="M580 661l-1 1h-27l-1-1v-24l1-1h27l1 1v24z"
          />
          <path
            id="Row1:_WindowSqaure_2_"
            d="M618 661l-1 1h-27l-1-1v-24l1-1h27l1 1v24z"
          />
        </g>
        <g
          id="Row1_TOP_-_SpanishWindows"
          stroke="#000"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <g id="_x3C_SpanishWindows_x3E__1_">
            <path fill="#ECECEC" d="M544 625v-14c0-2 2-7 8-7s7 5 7 7v14h-15z" />
            <path
              fill="none"
              strokeLinecap="round"
              d="M562 625h-21M560 614h-16"
            />
          </g>
          <g id="_x3C_SpanishWindows_x3E__2_">
            <path fill="#ECECEC" d="M572 625v-14c0-2 2-7 8-7s8 5 8 7v14h-16z" />
            <path
              fill="none"
              strokeLinecap="round"
              d="M590 625h-20M588 614h-16"
            />
          </g>
          <g id="_x3C_SpanishWindows_x3E__3_">
            <path fill="#ECECEC" d="M601 625v-14c0-2 1-7 7-7s8 5 8 7v14h-15z" />
            <path
              fill="none"
              strokeLinecap="round"
              d="M618 625h-20M616 614h-15"
            />
          </g>
          <g id="_x3C_SpanishWindows_x3E_">
            <path
              fill="#ECECEC"
              d="M516 625v-14c0-2 1-7 7-7 7 0 8 5 8 7v14h-15z"
            />
            <path
              fill="none"
              strokeLinecap="round"
              d="M533 625h-20M531 614h-15"
            />
          </g>
        </g>
        <g
          id="Row2_-_SpanishWindows_-_Long"
          fill="#ECECEC"
          stroke="#000"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <path
            id="_x3C_SpanishWindows_-_Long_x3E__1_"
            d="M516 579v-58c0-2 1-8 8-8s9 6 9 8v58h-17z"
          />
          <path
            id="_x3C_SpanishWindows_-_Long_x3E__2_"
            d="M544 579v-58c0-2 1-8 8-8s9 6 9 8v58h-17z"
          />
          <path
            id="_x3C_SpanishWindows_-_Long_x3E__3_"
            d="M572 579v-58c0-2 2-8 8-8 7 0 9 6 9 8v58h-17z"
          />
          <path
            id="_x3C_SpanishWindows_-_Long_x3E__4_"
            d="M600 579v-58c0-2 2-8 8-8 7 0 9 6 9 8v58h-17z"
          />
        </g>
        <g id="Row_3">
          <g id="Row3:_Window_3_">
            <path
              id="Row3_Wind:_Bench"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 505h19"
            />
            <g
              id="Row3_Wind:_Glass_1_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass"
                fill="#ECECEC"
                d="M532 504l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame" fill="none" d="M531 496h-14" />
            </g>
          </g>
          <g id="Row3:_Window_4_">
            <path
              id="Row3_Wind:_Bench_1_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 505h19"
            />
            <g
              id="Row3_Wind:_Glass_2_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_3_"
                fill="#ECECEC"
                d="M560 504l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_1_" fill="none" d="M559 496h-14" />
            </g>
          </g>
          <g id="Row3:_Window_5_">
            <path
              id="Row3_Wind:_Bench_2_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 505h19"
            />
            <g
              id="Row3_Wind:_Glass_4_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_5_"
                fill="#ECECEC"
                d="M588 504l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_2_" fill="none" d="M588 496h-15" />
            </g>
          </g>
          <g id="Row3:_Window_PINK">
            <path
              id="Row3_Wind:_Bench_3_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 505h19"
            />
            <g
              id="Row3_Wind:_Glass_6_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_7_"
                fill="#ECECEC"
                d="M616 504l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_3_" fill="none" d="M616 496h-15" />
            </g>
            <path
              id="Row3_Wind:_Glass_70_x25_"
              fill="#f7f755"
              d="M618 504h-1v-16l-2-2h-13l-2 2v16h-2v1l1 1h19l1-1-1-1z"
            />
          </g>
        </g>
        <g id="Row_4">
          <g id="Row3:_Window_8_">
            <path
              id="Row3_Wind:_Bench_7_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 476h19"
            />
            <g
              id="Row3_Wind:_Glass_14_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_15_"
                fill="#ECECEC"
                d="M532 475l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_7_" fill="none" d="M531 467h-14" />
            </g>
          </g>
          <g id="Row3:_Window_7_">
            <path
              id="Row3_Wind:_Bench_6_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 476h19"
            />
            <g
              id="Row3_Wind:_Glass_12_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_13_"
                fill="#ECECEC"
                d="M560 475l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_6_" fill="none" d="M559 467h-14" />
            </g>
          </g>
          <g id="Row3:_Window_6_">
            <path
              id="Row3_Wind:_Bench_5_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 476h19"
            />
            <g
              id="Row3_Wind:_Glass_10_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_11_"
                fill="#ECECEC"
                d="M588 475l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_5_" fill="none" d="M588 467h-15" />
            </g>
          </g>
          <g id="Row3:_Window_9_">
            <path
              id="Row3_Wind:_Bench_4_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 476h19"
            />
            <g
              id="Row3_Wind:_Glass_8_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_9_"
                fill="#ECECEC"
                d="M616 475l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_4_" fill="none" d="M616 467h-15" />
            </g>
          </g>
        </g>
        <g id="Row_5">
          <g id="Row3:_Window_13_">
            <path
              id="Row3_Wind:_Bench_11_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 448h19"
            />
            <g
              id="Row3_Wind:_Glass_22_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_23_"
                fill="#ECECEC"
                d="M532 447l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_11_" fill="none" d="M531 439h-14" />
            </g>
          </g>
          <g id="Row3:_Window_12_">
            <path
              id="Row3_Wind:_Bench_10_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 448h19"
            />
            <g
              id="Row3_Wind:_Glass_20_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_21_"
                fill="#ECECEC"
                d="M560 447l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_10_" fill="none" d="M559 439h-14" />
            </g>
          </g>
          <g id="Row3:_Window_11_">
            <path
              id="Row3_Wind:_Bench_9_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 448h19"
            />
            <g
              id="Row3_Wind:_Glass_18_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_19_"
                fill="#ECECEC"
                d="M588 447l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_9_" fill="none" d="M588 439h-15" />
            </g>
          </g>
          <g id="Row3:_Window_10_">
            <path
              id="Row3_Wind:_Bench_8_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 448h19"
            />
            <g
              id="Row3_Wind:_Glass_16_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_17_"
                fill="#ECECEC"
                d="M616 447l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_8_" fill="none" d="M616 439h-15" />
            </g>
          </g>
        </g>
        <g id="Row_6">
          <g id="Row3:_Window_17_">
            <path
              id="Row3_Wind:_Bench_15_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 419h19"
            />
            <g
              id="Row3_Wind:_Glass_30_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_31_"
                fill="#ECECEC"
                d="M532 418l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_15_" fill="none" d="M531 410h-14" />
            </g>
          </g>
          <g id="Row3:_Window_16_">
            <path
              id="Row3_Wind:_Bench_14_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 419h19"
            />
            <g
              id="Row3_Wind:_Glass_28_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_29_"
                fill="#ECECEC"
                d="M560 418l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_14_" fill="none" d="M559 410h-14" />
            </g>
          </g>
          <g id="Row3:_Window_15_">
            <path
              id="Row3_Wind:_Bench_13_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 419h19"
            />
            <g
              id="Row3_Wind:_Glass_26_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_27_"
                fill="#ECECEC"
                d="M588 418l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_13_" fill="none" d="M588 410h-15" />
            </g>
          </g>
          <g id="Row3:_Window_14_">
            <path
              id="Row3_Wind:_Bench_12_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 419h19"
            />
            <g
              id="Row3_Wind:_Glass_24_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_25_"
                fill="#ECECEC"
                d="M616 418l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_12_" fill="none" d="M616 410h-15" />
            </g>
          </g>
        </g>
        <g id="Row_7">
          <g id="Row7:_Window_2_">
            <path
              id="Row3_Wind:_Bench_27_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 391h19"
            />
            <g
              id="Row3_Wind:_Glass_54_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_55_"
                fill="#ECECEC"
                d="M532 390l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_27_" fill="none" d="M531 382h-14" />
            </g>
          </g>
          <g id="Row7:_Window_1_">
            <path
              id="Row3_Wind:_Bench_26_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 391h19"
            />
            <g
              id="Row3_Wind:_Glass_52_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_53_"
                fill="#ECECEC"
                d="M560 390l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_26_" fill="none" d="M559 382h-14" />
            </g>
          </g>
          <g id="Row7:_Window_PINK">
            <path
              id="Row3_Wind:_Bench_25_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 391h19"
            />
            <g
              id="Row3_Wind:_Glass_50_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_51_"
                fill="#ECECEC"
                d="M588 390l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_25_" fill="none" d="M588 382h-15" />
            </g>
            <path
              id="Row3_Wind:_Glass_70_x25__1_"
              fill="#f7f755"
              d="M590 391h-1v-17l-2-2h-13l-2 2v16h-2v1l1 1h19l1-1h-1z"
            />
          </g>
          <g id="Row7:_Window">
            <path
              id="Row3_Wind:_Bench_24_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 391h19"
            />
            <g
              id="Row3_Wind:_Glass_48_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_49_"
                fill="#ECECEC"
                d="M616 390l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_24_" fill="none" d="M616 382h-15" />
            </g>
          </g>
        </g>
        <g id="Row_8">
          <g id="Row8:_Window_2_">
            <path
              id="Row3_Wind:_Bench_31_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 363h19"
            />
            <g
              id="Row3_Wind:_Glass_62_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_63_"
                fill="#ECECEC"
                d="M532 362l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_31_" fill="none" d="M531 354h-14" />
            </g>
          </g>
          <g id="Row8:_Window_PINK_1_">
            <path
              id="Row3_Wind:_Bench_30_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 363h19"
            />
            <g
              id="Row3_Wind:_Glass_60_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_61_"
                fill="#ECECEC"
                d="M560 362l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_30_" fill="none" d="M559 354h-14" />
            </g>
            <path
              id="Row3_Wind:_Glass_70_x25__2_"
              fill="#f7f755"
              d="M562 363h-1v-17l-2-2h-13l-2 2v16h-2v2h20v-1c0-1 0 0 0 0z"
            />
          </g>
          <g id="Row8:_Window_1_">
            <path
              id="Row3_Wind:_Bench_29_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 363h19"
            />
            <g
              id="Row3_Wind:_Glass_58_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_59_"
                fill="#ECECEC"
                d="M588 362l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_29_" fill="none" d="M588 354h-15" />
            </g>
          </g>
          <g id="Row8:_Window">
            <path
              id="Row3_Wind:_Bench_28_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 363h19"
            />
            <g
              id="Row3_Wind:_Glass_56_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_57_"
                fill="#ECECEC"
                d="M616 362l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_28_" fill="none" d="M616 354h-15" />
            </g>
          </g>
        </g>
        <g id="Row_9">
          <g id="Row3:_Window_21_">
            <path
              id="Row3_Wind:_Bench_19_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 334h19"
            />
            <g
              id="Row3_Wind:_Glass_38_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_39_"
                fill="#ECECEC"
                d="M532 333l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_19_" fill="none" d="M531 325h-14" />
            </g>
          </g>
          <g id="Row3:_Window_20_">
            <path
              id="Row3_Wind:_Bench_18_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 334h19"
            />
            <g
              id="Row3_Wind:_Glass_36_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_37_"
                fill="#ECECEC"
                d="M560 333l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_18_" fill="none" d="M559 325h-14" />
            </g>
          </g>
          <g id="Row3:_Window_19_">
            <path
              id="Row3_Wind:_Bench_17_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 334h19"
            />
            <g
              id="Row3_Wind:_Glass_34_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_35_"
                fill="#ECECEC"
                d="M588 333l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_17_" fill="none" d="M588 325h-15" />
            </g>
          </g>
          <g id="Row3:_Window_18_">
            <path
              id="Row3_Wind:_Bench_16_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 334h19"
            />
            <g
              id="Row3_Wind:_Glass_32_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_33_"
                fill="#ECECEC"
                d="M616 333l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_16_" fill="none" d="M616 325h-15" />
            </g>
          </g>
        </g>
        <g id="Row_10">
          <g id="Row3:_Window_25_">
            <path
              id="Row3_Wind:_Bench_23_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M515 306h19"
            />
            <path
              id="Row3_Wind:_Glass_Gray"
              fill="#ECECEC"
              d="M532 305l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
            />
            <g
              id="Row3_Wind:_Glass_46_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_64_"
                d="M517 297v-8l1-1h13l1 1v16l-1 1h-13l-1-1v-4"
              />
              <path id="Row3_Wind:_Frame_23_" d="M531 297h-14" />
            </g>
          </g>
          <g id="Row3:_Window_24_">
            <path
              id="Row3_Wind:_Bench_22_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M543 306h19"
            />
            <g
              id="Row3_Wind:_Glass_44_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_45_"
                fill="#ECECEC"
                d="M560 305l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_22_" fill="none" d="M559 297h-14" />
            </g>
          </g>
          <g id="Row3:_Window_23_">
            <path
              id="Row3_Wind:_Bench_21_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M571 306h19"
            />
            <g
              id="Row3_Wind:_Glass_42_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_43_"
                fill="#ECECEC"
                d="M588 305l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_21_" fill="none" d="M588 297h-15" />
            </g>
          </g>
          <g id="Row3:_Window_22_">
            <path
              id="Row3_Wind:_Bench_20_"
              fill="none"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
              d="M599 306h19"
            />
            <g
              id="Row3_Wind:_Glass_40_"
              stroke="#000"
              strokeLinecap="round"
              strokeMiterlimit="10"
              strokeWidth="2"
            >
              <path
                id="Row3_Wind:_Glass_41_"
                fill="#ECECEC"
                d="M616 305l-1 1h-13l-1-1v-16l1-1h13l1 1v16z"
              />
              <path id="Row3_Wind:_Frame_20_" fill="none" d="M616 297h-15" />
            </g>
          </g>
        </g>
      </g>
      <g id="FRONT_EXTRAS">
        <g id="BUSH_-_Right">
          <path
            id="_x3C_BushShape_x3E_"
            fill="#FFF"
            d="M671 663s1-21-18-21l-8 1c-1 0-4-3-9-3l-7 2c-3-2-7-4-13-4-15 1-22 16-22 25h77z"
          />
          <path
            id="_x3C_BushLine_x3E_"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M671 663s1-21-18-21c-13 0-17 8-17 8"
          />
          <path
            id="_x3C_BushLine_x3E__1_"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M638 654s-6-16-22-16-22 16-22 25"
          />
          <path
            id="_x3C_BushLine_x3E__2_"
            fill="none"
            stroke="#000"
            strokeLinecap="round"
            strokeMiterlimit="10"
            strokeWidth="2"
            d="M645 644s-3-4-9-4c-4 0-7 2-7 2"
          />
        </g>
        <g
          id="TREE_-_Sharp"
          stroke="#000"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <path
            id="_x3C_TreeShape_x3E_"
            fill="#FFFDFD"
            d="M683 639c3 0 18-1 18-18 0-22-14-38-18-38s-17 16-17 38c0 17 15 18 17 18z"
          />
          <path fill="none" d="M681 589s-7 8-8 19M683 627v36" />
        </g>
        <g
          id="TREE_-_Round"
          stroke="#000"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <circle cx="174" cy="622" r="18" fill="#FFF" />
          <path fill="#FFF" d="M161 622c1-7 7-13 14-14M168 625l6 5 5-4" />
          <path fill="none" d="M174 662v-32" />
        </g>
        <g
          id="BUSH_-_Left"
          fill="none"
          stroke="#000"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <path d="M115 663c0-15 11-25 24-25 7 0 14 4 18 10M123 650c3-4 8-7 14-8M152 654v1" />
          <path d="M183 663c0-11-7-18-16-18-6 0-11 3-14 7" />
        </g>
        <g
          id="FLOOR_LINE"
          fill="none"
          stroke="#000"
          strokeLinecap="round"
          strokeMiterlimit="10"
          strokeWidth="2"
        >
          <path d="M91 663h-2M103 663h-7M732 663H106M743 663h-7" />
        </g>
      </g>
      <path fill="#766b80" d="M36 664h780v300H36z" />
    </svg>
  </div>
)
export default AlienInvasion
