import { generateAboutUsSection } from './about-us'
import { generateContactUsSection } from './contact-us'
import { generateFeaturesSection } from './features'
import { generateFooter } from './footer'
import { generateNavbar } from './navbar'
import { generateHeroSection } from './hero'
import { generateTestimonialSection } from './testimonial'
import {SiteContent} from '@/old.types/site' 

export async function generateHTML(props: SiteContent, bucketName: string, hasSSL: boolean) {
  
  const {
    colors,
    title,
    navbarItems = [],
    heroTitle,
    heroContent,
    featureSectionTagline,
    featureSectionTitle,
    featureSectionContent,
    features = [],
    aboutUsTitle,
    aboutUsContent,
    testimonial,
    contactUsTitle,
    contactUsContent,
    contactUsPhone = '',
    contactUsEmail = '',
    contactUsAddress = '',
    copywrite,
    featureImageURL,
    aboutUsImageURL,
    testimonialImageURL,
    metaDescription,
    metaAuthor
  } = props

  let cssUrl
  let websiteUrl

  //const navbarHTML = generateNavbar({title, navbarItems, colors});

  const heroHTML = generateHeroSection({
    title,
    heroTitle,
    heroContent,
    colors,
  })

  const featuresHTML = generateFeaturesSection({
    featureSectionTagline,
    featureSectionTitle,
    featureSectionContent,
    featureImageURL,
    features,
    colors,
  })

  const aboutUsHTML = generateAboutUsSection({
    title: aboutUsTitle,
    paragraph: aboutUsContent,
    colors,
    aboutUsImageURL,
  })

  const testimonialsHTML = generateTestimonialSection({
    testimonialImageURL,
    testimonial,
    colors,
  })

  const contactUsHTML = generateContactUsSection({ 
    colors,
    contactUsTitle,
    contactUsContent,
    contactUsPhone,
    contactUsEmail,
    contactUsAddress
  })

  const footerHTML = generateFooter({ copywrite, colors })

  const timestamp = Date.now()
  if(hasSSL){
    cssUrl = `https://${bucketName}/style.css?${timestamp}`;
    websiteUrl = `https://${bucketName}`
  } else {
    cssUrl = `http://${bucketName}.s3.${process.env.AWS_REGION}.amazonaws.com/style.css?${timestamp}`;
    websiteUrl = `http://${bucketName}.s3-website.${process.env.AWS_REGION}.amazonaws.com`
  }

  const html = `
      <!DOCTYPE html>
      <html lang="en">
        <head>
          <meta charset="UTF-8">
          <meta name="viewport" content="width=device-width, initial-scale=1.0">
          <meta name="description" content="${metaDescription || 'Generated by alien technology at https://buildasite.ai! Visit us to create your own free website today!'}">
          <meta name="author" content="${metaAuthor || 'buildasite.ai'}">
          <meta property="og:title" content="${title}">
          <meta property="og:description" content="${metaDescription || 'Generated by alien technology at https://buildasite.ai! Visit us to create your own free website today!'}">
          <meta property="og:image" content="${aboutUsImageURL || ''}">
          <meta property="og:url" content="${websiteUrl || ''}">
          <meta property="og:type" content="website">
          <meta name="twitter:card" content="summary_large_image">
          <meta name="twitter:title" content="${title}">
          <meta name="twitter:description" content="${metaDescription || 'Generated by alien technology at https://buildasite.ai! Visit us to create your own free website today!'}">
          <meta name="twitter:image" content="${aboutUsImageURL || ''}">

          <title>${title}</title>
          <link href="${cssUrl}" rel="stylesheet">

        </head>
        <body>
          ${heroHTML}
          ${featuresHTML}
          ${aboutUsHTML}
          ${testimonialsHTML}
          ${contactUsHTML}
          ${footerHTML}
        </body>
      </html>
    `

  return { html }
}
