---
title: "Reality is Personal (Esther Meek)"
season: 4
date: "2022-08-25"
time: "43"
description: "What is the nature of reality? Esther Lightcap Meek warmly speaks of reality as interpersonal. We discuss hope as a person-ed affair, how life is a sort of scrabbling together of clues, gift economies, covenant epistemology, on commitment, consent, belonging. (Recorded in November 2021)"
episodeLink: "b317808d"
embedUrl: https://share.transistor.fm/e/3524fd4a
sidebar:
    order: 2
---

### Links

- [Esther's website](https://www.estherlightcapmeek.com)
- [A Little Manual for Knowing (book)](https://www.estherlightcapmeek.com/little-manual-lm.html)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-4/dorean.md)

#### Hope as a Person

[00:00] **Esther:** In our conversation just now, you were making the point that there's this irreducible.. I hate even to use the word, contribution of the person. Everything's interpersonally rooted.

[00:11] **Esther:** And that's what I think you're saying you experience. I mean, what you've read of Polanyi and Newbigin and you're saying, well, this is just what I do in my job, you know? So you're working with real people in a convivial sort of way in GitHub, right.

[00:31] **Esther:** And your _Hope in Source_ thing, that's your wonderful play on words. I mean, hope is a _personed _affair, right? And so you've rooted the open source in the person. So very cool. 

[00:48] **Henry:** Thank you for that. It's good to kind of hear what you think about even the title itself and thinking like, the point of it is to say well, the source code is written by a person, right. And of course, as a Christian, you might say that like our hope is in a person as well, so it's not just like piece of text. 

[01:05] **Henry:** I guess that's a really underlying point is that in my community of programmers, the people matter. It's like a stereotype to think that what matters is the code that you write? This is something I struggle with. 

[01:16] **Henry:** Thinking that my worth as a person or programmer, especially on like GitHub is how many lines of code that you wrote, right? And I guess in academia it could be like, how many papers or books you wrote. It's like very similar kind of measuring. And how do you kind of fight that?

#### Creative Subsidiary Scrambling

[01:33] **Esther:** I think what you've got going on in there is what I would say is _creative subsidiary scrabbling_. Which is what ensembles do together to invite a larger real. So it's very interpersonal. It's generous, it's creative, it's making. And because that's your job, you just feel naturally at home in that. And I don't think you feel alone. 

[02:00] **Esther:** And I think we all struggle with temptations to think, okay, am I keeping up or am I worth my salt.. But I don't think it's any different in your job than it is in mine and anybody else's, you know. We have to combat kind of that looking elsewhere and just kind of keep our own creativity in our own collaborative mutuality. It takes trust.

[02:26] **Henry:** Going into trust. Open source is interesting because like a church, you're asking people to serve or volunteer. There's a few things you're trusting. If you're the one using open source, you're trusting that the person that wrote their code didn't do something bad or maybe I guess there's bugs in it. But you're trusting that they're doing a good job. And then if you're asking someone to help, you're trusting that they have good faith too.

[02:50] **Henry:** I like I guess ideally that open source doesn't necessarily have to be about money. You're not paying someone to do it. They're just doing it because they want to.. Well, I mean, it could be a part of the job. And that's why we're basically living off of donations, but then it gets kind of tricky.. Well kind of the crux of it is that the billion dollar tech companies that we all know, maybe not love anymore, the Googles and the Facebooks, they're using this open source and they don't have to give back. I mean, that's kind of the whole point. And so sometimes there's this kind of feeling of should they give back

[03:25] **Esther:** So how do you think oughta happen about that?

[03:28] **Henry:** Yeah. I wonder.. Part of me is like, freely given, freely received. I think open source is a really interesting way of thinking about grace. The whole point is that they don't have to give back. At least if that's the reason why you're doing it. 

[03:42] **Henry:** But at the same time, people need to live, people need to survive. And then also, maybe you just feel uncomfortable with like, well, they're making billions of dollars and they don't even give..

[03:51] **Esther:** I have a problem with that. 

[03:52] **Henry:** Are they exploiting us? 

[03:54] **Esther:** Yeah. And maybe it's because I'm older than you. You know, I think younger people have a different, probably more healthy relatedness to money and recompense for their work, but you know, you also still have a sense of justice and injustice. And I think a large company, like that ought to be.. I think you should be reimbursed for your work.

#### The Gift

[04:21] **Esther:** Have you read.. I dunno how much you think about artistry or the arts.. So I'm writing a book on that right now with regard to my philosophy. And so I've been reading books by artists on art and kind of incorporating that into my proposals.

[04:40] **Esther:** But there's this one classic book, it's classic now, called _The Gift_. And it's by Louis Hyde. Have you heard of this book? 

[04:50] **Henry:** I haven't gotten a chance to read it. Happy to hear more about it. 

[04:53] **Esther:** It's quite the book, but it starts out with kind of a sociology of an economy of gift. And then it contrasts that with a market economy. And then the thesis of the book is that art belongs in a gift economy. Though he does very helpfully say, look, we all have to survive in a market economy.

[05:15] **Esther:** So somehow the artist has to find a way to navigate that. So what I'm thinking is listening to you, the book might be valuable. To say, what you actually prefer is the gift economy. That seems to go with the creativity of what you're doing, but you've gotta find a way to survive in the market.

[05:37] **Henry:** Yeah. My friend Maggie brought up the book, so I have to think back on it. I totally agree with that.

[05:44] **Esther:** Well, I wish you well on that because, I think there's just gotta be ways to skin the cat that cultivate the generosity and the conviviality of a gift to me. Polanyi in his books.. What he was puzzling over was how the scientific community works, because that requires a free exchange you know?

[06:07] **Esther:** And so everybody's pulling together to make discoveries. And he thought that was so cool that it actually held a model for how we ought to go at society. And also a key agenda for him was what is wrong with a kind of a communist or socialist construal of science and why that would never work, you know?

[06:30] **Henry:** Any kind of top down, right?

[06:32] **Esther:** Yep. That's right. So he writes the Logic_ of Liberty_, but he spends a lot of time in _Personal Knowledge_ on just how the scientific community works. And he liked that phrase, the society of explorers. And that actually is what the title of the _Polanyi Society_ originally was, was _The Society of Explorers_. So that's why we're so cool. 

[06:56] **Henry:** I think there's a lot of parallels then, because it's like science is a _public good_, a word we use now in the market I guess. It's like non-excludable and non-rivalrous. You can't prevent anyone from using your idea, science is just ideas.

[07:09] **Henry:** Just like open source, once it's out there. I can't like prevent anyone from using it, whether I don't like them. It kind of feels like the water, air sort of thing. And I think science is the same way. And then how do you fund that? I guess our only default option is government grants or like some rich person gives us money because they're a patron.

[07:29] **Esther:** So you make a product and then you sell your product. Like for me, as a scholar and an author, I would be effectively doing the same thing because you can tap anybody's work with a footnote, right. And then you hope you can sell your books, and then maybe you trust that somebody will invite you to come and speak. 

[07:51] **Esther:** There's no exchange of of money going on in this yet. I value the opportunity to talk with not only you for the first time, but your audience and that's kind how that goes too. And you know, our real goal in life, I think, is making a difference in the world. So, obviously there's reward in that, but you gotta eat! 

[08:16] **Henry:** No, exactly. And if you're able to eat, then you are willing to do things for free or just because you want to, right. Everyone naturally wants to help people. And it's just that we all face this kind of like, this tension. I don't always wanna calculate, oh, is this worth it? Or like how much money am I gonna make on this? Or like this kind of thing. Be more generous, right?

[08:36] **Esther:** Yeah. I think there's something to anticipating that as you are generous, there will be fruit for you. There's some Bible about that. It's not the stingy person who is rewarded so in the larger scheme of how reality works, cool things come your way, as you bless others.

#### Polanyi's Interpersonal View of Reality

[09:03] **Henry:** I wanna talk more about Polanyi, so I think that could be a good segue. I feel like there's something there around seeking out, I guess, truth or whatever it is. And it kind of what, talks back to you? You've said like how knowing is like a dance. I like these bodily metaphors.

[09:19] **Esther:** Yeah. And interpersonal ones too. Thinking about my own proposals about how knowing works and now I'm also trying to write about the real. I really in a key way take my original orientation from some of Polanyi's ideas. But I've augmented them creatively to really feature the interpersonal as maybe the fundamental dynamic of reality.

[09:47] **Esther:** And if you just take the idea of face to face. And you know, we're having a hard time, you and I right now. Because you know, I see you, you're so not looking at me. And you're looking at me, I'm so not looking at you. But the point is if you were face to face.. In classrooms, I make my students look at each other, which is like, scandalous.

[10:10] **Esther:** You need to turn and look face to face at the person sitting next to you, you know? And then, I feel that face to face gaze. You can't stay the same. It cannot, not change you and cannot not change the other person because faces are like that. And so I like to see our orientation to the real and our communion with the real as first of all, interpersoned like that. 

[10:38] **Esther:** So of course, reality changes you as you figure it out, and you change reality as you are engaged with it. I've thought about talking about the _face of things_. And if you think about even your garden. You've gotta see, it. You've gotta attend to it. I guess that's a bad metaphor for somebody who lives in New York. You can kind of see it presenting to you and changing you. 

[11:05] **Esther:** So with gardening, what you've got is a season by season dance of overture and response. And that's ordinary life, you know? So our interface with the real is this intimacy of face to face. So I don't know where that leaves us.

[11:23] **Henry:** That's beautiful. You can refer back to the face of God. Now we see in a mirror dimly, but then we'll see face to face. 

[11:31] **Esther:** Then I will know that I am known. And I've suggested in my own work that we already know, as we are known. It's just that it's gonna be really cleaned up, when we get glory. But you know, we have communion face to face now. And I would say we only know as we're known now. That's part of my _covenant epistemology_, is to say that to know is also to be known. 

[11:58] **Henry:** I guess we can go into that. We used a lot of words that people aren't probably familiar with.

#### Covenant Epistemology

[12:03] **Esther:** So I have invented this term called _covenant epistemology_, which stands for my thesis, that the paradigm of knowing, and here we're doing epistemology, which is a big, hairy word that means it means anything that has to do with how knowing works, right. 

[12:21] **Esther:** So how it is that we know whatever it is, we know. Covenant epistemology is my proposal that the paradigm of knowing not be the inherited presumed knowledge as information mindset, but rather be the interpersonal, covenantally constituted, relationship. 

[12:43] **Esther:** So if you think, especially of yourself and something that you want to be known. So that would be the knower and the yet to be known. 

[12:52] **Esther:** I wanna say that the relatedness between those two is inter-person like, and it's intrinsically covenantal because you've got a promise to love, honor, and obey what you do not yet know, if you're gonna invite it to self disclose. So that's kind of the the key to what I mean by covenant epistemology. 

[13:12] **Esther:** And I would say that I got kind of the nugget of that from reading Annie Dillard's _Pilgrim at Tinker Creek_, where she talks about stalking muskrats. And what you have to do, if you wanna invite a muskrat to self disclose, and what that involves is you've gotta surrender your dignity and sit very still and not scratch your nose for a really, really long time, which sounds like covenantal behavior to me. 

[13:38] **Esther:** But also embedded in covenant epistemology is always going to be what I call a Polanyian component. So Michael Polanyi, your listeners are already familiar with. And he has just a myriad of incredible insights and ideas, but one of them was that all knowing is _subsidiary focal integration_.

[14:00] **Esther:** And what he means by that is that, all of our knowing has a two level structure of _attending from_ and _attending to._ So relying on clues or skills or powers to attend to, to find, to shape a transformative integrative pattern. 

[14:22] **Esther:** And I think we all know kind of the experience of having an aha moment where, where things that didn't add up, suddenly coalesce and everything gets transformed. We even call it an _epiphany_, right. That little moment of insight really is the key to seeing what Polanyi has in mind by subsidiary focal integration. 

[14:46] **Esther:** So if you're learning a skill, I talk about bike riding a lot, or reading a book or whatever. You can remember what it was like beforehand, when things did not add up. So you're fixating on the bike. Your body is not working out for you. You're sure you're gonna die by you know.. 

[15:04] **Esther:** And then also the words of the _authoritative guide_ make no sense either. If somebody tells you to balance.. Well, that's just the point, that's just what you don't know, right. So even the language makes no sense either.

[15:17] **Esther:** And so there has got to be this integrative transformative moment where all the things that don't add as you focus on them.. As you somehow scrabble to get inside them subsidiarily, Polanyi uses the word _indwell._ Indwell them. 

[15:33] **Esther:** That actually invites the integrative pattern to grace you. You know, it's not linear and it's not you can't count. You really are begging for there to be a revelation to come and transform everything that you've been scrabbling to put together.

[15:52] **Esther:** And so again, you hear that covenantal placing yourself where reality might grace you to show up. So that's subsidiary focal integration.

[16:01] **Esther:** But even when you've had them the aha moment and you make your pronouncement, there's all this stuff that you rely on that you can't put into words at the same time that you rely on it. It's like your pronouncement crests all that stuff that you've given yourself to. And this is the part in Polanyi that just made my skeptic heart sing.

#### Reality Explodes Your Questions

[16:28] **Esther:** When you get to that aha moment, is that opens worlds of possibilities. And so Polanyi had this magical sentence. He would say, you know you've made contact with reality, and he's a discoverer, right? That's his job. 

[16:42] **Esther:** You have an unspecified sense of future prospects that you can't even name. So there's always this sense of future possibilities. And that's what confirms to you in the moment that you've had the aha moment. 

[16:58] **Esther:** So in other words, every pronouncement, when you make a discovery and say, oh, da, da, da, da. What that does is it kind of opens the world to you. And that as I've written about that over the years, which that actually was what I wrote my dissertation on, was this contact with reality, that started seemed to me to be person like.

[17:18] **Esther:** So in a first book I wrote called _Longing to Know_. I said, it's not so much that reality answers your questions as that it explodes them. Reality really is in the driver's seat. So it walks in and takes over. 

[17:33] **Esther:** You know, if I get to be friends with you over the years the more I get to know you, the more bottomless you're gonna seem, but I'm not gonna say, oh, I don't know you. I'm gonna say, oh, it's precisely because I know you that I have a sense of your in exhaustive coolness. 

[17:53] **Henry:** Thank you. No, that's so true when you're meeting someone, your friend, your partner, or God. You want to know them more, even though you already know a lot about them. I guess the more you know about them, the more you would.. I would hope you would wanna know them more.

[18:08] **Esther:** Mystery that's got a face that you're familiar with. Yeah, it's lovely.

#### Loving with Control-F

[18:14] **Henry:** Yeah. Tying all that you just said with technology, the metaphor we use of knowledge is the database now, right. You know, Control F to search through things. Instead of the sense of community or communion with that thing that you're trying to learn. 

[18:30] **Henry:** I think it's interesting, like how does technology shape how we do epistemology? And clearly it makes us treat everyone like a resource in a database rather than like a person.

[18:43] **Henry:** And I think that's why I'm so interested in your work, because I wanna know as a person, a technologist or whatever, how do we maybe design or work on things that are doing that less, I guess?

[18:57] **Henry:** I think of doom scrolling, the assumption behind that is that that more information is better. That if I find this random piece of information, it'll make me feel better about what's going on in the world. It's sort of true that the more you know, the better, but there's so many other aspects of knowledge that matter. 

[19:14] **Esther:** Well, can I say a couple things? One is I think the key on a Polanyian approach and a Meekian approach with regard to the database is to see that as subsidiary. So the trick is what we have been missing in our modernist understanding of epistemology is we have just presumed that knowledge has to be vocally explicit.

[19:44] **Esther:** But what, Polanyi was saying was, knowledge as focally explicit actually blinds you to the real. And it's actually meaningless. It's totally meaningless. So what your database requires is you to wear it subsidiarily and creatively to find patterns. 

[20:09] **Esther:** And find people you can think of great movies here where somebody's gotta be found before the time runs out. But see nobody in typical epistemology has this category of the subsidiary. 

[20:22] **Esther:** Your database is a fabulous tool. But the problem with that, the poison, the skewing of modernist epistemology is this idea that knowledge is focal information that you then total up and kind of get this comprehensive election. And then that's your goal. 

[20:42] **Esther:** No, your goal is communion with the real. And that's way richer, way richer than comprehensive information because you've subsidiarily indwelled it, artfully, creatively. And it opens up new worlds to you that are highly personed. Does that make sense?

[21:03] **Henry:** Yeah, I think it's like the whole is greater than the sum of the parts, right? The parts are the subsidiary. And then the whole is what happens when you are able to indwell those clues and like come up with something new and use your judgment.

[21:16] **Henry:** And I think another related topic with tech is like we have all our algorithms and apps that tell us how we should think or what we should wear or what we should eat or watch. In some way we are outsourcing our ability to choose, right.

[21:32] **Esther:** In other words, we're letting other people make our mind up for us.

[21:36] **Henry:** Understanding how we actually know, we should trust that we can make decisions. Robots or whatever we wanna call it, AI, they don't know us better than ourselves. We can use them, like you said, as tools, that's all they should be. But these tools have become so powerful, we let them become ourselves, right?

#### Technology is like Chocolate

[21:54] **Esther:** Yeah, that's right. So technology is kind of like chocolate in you could get addicted to it, right. And you could fixate on what wasn't meant to be fixated on. And so I think technology can dehumanize, especially when you're in a mileau that says, yay robots. 

[22:20] **Esther:** In that article, I shared with you, I referenced an old book that came out when I was 21. It was Robert Pirsig's _Zen and the Art of Motorcycle Maintenance._ It's a very good book. He loved his motorcycle.

[22:34] **Esther:** But he was trying to work through this kind of killing, suffocating spirit of technology. Back in his day the big, bad word was the _system_, and the system was killing us. 

[22:48] **Esther:** Think of _One Flew Over the Cuckoo's Nest,_ and actually there's some similarity there, but there's something that can be deadening. I would say with Pirsig, it's not technology, it's the technological mindset, which is epistemology, not technology.

[23:07] **Esther:** But we're, I think we're vulnerable because here's another, and Sherry Turkel said this in the piece I shared with you too. And she's a sociologist who says, she said, I'm not opposed to technology, but I'm pro conversations, face to face conversations. 

[23:22] **Esther:** And I argued in that piece, that personhood is irreducible, but it's also fragile. I doubt we're gonna get addicted to persons unless that's some emotional fusion or something like that.

[23:35] **Esther:** But true personhood is what we crave rightly. And it should make us more ourselves, not less ourselves. But it does need to be cultivated, especially in this era where, Hey, everybody walking down the street is looking at their device. 

[23:52] **Esther:** You know, so we are not making face contact and then COVID comes along and that, you know makes the whole thing worse. So you need to have a fire pit outside, so you can have a face to face conversation with people.

#### Fire Pit Conversations

[24:07] **Henry:** I was gonna say, how have you feel like been able to cultivate that sense of belonging in this time?

[24:15] **Esther:** My life kind of changed because of COVID. And I also had the opportunity that I could pick up and move to my daughter's neighborhood. And that was able to happen only because I was taking this gradual phased retirement from Geneva College where I've been professor of philosophy for 17 years. And so I can look out this window down there and my daughter and grandchildren, and son-in-law, they live three blocks down there. So it was like I literally moved so that I could have them in my bubble, which is a big deal. And obviously people can't necessarily do that. 

[24:56] **Esther:** And I would think in New York you you'd need to cultivate balconies that you can hang out and talk to each other. You know, you gotta find some place where you can meet that's COVID approved, but you do I think need to make the effort to do that.

[25:10] **Esther:** So my daughter and son-in-law in St. Louis, they're artists and she's an engineer. But they literally set up their backyard so they could have fire pit conversations. And they have faithfully had their artist friends and other friends over. And they sit out there in the cold wrapped in blankets by the fire.

[25:30] **Esther:** So in this new place where I live, it's an old place and it's like the first ever time in my life I've had a real front porch. And to have somebody over to have cup of tea is quite doable. I think the colder, weather's probably good for us anyway, to get that face to face thing is just really, really important. 

[25:50] **Esther:** But I'm in no way gonna despise Zoom and Twitter. I mean, Henry, I'm just getting the privilege of meeting you and you live in New York. How could I ever have gotten to you? So you settle for Zoom, if that's what you got. And actually it offers some other possibilities, like you can connect with audiences that otherwise in person would be costly and dangerous and all that kind of stuff.

[26:17] **Henry:** I guess if the goal would be to yeah, meet in person, if it was possible.

[26:22] **Esther:** You know, one reason I moved so merrily and I don't move easily, let me tell you. But I moved because I was isolated, and, as a mom, there's one move to make and that's to be near your daughter. You know what I'm saying? So that's like, all I need, I don't even need to see her. I just need to know she's down there where I could get to her if I needed. 

#### Faces that see you

[26:46] **Esther:** But I do feel you gotta have some real faces in your life, some real _faces who see you_. And see that's I think philosophically profound. You've gotta see yourself being seen by another who's got regard in their gaze as they see you. You have to. Because how else can you know that you're even there, if you don't see yourself reflected in the gaze of someone else.

[27:17] **Henry:** Wow. Yeah, that actually reminds me of something I read from Ivan Illich. He was saying like, you know yourself in the pupil of the other, in front of you. So very similar. 

[27:31] **Esther:** As a child growing up, that seems to be one of I was puzzled about. Am I even here. I call it the noticing regard of the other. I think that's profoundly philosophical. 

[27:46] **Henry:** I think so. You can compare that to the modern epistemology. You are the detached observer, you're focused on looking at other people. And if you think you're this disembodied entity, you're not even realizing you could be someone that could be looked at and known. Like this whole one way versus two way.

[28:04] **Esther:** Yep. Plus what we're so good at in modernity is voyeurism. So we've got this objective observation. I mean, yay, the observation word, but that is so not the kind of scrutiny you want. That's not the thing that's going to make you be you. What's gonna make you be you is the loving regard of the other.

[28:26] **Esther:** And so the gaze of the other, that torpedoes this observation scrutiny thing. And again, back to the modernist mindset, where we think that only focal information is knowledge. That automatically deals in this observational, voyeuristic sort of a thing. Control, power, manipulation modification, all that stuff, all that baggage is connected to this defective modernist, epistemology and so.. 

[29:01] **Esther:** Okay, epistemology is what I do, so I think it's the cause of everything. No wonder that we've had the horrific things happen just like think of _Black Lives Matter_. That's somebody finally speaking up about abuse of power, right? Well, the abuse of power just goes with the modernist epistemology. You know, human mastery over nature. That's what Francis Bacon wanted. If you start with knowledge is power, you end up with power. 

[29:34] **Henry:** Where do we end up with knowledge as dance?

[29:36] **Esther:** Well maybe when the Glen Miller orchestra comes to town and you get to go dancing and then you say, oh, this is the way the world works! 

#### Myopic Fixation

[29:44] **Henry:** You mentioned like voyeurism and I immediately think of surveillance and it's like the same sense of power. Everything is a camera, whether it's a company, government, your own family. We're all tracking each other.

[29:56] **Esther:** And throw in the algorithm. 

[29:58] **Henry:** Yeah. It's like surveillance as care or algorithm as care versus a person, right. And that tool, which could be used to track.. It's like the word track even just sounds bad, you know? 

[30:08] **Esther:** I'm so not up on movies, but there's a lot of post apocalyptic films that just continue to play out this kind of control. It's endemic.

[30:18] **Henry:** I think of McLuhan here, like the_ medium is the message_, right? That ties into Polanyi where he talks about.. If you use the hammer, then the hammer becomes a part of your hand or your body. And you are indwelling the hammer. But if technology or media is an extension of your body, they can also be an amputation of your body.

[30:37] **Esther:** Well, I would say it's idolatry, you know? If you're properly subsidiary indwelling something, it shouldn't be your master, right.

[30:48] **Henry:** Cause it's subsidiary, supposedly.

[30:50] **Esther:** That's right. So it would only be an inappropriate fixation on what ought to be subsidiary that would lead to that. So I think what the modernist mindset, the modernist epistemological default as I call it, actually is, is just that myopic fixation. It's actually blinding us to the real. It's no mistake that this little girl, meaning me, wasn't sure that reality was outside her mind and that's that's a crying shame. 

[31:26] **Henry:** Thinking about idolatry, the way we define it in a faith point of view is just like putting something above what is ultimate, God or whatever. So when we say idol of money, and the same thing with the subsidiary, we're not saying technology is bad, it's just that we have made them too important, right. There's a balance that needs to be had. Otherwise it makes it sound like we're just being critical of everything, right. 

[31:50] **Esther:** Well, we hear idolatry and rightly think about that in reference to God, but I think we can also just think about it in reference to knowing plain old stuff. If you were just totally enamored of your database, you know what I'm saying? There'd be something outta whack, about that. You know, and it would blind you to the real, and I'm not talking anything religious here at all. But you have gotta indwell it. 

[32:18] **Esther:** I used to say to my students that periodic table of chemical elements you gotta wear it. You gotta see the world from it. Same with the multiplication table. You have to see the world from it. And then that opens the world. But if you were to light a candle to the periodic table there'd be a real problem there. And not just the religious part, it would be blinding you to actual chemistry. 

#### Commitment

[32:45] **Henry:** Another thing I wanted to talk about was maybe like _commitment_ and how that relates to Polanyi. I mean, just generally it's hard to commit to things. Given like open source, like why would I want to put myself out there to join a project or do something when I know I might not get anything back. So there's an aspect of like faith and trust.,

[33:05] **Esther:** Okay. Commitment. That's a great one. And I'd also like to add the word _consent_. 

[33:11] **Esther:** So I had two childhood questions. One was whether there's a world outside my mind, but the other is how do I know that God exists? Although I knew lots about the Bible and went to a Bible believing church and all of that. 

[33:24] **Esther:** So in_ Longing to Know _which was my first book, that really is me trying to justify my own Christianity to myself. And as a book for people considering Christianity, you have questions about knowing. And I really do see it as a response to Newbigin's challenge about what, whatever it is that's stopping the ears of people in the West so they don't even hear the gospel and his saying, &quot;Look, it's epistemology. We gotta fix that.&quot; 

[33:48] **Esther:** But Polanyi, in talking about tools, you mentioned about the hammer. And if you think about a bicycle as a tool, you have got to entrust yourself to the tool. So that's more evident with regard to a bike that, that somehow you've gotta give yourself to that bike and trust that it's gonna hold you up all that kind of stuff.

[34:16] **Esther:** So he defined commitment as our manner of disposing ourselves toward the world. And I thought, oh, you can grow up with all this religious jargon and not exactly know what it means, faith, commitment, and stuff like that. But if somebody says, look it's giving yourself to a bike so that you can ride it, you know?

[34:40] **Esther:** That means that that whatever the Christians call _faith_ really is this ordinary everyday sort of an act. And oh yes, obviously knowing God he's gonna transform your life in a way that knowing your bicycle isn't. But what I what I needed to know was that knowing of all types had things in it that looked like trust and faith. That was really the beginning of my approach in _Longing to Know_.

#### Moment of Consent

[35:10] **Esther:** And then over years of thinking about this, I've also began to realize that part of what's going on with commitment is this _moment of consent_. You have got to say yes to something, you've got to say yes to the bike, or or you're not gonna be a bike rider.

[35:29] **Esther:** You've gotta say yes to the authoritative guide. Who's trying to teach you to ride the bike or you'll never get it. So my students, when they came to class, I would say, look, your consent is absolutely critical to this. And you know, I hand you your syllabus. Somehow inside you, you've gotta say, okay, I'm gonna do what she says. I'm gonna trust that if I say yes to what she's asking me to do to these assignments that I'll get where I need to go. 

[36:01] **Esther:** And I would argue that modernity is characterized by saying no, where we need to say yes. And actually there's a term for that. It's _acedia_, which is one of the seven deadly sins. It's often known as slothfulness or laziness. But one philosopher, Joseph Pieper, has defined acedia as refusal to consent to being or to the real. And so what you've got in modernity is effectively a living out of a big fat no to the real.

[36:38] **Esther:** What we have to start to do is have the humility and and the risk taking responsibility to say yes to say I do, right. To give our consent for the real, so commitment and consent are huge. And they're not particularly essentially religious. Obviously you've gotta consent to God, but you've gotta consent to your garden, if you're gonna grow flowers, so you gotta give yourself and trust, but there's this kind of, yes, I'm gonna reciprocate.

#### Willed Loneliness

[37:12] **Esther:** And I've actually felt in my past and have read about this too, that some people you can see, they're so struggling with themselves. It's like they are living out one big no to themselves.

[37:25] **Esther:** Okay, here's a movie that I saw a long time ago, which was filmed in Pittsburgh. That _Joker_ was living out one big no. I mean, he was, he was obviously just like a tissue of no to everything, right. And, and that's what made him such a despicable character. Philosopher Eleonore Stump has coined the term _willed loneliness_, and that's what's going on with Joker, you know? And you know, all of us can have periods in our life where we have got to retrain ourselves to say yes, when our typical response to that point has been to say no. But knowing requires that you have got to give yourself to the prospect of college education, if you're going to get it. Or you've gotta give yourself to whatever your job is for you to get somewhere with that. 

[38:25] **Henry:** I think of other words, like humility. Kind of laying down, like a surrender to something, which is, I guess it doesn't have to be faith in God, but just trust. I guess that is the opposite of control. Knowing that I can't guarantee it's not certain. Having confidence. It might not happen. And actually taking a risk, but I'm still willing to go outta my way to like to try this thing. And serendipity, right? 

[38:49] **Esther:** And so, in my approach to philosophizing, I really like to spend a whole lot of time talking about ordinary acts of knowing. But I feel like every ordinary act of knowing has this kind of silent witness to the reality of God. And so it's like intrinsically.. For you to love a garden well, or to be an artist or to do the work that you're doing. You know, there is this surrender, this commitment. And then this sense that when you have a discovery, it's a gift from on high. The whole thing is so naturally open to the gracious in breaking, coming of God. You know, which I'll leave to him to do, but I feel as if every act of knowing bear's witness to that.

#### Have Your Hands Out

[39:47] **Esther:** It's like you have to have your hands out to receive a gift. And it's that gesture that opens you up to a reality that's far beyond what you might even have been dreaming of. I've worked a lot with James Loder's book, _The Transforming Moment_. And what he argues in there is that ordinary acts of knowing have this structure, just like I'm describing it. And then in his account of the convicting presence of the Holy Spirit, like God showing up, you know. So ordinary acts of knowing that's kind of like the grammar or the alphabet, and sometimes the Holy Spirit commandeers that. And the Lord comes. So the Emmaus road would be like that.

[40:35] **Esther:** It's an ordinary act of knowing, but the one who is revealed changes everything, right? So that's an experience of the convicting presence of God. Which we all have at some time or other, I pray. 

[40:49] **Henry:** I really like this quote from Augustine, which I'm sure you've mentioned many times, but the whole, believing first in order to understand. And that's it's so I remember hearing that the first time I was like, that doesn't make any sense, you know? Of course I have to know it and then I'll believe it. That's just the modern epistemology. And that's just so counter, I guess that has to click too.

[41:10] **Esther:** Well, and I like to help people think about riding bikes, because then the believe in order to understand is essential. You cannot ride a bike, if you do not exercise trust, you can't. You've gotta trust your authoritative guide. You've gotta trust the bike. You gotta trust the world. You've gotta trust your body which is what take some doing. Trust is of a piece with rationality. It's not opposed to, it. You can't have rationality, if you don't trust. 

[41:47] **Henry:** It's like when you're trying to learn how to program. It's just another language, like learning like Chinese or Spanish. And there's a guide as well. It might be your friend. It might be a teacher, whatever. And it's like all those symbols or whatever, they don't make any sense. And then at some point it does. And then now you can say, I know this language, 

[42:06] **Esther:** And in that moment of the aha it's like a door opens and you're caught up in a larger reality.

[42:14] **Henry:** Then they can start thinking from that view.

[42:17] **Esther:** It's almost like the aha moment is really over fast. You put it all together, the door opens and then you're into another world, right. I don't know what else to say there, except that's pretty wild. And there's like this split second moment that you are looking eye to eye the face of the real. It's this, _I see you_ moment from _Avatar._ That aha face to face encounter. You're looking deep into the eyes of the real that's looking back at you and has been looking at you since, before you saw it. And then the world opens. And so when you realize you're keeping your balance on a bike, the world starts to come to you in bike paths. That's future possibilities. That's how you know you've made contact with reality.

[43:10] **Henry:** I started riding Citi bike. I was like, oh wow, this actually is true. I will go to this different part of the city, just because I know that I can do it now. And those paths are always there to begin with.

[43:20] **Esther:** Henry, tell your listeners that I'd love to know them in a more direct way.

[43:26] **Henry:** Yeah, definitely. I would love for more people to know about your work. Thanks so much for having this conversation.

[43:31] **Esther:** Great conversation. I think it's really fun to talk to you.
