---
title: 'Everyone is "Protestant" Online (L.M. Sacasas)'
season: 4
date: "2022-09-27"
time: "50"
description: "How do we all act as protestants online? L.M. Sacasas joins Henry (4th time!?) to chat about material/digital culture, how we compensate for natural affordances in new digital interfaces, our inability to account for non-measurable losses, texture vs. frictionlessness, lofi, roguelikes, reality tv, ambient data capture, extracting our private life for gain, how digital space is more of a past rather a place. (Recorded August 2022)"
episodeLink: "ca5d08c2"
embedUrl: https://share.transistor.fm/e/7771074d
sidebar:
    order: 6
---

### Links

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-4/protestant.md)

[00:00] **Henry:** We were just talking about different ways of thinking about Christianity and how for us, as Protestants, we noticed that it doesn't seem like we care about the body as much, right?

> "For just as each of us has one body with many members, and these members do not all have the same function, so in Christ we, though many, form one body, and each member belongs to all the others." - Romans 12:4-5 (NIV)

[00:10] **Henry:** I'm talking about me going to Israel, and then not feeling something when I feel like I should be feeling something?

[00:17] **Henry:** When I'm in these [places where supposedly Christ was crucified](https://en.wikipedia.org/wiki/Church_of_the_Holy_Sepulchre).

[00:20] **Henry:** Not that I didn't feel anything, but when I see other people expressing themselves by like kissing the ground or weeping.

> Specifically what's the right posture to be placed towards our liturgies/rituals/actions and our beliefs? Protestant's (tend) to think more towards "faith alone/belief alone/bible alone" ala the "solas" and care less about anything else. This tendency in a way is caring about content in a way that is detrimental, and loses the idea of medium/form.

[00:26] **Henry:** It makes me question, okay, what is the balance between how much.. What's the word? Emphasis, we wanna put on the materiality of things?

[00:35] **Henry:** History versus it's all in your head. It's like spiritual, it's abstract. That maybe has a lot to do with even what you've been writing about. How maybe the digital space..

> I've talked with Sascasas in the past about how the digital world isn't disembodied, but it changes our relationship to our body, namely that we forget it (most literally in the sense you forget to eat, sleep, unaware of back issues, etc).

[00:45] **Henry:** We are all "protestant" on the Internet.

[00:49] **Michael:** Yeah, right. Oh, that that's a really interesting angle. I don't wanna kind of make unfair generalizations. But yes, I think that more Protestant traditions and maybe especially evangelicalism in the American context tends to de-emphasize the role that the body might play in spirituality.

[01:11] **Michael:** And so the faith becomes a much more cognitive affair. It's a matter of holding or asserting certain truths or ascending to certain truths or propositional beliefs.

[01:25] **Michael:** And so the other end of that would be more liturgical traditions, whether it's Orthodox or Catholic or some segments of even the Episcopal or Anglican tradition, where the body is more engaged.

> I've noticed this as well in going to different worship services. High/low church is a thing, like high and lo-fi music which I talk about later.

[01:38] **Michael:** It's more of a part of what you do in worship, and even in your sort of daily private practice of piety. And so I've noticed that in my own experience kind of interacting with these various communities and traditions.

[01:56] **Michael:** And right, I think my sense has been that to completely abstract the body from the experience of one's faith is probably a mistake. But I know they're kind of delicate kind of theological currents to navigate there amongst the various traditions.

[02:15] **Michael:** But that the idea that online, we are also kind of trading in abstractions, or trading in virtual differently embodied spaces, right. I mean, I've made the argument, at least once that our online experience isn't really disembodied.

[02:33] **Michael:** You know, here I am, right.

[02:35] **Michael:** Even if we couldn't see each other as we can now, right. I'm still doing something with my body, but it's what we do with it. Or whether we relegate it to a kinda secondary position and then emphasize the verbal aspects of communication or the more abstract, linguistic elements of communication, as opposed to the various ways in which the body might mediate the act of communication.

> Can give the examples of in-person bible study or small group vs. a zoom call. Or Zoom church vs. in-person church. How are parts of you reduced, how are parts of worship reduced (even something mundane like tithing)?

[02:58] **Michael:** I think, yeah, there's something interesting there. I mean, just the way you phrase it at the end there caught my attention that online, we're all Protestants in that way. I might do something with that after little more time to think about it, but that's an interesting way of putting it.

[03:11] **Henry:** It'd be interesting to explore that. It's almost like we went too far in a certain way as Protestants throwing out the baby with the bathwater.

[03:19] **Henry:** The whole metaphor is like liturgy, which is like those material things you're saying. You get to a point where the only thing that matters is like this flattening of faith, right. Belief.

[03:30] **Henry:** When we talk about like salvation, we always talk about like, oh, did you say the prayer that said I believe in Christ, stuff like that.

[03:36] **Henry:** And it has nothing to do with like what you do, how you live your life. It is kind of like this reductionism at the extreme. And then the other side might be like, wow, it looks like they're emphasizing these practices too much, there's too much action and not enough belief.

[03:51] **Michael:** Yeah. And I think the more nuanced representatives both poles of that would probably maybe be closer than what that kind of kind of points to. But I think there are tendencies in those directions. Definitely.

[04:06] **Michael:** And that has been an interest of mine. To examine not just what we do with our tools, right?

#### The Everyday Texture of Material Culture

[04:15] **Michael:** Because I guess one way of translating this into the realm of technology is that we maybe think in very, reductionistic ways about how this act is good and this act is bad with regards to what I do with a certain technology.

> ...we can begin to look not only for discrete and quantifiable effects, but for more evasive patterns, changes to what we might call the texture of our experience or its meaning. I’m especially taken by the idea of exploring how material culture changes the texture of our experience because the phrase itself points us toward a more tactile mode of exploration. It suggests that the self and its relation to the world is not merely a mental phenomenon. It has a sensual, embodied, and material dimension, and changes, even subtle ones, to the texture our experience can have profound consequences. -[The Stuff of Life: Materiality and the Self](https://theconvivialsociety.substack.com/p/the-stuff-of-life-materiality-and)

[04:33] **Michael:** And yeah so in that last post that I've put up in the newsletter, wanted to think a little bit more just not about what we're doing with it, but thinking about technology, not just in terms of our devices that empower our actions, but sort of the texture, the material culture that we kind of just live in day to day and how that shapes us maybe in subtle ways.

[04:56] **Michael:** I was thinking, I use the example of the difference between an e-reader and a physical book, right? I'm staring at some shelves now that have some books that I've accumulated over the years.

[05:09] **Michael:** And with each one of them what matters about them to me is not just the content of the the argument of the book itself. But I have a set of associations with them where have been with this book who gave me this book?

> "As a bookish person, for example, I think about how the distinct material shape of the book not only encodes a text but also becomes a reservoir of my personal history. I remember where I was when I read it. Or I recall who gave it to me or to whom I have lent it." -[The Stuff of Life: Materiality and the Self](https://theconvivialsociety.substack.com/p/the-stuff-of-life-materiality-and)

[05:23] **Michael:** Where did I get it? And even if I'm thinking of just the intellectual content of the book, it's presence in front of me, where I might kind of incidentally glance at it, just sitting here and be reminded of it's argument or it's central thesis or whatever.

> "In other words, the presence of the book on a shelf recalls its contents to mind at a glance and also intertwines an assortment of memories into the backdrop of my day-to-day life. At the very least, it becomes an always available potential portal into my past." -[The Stuff of Life: Materiality and the Self](https://theconvivialsociety.substack.com/p/the-stuff-of-life-materiality-and)

[05:41] **Michael:** It's physical presence matters, right.

[05:43] **Michael:** Whereas if I do all my reading on a Kindle say, that material presence of the book kind of disappears, right? Because the e-reader presents the same material interface for every book I ever read, right.

[05:58] **Michael:** And it has its advantages and all that is fine. And again, the point here is not to say e-readers are bad. It's simply to try to understand how they change the presence of just the materiality of the stuff around us. Right. And I think that that's not inconsequential.

[06:17] **Michael:** I think it matters and that's worth thinking about.

> I need scarcely indicate that everything that is especially hateful and devilish and inhuman about the conditions and strains of modern industrial society is not only Protestant in origin, but it is their boast(!) to have originated it.
>
> If a few people could only stop asking whether this is "a good thing or a bad thing" and spend some time in studying what is really happening, there might be some possibility of achieving relevance.
>
> It's a Protestant sort of fixation, this "Is it a good or a bad thing?"
>
> Marshall McLuhan, "The Medium and the Light"

[06:20] **Henry:** Hmm. I love that. I read from McLuhan a while ago. Maybe that's what I mean by almost like this Protestant way of thinking. Is that the only question or answer we want is whether something is good or bad.

[06:32] **Henry:** We're just saying, let's expand that.. really does explode the kind of questions you're asking.

[06:37] **Henry:** Why is this book next to this other book on this shelf? And you could be like, oh, I remember my friend came to my house in this year and this day for this reason. There's a stain on here. And I know why that happened, that's not gonna show up in your e-reader.

[06:52] **Henry:** Mostly because.. I would say that you could probably embed that kind of stuff in the technology. It's just that as a designer, you're not thinking that.

[07:00] **Henry:** Let's do the efficient thing, which is alphabetized. Maybe sorted by, I don't know how much you've read it or like the size. Very like, yeah, quantitative things.

#### Translated Affordances of Digital Interfaces

[07:11] **Henry:** But you could create an interface that would allow you to add in that stuff. I've seen people where when you read a book, they would take a picture of where they are at.

[07:21] **Henry:** And so it'd be like, I'm in a park at this time on this day, and that would embed that kind of information. And maybe that would help you if they displayed it in a way that was like, kind of spatial. There's no reason why you can't do that.

[07:32] **Henry:** It's just that our interfaces also don't afford that naturally, right. Because like this bookshelf it's just there.

[07:39] **Henry:** I think of the idea of say lossless compression and how when we put something in digital, we could just remove all the information that "doesn't matter", the sake of saving space. And we lose all this other stuff that like you said, it's not in inconsequential, but we kind of don't really focus on it. Maybe we could, if we wanted to.

[08:03] **Michael:** Right. I mean, what strikes me about that is precisely the difference between how in this just this very specific example we're talking about. I don't have to do anything more than use the book in its most natural way in order for these associations to gather around that, right.

[08:22] **Michael:** So I hear what you're saying about.. Yeah, we can maybe figure out ways of trying to incorporate this, but then it always.. All these moves seem to require a lot of effort, right? A lot of forethought, a lot of intentionality, a lot of follow through on the part of the user in a way that makes it..

[08:41] **Henry:** It's a burden.

[08:43] **Michael:** It's a burden, right? Yes, right. It becomes a kind of burden, rather than just sort of being just a default way of experiencing the technology, right.

[08:53] **Michael:** And I don't know.. I feel like I hear that a lot in a lot of other cases where like.. Well, we can recapture this thing that may be lost, but then when they describe how that would work.. I just, I can never help but think, I'm never gonna do that.

[09:08] **Henry:** Yeah, no, I know, I totally feel that.

#### The Burden of Note-Taking Systems

[09:11] **Henry:** One example I immediately think of is.. I mean, everyone has to take notes on stuff eventually. And there's even a meme lately.. I don't know if you've seen that meme with the whole IQ curve thing. The people on the left and the right just use like simple notepad, Apple notes.

- [tweet](https://twitter.com/andreyzagoruiko/status/1552086187489107969?s=20)

[09:27] **Henry:** And then one in the middle, it's like all the different type like Notion and OneNote and whatever. All don't even remember all the names, Roam. And I've used all those things in the middle a lot.

[09:38] **Henry:** And I come back to like, I don't wanna like set up anything. I just wanna like jot something down. And I might not ever look at it again. I just need that the minimal amount of effort.

[09:49] **Michael:** Right. No, that's a great example. In fact, what did I recently download, uh, Craft. So I haven't used it yet, which says a lot.

[09:57] **Michael:** But anyway, I've attempted some of these online note taking kind of systems. At the end of the day, yeah, I just don't stick with it because the simplicity of having a little notebook that I carry around and jotting stuff down. It doesn't.. I don't know.

[10:12] **Michael:** I feel like you can't replicate that with these tools. Which have.. they can do their own things. And I know that.. I'm sure there are users that have figured out great systems with them, et cetera, right.

[10:21] **Michael:** It just doesn't pan out for me. So that in this case, that meme makes a lot of sense, validates me. And I think just going back, it's worth mentioning something you alluded to, which is that we don't have..

#### No Accounting for Loss

[10:36] **Michael:** When we go for the most efficient method or tool or device or whatever, when we you're talking about lossless compression, there's often no way of even accounting for what you're losing.

[10:49] **Michael:** Sometimes it's difficult for people to even articulate what it is, what this loss is. Or what am I missing out on. And it's certainly very difficult to come to quantify, to assign value to, right.

[11:02] **Michael:** These things end up getting lost, getting discounted in part because there's no way of assigning them a value, given the quantitative, profit loss orientation of so much of our society.

[11:17] **Michael:** There's a lot that's getting lost along the way, precisely because of this dynamic, right. We only know how to value and account for certain kinds of effects and consequences, and anything that doesn't fit within those categories, there's not even a way to mount an adequate defense of those things.

[11:36] **Michael:** Right. I mean, does that make sense? Is that..

[11:37] **Henry:** Totally. We have this certain mindset or framework of thinking that we've all kind of soaked ourselves in and we can't get out of it. We can't imagine a world that isn't like that.

#### The Added Texture of lofi

[11:48] **Henry:** If someone tries to bring up like, oh, well we lost this, then it's too easy to just be like, well, you're too focused on the past.

[11:55] **Henry:** I also think of like, say like music. People want the physical vinyl. Even I feel like this, you've probably heard of like [lofi](https://en.wikipedia.org/wiki/Lofi_Girl) music. And it's interesting because they purposely make the music sound not bad, but like old, they put in the crackling sound.

[12:12] **Henry:** It's gotten so popular where now we're generating.. So it's like we reverse it. We're just automating and optimizing that kind of sound. So that even that gets kind of lost.

[12:24] **Michael:** Yeah. I can hear the kind of responses that you're aluding to, that this is kind of Luddite tendency or reactionary or romantic or some other adjective of that sort is always kinda used as a slur.

[12:40] **Michael:** Even being able to mount a defense, to articulate why something like that matters without falling into a romanticism about the past or a kind of nost.. I'm looking for an adjective because I actually don't think all forms of nostalgia are bad.

[12:59] **Michael:** But a kind of reactionary nostalgia about the past that ignores elements of injustice or ways in which life was a lot harder. Whatever. I grant all of that.

[13:11] **Michael:** And yet I think when people register a preference for analog technologies or technologies that are a little less smooth and crisp and efficient. I think they're registering a kind of genuine human need for a deeper kind of engagement with stuff that that's just a little bit more rewarding, even if it's a little harder, a little more.. requires a little bit more of us, but it involves us in ways that are a little more satisfying.

[13:39] **Michael:** And it's why I kept using this word texture, to talk about materiality how it changes texture. And I think we want a measure of texture, right. Rather than just a completely smooth experience of the world.

> "Perhaps the best way of conceptualizing this is to say that the device over-consolidates the materiality of reading in a way that smooths out the texture of our experience." -[The Stuff of Life: Materiality and the Self](https://theconvivialsociety.substack.com/p/the-stuff-of-life-materiality-and)

[13:50] **Michael:** So even there, right, I'm struggling to articulate this and those are obviously very metaphorical ways of putting it. But yeah.

[13:57] **Henry:** Maybe you could go into that a little bit more, what you mean by texture. It's so hard to express that notion..

[14:03] **Michael:** Maybe the language of frictionlessness is part of this. I'm not sure how current that is. I remember writing about this around 2013, 12, 13, or so where removing friction or frictionlessness was this great new thing that companies, devices, apps were striving for, right.

[14:23] **Michael:** I think a lot of times that amounted to removing any obstacles to parting you from your money. But it was a larger kind of value, right, that we're gonna make things as frictionless as possible.

[14:35] **Michael:** Obviously one always has to make the exception. There are cases where that's probably a good thing to do, right. But when you make it an expansive value, that just kind of becomes something you pursue for its own sake under all circumstances, I think you obviously miss out on some things.

[14:51] **Michael:** And the idea here is that we want kinda..

#### Anchors of the Material World

[14:54] **Michael:** You know, I talked about having anchors for the self in that post where I talked about materiality in the book and whatnot. And maybe to tie it back to the beginning of our conversation, right.

> "Without such objects, I’m sure the respective memories would recede once more, maybe forever. If I consider throwing away such an object, I struggle to do so. Not because I would miss the object, of course. I was blissfully unaware of its existence until I happened upon it. What I fear is losing some small slice of myself that would be almost certainly irretrievable without it." - [The Stuff of Life](https://theconvivialsociety.substack.com/p/the-stuff-of-life-materiality-and)

[15:03] **Michael:** It's because we are not just minds, right. That we are bodies in space.

[15:08] **Michael:** The material world, not just the ideas that kind of criss-cross through our mind, but the material world itself is part of the context in which the self evolves and comes to understand itself.

[15:22] **Michael:** So if we have fewer and fewer ways of anchoring the self to the material world, I think that that's part of what some people feel is lost, right? Our identity becomes.. We have a harder time gaining traction, stabilizing over time our experience of the self.

[15:42] **Michael:** A lot of this, I think that just has to do with memory, right? How we anchor our memories of the self over time.

[15:48] **Michael:** So, yeah. I mean, it's a challenge to speak well about this, right. Maybe only the poets can do that. But you know, I'm stumbling around trying to do it

[15:57] **Henry:** Yeah, me too. It reminds me of something my other friend posted. I think Chris Krycho.

[16:01] **Michael:** Oh yeah. I know Chris.

#### The Frictionless Life

[16:02] **Henry:** [_Friction is the Friend of Serendipity_](https://buttondown.email/chriskrycho/archive/friction-is-the-friend-of-serendipity/). And even thinking about like, if there's no friction, right. I'm thinking about like on ice, sliding across.

> "And here we come to it: friction is good. It is of course not a wholesale good, but a contextual good—but a good it remains... To riff on Cohen’s post: friction is the enemy of engagement, and therefore of monetization. That also suggests the corollary: friction is (or at least may be) the friend of serendipity." - [Chris Krycho](https://buttondown.email/chriskrycho/archive/friction-is-the-friend-of-serendipity/)

[16:10] **Henry:** The texture is actually what makes you stop? Those are the anchors. I mean, this is all metaphorical..

[16:16] **Michael:** No, no, it is. Right.

[16:17] **Henry:** I don't know. The loss of identity, feeling like you're kind of going place to place because you don't have anywhere to even temporarily go. You're just kind of drifting.

[16:27] **Michael:** Right. Exactly.

[16:28] **Henry:** Feel like it's a good metaphor.

[16:29] **Michael:** Right, right. No, in fact, while you were writing that, I tracked down this blog post I wrote in 2011. The title was _A Frictionless Life is Also a Life Without Traction_. Near the end I talk about Albert Borgman here. I think Borgman is very good of philosophy of technology on these questions.

> Removing all resistance removes all traction; and if everything is easy, in the end nothing may be satisfying or meaningful. This reminded me of philosopher of technology Albert Borgmann’s suggestion that we must make a distinction between “trouble we reject in principle and accept in practice and trouble we accept in practice and in principle.” - [A Frictionless Life](https://thefrailestthing.com/2011/05/05/a-frictionless-life-is-also-a-life-without-traction/)

[16:44] **Michael:** "Traction implies resistance and sometimes trouble, but it also presents us with the opportunity to navigate meaningfully." Right?

[16:50] **Michael:** Because it's that idea. If you're just on ice, you can't even gain enough traction to have agency over where you're going and what you're doing.

[16:57] **Michael:** I went on to say, "A frictionless life may promise ease in a certain security, but also leaves us adrift chasing one superficial pleasure after another, never satisfied because we never experienced a struggle against resistance that is essential to a sense of accomplishment." I still would stand by that.

> "The trajectory of our desire toward a frictionless life, then, may paradoxically leave us unable to find meaningful satisfaction or a sense of fulfillment." - [A Frictionless Life](https://thefrailestthing.com/2011/05/05/a-frictionless-life-is-also-a-life-without-traction/)

[17:13] **Henry:** Another topic would be like video games. There are a lot of mindless games where you don't actually improve on any particular skill. They give you plus ones and points right. Make you feel like you're progressing, based on how much time you put in.

> Ref things like most mobile games (Bejeweled, gacha games), but also idle games (Cookie Clicker, Universal Paperclips, etc). See [What Makes "Clicker Games" Good? (video)](https://www.youtube.com/watch?v=j_nI6G3ZDiE)

[17:30] **Henry:** And I think that this might be the same, people are trying to gamify people's lives. I remember hearing a talk from a game designer. They're gonna start getting plus ones when you brush your teeth. Or if you go to the store multiple times, you get this.

> "When I spoke in 2010, the thing that people remembered most was this whole notion of gamification.. and the whole world turning into a giant game. So how has that turned out? Well since then I have had dozens of people come to me and say, "I started my company because of that talk you gave." And I'm like man don't blame me for that shit. I don't want any part of that. I mean there's three companies alone doing points for toothbrushing, right." -[The Secret Mechanisms (Jesse Schell, D.I.C.E. 2013)](https://youtu.be/us6OPbYtKBM?t=281)

[17:42] **Henry:** It's all about trying to get you these external motivations rather than the internal motivation, I want to get better.

[17:49] **Henry:** But there are other games where it's actually difficult, right? And so you have to learn, whether it's making certain jumps, figuring how far things are, those kinds of things. The only way you can progress is people say, you need to get good, right.

#### The Internal Motivation of Rogue-likes

> "Roguelike (or rogue-like) is a subgenre of role-playing computer games traditionally characterized by a dungeon crawl through procedurally generated levels, turn-based gameplay, grid-based movement, and permanent death of the player character." [Roguelike (wiki)](https://en.wikipedia.org/wiki/Roguelike)
>
> See [Roguelikes, Persistency, and Progression (Game Maker's Toolkit, video)](https://www.youtube.com/watch?v=G9FB5R4wVno)

[18:03] **Henry:** And I really like this particular type of game genre called a [roguelike](https://en.wikipedia.org/wiki/Roguelike). you probably never heard of it, but it usually involves what we call perma-death. You have lives and I guess when you lose, you have to start over from the beginning. And then also it's randomized, so basically every time you play it's different.

[18:22] **Henry:** Usually, when you play a game, you don't have to

[18:23] **Henry:** actually die right. It pauses you, you start from some checkpoint and you keep going. It's really easy to kind of get to the end.

[18:30] **Henry:** But in these kind of games, if you fail or you die, you have to start over from the very beginning. So the only way you can actually beat this game is you basically die enough that you learned how to get past what these obstacles are.

> My favorite examples that I've played (with varying levels of help): Hades, Slay the Spire, Noita, Nuclear Throne, Risk of Rain 2, One Step From Eden, Inscryption. I'll also mention platformers as also usually not helping you (Super Meat Boy, Celeste), other than maybe for accessibility.

[18:44] **Henry:** And I think that gives you a lot of fulfillment because at the end that it was me, that I had the skills to get through this. Versus like the game just kind of pushed me along.

[18:54] **Henry:** I put enough hours in it, in terms of just straight up time, my skill doesn't have to increase at all.

[18:58] **Henry:** If it's all frictionless at the end of it, you're not really satisfied completing this thing. It's like entertainment or something.

[19:06] **Michael:** Yeah. And of course, I think this is kind of a good segue to Illich. We have to talk about Illich at some point. So it's the difference between just being a consumer, right, and being skilled, developing some measure of skill or competency.

[19:21] **Michael:** Which then gives you a sense of accomplishment, sense of purpose. I think that anchors your identity to some degree, helps you contribute to the life of the community, et cetera.

[19:31] **Michael:** Whereas the alternative is that we know only how to consume services and things and goods, that demand nothing of us, never satisfy us, just gin up more desire for the same.

#### The Language of Needs

> Worth listening to his podcast series with David Cayley from 1994: Community and It's Counterfeits [(transcript)](https://static1.squarespace.com/static/542c2af8e4b00b7cfca08972/t/58feb23dbebafb9f0adb7fc5/1493086792120/COMMUNITY.pdf) [(audio)](https://www.davidcayley.com/podcasts/?category=John+McKnight).

[19:42] **Henry:** Since we're gonna talk about Illich, I've been listening to a lot of John McKnight. I think he helped him with _Medical Nemesis_ and also _Disabling Professions_, I think.

[19:52] **Henry:** But a lot of his work is around the language of needs, in terms of community, in terms of what you were saying about being consumer. And his point was in order for the community to grow, the institution will never help the community grow because the institution is an outsider, a third party. They're coming in to fix your problems.

[20:14] **Henry:** And of course, they're looking at this community from the point of deficiencies and needs. He was coming into like a university setting and all the studies are all what he would say are the glass half empty. Let's find out all the, I don't know, drug problems in the city, and then figure out how to pay these people to help those people.

> "We have deficiencies and problems and emptiness. And we have fullness and gifts and capacities... communities have no needs for needs. In my hometown, little town of Wisconsin, we have one carpenter. And he has one leg. Nobody in my hometown needs John's missing leg; we need his other leg. We need to understand him not as physically disabled, but as a carpenter because he's the only one we got. And if we begin to think of him as physically disabled, our community will stop growing." - [John McKnight](https://www.youtube.com/watch?v=0-yvfj-ttIs&list=LL&index=17&t=2628)

[20:33] **Henry:** He was saying, why aren't there studies that tell you which communities have figured it out basically on their own. He found the principles of how to grow a community from the point of gifts rather than needs. Seeing people that they all have gifts.

[20:48] **Michael:** Very different, right? Yeah. That makes a lot of sense.

[20:51] **Henry:** It's sort of like what you said. Like playing this game and feeling accomplished, people need community. And people feel like they're being valued in their community, by using whatever gifts that they have.

[21:05] **Henry:** Especially what he would call labeled people. We label them based on their disabilities, rather than their gifts. And it's difficult because it's easy to just say, yeah, let's just pay for something. Or I guess separate people, isolate them into different places or like something like that.

[21:19] **Michael:** Yeah, yeah, this certainly resonates with Illich. Yeah. I can definitely see the affinity.

[21:24] **Henry:** I don't know where we went with but that was, that was interesting. I wanna go deeper into what I thought was the Protestant mindset or whatever you wanna call it..

[21:33] **Michael:** Man, I'd have to I'd wanna think about it a little otherwise I think I'd just be kind of..

[21:37] **Henry:** I'm happy to just spend some time thinking about too.. With podcasts, we always wanna say immediately what I'm thinking.

[21:42] **Michael:** No, no, but you're right. I mean, it's fine, fine to try to hash it out. I just don't want to give you nothing. Yeah. I mean, if you wanna start off and tell me some of what you were thinking you know, along those lines, I'm happy think out loud with you.

#### Liturgies and Mediums

> "Education is a holistic endeavor that involves the whole person, including our bodies, in a process of formation that aims our desires, primes our imagination, and orients us to the world -- all before we ever start thinking about it." ― James K.A. Smith, Desiring the Kingdom

[21:52] **Henry:** I guess I kind of go to James K.A. Smith's work on liturgies habits?

[21:58] **Michael:** The first of that trilogy books that he wrote. Yes.

[22:02] **Henry:** Ties a lot into McLuhan. I kind of find everything going back to the medium is the message.

> The section on "the medium is the message" can, perhaps, be clarified by pointing out that any technology gradually creates a totally new human environment. Environments are not passive wrappings but active processes. … “The medium is the message” means, in terms of the electronic age, that a totally new environment has been created. - Understanding Media

[22:07] **Michael:** Mm-hmm. Yeah, yeah.

[22:08] **Henry:** Even the materiality, the texture you were talking about in the world, isn't that like our medium?

[22:14] **Michael:** That's the medium, right? Yeah, definitely. It's the stuff of life.

[22:17] **Henry:** So when we reduce, when we flatten life by digitizing things and we kind of lose those other, what we call them, things that we can't even say, we lose like the medium.. Or the medium becomes something else. I don't know what..

[22:33] **Michael:** Right, it changes, right? So the medium changes and the most important effects are not often the ones that we immediately perceive.

[22:42] **Michael:** I don't know, maybe this example will help. One thing that occurred to me after I wrote that post.

#### No Material Trace

[22:47] **Michael:** But I recently took my girls to their first baseball game. So I don't know for me, I'm a baseball fan. It was a big deal for them, they really enjoyed it. And there were.. I had no paper ticket to save right. I had to use an app, and that app was our tickets.

[23:04] **Michael:** There was no little bit of.. no memento, right? No artifact, right.

[23:09] **Michael:** Whereas I recently kinda shifted offices and so I unpacked a few boxes and went through some old stuff. And I found the ticket to my first baseball game, which was a spring training game in the 1990s, before the Marlins came to south Florida, went to watch the Nets and the Yankees play.

[23:23] **Michael:** And so this whole set of memories comes back because I have this little physical artifact that takes me back. I think people of a certain age would resonate with this. I mean, up until pretty recently, I suppose. Maybe even just up until the pre COVID period, you would have something like this where increasingly we've digitized all these interactions, right?

[23:43] **Michael:** So there's no material trace that's left behind in a way that I can stumble upon it 10 years from an hour or whatever.

[23:54] **Henry:** And like you said earlier, people are introducing that digitally, but it's just not the same. You could have a history of every ticket that you bought that's digital and you could put it on an NFT, all that stuff.

[24:07] **Michael:** Right.

[24:08] **Henry:** And they have these new apps. They'll be like, oh, you took this picture like a year ago. And I think genuinely do help, but it's not just stuck in this pocket in a coat.

[24:18] **Michael:** Yeah. No, I think, my wife had one of those apps for a while. It would kind of collect your photos across various apps and it was on this day. I forget what it was. And it was interesting because it was also gamified with a streak function. You'd get a little record of how many days in a row you'd done it or something like that.

[24:34] **Michael:** But to me, this is a really interesting point. Because I think this kind of echoes something we were talking about a little bit ago.

#### Compensating for the Losses of the Digital

[24:41] **Michael:** We find ourselves trying to create very artificial ways of replicating things that had been just default modes of interaction or just default outcomes.

[24:53] **Michael:** And I find that one interesting thing that that does is it makes things much more conscious, right? We're much self-conscious about we're trying to do, in a way that has its own interesting consequences.

[25:05] **Michael:** Paralyzing maybe. It heightens itself in a certain way, anxiety inducing.

[25:10] **Michael:** There are a lot of knock on effects, second order effects from even that desire to try to compensate for these losses in ways that are now much more artificial, rather than embedded in the actions themselves, internal to the actions themselves, right.

[25:28] **Michael:** Which is different than trying to layer some additional process or series of steps or whatever onto something just to replicate what would've been ordinarily captured anyway by the action itself.

[25:42] **Henry:** It's almost like you're not able to acknowledge the medium is the message actually. If you think about it, trying to replicate that thing digitally is not being able to understand that if you do that, you're actually creating another environment has a whole different set of behaviors that happens.

[26:00] **Henry:** There's no.. Nothing can be one to one, right? Everything is always gonna be different.

[26:04] **Henry:** That's why people don't like reading the same book, because they're like, well, I already read the content, but it's like, you are different as a person, and the context have changed.

[26:12] **Michael:** That's right. I mean, that's well put right. You're just escalating in a sense the problem, right? You think, well, there's this kind of loss, or this this thing I need to compensate for, so I'll just introduce one more tool or technique to do so, and then you've just sort of introduced a whole new set of..

[26:28] **Michael:** You've not only failed to recapture what you think you're recapturing, right. You've introduced a whole new host of issues.

[26:35] **Michael:** And not all of these necessarily, pan out in catastrophic ways or anything like that. But, but I feel like we're constantly chasing something, that we can't quite capture, or recapture as case may be. And then generating other effects that we still haven't fully comprehended like this inability to just inhabit moments and actions..

[26:59] **Henry:** As they come!

[27:01] **Michael:** As they come, right. That we are forced into modes of heightened self consciousness.

[27:06] **Michael:** I think that that actually has a lot to do with the inability to maybe move forward even socially. If I think of this at the kind of collective level, we're kind of trapped in these doom loops of self-consciousness and self-awareness. We're unable to sort of.. I don't know, imagine alternatives or simply..

[27:26] **Henry:** Be.

[27:27] **Michael:** Be. Right, exactly.

#### You can't capture me!

[27:28] **Henry:** I almost feel like that this practice of digitizing things or wanting to recreate is like the habit that we're creating, because we're trying to chase after what I would just say, capturing things.

[27:40] **Henry:** If we wanna speak from Illichian point of view, he has like this famous.. It's not famous, but like I keep thinking about it, where someone was trying to take a picture of him when he was giving a talk and then he just shouts in the middle of his talk. "You can't capture me!"

[27:54] **Michael:** Oh, interesting. Yeah,

[27:55] **Henry:** Thought that was so funny, but also in a way he is right. Maybe we feel like we can capture these moments in time. And we do feel like a picture captures a moment in time, but the picture will never bring you back to that moment.

[28:09] **Henry:** What it was like. And we could try to simulate the sounds and the smells and all these things, just like we're trying to do with the metaverse, but it's not going to be the same, right.

[28:18] **Michael:** Yes. I mean that dynamic of trying to capture the moment, document the moment. Yeah, that that's so pervasive.

[28:25] **Michael:** I mean, I wonder.. I used to think about that a lot more. And I wonder to what degree.. Has that changed? Do you feel like that has changed, like that impulse to document?

[28:34] **Michael:** I think of that as being a very sort of early social media kind of instinct, I'm not sure how much that is the case anymore, but I mean, I think to some degree it is, right. I know I'm I certainly tempted by that.

[28:48] **Henry:** Well, I think as someone that does podcasts, you might start feeling like I need to record every conversation that I have because there's something good. There's devices that are always on. It's probably default on, and then when you need it 30 seconds back, I can like save that. But you're conscious that you're being recorded all the time. But I also think maybe it's not as big a deal just because we are doing that all the time.

#### Reality TV prepped us for the very online life

[29:11] **Henry:** Everyone is trying to capture what's going on in their lives. And it's like, I watch Twitch, right? But one of the most popular categories, it's not video games. It's IRL, in real life.

[29:22] **Henry:** And it's like these streamers, maybe they are famous through video games, but now they're just basically celebrities, like YouTubers. And they just stream them doing random stuff, being in their home, like cooking food or whatever. And that is their whole life.

[29:39] **Michael:** Yeah. That is curious because that hearkens back to very early internet days or very early, maybe web two days. I remember there was a documentary to this effect. I wrote about it in some essay I wrote about privacy at one point a long time ago.

[29:53] **Michael:** I forget the name of the documentary, but it was somebody who basically subjected himself and a group of friends to 24/7 surveillance. And I think that that kind of stuff was more popular in that era. So interesting to kind see that kind of come back.

[30:08] **Michael:** I think of that too I've, I've often thought that reality TV was such a perfect prelude to the social media era. That in many ways it prepped our consciousness to then just put our lives online. Right?

[30:23] **Henry:** And it gets kind of worse because it's the way they make money is through.. It's actually hard to do that. It's not just a YouTube video. You can edit it, make it short.

[30:32] **Henry:** A lot livestreaming is.. You can just say it's boring. And if they have a contract signed they have to stream a certain number of hours per month, then you know, how do you fill up that time?

[30:41] **Henry:** So a lot of people aren't creative enough or just it it's not, you could still get a lot of views if you're famous by eating some food, you don't have create this whole like setup.

[30:52] **Henry:** So a lot of times people are just end up watching their own YouTube videos or other streamers as the stream, which is so meta. It just gets kind of like, wow, what is going on?

[31:03] **Michael:** Right, right. No, that's incredible. But it is that you use the word extracting not too long ago. That's been my one fundamental take about the metaverse right.

[31:12] **Michael:** And maybe this is the difference I was trying to get at. When I think of early social media, I think of a lot of very conscious documentation of the self and presentation of the self.

#### Ambient Capture and Surveillance Culture

[31:23] **Michael:** Whereas now what's being captured, I think the focal point has shifted from the self as we capture it in a televisual way to the capturing of data, just data from all realms of our experience.

[31:37] **Michael:** Whether it's data about the bodies that our Fitbits gather, ambient data about our consumption habits, the way a lot of smart devices, our designed to capture data about our consumption habits as well, to automate that consumption.

[31:50] **Michael:** And so it's less about that older ideal. Cause I do think it's also the case that maybe even Gen X brings the old televisual ideals of the self as celebrity into the early social media world.

[32:05] **Michael:** That has changed and shifted to something a little bit different, although I'm not sure I can articulate how exactly it's changed.

[32:12] **Michael:** But I think we're in a realm now where it's less about the active presentation of the self for most people. And more about kind of the ambient capturing of data that reveals preferences, ostensibly, and automates all forms of content intake and consumption, which has its its own set of issues or whatever.

[32:35] **Henry:** Yeah. I guess maybe that fits into.. We're always talking about algorithms now. You flatten everyone's inputs into some data set, and then that turns into like what you're supposed to watch.

[32:49] **Henry:** Even livestreaming fits in with this ambient thing you're talking about, it's not like most people are necessarily watching someone as the main focus of what they're doing. They're cooking food or running or something. It's just like in the background, like having TV in the..

[33:05] **Michael:** Right, and that's interesting of itself. But I don't know that I ever completed a thought of extraction, right. So we want to extract.

[33:11] **Michael:** And often for the sake of, I mean, in the case of the the people who are live streaming and have a platform and contracts, obviously it's a form of income, right? You're generating income for yourself by basically extracting your private life, right. Or what would presumably be your private life?

[33:28] **Michael:** Everything now can just be a source of production, right? It has no integrity on its own terms except as a potential source of content.

#### On the Terms of the Medium

[33:41] **Henry:** Yeah. It's interesting, because I spend a lot of time watching this stuff too. So it's not like I'm trying to say this is bad whatever. But I'm also trying to understand like what's going on and I think..

[33:52] **Henry:** People that do that, they are very open about their lives and that can obviously be bad and good in so many different ways.

[33:58] **Henry:** But it is interesting hearing when they're not on, right. They're not on their livestream voice or whatever and because there's so much time, right, people just act like themselves and just be honest about how they feel. But then you can't tell if it's like, is that for the livestream or is that just them?

[34:14] **Henry:** Sometimes like people will share. And like one of them, I thought was interesting. They're just speaking about how you have to evaluate whether that game is gonna be good for your viewership. The game might be just fun, but if no one will watch it..

[34:28] **Henry:** It actually hurts you because if you play the game that no one watches that actually might make people not wanna watch you later, or they start tuning to someone else.

[34:37] **Henry:** Or you could not stream it, you just play it for fun offline. Then you're like, well, I'm not making money.

[34:43] **Michael:** Yeah, yeah. It's another case of you're kind of conforming to the medium, to the platform, right? Exactly. Whether it's what plays well in that medium, or whether we think of it strictly as consumer demand or whatever, but right. That's dictating what you're able to do, right.

[35:01] **Henry:** Right. And then you might even play games that you don't even wanna play, but then they're paying you to do it.

[35:07] **Henry:** Maybe with a podcast, you can only talk about certain topics or it has to be timely so you're doing it every week.

[35:12] **Henry:** I almost feel like I wanna do the exact opposite. Never take sponsors. I was trying to edit some of the ones I did last year. I was like, oh, this is still pretty good. It still feels like relevant, because we're talking about things that apply across hopefully multiple years. It's not just like, oh, this week this happened.

[35:29] **Michael:** Right. Or this topic that trended for 24 hours.

[35:33] **Michael:** Yeah, And I I don't know, to go back to this idea of things we have a hard time articulating, quantifying, defending whatever. The we here obviously very generic, right.

#### Extraction of Private Life into Public Benefit

[35:41] **Michael:** But there was a recalibration of the private versus the public self, right? The private versus the public life that digital media has enabled. And I don't know that we have quite reckoned with the consequences of that.

[35:57] **Michael:** To some degree, this maybe even has something to do with the self consciousness I was talking about earlier. That we afford ourselves time when we're not in the public eye at all right. Where we're not thinking of what we're doing as being potentially for the public eye.

[36:14] **Michael:** That there are aspects of our lives that we do think of as private, right. I don't know. I mean, obviously for maybe the majority of people that maybe that hasn't changed all that much.

[36:25] **Michael:** I don't wanna make the influencer, the YouTuber, the norm. There are obviously still kind of exceptional case, I think.

[36:35] **Michael:** Everybody who has a presence on social media, unless they're kind of content with just kind of lurking and just being someone who watches and listens in or whatever you have to generate something, right? Whether it's quippy sentences or memes or images for your Instagram account.

[36:54] **Michael:** What maybe would've been conceived as being private life now becomes fodder for this kind of public presentation of self.

[37:01] **Michael:** And I might even have committed the sin of tweeting this thought, that there are goods that are proper to the public realm and there are goods that are proper to the private realm. And in blurring the two we've kind of lost those two sets of goods, right?

[37:16] **Michael:** So it's in a way we've.. Maybe corrupted is too strong of a word, but you know, we've kind of corrupted public life with private elements of the self and invaded private life with the public in ways that have kind of disturbed the right balance, the right order of both of those sphers. I don't know. Does that make sense?

[37:37] **Henry:** Yeah. Some people now, they don't want a distinction between the private and the public. Or maybe by putting ourselves so much in public, what's the difference?

[37:44] **Henry:** And I think that a lot of us share these very deep, intimate moments about our lives online. That doesn't mean it's everything, but like share when they get married, they have kids, when they change their job. You think about all these big events, we wanna put that on there.

[38:00] **Henry:** Of course we all wanna share these moments, but it's also weird because everyone else sees it too. And they're not gonna have the context or relationship with you to even make that meaningful to you other than making your likes go up.

[38:13] **Michael:** Yeah. And I mean, I wanna be careful on two fronts here.

[38:16] **Michael:** So I've mentioned two things so far, right? The televisual ideal of the self that we carry into the early social media period. The way in which reality television, mid to late nineties, early two thousands kind of preps us for that.

#### On Loneliness and Making a Living

[38:28] **Michael:** The third thing maybe is loneliness, right. You know, throughout the mid to late 20th century there's a lot of work done on the, the. The pervasive nature of loneliness, right? Anonymity, mass society, the individual is lost. You know, I think _Bowling Alone_ comes out in 2000.

[38:47] **Michael:** And so I think we bring an experience of loneliness and alienation also into that early social media period. And social media promises connection, right. Promises to alleviate that loneliness. To give us people who will hear us and listen to us tell our story or share our lives. I imagine there must be some solace in that.

[39:09] **Michael:** Or at the very least that's a legitimate desire for which we seek a satisfaction, right? The desire may be framed as a desire for companionship, to be known, to be affirmed, et cetera. You know, so I think, in describing how social media, digital media, the internet in general, kind of shapes us or whatever we're trying to do.

[39:32] **Michael:** I do think it's important to acknowledge that desire as a legitimate desire that maybe drives a lot of what we do. Even if I might have issues with the way in which social media addresses that desire or fails to.

[39:46] **Michael:** And then the other thing too, I wanna acknowledge is I mean, people need to make a living. Some people have found a way to make a living. I don't know. I just think it's very easy to.. It's probably too easy to criticize people for what they're doing when from one perspective we could say, look, it's hard to get by.

[40:03] **Michael:** And some people are trying to be creative about how they do that. I don't wanna judge that too harshly. I mean, I think ideally there are ways of kind of negotiating all these things. Maybe better, worse ways of doing it.

[40:16] **Michael:** But yeah, I think people want companionship. People need to find a way to make a living in the world. So I think at the very least, those always need to be kind of caveats in our critiques or nuance the way we think about these trends and developments.

[40:29] **Henry:** Totally. I mean, it's funny because in some sense, that is how I make my life. I'm just critiquing my own self I guess. I don't know.

[40:36] **Henry:** I wanna critique it as someone that is participating in this space. So hopefully from a loving heart.

[40:43] **Michael:** Right, yeah. And being inside of it and trying to navigate, in a sense unless we're talking about something we might deem altogether illict, right. But that otherwise this is what we can hope for, right.

[40:54] **Michael:** To kind of thoughtfully participate in these arenas and find out from experience rather than just as a kind of outside observer, whether they're wise and virtuous ways of navigating these spaces. In humane ways of being in them, rather than just allowing the demands of the machine or the system or the the network to completely overtake us and shape us. Yeah.

[41:19] **Henry:** Right. And I think that goes back to what we were talking about with like a certain mindset. Doesn't have to be Protestant or whatever, that was just my funny label for it.

[41:27] **Henry:** One could be like, well, the future of work is everyone live streams. And the other one is like, oh, this stuff is really bad, we should get rid of it. I think this is gonna be here to stay, it's not gonna go away. So how do we think about doing this in maybe some more thoughtful ways.

#### Negotiating The Terms of Technology

[41:45] **Michael:** Right. And may be the case, I do think refusal needs to be a live option, right.

[41:51] **Michael:** There are cases where we might affirm without too many qualms, right. Just a firm endorse, embrace a new technology or device or pattern or whatever.

[42:03] **Michael:** I think probably most of the time what we're doing is something more like negotiating, right? We're negotiating the best terms. We realize that there's some benefits that accrue, we recognize at the same time that there are some harms or some consequences that we're maybe less sanguine about.

[42:20] **Michael:** And so what we're trying to do is navigate, negotiate. So then I wanna say the third option is refusal, right? And I think there is for certain people and certain conditions, depending on their moral outlook, how they're situated, they may conclude the best option is to refuse.

[42:35] **Michael:** And that that's a perfectly legitimate option as well.

[42:38] **Henry:** Yeah. The concern is just being able to opt out. And I guess that goes back to like Illich and the feeling that may be forced to do something because there are no more options whether it's legally or culturally, right? Maybe there's some universe out there where everyone has to livestream for some reason.

[42:59] **Henry:** And I'd rather someone do livestream and do youtube then they just work some random 9-5 job. At least maybe they can be creative about it, the fact that they have the ability to try something else. I think that's great.

[43:10] **Michael:** I think that's right. Every era has presented us with demeaning forms of human labor, right. And so anytime where we increase the freedom of individuals.. Genuinely, right. I think the catch here is always what is sometimes offered as increased freedom is often just another form of entrapment.

[43:28] **Michael:** But if there are genuine avenues for a greater degree of independence and self-sufficiency and, and development of personal skills and capacities. Those are always to be valued and preferred, I think.

[43:42] **Henry:** Mm-hmm. I'm not sure where this fits in, and you've wrote about this too.

#### The Gradience of Relationality in Sidewalk Life

[43:45] **Henry:** When you talk about private and public, I also think of Jane Jacobs' sidewalk life.

[43:50] **Michael:** Mm-hmm. Yeah, kind of gradience of relationality between that spectrum of private and public, right?

[43:57] **Henry:** Right. Trying to figure out what is sidewalk life online. Does that exist?

[44:03] **Michael:** Right. And it's funny, cause that's another case of that pattern that we talked about at the outset, which is that it just happened by default in the setting that she was describing, right? You just the arrangement of the space was such.

[44:15] **Michael:** You walk out, you pass your neighbors, you're, you're going to the local market.

[44:19] **Michael:** And so you have all of these interactions that are not the kinds of interactions you have in your home, where you invite people into your private spheres, but neither are they completely anonymous interactions, right?

[44:32] **Michael:** You come to know your neighbors to a certain degree. You come to know the grocer to a certain degree. You are known by them. But it's not happening because you're going out of your way to do it. It's happening because it's the arrangement of space, housing, and commercial space, et cetera.

[44:46] **Michael:** Whereas now if you live in the suburbs, the way they're constituted, and you wanna reconstitute some kind of community in that way, it will not be organic, right?

[44:56] **Michael:** You have to drive somewhere. You have to coordinate people's schedules, which are now kind of all off kilter. You find yourself again, trying to artificially reconstitute, what had been a kind of organic just default way of being.

#### Artificially Reconstituting Our Being in a Built Environment

[45:12] **Michael:** And maybe that's the only thing you can do, right.

[45:15] **Michael:** So if I wanna have friends, I don't know. There was some meme going around Twitter. I didn't catch the origin of it, but it was one variation of it. That by the time you're 30, you should have friends. And it's like, well, I mean, sure, that's nice.

[45:26] **Michael:** If I haven't been forced to move and relocate. If the way that I've had to make a living hasn't kind of precluded a social life. There are all sorts of caveats to that, but ideally, yes. And maybe it just requires us to be more intentional in this way. Artificial, if you like. Maybe that's too pejorative a way of putting it.

[45:45] **Michael:** But I don't know. I mean, it would be nice if our material environment, our socioeconomic environment was more conducive to the formation of friendship, for example. And we didn't have to go fight against the grain of the environment in order to achieve that, which I think is what we're often doing.

[46:03] **Michael:** Are we gonna have to go against the grain of our material environment to achieve some of the goods that we want for our lives? One can imagine a world where it isn't that way, right? Where the grain of our social environment is such that it is conducive to human flourishing, conducive to relationships, cetera.

[46:21] **Michael:** And it's, you course, very easy for me just to say that right, declare that.

[46:26] **Henry:** Yeah. I mean, I guess it just speaks to just the difficulty and maybe impossibility of designing a world. The digital space is that I think you use the word built environment. It's artificial in that way. Not that it's like a negative thing, simply that we have to build everything from scratch.

[46:44] **Henry:** And like you said, recreate all these things that just don't.. We can't even use the same assumptions. Actually that's one of the problems with tech. We aren't able to embody, if that's even possible, what's in this space enough to just come up with new ideas or primitives that is better suited for the digital space rather than just trying tack on.

[47:06] **Henry:** Like we've always talked about how to emulate talking when you create Zoom or something.

[47:12] **Michael:** It's not quite the same. And I think at the core of a lot of that.. In each of these cases, the body is displaced as the focal point of our experience in ways that have inevitable consequences. And again maybe it's fine sometimes, right.

[47:27] **Michael:** You know, I'm glad to be able to chat with you in this way. If all my interactions were this way, as it was for some people during the early days of quarantine, for example, right. That's problem. Some people can choose that or to be forced into that kind of mode as a problem.

[47:42] **Michael:** But right. I think in the digital space that there is no.. I've tried to argue, it's not a place. And so our bodies can enter into it in the same way. And I think this will still be the case even with kind of immersive VR.

[47:55] **Michael:** You're not gonna be able to replicate the kinds of interactions where the human body is at the center, right, of our experience. And we're not just acting tele-presently, in some mode or another.

#### A Gaze Turned Pastward

[48:07] **Henry:** I think you've written that it's also like the digital is always the past.

[48:12] **Michael:** Oh, yeah, well recently, yes. It always turns our gaze to the past, right. I think of the experience of a timeline on Twitter or Facebook, whatever, right. It's always receding into the past, right.

[48:23] **Michael:** Even if it's a very recent past. But it is always to what has happened.

[48:27] **Michael:** And then we just sort of layer levels of discourse over things that have happened. And all of it is just kind of accumulating in the past and it kind of sucks our attention, our sense of purpose, even, our imagination. All of it just sort of gets sucked into these massive digital archives of the past.

[48:46] **Henry:** If you were having a conversation or argument in person, it's all happening in the present. But with Twitter, even though they could have said it a second ago, people are responding to someone else's second ago.

[48:57] **Henry:** And I feel like it's the same with what I was saying with livestream. People are watching livestreams of someone else's livestream of some video. It becomes too meta. There's no coherent narrative or situation or anything.

[49:09] **Michael:** Right. There's nothing propelling us productively forward, I guess, as part of what I'm trying to capture, right. With any form of media, you're always dealing in the past, right?

[49:19] **Michael:** So when somebody wrote a letter, and somebody received. They're receiving something from three days passed, or a week passed, or whatever. You read the morning newspaper in 1985, you're reading things that were printed the night before, right. Or published overnight, whatever.

[49:34] **Michael:** But it's the preponderance, I think. So the preponderance of our activity for somebody who's extremely online say, their gaze has always turned to this moment just before now, right. They're not inhabiting the present. And their action is building this archive of the past and they're being sucked into it.

[49:53] **Michael:** You know, I don't want to exempt myself from it, right.

[49:56] **Michael:** And there's nothing to turn our gaze forward, or to give us the freedom to think about what may come, or how we might be in the future, or to just inhabit the present. It's always again, this gaze turned pastward.
