---
title: "Finding Hope Amid Burnout (Alex Kim)"
season: 4
date: "2022-09-27"
time: "43"
description: "Where can hope be found? Alex Kim joins again to open up questions of responsibility, and our place in relation to times of weariness. He speaks out his experiences growing up and also shepherding a local church body as a youth pastor. We speak amidst the burnout on notions of time, the work of Charles Taylor through Andrew Root, work/play, and living out in hope. Maybe it's what this podcast is attempting to work towards! (Recorded June 2022)"
episodeLink: "04c015c8"
embedUrl: https://share.transistor.fm/e/d1722b65
sidebar:
    order: 5
---

### Links

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-4/hope.md)

#### La Fatigue d'être soi (Weariness of the Self)

[00:00] **Alex:** It's funny talking about it like this. I'm only 30, but I feel like I don't remember growing up in the 90s or even the 2000s and thinking.. 

[00:09] **Alex:** Man, my life is just a really washed up version of _Mad Max_ like if I were to purchase Mad Max as a reality from wish.com. I wonder if it's like a phenomenon of us being so interconnected. 

[00:26] **Alex:** There's always something looming, right? The world feels very apocalyptic, in kind of like the movie genre sense and not like what we would consider like a biblical sense of apocalyptic. 

[00:41] **Alex:** And I can sense that there's a lot to talk about because of it, but at the same time, it can feel a little bit tiresome. I think people when they do have something to say, it's more like exasperation, right. 

[00:59] **Alex:** I don't know, like how are you feeling about all this?

[01:03] **Henry:** It kind of just reminds me of burnout in general. Everyone's quitting their job whether it's in my industry or just generally speaking. None of us can focus on anything, caught up in the wind of like every single thing that's happening. 

[01:16] **Henry:** Not that those things aren't important, but those other things didn't stop mattering when this new thing happened, right.

[01:21] **Alex:** It's interesting that you bring up burnout because I've been reading a book by a youth pastor named Andrew Root. It's part of a series on basically applying Charles Taylor's book to church ministries, specifically youth ministry.

[01:40] **Henry:** I forgot if I sent that to you.. I might have gave it to you..

[01:44] **Alex:** Honestly, it's probably a both and, knowing that we share a lot of ideas with each other. Yeah. I mean, I was reading it recently. His third book is about how the Church is affected by what Charles Taylor considers like _The Secular Age_. 

[02:03] **Alex:** And I guess, regardless of what you may believe personally in terms of your own values or your own religious thought, he does say that the fascinating aspect of our burnout is tied to our conception of time. Not having enough time.

[02:21] **Alex:** What he says is actually somewhat perceptive, that a lot of what we do is tied to our own identities as well. So it's not just that we're a part of these movements simply because they're good movements to be a part of. 

[02:37] **Alex:** But there's kind of this aspect where we're trying to find our identity and find ourselves within these movements. And within our society, there's always going to be another movement that sort of cries out to us if we wanna personify it, to make it a part of who we are.

[02:54] **Alex:** And if we were to think about burnout and the sense of time and also identity.. 

[03:00] **Alex:** I think in French it was like _La Fatigue d'être soi,_ or depression is the fatigue of being oneself. 

[03:08] **Alex:** Sometimes I wake up in the morning and I get that sense, right? Like, who am I, why do I feel? So burned out? Like, what do I need to do in order to be me today? 

[03:19] **Alex:** And that sort of rings true I think with all these like events happening back to back, right. It's not just a matter of like, what can be done to resolve these issues, but what is my responsibility and what is my place and who am I in relation to all these things? 

[03:39] **Alex:** And there seems to be kind of that extra demand that if I don't find my place within these movements that I'm doing something wrong. 

[03:49] **Henry:** Like a moral judgment on yourself, if anything. 

[03:52] **Alex:** Yeah. And it's this kind of this nebulous, journey to constantly find yourself and waking up the next day, realizing that you may not actually know who you are. And that it can be depressing. Not in a clinical sense, but existential. 

[04:12] **Henry:** Is what I was doing related to this current movement? And if I think that movement is important, then maybe I should stop what I'm doing. 

[04:22] **Henry:** I guess if you're always like changing jobs, reinventing yourself, or trying to get caught up in this stuff, then you don't have roots, which is funny. His last name is Root, right?

#### These Churches have Five Year Plans

[04:32] **Alex:** Yeah. And it's interesting because the thesis of the book actually comes about because the writer explores these megachurches, who are known for just their constant dynamism, their constant movement and formulating their identity, who they are, having visionaries within their leadership.

[04:57] **Alex:** And what exactly do they do is.. They try to propagate as many high intensity events as possible, right? To try to get people energized in the next project. 

[05:10] **Alex:** Jokingly, maybe all of these churches have like five year plans, right, regardless of whether they fully come into fruition.

[05:17] **Alex:** But it's kind of like, just kicking these events to go, go, go in order to sort of maintain this identity and to maintain this high level of energy.

[05:28] **Alex:** What's fascinating is that every time he goes to these churches and he talks to the people, the churches have like hundreds of people who attend. 

[05:36] **Alex:** But one of the blights that plague, not only this megachurch in say like a big metropolis like New York, but also like the small churches who low key hate these kind of megachurches, and like what we would consider like the middle of nowhere United States of America, they also face the exact same kind of burnout, I guess what we would call like a spiritual depression. Of course not using that in any like clinical sense, but just this idea of burnout. 

[06:08] **Alex:** And it's strange because you would think that with all this hyping up people would actually be doing things and not be burning out, because everyone's like so focused on the next project. Maybe it is a little bit more obvious to other people it ends up actually crowding out and burning people out.

#### The Dynamics of a Pastor

[06:30] **Alex:** I would not consider my church to be all about events and programs and things like that. But I feel a little bit of it too. Who am I supposed to be in relationship to my students, to the parents, to the other adults in the congregation, to the leadership. 

[06:50] **Alex:** And depending on what new event happens, I feel like there's always this transformation that is being demanded even of my own person. And it's not surprising to me that a lot of pastors burn out too.. 

[07:05] **Alex:** It's strange because I think a lot of people and maybe people who are listening in who aren't very well acquainted with a church or any kind of religious affiliation, may not exactly know the dynamics of a pastor, or a priest, or a rabbi or anything like that.

[07:21] **Alex:** But, I think just being kind of this member within this community, you would think that the guidelines and the expectations would be relatively uniform. But everyone has their own expectation of what a pastor should be. In that case, the identity of the pastor is always in flux.

[07:41] **Alex:** And it makes sense to me, the more I think about it, why so many, especially youth pastors, don't make it past like the third year of ministry. 

[07:50] **Alex:** Because if you think about it, they have to be administrators, right. They have to know how to teach. They need to know the Bible. Others demand that they be pseudo philosophers, to have kind of a scholarly bent. Others sort of demand that they are super big on doing the worship correctly or meeting up with people one on ones.

[08:15] **Alex:** It's a very demanding position. So I guess for me, I understand, or I feel like I empathize at least, or sympathize with those in the congregation who are going through burnout, especially with all the world events that sort of call and beckon us to pay attention to them. 

[08:35] **Alex:** And of course I say all these things, not because I think these events don't matter. I think they all contribute to our human story in good or bad ways. And that we do ultimately have a responsibility.

#### Intimate Moments &gt; Big Programs

[08:49] **Alex:** But the question is how do we manage our responsibilities in a way that doesn't burn us out entirely to the point where we're like completely apathetic.?

[09:00] **Alex:** Maybe part of the solution for at least within the church community is not to focus so much on these like big programs and trying to get people energized for it. But just to simply start small and appreciate the small intimate moments where people enjoy one another's company. Can be a good way to start. 

[09:23] **Alex:** Part of the reason why you may feel burnout is, everything becomes kind of a task, right. You're really no longer in the moment. And it's almost like you are outside of your body, right? You're not really like experiencing it for what it is. You're not really enjoying it. You're just doing it for the sake of doing it because time demands it. And I wonder if our slavery to time itself can be broken simply by enjoying the moments that we have. 

[09:56] **Henry:** That makes sense. Preoccupation of the future that doesn't exist or dwelling too much on the past, rather than just being there. We use the word fellowship, right. Being with friends and enjoying another's company in that moment. 

[10:12] **Henry:** And another thing we do is try to capture that. Say we see a nice sunset that anyone can see. We have to take a picture and make a video. Why is it so hard for me to just not need to record anything? It's funny even doing podcasts, we could just have this conversation. But might as well record it.

[10:29] **Alex:** Yeah. And maybe there's also this thing too, where there's kind of this impulse for us to want to be known and to share our lives with people that we don't even know, for whatever reason. You can call it for clout, for reputation, things like that.

[10:49] **Alex:** But I wonder if it would actually be better for our health in certain ways, just to be satisfied with sharing those moments with people who are the closest to us.

[11:02] **Alex:** And I wonder.. I don't come on here on this podcast thinking I have the answers for everything. Or even if I have the answers at all for these very complex questions.. 

[11:13] **Alex:** I just hope that it's not nostalgia speaking. I'm not trying to like say, &quot;Well, in the good old days.&quot; as if there were a golden age per se besides the golden age that I believe in, starting in Genesis. 

[11:30] **Alex:** But like no solutions, just like food for thought.

[11:36] **Henry:** We're just speaking out loud.

#### Notions of Time

[11:38] **Henry:** I think I want to go back to the time thing. If there is a reason why burnout is related to time. And I think one notion of time that I thought was interesting is like what he called higher time. Time for us, the only way we can conceive of it is simply that each portion of time is the same. That's why we can measure it by seconds or hours or years. 

[11:59] **Henry:** But one example would be like going to church on Sunday. That moment when you're there is connected to every other moment that you were in Church on a Sunday. It's always seven days apart, but each moment they're meaningfully talking about the same thing. 

[12:15] **Henry:** Same with a birthday. Every birthday you have reminds you of every other birthday, even though it's a year apart. So in terms of like measurable time, it's really far away. But in terms of what it means to you, it's like significant.

[12:28] **Alex:** There's always pros and cons, right? I think one of the biggest problems with a lot of more traditionalist mindsets is that, at least when it comes to technology, is that they always sort of focus on all the cons, right? 

[12:44] **Alex:** And sometimes those who are all about tech can very easily fall into trap of thinking all about the pros without thinking about maybe some of the repercussions or things that are being pushed out of our sort of cultural memory.

[13:01] **Alex:** And when it comes to even the measurement of time itself, you think about certain societies where like that rigidness when it comes to making time isn't nearly as important. More stereotypical views on this where the German conception of time is very like on time. Very similar to Japanese culture in terms of their train systems especially. Nothing is even early. Everything is exactly when it needs to be. Emphasis on needs to be, right. 

[13:36] **Alex:** And then you have like other time perceptions. People in our culture would consider it like Asian time, which is basically when everyone comes like 15 minutes later than they're supposed to. Or you leave 10 minutes later than they're supposed to. 

[13:52] **Alex:** But I find that what's interesting is on the one hand being able to measure time does open us up for more efficiency. But the question is like, is life all about that kind of utilitarian efficiency? 

[14:10] **Alex:** And even the way that we perceive time without necessarily measuring it. Even if we measure time, I think the way that we perceive that same amount of time is qualitatively different. The same 10 minutes can be painfully slow or super quick. And you wonder where all the time had gone.

[14:33] **Henry:** Right, you're like having fun on vacation or you're working.

#### Having a Proper Sense of Efficiency

[14:36] **Alex:** Yeah. And I wonder if it's possible for us to recognize the importance of efficiency, but also have space where we're not enslaved to efficiency. Where we can tell ourselves and each other that there are times where, you no pun intended, where it's okay to just slow down. 

[15:03] **Alex:** But I think it's very hard to escape that in our culture especially with what we're surrounded with.

[15:08] **Alex:** For one example I was at the camping trip, this past weekend with a group, my youth and their parents. And one of the traditions of this camping trip is that we would go to this Irish breakfast joint. And the food is.. The food's decent, right? Of course we're not doing this podcast for basically a Yelp review.

[15:32] **Alex:** And one student, not like trying to rag on this student, kept saying, oh where's our server? When's the food going to get here? We need to be able to get our food and eat it on time and get outta here so that we can make it to our Sunday worship service.

[15:54] **Alex:** And I just had to tell him, it's okay to just relax? And take some time to just enjoy company, talk with each other, stuff like that. Of course, I'm saying that. And then later I catch myself when we need to get the bill, and it's like 10 minutes before the service. I'm like, okay, alright. We need to get the bill right now. 

[16:16] **Alex:** So it's hard, I think in our culture to really think about it in those terms, because there's always a deadline that's being set for us. And I think that goes back to our burnout, right. We would like to enjoy our time, but we can't.

#### Work in Order to Play

[16:32] **Alex:** And that's why I think a lot of American society, we work in order to play. We try to get all of our work done so that we can set up part of time where we can enjoy. But the sad part is that I think for some of us, maybe many of us, we can't enjoy the time that we set apart, because we know that at the end of it, there is more work? It's just a cycle. 

[17:03] **Henry:** There's that phrase, work hard, play hard. That might be capturing part of that. It's really intense to be at work all the day, and then you do something really intense when you're not working. That probably makes you very tired too. There's no sense of rest. I think we don't have that as part of our vocabulary.

[17:21] **Alex:** Yeah. I think our culture is maybe slowly shifting away from that rigidness, whatever you want to call it. I think you make a good point though. Why do you play hard? Well, you're working hard all the time, and yet you still only have like so much time to play. You're kind of put in this position where you have to make the most out of the time that you have. 

[17:46] **Henry:** That's the same problem. You're basically making play work by playing hard, right. I need to figure out the most intense thing. It's almost like the soul of play is like lost trying so hard, right.

#### Trapped in Itineraries

[17:58] **Alex:** Yeah. And even vacations, I think can feel that way too, right? Not only are you working at your job right, 40 hours a week or whatever, but you're also planning a vacation. And when you plan a vacation, what do you plan? You plan an itinerary, which is a schedule of events. And you have only a certain allotted amount of time per event. And then you're off to do the next thing, right? 

[18:27] **Alex:** I say this because when my wife and I go vacationing, I think we had this very intense itinerary at first. Our synapses were firing just always getting something new. And at a certain time, I was just like, okay, well, I feel like we have a decent enough understanding of the Hawaiian islands where we can make it without having such an intense itinerary, right. 

[18:59] **Alex:** We can take things slow. We can go to places, have a general outline, but just take time to enjoy what we experience. And if we don't happen to go to something like that's okay.

[19:15] **Alex:** I think that changes the vacation or rest qualitatively. It's not just a rush to do more, because you feel like you don't have time, but you get to enjoy. And surprisingly, I would say that I probably remember more from having a less strict itinerary. Seems a little bit more like remarkable to me, memorable. 

[19:43] **Henry:** There must be some relationship there. We went on a tour. Or tour bus. And that's literally the epitome of a schedule, right? You can't either stay longer or you can't skip something. It's all planned out for you.

[19:56] **Alex:** Yeah. And of course there's some benefits to that because when you're already working, you don't want to put more work into setting out your time for this. So you have some company or corporation do it for you. But by doing it, I mean you still fall into the same trap where you're unable to really slow down and you're trapped. So it is really what it is. You're trapped to the schedule. 

[20:24] **Henry:** We chose that too, that's even better. 

[20:26] **Alex:** Yeah, you chose to be trapped to a schedule, because that's all you know.

[20:31] **Henry:** These habits we're learning from work get applied to your play and your vacation or your friendships or whatever. In New York, everyone's like, do you wanna meet up? Oh, I'll put you on my calendar, right? From like five weeks from now.

[20:44] **Henry:** I'm trying to actively do the opposite, give myself more free time, less scheduled things. Give myself slack, essentially in my time. So that I am free, when someone else asks me to do something, I can fill that up. Going back to this idea of serendipity, these are values that I appreciate a lot more.

[21:04] **Henry:** That's a memorable thing too, because you didn't expect it. For a vacation, you go to the places that you're supposed to go to. You don't have any story to tell because everyone's gonna go there. You could just watch it online or whatever. But like something that happened personally to you, that's a testimony. That's a narrative that you can share. That's very meaningful that you'll remember and other people will remember. 

[21:24] **Alex:** Yeah. In the book he mentions that when several different people were interviewed about what they would do if they were to magically get a bunch of money, one of the more popular answers was to not work for a certain duration of time and just try to rest, right. Even though our society has a lot of entertainment venues, people are still not finding the kind of rest that they would like.

[21:58] **Alex:** I mean, how many of us sort of feel that itch that needs to be scratched whenever we're just sitting around and not doing anything, right. We always feel like we need to be doing something or we're not &quot;productive members&quot; of society. But what a very like capitalistic, consumeristic view of oneself. 

[22:21] **Henry:** It's a machine view of yourself. 

#### Where is Hope?

[22:23] **Henry:** I think maybe related to this conversation, we could talk about hope? The beginning of this was all about kind of like the hopelessness of the world and burnout towards it. How should we be thinking about it? 

[22:37] **Alex:** I know we sort of went on that tangent about burnout, but I think maybe burnout is very much tied to this idea of hopelessness, right? Because part of the problem with all these major events that are happening in our society is that they're all bad. They're all catastrophic in some way; things that we haven't seen in decades. 

[22:58] **Alex:** We have like a pandemic that's still lingering around. We have potential food shortages. We have a war in Europe. We have supply chain issues. We have a looming recession.

[23:15] **Alex:** And one wonders, what's beyond this? And I think it's relevant to my ministry with everything that's going on internationally and also domestically.. and even seeing some of my students who are very much Gen Z. They're one of the more socially active generations that we know. 

[23:38] **Alex:** They are also very hopeless in their perception of the future. I would say that anti-natalists arguments are becoming a little bit more popular within their generation. For those who don't know what that is, it would be arguments against having children. They are very sensitive to climate change issues. And they're also a generation that is having less sex because of these issues as well. 

[24:15] **Alex:** And ultimately when you are to ask them of the reasons behind all this is that it's this deep sense of hopelessness in the future. Which I guess makes sense if you think that this world is going down the drain then why would you want to bring new life into the world, right. Why would you want to have them suffer to things that you are suffering and things like that? 

[24:46] **Alex:** And the more I think about this along with just burnout, right? You get a sense of hopelessness too, right? I think part of the reason why burnout can feel so like saddening is that there's no real hope to escape that burnout, right. Or there's no perception of hope to progress to creating a better world.

[25:15] **Alex:** Perhaps a lot of these steps towards what they would consider progress have taken several steps back, right. And I can see how that can be demoralizing; no one likes to see one's own efforts completely squashed over what could be uncontrollable at least in an individual's sense.

#### On Shepherding

[25:41] **Alex:** Sometimes I wonder if I should like bring up some of the things that my students do, even like anonymously.. Because I wonder if I bring it up on a podcast like this and they end up listening to like, oh, Alex is using me as an example here. But I don't mean it in any kind of like, mean spirited way, definitely not. But there are some things that my students say that I find to be very like provocative and very, very good to learn from. 

[26:07] **Alex:** I think that's the one thing that I try to be as a youth minister or a youth pastor is.. Part of who I am and what I need to be doing is I need to be declaring what God is saying, right, through the Bible. And if you wanna talk about job description, that's part of the job description. 

[26:29] **Alex:** But I think another part is like in order for you to be a good shepherd you need to start paying attention to how your sheep are doing. 

[26:38] **Alex:** It's not just telling them to go here or there, but you need to actually understand their own condition, their thoughts, their worries, their anxieties, their questions.

[26:47] **Alex:** And what I found very illuminating is that they weren't asking me questions necessarily for answers. I think one of the students, actually asked me a question more along the lines of like, how are you feeling about all these things? As if i'm the one that is being shepherded at that moment. 

[27:08] **Alex:** Another student, she actually had a very provocative statement that I think is very helpful, something that we've kind of talked about all the time.. But basically to sum up what she said, she found the idea of the hope that we find in the Christian story to be very compelling, but also very distant, right.

#### Against Walls and Fences of Hopelessness

[27:36] **Alex:** We just kind of live in this society where there's almost this wall of hopelessness, right? 

[27:43] **Alex:** For some people it's like a stone wall that you can't see through, so you can't see hope on the other side. But for others it's like a chain linked fence, you can see it, but there's still kind of this barrier and you're not quite sure how you're going to get through that.

[28:01] **Alex:** And just going back to what one of my students said, how can we make this hope compelling for this generation? 

[28:11] **Alex:** Because of my convictions, the Christian story is the hope for the world. But maybe for some of your listeners, it's a question that we can all ponder, right? 

[28:24] **Alex:** Is there hope, can we find hope even in the midst of all this bad news, right. Are there stories of hope? Because it does impact how we live our lives, hearing about some of the statistics of this generation and definitely the generation to come, how we view or really what we expect in this life really does determine how we live in this world.

[28:55] **Henry:** I guess I just wonder how people in the past thought of that question, what did they expect? Not just like 50 years ago. Did they not expect that much? And now we expect a lot? I don't know.

[29:07] **Alex:** It is a good question to ask. 

[29:09] **Henry:** Why did people choose to, if they even thought of it as a choice, to have kids or to continue living, right. It doesn't make me be like, oh my life is so much better or whatever, but I guess it even lengthens this time.

[29:22] **Henry:** If you're familiar with Alan Jacobs, he has this phrase, temporal bandwidth. 

[29:26] **Henry:** We were talking about news before, right? Every minute there's a new thing happening and it makes your bandwidth really small. And when I see the past a little bit more, it gives me more, because I understand that people have gone through a lot of things too.

[29:42] **Alex:** I think in the past there was a clearer expectation, at least among Christians especially, for the hope of a better world. I think in today's Church, the chain linked fence is still a reality for many Christians as well. It's just that they go to church. And they may be looking through this chain link fence while others who don't go to church may not be paying it at any attention at all. If that's how we wanna formulate the analogy. 

[30:16] **Alex:** But I think back then there was less of a sense of a chain linked wall. There's more of a sense of this immanence, where God had an active role in your life, right? There was a push, especially during modernization in the West, to explain everything through the scientific method and to crowd God out as an explanation for things. 

[30:44] **Alex:** Some even considered that the God of the gaps argument, where if something is mysterious, instead of utilizing the scientific method to figure it out, you just say, ah, it's God, right. God did this.

[30:56] **Alex:** What is that quote from that movie about Mozart Amadeus, where the guy at the end scene says, it was God or something like that.? Anyway, sorry, that's just me going on a tangent.

#### Dual Causality

[31:08] **Alex:** What I believe honestly is like not to just assign everything that's mysterious solely to God, but to recognize that God does work in and through his creation so that we can believe in a kind of like dual causality, right. 

[31:26] **Alex:** The Bible often talks about like God riding on the clouds and bringing rain to his people. And the thunder and the lightning are his like weapons of choice or whatever. The clouds are like his chariots, like highly poetic. 

[31:43] **Alex:** Then if you were to ask anyone today, like, oh, how do you get rain? You talk about it in scientific terms, but for me it's both. There's multiple levels here, right? God's the one who is ultimately behind it, but that's because nature, as we see it, was set up in that way. And I don't think that necessarily contradicts each other.

[32:04] **Alex:** But the reason why I say this is I think there was a higher perception of this back in the medieval ages and before really modernization started happening and the scientific method and all that started to crowd out the theological underpinning of how we explained the phenomena of this world.

[32:28] **Alex:** And now we're all products and children of the Enlightenment, right. I don't think any of us really experienced the world as it was experienced in the medieval ages. We're always gonna feel like there's this sort of chain link fence. 

[32:46] **Alex:** Now I say all these things, going back to our topic about how we can actually effectuate maybe the sense of hope. And I think it's actually by utilizing our relationships and how we live our lives to be sparks or moments where we can peer other side.

#### Church as Wirecutters

[33:09] **Alex:** Rather than just approaching it simply in terms of argumentation and discourse, I would much rather talk about like how we as a Church can stand with those who suffer and bring hope. And how can the Church sort of be the kind of wire cutters for this chain linked fence that we call hopelessness, right? 

[33:34] **Alex:** How can we help people not just see the other side, but gradually find their place on the other side. 

[33:43] **Alex:** Yeah and I think going back to what we talked about earlier, that begins on the one sense, a communal level, as people interact with the Church. 

[33:54] **Alex:** But also at an individual level, as individuals carry out their responsibilities within the community, sharing their time and their energy and experiencing the joys of hope, which for us is to be with the Lord in the moments that are given us. 

[34:17] **Alex:** So we can talk about changing the national discourse or changing the systems and things like that. And I think those are all very, very important, but I think we also need to focus on the individual level and what we do in our daily lives. So that the systemic changes make sense.

[34:39] **Alex:** My skepticism or really my worry is that it'll be like, oh, we changed the system, now we can just get on with our lives, right. But again, our lives in the individualistic consumeristic sense and not in the corporate sharing of lives and responsibilities and sufferings and joys that come with living in this world on a day to day, moment by moment way.

[35:06] **Henry:** I make a metaphor to technology. We have all this technology makes our lives more efficient, but we don't know how to use it effectively. Learn to use it when it makes sense and learn to know when to walk away. Same with like learning to improve our sense of what does it mean to be human or to live in a community? And we need that alongside changing the system.

[35:29] **Alex:** I mean, I think that's the next step, right? Just first I think, at least in my context, it's recognizing what is important to us? What are our values? How then can we start not only envisioning, but finding effective applications for those values in the lives that we live, right. What are the things that we say yes to? What are the things that we say no to? Because we have this vision of hope. 

#### Living Out a Seen Hope

[36:02] **Alex:** If we were to appropriate one of the Greek philosophers and to use Plato's Allegory of the Cave. 

[36:10] **Alex:** The philosopher who goes and sees the real world, freed from his or her chains and goes back to tell these cave dwellers about the real world and the elusiveness and the illusions that they were seeing in the shadow of these puppets.

[36:30] **Alex:** I think in kind of a didactic or educational sense, rather than merely through lectures or purely proclamation, what our generation needs is a Plato's cave allegory where a person who has envisioned and seen this hope, lives it out in their lives. And that is their teaching, right. 

[37:00] **Alex:** That is how people are able to see this elusiveness of hopelessness kind of pass away, as they are seeing this hope that is actually the reality that we should all seek. So you can criticize me for how I use that allegory. I just kind of thought that that might be a little bit helpful in terms of how we can bring the hope that we understand and effectuate it. 

[37:29] **Alex:** I really do think that the way that we help people to understand hope is not merely talking about hope. That's part of it, but we just need to live as hopeful people, right. We just need to show people. And going back to consumption, people who only consume hopelessness will always only know hopelessness. 

[37:57] **Alex:** Not to go onto another tangent.. think about all the people who only listen to one type of news, then you wonder like how to get more and more extreme in that. Because going back to your love for liturgy, it becomes a habit. What you listen to, what you experience becomes you. What you subject yourself to.

[38:21] **Alex:** We're not as insulated as we would like. We're very porous and we will absorb things. And actually I think that his Charles Taylor's own kind of analogy, that people in the past viewed themselves as being more porous to influences. Whereas we like to lie to ourselves and say that we're insulated. 

[38:43] **Henry:** It's not that we are buffeted, we are porous. Like you said, we just pretend that we are so strong and no one influences us. In reality, everything affects us, whether it's consciously or unconsciously, right. The whole point of talking about liturgy is realizing that things do stuff to us, we're not the ones doing things to the world.

[39:07] **Henry:** I think that your point about not just saying something to have hope. That's like the equivalent of the person stuck in a hole and then you just tell them, Hey, just get out of there. Or you're sad, and then they're like, feel better.

[39:20] **Henry:** We choose to go down with them. It's like presence.

#### Hope for Life and Life to Hope

[39:24] **Henry:** The medium by which we talk about a message is the whole point. And if the message is a person or the medium is a person, then that's the thing that gives us hope. Just like we think that Jesus is our hope. 

[39:39] **Henry:** The medium of laws says something about what we think makes sense, or is important in the world. Not that they're not important, but we're maybe idolizing them. That we think that the way we can change the world is through laws. Like you said, those are the systems, but we haven't even changed ourselves, then it's not gonna be as effective. Taylor actually talks about law fetishism.

[40:00] **Alex:** It's good that you brought up that thing a little earlier, because I think you're thinking about James Chapter 2, right? Suppose a brother or sister is without clothes and daily food. If one of you says to them , &quot;Go in peace; keep warm and well fed,&quot; but does nothing about their physical needs, what good is it? 

[40:16] **Alex:** Of course that chapter is talking about faith and deeds and stuff like that, which we don't have to get into now, but yeah, in a real sense, like the medium is the message. And in the Christian faith, the medium is our humanity and the message or the Word is Jesus. So really God's word of peace and love to us is presented not incorporeally, but through our humanity.

[40:49] **Henry:** A person came down right. And we are supposed to imitate him. 

[40:54] **Alex:** Going real quick back to the whole, like giving hope for life and bringing life to hope, right. 

[41:02] **Alex:** I would just like to really think about Jesus himself, who was born to someone who was in an engagement, not yet married, who we know was born basically poor, who was persecuted and had to flee from his place of birth, and who had friends who betrayed him, right. Knowing very much the amount of suffering that Jesus went through.. Yet, despite all this suffering, there was still hope to life and the life that he gave for us. Despite every argument that one could make that maybe Jesus shouldn't have been born, right. 

[41:58] **Alex:** And I think this is why for me it's important that Christians don't just like lobby and fight tooth and nail to use force to overturn, but to be compassionate and understanding and to find ways to provide a world that right now, not trying to be like condescending in any kind of way, but just recognizing what people are saying themselves, that they feel hopeless, that we could give them hope, right. 

[42:36] **Alex:** I think one thing that Christians can do is that they kind of view themselves as superior to everyone else and just kind of assume that people are hopeless. And that's not what I'm trying to do here. 

[42:47] **Alex:** I'm just really listening to what people are saying, their feelings of hopelessness, and wondering how the Church can step in and provide hope for those people.

[42:59] **Alex:** So to make a very bad pun of your podcast, I hope that we can all find hope in the source who I think is God himself so. Or a source of hope for those listeners of yours who may not be so religiously inclined. 

[43:21] **Alex:** Nevertheless, hope is not something that should be deprived from anyone. We want people to have hope. We all want a better world.
