---
title: 'Right Feeling (Sonya Mann)'
season: 4
date: "2024-08-09"
time: "47"
description: "How does faith call us to both right action and right emotion? Sonya Mann joins me again to discuss the layered meanings of biblical parables. Some themes I liked: the paradoxical nature of faith, the generousity of God, the interplay bt obligation and grace, freedom within constraint, the parable of workers in the vineyard and talents, lay utilitarianism, the nature of praise, phenomenology in faith, the metaphor of weddings, viserality and the flesh, specificity, sacred modes, acceptable woo, cheap grace. (Recorded October 2020)"
episodeLink: "7b1c5ae2"
embedUrl: https://share.transistor.fm/e/393f4afc
sidebar:
    order: 8
---

### Links

- [Matthew 20: Parable of the Workers in the Vineyard](https://en.wikipedia.org/wiki/Parable_of_the_Workers_in_the_Vineyard)
- [Matthew 25: Parable of the Talents](https://en.wikipedia.org/wiki/Parable_of_the_Talents)
- [Luke 15: Parable of the Prodigal Son](https://en.wikipedia.org/wiki/Parable_of_the_Prodigal_Son)
- [The Woodcarver: A parable, of sorts](https://www.reddit.com/r/latterdaysaints/comments/75wvcx/the_woodcarver_a_parable_of_sorts/)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/main/season-4/feeling.md)

[00:00] **Sonya:** So Henry, I want to read Matthew 20, which is the parable of the workers in the vineyard. I actually read this last night because I'm reading through. And it really resonated with me and I felt like it was very relevant to our current cultural moment, at least in America, and maybe in other places too. So I'm just gonna go ahead and it's not very long, so I'll just read it and then we can talk about it and what it means. Oh, and this is Jesus speaking.

[00:27] **Sonya:** For the Kingdom of Heaven is like a landowner who went out early in the morning to hire laborers for his vineyard. Now when he had agreed with the laborers for a denarius a day, he sent them into his vineyard and he went about the third hour and saw others standing idle in the marketplace and said to them, you also go into the vineyard and whatever is right, I will give to you. So they went. Again, he went out about the sixth and the ninth hour and did likewise. And about the 11th hour, he went out and found others standing idle and said to them, why have you been standing here idle all day? They said to him, because no one hired us. He said to them, you also go into the vineyard and whatever is right, you will receive.

[01:09] **Sonya:** So when evening had come, the owner of the vineyard said to his steward, call the laborers and give them their wages, beginning with the last to the first. And when those came who were hired about the 11th hour, they each received a denarius. But when the first came, they suppose that they would receive more and they likewise received each a denarius. And when they had received it, they complained against the landowner saying, these last men have only worked only one hour and you made them equal to us who have borne the burden and the heat of the day. 

[01:42] **Sonya:** But he answered one of them and said, friend, I am doing you no wrong. Did you not agree with me? For a denarius, take what is yours and go your way. I wish to give to this last man the same as to you. Is it not lawful for me to do what I wish with my own things or is your eye evil because I am good. So the last will be first and the first last for many are called, but few chosen. 

[02:07] **Sonya:** Here endth the lesson. 

[02:09] **Henry:** What translation was that? 

[02:10] **Sonya:** That's the new King James version. I love the poetry of the King James version, but the new one is definitely a little bit easier to understand, I guess, to a modern reader. In the original King James, they say a penny instead of a denarius. So there's also some like translation update stuff.


#### Come to the table: God's generosity

[02:30] **Sonya:** But this parable in particular really resonated with me right now. Because it's sort of on the face of it, unfair, right? Like you have the people who work more, who put in more hours, who were as they complained there during the heat of the day. 

[02:45] **Sonya:** And then you have the people who got recruited much later and who haven't put in as much effort and the landowner. Who is unto, what is the phrasing exactly, it's like unto the kingdom of Heaven decides to remunerate them all the same, to give them all the same payment for their labor. And they aren't instantly happy about it. But he says, this is my right and my privilege to decide what to do. You know, you got what I agreed I would give you. And you know, it's my decision to decide to also give these other people exactly what I gave you. 

[03:19] **Sonya:** And within context of christian theology. This serves as a metaphor for salvation, really, that if you're the the most righteous, meticulous person, I don't know, it may seem unfair that people who are not are also saved or also eligible for salvation.

[03:38] **Sonya:** And this is a theme that comes up in multiple parables. You wanna mention the one that came to mind for you? 

[03:44] **Henry:** Oh, I guess another one of these garden metaphors, the parable of the talents, and it was talking about how a master gave a bunch of people a different amount of money and then one of them kind of buried it in the ground 'cause he wanted to keep it for himself instead of using it to multiply.

[04:00] **Henry:** So that's more about like stewardship of your actual money or of your gifts and skills. They're not taking advantage of your potential. So in some sense it's people that could have been more ambitious, where you're like, oh, I don't want to do anything great. But within you, there's potential to do something, but you're kind of squandering that.

[04:19] **Sonya:** There's also the prodigal son. It often circles back to like personal responsibility and attending to whatever your own obligations are. Like, envy. Mm-Hmm. I, I read it as, as warning is probably not the right word. Like a reminder to not the spec in your brother's eye, but the plank. It's such a weird metaphor. 

[04:39] **Henry:** You don't notice the huge log in your eye. That's how bad that you don't even realize your own problems. Also, like self-awareness too of your own sin in comparison to other people. 

[04:48] **Sonya:** Mm-Hmm. Yeah. I've always really liked. This aspect of, of how it works, I guess, that everyone is eligible. No matter where you are in life, you can come, sort of come to the table.

[05:00] **Sonya:** The landowner is very generous and as you said, this is a persistent metaphor across various parables like the garden or the farm context, where God is the landowner, is the person who sort of oversees all of it, but you also have responsibilities in terms of how you engage and what you do with your labor. 


#### Orthopathos: a change of heart

[05:21] **Sonya:** And how you feel about it. I think that's one of the things that's really challenging about Christianity is that it's not just about right behavior or you know, striving to act the right way, but there's also an internal aspect in striving to feel. Oh, feel the right way. It sounds so restrictive and it, I mean, it kind of is.

[05:41] **Henry:** Yeah. I think sometimes we make it more palatable to people, but there's a asking of you to be different. It's not purely an external thing. There's a change of heart that results in external behavior. Only doing the external behavior is the example of the prodigal son. 

[05:58] **Henry:** If people aren't familiar with the story, in essence, there's a younger son that kind of takes the inheritance of the father and he loses all the money. And then at some point he comes back to the father. 'cause he feels like maybe I can be his servant at least. And the father kind of like runs, he's like looking for him every day and he welcomes him back and he has a whole feast.

[06:18] **Henry:** But then the older brother was the one that was doing everything right. Every day he would do his labor, all that stuff. But then his true colors show up when the younger brother comes back and he's not happy that there's that party for him. And so clearly he was doing it for a different reason. Right? He is like, how come you didn't give me a feast? 

[06:37] **Sonya:** Yeah, and this also recalls another metaphor that Jesus uses, I think multiple times, is that of the lost sheep, that you have a flock and you know, you here kind of standing in for Jesus himself and you're happy that all of your sheep are there. But if one of your sheep wanders off and falls into a crack, or is missing. You're going to want to go look for that sheep, and you're going to be really overjoyed when you find it. Or if the sheep comes and wanders back, you're going to be delighted, that your lost sheep has returned. And I think the point being that, you know, the other members of the flock are not less valuable per se. It's just really exciting and wonderful when someone who is lost returns to the fold. 

[07:20] **Henry:** Yeah, I mean, even that behavior can seem weird if we're thinking more utilitarian, right? It's like, oh, it's just one sheep. I have 99. Do I really need another one? Or whatever. And I think that shows that God is a personal God that cares for each person, at least in this scenario. 

[07:37] **Sonya:** That's perhaps one thing weird to modern readers. I mean, we're so immersed in a kind of like lay utilitarianism where like we do things because they're useful, like ROI incentives and I think all of that is real and to some extent useful. But I mean, it's really clear reading the Bible that you know, God is not utilitarian.

[07:58] **Sonya:** Jesus is not utilitarian. It's pretty explicit that like the things that happen on Earth are. Important. You know, it's important to approach your earthly life with care. Because you are preparing for your next life, your life with the God. 

[08:14] **Henry:** And then you see that in the example of Jesus himself, right? Just his life, how he lived it. The contrast between, you know, giving these kind of sermons on the boat. It's like a one to many, kind of like a equivalent of a Twitch streamer at this point. But there's also him meeting the woman at the well and people that no one wants to talk to. He does both.

[08:32] **Sonya:** Yeah. And especially with healing, I think, at least the translation that I'm reading. Always puts it as, you know, he was moved with compassion. It's like he meets someone individually. It's almost like the love flows out of him. 

[08:45] **Henry:** Even that itself can seem weird. Mm-Hmm. Why would God feel something? Whatever our assumptions about who God is, you know, when we kind of read that stuff.


#### Freedom and Responsibility within the Body

[08:53] **Sonya:** It can be sort of tempting to look at it as like, oh, God is huge and remote, and we're all sort of like ants or like fingernail clippings or something. Something where it's only an insignificant part of the whole body. I think of ants because I think we tend to look at ants as like not really individuals. They're kind of part of the whole. The larger apparatus, but the Bible says that, no, that's not at all how God looks at humans. That each of us is precious and important. Like you said, it's a personal God. 

[09:24] **Henry:** And the body of Christ. The eyes can't do what the feet do. That kind of thing. 

[09:28] **Sonya:** Circling back to the responsibilities, this is another thing that really resonates with me and that I think really, really does encourage people to grow and both be more righteous, but also I, I think it does pay off in terms payoff.

[09:44] **Sonya:** Gosh, I don't wanna use that language, but I lack another. Um, it benefits you as well, I guess I will say, to have both responsibilities and forgiveness. Like Jesus is very demanding, but also very forgiving. But as you said, Jesus talks to the lepers, Jesus talks to the prostitutes, to the foreigners, people who are outside of the chosen people and doesn't.

[10:09] **Sonya:** He at some point verbatim, instruct his disciples to go to the Gentiles as well. But overall, there's both a high standard of behavior and of internal feeling to which you are, you know, called to live up. At the same time, if it's a struggle, like it's okay for it to be a struggle and it's okay for it to be a work in progress.

[10:32] **Sonya:** You know, all of these things are debatable 'cause there's definitely an element of interpretation, but that's how I read it. I, I really feel that, that there's an emphasis on personal responsibility on improving yourself and focusing on that. Which is not to say that you shouldn't encourage others and sort of be in community with your fellow Christians and with your neighbors in general.

[10:55] **Henry:** That's an interesting point to bring up. 'cause a lot of criticism, some people have of say, American Christianity, is that maybe two individual at certain points. But I, I think it's both that we want to emphasize like interdependence, right? We have our own walk, but it's not alone, right? Mm-Hmm. At first we have the Holy Spirit in us.

[11:15] **Henry:** Which is kind of amazing. If Jesus says, I'm gonna send my helper right. We have God in us to help us. And also we have our fellow people that we are walking with on, on this journey and, and you could bring up discipleship where I can't force anyone to do anything, but I can help them grow. Going back to the garden metaphor, I can plant the seeds right?

[11:37] **Henry:** But God is the one that makes the growth happen. Just like you can't make the plant grow faster, you can only make an environment such that the plant will grow at all. That's related to like parenting. 

[11:48] **Sonya:** I think of what Jesus says is the primary. What are the foremost laws? You know, what is the most important thing?

[11:54] **Sonya:** And he says to love God and to love your neighbor. And in particular, loving your neighbor as yourself. That's a really tall order, and if you think about what it means to love other people as yourself, that's a lot. It's really a lot. I, I agree that it's very much worth striving for. I don't know that I ever feel like I really achieve that.

[12:17] **Sonya:** I do try maybe in moments. I think there are moments where I do genuinely feel that kind of love for other people. And when I feel moved to help other people to the degree that I help myself, but it's rare, you know? That's a big ask and I guess, I think it's an appropriately big ask. You know, Jesus was right to say that.

[12:37] **Henry:** I think that context was a, Pharisee was asking what is the greatest commandment? 


#### On obligation: asking something of you

[12:42] **Sonya:** Hmm. That's what it is. So something that listeners, I'm gonna review for you, Henry and I, one of the things that we've been wanting to talk about is in the kind of online subcultural circles that I run in, there's been a burgeoning interest in, I guess spirituality, not so much Christianity.

[13:02] **Sonya:** Specifically, although I think there's a definite Christian strain, but in ritual in things that are the non-material realm, I guess both in terms of interchange but also to some extent the supernatural. There are even people who are going in a more like occult direction, but dissatisfaction with, you know, your sort of lay scientific consensus, which is not to say that people are really rejecting science, but it's like looking for more, what else is there?

[13:31] **Sonya:** And for me, that was definitely part of why and how I came to Christianity was part of this questing. I really felt that rationalism was insufficient for a good life. And I still like rationalism. I think there's a lot of value there. I guess for me personally, I feel like it's necessary but not sufficient.

[13:52] **Sonya:** One thing in retrospect is that it doesn't really ask a lot of you, like it asks you to try to be correct, I guess. I don't feel like that's enough responsibility or enough obligation to call people to become their best selves. 

[14:07] **Sonya:** And I think that it's both something that's scary about Christianity. That it involves responsibilities, that it involves thinking about what God deserves, not just what you deserve, and what God deserves from you, and then also what you know, sort of by extension what the other people around you deserve from you.

[14:26] **Sonya:** It's scary because it's a lot. It's hard. I think it's also attractive, you know. I don't think it's really enough for people to not have some kind, you know, like we yearn for community and connection and I think the sort of hedonistic standard where it's just all for fun is not enough.

[14:44] **Sonya:** And I think there's a reason why, you know, generation upon generation of humans have. And I mean, not even just specifically Christianity with other religions too, have sought obligations that both, that bind them together and that bind them to a higher power. What do you think? 

[15:02] **Henry:** Yeah, there's a lot there. Obligation is interesting. Maybe that's really on point, where a lot of religions try to tie what is true with what is moral.

[15:12] **Henry:** And I think Rationalism tries to separate those two things, or don't even bring up that idea at all. Christianity is about saying that truth is a person and truth involves action as well. And maybe that relates to how we conceive freedom, where freedom is free from people telling me what to do. But now it feels like there's a point where you might say like, oh, I want someone to tell me what to do. And that burden that I have of like, what is my meaning and what I should do is too much. 


#### The freedom of the woodcarver

[15:41] **Sonya:** The freedom thing makes me think of. There's a Reddit post that I really like, which is the parable of the wood carver. I'll try to find a link later and send it to you, but I'll briefly summarize it.

[15:52] **Sonya:** What the post is about is a contrast between freedom from and freedom to, as in like external influence or freedom from constraints imposed on you by others and tracingwoodgrains is their username. Used to be a Mormon but is no longer, so this is like in a Mormon context, but it's not very like Mormon specific.

[16:12] **Sonya:** He talks about how you can have this freedom from, but there's, it's also important to have freedom too, which is the freedom of capability. And he gives the metaphor of a wood carver where if you put wood carving tools into my hands, or presumably your hands, unless you're secretly a master wood carver, and I don't know.

[16:31] **Sonya:** No, we wouldn't really have any freedom to do anything with these wood carving tools. So maybe we could like get some chunks out of a piece of wood. The master Woodcarver, who has spent a lifetime using these tools and honing his skill. He has the freedom to make all kinds of beautiful things, useful things using these tools because he's put in the time and he has the practice and that kind of freedom.

[16:56] **Sonya:** The freedom to build, the freedom to act, the freedom to create. But it does depend to some extent on the freedom from being able to choose what you do. But it also depends on having built up your skill, sort of shaping and training yourself. And I think that this is something that. Is definitely part of Christianity.

[17:16] **Sonya:** I think the freedom of the Kingdom of Heaven, perhaps. I don't know that we can necessarily really access that on earth in our mortal lives, maybe, I don't know. It's kind of debatable, but that kind of freedom is something that I think naive utilitarianism doesn't necessarily call you. In the same way to pursuing that kind of freedom.

[17:36] **Sonya:** Maybe that's a little overstating. Things like, I don't wanna say that utilitarians don't do anything, and I think there are utilitarians who feel their moral obligations really strongly like the effect of altruism movement. Mm-hmm is an example. I wouldn't be surprised if there are fair few effective altruist Christians who see it as a kind of natural marriage.

[17:57] **Sonya:** Because, I mean, it's all about wanting to help people. To the maximum extent possible according to a certain definition. And that's always the tricky part is like, how do we define the good? 

[18:07] **Henry:** Yeah, you need negative freedom in order to have that direction where you should go. I mean, that's sort of like the modern predicament.

[18:15] **Henry:** Well, if you're free from everything, what now? That's the beginning of it. Now I can do anything, but I think for most people we don't have a good direction. We're lost. You're in the wilderness, so maybe not anymore, but you go on a plane, you go travel somewhere and try to like find yourself, right.

[18:31] **Henry:** Belonging or something. You find where you're supposed to be in some kind of community. 


#### formative moments of intimacy

[18:36] **Sonya:** Yeah. That also really resonates with me, the idea of belonging. That's certainly how I felt. Coming back to Christianity, just it was like a feeling of everything lining up. Often to me, reality feels very layered and all the layers kind of aligned.

[18:52] **Sonya:** I guess you could call it an epiphany of some sort. It almost feels a little presumptuous to say that I had an epiphany. 'cause to me it feels like a very grand notion and it didn't feel grand necessarily. It felt more intimate, I would say. 

[19:07] **Sonya:** I'm thinking of this specific incident where I was sitting and praying and there was a rainbow. There was literally a rainbow in front of me. Just because it was raining, it was a normal rainbow. But I was looking at the rainbow and thinking about what rainbows signify in the Bible and in the.. I wanna say like the Christian mythos, but I don't mean that in a detracting way. I mean, it sort of like the system of thought.

[19:30] **Sonya:** You know, I felt like I was experiencing God's love, you know. This actually, this was kind of before I had really like committed to converting. I was still kind of exploring, but it was a very formative moment because feeling things viscerally is so important, or at least in my experience it has been, especially for changing my mind about anything.

[19:51] **Sonya:** Having that visceral experience and firsthand.. I'm not very good at learning from other people's mistakes. I only learn from my own mistakes. And it's kind of the same with everything else. You know, non mistakes kind of learning. 

[20:03] **Sonya:** And I did a lot of pondering after that and I, I don't really, I think of God as supernatural. I think of God as supranatural. I was thinking about like, okay, what literally happened when I was having this experience? 'cause I, I had to figure out. What happened? I'm not really the kind of person who can like leave well enough alone with that kind of thing. I had to like dissect it. Or maybe a better way to put it is that I couldn't not dissect it.

[20:27] **Sonya:** And I was like, okay, this is a psychological experience that my brain produced. And then I had this moment. I was like, well, why can't that be God? You know, if God is is all powerful and spans everything, why would that be outside of God's? Capabilities, obviously not. So it was a very formative moment, like I said, and I think going through the pondering afterwards was also important.

[20:48] **Sonya:** It forced me to think about the literal level as well as the metaphysical level. Again, I would go to the layers they feel stacked, where there's like a pattern that runs through all of them. And that experience allowed me to see the pattern. 

[21:04] **Henry:** Yeah, you had this psychological response, but on top of that it's like God maybe used that to show you something, but they're just where you see it, right in the stack, I guess.

[21:13] **Sonya:** And it's also like, why did I have that psychological response? Because I was praying and I was intentionally, I. Putting myself in that state, I was reaching out to God. And you know, I do think we have the biological mechanisms to do this and there's a reason why we evolved that. Like I personally completely by evolution.

[21:31] **Sonya:** I think that's all real. But I think it is also God's work. I guess I don't see any contradiction there. Like God set the starting conditions and in some sense is the starting conditions. Mm-Hmm. From which we eventually emerge. And I, I think God is the reason why humans have turned out the way that we are designed us in his image as the Bible says.

[21:54] **Sonya:** I guess as science has progressed, our conception of what that means, or I guess how that manifests in a sort of like biological material sense has changed. I. I don't see the original idea as any less legitimate than it was like, I think they were right. I guess the ancients like figured it out pretty well, and then I think Jesus came and completed the figuring out, and here we are.

[22:15] **Sonya:** That's my. Attempt to unify, you know, our sort of material history and our science with what the Bible teaches us and with the continuing practice of Christianity teaches us. So that's another thing that's really beautiful. It's the, the apostolic church, you know, it passes from person to person all the way back to Christ when he was here on earth.


#### integrating with tradition, Christian art, Kanye

[22:37] **Henry:** Yeah, that might be an appealing thing too, regarding like ritual, right? Not to mean that old things necessarily have to be right or or good like the Lindy effect where old things that last longer will last even longer. But there's something that is unique to any old religion where like seeing hymns that other people have sung for thousands of years, that's like pretty amazing.

[22:59] **Henry:** Some people are trying to turn back to like old. Ways of doing liturgy and worship. The opposite is taking the content of Christianity or the message, I guess, and putting it in the medium of whatever happens to be popular at the moment. Livestream, church, pop worship music. Which is all good, but.. 

[23:16] **Sonya:** The like youth pastor stereotype. 

[23:18] **Henry:** That was done with the intentions of getting people into the message, but we're separating the form and the content and I realized that those forms has its own message that might tie better to Christianity than trying to do the opposite. We're losing something about kind of adapting to the times. 

[23:36] **Sonya:** Yeah, I guess I, I have a sort of both perspective on that. Like I think that, yeah, it's important to sustain and revive the, the older way as. That have kind of fallen off.

[23:48] **Sonya:** But I also like, I really like Kanye West and actually some of Kanye's more recent work has been specifically Christian music. Right. But you know, in like rap form or kind of both rap and gospel, like he weaves it together. That's good too. You know, there is something though where it's like you want it to be.

[24:07] **Sonya:** For lack of a better word, authentic, because it feels like there's a difference between kind of like grafting it on and kind of like trying to make it, it's like a, how do you do fellow kids thing? Like is it being used as like a marketing technique or is it a, this is the form through which the spirit flowed?

[24:25] **Sonya:** I don't know. Yeah, and maybe it's kind of presumptuous to say that You could tell from the outside. Maybe a better way to put it is that there's definitely some Christian art that I feel really resonates with me and it feels sincere and it was meant to come in that form and some, not so much. Maybe that's just my aesthetics.

[24:43] **Henry:** Yeah. I don't want to say that we should go back to a certain way. It is just like, how do we. Truly understand the new forms, but then also really understand what is the Christian faith and how do we kind of really relate the to it culturally. We have to understand both and and be aware of that. A lot of times we just like to tack on things, like you said, and it doesn't really work for christians or non-Christians.

[25:06] **Sonya:** There are so many beautiful old monasteries and old cathedrals, some of which still have services or still have people living there who are keeping the faith. And I find that really beautiful and I, I agree with you that it's not like old things are like automatically good, but there is still the things that have survived through the ages. So for a reason by some mechanism, like there's something there, like they wouldn't survive if there wasn't some like there, there, and it's worth going to look for it. 


#### Archaic on the outside, Alive inside

[25:37] **Sonya:** Christianity itself could be looked at from that lens. Something that can seem kind of quaint and archaic from the outside, but from the inside it's just as fresh and alive as ever. I think. 

[25:49] **Henry:** We kind of touched on that last time. The experience you have, it really is a whole new world of like the history of all these things and assumptions that we had about it on the outside that became more.. Not even clear. In some sense, it could be more complicated, right? Now I understand that this stuff is a lot more deep than I thought. Yeah. 

[26:06] **Sonya:** Oh, that's definitely how I feel. I mean, it's been wonderful. It's been really, it's been exciting, you know? And there's a rejuvenation. 

[26:14] **Henry:** I think if you're not a Christian, it could be like an academic exercise, like, oh, I just want to learn the history or something. But no, you're evoking awe and wonder. If you are like super rationalists. A lot of people get that from the cosmos, right? Like, Mm-Hmm. Seeing that there's a lot out there, that there's complexity in the world and that gives them wonder. But yeah, a lot of times we, we just like to reduce everything. Hope that it's like legible to us. 

[26:37] **Sonya:** Mm-Hmm. Christianity is so particular like, you know. 

[26:40] **Henry:** Yeah. 

[26:41] **Sonya:** Some very specific tenets. There's specific beliefs, especially around like Christ himself, who he was, the nature of Christ. That can be kind of offputting to people, that it is both, I don't even wanna say unscientific necessarily, but it's not like justified by math, right? Like you can't like do a prove a theorem that you know says Christianity is true or something.

[27:04] **Sonya:** You have to decide like this particular thing. Yes. It's like you find a way to say yes without having I, I don't know, like a double blind experiment or something. 'cause it's not that kind of thing. I guess it would be like trying to, trying to say that some historical event is like proofed by math or something. It's like the wrong kind of evidence. 

[27:24] **Henry:** That's, I mean that's what faith is. Sort of why I feel like that kind of apologetics was just already admitting that we failed. Like our lives should be the argument for Christ in some sense actually. 


#### Fruits: the form of faith

[27:34] **Sonya:** You shall know them by their fruits. That's another line that I've been thinking about a lot. And that's also like a garden. It's an orchard metaphor. 

[27:43] **Henry:** Yeah. And that question is what are those fruits? And if we are the tree, are we a isolated tree or are we grafted into the tree that is Christ? And how does that relate to like all the people around us? 

[27:56] **Sonya:** And he also points out in keeping with the body metaphor later, this kind of tree has this kind of fruit.

[28:02] **Sonya:** So that kind of tree is this other kind of fruit. And then, you know, there are also forms that don't have fruit. I mean, it's form and function. Again, what you are sort of the shape determines what comes out. 

[28:13] **Henry:** Especially modern people, it's mostly about the efficient cause, like cause and effect. But the formal cause is actually about form. 

[28:21] **Sonya:** As in like having to do with like shapes and morphology.

[28:24] **Henry:** Like why does that matter? It's just like the shape changes what happens. 

[28:28] **Sonya:** The why. And the why is something that really just can't be scientifically answered, or you can answer it on a sort of efficient cause level. You can't answer that why on a formal cause level with science, really. 

[28:43] **Henry:** The final cause would be like the purpose. Right? That's the other thing. Nothing has purpose, it just does it, right? 

[28:50] **Sonya:** It's something that people really want, like this crisis of meaning is something that people have been talking about a lot. There's like something missing in our culture. And I guess I think what's missing is God.

[29:01] **Henry:** Sarah of Ribbonfarm had a post like ambiguity as meaning, something like that. A lot of meaning comes outta the fact we don't know specifically. 

[29:09] **Sonya:** Yeah. It's so hard to talk about this because I feel like, and maybe that's a feature, not a bug, that it's hard to talk about talk. It feels like language doesn't really encompass it.

[29:19] **Sonya:** It's like trying to talk about what happens inside a black hole, you know? Mm-Hmm. Like, it just completely breaks all of our. Things like causality disappearing or time inverting, it just doesn't match with sort of the way that we typically interact with the world and all the intuitions that we have built up about that.

[29:38] **Sonya:** I think a lot of like theology and even liturgy is trying to kind of bridge that gap in a different language from our everyday kind of lay language. And it's not even, language doesn't go far enough. It's like a different ontology. It's like a different, this is the structure of things. So I, I would go again to like Jesus not being a utilitarian or not being like even consequentialist necessarily in a straightforward way.

[30:06] **Sonya:** It can kind of jar with our intuitions, right? Where it's like you do stuff because there's a benefit I. Which is not to say that there are no benefits, but that's not the reason why you do it. 

[30:16] **Henry:** Well, that can't be the first reason. 


#### Auras: acceptable woo and phenomelogy

[30:18] **Henry:** I was reading a book called In The Vineyard of the Text, and it's also by Ivan Illich. A lot of murals and paintings in like cathedrals, they have those halos on top of the saints heads, right. And it's like that gold color that like glitters when you're looking at it. And in this passage it says that the painter. They represent the world as if all beings contain their own source of light. Light is imminent in the world of medieval things, so basically everything gives off its own light.

[30:48] **Henry:** It says you feel that if their luminosity were extinguished. What is in the picture will not cease to be visible, but also cease to exist altogether. But for us, we, we know we're shining a light on things that exist. If there's no light, obviously those things still exist. But in that world, like the way they put it makes it look like all things have their own light and they're giving off light to our eyes.

[31:10] **Sonya:** Makes me think of, I can't remember if we talked about this before. There are people who see auras and you know what exactly they're seeing or like what produces what they're seeing. I don't really know. Mechanistically, I'm sure it happens in their own brain, but that is not a reductive thing to me.

[31:26] **Sonya:** I guess I feel like everything we experience, to some extent happens in our own brains, but I don't think that that means that it's not real. Where am I going with this? 

[31:35] **Sonya:** Just that when you were talking about halos, it made me think of people seeing auras. I guess my thought on that is that I don't think they're seeing something that's not there, per se. Right. I think they're seeing something that most of us don't see in that way.

[31:49] **Henry:** Yeah, the new age thing would be like, oh, they're getting officer and energy. But then normal talk people are like, oh, they have this vibe, right.

[31:56] **Sonya:** Yeah, it's interesting there. There's like accepted woo, and then there's like woo that's kind of out there. But if you look at it closely, a lot of the assertions are similar. Maybe it depends on how many people experience it. Like almost everyone, I think. Feels some kind of like vibe, you know, it's like the mood of a situation or somebody else, but not everyone has like a synesthesia of like seeing it in like a colored light kind of way.

[32:22] **Sonya:** I don't see either of those as like less legitimate than the other. I just see them as different. Now I'm thinking, what else is accepted? Woo. I feel like that'd be a fun thing to try and figure out. It's kind of invisible by nature. It's like part of our folk psychology of how things work. 

[32:36] **Henry:** I think like the feeling you get within the first few seconds of talking to someone, you're like, oh, we could be friends. People say that all the time. Mm-Hmm. That's normal. And you can't really describe that either. 

[32:44] **Sonya:** And there's like this sort of rationalist, like scientific impulse. Still deconstruct it and break it down into like, okay, well you're looking at their facial features or you're picking up on cultural markers and stuff.

[32:55] **Sonya:** And I don't think that's necess, I don't think it's wrong, but I guess I would call it again, insufficient. I'm big on phenomenology. I really like the sort of the experience and beingness happening. This as a way of exploring the nature of things. Our sensing apparatus is so powerful. It's super powerful.

[33:16] **Sonya:** Intuition is amazing. Instinct is amazing. I, I guess I do see those things as sacred. They're emanating from our spirit in some way.


#### Sacredness as a mode of being

[33:25] **Henry:** To see the sacred in what is secular or what is normal, and I think that's something that I'm trying to understand better too. Even as Christians, you might try to think that certain things are more holy.

[33:36] **Henry:** Anything can be sacred in some sense, but you don't wanna take it too far. I think there's two extremes, right? It's like one is like there are specific things that are sacred and the other thing is that everything is sacred to the point where you don't even know like anymore. 

[33:50] **Sonya:** I think of sacredness as almost sort of like a mode. Or like a way of being? So I guess the way that I would try to sort of unify those is that like certain acts, certain experiences pull you more strongly into the sacred mode, but I do think it is present and accessible for most, maybe all of our lives there are, say the Christian dissidents who got sent to the Gulag in the Soviet regime.

[34:20] **Sonya:** You know, the Gulag is like a prison. Labor camp is not what you would normally think of as very sacred space, but if you are enduring and resisting and keeping your faith, there's something very sacred in that, despite the setting. And that's a very extreme example, but I think that kind of like mismatch between the sort of superficial what's going on and then what is going on inside is, I don't know. It feels significant to me, I guess.

[34:49] **Henry:** I like that. Some other people that I know have a lot more interest in meeting in person, even though we can't, so we are kind of doing this sort of mini house church thing outside, and all that means is getting together and doing a church service on our own, right? You pray, someone gives their own little sermon, do some worship. That's where I feel like God is there. You know the whole, where two or three people are gathered, God is with us. I feel a lot more edified and fulfilled doing that then like listening to the last few months of livestream church. Even though we have a lot more people there, we have this whole production, but the fact that it's normal activities and normal people, something about that can be its own sacredness. Right. 

[35:31] **Sonya:** Yeah. I think that's really beautiful. Ah there. I mean this came up in our earlier conversations, we're embodied, we are flesh and those things are important too. Being together in person, even if it's not like normal, you know, I'm sure like you guys took precautions. You're not like running up and hugging each other. Presumably I wouldn't judge, but you know, probably other people would, but it's important. I don't know. It's important to be with each other, which is not to say I think it's good to do the virtual stuff also, but it's not the same.

[36:03] **Henry:** We could have had this podcast in person. 

[36:05] **Sonya:** Yep. Have you done any podcasts in person? That would be interesting. 

[36:08] **Henry:** Yeah, I have. It's 'cause I went to their city basically. I remember I did it with Nadia, like I was in San Francisco. Or she came to New York and we did it. 

[36:16] **Sonya:** Did that feel different from other podcasting?

[36:18] **Henry:** Yeah, in a way because. Well, you're more aware that they're.. When you're doing it online, you know that they're listening and looking, but it's different when you're in person. Yeah. You're also not aware because I can be more comfortable with myself, like knowing that the person's right next to you.

[36:33] **Sonya:** Maybe more, not so much in your conscious sensing apparatus and more in your intuition. 

[36:40] **Henry:** Yeah, and just more intimate. Yeah. I can't tell if I'm more myself. Because it is like, you wanna be able to forget where you are and just be in the conversation. In that sense, our minds are almost like, you know, fusing or whatever you wanna call it, during that dance of talking and having dialogue.

[36:55] **Henry:** Actually, I, I think it depends on the person too. You know, certain people actually would rather, you know, do it online. Nadia herself was saying that when she does the podcast, she would rather us not have the video like audio only because it actually helps her concentrate better. 

[37:11] **Sonya:** Oh, that's interesting. Yeah, being on video is something that people have been talking about, like zoom fatigue. It's, it's almost like physically weird. There was something else that I wanted to say about religion that I've now forgotten. Oh, community. Something you brought up earlier. 


#### Communities of praise

[37:26] **Sonya:** We all do have our own path, but community is important.

[37:30] **Sonya:** I think it's a really important part of Christianity in particular. You know, it's an important part of many religions, but we've been mostly talking about Christianity. I mean, certainly there is the path of, you know, like going off to be a hermit in the desert, but I think much more common is to have like a congregation, you know, sort of a community of faith and of praise.

[37:51] **Sonya:** I feel like praise is something that the, like modern kind of secular mind, what is the equivalent of praise for secular people? And I don't know that there really is one? Not like glorification? And I think it can come across as like pretty weird actually without being inside Christianity.

[38:10] **Sonya:** Especially like the idea of.. Say like Job, you know, Job in the midst of his torment. The idea you could go through stuff like that or that anyone could go through stuff like that and then praise the creator. You don't necessarily expect to get anything out of praise, right? That's not really like the point, I guess. Praise coexisting with suffering is like from a utilitarian perspective, weird. 

[38:34] **Henry:** I was reminded of a quote from CS Lewis talking about praise in general, that you said something like, we delight to praise what we enjoy and who we like because it doesn't just express what we like, but also completes the enjoyment. It is it's appointed consummation, so telling people that you like them, it's a good thing for you. We praise people all the time. Our friends, celebrities, people that we like online, you know, we go out of our way to tell them like, good job. Why wouldn't we do that with God of all people? Right. 

[39:04] **Sonya:** I like that. That's a great quote. It's like a fulfillment. 

[39:09] **Henry:** It's the end of it. Going back to this whole like, we can't help but want to praise God. Yeah, and I think that is what glory is. It's like when you see something that is glorious, you have to tell someone about it. You're gonna just shout it out. You're gonna tell yourself, wow, this is amazing. 

[39:24] **Sonya:** That makes me think of how nature is sort of awe-inspiring in its own right, but it also helps people, including myself, connect with God that the mm-Hmm. Yeah. And I love the way that you put it, that it's so wonderful, how could you help but, say something. 

[39:38] **Henry:** I think in the quote he was saying, that there's like an author that you like and you just need to tell everyone how amazing this person is. And another one he said was a good joke. That goes back to the chief end of man, is to glorify God and enjoy him. So that ties together what our purpose is and that we actually want to do that. 

[39:53] **Henry:** It's not like, well, why does God want us to tell him how amazing he is? Isn't that like a megalomaniac. The only reason why this is okay is because he deserves it. Why would I wanna praise someone that doesn't? 


#### One can't help but laugh

[40:05] **Sonya:** I really like a good joke also because it's like asking, why did you laugh at a joke? You know? And there's a sense in which you can sort of dissect that. But really the reason is because it was funny. So it's like the same thing with God. It's like, why would you praise God? Okay, I can deconstruct some reasons, but the main one is because he is glorious. 

[40:26] **Henry:** My friend Justin showed me this essay called A World Without Laughter, and it's making equivalent faith and humor. Basically a sense of humor is like having a sense of faith.

[40:39] **Henry:** And the story is these other people don't know how to laugh and I guess the government or some company they're trying to like make us and no one laughs 'cause they think it's bad. So they make pills and take people to hospitals to try to get rid of it. And then people create their own little places, basically church, to do that on their own. But other people are trying to audibly make those sounds, but they don't actually feel it. And they're like, oh, that's not how it works. 

[41:03] **Sonya:** Actually. I feel like that helps with the, how can this coexist with suffering, right. Or how can you, you know, feel for the terrible situations that other people are in and still glorify God.

[41:13] **Sonya:** And I love laughter as a way.. Like gallows humor is a thing, right? Like when you're in the depths of despair, humor can be one of the things that sustains you. Mm-Hmm. And I think it's similar with faith and with glorification, that it's not an impulse that goes away because of those circumstances. And it's not a mode that is like turned off. 


#### cheap grace, coming prepared for the wedding 

[41:34] **Sonya:** Yeah, I wonder are there many Christian dissonance throughout history? How did they endure? And I think that's one of the ways. 

[41:41] **Henry:** Yeah. I wanna learn a little bit more about Bonhoeffer. I don't know if you're familiar with him.

[41:45] **Sonya:** No. 

[41:46] **Henry:** Dietrich Bonhoeffer, he has two books that are pretty well known. One is called Life Together, about community. And the other one is called The Cost of Discipleship. Hmm. I, I think the first two words in that book is Cheap Grace, and he was talking about how we basically tape grace for granted in that sense. And I actually, we were talking about obligation that grace, even though it is free from God, that it's.

[42:08] **Henry:** Something we don't deserve. It is something that does require us to do something right after it's given to us. There's a responsibility, and I guess not taking on that responsibility is the insult. Mm-hmm. To the grace that has been given to you. 

[42:21] **Sonya:** Yeah. Oh, that reminds me of another parable. The one of the wedding, or I'm, there are multiple wedding scenarios. Yeah. 

[42:28] **Sonya:** But the one I'm thinking of specifically is there's a man who, I think it's his son, he wants to hold a wedding for, I'm not positive, but he sends out his servants to invite people to the wedding, and the people don't wanna go to the wedding and they treat his servants badly, and I think they kill one of them.

[42:44] **Sonya:** I'm misremembering the details, but the gist of it is he tries to invite people to the wedding. They repu the invitation. So he is like, he tells the servants, all right, well just go invite anyone, you know, just go and go out into the countryside and invite anyone you come across, and they're welcome to come to the wedding.

[43:01] **Sonya:** And so a bunch of people who get invited are all excited and they get all dressed up and they come to the wedding. And you know, it's all good. But then there's another guy who got one of the invitations and he comes to the wedding and he is not dressed up, he's not like excited for the wedding. He's just kind of like showing up maybe for the free food or whatever.

[43:17] **Sonya:** And the host is like, Hey, why are you not ready for the wedding? Why are you not all dressed up? And the guy doesn't really have an answer. He is like, um, I don't. And the host roses him out and casts him out into the outer darkness. So there's wailing of gnashing of teeth. And that, I mean, it's, that's harsh.

[43:35] **Sonya:** It's very harsh. But I think it is, at least my reading of it, is that it's about this, do you come prepared? Do you come ready to celebrate? Are, are you transformed? Are you just responding to the invitation or are you really becoming a guest? Hmm. I guess that is another obligation, you know, to treat it with the sincerity and with the, the seriousness that it merits.

[43:59] **Henry:** You come as you are, but then once you have encountered Jesus, our life is that process of continual transformation to become like him. 


#### A vibration throughout the whole stack

[44:09] **Henry:** And I think the wedding metaphor is really good. Actually, in the House church thing, I really appreciated my friend that was trying to do this mini sermon thing.

[44:16] **Henry:** He talked about the different wedding, basically Jesus's first miracle, which is the Cana, so his. Mom was like, can you turn the water into wine? So that was his first miracle. And why was it at a wedding and why was it turning water into wine? And he also talks about how Genesis, in some sense, is a wedding, right?

[44:34] **Henry:** Adam and Eve. And at the end, in Revelation, when we're in heaven, that is also depicted as a wedding. The wedding feast of when everyone comes and we're all eating bread together, right? Same with communion. Hmm. So that's a interesting parallel of like the beginning and the end. And this part, and I guess our lives is a preparation for that wedding feast.

[44:55] **Henry:** But the metaphor is that the church is the bride. Right. And Christ is the groom. So that's the other wedding and the, the church needs to prepare to, to go to heaven. Right. It's just cool to see that throughout and, and I don't have a point with this, but like just trying to tie in all these thoughts that we had around gardening too in the beginning was the gardening the Eden with the fruit.

[45:16] **Henry:** I. And then he pointed out that the water into wine is really interesting too, because when we go to heaven, it's not just a repeat of the past. We're not just going back to a garden. It's a transformation. It's a redeeming of the old. We're gonna go to a city like the garden to city. And then water into wine is interesting because it's not just like water, but like wine is the refinement of fruit, which is also in the garden. So there's like whole nother parallel. 

[45:42] **Sonya:** Yeah, this is like one of the layered nesses. Layeredness. There's another word for that that doesn't sound ridiculous that I'm not remembering. Stratification, I guess. But that has a whole different connotation. But oh, I just love how it resonates. It feels almost like a vibration that goes through the whole stack.

[45:59] **Henry:** Hmm throughout the whole story. 

[46:01] **Sonya:** I love that. 

[46:01] **Henry:** It's really easy to pick out random things here and there, but how does that relate to the whole thing? It is a part of something that spans the whole time. And I really like the point you made about Christianity being particular. I used to think that's not really a big deal, but I think that's kind of unique to comparison to say, in my experience, of like Buddhism, right? Hmm. It's very abstract in some sense. It doesn't even matter who said it, like the truth could be out there somewhere. But with Christianity it's kind of saying the opposite. I, I mean, there is compatibility there, but truth is contained within the person of Christ. And that he was an actual person at a certain time and a certain place. 

[46:39] **Sonya:** Yeah. That specificity, I think it, it, it makes it very hard to accept in some ways, but it also.. Once you're inside of it, is is also part of the power of it? 

[46:50] **Henry:** I think so. Especially the phenomenology part of it. The story itself is personal. God is personal. And it makes it look like reality is personal and that the way I should live my life is very relational. 

[47:01] **Sonya:** And there's a chronology, you see this also in the before Christ and then ano Domini. It was very much understood that way. It's like it transforms history. And history is pretty like material and specific as well as transforming the spiritual realm. I mean, you can see it on the material level also. Christianity is pretty historically important, even from a secular perspective.
