---
title: "The Dorean Principle (Conley Owens)"
season: 4
date: "2022-08-24"
time: "29"
description: "Why is Christianity so commercialized? Conley shares about The Dorean Principle, his new book which explains this biblical concept of the Gospel being 'freely given'. We talk about being a colaborer vs. a customer, reciprocity vs. gift, Bible translation, Christian music, copyright and creative commons, and how it all relates to an open source ethos. (recorded in October 2021)"
episodeLink: "c079064c"
embedUrl: https://share.transistor.fm/e/559898a7
sidebar:
    order: 1
---

### Links

- [The Dorean Principle (html book)](https://thedoreanprinciple.org/)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-4/dorean.md)

#### Supporting Ministries with Co-Laborers

[00:00] **Henry:** Maybe we could start with what is _The Dorean Principle_?

[00:02] **Conley:** So, _Dorean_ is the Greek adverb that means freely. Jesus said in Matthew 10:8, "freely you've received, freely give". Or as the ESV says, "you receive without paying, give without pay". And then immediately after that, Jesus goes on and say, a worker is worthy of his food. So it's a book about how ministry ought to be supported, but not by exchanging the gospel for money as so often happens.

[00:26] **Conley:** People wanna charge for biblical counseling. I was at a conference a few weeks ago where the presentations that were gospel oriented, they wanna charge you 14.99 to watch the live stream. There's just all kinds of examples of people exchanging the gospel for money, as opposed to having it funded by _co-laborers_ rather than customers.

[00:46] **Conley:** Now, the connection to open source is if you think about the way copyright is used by Christian ministries, it's often used to secure funding. In addition to that, even if it's not used to secure funding, it's used in a way that places an obligation on the one who receives the message, right. To say, you can't distribute this, or you can only modify it in these ways et cetera, et cetera, right.

[01:13] **Conley:** And so it places obligation on the hearer, rather than truly being offered freely. So the implication is that, if this principle is correct, if ministry ought to be offered freely, and not given with reciprocity, expecting something in return, then it ought to be offered with a free license, provided that someone is conscious enough to think about licensing.

[01:38] **Henry:** Basically what open source is.

[01:40] **Conley:** Yeah, exactly. So it doesn't necessarily have to do with the process of development and other things that open source frequently involves. But given that some ministry comes in the form of software, either accountability software, prayer apps, or Bible study software. If you're gonna offer these things under a free license, might as well be open source in the fullest sense.

[02:01] **Henry:** This applies to so many other things, basically all content.

[02:05] **Conley:** Right. And that was kind of a big moment for me. Well, when I first got involved in open source, thought that was really cool. And then I discovered that people were applying free licenses to content also and realizing this was just a much broader issue. So yeah, it's about content in general.

#### The Modern Publishing Industry

[02:22] **Henry:** Maybe we can go through.. why do you think Christianity became so opposite of this I guess?

[02:29] **Conley:** So it is worth pointing out that, yeah, I'm not claiming that the church has gotten this wrong for so long and I'm now showing everyone what the Bible really said. I do think the church relatively followed this for a long time. There were periods of distraction. The whole Reformation was primarily started over in the sale of indulgences, right? And so Johan Tetzel, I forget what the exact jingle he would sing was, but "every time a coin in the coffer rings a soul from purgatory springs", something like that.

[03:00] **Conley:** This catalyzed the largest change in Western culture. So there have been times when, things have gone asstray with this, but I think, primarily for our own time, it's just happened the past few hundred years with the advent of the modern publishing industry.

[03:17] **Conley:** So how do you define the modern publishing industry? I don't know. I guess a lot of people would put a lot of emphasis on the Gutenberg press, things like that. But the way I think about it is, the more things have advanced, the more the physical product of a book and the content have been easily divorced, right?

[03:37] **Conley:** So it used to be when you were selling a book, you were primarily just selling this physical resource. It wasn't necessarily the content, the gospel that you were selling. It was this physical item that had limited supply. Now, when you offer a book, a lot of times you'll sell a Kindle version separate, and it's obvious that it's the content you're charging for, not the paper. The paper now is very cheap, it's the content that's expensive. Whereas it used to be the other way around. And so it's becoming more and more clear that what's being sold is the content.

[04:11] **Conley:** And as the publishing industry has gone that way, the church has just sort of blindly followed not questioning sufficiently whether or not this is going against the biblical ethic, because there was never such a need to define the biblical ethic well before things like the sale of indulgences. That's kind of in your face. It's obvious something's wrong with this, and there wasn't a need to define exactly what was wrong with it, right. Or to define the nuances of where is the line between peddling the word and not peddling the word.

[04:43] **Conley:** And now we have more of a need for that. And I think that's what this work was born out. If you think of all the councils of the church and things. Why didn't I see it happen? Well, there was finally a need to define in what sense is Jesus the son of God.

[04:59] **Henry:** There was an assumption or that was just part of the culture. This is what we believe, but then some people believe differently. And then that's when you have to kind of say, oh, this is actually what we believe more explicitly.

[05:11] **Conley:** Right. Once there's more serious, violations of the biblical pattern or the biblical teaching. That's when you need to define things more concretely. And that's what I'm trying to provide.

[05:21] **Henry:** What would you say to.. Whenever I tell people I'm doing open source, they're like, how do you make money? They'll just say that it's not viable or we have to charge for something. Why would someone give back without..

[05:31] **Conley:** Sure. Well, first of all, like you already know.. Wherever there's a demand for something there's money for it. So the idea that someone can't make money while offering freely licensed content is misguided.

[05:46] **Conley:** But as far as the church goes, I mean, the church already has a way of gathering funds and that's the week to week voluntary contribution of the saints. I'm certainly not saying that the worker isn't worthy of his wages, that ministers shouldn't be well provided for.

[06:01] **Conley:** It's just once again, that should be coming from co-laborers not customers. Yeah and there's more creative things we can do too, things like Patreon or Kickstarter where, people can provide, the minister or the content creator or the, Christian software developer with funds, so that he's able to do this work of ministry without having to charge the recipients of ministry in some reciprocal fashion.

#### Co-Laborers vs. Customers

[06:25] **Henry:** How would you define co-laborer versus customer?

[06:29] **Conley:** Yeah. So that's a very good question. One way to think about it is obligation, right? So who is that person obligated to? One who, gives to the minister out of a felt obligation directly to him is very different than one who gives out a felt obligation to God.

[06:48] **Conley:** So for example Paul says in 1 Corinthians 9, he likens the whole act of funding ministers to how the priests received their money and goods in general. The Lord said of the priests that he was their inheritance. And what that meant was that they received the ties and the offerings and sacrifices.

[07:07] **Conley:** Now we all know that when people were bringing the sacrifices, they weren't sacrificing to the priests, right. They were sacrificing to God. And so that makes all the difference in the world right? It's the difference between idolatry and right religion.

[07:20] **Conley:** Hophni and Phinehas, the sons of Samuel, they took the sacrifices directly rather than waiting for them to be offered to God. And so that would be a good example of an old violation of this principle, where they were considering the people directly obligated to them as opposed to being obligated to God.

[07:39] **Conley:** Who the felt obligation is to? Is it to the minister or is it to God and then via God indirectly to the minister? It's whether or not the obligation is immediate or mediated.

#### Beyond Reciprocity: Contribution Matching + Family Worship

[07:52] **Henry:** How would you interpret this as someone that isn't Christian?

[07:55] **Conley:** So yeah, I've thought a lot about that. And most recently I was thinking about it in the context of, employee contribution matching. So for those who don't know, I'm both an engineer and a pastor. So I'm kind of handling this from both ends, deciding as the employee do I go through this program and as the pastor, do I set this up so that other employees can give to the church this way.

[08:18] **Conley:** And so this is hard because.. Is my employer like a real co-laborer? A lot of things they stand for are quite contrary to what the Church stands for. And in what sense, could we receive that? Well, the dichotomy I set up in the book is between reciprocity and co-labor right? So first of all, this is obviously not reciprocity, right? It's not that they're giving an exchange for something else.

[08:43] **Conley:** Something else that kind of helped me think through this too was family worship. So a long tradition in the church prior the past century was for families to worship God together every day. And this is, one of the distinctives in my church. My family does worship God every day together.

[09:02] **Conley:** And as a Baptist, I don't believe my, children are necessarily regenerate. I don't believe my children necessarily have status as a Christian unit. They're not baptized. And yet I think it is fine for them to worship God with me, right. Even though the younger ones who don't believe rightly, may not yet be offering right worship to God, right. I still think that this is a good thing for them to do.

[09:25] **Conley:** That kind of opened the door to understanding how a non-Christian could give in a way that would still be considered right co-labor. So I'm not sure if that's the best way of thinking about it, but that's where my thoughts have gone recently.

[09:39] **Conley:** But there are a lot of texts in the old Testament that would give you reason for pause about that. For example, Abraham refused, money from the king of Sodom. There's actually just a lot of instances of the people of God refusing, funding from outside entities. Now I would say that's largely in line with this principle, they're rejecting reciprocity.

[10:01] **Conley:** However, it's possible too that they're saying this isn't right co-labor, because you're not one of us. But I don't know. Anyway, this is, one of the more finer points that I haven't worked out.

#### False Teachers are also Greedy Teachers

[10:12] **Henry:** Where can we go with this?

[10:14] **Conley:** Sure. Well, maybe I could just read through the chapter titles. So kind of what I go through in this book is I start off in the first chapter with what Christ said about this. That verse I mentioned in the beginning, Matthew 10:8-10, where he said, receive without paying and give without pay.

[10:30] **Conley:** And then, I have a lot of chapters on Paul's theology. Paul, there were some important topics like the Lord's supper where he only wrote half a chapter on, but ministry fundraising was something he wrote on constantly.

[10:43] **Conley:** And then I talk about false teachers also. A lot of people imagine it as a Venn diagram where they think that, you've got these greedy teachers and you've got these false teachers and there's some overlap between the two, but you could be a greedy teacher without being a false teacher. And you could be a false teacher without being greedy teacher. And I think the picture the Bible paints as they are one and the same. Basically, this principle is supposed to be the means by which we detect whether or not someone is, sharing the true gospel.

[11:08] **Henry:** When they're preaching the gospel, but then they're doing in a greedy way, the greediness is not the gospel. So they're still being a false teacher.

[11:15] **Conley:** So the Bible seems to from my reading of it. It seems to picture a false teacher as always having.. Well necessarily he does always have some ulterior motive, right? If he's not sharing the truth, it is for some ulterior motive and that can be kind of summarized as greed and for his own gain. And the way the Bible most frequently pictures this as only doing this in exchange for money. Money's kind of just to stand in for any kind of personal gain, but money really is the prototypical kind.

[11:47] **Conley:** As it is now, this principle isn't firmly understood and held, it can't function that way as this discerning factor to know whether or not a teacher is teaching truth. But it could be if more Christians began to embrace this.

[12:01] **Conley:** There are other things, I go through just relevant things in the New Testament. I go through, the early history of the church. There are documents like the Didache written in the first century and other things, other extra biblical writings in the early several centuries where people very clearly, even quoting some of the verses I've been mentioning. It's clear that someone cannot teach for money or else they're a false teacher.

[12:24] **Conley:** Yeah and then after that I get into just what does this practically mean for us? What does this mean for church ministry?

#### The Copyright Milieu of The Bible

[12:31] **Conley:** And then the last two chapters are about copyright. And it's funny because that was kind of the agenda of the book the whole time.

[12:37] **Conley:** I feel a little deceptive, because most Christians who read this, I don't think they have any idea as they're reading it that that's gonna be the big application in the end, is copyright, but really that was my main goal in writing it.

[12:48] **Conley:** I've had thoughts on copyright ever since college, when I got involved in open source and began growing discontent with the way ministries were using copyright for the sake of gain. Just kind of had that on my mind as I was reading the Bible and began to see some of the relevant texts and was able to think of them in that grid of how it might apply to copyright. I began realizing that this was more than just a personal preference I had. This was actually what the Bible was saying about obligation about ministering freely. And there was a real solid application to draw here and not just a wishy washy this might be the wiser way to go.

[13:25] **Henry:** Can you talk through how that applies to like Bibles and songs? I don't think most people, whether you're Christian or not, think about the translations and the copyright.

[13:35] **Conley:** So copyright runs deep in Bible version publication. It's a shame how deep it runs, but it goes all the way to the manuscripts themselves. So there is court precedence that says that a mechanically reproduced copy of a public domain work can't be copyrighted.

[13:54] **Conley:** But still it is the case that museums and other places that own physical manuscripts of the Bible, those manuscripts from which we create the versions that we have, they assert copyright and the institutions digitize them, whether or not they agree with that assertion, go ahead and comply with their requests and don't publish them on the web just so that they can keep working with those institutions. So a lot of these manuscripts are not accessible to the public.

[14:22] **Conley:** They're only accessible to someone who's a part of one of these organizations that are willing to pay. Now I'm not saying that you can't trust what the Bible says, because it's all hidden by some Illuminati cabal or anything like that. The scholarship is more open than that, but it's not as open as it ought to be.

[14:37] **Conley:** So this goes all the way down to the manuscripts itself. Then from the manuscripts you have what are called critical additions, where people take the manuscripts and they look at variants. Maybe someone spells one word differently and that.

[14:48] **Conley:** And so which one do you go with? Well, there's a lot of different things to consider. How many manuscripts? Which manuscripts do you value more? Which ones seem to be older? Things like that. And you put it all together and then you write down a critical edition, which is like, this is the Greek or the Hebrew text that we're going to go with.

[15:05] **Conley:** And so then people copyright the critical text and whether or not that's something that's creative enough to be copyrightable there.. Once again, there's court precedent about these kinds of things, but it's not clear to me if an arbitrary case were to go before a court, which way it would go. It's probably worth pointing out. I'm not a lawyer, this is just me speculating.

[15:24] **Conley:** Anyway, so then you have the critical additions being copyrighted. And then beyond that, someone translates one of the critical additions. And, now you have a modern Bible translation or a version. And these are also copyrighted.

[15:37] **Conley:** And there are some versions that a lot of people think are public domain that are not public domain. For example, the King James Version, not public domain. No, yeah, so it's under the eternal copyright of the Crown. So the Crown eternally owns the copyright to the King James Version. Now they don't enforce it outside of the UK, but in theory, they could because of international copyright law. So it's been administered by a couple of different organizations. I think the current one is Cambridge, but if you're in the UK and you wanna publish you want to print KJV Bibles, you actually have to get permission from Cambridge, I believe.

[16:13] **Henry:** Wow. Especially if it's the Bible itself, it does seem like it goes against the whole thing. Wouldn't everyone expect that.. I feel like if you were learning about Christianity.. A non-Christian be like, why wouldn't the Christians care about this more, but it seems like always been that way. That's so sad.

[16:30] **Conley:** Once again, it's very easy to justify these things if everyone else is doing the same thing. Oh, well this is an important work. We need to make sure it stays funded. This is the way you keep it funded. So I have some sympathies given that people haven't seen a lot of other models.

[16:46] **Conley:** I'm hoping that this book gets some readership and then maybe I'll have less sympathy after people have had a chance to consider these ideas. But as it is, people haven't really considered there's a serious alternative to all this. I hope they do.

#### The Oddity of Christian Music Licensing

[16:59] **Conley:** So you also asked about music. Yeah music is another thing that's very odd. There's this organization called the CCLI, right? Oh, I forget what that stands for. I think it's Christian Copyright Licensing Incorporated, something like that. Anyway most churches pay some yearly fee to CCLI in order to display worship music. So either streaming or printing it out, things like that.

[17:24] **Conley:** But what's interesting about all this is that US copyright law also already has provisioned for religious entities. That in the course of a worship service, they can display perform copyrighted works without violating copyright law.

[17:38] **Conley:** So it's not clear to me what exactly the CCLI is providing. Is it for the streaming? Does that count as being part of the worship service? I guess that's kind of debatable. Is it for printing? Well, I mean, that's kind of part of displaying. It's not clear to me.

[17:54] **Conley:** Once again, I'm not a lawyer, but I don't know what value CCLI is really providing other than trying to make sure that the artists that are get funded. They all have churches. Hopefully those churches recognize that this is a ministry they provide and would want to support that ministry as opposed to trying to get money from every other church who benefits from it.

[18:16] **Henry:** Right. I guess the question is.. I don't know how much money they're getting from that. And how much is it actually going to the artist versus the organization? And then if their music's gets popular, they're probably having like concerts or something.

[18:28] **Conley:** Right. And the CCLI, it provides so little it doesn't give you the right to rearrange the tunes or anything. And if you think of Creative Commons hopefully some of the listeners are familiar with Creative Commons. It's kind of like still giving you a non derivative license. It's very locked down.

[18:45] **Conley:** And once again, I'd love to see the Church change in this area. And this is also true for, for hymns. A lot of hymnals have been written within the time span of copyright law. So they're still under copyright and a lot of times they will have very small modifications of the original lyrics of the original tune. So that now you've got a new copyrighted work. And even though that song is hundreds and hundreds of years old, it's still considered copyrighted.

[19:12] **Conley:** And I don't know of this personally, but I heard this from a lawyer friend, there was a case of some very old public domain music just classical music. And someone had copied it and was distributing it. And there were typos of where some of the notes were set. And so the original republishers of this work that they had copied from claim that those typos, those accidents, were creative additions. And so their work not actually the public domain work, but, but one that was then copyrightable and tried to enforce copyright on that. So yeah it's crazy what people will do.

[19:47] **Henry:** Ugh. Why do I want to think about any of this. It's like.. Not that we shouldn't be thinking about.. It just limits like people's ability to express themselves and maybe one way of doing that is to modify songs or the text.

[19:59] **Conley:** Right. It limits people's ability to do that. It also provides a _chilling factor_ for where things are legal, but people don't know whether or not okay. Well then on top of that, you have many people who are paid to deal with these issues.

[20:13] **Conley:** So the time it sucks out of people is.. Whenever I think about just how much time has been lost how many people's daytime job revolves around copyright law or how many people..

[20:26] **Henry:** Every streamer and YouTuber might get copyright striked.

[20:28] **Conley:** I mean, my own job revolves around copyright law and in an ideal world my job wouldn't exist kind of the way it does, you know? Yeah, just to think about how much productivity is lost, because we decided that this would be the structure where we would promote creative works seems counterproductive.

[20:43] **Henry:** And I guess the interesting thing to think about is if we gave up that control, would it be worth.. I mean, I guess we're saying it's worth it.

[20:51] **Conley:** Yeah, I would say so. I mean, certainly in the case of the Bible. Like for example, Christians thinking about the KJV. Like I said, it's technically copyrighted, but in the US practically it's not.

[21:01] **Conley:** I've talked to people in charge of Bible versions and asked them to to use a freer license. And a lot of them have said no, primarily because they don't want someone to tamper with the text. But if you think about the King James Version, Joseph Smith has its own version of the King James version. Thomas Jefferson had his own version where he erased the miracles of Jesus and things like that. Like you have all these versions that a lot of Christians wouldn't be happy with, but at the same time, I think far more good has been done by KJV being practically freely available.

[21:34] **Henry:** I guess it's similar to like free speech discussions. Little bit different, but kind of this fundamentalism about not allowing your kids to see things. Like Harry Potter is about witches, so it's like from the devil, that kind of thing. In this case, it's like allowing this to be free brings a possibility of someone corrupting it and then that might influence people.

[21:53] **Henry:** And then we need to make sure that it's controlled. And I guess it's like the control itself is the problem. Of like not letting it go out there. There's a possibility of it failing and people doing whatever they want..

[22:06] **Conley:** Right. Yeah. There are two ways to think about one is the pragmatism. Well, what's the, the better end and like you and I are saying, yeah, I think the better end is if these things are free.

[22:16] **Conley:** And then secondly, there's the more fundamental rights aspect of it does the copyright holder have a true absolute right, even outside of the construct of the government to control their work.

[22:28] **Conley:** I would say no, given some of the reasoning and that Thomas Jefferson quote, what I was talking about, natural law. That God has set up things that are real inalienable rights. And the right is not the copyright holders as though this were physical property. The right is anyone to whom the idea comes because once it has entered their head, it is now their idea as well.

[22:50] **Henry:** Yeah, no, that makes sense. Feels very intuitive in the internet age where it's like, it's already so open. Like websites, you can look at the source code, you can copy it. The remixing of anything like a video or like on TikTok or music. And then also like fan fiction, right. They're technically extending something or they rewrite it. The death of the author, like does it even matter who wrote it if we want to claim that it's ours now. Feel like that kind of sentiment is already in the air.

[23:21] **Conley:** Sure. Yeah. It earlier. I think I do think attribution is important, but but yeah there doesn't seem to be enough to be gained by insisting on control. And beyond that, I don't think that it is actually the right of the creator to insist on such control.

[23:36] **Henry:** Yeah, I guess when people are pretending to be that author, that's different from forking

[23:42] **Conley:** Yeah, that's a problem!

#### Personal Bibles

[23:44] **Henry:** Going back to Bible translations, because you brought up like Jefferson had a Bible. What do you think of like personal Bibles or even encouraging people to kind of, I don't know, not change it or anything, but like kind of change it in way that makes sense to them. And then there's also this whole thing about like machine learning and like, what if you had a Bible that was like for you.

[24:03] **Conley:** Before I answer that question, it's probably worth saying that there are a few free versions that exist. So there's the ASV, the American Standard Version that's from the early 1900s. And then there's also the WEB version, W E B. So that's more recent.

[24:17] **Conley:** And for those who don't know, there's probably two main kinds of Bible translations, one that's based on Byzantine texts and one that's based on other, other texts. So anyway the WEB is based on Byzantine texts and the ASV is based on other kind of critical additions.

[24:31] **Conley:** So, anyway, yeah, it's interesting that you asked that question because I've been trying to update the ASV myself. I've been doing this for like eight years. I mean, very slowly. A few words here and there, but changing all of thees and thous, that kind of stuff.

[24:47] **Conley:** I study a lot of commentaries as a pastor. Whenever I discover a translation this year or whatever I do try to if I think it should be different I update that too. I'm not an expert, so I don't know.. I'm not sure in what capacity I ever wanna share this.

[25:00] **Conley:** But yeah, I think for a student of the Bible who understands some translation issues, it would be worth having your own kind of personal addition where you've kept notes and "altered" some things.

[25:11] **Conley:** Now, the Bible says a lot about changing its words. So if it's doing it to go, not just beyond the intention of translators, but beyond the intention of the original author, I don't think you're doing anyone a service. But yeah, I do think there are some legitimate reasons to have your own kind of personal translation.

[25:29] **Henry:** Maybe there's a word and you want to use the original Greek or something instead, because that might help you understand it better.

[25:35] **Conley:** Yeah. Like every time you have the word love to actually insert like agape and philia or whatever. People tend to be interested in that kind of thing. Which version of love is this? That would be interesting.

[25:45] **Henry:** Otherwise you would have to learn how to use or even know that exists the whole Strong's concordance, those kinds of things. The average person has no idea, but it's like what if you made it simpler? It's not that like everything has to have a synonym, but it's kind of cool, this is kind of a more deeper word than English provides. And it maybe helps you to learn Greek or some other language so you can appreciate better.

[26:08] **Conley:** Right. Yeah. But then, and then it's worth pointing out, but with most modern versions, you would not be able to do that and then publish it. So that's worth thinking about.

#### Given Without Price

[26:17] **Henry:** Maybe we could end with like what's a takeaway for someone that might not be a Christian?

[26:22] **Conley:** Sure. So that's a very good question. What's the takeaway for someone who's not Christian, but finds this interesting.

[26:28] **Conley:** So I have been sensitive about talking about this, cause in a way it's kind of like exposing a lot of the dirty laundry of current state of Christianity. Yeah, I mean, I wanna be transparent at the same time. I don't want to.. I mean, that's not my main agenda, to draw attention to like the messes we have in the church at the moment.

[26:47] **Conley:** But yeah I would say that forgive us for for where we've, gone wrong and tried to, charge you for offering you the gospel. And that that's obviously not what Jesus promoted or Paul or any of the apostles. Yeah, and I hope that as this is adopted the Bible's more freely available and that people have more access to it.

[27:06] **Conley:** And yeah, if someone's listening to this and not a believer, of course, the, the main thing I would want them to think about is just to consider the words of the new Testament, that Jesus Christ was offered as a sacrifice to pay for the sins of the world.

[27:19] **Henry:** I think pointing out the problems, especially in this case.. I guess it helps explain what it's all about in the first place?

[27:25] **Conley:** I guess there's a more serious tie into the gospel. So if I can just read like part of the conclusion, of the book.

[27:30] **Conley:** The prophet Isaiah describes salvation as water that is offered without money and without price, Isaiah 55:1. In the gospels, Jesus explains that he is the source of that living water, John 7:37. On the final pages of Scripture, John records the repeated assertion that the Lord offers this water freely, Revelation 21:6; 22:17. As we consider the relationship between money and ministry, there's nothing less at stake than the proper advancement of the gospel of Jesus.

[27:58] **Conley:** So the gospel.. It's offered freely and that's kind of what makes it distinctive from what's offered in many religions of the world, right? By your own effort, you earn righteousness, but Christianity is unique in that what it offers is entirely free. And that needs to be reflected in how the gospel is promoted. If Christ is offering it freely, then his servant that's a messenger should not be then charging a premium.

[28:24] **Henry:** Right. Pointing out that that's been lost, it is promoting the whole point in the first place.

[28:30] **Conley:** Yeah. So this is not just one arbitrary thing about how ministry is done, but it is reflective of the gospel itself. That valuable thing that has been offered, without charge.

[28:39] **Henry:** Thanks for this conversation. I've given a talk about like why I do open source and I bring up the same verse about freely given, freely received. So it's like kind of cool to see this applied to the faith.

[28:51] **Conley:** Well, thank you, Henry. I've appreciated it.
