---
title: "Digital Communion (Nick Ripatrazone)"
season: 4
date: "2022-08-29"
time: "52"
description: "Can our digitally mediated environment be spiritual? Nick Ripatrazone takes us through the lens of the Canadian philosopher Marshall McLuhan, focusing on his not well-known Catholic faith. McLuhan himself describes his testimony into the Church as, 'I came in on my knees. That is the only way in.' We discuss the topics around intertextuality, the complexity of life, on form/function within mediums like poetry, concept/percept, ambuigity and paradox, and McLuhan's famous phrase the medium is the message. (Recorded April 2022)"
episodeLink: "973ef0a1"
embedUrl: https://share.transistor.fm/e/a8b7e0d4
sidebar:
    order: 4
---

### Links

- [Digital Communion (book)](https://www.fortresspress.com/store/product/9781506471143/Digital-Communion)
- [Nick's site](https://nickripatrazone.com/)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-4/communion.md)

#### Layers of Language Meaning

[00:00] **Henry:** Thanks Nick for joining me for this chat. I was just explaining to you my background and how I work on this project called Babel. And it translates JavaScript, which is a language in the browser, to an older version of JavaScript. 

[00:11] **Henry:** So it's like in this backwards compatibility, because you don't even know what browser the user is using. But yeah, programming language translation.

[00:19] **Henry:** And then you were saying that maybe _James Joyce_ has something to do with that. 

[00:24] **Henry:** Don't know a lot about him. I just heard, and even from your book that, he's really difficult to understand.

[00:32] **Henry:** And I know that also, maybe a disclaimer, is that as an engineering background, I hated english and history and all these things, but then now I'm finding myself wanting to go back and do all this liberal arts stuff as an engineer. 

[00:44] **Henry:** Not that I don't wanna learn engineering anymore, but it's just like, that stuff just seems more important to me now, which is funny.

[00:50] **Nick:** Yeah. I think James Joyce was kind of in a cusp of a lot of changes in terms of communication and language and the advent of film as sort of a medium. It's interesting because _Marshall McLuhan_, one of his main theories is the idea of _obsolescence_, which is a little different than something being obsolete.

[01:11] **Nick:** Like when something is obsolete, it's done and it's over, but obsolescence is the process of something going out of fashion or of utility. And McLuhan thought that those are the aspects of life that are the most, I guess, apt for us to study and to understand.

[01:30] **Nick:** James Joyce, as a fiction writer, was writing at a time where there were changes in the way we think the brain works. And there was changes in terms of how newspapers were arranged, and advertising. And as I was saying about the advent of film. 

[01:45] **Nick:** So I think as a writer, his work has almost like a hyper textual kind of level to it. And if anyone sits down with his book, _Ulysses_, which is like the, almost the size of literally the Bible, and it's probably as inter-textual as that book.

[02:02] **Nick:** That's what I was thinking of when you were talking about sort of translation, coding, layers to language, and pointing us to other things. And I think Joyce was someone who McLuhan was quite interested in for that ability, to have levels to his work, kind of both literal and metaphorical. 

[02:23] **Nick:** And that's like you say, he's kind of inscrutable for that reason. And I think that's kind of what appeals to me about him, because it is sort of a game to enter into his world and to try to deconstruct it and then find those like keys to read him.

[02:42] **Henry:** So when you use the word inter-textual, you're saying this is of multiple levels of meaning, but also references in between each other?

[02:48] **Nick:** Yeah. I think, I mean, the Bible to me is such an incredible text in terms of it's narrative modes. It's linguistic moves. It's mixture of symbol and metaphor and poetry and history. It's just so much going on. And it's often described in reductive ways. And yet it's just a heavy text.

[03:15] **Nick:** And I feel like with Joyce, I remember my copy of Ulysses in graduate school. I bought at a used bookstore in Newark. I went to Rutgers Newark. So it came pre annotated for me, but I didn't know if the annotations were correct or not. 

[03:30] **Nick:** And I liked that kind of interaction with that mysterious other person who had the book before me. So I had to both read the book kind of on my own, but then try to deduce whether they were right or wrong. And in that way, it even expanded Joyce's kind of strangeness with his intertextual method.

[03:48] **Henry:** That's really cool. Maybe getting an old copy of a book is way better than getting the new book, because it's like, you don't even know who that person is and you you're like having a conversation with them in some sense.

[03:57] **Nick:** And I think, when we think of like the Bible as a text, even if we get a new copy of it, we're getting something that for the Old Testament through _Midrash_ and through engagement with exegesis of other parts of the Bible. Like it's just a text that has been so encountered so often over history. I feel like that spirit kind of lives in it.

[04:20] **Henry:** Yeah. I do like how people describe it as the book of books, right. As different genres. 

#### Bible as Hypertextual Medium

[04:26] **Henry:** Maybe this can get into our discussion about McLuhan's _the medium is the message_, right? Let's take the Bible. When I think of a Bible in the modern context, it's a dictionary, it's a reference book versus a different way of thinking about it would be. 

[04:39] **Henry:** Even my pastor was talking about like a few weeks ago, about like a contemplative way of reading the Bible. It's not about getting information, but about like soaking in like whatever God's trying to tell you or something. And you might even think that there's a better kind of Bible that would be appropriate to that. 

[04:56] **Henry:** I know that recently there's been a lot of effort into like reading Bibles. A lot of Bibles, they have the two columns. They have all the verse numbers and chapter numbers. And then this one looks like a normal book. There's only one column and then there's just a chapter. And then there's nothing in between. 

[05:12] **Henry:** And I think that it seems like copying that style, that would lead you to want to read the whole chapter in its entirety versus like pick out like random verses cause that you're supposed to read like the verse of the day.

[05:26] **Nick:** In the one that you're describing is there not like footnotes at the bottom of the text? Is it more almost like just the narrative of the page and then there's no notation. 

[05:36] **Henry:** Yeah. It's like very plain in a way. It's just straight up, this is the text. There was a Kickstarter called Bibliotheca. The whole draw of this was like, let's get rid of all this.. I mean, you could call it excess or whatever, but like all this other stuff.

[05:49] **Nick:** That's so interesting to me because when I think of when I was like first kind of introduced to the Bible in the sense of literary study of it. And I still have, I don't know where it is in the house, but like my Catholic study Bible that I got when I was younger, like half of the page is footnotes.

[06:07] **Nick:** So, it kind of got me thinking that it was always a text that you would bounce in and out of. Like, you would go to the scripture, but then you would go to the exegesis commentary, the contextual information. Like you say, the book of books, like it sent you to other places, which is what I feel like when I'm online.

[06:29] **Nick:** I'm not going down like a corridor, I'm going into like this open field in a way. But it sometimes feel like claustrophobic, especially like on Twitter. I can go to a lot of places quickly, which I guess is pretty similar to my encounter with the Bible.

[06:44] **Henry:** Now that we have hyperlinks, right. You click and everyone says you go down the rabbit hole, right, on YouTube or whatever it is. And both of those are valid. But if I'm feeling sad, then I'll read a verse about sadness, which is fine. 

[06:56] **Henry:** Maybe that would prevent me from reading the whole thing or going into more depth, because having it on your phone, I just pull up the app and it just tells me, read this. The opposite would be not being able to relate to either people in your own community or people online.

[07:11] **Nick:** Yeah because we're talking about Joyce. I mean _Finnigan's Wake_ is even more.. I don't feel especially confident wading through that book as anything more than just like trying to stay afloat.

[07:23] **Nick:** I don't feel like I'm swimming with any true skill. It's more so I'm just trying to figure things out, whereas Ulysses is a little more decipherable. And it is beautifully written in certain places. In other places, I think it's meant to be obfuscating a little bit, like it's just meant to push us away. 

[07:42] **Nick:** I mean, when I read the Old Testament, I feel tired. I feel like it's like I'm in the middle of a snowstorm. And then when I read the New Testament, there's like this razor kind of clarity that happens. So it's interesting to have that experiential kind of result.

[07:56] **Henry:** Right, a lot of people feel that way. You know, I feel like a lot of old Testament is like a lot of history. And also, I mean, they're all in the past, but I almost feel like that the New Testament just feels more relatable. Like there's a lot more letters writing directly to people, or just literally what Jesus says and that just seems like good advice versus in the Old Testament. There's a lot of like suffering in war and a lot of negative things.

[08:21] **Henry:** And I think a lot of people dismiss that because they're like, well why would that be in the Bible? But it's just depicting reality in a way, you could say. Like if there was none of that, it would be kind of weird if it didn't, because we have that now. And that's what we had before.

[08:36] **Nick:** Right, exactly. And there was so much at stake. The drama of the narrative, it feels like strangely, profluent and natural that it went that way, leading towards the New Testament.

#### Embracing the Messiness of Everything

[08:47] **Henry:** Yeah. I've never read any of Joyce before, but I think the examples you put in were interesting about the way that Joyce would structure his sentences, tried to reflect literally the content that it was talking about, right. I think there was a dog wagging his tail and then the words kind of looked like or felt like they were even doing that too.

[09:09] **Nick:** Yeah. I think it was on the beach in Ulysses. When a lot of people imagine language and it's function, I think for a lot of people it's communication. And communication, a derivative of it being expression, like how we feel. 

[09:23] **Nick:** So therefore we want to tell someone how we feel and we seek clarity because either we think that clarity means accuracy to how we feel or so that the recipient kind of understands it. 

[09:35] **Nick:** But I think what Joyce, as a writer, kind of demonstrates is, as you discuss, that what we think is clarity and accuracy is sometimes neutering the messiness of everything. So I think Joyce sort of recognized a lot of discord in life and even in like domestic situations, just like a lot of frenetic kind of things. 

[10:00] **Nick:** And so therefore in his language, especially in a book like Ulysses, it's almost like we're looking at this kind of like Cubist representation of something. Like it at first looks like it's all over the place, but then we're sort of allowing ourself to see the world through his eyes. 

[10:16] **Nick:** And yeah, that's kind of why I am so interested in him as a writer because I think Joyce was someone who was very, very much trained in the Bible, going to Jesuit schools and having the Bible as a story, as a intellectual text, as something as part of his existence.

[10:38] **Nick:** It's impossible to imagine him as a writer without his religious background, which I think is true for a lot of the most kind of stylistically intense writers around. They seem to have that foundation, which I think speaks to the power of the foundation.

[10:54] **Henry:** I feel like I can't appreciate modern art in the typical sense, because I'm trying to get, like, what is the point? I'm trying to figure out the answer, the solution, whatever. And I feel like I remember reading something from _The Medium and the Light_, about how that is the point in a way. You have to perceive the whole thing and I guess encounter it, feel it. And maybe that's how he saw religion in a way.

[11:16] **Nick:** I think when you use the word perception or perceive, that is a central thing for him. His books are.. They're like mosaics, they're like collages rather than linear texts. 

[11:29] **Nick:** If you watch his appearances on television, interviews, he tended to speak in a recursive, kind of associative manner. 

[11:37] **Nick:** And I think some interviewers tried to like bring him to the more centering discussion, but McLuhan didn't think life or the brain or language work in those ways.

[11:50] **Nick:** And when you mention the medium is the message, which is something that I'm fascinated by as like a cultural saying, because it's something that we've heard a bunch of times and even people for whom don't know who he is.. Like they probably have heard that saying. 

[12:07] **Nick:** I guess it means almost like two things. In the pop culture way, it sort of means like the fact that you and I are speaking right now, we're speaking through a particular medium. And that medium, perhaps its importance as like a tool transcends maybe the minutiae of like what we're actually saying. Like it's more revolutionary perhaps that we're communicating in that manner versus like what we're saying.

[12:32] **Nick:** So I think McLuhan was both okay with that meaning being out there, but also clarified it to say that the medium is a message for him means that the environment, the media through which we communicate, transform us. Like those environments, just like preternaturally like make us different, which to me is like a more religious and spiritual way of reading that saying. That's what I'm most attracted to for him.

#### Incarnational Poetry

[12:57] **Henry:** Yeah. There's a lot there! Thinking about.. Just thinking personally again, I feel like I didn't appreciate what like, say poetry was for in a way. And I realize understanding this phrase better, helps me appreciate it. 

[13:12] **Henry:** Another dichotomy would be like a form and function, right. I think maybe I care too much about function, which would be efficiency of speech. Which is basically acting like a robot. 

[13:22] **Henry:** Versus like in a sense with poetry, it's all form. The whole point is that each word is so important and specific. I can't just swap out random like synonyms or something. 

[13:32] **Henry:** It's sort of like well, why can't I just write out what I actually mean? Why would I care about poetry because you know, I'm gonna translate everything into like machine language, eventually zeros and ones. I need to figure out what is the underlying message, not like this fluffy stuff on top. 

[13:49] **Henry:** But with poetry, you can't really do a translation. And it's funny, I work on a translator. It's like, you can't really translate languages one to one. There are words that don't exist in other languages same thing with poetry then.

[14:01] **Nick:** McLuhan, he grew up generally, I guess, Christian. You know, his family wasn't like ardently Christian, but you know, he went to church. And his mom was a believer for sure. But it wasn't until he read poetry specifically, Gerard Hopkins, who's this really kind of wild, not like as a person, but like sytactically wild, Jesuit priest. 

[14:25] **Nick:** And so McLuhan ended up going to Cambridge for his PhD, but he was riding his bicycle and he had like this book of poems with him. I think he was reading this poem _Pied Beauty_, by Hopkins. 

[14:36] **Nick:** And Hopkins is to me the most like radically innovative poet I've ever read, and was given to me in college by a professor who.. I think she was agnostic. 

[14:48] **Nick:** You know, when I started reading Hopkins, I didn't ask her in class, but I sort of was thinking like, this is the most profoundly religious person I've ever read! He has such a radical way of looking at the world, just like a total incarnation view of the world.

[15:03] **Nick:** So McLuhan was quite drawn to him, and that awakened in him a rather earnest search for faith. So I think that with Pied Beauty, which is a poem about like the kind of abnormalities or unique nature of the world as being the source of its true beauty. That as you say, it can't be almost translated into non poetry, like it has to exist in that kind of metaphysical space of poetry.

[15:29] **Henry:** Maybe that's like, kind of like the definition of poetry in a way, like it's sort of, now that I think about it, it's untranslatable because it is form, I guess. And feel free to to share something from there.

[15:41] **Nick:** Yeah.. My book of Hopkins is right here if I can grab it for a second. This is actually my battered copy of Hopkins from college. It's like falling apart. So McLuhan, what he was drawn to was that Hopkins seemed to.. 

[15:55] **Nick:** He didn't sound like someone of his time, like he was a mid 19th century poet. He sounded like strangely modern and sort of out of place. So that kind of would be consistent with the obsolescence idea. 

[16:12] **Nick:** Do you want me to read one of these? All right. This is _Pied Beauty_.

[16:18] **Nick:** Glory, be to God for dappled things - For skies of couple-colour as a brinded cow; For rose-moles all in stipple upon trout that swim; fresh-firecoal chestnut-falls; finches wings; Landscaped plotted, and pieced - fold, fallow, and plow; And all trades their gear and tackle and trim. All things counter, original, spare, strange; Whatever is fickle, freckled (who knows how?) With swift, slow; sweet, sour; adazzle dim, he fathers-forth whose beauty is past change: Praise him. 

[17:11] **Nick:** So, I mean, you could tell from the last line, praise him. That he has a Christological vision in mind. I like a lot of stuff he's doing, but there's a line that I read where he says, Whatever is fickle, freckled. Then he has like a parenthetical. 

[17:24] **Nick:** And in the parenthesis, he says, who knows how with a question mark, which feels like something that I would do in 2022. And he was doing in like 1878. And like, how could language have like such a direct line, you know? But it does.

#### &quot;Coming on my Knees&quot;

[17:41] **Nick:** So that was what McLuhan was reading. And he's like, wow, this makes a lot of sense to me. And that's what led ultimately to his conversion and sort of his very deep faith for the rest of his life.

[17:53] **Henry:** Yeah. Maybe you could talk about that too. How did he come to faith? And he was like, I came in on my knees. That is the only way in. I was like, dang, that's powerful.

[18:01] **Nick:** Yeah, it's great that you quote that. He was interesting. He was doing a lot of biblical reading and reading of the church fathers for his dissertation. So his dissertation was on Thomas Nash, who was a satirist, actually a really like off the wall kind of writer, like some wild stuff. 

[18:21] **Nick:** And so it might seem kind of surprising that McLuhan who was a quite traditional sort of person in certain ways would be reading somebody who like really pushed the periphery of content. And his interest in Nash was he said that people who are satirists, who use puns, who joke with language are kind of stretching language, like making it elastic and making sure that it can hold onto a lot of meaning. 

[18:49] **Nick:** So that's what interested him. So while he was studying or writing his dissertation, he was reading the Bible deeply. He was reading so many kind of major thinkers. And as you note, that like intellectual element was juxtaposed with this deep personal sort of search. 

[19:09] **Nick:** He wanted to find something, he'd write letters to home and to his brother and saying like, you've gotta get into this. Like, it just took hold of him. So there's this requisite kind of humility, that it was an awe-inspiring thing.

[19:23] **Nick:** Which I think if religion ever becomes something that doesn't inspire awe in people who say that they believe, then it can become a little bit of a simplified exercise, you know? So McLuhan certainly had that as his foundation.

[19:39] **Henry:** Yeah, like a caricature of religion. Another professor was saying the way we can come to faith is through beauty, right. 

[19:46] **Nick:** Beauty makes sense because things that we perceive as beautiful either, there's a sense of pattern. There's a sense of a creator behind them. There's a sense of purpose. And I think people are interested in stories. You know, stories offer us meaning to existence. So all we can find all those things.

[20:10] **Henry:** Yeah. It's funny when we talk about history, we say like his story. There was a thing from Tolkein, On Fairy Stories. But he talks about the idea that God is like a myth, but then through the incarnation, the myth became real. The myth became fact.

#### From Tech to Philosophy

[20:28] **Henry:** Maybe with the internet, you could say that stuff like emojis and memes and slang, are ways of making language. So people are stretching language all the time, and they're lay people. And I think it's same with coding. People are using these syntax in all these different ways. 

[20:46] **Henry:** I feel like there are a lot of people in tech that really like philosophy, they're writers themselves, right. It's just interesting because you might think that wouldn't be the case. There's this like stereotype, oh it's about like math. We're just like kind of creating these separate spheres when maybe they're not that different.

[21:03] **Nick:** If you think back to your edu, when you were studying these things, do you feel like that was how it was presented to you or implied?

[21:11] **Henry:** That's a good question. I mean, even say math itself, .People think that they need to have a certain mindset like stem, like you have to be an engineer. I just don't believe that, anyone can understand logic and systems.

[21:24] **Henry:** Whatever field you end up working in is a system and you know that domain better than anyone else. The cool part is when they're able to kind of figure out for themselves which parts are like related.

[21:35] **Henry:** Like I met someone at church that.. They're really good at jazz piano. They told me that they learned piano during COVID. I was like, how's that? And they had a background in guitar, but I'm just like still, that's like really impressive, maybe two years. 

[21:49] **Henry:** But then he was like, well, you can do it too. And I was like, really?

[21:53] **Henry:** But it was just kind of interesting that in a way improv or jazz is, is a way of going past these boundaries. Music can be messy as well, right. That's kind of what jazz is in a way. It just makes me think that like, that's not that different from writing, right. Just finding even my own life, that's like, wow, we need to be more expansive about this stuff.

[22:15] **Nick:** Yeah. And I think when you're saying your interest in philosophy has grown. I think philosophy for me, is a way to recognize the multiple systems at work in the world and ways of communicating and how as you imply that there's certain structures that we can understand. 

[22:36] **Nick:** So for me, like, for example, poetry is a structure of communication and then fiction writing is a structure of communication and creative nonfiction is.. So like, there's all these different structures. So if we take like a genre approach to the world, I think it unlocks a lot of things. 

[22:54] **Nick:** Because it almost validates that there is a way to play the piano. There is a way to write poetry. And we can study it, but those things are porous in a certain sense. Like they they're open to that freedom. When I wonder why there's such like a delineation between disciplines, part of me thinks that it does come from kind of the desire to..

[23:19] **Nick:** because when we're asked the question, like, what do we want to do with our life? Or what are we doing? Usually, that's a question that has to be answered in a sentence. Whereas in reality it probably would be like a two page essay. Or even like a diagram. A lot of times like people ask me what I do. I answer it depending on the audience to whom I'm speaking. 

[23:39] **Nick:** Like when I have to explain to people in the writing world that I'm a teacher. I tend not to, or I intend not to say it even anymore, because when I used to, they would ask all these like kind of strange questions as follow ups. 

[23:54] **Nick:** And I'm just like, I don't really wanna talk with anymore. So I just kind of said that I'm a writer and editor and then leave the other stuff out. But yeah, I agree with you that people who have tech inclinations or interests, there's I think a pretty smooth transition to the world of philosophy and art. 

[24:11] **Henry:** Well, I guess maybe I wanna do that in a way!

#### In Art, Faith is Perception

[24:14] **Nick:** Yeah. Yeah. I mean, visual art, I feel like knowing that the internet is a thing that exists helps me understand that art better, which is a weird kind of osmosis. Like, for example Dali's creations about Christ on the Cross. 

[24:30] **Nick:** When I look at the rendering of the St. John on the cross kind of vision, like looking down and like there's Jesus on the cross. And there's like the cosmos, like below him. And then looking at that, like Cubist representation of him on like this.. Like levitating.

[24:44] **Henry:** Yeah. Oh yeah. I didn't even know until I like randomly went to Florida for vacation. And then that was one of the museums, having not known about him before. 

[24:54] **Nick:** yeah. And someone with a religious interest, for sure. He was another one of those kind of like _Andy Warhol_ an artist who is so profoundly religious.. The religious element is so foundational that it's almost like we don't even need to say it, you know? And therefore, by not saying it, then people sometimes forget that.

[25:13] **Henry:** Yeah. They're so infused with the religious element. Including McLuhan, he doesn't have to say it anymore. And I think that's the best thing. Like I don't have to tell everyone around me I'm Christian like that doesn't help. Ironically saying it is the distraction, but kind of because that maybe that's the point of the medium is message. I'm just telling them the message literally like I am Christian rather than living it out, right.

[25:35] **Nick:** That's a good way to think about it. I think McLuhan would agree with that concept, as he sort of saw Jesus as like the synthesis of those two things in a way that no one else has ever been, which is instructive, I think too.

[25:48] **Henry:** I think that's like the most mind blowing thing. I read this essay, I think it was _The Medium is the Messiah_. I kept thinking the the medium is the message was the normal.. But maybe it really is a misconception. 

[25:59] **Henry:** He always talks about like concept versus percept. because it's not really about conception all. Right, it's about perception. But yeah, I usually think it's about a container, so it's like the way or the tube, but really like you said, it's environment. That's why he said it changes everything right. 

[26:17] **Henry:** And you know, we reference the verses, the Christ is truth and then later the Word became flesh. So it's like somehow Jesus came here to talk about himself. And he says that I am the way. And he's also the message. Then of course the person that came up with this would have to be like deeply committed to the faith. I don't think you would've came up that otherwise.

[26:39] **Nick:** I mean the global village, which is a thing that he had mixed feelings about its actual presence. You know, on Twitter we see the problematic nature of it. 

[26:49] **Nick:** But he also in thinking about the world in that way, implies a collective or sort of ecumenical consciousness as being something that we should strive towards. Because I think if there's a world of people who believe and they are linked by that belief, even if they're not physically near each other. 

[27:11] **Nick:** Which is kind of what would intrigued him about Latin mass, which was something that in his church and the Catholic church was still up until the 1960s, early 1960s, the universal way of saying mass, no matter where you were, wasn't in the local vernacular. 

[27:31] **Nick:** And to him, that itself was both like an ancient thing, obviously, because of the ancient nature of the language, but also incredibly modern in that sense that you could go to any country in the world and sort of hear the same mass. 

[27:46] **Nick:** So it was like this unifying kind of nature. So yeah, there's just a lot going on. Like you say, like the more that you think about it, it's almost like just below the surface of everything he says is this religious element?

[28:00] **Henry:** So you're saying like, like Latin was the shared language and you can go anywhere. It's the same. And then now it's like, you have it in your own language, which is interesting. because I might say that you could say it's more democratic because you don't have to learn Latin, but maybe everyone did before. That was just what it was like.

[28:18] **Nick:** It's interesting because a lot of like a lot of great American writers.. Fiction writers, and I'm thinking of Don Delo, Tony Morrison, Thomas pension, Cormack McCarthy grew up on Latin mass. They were young enough that it was part of their upbringing. 

[28:37] **Nick:** You know, they were of the age where they saw that transition go from the Latin to the vernacular. And to hear a mass in Latin makes you feel like you're almost like in another world, like on another planet. 

[28:49] **Nick:** And for an artist, like I'm a believer that an artist needs a sense of like dislocation to some extent, you know? You just need to be elsewhere and mystical. And that, I mean, it's almost like a weekly dose of mysticism for anybody, you know? 

[29:08] **Nick:** I go to Catholic mass every weekend, but like I've been to Lutheran services and Baptist and so on and so forth. And I feel like the most acute moments of those services are when it feels like we're linguistically somewhere else. 

[29:24] **Nick:** Even though Catholic mass isn't in Latin anymore, there's still some leftover like syntax that is not the formulation that I would use. Like for example, talking right now or talking later today. That gets kind of consistent with the idea of language being translated into something else for another purpose.

[29:42] **Henry:** One equivalent right now, it'd be more just worship in general. Like singing is different from our normal talking, but it's not that much compared to like Latin, like different language. So I finally actually went to Catholic mass a few weeks ago with someone, because I actually have never been before.

[29:58] **Henry:** And I just like, as a Protestant, just want to know what it's like you know, liturgy. Maybe because it was a 6:00 PM service like, I didn't have a sense of community per se, but I got a sense of very solemn, holiness. Obviously the medium of like the building being beautiful and then the hymns. It definitely felt more like somber, that kind of feeling.

[30:19] **Nick:** Yeah, I think solemnity is a good way to think about it. There's like almost like a melancholic kind of touch to it. I guess if like you think of an artist and the things that tend to generate art for them, those tend to be the kind of sources a lot of Like the contemplative, that sort of like solemn space. And that would be consistent with McLean for sure.

#### Art as the Boundaries of Language

[30:42] **Henry:** How would you or McLuhan define an artist or art generally? 

[30:49] **Nick:** Well McLuhan thought that poets and artists were the key to really understanding what language is capable of, and where we are going with our methods of communication. 

[31:02] **Nick:** So his first book, _The Mechanical Bride_ from 1951 was a study of print advertising, but done with the care that you would apply to like a classic Renaissance piece of art. Like he paid like such close attention and probably like too much attention, he realized, to the nuances of the ads. 

[31:24] **Nick:** And it's weird because what happened was he realized you had to treat each text or work of art on its own and by its own rules while seeking patterns that transversed or went across multiple texts. 

[31:39] **Nick:** So when he kind of ditched print for TV and to some extent, poetry, I think it really opened his eyes to like the performative elements of those medium. So for me I think the essential nature of art is it requires us to step outside, like the norms of communication and thinking and it like kind of reroutes us and refocuses us. 

[32:02] **Nick:** You were just mentioning, I think going to.. What was the name of the museum that you went to to see Dali? 

[32:10] **Nick:** If you know that experience of like, when you go into a gallery, you go to a museum, you have to kind of slow yourself down. It's sort of like the same way. Like when you read a poem, like you have to reroute yourself. So like, I like those moments when people have to.. It forces everybody who encounters it to reassess what these assumptions are about language and communication of thought.

[32:30] **Nick:** So for me, what art does is it kind of takes hold of you and it offers you that other path. And McLuhan knew the power of story, because obviously as a believer, he was drawn to the story narrative form of the Bible, especially the New Testament. So all those things working together, that was his vision, kind of, the synthesis of all those things.

[32:54] **Henry:** I just think about social media and all these things. It's about like scrolling as fast as possible. Literally every second you're looking at some new story or tweet or whatever. 

[33:03] **Henry:** I even saw something the other day, it like fades out the rest of the word.. It only reads like the first letter, because your body will just perceptively read things. 

[33:11] **Henry:** But you would never do that with a poem because that's not the point. And it's also usually shorter anyway. I like that, that art forces you to up with a different way.

#### Satan as a Great Electrical Engineer

[33:20] **Henry:** Okay, when you used the word mystical, what does that mean? And maybe that's.. He talks about the mystical body of Christ, and then maybe how that relates to the global village and the internet, right? You could say it's a corrupted version of the body.

[33:33] **Nick:** Yeah. You know, what really drew him ultimately to be a person of faith was the concept of the incarnation that Christ is everywhere. His specific, I guess, brand of Catholicism is Jesuit influenced, which was also James Joyce. 

[33:52] **Nick:** The Jesuit vision is, they have a saying called _God in all things_ and their approach to the world is.. They're not monastics. They find power in someone being cloistered, but they're very interested in people being in the secular world and finding God in very unusual places. 

[34:15] **Nick:** So for me, that really influenced how McLuhan approached religion. He knew that TV was taking over the world. You saw it happening. He knew that sooner or later computers would do the same thing. And it would be foolish for him to sort of like stand like a thwart these things say like, we gotta stop them. 

[34:34] **Nick:** It was better for him to, as you noted before, to perceive and to document and to describe, and then in those transmutation sort of try to find God present. So for me the Jesuit vision of finding God in all things applies to the fact that if he believed that God was everywhere, that God was in the global village, even in his worst moments.

[35:00] **Nick:** Like, he of course didn't use the word internet, but he thought that with the ability to instantly connect and communicate, that we would not be very good at turning that off or knowing when, to not like, I guess like punish ourself, like through like our equivalent of dooms scrolling and stuff like that.

[35:22] **Nick:** So he knew that we would go there. And of course we do, like all time, like we can't kind of stop. Like he actually wrote to a French philosopher he said something like the _Prince of darkness is like a great electrical engineer_, was kinda like a McLuhan-esque sort of thing. 

[35:37] **Nick:** The danger here is when there's a true disembodiment, like when there's no physical corporal sense. And I think that ties to the metaphor of the mystical body of Christ. Like it's really important of course, for Christians, like the idea of the bodily resurrection. That's essential. Like that there's a physical corporal resurrection and an ascension. 

[35:55] **Nick:** So for McLuhan we have to hold onto our bodies, like our physical forms. That there's a certain ethical underpinning to that. When we move fully to these like disembodied, electronic for him, but digital virtual for us worlds.. If we don't have like a spiritual foundation, that's when things can get really get dangerous. 

[36:16] **Nick:** If I spend too much time online, I'm not happy. And I don't think it's simply just because like I'm not like in the world, like I just feel like there's something about that aesthetic experience that just like can hurt. So McLuhan saw ahead of that.

[36:34] **Henry:** Yeah, I was actually gonna ask about the quote. You already brought it up, that's awesome. There's a longer part of the quote talking about how the things are invisible, right? Which is the environment. In the end, I feel like his thing is about like what changes us and the things that change us are things that we don't recognize, and we need to be aware. 

[36:56] **Henry:** And so the only way to do that is to understand the environment. Andrew McLuhan, his grandson, he sent me an article about environment and anti-environment. And the idea is like we don't know who discovered water, but it wasn't a fish, right. I was like, oh, that makes sense. 

[37:13] **Henry:** So we need to find an anti environment for the environments that we're in. And I guess he's saying that artists are the best people to help with that, right.

#### Authentic Religion is Full of Ambiguity

[37:23] **Nick:** Yeah. And when he had a lot of these ideas, he himself was like in an obsolescence phase, like he was older than the people that he was examining. And people who were younger loved his theories because they were seen as countercultural. Whereas older people just didn't get what he was saying.

[37:41] **Nick:** I would describe him as like a prose poet, almost himself. Like his is writing not linear and it's not traditionally scholarly or academic because he doesn't have footnotes or citations or anything like that. 

[37:55] **Nick:** He was so smart, but he thought in a discursive kind of associative way that it creates like that collage effect. And that allowed him to perceive the patterns that a lot of other people couldn't see.

[38:07] **Henry:** Yeah, it's funny that you can be yourself, and it's just so different from the society that they think it's radical. And I see a lot of people going back to religion in a way, because maybe it's been so long that a lot of people, they've never encountered it. I don't know, like even working on this podcast, posting it, I was very afraid of whatever the perception is or reception of this. 

[38:29] **Henry:** But I've, I haven't had like, basically any negative feedback essentially about doing it at least. I think people listening are not necessarily religious at all, but they think it's interesting just because, trying to tie in topics that they probably never thought were aligned or similar. So that's been really encouraging.

[38:48] **Nick:** And that's great to hear. And I think part of it could be from the fact that authentic religion is full of ambiguity, right? It's full of the unknown yeah, like, so that's the stuff that appeals to, I think, a lot of people, for sure. 

[39:06] **Henry:** Yeah. Going back to the idea of like the world is messy, he can considered himself an explorer, right? He was always talking about probes, which is a word, because I feel like we don't use that word. I think that he's not judging anything. He's not casting his own opinions. He's just saying like, I'm just trying to like, see what's going on. And I feel like people like that, because you're not like you need to be like defensive or something. 

[39:28] **Henry:** Yeah. I guess it's like meeting people where they are, being able to have a shared language. If I use the word like sin or God, like it doesn't mean anything to people anymore. And so maybe we need to use different language so that it actually makes sense to people. So for some people it would be like psychology or psycho-analysis like that kind of language makes sense to people live. 

#### What is Sin Really?

[39:52] A word like sin, is so contextual and layered and kind of presupposes a moral vision of something, if the sin is considered the aberration or the divergence. I guess I'm kind of interested.. What is the equivalent to the word sin for a secular person?

[40:15] **Nick:** I use the word reflexively, like the locution of like a venial sin versus a mortal sin, like that predates my life. That's something really that the Catholic Church uses, but I'll because I come from that tradition I'll use that like in a kind of jocular manner in spaces where I'm not with like Christians. It's a little thing to just like eat too much dessert or something like that.

[40:39] **Nick:** So I wonder what the equivalent is and how they form that equivalent, you know? Cause I think that's an interesting conversation to have with people who maybe don't believe, right.

[40:49] **Henry:** It's almost like it's too general for people. There's like sin of omission, you didn't do something that you should have done and then there's sin that you did something you shouldn't do. There's the idea of like sin as idolatry, taking something good and making it as important as God. The whole like golden mean idea. There's also like more like betrayal, that might be like one way of thinking about it.

[41:12] **Nick:** Cause that's something that transcends the secular versus the.. Like, If I could think of the biblical narrative that could get people kind of thinking about the Bible, it's like the Judas narrative. 

[41:24] **Nick:** There's something so profoundly human about that moment of you know, inviting someone into your space and having that person be the one who betrays you and the sadness that arises from that, like that is just like a human thing.

[41:41] **Nick:** So that could be an interesting way to start like a language conversation as like, how do, how would someone who isn't a believer in a particular God, how do they talk about that level of betrayal? I guess you could say. 

[41:54] **Henry:** And I guess no one wants to bring up those kinds of things, at least personally, maybe about other people because you know, celebrities and stuff like that. But how do we create spaces that people can share.. If I'm struggling through something, you should be able to talk about that with your friends, your family, your church group. 

[42:12] **Henry:** But then it's like, if you don't have that, are you gonna talk about that with your coworkers? Maybe, but I don't know how often that happens, especially with random people, right? Like if think about it, the people in your like little small group at church, I mean they are random people. 

[42:26] **Henry:** And then eventually I would hope it would get to the point where you can do that and, and they can support you. And that's a big part of being in the community, right.

#### Understanding McLuhan

[42:34] **Henry:** But that's why the medium and the message, it is very related to liturgy. It's about like habits and what the effects of our technology have on us. Actually I was thinking of the four ways that media affects us, right. I think it's called tetrad of media effects. 

[42:47] **Henry:** We usually focus on the good things that technology gives us, but how does it obsolete something? Has it retrieved something from the past? I think. And another one is how does it reverse, when it's extreme? I feel like there's so much there because it expands like what you think tech does.

[43:05] **Nick:** Yeah, it's no longer merely a vision of it from a utility standpoint, which I think for someone like myself, who's a layperson in that world. Like I perceive it as what is the utility of this thing? Which is a very reductive way to think about like a human enterprise or experience. McLuhan's vision is more holistic and realistic probably. 

[43:30] **Henry:** Yeah. It's really important because, it's obvious that the church in a way is not really applying what he's saying. And I find a lot of people, Illich included, he was dismissed by the church in some sense. They didn't like what he had to say, though what he was trying to say was deeply important for the future of the church. How do you think that the church should think about applying his thought, and why was it so difficult for people to understand that?

[43:57] **Nick:** McLuhan's I guess institutional encounters with the Church are pretty sad in terms of their outcomes. It was a real opportunity for him. He was on several committees with the Vatican to look at the changing media environment. 

[44:12] **Nick:** And it almost seems like too good to be true that that had happened. You know, and like, it qdidn't work out in part, I think of the bureaucracy, I think because of, they didn't realize how truly a visionary he was. But I think ultimately, the church of his generation was interested in the possibilities of television. 

[44:29] **Nick:** it was the time when, Clare of Assisi became the Patron Saint of TV. She was ill in her convent and wasn't able to attend mass. So she saw a vision of it projected on the wall of her, cloister and she actually could hear it and could see it. And it was like this crazy, just like amazing mystical moment. 

[44:53] **Nick:** And so I think in terms of like a real useful manner of this, the fact that online or digital life is another possible sphere of human existence. Like every sphere of human existence. If the church has the mission of connecting, communicating, and uplifting people, then that has to be another sphere in which it operates. It can't be just like this alleyway that they don't go down and they hope that it just like takes care of itself. because I think we know how well that will work out. 

[45:26] **Nick:** So I think they have to participate in an open-minded way and they have to recognize, that there are a lot of people of faith in those spaces and that they could probably learn from those people.

[45:40] **Nick:** When you talked about thinking of open source in a metaphorical way, like to me, that's exactly the kind of thing that McLuhan would appreciate because you're speaking in that language and you're understanding its form and function. And for people who are non experts, like they need to listen to people who are inhabiting those spaces and understanding the discourse of them. So I would say if they didn't listen to McLuhan, they should probably listen to.. take a second look at McLuhan, you know? 

[46:11] **Henry:** Yeah, that makes sense. I think another thing that I've been struggling with is sort of like what happens when the church embraces technology too much in a way. They're actually not understanding the medium, right? Hey, this is a great way to spread the gospel. 

[46:27] **Henry:** Here's an example. If you just tweeted like a random verse, you just happen to have a lot of followers. But it's like, whether it's doom scrolling or I don't know, baby pictures or whatever, and then you see like, verses, you're not in the right mindset or context. You're not gonna read through that verse and have that actually affect you, in the heart, right.

[46:46] **Nick:** Because I think in the hypothetical example that you've mentioned, the most advantageous thing would be perhaps for that person to put down the phone or to step away from the device in which they encounter that like language that moment of verse and then to contemplate it outside that sphere.

#### Living is Lengthening the Narrative

[47:06] **Nick:** So I think one of the problems, and I think this is something you mentioned before, like the idea of when we analyze tech, we tend to look at utility rather than philosophy of it, is that for me, the ubiquity of the digital experience might lead people to think that if you're not participating in that space constantly, that you're not participating in the modern world.

[47:32] **Nick:** Whereas to me, I think of it almost like drawers in a desk. You know, it's just one of the drawers in the desk of like reality. There's the internet, but then there's also going outside for a walk and there's also listening to music, there's different drawers.

[47:46] **Nick:** You know, if I'm looking through the Internet to find something, I'm gonna then close the drawer go to something else. That is something that maybe societally, we're still trying to figure out. That we don't have to be in that space for everything, that we can extract things from that space and then go in other spaces and seek it out.

[48:05] **Henry:** Exactly. I like that metaphor of the drawer. I guess the problem is that, especially this kind of metaverse stuff is about making it so that there is only one drawer left, that you lose the almost like capability or imagination to believe that you can do otherwise. Almost like an implicit goal in a way, which is weird. 

[48:26] **Henry:** On the other side, people, they make memes about saying like, oh, you need to go outside and touch some grass, you know? Like there's clearly a desire to be offline, and I think that's kind of when tech becomes an institution. 

[48:39] **Henry:** What I got from Illich, he has this phrase called radical monopoly. And instead of a product being the monopoly, it's about the whole concept itself. You feel like you can't learn unless you go to school.

[48:53] **Henry:** Obviously you can learn on your own or talk to your friend, all these things, but then school as an institution culturally makes you feel maybe as a parent, they have to go to school. Or I can't talk to my friend unless I send a text message. I wouldn't even think about sending a physical mail, right.

[49:09] **Nick:** McLuhan would like that example because he would say, okay, so the action of the sending the letter is itself a sequence of environmental experiences, right? It's finding the pencil and the paper, it's the kinesthetic feel of that paper. I know like when I hand write something, it just feels like I'm doing like a lot of labor rather than typing it.

[49:27] **Nick:** So it's like the lengthening of the narrative. And then it's finding like the steps the envelope, the stamp, walking down the street or driving to the post office, going through those processes.. It's all part of like an environmental experience. 

[49:44] **Nick:** And so in that way, the way that we see what communication and with others means is radically different by sending a letter versus sending an email. So when we compound that in everyday life.. I mean, that must be like hundreds of times a day where that occurs. But like you say, because it's so ubiquitous, it's not analyzed. it's just kind of accepted. So McLuhan would say, that's we need someone to pay attention, to see what that does to us. 

[50:17] **Henry:** And that's funny because that literally is the point of all these apps. It's like about making it effortless, non contextual and frictionless. Maybe that's even another better word. It becomes habit. It becomes a part of my body, I guess. When the phone buzzes you, you like open it and look at it.

[50:34] **Henry:** Versus like mail, it feels.. Because it's so tedious, you're probably thinking that whole time, like about other things. I like that a lot of just like finding a random activity and then thinking about all of these different steps that you take to, do that, especially if it's a physical, I guess. 

[50:51] **Henry:** That's the thing like sending an email is still physical. Everything we do is still physical, right? My friend, Michael Sacasas, he was talking about how the digital is not necessarily disembodied in a way. It just makes us forget the body. That another way of framing.. 

[51:07] **Henry:** Like the idea of the cloud, right. It's not actually a cloud, obviously it's machines that are running in some server somewhere in the world and they're taking up resources, right. Where getting materials or Silicon, out of the ground to do that. So they're all there, we're just hiding it. 

[51:23] **Henry:** And that's actually, maybe even worse, it does exist and it's whether it's environmental or societal, like there are consequences to that.

[51:31] **Nick:** I love talking about all this stuff. So I really appreciate the opportunity to talk about it.

[51:36] **Henry:** Yeah, this was a great conversation, and I think very McLuhan-esque in a way, just trying to, explore, right. Like we don't have the answers and we're just trying to like, say what's on our mind.
