---
title: 'Sacred Charity (Austin Chen)'
season: 4
date: "2024-08-28"
time: "34"
description: "How does rationality/ea and faith intersect? Austin Chen joins me to explore the overlaps between Catholic upbringing and EA principles. We discuss his car wash story, tithing/earning to give, the concept of utilons and fuzzies, creating secular liturgies like Taco Tuesday, the tension between being agentic and the savior complex, on rest and waiting, and seeing the uniqueness of each person amidst the systems we create. (Recorded May 2024)"
episodeLink: "5c6ffa94"
embedUrl: https://share.transistor.fm/e/d96dc7b8
sidebar:
    order: 9
---

### Links

- [Earning to Give](https://en.wikipedia.org/wiki/Earning_to_give)
- [Manifund](https://manifund.org/)
- [Purchase Fuzzies and Utilons Separately](https://www.lesswrong.com/posts/3p3CYauiX8oLjmwRF/purchase-fuzzies-and-utilons-separately)
- [OSS lazy-loads governance](https://www.devonzuegel.com/post/oss-lazy-loads-governance)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/main/season-4/charity.md)

#### Jewish Culture and Rationalism

[00:00] **Austin:** I think the EA to Catholicism lens is probably very fruitful. I can start there.

[00:04] **Henry:** Because I assume that most people that are into EA are not religious people?

[00:09] **Austin:** If anything, the religion that is more common among EA folks might be Judaism. There's a tradition of at least the rationalist community coming from people who are Jewish by background like Scott Alexander, Eliezer Yudkowsky, I think have some traditions from this culture. They are people who have written a lot and shape a lot of how the rationalist movement thinks, which then shapes a lot of how the EA movement thinks.

[00:33] **Henry:** You think they're just key figures or is there something about jewish culture that relates?

[00:38] **Austin:** I think there's probably something about Jewish culture. The elevation of argumentation, among Jewish people, debates, proper reasoning, verbalizing your thoughts and figure out disagreement. There's something there. I'm not an expert in any of this. I can probably speak the most my own faith actually. So we'll talk about instead. 


#### Growing up Tithing

[00:57] **Austin:** So, I'm Catholic, I grew up Catholic. Both my parents are Catholic and they raised me in the tradition. and I think that had a pretty direct, line of, causality to how I ended up interested in the ideas of effective altruism. A core teaching of effective altruism is, where you give 10% of your income, if you take the giving what we can pledge towards effective charities and, a pretty core teaching of the Catholic Church is that it is important to donate back. I think the same figure, 10% actually.

[01:26] **Austin:** Growing up, I would go to church, with my mom and dad and my siblings, and they would hand over a $1 bill or a $5 bill for us every time the collections basket for church came around. And I guess that habituated me a little bit to the idea that like, oh, donating, giving money away to the church is a very reasonable thing to do. Specifically like, the money that we kind of have on earth is like, not just for us, it's also for, other things. It's to, give back. That made donating a very, normalized thing. 

[01:53] **Austin:** I mean beyond the giving money in churches, lots of like teachings of course of the Catholic church, about how like you are on earth to help out other people and do what you can, for other people. That's, I think been very important to me, very ingrained in me. And, that's how I like, started with the idea that like, I should be giving away some of my income and trying to help other people.

[02:12] **Austin:** Where EA entered the picture, is a little bit interesting. 


#### Car washing for missions to earn to give

[02:16] **Austin:** When I was in middle school, our church ran this event. This kind of mission trip where they send a bunch of, middle schoolers down to Tijuana, Mexico to construct a house for a poor family there. I think that's relatively standard in many churches in America. 

[02:32] **Austin:** One thing that stood out to me, when we were fundraising for this trip, is that the students decided, oh, we're going to pull together like a car wash fundraiser. That's like a pretty common thing. We're going to go out and like find a empty gas station and then put out signs and tell people, come over, we'll wash your car for like $10 or something like that, or a donation for your choice. And we like worked pretty hard at this and had a bunch of students and adults over helping to oversee this whole operation.

[02:59] **Austin:** And I think I sat down and at the end of this whole thing I calculated, we made much, much less the minimum wage. We made something like, I don't know, $5 an hour say, doing all of this, car washing by hand. So a part of me, in middle school, just went like, you know, what I could have done instead is just go and gone to work at McDonald's and then use that money to quote unquote fundraise for, this mission trip that we had.

[03:18] **Austin:** That kind of thinking got made me very predisposed to the idea of earning to give much later in, I don't know, the early 2010 when I heard about the whole effective altruism movement. I was like, yes, the idea of, you should just go work in like an investment bank or as a software engineer or do something and make a bunch of money and give that away that is much better than volunteering. If you have the ability to make a lot of money, that always just made a bunch of sense to me.

[03:42] **Austin:** So that's, kind of another way in which my early Catholic church group, led me closer to, effective altruism. 


#### Ebbs and Flows

[03:49] **Austin:** From where I'm standing now, I probably spend a lot more of my time thinking about EA concepts, EA principles, and being as part of the EA community, than I do think about like the church, Catholicism.

[03:59] **Austin:** And that's kind of a reverse of 10 15 years ago where I was very devoutly, Catholic and didn't know much about EA and didn't know anybody in the movement at all. I have some thoughts about, the ways these different movements are structured or like what it kind of feels like to be a member in the things like that. I'm happy to go any direction.

[04:16] **Henry:** Are you still attending mass? Is that a thing? Or is it just more your thinking you're saying is devoted more towards..

[04:22] **Austin:** Yeah, I still go to mass. I think that's the way I'm like a bare minimum Catholic. Where I, go to mass, every Sunday. Even if I'm not traveling, I try to like make it a point to go to like a local service.

[04:32] **Austin:** But I don't feel very strongly rooted, with, a particular Catholic church. It comes and goes. maybe a year ago I was, living much closer to a church and then I would go there and sing in the choir, and then I got to know the people there a bit more. that was also the church in which me and my wife got married, so, then we had like talk with the priest and get to know him a little bit.

[04:48] **Austin:** now I'd say we're like a little bit less like rooted again. and I think, it's a thing that kind of ebbs and flows. with the, upcoming birth of my, daughter. I expect, well, we wanna take her in for baptism and maybe a few years later, kind of, get her educated in the Catholic tradition as well. So, that might bring me closer with the church again. 

[05:05] **Austin:** but yeah, that I think occupies a small percentage of my waking life, and versus a large percentage of my waking life is thinking about effective altruism. I spend some of my like free time reading the EA forum for example, but also my work Manifund, is a lot around funding things in principles with the things that effective altruism thinks is valuable. I spend a lot of my time like talking to people in this space. so yeah, the, the balance of where my attention is has definitely shifted a lot. 


#### How far does a dolllar go

[05:32] **Henry:** I'm not that familiar with the principles in it. No one wants their altruism to be not effective. Why is Effective Altruism as a movement so different? Why does it need to be its own thing almost? I went to this conference and it was about Christianity and effective altruism. I thought that was interesting 'cause I didn't even know that there were Christians that.. so it was just cool to learn from people and be curious.

[05:54] **Austin:** Yeah. Maybe I'll go back a bit to how I found myself very attracted to the principles effective altruism. Which was that shortly out of college I had started like working, I was like giving some of my income. The natural thing there was to give it my 10% back to the church. I think it was the Oakland church or maybe the Berkeley church because that was where I kind like had gone to college. 

[06:14] **Austin:** I had some sense in which I wasn't really sure what happened with the money. It kinda looked to me that the church did have a lot of money. They had this nice cathedral and I'm sure I could have looked in and thought like, oh, they probably served the homeless in America. But there's always a part of me that is very much trying to optimize.

[06:31] **Austin:** And I guess I'd come across some of the foundational literature on effective altruism. Asking questions around like, does a dollar donated locally, domestically in the US go as far as a dollar overseas? Well, it seems like people in Africa have much lower costs and much lower standards of living and just baseline have many more needs. So you might imagine that like sending like a dollar to somebody there, it just goes kind of farther, helps more people. And I found that to be pretty persuasive. 

[06:56] **Austin:** And then beyond that, one of the things effective altruism tries to spend a lot of time thinking is different kinds of helping people. They're not all the same. You might think that education or spending money on teachers is this level helpful. And maybe spending money on drugs is this level helpful. And directly just giving the money to people, it's this level helpful. And we don't really know what the levels are, but it seems kind of important to try to figure out what they might be.

[07:17] **Austin:** It's very plausible that there are orders of magnitude differences, 10x, 100x, 1000x between like different kinds of ways you can help people with your charity dollars. And if that is the case, then it is pretty important to sit down and I think do a randomized control trial or use other ways you have of like understanding what the impact of your work is. I found that just very compelling. 

[07:39] **Austin:** I would like the good that I'm doing, the amount I am donating to go as far as possible under particular world views. If you roughly think like a human person in Africa is worth about as much as a human person in America, then maybe you should try to donate to like causes in Africa, that kind of thing.

[07:56] **Henry:** Yeah, I mean at that conference there was a guy, he said he worked at USAID. He actually had a whole talk about cash transfers. And then he calls it like a baseline, where it's not that it itself is the thing that you should be doing, but if you're not even doing that effectiveness, then you should reevaluate.

[08:13] **Henry:** Then someone else gave a presentation whose an economist, kind of measuring interventions. There's like bad water supply in a certain country in Africa and how they marked a pipe with red to tell everyone don't use that water. And then it ended up making it worse because the other water sources were even worse than the one that they picked that were bad. I guess the point was that something in theory that was obvious, sometimes it's not. And I guess it's worth putting in this kind of effort to figure out whether it was effective. But I don't think anyone would argue that the general idea of wanting to understand that output that we were talking about previously, that that seems like a good thing.


#### Separate your utilons and fuzzies

[08:49] **Austin:** I think many people from the computer science or techie people kind of feel like, oh, this does seem kind of obvious. I don't think it's that obvious to everyone. I think a lot of people feel strongly that, for example, the local university or the local theater troupe, art museum, you know, it's also very valuable and worth donating to. And I have actually some amount of belief in this as well.

[09:07] **Austin:** I kind of think that probably things that you like personally use, you should consider donating to as well. But it's possibly worth separating that out into like a different category that might be a more consumption kind of donation. The same way you are consuming when you are going to a local movie theater that is for-profit. If you go to like a nonprofit, you know, like performing arts thing, you might want to donate to kind of help them out as well. 

[09:27] **Austin:** But I do think that if you are the kind of person who is in the position of making a lot of money and able to donate lots of it, you might want to think about the good that you do in the world, in the kind of a separate category.

[09:37] **Austin:** There's a classic essay on this, which is you should consider purchasing your Utilons and your fuzzies in different buckets, which is to say like your utilons, the amount of utility you effect upon the world, the amount of people you're able to help, you should try and do very rigorously. And then for purchases that are in support of things that you like, you don't want to apply this level of rigor to.


#### Assumptions in value

[09:55] **Austin:** And then your second point. I think it is kind of hard, even if you agree that like, oh, you want to be like very effective with your donations. Kind of hard to know. Everyone's gonna tell you like, oh, we think our donations are very valuable. How do you know, which of these many different charities in the world do you choose between. And I think effective altruism has these like meta charities or charity evaluators. 

[10:16] **Austin:** One that I respect a lot is GiveWell, for example. they try to like talk to the charities and look over the reports and talk to other scientists and do things like this to kind of come up with a quantified of, for example, how many lives you can save per dollar, spent. Or how many dollars does it take to save a life, I guess is probably the easier way to think about it.

[10:33] **Austin:** I respect them a lot. I think they hire very, like smart people to, sit down and do these analysis. There are of course like all kinds of issues that they themselves will admit, like there are wide uncertainty bars on many kinds of the research that they do. And it is very sensitive to different assumptions.

[10:50] **Austin:** For example, the baseline assumption of like, do you think human people alive today are the thing that is very important that you want to save? Or do you think animals might matter? Do you think that like preventing the torture of chickens in a factory farm, is that important to your moral calculus?

[11:05] **Austin:** And then, do you think in the future, people who live a hundred or a thousand or a million years from now matter, and if so what does that mean about how you try to help those people? There are lots of like questions like this that effective altruism, people in the community wrestle with, and I don't think they're like easy answers. I guess many people have like come on their own, like, this is what I believe.


#### EA as at it's best a meta-framework?

[11:24] **Henry:** Maybe those assumptions are clear, but I guess as an outsider, I think the distance thing and the time thing. A person that's right next to me, I think most people would be more willing to help that person when they're literally their neighbor versus.. Is it our responsibility to help everyone? It's a moral imperative, like you said, different assumptions. To me it seems kind of absurd that someone that potentially will live a million years from now matters the same as someone that's literally in front of me.

[11:52] **Austin:** I think those are pretty strong intuitions among many people. And I actually, also share a lot of these? I, I think, the taking the assumption that somebody who will live a thousand or a million years in the future matters as much as today is somewhat trendy in certain circles under the, what's called long-termism. If you could prove to me that both of these people were going to live, for sure, nothing bad happened to humanity or something like that, I, I might buy that assumption. But I could get into a very long I guess question back and forth about this. 

[12:21] **Austin:** Maybe taking a step back, I think the EA movement, the best version of movement doesn't try and like persuade you, at least too much, about one set of assumptions over the other. 

[12:29] **Austin:** But rather if you come into it with a set of assumptions like, you know, I really care about people today. Maybe I even care about people in the United States or something like that. What is the best way to help those people? I think the best version of EA would to try to help you answer those questions. 

[12:42] **Austin:** And definitely like the different factions of EA I think there are some kinds of consensus around like, what is the best way to help animals or specifically even to help chickens? If you think like there are underserved, and these are people who take funding within EA and talk to each other.

[12:57] **Henry:** I think I would agree with that. If EA was a movement where it just helps you enhance or promote those own values rather than, it feels like EA itself has its own values that it's almost trying to get you to agree with, which you might not like. These are the set of assumptions that matter. Or even the way you check if something's effective, do you have to do this randomized controlled trial, stuff like that.


#### Friends vs Movements

[13:18] **Austin:** I think it's pretty tricky. It's one thing to think about what a movement feels like. A movement is kind of amorphous. I think what is very clear to me is that many individual people within EA I like very much enjoy engaging in, that's probably one of the things that drew me into the movement. The individual people who I talk to are very thoughtful, very smart, have put a lot of effort, have often devoted their lives towards trying to help other people. And I think that's very noble and I appreciate talking to 'em on many issues that matter to me. The movement as a whole is again, like a trickier thing. It's not like super well led, I would say. It's not like there's a single person or a single organization who kinda like rules over all of effective altruism.

[13:57] **Austin:** I think it's much more the case that there are just like many players within the space. There's some people who are funders and some people who are charities and some people who are just kinda like fans who read and comment a lot. Out of that, it might feel like ea might have like a particular message or many people believe a thing and then you as an outsider talking to people in the movement, might feel like, oh, they all are sending the same message. Does that mean EA believes this thing? It's hard to say.

[14:18] **Henry:** Right, right. I guess not that different from any religion in a sense, not that it is. But Christianity or Protestantism, there's also no one person necessarily leading it. Everyone kind of generally could even believe in different things, but everyone's like, oh no, Christians say this.

[14:32] **Austin:** Yeah, I think even within Christianity there are different levels of this. Catholicism for example, that's the sect that I'm obviously most familiar with, tries to be a lot more like consistent with all its teachings and it has more of like a hierarchical structure, to help enforce that. A pope at the top and then archbishops and bishops and priests, and then laymen. That kind of means that it's easier to have like a consistent, message. And then there are also other kinds of mechanisms, like the mass, for example, in the Catholic Church is standardized throughout the world. That's a key part of Catholicism, the unity. I think that's what the word Catholic actually means.

[15:03] **Henry:** Universal.

[15:03] **Austin:** Universal. Exactly. That unity I think very much distinguishes at least my experience of being in the Catholic Church from my experience being in EA. I think this is probably less true of other Christian sects depending on which Christian Branch you're talking about. I'm curious, like what was your background? 

[15:20] **Henry:** I grew up atheist. Parents didn't believe in anything. Ultimately the reason why I decided to accept Christ is through various health issues that I've dealt with throughout my life. Long story short would be that I didn't really have any hope other than in that. It's like hope for a future, and then hope in this life. Why I would wanna wake up every day, kind of thing.


#### Continual commitment

[15:42] **Henry:** I'm curious like what.. You said you grew up Catholic, so it's like what keeps you in Catholicism or participating, especially as you said, kind of ups and downs. For a lot of people they might be like, oh, why are you still Catholic, if anything?

[15:54] **Austin:** That's a great question. Yeah. I think there's one part of it, which is a commitment I made. Which is that like I went through the sacrament of confirmation, which you kind of like swear to be like Catholic and something that's a thing that you hold to for the rest of your life. 

[16:07] **Austin:** And I take commitment seriously, or I want to take commitment seriously. I think of myself in high school as like a real person whose beliefs mattered. And I want to kind of like uphold that person and follow what that person believed. Is one part of it. 

[16:23] **Austin:** Another part of being Catholic, I think, is that in the Catholic faith and more broadly in the Christian teachings, I have found some of the warmest, nicest, most kind people who I think exist on earth, or at least in my little.. The ones who will go out of their ways to pick up groceries for you at Costco when you're a college student without a great way of getting it. That kind of thing.

[16:44] **Austin:** Or my mom is a personal example. She spends a lot of her time trying to help people, visiting older people who are in the hospital or in other places or trying to do good on their behalf.

[16:54] **Austin:** Seeing the effects of faith on these people, these people represent to me the kind of person that I would like to become. They cite faith as a reason why they do these things. And that makes me think like, oh I want to have this same thing as well. So I think that's a big piece of it.

[17:10] **Austin:** And then I think I just have believed in things like God and a heaven after this life and things like that in a while. In a way that is like kind of hard to shake off. It could be virtuous to kind of trying to question those very like deeply. I don't know that I have like examined that very much recently myself. I don't know. I believe in those things and I like believing in those things. So all of those are reasons why I am Catholic. 

[17:33] **Henry:** There's a lot there. I don't know if you know Sonya Mann, but she converted to Christianity a few years ago. She felt one way of observing maturity is when you're okay with the ambiguity. When you're younger, you're like, I need to prove everything in order kind of commit to something. And being okay in the unknown is just what it's like to grow up. You're still willing to kind of take the leap.

[17:56] **Henry:** Maybe there is something about wanting to question. I guess if you are in this rationalist ea space, I would've thought that you would have a desire to be very rigorous about believing all that. I wouldn't necessarily. I don't know if you felt a certain pressure to do that or anything, or other people do.

[18:13] **Austin:** Hmm. I think I often do get into conversations with my wife, who is not Catholic, or other people in the EA or rationality space around belief in a way that is kind of a fun debate. Not necessarily even that core, but things like what does it mean to have a heaven? Is that consistent with what a lot of non-religious people believe about AI for example. And I think it actually can be. Many analogies. I think one very likely way we get to heaven is where we're all like eventually uploaded we're in utopia of some kind or another. But with some kind of value judgment based on what you did a long time ago. So definitely ways to bridge the gap or talk about things in a way where people from Catholic backgrounds and people of the more rationalist ea background and can find some agreement.


#### Babel and Pentecost

[18:56] **Henry:** I've had this thought recently. It's funny. I worked on a project called Babel, and it's like negative thing in the Bible, right? Building this tower. It kind of feels like AI is a Tower of Babel that we're creating. People were melting down their jewelry and their metal into this golden calf. And it feels like we're melting our silicon into GPUs and turned into this AI that we're gonna worship.

[19:18] **Austin:** Oh, absolutely. More than just the silicon. Silicon and gold is relatively seems cheap compared to the time of the people. That we're spending the brain powers and the time of the smartest people in our generation to try and build this thing or make this thing safe or like talk about this thing. I think the analogies to Tower of Babel are like pretty good.

[19:35] **Henry:** Also I would say the inverse of Babel is very interesting, which is Pentecost. What does that mean? This metaphor of us building a tower to God versus God coming down to us.

[19:45] **Henry:** It's the same things about language, right? In Pentecost, holy Spirit came, and then everyone was able to hear each other in their own language. Maybe AI feels like that because it can translate for you actually. But I wonder, people have that critique of just it feels like we are gonna become a slave to the technology versus this idea of working with the technology.

[20:04] **Austin:** Yeah, it's possible that the Catholic orientation towards God provides some useful clues for non-believers that how they should orient to the AI or orient to transhumanist future roughly.


#### The Mystical Body and Taco Tuesdays 

[20:16] **Henry:** One of the people I've been trying to learn more about, Marshall McLuhan, the father of media studies. Until recently I was like, oh, I found out he was a Catholic. How does his faith actually affect.. Lot of these people don't write in a religious sense. It's like they're just writing secular work, but still using a framework of religion. 

[20:35] **Henry:** The church is the body of Christ, right? And then Christ is the head. In Catholicism, he uses a phrase specifically the mystical body of Christ.

[20:43] **Henry:** He says the electric age connects us right in a certain way. I just think about we're connected online right now. And it makes us feel like we're connected, a body. And so he says that this is almost like a false body that is created through connecting us on digitally. He uses the word facsimile, a fake representation of the body. Uh, He says, the prince of this world, Satan, is a great electrical engineer. It's like a really funny statement. 

[21:09] **Austin:** I very much hesitate to be the kind of person who instinctively says, oh, you know, this new technology is bad. I mean, I'm a software developer. Most of my living is from connecting people over the internet. I do think that there's something to the effect of.. The structures of the Catholic Church and Christianity more broadly. The mass service of bringing people together once a week to talk to each other and like learn and share food and like become just brothers and sisters in Christ. 

[21:34] **Austin:** I think that's very important social technology that I don't think the internet age has quite like replicated yet. For example, recently my parents have been calling into mass a little bit more because of Covid, a lot of the churches have gone done this live streaming. Now they don't have to get off their butts and get into a car. They can just like watch it at home. 

[21:53] **Austin:** And I think something's like lost a little bit there. Where you might so listen to the same lectures. Content. But it is kind of a facsimile the way your writer was describing it because, many things that come with being physically present with each other no longer happen when you are just like watching a recording, or even a livestream.

[22:12] **Austin:** You don't have the very casual conversation, the bumping into a church friend who you see like every week and you don't see what's going on with their lives. 

[22:21] **Henry:** Your example does speak to the medium is the message. We are so focused on the content, the message. The fact that you're hearing the sermon or the mass, we're not paying attention to how we are experiencing that. And so the how would be the fact that it's digital versus physical.

[22:36] **Henry:** The effect of the medium on people is way more important than whatever particular message is being said. So meaning that the whole medium of livestream, that's more important than the content itself could even be talking about. Whether it's church or a debate or politics. People are really mad at what people say on social media, but social media itself creates a whole different way of thinking.

[23:02] **Henry:** And when he says medium, I really like his other substitute. It creates a whole environment that changes us. It shapes how we live, how we relate to other people, like you said. And environment's a good word is because the environment is invisible. 

[23:15] **Austin:** In my own life, I've tried to take at least bits and pieces of like what I liked about the social technology of the Catholic Church and bring them into my life. One main way is like a Taco Tuesday. A secular tradition, but a tradition nonetheless. One where every week I just send out an invite and usually 20 or 30 people come to my house. We cook tacos together. Do some kind of activity like board games or karaoke or something.

[23:38] **Austin:** And a lot of my thinking behind this comes from like, what were the main social benefits of having church service every week, which is that like predictable. It's a good amount of time to catch up with people who aren't your closest friends maybe, but people who you still care a lot about and want to know what's going on. And chance for them to hang out with each other. That weekly touchstone is very important. 

[24:00] **Austin:** That's one thing that goes back all the way in the Bible like on the seventh day, you know, you should rest. And I think with that rest you should also nurture the relationships in your life, which is what mass did. And what I hope to do a little bit with this like kind of weekly dinner thing that I have.

[24:13] **Henry:** Focusing on the word liturgy, right? This repeated process that happens continuously, you're right. Really important. 


#### Agentic or Salvific

[24:23] **Henry:** A different thing in faith that we emphasize is prayer. I think a big part of prayer is a vulnerability of letting go, knowing that I cannot fix everything.

[24:31] **Henry:** And maybe something I kind of see, it feels like this need to kind of be the savior sort of complex. Meaning that we are really smart. We have science, math, all this stuff. And we also don't want to feel like we have no agency, right. 

[24:43] **Henry:** And so what's the balance of knowing? I guess it's like, I don't wanna feel like I can help everyone, 'cause I can't. So I want to know what is my role to be able to affect change? And I think part of it's actually some kind of humility. 

[24:55] **Henry:** And people always say like, thoughts and prayers, we're just saying that and it doesn't mean anything. But I think it's a powerful act for yourself to be able to let go and be like, I cannot do this, but I would like to at least say that I'm thinking about it or even to change my mindset around that.

[25:10] **Austin:** That is really, really interesting. Not a thought, a connection I've made before. I do think inside the EA movement, one of the virtues or one of the things that people say is good about a person is if they are, quote unquote, agentic. If they have the ability to kind of like make change happen in the world or start with a plan of action, actually execute upon that.

[25:32] **Austin:** And I've almost spent so much time thinking in these terms that the opposite, the ability to recognize when you don't have control and ok with submitting to God or submitting to the things the way they're. I think there's something virtuous about that, and I just like, yeah, I really haven't thought about this. I myself have a lot of the impulse of like, oh, trying to have more control and try to shape things and fix things and make things better. Be the savior.

[25:57] **Henry:** I'm in the same circle, too engineered mindset. Everything's about predicting.. Prediction markets, all these things. 

[26:03] **Henry:** Maybe that's my draw towards art where it feels like there's no measurement there. And I don't want it to be like, oh, it's just all fuzzy.


#### Humility of Sabbath

[26:08] **Henry:** Like you said, there is a virtue to.. Whatever true humility looks like. Like if I said I'm not a good programmer or I'm an amazing programmer, but just knowing where I actually stand that's true humility, right? And I brought this up actually just 'cause you mentioned Sunday. Sabbath right ?

[26:22] **Henry:** That's one of the most interesting things about faith, is that God, who supposedly is all powerful decides to spend one day just for rest. He doesn't even have to rest. So how does that fit into how we think about being effective?

[26:34] **Henry:** Another issue would be this feeling of guilt that I felt a lot with open source. I have to help everyone, everyone that sends an issue, I'll work on the weekend. I had to learn to say no. My own boundaries. So I don't get burnt out. Maybe that's a big issue in ea. Like, if every dollar needs to be effective, then also every moment in my life might need to feel effective. I.. I don't know.

[26:54] **Austin:** Yeah, absolutely. I think this is a thing that many people in the community will call out, the sense of demandingness, the sense that yeah, every dollar and every moment needs to be, you know, optimized for. And I think many leaders of the movement try to disavow this. 

[27:09] **Austin:** Make the statement that no, you do need to have time for yourself. But it is hard, fundamentally to like reconcile these two. You know, on one hand, everything can be better and you should be as effective as possible. And on the other, our human like frailties and needs.

[27:21] **Austin:** And I like what you said about like, you know, God himself decided to take the Sabbath, the seventh day off. And so who are we to think that we can go through, power through, you know, like every feature request at 2:00 AM on Sunday.

[27:35] **Henry:** There's something about even sleep. Maybe we find out we only need X amount of sleep. And the only reason why you rest is so that you can be more productive. That rest itself isn't an inherent good thing. 

[27:46] **Henry:** I think a lot of other things like fasting, sleep and Sabbath. It's like kind of popular now to fast or to meditate and all these things because there's like this benefit to it. And I wonder like, is there a benefit outside of that?

[27:58] **Austin:** Like, in some sense, like I feel so brainwashed that like I have a hard time trying to understand the benefit. With the sleep thing, I do have a bit of the impulse where it's like trying to minimize sleep. I've taken things like caffeine or other drugs, modafinil to try and you know, stay awake more and be able to be more productive. And insofar as people you know, rest it's easy to just justify like, oh, I rest now so I can be productive later. But maybe that's the wrong altar to be worshiping on, you know. 


#### Efficiency and Waiting

[28:22] **Henry:** It's funny the AI feel more human than me. It's like I'm the one trying to optimize life much possible. I don't know if that's the right approach. Oh, something I really liked, this is actually from sermon I heard, and they were giving an example of pokemon. They call it Holy Inefficiency. When you're playing in the beginning, everything is fun, 'cause it's for the first time. I don't think you're thinking about the motto, catch em all. Kind of enjoying every moment.

[28:46] **Henry:** Eventually, you get a bike or you learn how to run. And if you think about it, once you learn how to run, what's the point of walking ever again? So you're always gonna hold b or every time you go outside, you're gonna press, I think select button, and then you're gonna bike. And then you're gonna fly everywhere.

[29:01] **Henry:** So it's like funny how often we're trying to like min max optimize the game. At the end we're just teleporting everywhere, like the thing in between A to B doesn't matter at all. It's just about getting to the end. So something is also lost there. 

[29:15] **Henry:** And you say all that as a metaphor for relationships. So easily relationship with God is like, am I trying to fast forward my relationship with God? You're patient, you're waiting. And I maybe one of the virtues that we don't have in our society is patience waiting. And I think about all these liturgies that we have in the church, the calendar that's actually waiting. Seasons are waiting. Advent literally is.. 

[29:39] **Austin:** Is a time of waiting, yes. 

[29:40] **Henry:** Lent. These are all rituals that were created to instill a sense of waiting. And I think that there's like nothing in our society now that does that. 


#### Hope is trusting in people

[29:49] **Henry:** Another person I have been reading a lot about is Illich. One notion I really resonate with is what he calls the difference between hope and expectation. 

[29:58] **Henry:** For him Prometheus represents expectation. Prometheus like the guy that stole fire from the gods, and he represents foresight, which is about prediction. And his brother, we've forgotten Epimetheus. He represents hindsight. 

[30:13] **Henry:** And hope he says is trust in a person. You obviously want that thing to happen, but you're okay if it doesn't. And expectations like, no, this has to happen, because of whatever system I've made. His point is that we've created such a world that feels like everything has to be engineered and there's no other way to do it. Versus this idea of trusting in people. Because we're also flawed and we're gonna make mistakes and we can't guarantee certain outcomes, but it feels like we're trying so hard to become this other thing. And like, how do you balance?

[30:45] **Austin:** One idea that sparks, uh, in me the difference between trusting in people and expecting kind of engineering like things for the world is that people are just individually irreplaceable. Like special, different, unique. 

[30:57] **Austin:** Engineering is about like kinda getting rid of those differences in some sense. When you engineer a system, you try to make it like replicable. You try to use pieces that are interchangeable. Try to have the output be consistent, deterministic all the time. And I guess I see like differences here a lot. 

[31:14] **Austin:** Like right now I'm organizing this conference Manifest and the process of organizing a conference is a lot of talking to many, many, many people and trying to like understand who they are and like what they want. And if they're a speaker, what are they going to talk about? And they are very much not replaceable. They are very much unique.

[31:30] **Austin:** I have to like put a lot of trust that they will come and like show up and deliver and present a talk that the audience will learn a lot from and enjoy and things like that. There's a piece of that I like a lot. It's very different than me like writing code for Manifold, right? Which is much more like deterministic. You're working with things that just run again and again and again. And you can kinda like model out all those pieces and I enjoy that a lot. I love software engineering, but I, I think I'm also growing to like the, just like talking with people like trusting in them.

[31:57] **Henry:** Not that, you know, everything should be one or the other. It's more just like we should be better at determining when things can be systematized when they maybe they shouldn't. 


#### Knowledge Progression, Loose Structure

[32:06] **Henry:** My friend Cristobal had a really cool theory of knowledge. He kind of made this trinity of people. The artist tries to move the boundary on something, defamiliarizes. And then the scientists create a theory on that art because they're trying to understand what the art means. Then the engineer comes in, creates a system to concretize that idea. And then the artist comes back again, I don't like the system.

[32:28] **Henry:** I'm always struggling with like, okay, I have such a engineering mindset and then my work is all engineering, but like, I feel.. This is a wrong approach? Open source is one of the most technical things that you can do code wise, but then because the organization is so loose, it's one of the most people oriented thing you could do. There is no structure really. I mean, you can create whatever structure you want.

[32:51] **Austin:** But that like flexibility means that you actually have a lot of room to shoot yourself in the foot, basically. And you have to think a lot more about how to do simple things. In a company it's very well defined. Like you have a manager and you have a teammate and you know how you're supposed to relate to each other. And I imagine with open source people come in and have varying amount commitment and expertise and background, and you don't, you know, decide any of that.

[33:10] **Henry:** Devon Zuegel who did GitHub Sponsors, she had a post that I like, it's called Lazy Load Governance, right. That in open source, you don't need to do all these things upfront, but then eventually you do. It's always, in retrospect, rather than at a company, you feel like you decide all these things ahead of time. And so sometimes it might lag a little too much. But that's kind of the nature of how, like you said, how this thing works. It's so like, kind of hodgepodge. 

[33:34] **Austin:** I thought it was great to talk some about the faith and how it relates to different things that we care a lot about: open source, ea, other bits and pieces.
