---
title: 'Artificial Physicality (Drew Austin)'
season: 4
date: "2024-08-07"
time: "50"
description: "Why does everyone care about New York? Drew Austin explores the interplay bt digital/physical env and how tech values shape our lives. We discuss some of his past essays: fashion as public good, airport lounge-ification highlighting, and how digital paradigms reshape our physical spaces. Topics include: fake serendipity, lofi, gm, resilient systems, the commons as customs, postmodernist software, leaving a trace, Twitter as a waiting room. (Recorded October 2021)"
episodeLink: "1c3ca662"
embedUrl: https://share.transistor.fm/e/5273bdb8
sidebar:
    order: 7
---

### Links

- [Worn Out (2021, *Real Life*)](https://reallifemag.com/worn-out/)
- [Kneeling Bus substack](https://kneelingbus.substack.com)
  - [Last Exit to Brooklyn (2021, *paid*)](https://kneelingbus.substack.com/p/last-exit-to-brooklyn) (on living in ny)
  - [The Airport Lounge City (2021, *paid*)](https://kneelingbus.substack.com/p/the-airport-lounge-city) (airport lounges)
  - [#168: Punks in the Beerlight, (2021)](https://kneelingbus.substack.com/p/168-punks-in-the-beerlight) (CDs, physical media)
  - [Halfway to a Third Place (2024)](https://kneelingbus.substack.com/p/halfway-to-a-third-place)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/main/season-4/artificial.md)

[00:00] **Henry:** Talking with Drew Austin. We're doing this in person, which is kind of new for me. And maybe for you too. 

[00:05] **Drew:** In person podcasting is back! 

[00:07] **Henry:** Yeah, I hope so. 


#### So what's the weather in New York?

[00:08] **Henry:** You've had a few newsletter posts recently about New York as well. 

[00:11] **Drew:** I've lived in New York for 10 years. My background is in urban planning, so a lot of what I write about is how the digital and physical worlds collide and overlap and influence each other. Watching how much cities have been changed by all our digital technology, not just in the last 10 years, but well before that. It's such a fertile place to observe different phenomena, and it's also very unlike the rest of the United States. So in a sense, you're not always learning that much about other places if you're here.

[00:37] **Henry:** Everyone knows what's up in New York, but then we might not know.. 

[00:40] **Drew:** The internet is so like central to that, but other media I guess also broadcast the activities of New York to the rest of the country and the world. 

[00:48] **Drew:** So everybody I joked, has to know what the weather's like in New York, if there's an extreme weather event, my mom knows if it's snowing here. And I've always thought that was kind of silly, but that's also.. Whatever the New Yorker like identity is. I feel like that's such a big part of it. Like you have to hear what I'm doing, but I don't care what you're doing. That's the provincial New Yorker looking out at the rest of the world.

[01:11] **Drew:** But I mean, I don't like to think that I've internalized that attitude, but it is just being here I think gives you a lot of food for thought if you care about cities in the built environment. I mean, I'm really happy to be here and I think it gives me a lot of ideas that I wouldn't necessarily have if I lived somewhere else.

[01:32] **Henry:** I've been here, I guess like six years, so it's long enough I suppose. Yeah. I don't think I feel like a New Yorker either, but there's a certain ethos or culture to the city that you can't get in a lot of places. When I first moved, I didn't want to be here, but then I realized how much I hated driving. Seems like the only city that you can just take a subway, right? In the US. 

[01:51] **Drew:** That's also really important to me. I love not owning a car and I will try to not have a car as long as possible. 


#### Even a pandemic becomes about NYC

[01:58] **Drew:** I think I've written about this a lot over the last year and a half since the pandemic started. The pandemic is obviously like a very physical problem in many ways, requiring us to isolate social distance being transmitted by people being close together.

[02:14] **Drew:** And how it's kind of been both in the middle of last year and now post vaccine, it seems like New York's like role in, I guess like having a dense urban environment or just being like the American dense city. Everything that's happened with the pandemic seems to be this referendum on New York. 

[02:32] **Drew:** So last year everyone was very eager to declare that like New York was dead and now everyone kind of has like swung completely to the opposite direction. And everyone thinks New York is is where you where you want to be right now because you can do things again.

[02:48] **Drew:** And it's funny how in both situations. It somehow becomes more about New York than you would expect and. I mean this is also like a very, again, like, yeah, New York centric thing to say, to like assume that everyone is thinking about New York. But it does feel that way sometimes. 

[03:03] **Henry:** Maybe it's self-fulfilling prophecy that maybe that's, I was thinking just memes in general, like the whole GameStop thing. 

[03:07] **Drew:** Yeah, and I mean that definitely seems to be borne out by the fact that I, I haven't checked lately, but just I know that the GameStop stock price is still like way, way above.


#### We behave the same, online or in a city

[03:18] **Drew:** If you're talking about technology and media, a city is a medium, but like also the internet is a different medium where it just happens to be one of the primary theaters where human nature plays out today.

[03:29] **Drew:** Like we attribute a lot of things to the internet that aren't really because of the internet. There's certain types of human behavior that are going to happen somewhere no matter what. And like a city is one place that they can be observed and the internet is another place.

[03:43] **Drew:** So like I think a lot of times we think Facebook is causing us to become bad people. But really like that way of being bad was something that we would've found a way to do before, and maybe we just haven't remembered what it used to be like. Or we've idealized the past. I mean, some people idealize the future. 

[04:01] **Drew:** That's what's kind of interesting about technology, thinking of it in terms of like the medium as Marshall McLuhan used it. It's just another place where people do human things.

[04:11] **Henry:** He was emphasizing the medium isn't just the way, but the environment. We are always thinking about how do we create tools and affect the world rather than the world affecting us. 

[04:22] **Drew:** Right? That statement about every new technology is an amputation of, 

[04:28] **Henry:** He's known for saying like it's an extension of our body, but then we forget the second part of it, which is like, it can easily do the opposite, which is remove our senses or remove the need for our senses. 


#### Technology, Memory, and Depersonalization

[04:39] **Drew:** You can see things like certain types of memory. You can see it in our culture that other ways of doing those things have atrophied. Memory is sort of like a complicated thing, but right now nobody feels like they're not gonna have most of the information they need at their fingertips. So it becomes less urgent. It almost feels pedantic to even.. I, I'm not complaining about that. I feel like it can be kind of missing the point if you complain about the fact that nobody has to remember facts anymore because they can look them up.

[05:11] **Drew:** Right? Like that's great. I'm happy to not have my head full of useless facts. But there again, like you were kind of alluding to earlier, there's so many like knock on effects and a lot of them are. Fairly unpredictable and we kind of realized that there are problems once something has already disappeared.

[05:29] **Henry:** All of us can use like GPS to like get anywhere we want. This is great for all of us individually, but then maybe before you would've asked for directions and that was like a small amount of trust for a stranger that we lost.

[05:43] **Drew:** I noticed that pretty quickly when smartphones became pretty widespread 10 years ago or however long. One of the first apps I remember seeing on the iPhone that I thought was really amazing and kind of like the perfect indication of what the iPhone could do was Shazam.

[05:59] **Drew:** I remember pretty quickly after people started to use Shazam to identify music, that it became less acceptable to ask somebody what was if you went to a restaurant. And you liked the music that was playing. First of all, it's like, why are you, it would be, why are you asking me this? You can just Shazam it.

[06:16] **Drew:** But secondly, a lot of times people wouldn't even know what was playing because they were just playing like a Pandora or like algorithmic playlist. The person both doesn't need to talk to you about what it is and doesn't know. So they've been removed from the whole process.

[06:30] **Henry:** Yeah. Impersonal. I guess like they might even feel offended that you're asking at all. 'cause like everyone knows at this point you're supposed to just search Shazam it maybe eventually. Like there's no name to the music. It's just like all Yeah, like real time generated from like code or something.


#### Lofi, CDs, and Artifical Physicality

[06:46] **Drew:** Which I is in a way it happening now because so much music is made to like be lo-fi basically. Yeah. Lo-fi or like Monday moods or whatever. Yeah. And it's kind of not actually even really meant to be thought of as made by a, an artist. It's just almost an engineered product. But I think that's actually like, I mean, directions is also like a good, it's an opportunity to help somebody directly, like on the street.

[07:12] **Drew:** With music, it feels even more tragic to me because asking somebody what music they chose to play is such a great opportunity to talk about something interesting that you both are excited about. And I mean, we can go do that on Twitter or social media or whatever now, but it's just one little thing that has gone away, and I think it's kind of not perceptible to a lot of people.

[07:36] **Henry:** I think one of your posts mentioned that too, like when you're driving with someone?

[07:38] **Drew:** The disappearance of physical media. I wrote about that recently. How by reorganizing our like media archives in this completely digital format, we don't have the same ways to like show each other what we like as you could, if you had all your CDs on a shelf or all your records on a shelf at your house.

[07:56] **Drew:** Most people who like books still have bookshelves, although that's also kind of going in the same direction with ebook and stuff like that. Again, there's a way of talking about this that can feel like it's kind of trivial. How much do you really need?

[08:12] **Drew:** And I actually am like, happy to have more space in my apartment that's not taken up by huge piles of CDs. But it is like something that I don't think that for my generation, there's an adequate replacement for it. And I mentioned in the post part of it's just that I've gotten older, so like music and showing off what music you like as you as central to my life as it would've been when I was in my early twenties or teenager. It's still like, you know, a way to learn a lot about somebody. 

[08:39] **Henry:** Yeah, we're in my room. It's like what's in here? Yeah. Maybe. Well, I put the books in a box, but otherwise what are we showing off anymore? Yeah. And maybe that if it's all online, it's like, you could have just looked it up or something.

[08:53] **Drew:** Well, I think social media or there's, there's an effort to kind of give us artificial ways to recreate those types of things in purely digital environments. Like in theory, social media should be a way to like. Show everybody else what you are. But the way that it's done in those media are like, it kind of just feels like everyone's shouting at each other at the same time.

[09:15] **Drew:** So you're thinking a lot more about what you're putting out than what other people are are showing or like, I mean, I think actually an interesting example of this is NFTs, the technologies for displaying your NFTs, which are still pretty rudimentary, but. I think that's actually filling the void of something like having a record collection that is a sign of like who you are.

[09:38] **Drew:** I'm not that deep in NFTs. I don't own any, so I can't imagine using an NFT to like show anything about myself. But I know that people seem to be trying to do that and are probably getting some value out of that. And what, what's interesting to me about that is at some point it feels like the last era of the internet or of computers was kind of eliminating all these things from the physical world and putting them in pure information formats online. And now we've completely finished that process and now we're trying to re recreate these physical environments that we've stripped of all of their purpose.

[10:12] **Henry:** Right. Maybe Zoom is like the epitome of all this. So there's all these like gather, like these spatial apps where you can chat in a video game or people are using video games to have parties or birthdays.

[10:21] **Drew:** Even clubhouse I thought was pretty spatial. I mean, I audio is inherently more spatial than a lot of the visual environments we have on the internet.

[10:30] **Drew:** But the way that like you would drift from room to room, it actually did seem to kind of simulate. Being at some social gathering or a place in its own kind of simplified way. A lot of what the physical world imposes on us is these constraints which are very fundamental to life in meet space. Like I have to travel across distance to get from my house to your house to record this podcast.

[10:57] **Drew:** And kind of the magic of technology is that it eliminates those constraints. So it's interesting that we feel the need to reproduce them. It may be suggests to me that we've sort of given these digital technologies too many chores to do or too many tasks that maybe not all of them are best done online or in purely digital forms.

[11:16] **Drew:** If we find something lacking when everything is online it means that we've moved too many things out of the physical world. But that's a, I mean, that's a huge, I don't know. I feel like that's all. You could write a whole book about it. 

[11:30] **Henry:** On a website, it's like actually too fast on the server side. So they purposely make it slower so that it feels like something's being done, but in reality it's actually an instant. They need people to perceive that like work is quote unquote being done. 

[11:43] **Drew:** Yeah that's a great example of that. And like, it's disorienting if that goes away. Like your actual sensory cues are like missing. You need some of that. 

[11:54] **Henry:** I don't think you would wanna have to walk to a Zoom room. You still would just teleport. We always recreate. Yeah. The same thing in the new medium and we can't help but do that. We don't really know how to imagine something really different. 

[12:05] **Drew:** Yeah, assuming that Clubhouse is not at all what it was six months ago. I think that was one of its big downfalls was that it took most of the social media that we use is asynchronous and it imposed a synchronous quality on how we communicate digitally. And it only worked because it was this special moment in human history when everybody was isolated and at home and had a lot of free time.

[12:31] **Drew:** So every evening when people weren't working anymore, like they would all be on Clubhouse. But you, I think you could, and you saw it kind of start to wane once people started going back out and getting vaccinated and stuff. So I think it was an unnecessary constraint that we've already kind of figured out ways to bypass using the internet.

[12:50] **Drew:** Twitter is really interesting because it feels like it's happening in real time. But it's actually a bunch of people who just posted and are probably not even looking at their screen right now at a very granular level.

[13:01] **Drew:** Like most of the people that you see in your Twitter feed aren't actually on Twitter right now. They're probably like doing something else. It's pretty clear if you have an opportunity to find out how many people are online at one time. There are also a lot of eyeballs on the screen at any given moment.


#### From Sharing Silence to gm

[13:19] **Henry:** Yeah. I found myself like not using it much anymore. Sacasas was saying how like there's no way to be silent. Mm-Hmm. Online.

[13:27] **Drew:** And there's no like silence paired with presence. It's like people would notice if you, if you were silent and on Twitter, then it would be perceived as an absence.

[13:37] **Drew:** It would be like, where did Henry go? But in the physical world, you can be silent and present at the same time. And you know, we could be sitting in this room together, not talking, and there would be. Some benefit of shared human contact there, even though there was no quote unquote content.

[13:55] **Henry:** So this reminds me of a game that I play a lot. It's called the Mind. You're supposed to be silent when you're playing it. In short, it's the numbers one through a hundred. It's a card game. And you need to play the numbers in ascending order. So like 1, 5, 23, and up. And it's a cooperative game..

[14:11] **Henry:** The trick is that you're not allowed to communicate what number you have or anything. So you can only use like body language. And so that's a great game to show nonverbal communication.

[14:20] **Drew:** Yeah, no, I love stuff like that. And I think it becomes, I also think it's sort of like almost a trapping of knowing somebody better or being closer to a friend or someone in your family that you can feel comfortable sharing silence with them while together? I think that's something that we don't really feel with people we don't know as well. You just have to keep filling the silence, but as the relationship deepens, it becomes more Okay.

[14:46] **Drew:** Which I think is very telling of the value of silence, that we kind of get more comfortable with it as we know people better. 

[14:53] **Henry:** Is that even something we want to. Introduce into digital space, or is it just like not a thing? There's live streams and discords where people join and they just study together and nobody is talking.

[15:06] **Drew:** I think in a way actually that, um, the GM meme is kind of that too, even though it is a thing. But because it's just the same thing being said over and over again, it kind of loses its. It's content and it just becomes this statement between two people without any real message. Like a nod. 

[15:27] **Henry:** Yeah, that sounds like the YO app. 

[15:29] **Drew:** It's just that reappearing. I mean, I've seen it in like discord rooms where everyone's just saying GM and that's the only message that's being exchanged in the room. And obviously the app that was made recently. But all that stuff, I think it speaks to some. I mean, that's also just kind of a joke. I can't really like assess whether it speaks to some deeper need, but it does seem to be like kind of an example of something that's not like content in the way that we normally experience it. 


#### Worn Out: Fashion and Public Space

[15:58] **Henry:** Should we talk about your post on Real Life? The title is called Worn Out.

[16:02] **Drew:** I wrote a piece for Real Life a month or two ago, so I became really interested in this idea of fashion as something that has a relationship to the public space and there's this reputation of. People in the Bay Area or Silicon Valley or in tech not dressing well and obviously in like New York would be the opposite end of the spectrum to that which kind of embodies everything that the Bay Area is not Culturally, people in New York are known for dressing well or trying to dress well or caring about that aspect of their self presentation, and I thought it was really interesting to kind of explore maybe the deeper reasons why.

[16:42] **Drew:** People in tech don't seem to value that. And my hunch or my hypothesis that I explored and argued in this piece is that fashion is something with positive externalities that enhances the public realm. And if you don't care about that, then you don't care about fashion. Now, I think there's another way of looking at fashion, and I mentioned this in the piece, that it is a sort of vain and self-aggrandizing practice so that people will think I am great, but I actually don't think of it that way. This is kind of a great example of what I was saying about living in New York. I notice just being on the street and how interestingly people dress is something that we all benefit from. If you dress interestingly, if you have like a flashy style, then it kind of makes the whole street scape feel more vital.

[17:29] **Drew:** And when people like think that New York is an interesting place to visit, that's a huge part of it. So the people watching, half of why it's interesting is what people are wearing. My argument in the piece was that tech isn't interested in creating those kinds of positive externalities, and they're not really interested in enhancing the physical public realm.

[17:48] **Drew:** And a lot of the environments that we spend all of our time in online seem to be these digital simul acra of public space that don't actually have some of the necessary qualities of public space, one of which would be. Like the fact that there is a commons, like a shared experience of things that's not sort of monetized or turned into data that somebody benefits from. I'm curious what you thought about that, or if you have any. 

[18:16] **Henry:** I was just thinking about myself. I have to admit, I never really cared about it. And then moving here, it made me feel.. Well, I guess I still don't care about it. It's funny and yeah, it's like we're both just being to ourselves.

[18:27] **Henry:** Maybe it's the same thought of science is objective and then saying that, oh, my non view of close is objective, but that's also its own view. There's no like, it's a statement. Yeah. There's no non view. It's just the tech. Attire or whatever is a thing, right? 

[18:41] **Drew:** Yeah. And you are saying, I never cared about what I wore, and then in some ways still don't? I probably dress nicer than I did before I moved to New York, just because the bar is higher for like, what, I guess like what's acceptable. But I think about it more now, and I acknowledge that I gather a lot of information about other people by what they're wearing, not in a judgmental way.

[19:08] **Drew:** Just there's a lot that you kind of gather right off the bat if you see somebody and see how they're dressed. And I, I've come to like, not only be aware of that, but to actually appreciate it. I think it's just really fascinating to see what you get, what you learned about somebody in that way.

[19:28] **Drew:** And I don't think it's about a competition. I don't think people are trying, there are situations where that's true, but it's not like someone's trying to be better than everybody else in the room. I think there is just pure self-expression happening in many cases. 

[19:43] **Henry:** Doesn't mean we should dismiss thinking about the whole industry of fashion, because you thought that some people were trying to show off, right? 

[19:50] **Drew:** Right. There's a consumerist element to it that is unavoidable, but that I think afflicts everything at this point. 

[19:57] **Henry:** Basically just being more aware of things that you didn't care about before.

[20:01] **Drew:** Maybe because I'm not an example of a person that dresses in a flashy way. I almost think it was like more interesting for someone like me to write it because if, if like you or I are appreciating this behavior that we don't fully take advantage of, I think it attest to the power of it. Like, I'm glad someone's doing that.

[20:22] **Drew:** It's not necessarily me. Yeah. But like with any public benefit or public good, everyone is glad to see. Yeah. That it exists, even if they're not all, it's rare that people are equally contributing to it, but everybody benefits from it. And I think that's important in healthy societies to have that dynamic.

[20:45] **Henry:** Yeah. I guess going back to like Commons, Andy Matus kind of post, and he mentioned like video games being a public good, but specifically the UI of a video game. So I guess once a video game comes out, everyone can just copy that ui. Remember the game 2048? That was like a copy of something else, which is also a copy of something else.

[21:06] **Drew:** All of culture I think could be said to be a version of that. Like music is often clearly, even great music is clearly deriving tons of its characteristics from what's come before it. Any art, I would say there's a version of that happening. It's very natural and it's what we should want because once somebody comes up with something that works, everyone else can adopt it.

[21:32] **Henry:** The style of it, it's like UI is just fashion of like software or something. Maybe tech cares too much about function. 


#### Modernist architecture and postmodernist software

[21:39] **Drew:** Yeah. I think that's actually a really good way of putting it. This connects back to architecture because in modernist architecture there was this idea, of form following function. The shape of something or the form of something should be a pure expression of its purpose. There was an idea that if something was perfectly engineered to fulfill its function, then there was an inevitable way they would have to look. And modernism kind of contradicted itself by not actually adhering to its own ideas.

[22:05] **Drew:** Because a lot of modernist architecture was just this like style that kind of got applied to everything in a non-functional way, but the idea was pretty compelling. And I think I see a lot of that in, in tech and how, how software is approached that if, you know, if something's not contributing to the functional purpose of the software, then it's excess and it doesn't really need to be there.

[22:32] **Drew:** It's like a completely different medium to think about that in, because code is inherently functional and it's not really visible. So like aesthetics get layered on top. And there might be a example of that that I'm like missing. But I think aesthetics always seem to come like after the, the underlying code.

[22:53] **Drew:** Again, with crypto, I think some of that may have like converged again. The actual act of doing certain things in code is not necessarily functional except to like express some point or idea. 

[23:05] **Henry:** Yeah. My friend Angus, he has a book called, like if Hemingway wrote JavaScript, it's really cool.

[23:10] **Henry:** He just implements algorithms and then he'll write them in different authors like Hemingway or Shakespeare like, and he'll have like different ways of writing comments. So it's like showing you how aesthetic coding can be. It's also just writing.

[23:21] **Henry:** One of the first things I worked on was what's called a code linter. And you know, like linting your clothes, like get off like, you know, hair or whatever. And so we have that, which is essentially just spell check for coding, but it's only aesthetic. So it's like you need a space here. You, you need to change your name and your variable.

[23:37] **Henry:** It's really helpful on a team where you have like a hundred people, you wanna make sure that. Everyone's on the same page. So we have a standard. But the problem with standards is that it removes the ability of people to express themselves. And so some people might protest against the use of a linter, at least on your personal project. Just let me do whatever I want. 

[23:55] **Drew:** Well, that's really interesting. And I, as a non programmer, it's interesting to me that there is, you know, like that there would be like a desire for expression just in the way the code is written and like how it raises the question of how much flexibility should there be?

[24:10] **Drew:** I was thinking as you were describing that there, it's code is weird in that you consume it two different ways. You can actually read the code as it's written or you encounter it as a user who is experiencing the, the results of the code. And like the latter is obviously much more common and something you don't really need any literacy in engineering to do. It's actually the purpose of it to be something that people can engage with without understanding the underlying code. But I don't, I guess there's a version of that with reading a book. Like you could read the book or you could experience the second order effects of the book as it disseminates through the world and affects culture.

[24:55] **Drew:** But with code, I think that loop is much tighter. The relationship between what's written and what the effect of what was written is a very direct and predictable relationship. 

[25:07] **Henry:** I also think about how people create programming languages themselves. Yeah. And usually language design is top down.

[25:14] **Henry:** That makes sense. You have a group of experts that kind of decide what goes in and our tool in a way, democratizes. That design because they can make their own things. Then maybe propose them to the committee and then they'll eventually get included in the standard, even though that might take like three years or something.

[25:31] **Henry:** That gets into this whole philosophy around how do you design a language and what's good for people? Should there be one way of doing things or should they be many ways of doing things? And so there's this guy, Larry Wall, and he's the creator of Pearl. Okay. And he gave this talk, like he said, that Pearl is the first postmodern programming language.

[25:49] **Henry:** Wow. Which I think is an interesting concept from a functional utilitarian point of view. It's like, yeah, you should only have one way of doing something 'cause you're gonna confuse people. 

[25:57] **Drew:** And there's also the idea that the best way is the way that you've arrived at. Yeah. And so why would you not, why would you do something that's not the best way of doing it? 

[26:05] **Henry:** Mm-Hmm. 

[26:06] **Drew:** But then there's hubris in that because who can like. Why would you assume that you found the best way to do something? I mean, I understand the desire to believe that, but it's unlikely to be true, 

[26:17] **Henry:** Even from the creator themselves. Like why do you think, just 'cause you made it, that you're gonna also be the best person to determine that? Cause Illich, he talks a lot about how standardizing, like I think it was a Spanish or Chinese was like a way for the government to like impose on their people.

[26:33] **Henry:** Through programs, like, okay, that's kind of true. You are making them think in a certain way. It might not even be intentionally, but it does that just by limiting what they can express. 

[26:42] **Drew:** Yeah. George Orwell has written about that too, how it's kind of a totalitarian action. I guess 1984 has that. The double speak and all the weird language in the book. He's written essays about that too and just how it shrinks the range of thoughts that people can have if you reduce the options in the language. 

[27:00] **Henry:** Yeah, and I think that it speaks to the idea that there's only one value in tech. Which is like ability and efficiency. But you're assuming that there's no other metric. 

[27:08] **Drew:** Do you think that's changing at all though? I feel like I see more evidence now that. There are those other value systems. Maybe it's just because I'm more plugged into the communities of people that are working on things than I was like 10 or 20 years ago.

[27:23] **Henry:** People are more wary of tech values. It's a very broad statement. I guess my concern, that's someone that's sympathetic to it, bringing in old values back into the new medium, right? It's so easy to do that by accident. The artifacts that we make, embody our values whether we want to or not. 


#### Code isn't just code

[27:41] **Henry:** If you have a different mental model of how the code works than them, that's why you can't understand it, because they are thinking from a certain viewpoint, and it's like if you can buy into that viewpoint, it'll be easier to go through the, say the tutorial or whatever on how it works.

[27:57] **Henry:** Instead of just pretending that like, code is code, you know, people say it all the time, unless you understand why they said something. You're just doing what I, I call like archeology, trying to figure out like a mystery. Like how do they do this? 

[28:09] **Drew:** That's actually.. As someone who, what you just described, I would say I've dabbled in coding, but I definitely am no expert and, certainly don't do it professionally at all. Actually, that's not even totally true. 

[28:22] **Drew:** But, the way you're describing it, I feel like the farther you are from it or the less you understand it, the more you would not realize that. If you don't have any understanding of coding as I don't, relative to someone like you, it seems from the outside more like there's likely to only be one way of doing things because it's kind of perceived as this super rational system for creating things that do things in very predictable ways. The more I've learned about how code actually works, the more I've come to understand what you just described. And it's much more of an art than I ever realized. 

[28:58] **Henry:** One way of thinking about it is just trying to be aware of the fact that like everything can have bugs. My code can have bugs, like my program, but then the browser that I use can have bugs, which it does. And then even the program language itself. Yeah, that can have bugs. And then the CPU that you use can have bugs like all the way down.

[29:16] **Henry:** So it's not that predictable. So they have to have error correcting, like built in to be resilient to like these kinds of random fluctuations of electricity or something. 


#### Infrastructure requires resilience 

[29:25] **Drew:** I like that you said the word resilient because I do feel like resilient is another word for there being multiple ways to do something. And that's kind of necessary for something to actually be resilient, whether in a system like a city or in code. I think it's a generalizable quality of resilience. 

[29:42] **Drew:** I mean, modernism, again, that was the problem with it. It kind of connects back to that idea of one way of doing things. I feel like a lot of the things that get grouped under the term modernism, a system that's completely totalized, that has one way of working and things that have more flexibility and more resilience built into them, have stood the test of time. And I mean modernism as a 20th century phenomenon. I think it kind of had its moment. 

[30:08] **Henry:** For maintenance and any kind of infrastructure you're gonna want that resilience, that's literally the whole point.

[30:13] **Drew:** Over and over again that, that you want things to be resilient and only in like temporary periods of time where people forget about what's gone wrong in the past.

[30:25] **Drew:** Does it become possible to like produce something that's not resilient? I mean, honestly, we're probably in another one of those periods. I think we're always in a period like that in some. Aspect of life where like something's being over-engineered to be kind of too rigid or too narrow and we ultimately pay the price and we learn too late that like we should have made it more resilient. And then we learn the lesson in that space, but then we make the same mistake in a different domain. Yeah. 

[30:54] **Drew:** I also think one of the best and like most time honored sources of resilience in different areas of society is just more people having agency and more people being empowered.

[31:06] **Drew:** And instead of having a more top-down system, having a lot of that agency sort of at the lower levels, what I think you could see that in terms of like communities, small businesses, the more of those types of things you have, the more resilient society usually is. The more consolidation happens, the more likely it is to be not resilient.


#### The commons as customs

[31:28] **Henry:** The commons. Like, you know, this idea that nobody can own it. There's no rules that you can even think of to impose on people.

[31:36] **Drew:** Instead of rules that are customs for engaging with it, but everyone kind of just understands what they, and everyone sort of sees. The commons as, as something to be protected and not to be.. 

[31:50] **Henry:** Managed. 

[31:50] **Drew:** Captured for oneself or.. Managed is a good word. 

[31:54] **Henry:** Those rules are internalized in some sense, like they're not written down. Everyone understands them.

[31:59] **Drew:** And it's kind of like the culture is like an organism that regulates itself in a constant process of sort of subtly nudging behaviors towards where they need to be rather than hard rules that are enforced via punitive measures. 

[32:16] **Drew:** Especially Illich's writing on the Commons is so valuable because when I read it, I realize how few examples there are of anything like a commons in contemporary life, even things that we think of as commons are not.

[32:30] **Drew:** And like when I say public space, yeah, that is not a commons. It's just space that's been, you know, marked off to be used by groups of people at once. But I think a, an actual commons in which you can, like gather resources or do more types of things is not even. It's not, it's like a completely different thing than public space. And I think public space is maybe a, a more restricted version. It's 

[32:54] **Henry:** usually just like space that the government allows people to use. Why can't I buy a ping pong table and then let everyone use it I can't even do that. 

[33:01] **Drew:** People's behavior changes when they know that they're not engaging with the commons. What you described, if that was not prohibited in the park, then it would instantly be a problem because too many people would try to do things like that. 

[33:14] **Drew:** Because everybody sees it as, I'm gonna try to claim as much of this as possible for myself, either temporarily or spatially. And in the commons, that wouldn't happen because the whole society that is the steward of the commons would understand that that ruins it. 

[33:31] **Henry:** Understood that there's some kind of way of managing, 

[33:33] **Drew:** there would be a protocol. Yeah. That was easy for everybody to follow and understand. 

[33:39] **Henry:** And maybe that inherently means that it has to be local and like Yeah. Not really scalable. 


#### Airport Lounge-ification of Cities

[33:43] **Henry:** It sounds like it relates to when you were talking about like airport lounges, right. 

[33:48] **Drew:** I think it was last week, the background of this post. I went to the US Open, the tennis tournament, which happens at the end of August and beginning of September in New York.

[33:56] **Drew:** And the venue, which I'm sure, I think this is like common at every stadium or arena now, but, there were these Amex lounges all over the grounds. And there were like chase sapphire lounges and it felt like an airport or something from an airport that's now been exported out of airports to urban environments, or, I mean, that's like a private space, a private event.

[34:18] **Drew:** But actually since I wrote that post, I was in Manhattan down by the South Street Seaport. And there was an Amex lounge. Wow. Just out on the street for people to use. And they had like a little bar and people could like charge their phones. But you just got in, if you have the card.

[34:33] **Drew:** And I was like, now this, this kind of logic is sort of disseminating throughout space where we have these enclaves that are kind of nested inside of other enclaves. And you need special permission or you need some special status often as a consumer. If you have the right consumer status, you get access to this space that everyone else can't get into.

[34:55] **Drew:** And that's not new by any means. But I mean, the airport's kind of a place where you're familiar with that and expect to encounter it. Because even getting into an airport, you have to clear the hurdle of having booked a flight. And then within the airport there's more and more exclusive.

[35:10] **Drew:** Spaces that you can all get into if you have like that specific boarding pass or this credit card that gets you into this lounge or some status on a certain airline. And now it seems like that's leaking out of airports and it's everywhere. And I think that that's probably been the case for a while.

[35:28] **Drew:** And obviously there've been different types of exclusive environments throughout history. But this feels maybe new because it kind of coexists so easily, and I think when everything is, is sort of digitally tracked and monitored, you can have the exclusive Amex lounge, like just right in front of like, like rubbing elbows with, with quote unquote public space around it.

[35:54] **Drew:** In the past, you would've needed a more heavy handed way to separate those different spaces out. But now they can all just kind of intertwine each other. 

[36:01] **Henry:** Are they just on the street or something? 

[36:02] **Drew:** Yeah, it was just like out in the middle of the street with like a little, like a rope around it. It's kind of funny. 

[36:07] **Henry:** That kind of reminds me of SoulCycle Peloton? Yeah. They have the outdoor makeshift gym, I guess. 

[36:12] **Drew:** Yeah. And then the space kind of becomes an advertisement for itself. 

[36:15] **Henry:** Because it is open, right? Yeah. Everyone can see it. 

[36:17] **Drew:** People see it and they wonder what they have to do to have access to it, and it just kind of bolsters the brand via that visibility. 

[36:27] **Henry:** Instead of like a gym where you.. I don't know if you can see through..

[36:30] **Drew:** Yeah. Well, a lot of gyms have big glass floor to ceiling windows, so you can see, I don't know, I don't know if that makes them seem more enticing or not, but I do feel like the Equinox brand is pretty like powerful.

[36:41] **Drew:** In different sectors like gyms or WeWorks, there's all these different versions of spaces where you're kind of buying a membership to a desirable space and then you have unlimited access to it. And that's kind of the product, is just being in the space and that's what you're paying for, rather than getting any specific good or service. It's more about just existing within the brand. 


#### McDonalds as the only third place

[37:03] **Henry:** And making it more like part of your day to day or just make it feel like it's just normal. Yeah, well, everyone goes to Starbucks, so it's like you go there to work. It's not even about coffee anymore. I think did, did they change the policy where like you could like just sit there or something? 

[37:17] **Drew:** I think there's been some different eras of that because there was a whole thing with.. I remember it came up last year during Black Lives Matter. Somebody got kicked out of a Starbucks and, um, they were forced to change their policy and allow people to be in..

[37:31] **Drew:** I think the question was whether or not the person had bought coffee. And I think now they've pulled back on that. You can be in there no matter what. I've always assumed that that was the case with any fast food type place. I always kind of thought that you could go in McDonald's and nobody would ever question what you were doing there. And actually McDonald's, I think has become one of the main public spaces that people use in different types of urban environments. Smaller towns that don't really have other third places, mcDonald's sort of fulfills that role, which is kind of a, a sad statement.

[38:02] **Drew:** And it's so like your presence in a place like Starbucks is still so compromised, but it feels public just because it is more public than most of the other environments we have access to. And I mean, it's kind of this consistent branded environment that appears around the world now, and you can find it. In any, like, pretty much any big city in the world and know exactly where you're getting what to expect inside. And I think that consistency makes it more desirable for people to like, or in certain situations people like welcome that familiarity, but it's not, I feel like a very small part of that is about the coffee.

[38:43] **Henry:** It is interesting that it's like, that's like where the corporate side is becoming the commons because the common is that knowing that we've all been to Starbucks.

[38:51] **Drew:** It's like discreet spaces where you would just be in them to make a transaction now evolve into like relationships that are ongoing.

[38:58] **Drew:** I feel that very strongly with the credit card lounges because it's all about forming a relationship with American Express and then you are in this club that gets different amenities and access to certain spaces and events and products and discounts and it's all about you feeling warm towards American Express and almost thinking of them as, some sort of people that are gifting you all these benefits.

[39:30] **Henry:** It's like a clan or a guild. I also read something about there's a dating ad Bumble. They're trying to make a space for people to have dates. 

[39:38] **Drew:** That's pretty interesting. I think it's in New York. I think it's gonna be a coffee shop or cafe or something. Anytime something I think of is an app like suddenly has a physical presence in the world, it always makes me laugh. 


#### Reverse engineering bodegas

[39:51] **Drew:** And I mean, there's more and more of the Amazon Go stores. It feels very weird and like bizarre every time I see one. Like I just walked past one the other day in Midtown. It's like sort of a AI generated like approximation of like what a store is. They are basically the product of, Amazon's data, about what types of things people want on a daily basis. That could be in like a bodega type setting. They just reverse engineered the corner store. 

[40:24] **Henry:** Yeah. That reminds me of when. People used to like ab test, like buttons and Yeah. The most trivial things. 

[40:30] **Drew:** Actually when I went, have you been in one of the Amazon physical bookstores?

[40:35] **Drew:** Yeah, I did. Yeah. I went in one of those a while back and I remember just thinking the same thing. It felt like the organization of the store was completely chaotic and not based on any traditional notion of how you should organize a bookstore. You know, like there's very, like, familiar conventions. If you go into a bookstore about.

[40:55] **Drew:** You know, there'll be a fiction section. There'll be, you know, poetry, like then all the different categories of nonfiction. In the Amazon store, it just felt, it actually felt like the physical manifestation of like the Netflix home screen where it's just rows of content filed according to different categories. Right. But they're not mutually exclusive. I can't even begin to like, yeah, yeah. 

[41:17] **Henry:** Well they're all like the most popular things, right? I wanna be able to feel like I can create my own serendipity, but they kind of force it on you and they're kind of ruins the joy of just finding something new 'cause of the algorithm.


#### Fake serendipity vs the city

[41:31] **Drew:** And it also feels like fake serendipity. Because someone clearly thought very hard about what you were going to encounter as you move through this environment. Yeah. And tried to make it more likely, whereas other, I think the serendipity as it has been known traditionally is more like there is no mastermind or like. Maybe there's a well-designed environment that makes it more likely, but it's not trying to ensure that you have a certain outcome. It just enables that to happen. 

[42:03] **Henry:** The fact that it might not happen is why it's serendipitous. Not that it was made to happen or it's a hundred percent gonna happen. That's how New York is as the city itself. Although I haven't had it happen recently, but I used to meet people I knew all the time, just randomly walking or taking a subway. 

[42:20] **Drew:** That's like one of my favorite things. I think everyone feels that way. It sort of releases this massive amount of endorphins or something that happens because it really does, like, I think it's some deep human, thing to value that or to appreciate it. 

[42:36] **Henry:** It's the opposite of let's schedule a date to like meet up or whatever. I just find myself wanting to plan less and.. 

[42:45] **Drew:** That would be the dream is like just to live in a place.. I feel like the last time I really had that, 'cause I've lived in pretty big cities, but I think that's, it's been said that like one of the reasons people like college so much is because it's the only one of the only times in their life or maybe the last time in their life that they live in like a walkable place where everybody.

[43:09] **Drew:** It kind of simulates like a community in the traditional.. Everything good about a community without a lot of the downsides. You have those serendipitous encounters constantly throughout the day. You walk everywhere, which in turn makes serendipity more likely. Unlike the more restrictive forms of community that have characterized like most of human civilization, college is not, it doesn't have like the confinement.

[43:33] **Drew:** You ultimately leave. And you are able to do whatever you want in a way that hasn't always been as easy in other types of communities. I think there is a lot to that, that it is like, you know, a place where like there's huge amounts of serendipity, which is just an indicator of a lot of other positive social qualities that we want.

[43:52] **Henry:** It's like a side effect where you can't.. Can't make it happen, but if you have those other things in place, then it'll go through. 

[44:00] **Drew:** It's like an outcome of a very intricately constructive environment that can only really arise over time with the ingredients being in place or the right characteristics of the place allowing. Things like serendipity to happen. It just means that it's a well-made environment.


#### Can digital environments enable serendipity? 

[44:17] **Henry:** Do you think that the digital space can do that?

[44:21] **Drew:** I think it can, but I think the physical environments are so complicated and the ones that we've like, like a city for example, or a town, there's just so much going on there it's very difficult to build every quality of that into a digital environment. So I think you can definitely enhance digital environments and give them better qualities over time and fix things and tweak things and make them better and make them more human. But I think that just because the nature of digital space is so fundamentally different from physical space, you're gonna end up with a different outcome.

[44:56] **Drew:** And anytime you try to simulate something that is present in the physical world, it's harder to faithfully reproduce it. I think you look at, like, I've, I keep referring to Twitter because that's where I spend the most time online. There's a whole different set of norms that exists on non-spatial digital environment like Twitter.

[45:16] **Drew:** That is like, there are moments on Twitter that feel like serendipity, but it's a completely different type of serendipity than the type that you get in the physical world. It's just a different type of environment. 

[45:29] **Drew:** And I think it's interesting when you see the types of features that people demand from a site like Twitter, which kind of is notoriously not added many new features or changed the product much over the last decade. But something like demanding the edit. But yeah, I think is a really good example actually. in the camp of like, we don't need an edit button. And I don't really see the benefit of it, but I think, I mean, I know why people ask for it.

[45:56] **Drew:** but just the way that we relate to like the information in front of our faces in an environment like Twitter, I think is so different. The idea of like a tweet being kind of like fully flexible and being changeable via the edit button, like the way that we. Would engage with, with that type of information is different than in the physical world when there's more of like, if something gets changed, there's more evidence that it was changed. 

[46:22] **Drew:** All this like fake news stuff that keeps coming up on Facebook or every, every website or, or platform, like, I just think a lot of it stems from the fact that we don't have as much context. On the internet and like we could, a lot of like what people want from environments that feel more spatial is just more context.

[46:45] **Drew:** And I think the physical world's very good at providing context and it doesn't come naturally to digital environments. 

[46:53] **Henry:** The history of where something came from. It's like I know that someone's used this thing or like someone's been here before, but like.. 

[46:59] **Drew:** On a piece of paper, if something's been rubbed out and rewritten, there's more evidence of that. That's like a narrow example, but I think the physical world tends to just leave more traces. 


#### Leaving a trace, a legacy, provenance

[47:12] **Henry:** Traces, yeah. 

[47:13] **Drew:** Of everything. 

[47:14] **Henry:** And it's maybe that goes all the way back to this whole program language thing. It's like that's not something someone thought of. They're not like, oh. Let's make it easier to track like what happened in the past or whatever. 

[47:23] **Drew:** Yeah. And again, I mean that to, to bring up, like NFTs again, that is like a, that's the type of like feature that I think is being sort of copied from pre-digital, like modes of existence and being replicated or like artificially introduced.

[47:40] **Drew:** The idea that like the providence of an NFT can be or anything on the blockchain, you know? Yeah. That actually leaves a. Trail immutable, like trail like I think that's the type of thing where we're reacting to some of the problems with earlier versions of, of software or, or the digital world. 

[48:00] **Henry:** Is it good to create that water cooler type place? You coming here is like you had to. Take time to go A to B, and then everything online's instant. So it's like, yeah, the waiting room, whatever that means, so that people have a space where they can stop.


#### Twitter as a waiting room

[48:17] **Drew:** The waiting room is an interesting example, like a place that you're in, but you're not really there for any particular reason.

[48:24] **Drew:** Mm-Hmm. You're just there. Yeah. Like I think that everyone ends up with some digital space that is like that. The default website or app that you go to if you're just mindlessly on the internet and not really thinking about what you're doing. Like for me, that would probably be Twitter. For some people it's a discord server.

[48:43] **Henry:** The feed is the waiting room. 

[48:45] **Henry:** It is kind of a waiting room. Like you're just, a bunch of people are just sort of there hanging around, like figuring out what they're gonna do next. That's funny because the waiting room is literally about time rather than space. Because you could be anywhere, right. And you know, you're in line for something else, and then now you're waiting by joining Twitter. 

[49:05] **Drew:** You're in the physical and digital waiting room at the same time. 

[49:09] **Henry:** But you've like outsourced the waiting room. 'cause you could be talking to the person next to you in line, but obviously you're not, you're not gonna talk to them. 

[49:16] **Drew:** I kind of said this a different way earlier, but I do think Twitter is interesting, and you could say the same of Instagram or Facebook, but it's this massive body of work that's being completely produced by mostly people that are in the middle of doing something else or like waiting for something real to happen, or like taking a break from like talking to somebody.

[49:38] **Drew:** I feel like all of my Twitter behavior is just in these tiny little moments between things that I would consider like real activities, and now I've tweeted like thousands of times and it, it's just like all the product of these weird fragments of time when I was like distracted from something else.

[49:59] **Henry:** Well, the way you use it is definitely reflective of that then, which I appreciate, but I don't know what I would say. 

[50:06] **Drew:** There are a lot of different approaches. some people very much take it seriously and think of it as a way to network or build their personal brand or promote something that they're doing. And I use it to promote things that I've done too. But my primary usage of it is stray thoughts that I'm firing off just to kind of get them out of my head.
