---
title: "Attending to Silence (Michael Sacasas)"
season: 3
date: "2021-09-01"
time: "57"
description: "How can we think about digital communication, let alone silence? Is it possible? Michael Sacasas is back to chat about a few of his last newsletter posts: the nature of silence, attention not as a resource, on hope vs. expectations, the arms race of escalation, manufactured needs, askesis or discipline, the commons vs. the public, and trustlessness and codes of law."
episodeLink: "62d7e144"
embedUrl: https://share.transistor.fm/e/8df2bd21
sidebar:
    order: 18
---

### Links

- [Impossible Silences](https://theconvivialsociety.substack.com/p/impossible-silences)
- [Your Attention Is Not a Resource](https://theconvivialsociety.substack.com/p/your-attention-is-not-a-resource)
- [Surviving the Show: Illich And The Case For An Askesis of Perception](https://theconvivialsociety.substack.com/p/surviving-the-show-the-case-for-an)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/silence.md)

#### Impossible Silences

[00:00] **Henry**: Hey everyone, this is Henry, it's been a while since my last podcast, I think. But yeah, again, I have with me Michael Sacasas, and we're just gonna talk about his last newsletter posts from the last six months, and how they relate to Illich and his thinking around silence, attention, and some other topics, like hair of all things.

[00:20] **Michael**: We'll be all over the place.

[00:21] **Henry**: We'll see where the conversation goes, which is very Illichian.

[00:24] **Michael**: Yeah. That's right.

[00:26] **Henry**: Maybe we can start with one of your posts called [*Impossible Silences*](https://theconvivialsociety.substack.com/p/impossible-silences).

[00:30] **Michael**: So I think various things that have led me over the years to think about silence. And, in this particular case, I was sort of struck by the fact that essentially silence is a critical part of human communication. It's meaningful. This is I think the important word, right?

> Saying nothing, in other words, is not the same thing as silence. Silence is felt. It is meaningful. It is not mere negation. In fact, it can be, as we shall see, eloquent.

[00:45] **Michael**: So if we're together and, you know, if we imagine something like a sorrowful or tragic situation, I don't necessarily have to speak words to meaningfully communicate my love or my care, right? So, two bodies in proximity being silent before one another are still having a kind of meaningful exchange as it were between the two of them.

[01:13] **Michael**: And so that's the title of that piece we were talking about, I called *Impossible Silences*. Because in a digital media context, that kind of silence is impossible, right? You can't have it. It presupposes the presence of bodies. And so if I'm on Twitter and there's some controversy, some part of the outrage cycle for the day or whatever it is. And I don't say anything about it, that silence isn't meaningful, it doesn't necessarily communicate. Or if it is meaningful, it's always in a sort of dangerous way, right? Why hasn't this person said something about this thing, because the expectation is that everybody sort of pronounces their opinions on what is happening, stakes out their claim, and, you know, puts down their take, et cetera.

[01:55] **Henry**: Immediately.

[01:56] **Michael**: Quickly. Right? Exactly. Because the cycle is going to be over in 24, 48 hours, so you have to get it in,

[02:01] **Henry**: And then maybe you feel the need to say oh, I took a break or I'm going on vacation. Almost like your excuse in some sense, even though it's just your life. Who knows what it could have been, right.

[02:11] **Michael**: Yeah. Silence can't just sustain itself. It needs explanatory comments as it were, right. The first time I thought about this sort of thing, I think it was way back in 2013. And it was a school shooting in Connecticut. And I remember feeling as I'm reading, I opened up Twitter and this is how I learned of it, or it had just happened.

[02:31] **Michael**: And I remember feeling the need to say something. And I immediately remember thinking why, you know, why is it that I feel the need to say something? You know, I have nothing to say to this, you know, it's, it's tragic. You know, it's upsetting, et cetera, but I just felt that, that, that imperative to speak. And I think it was a function of social media because the only way one exists on social media or appears before others is through communication right, through posting something, whether it's speech or a meme or whatever the case may be.

[03:02] **Henry**: Your box shows up on newsfeed, but that'd be interesting if like not saying something makes space on the newsfeed. But that's not how it works, right.

[03:11] **Michael**: Right. No, I mean, I actually thought what happens if you hit a space bar and you know, post to Twitter, does that show up? I have no idea. I was tempted to try it. But you know, and then I got sort of sardonic about it. And how would anybody know I'm being silent on Twitter? I guess I, you know, I post hashtag silence, you know, just, but defeat the purpose, you're so self aware of it.

[03:31] **Michael**: And so then even the silence kinda, you know, it's not performative if other people can't note it anyway. So it seemed to me like this is just kind of perverse incentive structure in the context of something like, you know, whatever tragedy happens to be front and center that given moment,

[03:48] **Henry**: And maybe that's related to like quitting too. I'm telling everyone on Twitter that I'm quitting Twitter, maybe it's sends the wrong signal. I don't know.

[03:57] **Michael**: Yeah. So in any case, and then I thought about the value of strategic.. I'm not sure who coined the term, but the idea of strategic silence. This is prior to 2016 when things began to get really crazy. But there was something that was causing a bit of consternation and drawing a lot of attention and whoever the provocateur was at the point at that moment was by all respects, a kind of insignificant figure.

[04:21] **Michael**: But he was receiving an immense amount of attention for the actions that, you know, had on viral on social media. And so even.. This is a well-known dynamic now, right, even if I wanted to criticize these actions, I'm in fact feeding into the growth of his popularity, on the terms of the attention economy, right. The only kind of negative attention is no attention. And so if I give him negative attention, I'm still spreading the message, his actions and his presence through my network. And so I know this is sort of a dicey, sort of way of thinking about this because we have so long equated speech with power.

[05:00] **Michael**: And we talk about speaking truth to power and that kind of thing. And so it's not that I'm suggesting that we must always be silent, but that there are moments where perhaps the better part of wisdom is to not even to challenge something, but to just let that message die in my little part of the network, right.

[05:20] **Michael**: By not commenting on it, it sort of dies with me and doesn't filter through to the other people that might hear it, if only because I'm criticizing it. Soin any case all of these different ways in which I think silences is valuable, can be lost, can be powerful, in digital media context.

[05:40] **Michael**: And so this last post was just to focus on, again, the dynamic of the meaningfulness of silence, how that meaningfulness is lost, because it only functions in a fully embodied context. I mean, I suppose, you know..

[05:55] **Henry**: Even now right?

[05:56] **Michael**: I was about to say, this is an interesting case because we're looking at each other, you know, we see one another, at least portions of one another's bodies it were.

[06:03] **Michael**: So I suppose in this context, our bodies aren't quite fully present, but, you know, we could be silent, you know, and that silence would take on some dimension of meaningfulness. I think it would still fall short of what the fully embodied experience would yield, but nonetheless, right, on social media, by and large, it's impossible to be silent in this way, right. To be meaningfully silent.

[06:26] **Henry**: Yeah. I mean, just thinking about this podcast. Depending on how you do it, it could be like an interview style. So then it's like the silence doesn't feel as, I dunno, natural, where when you're talking with someone, you actually do cut off one another and that's normal. But then for this stuff, it's usually like question, answer, question, answer. Just feels a lot more strict.

[06:45] **Michael**: Yeah. And even on radio, the worst thing that could happen, you know, if you're a DJ is for there to be silence, right. You know, and, and so you have this pressure to sort of fill the empty space. In a podcast scenario, you have a little bit of that. I think podcasts can be more informal. And maybe there's a little more space for that.

#### Silence as a Commons

[07:03] **Michael**: But yeah, part of what got me thinking about silence again when I wrote that a few months back was reading an essay by Illich. And it's one of his oldest essays and it's from when he was teaching Spanish to English speakers, in the context of his ministry in the Catholic church. So that they would be better prepared to minister to the immigrant population. And so he's essentially teaching language and he would give these meditations almost as it were, these brief reflections before the class. And so this is one of them.

[07:32] **Michael**: And in it, he talks about essentially the function of silence and in language. He had some very eloquent lines there, where he talks about how somebody's silences can be more meaningful than their words. And that part of really learning a language is to be able to read those silences, to be able to interpret those silences as they function in the native tongue that you're trying to learn.

[07:56] **Michael**: And he even took draws ultimately a kind of religious or mystical significance in terms of the silence of the soul before God. The receptivity, right, to being prepared to hear. And as you know, again, these sort of multiple dimensions, both with regards to the other, right, the other human being. Am I prepared to simply here to simply listen, to not be so interested in saying, you know what I have to say? That I'm being patient enough to learn and to listen. And that requires silence. And it had that also that, that kind of spiritual dimension for him as well. That struck me as a, you know, rather profound understanding of what silence can be. Of the role of silence.

[08:41] **Michael**: And if we think about the, we commented on it already, you know, the temporal, the pace of social media, there's very little time to reflect and to listen. And even the mode of listening silently, it doesn't really show up in a social way. I mean, I might do it, you know, I mentioned, you know, the, the practice of lurking, which in a sense is sort of hearing or listening or reading without speaking. So it's not impossible to do that, to listen carefully or read carefully on social media without commenting.

[09:17] **Michael**: But it loses its sort of social dynamic. Others don't know you're doing that right. That you're taking that kind of care. And then beside that there is the pressure to speak quickly to speak immediately, right. To get the take in before that particular topic moves on.

[09:34] **Henry**: I think it also relates to, you use this analogy a lot, of life as a gift versus control. So maybe being able to be silent, it's like kind of seeing the person or whatever they have to say, I guess, or themselves as a gift, right.

[09:48] **Michael**: Right, exactly. It's a mode of attending to the other, that is more interested in what the other may give to you then and what you may give to them, right. I think often we tend to think about, and again, I don't want, this is just sort of part of the human condition, I suppose.

[10:08] **Michael**: You know, I won't connect it very directly to social media, but just, you know, we want to be heard, we want to say what we have to say. And it takes a certain degree of virtue to be able to put that aside, to be less concerned with winning an argument or making my point, and to just to listen with humility, with care.

[10:28] **Michael**: And I think that that's a good connection. And it's about recognizing the other as a gift before you. And not just one more thing to manipulate. One more aspect of your experience to control and to just bend to your own wishes or desires.

[10:43] **Henry**: And seeing the other person not as a resource, maybe that relates to the end of that essay about like the commons and how silence gets turns into a resource and then it needs to be managed and policed. Then it destroys the commons. Maybe you could share the story about the loud speaker?

[11:02] **Michael**: Yeah. So he tells a story about how, when he was an infant. Obviously it must have been related to him at some point, but when he was an infant, he was brought to his grandfather's estate on an island off the coast of Dalmatia, which is a province within Croatia. And the island in his father's estate.

[11:21] **Michael**: This is what had been in the 1920s in the mid twenties. And so in large measure, in modern society, as we know it had not quite yet come to this island, right. He, I think it's in this context or maybe elsewhere. He says, many things were still being done on his grandfather's estate, as they had been done for hundreds of years. Even to the point of having a wine press that had been in operation since the 14 hundreds or something of that sort. So, so it was a very different world and social reality there at that point now.

[11:51] **Michael**: But on that ferry, that's bringing little baby Ivan to the island was the first loudspeaker that was being brought to that island. You know, he had a lifelong aversion to microphones. If he could help it, he would not use a microphone. And I think part of the reason for that is that it.. It gave a granted a kind of power that destroyed the idea of silence as a commons.

[12:15] **Michael**: And I think, you know, I've read that essay a number of times and trying to articulate what exactly does he mean by this? And I think part of what he means is that, silence is a commons is a space where everyone who enters into that space and to that acoustic space, if you like, is able to speak into it with just as much of a chance of being heard as the next person, right.

[12:39] **Michael**: So you introduce the microphone say, and then you've augumented one voice. Over all the others. And so that creates a very different dynamic in his view, right? It changes the sort of acoustic power relations of the situation. And it was just one of the many examples, I think in Ilitch's view where there was something that was commonly held and this case a kind of space sort of commonly held, which we could enter into just by virtue of being a fellow human being equally equipped with natural capacities, to speak into the space and be heard, but then a new device or technique or technology is introduced in such a way that it, it upsets those power relations, nothing.

[13:25] **Michael**: Of course, you know, I feel immediately the need to say Illich understood there were other power relations in play, right. You know, there were other ways of silencing people. And we don't need to be naive about those to still recognize I think the value of what Illich is saying. Yeah.

[13:40] **Henry**: Right. I mean, you could even argue that it could be democratic. You could pass the microphone to someone else, or other people can buy their own microphone. Maybe people might say that it's helpful. Same with social media.

[13:49] **Michael**: Yeah. I mean, I suppose. I think when you introduce ways of communicating that augment somebody's voice, I think what Illich would say is that you generate a kind of arms race, just an escalatory process. Right? So now I need to figure out a way to be heard over the person who is now thus equipped.

[14:09] **Michael**: And so, the end result is a situation, I suppose, where everybody has gained the power to speak, but in such a way that nobody can be heard. And so it's become in his classic way of analyzing these things, it becomes counterproductive. You cross a threshold where the advances, so to speak, have flipped in such a way that it makes it now very difficult.

[14:33] **Michael**: So even as I think about social media, right. Any of us, all of us with whatever number of followers we have or whatever the case might be. We have platforms, literally where we can speak. And yeah, I think most of us would say that there's very little to be gained from it in some respects. It's not a place where we feel like we can have productive conversations. The dynamics become destructive and polarizing. It's a case where many people are able to speak, but very few people can be heard or know how to hear any longer, right.

#### Attending with the Body

[15:10] **Henry**: Yeah. You were mentioning a while back that like silence is, at least within the presence of people, is a way of attending to people. That was related to like a different newsletter you wrote on like attention not being a resource. So attention, we think attention is the mental act of like focusing on something, but then you're like, oh, what about all these other bodily ways of attending? And I guess silence is one of those.

[15:37] **Michael**: Yeah, or silence is an observable sort of, I'm not sure what the right word will be, right, but silence is what happens when you're attending acoustically, right, in a sense.

[15:48] **Michael**: Yeah. I've written about attention on and off as so many others have over the past 10 years. And in this particular case, it did seem to me that when we think about attention, we tend to think of it without regard to what the body is doing, this is also kind of inspired by Illich. Illich in his later phase of his career of his writing was very interested in the body. Very interested in the senses, in what sight can be. He writes this sort of cultural history of how we think of what we're doing when we see, and it's an actually, very interesting history. It brings to our attention, no pun intended, this very seemingly odd ways of understanding sight as something that actually emanates from the eye and makes contact with the world beyond us, which would have been kind of Greco Roman and into the medieval period. The understanding of whateyesight is before modern day optics.

[16:41] **Michael**: In any case, so a lot of what I just call attention discourse, you know, thinking back to all the different people who have written about distraction and attention in online digital context, that discourse sometimes takes the body out of the picture. And I mean, I can understand why, you know, if I think about paying attention to something, I almost think of in fact closing my eyes and just sort of gridding myself, and thinking really hard about something, right. It's just this sort of intense mental act, right. It almost becomes synonymous with, with thinking itself and it seemed to me that it'd be worth exploring the idea of attention with a more direct connection to the senses so that, what I need to do to attend to the world is not just think harder.

[17:33] **Michael**: But to learn how to see, which seems like a weird thing to say, right. Because if you're, you know, ably sighted, you just think, well, of course you just see, right. There's no skill involved in that. You just look and there it is. There's the world. Of course you're seeing. But I think artists, especially, but others too, we'll notice that, will remind us that just to look as not to see. This is the way I sometimes put it, right. We can look without seeing.

[17:59] **Michael**: I think all of us have had an experience like this, where I have to actually patiently attend to something in order to see the fullness of what is before me. One example that I've used is an art historian at Harvard or Yale. And they write about, the typical interpretive essay that they would have their students write where they go to the museum, you know, look at this painting, write about it. But their requirement was that the students sit before the painting for a solid three hours before they write anything, right. Which seems, I mean, I don't know how that strikes you. I think it strikes a lot of people as kind of excessive. And the point of this, she writes about this exercise in part, because she says she's realized that we need to learn how to attend to things as well as you know, so every discipline has a way of teaching their students how to attendto the world.

[18:53] **Michael**: This is what she's trying to do. And what she relates of course is is that, you know, students would report back and say, yeah. I sat there for 10 minutes. I began to see this. It wasn't until I hit the hour mark that I noticed this about the painting. And she writes about this given her own experience and she uses a painting, is a 18th century American painting illustrate this, but it's this idea that you would have to actually be very deliberate, and train our eyes to see, in some cases and various human activities require us to learn to see the world.

[19:28] **Michael**: Scientists, the painter, the baseball player, right. I can think of just examples where vision needs to be trained, in an active way in order to see the world. And so that connects attention very directly to sightin this case, right. And then to kind of weave it with what we've been talking about earlier, you can sort of same thing for attending to sound.

[19:53] **Michael**: Right. You know, we have sounds all around us all the time. You know, it was interesting at the early phases of the pandemic last year, Reading a lot about people sort of saying, oh, I'm hearing the birds for the first time, or I've never noticed all this noise, right. And I suppose part of that, you know, if you live, especially if you live in an urban setting, had to do with the fact that there were fewer cars on the road, maybe less ambient noise.

[20:15] **Michael**: But I wonder how much of it just simply had to do with the fact that we were paying attention in a different way, right. And all of our senses can be trained, I think, in this way. This is what I was trying to, to get in that piece or that attention is not just a mental activity. It can be a fully embodied activity. Yeah. Does that make sense?

[20:35] **Henry**: No, totally. I think we talked about this last time, like the bike analogy. When you learn how to ride a bike, the bike paths, like kind of almost show up or they light up. Like you saw them before. And this actually happened for me where I finally started using this thing called Citibike in New York City. And then there's a bunch of stations all around the city. So you don't have to walk or take the subway.

[20:56] **Henry**: And because I didn't use it before, I would have ignored it. Maybe I thought was annoying. Or other people did it. I was like, oh, but I'm scared, you know, all these different ways of thinking about that thing. But then once I finally did it, I was like, wow, every time I noticed one, oh, maybe I should bike over here. It really changes your view of the city. But also like your life, like what you decide to do, may you spontaneously go somewhere else just because you can. So I think that really opens up things, because you decided look at it differently.

[21:27] **Michael**: Right, right. A guy named Rob Walker, I think Rob Walker's his name, has an interesting newsletter called the art of noticing. And every newsletter is a exercise you might do. Not physical in the sense of, you know, activities you might undertake, you know, or prompts to get you, to see the world differently, or think about the world differently or to become attentive to the world in different ways. And yeah, I think that'd be a good thing, you know, for us to do, certainly to counteract the degree to which our attention does kind of get siphoned into our devices, right. So, you know, with smartphone in hand, I've much more tempted to become inattentive to my surroundings, right.

[22:13] **Henry**: I think of walking on the street with your phone out, not looking at the road or anything. And then also this is related to sound, noise canceling headphones. I use those all the time now and it's like not just a safety concern, but it is interesting that you might not hear what's going on or just notice like things are going on. That's more of a recent thing I feel like too.

[22:34] **Michael**: Yeah. It's interesting. So I really liked Fahrenheit 4 51 by Ray Bradbury. And I think the book is often just lumped into this sort of anti-censorship thing. I think there's a lot more going on there. It's really interesting. And there's this theme of people encasing themselves, in such a way that they have just lost touch with reality if you like or the world. And my understanding is, this is before headphones were a thing, Bradbury envisioned what he called in that story, seashells, he calls them, right. And so they're very familiar to us, you know, 70 years later, as earbuds that people would put in their years, but it would sort of block out the world, right. And so it was also a world in which people move very, very fast. And so speed becomes an impediment to noticing the world. It's the difference between walking and driving.

#### Hope vs. Expectation

[23:27] **Henry**: Yeah, that relates a lot to like efficiency. And attentiveness in this sense is around being inefficient. Because I don't want to get from A to B and I'm trying to be aware of my surroundings, I will notice things. Is because the A to B mindset, right? I'm going to here to there. You're of course you're not going to notice anything. So I'm going to buy things or use things to make me not have to see or listen to anything around me, right.

[23:52] **Michael**: Right, right. It's interesting because as you're saying that it occurs to me that it works if all we ever want to do is the goal. Our self given goal, right? So this thing I want to accomplish.. Anything that prevents me from doing that or makes it harder or more challenging, it's just an inefficiency that I can eradicate. And if I get rid of it, I can accomplish my goal.

[24:15] **Michael**: But then I guess the other way of thinking about it, and this goes back to the idea of receiving life as a gift, is that there's an openness, I don't know what I may find, right.

[24:24] **Henry**: Surprise.

[24:25] **Michael**: Exactly. So often in terms of surprise, right? Do I live in such a way that I am prepared to be surprised? By my circumstances, by the world, by people. But if I only ever think about my self given goals, right? The goals I give myself to accomplish. You're inhabiting the world in such a way that you're not able to see what may be there. The gifts that might be there, right in your path.

[24:51] **Henry**: That's also the planned life, the world of control that you predict, right. Instead of knowing that there's a risk. Because you don't know, it could lead to failure, but it could also lead to something like good or amazing.

[25:04] **Michael**: Right. I think a profound theme in Illich's work, right? The opposition of the idea of planning. At the end of Deschooling, in that essay, Epimethean man, right. It's hope versus expectation, you know, expectation as regards as what we can expect because we've planned for it, and we've predicted and we've directed our technology towards the control in the things to make this thing happen, as opposed to an openness to what may happen. Yeah, it's a really.. I mean, in many ways I think this is sort of at the heart of the question of technology. As a kind of culture as a mindset as not just this tool or that tool, but a way of being in the world.

[25:45] **Henry**: right. And I guess that ties into his convivial tools.

#### Vendor Lock-in

[25:48] **Michael**: Yeah. And they're tools that, you know, very intentionally lock us in. Their point is to lock us in, into into their own dynamics.

[25:57] **Henry**: It's funny because in software we have like vendor lock-in right. You make it really convenient. And I guess that's why everything is free, so that you use it and then you depend on it. And we all know this, but I guess that's the whole radical monopoly, right. The whole idea of it is dependence, like cars.

[26:12] **Michael**: Yeah. That you can only imagine doing this thing through the service or through this product. And so you mentioned cars, right? I think in Illich's view, would, you know, true auto mobility is you and your own two feet taking you where you want to go. You don't depend on anybody or anything when you service or the industry in order to do that.

[26:36] **Michael**: Granted, you necessarily can't walk from Florida to London, but the idea that transportation gets reduced to having a car, in the American context, certainly right. My freedom of mobility is dependent upon having a car. And of course, we've built cities in such a way that that becomes a kind of self fulfilling prophecy, right.

[26:56] **Michael**: Or that education learning is reduced to what the school can offer me. And so there are all these ways in which, right, the idea of the radical monopoly is, you only now imagine doing this very human thing through the channel that this product or service or institution or technology has framed that are made possible.

[27:16] **Henry**: The key is like the imagine in a way, right? It's not just that that's the norm or that's what people do, but that you can't even.. Like people culturally can't conceive of anything else other than that,

[27:28] **Michael**: Exactly right. It's, you're locked in. I mean, that's when I think the power of culture in its deepest sense is when it forecloses alternative ways of being, right. Where you can't even think of something being done differently.

[27:44] **Michael**: And so you begin to think of it just as natural. This is natural. This is the way it always is, right. And I think that's when cultural norms are operating most powerfully, when you don't even recognize them as such and you mistake them for nature itself, right.

[27:57] **Henry**: So when tech becomes nature, I guess then you think that's natural, right? Like how do we not, like, how do we not communicate other than social media?

[28:05] **Michael**: Right. And I mean, there are so many times where I've had conversations like this. And I understand these things are complicated, because we've now created structures where these dependencies are active. And so, you know, especially if you're not already, well-positioned, it's very difficult to just say, well, I'm going to do without, or I'm going to opt out.

[28:27] **Michael**: But you know, I talked to people in various contexts and I've usually been associated with relatively small institutions that kind of struggle for funding. You know, don't have a great deal of resources available to them, and are often trying to draw people's awareness to what they're doing.

[28:43] **Michael**: And of course the default way of thinking about that now is what? We need a social media presence, right? We need a more active Instagram account. We need to purchase, you know, ads on Facebook and. It's difficult to resist that logic. And certainly there are a lot of businesses that may depend on Facebook, et cetera. And I understand that. But that's an example of how we get locked into thinking.. Our imagination is curtailed, right? Our ability to imagine alternatives becomes very hard.

#### Rat Race or Arms Race?

[29:15] **Henry**: And it's like weird because being aware of it doesn't even help in some sense. I think it's similar to this feeling of, you know, like the nine to five people want to leave the rat race, stuff like that. You can't help yourself. Or like maybe the whole GameStop thing that happened. Like you can't help yourself but want to participate in that to make money. Or NFTs and crypto like, to participate in that either.

[29:39] **Michael**: It seems to me with that kind of thing, that there's a sense that you're going to miss out, right? You have to get in. And if you don't your chances of benefiting from it, right. Or really, you know, profiting from it, whatever that particular thing happens to be are going to pass.

[29:56] **Michael**: And so it's that sense of.. I mean, these are very unhealthy.

[29:59] **Henry**: Scarcity.

[30:00] **Michael**: Yeah, it's right. It's scarcity in a sense, right? If you don't jump in, creates enormous pressures to do just that. And then the other really unhealthy dynamic is the arms race dynamic, right?

[30:11] **Michael**: Where if I don't upgrade in this way, my competitors will, right. And you know, the logic of cold war nuclear proliferation, right. If I don't have this many nukes, somebody else is going to have those things, right. So you feel as if there is no option but to escalate. And so in both of these cases, it can be enormously difficult to find another way of being

[30:35] **Michael**: And to survive, right. Because again, once the world gets structured this way, again, especially for the disadvantaged, and for those that are already in positions on the low end of the equality spectrum, it becomes extremely difficult to do that. To opt for that other way of life. You require a community, you require something more than just your own decision on a given day that you're going to live differently.

[30:58] **Michael**: Although, you know, at the same token. Yeah. I don't know. Sometimes I think maybe it's not as hard as we think. And maybe part of the problem is, is that we're locked into a particular way of imagining what a good life looks like. I don't know.

[31:15] **Henry**: Right. And everyone's different. I think it's more like, that makes sense, if you're in that kind of situation, I don't think anyone would expect you to even attempt to do that. But my like, I don't know if it's a concern, but just interesting to me, it's like people that are in a privileged position or it looks like on the outside, they're not doing it either, right.

[31:34] **Michael**: Or very few, right. I mean, I don't know how, you know, your own experience has been here are the people, you know, where your connections are, anecdotally what you've heard, but I mean, it seems to me that there's a lot of interest now in finding a different relationship to work.

[31:51] **Michael**: I hear a lot of talk about the four day work week. There's talk about the, you know, what is the source of the dynamics in the workforce right now, right? Is it that there are no jobs, is it that people are just holding out for better pay? Or is it just people who decided

[32:05] **Henry**: That reminded me, I read something about China actually. There's like a slang term for it in Chinese, lying down. And it essentially is like, they all quit, because they just want to metaphorically, lay low not do anything. Maybe that's like their version of exit and voice. Well, by studying or working, we're not going to increase our social standing at all, or just helping the government. So the only way to not help them is to just stop working entirely.

#### What in Fact Do We Need?

[32:33] **Michael**: Yeah. I mean, that is interesting. And at the heart of so much of this, you know, deciding what is.. What path do I want to follow? What choices do I want to make? What can I live with? What can I not live with? You know, just answering this sort of fundamental question of what do I conceive of as a good life for myself and my family, et cetera.

[32:54] **Michael**: Is this question of desire, of want. What we want. So the last thing I wrote, the last thing I put on newsletter. Also very Illichian in theme, is the idea, very simply put, maybe we want too much. And what we want, I can imagine how that will strike some people listening, but the idea here is chiefly about stuff, right? So this is a very, in some respects, very kind of cliched critique of materialism, right? The idea that if I just get more stuff, access to more services or more experiences, then I'm going to be happy.

[33:28] **Michael**: And so I sort of just drive myself to work as hard as I can. And I do that chiefly because I think that my satisfaction is always going to be connected to having more things, more stuff, bigger house. I kind of darkly joke about how the square footage of homes has nearly tripled in the last 70 years in the United States. And yet many suburbs are sprawling with storage unit facilities or because we just don't even have in these huge homes, enough space to store all the stuff we've accumulated.

[34:03] **Henry**: This is funny because we just moved. So every time you move, you realize you have like two times as many things as you thought, right.

[34:10] **Michael**: And maybe as, as you need. And so I think what Illich really came to see, and I think this was an evolution in his thinking, is that you can't just critique schools and modern medicine and the transportation industry. This is all what he does in the early and mid seventies.

[34:28] **Michael**: Because there were some more fundamental realities underpinning these institutions. They were serving in some respects what people came to think that they needed and wanted. And so you had to attack the problems that were at that level, and to expose these supposed needs, you know, as manufactured needs.

[34:51] **Michael**: Right. And to really learn to ask for ourselves, you know, what in fact do we need? And this is hard, right? It goes back to that thing that we just naturally think this is the way people are, right. So to have the discipline, I suppose, to deeply question even the things that we take for granted, right. In terms of what we think we need..

[35:11] **Henry**: He called those certainties.

[35:14] **Michael**: Right. These certainties. And for him, history helped, right. He was a historian at heart. And so going back and just escavating other now very foreign ways of life, and human ways of being in the world, right. In order to show us, I think, that the particular modern configuration of human wellbeing, isn't the only way to do well in the world. And in fact, it might be keeping us from the deepest sources of satisfaction.

[35:45] **Henry**: Right. I kinda reminds me of Alan Jacobs, breaking bread with the dead. I remember he was mentioning that like history, the reason why you would read it is so you get to see the present state from a different light. And I guess me personally.. Encountering one of these things where it's like, oh, the thing that I believe now is a very current idea, then it helps you that think that maybe you could question a lot of things that seemed important. People are completely different from before.

[36:15] **Michael**: Yeah. And I think you're right. It's sometimes just having this happen in one very specific way is enough to open the flood gate as it were. Now you are at least cognizant of the possibility that the things that you take for granted need not be so.

#### Askesis of Perception

[36:33] **Henry**: I guess related to that would be like, how do we do that? And maybe we could talk about your other posts, called it surviving the show, and then this other fancy word that people might not know of askesis of perception, right.

[36:49] **Michael**: Yeah. I think that that's just a transliteration of a Greek word; it's the word behind the word asceticism, which we associate with monks and, you know, severely religious people. But it is essentially just disciplining, right?

[37:04] **Michael**: Which if we might, even that word discipline, I think has a kind of a pejorative connotation. So training, right? It's just training. A form of training. And in a sense, this is what people in religious orders do, is they undergo kind of askesis, or training and disciplining of their desires, say for example. But athletes do the same thing, right. Even as we've talked about earlier, artists trained themselves to see the world in a certain way, et cetera. So, yeah, askesis is just sort of the idea of needing to train your perception, your vision.

[37:37] **Henry**: It's interesting. We have a really good picture of training ourselves physically, especially at the level of athletes, right. They have coaches, nutrition, and all the different things. But it seems that we barely know what to do to train your mental capacity, memory. People I've done research in it, but like, just think about the average person and professional, right?

[37:59] **Michael**: Yeah, now that you've mentioned that, in that post, I was drawing on a memo that Illich wrote to the president of a school, proposing a series of lectures. And so in it, he talks about how in his view, what has happened in Western educational context is that the training of the mind, reasoning, I guess, critical thinking skills, maybe it was one way of putting it, had been divorced from what he calls SKC or a training of the desires and of the body, right?

[38:34] **Michael**: That the person had been sort of severed, cut up into these different faculties or capacities and that around the 12th century, which is very critical for him in many respects, in educational contexts, in the university and the emerging university of 12th century, the idea of learning gets reduced to just the training of the mind, without regard for the heart and the body. Or what might be the relationship between those three faculties of the person.

[39:05] **Michael**: So I'm going to take this in a certain way and you tell me if it's helpful or not. I think of our angst about the current information ecosystem, right? And all the top of misinformation, disinformation, the proliferation of conspiracy theories, right? It's just this huge part of the discourse, right.

[39:24] **Michael**: Because people just want, how do we make people think, right. Or believe the right thing or whatever. So without getting into many of the dynamics involved there. This one sort of fundamental point is that, very often, people say, well, we just need better literacy skills or a better media literacy. We need to train people to laterally fact check. They're all these methods.

[39:46] **Michael**: But really, before any of that matters at all, somebody has to want to know the truth and somebody has to entertain the possibility that they might be wrong. Somebody has to have the courage to believe that their tribe, their people, their party, is in error. And to be willing to break with them, right. If that means coming to better understand the truth of the case or the matter.

[40:14] **Michael**: So in other words, all that to say is that there are moral virtues that have to underpin the deployment of any of these skills, right? All of these skills can, if these intellectual virtues aren't there, will not avail, right. In some respects, they may just reinforce the person and their errors. Make them more clever in their..

[40:37] **Henry**: That makes sense in light of conspiracy theories. That's sorta like, believe the science. If only they knew the facts, their mind will be changed. Just arguing with anyone, that might not be the case. And even in a religious context, you're trying to evangelize or convert someone or whatever, that you can't just say some facts, quote, unquote, and then that will lead to anything, really.

[40:58] **Michael**: Yeah. There's other dimensions of the human person that go into how we view the world, what we believe, what we trust. So often it's a matter of trust. And so I think Illich's point then in relation to this is that you can't just impart people with a set of intellectual skills. There's more that is needed. There's more that isn't needed at the level of human desire, of virtue.

#### Isn't Just Something You Can Code into a Program

[41:28] **Michael**: And in some respects, this also all involves.. The body in the sense that there are habits that we cultivate. Practices that we cultivate, as well. So Illich wanted to kind of reconnect all of these things, bring them together as a whole package. Which would, you know, I think bring us a lot closer to, not an answer to our present crisis, but certainly would avail us more than simply saying, well, Twitter just needs to attach some warning labels to some, some tweets or just ban some people or whatever.

[42:00] **Michael**: All of those really have just the effect of escalating the problem in the sense that then people think, well, now I'm being targeted. And this is what happens when a big media takes over. You don't really improve the health of the public sphere. Because the change isn't a technocratic fix, isn't just something that you can, you know, code into a program, I would say.

[42:26] **Henry**: That rings true as a programmer.

[42:30] **Michael**: Right. Which is not to say, again, that these other, so- there not even solutions, these other strategies have no place. But they're going to be incomplete and inadequate.

[42:41] **Henry**: I feel like that's so hard to like express. Maybe that's the whole point, like exposing or bringing in an imagination that there are other approaches. Maybe the only approach we have is this ban people, these kind of black and white sort of things, or very like technique oriented things.

[42:59] **Michael**: Right, right. And I mean that, that's just sort of nature of modernity in a sense, right. That if there is a problem, it's susceptible to technique. And we just need the right method, the right tool, the right sort of institutional structures. And then this problem will be solved or will go away. Right. I think the human person and thus human society is simply just more complicated than that. More complex than that.

#### The Commons vs The Public

[43:29] **Henry**: I don't know how to tie this to the essay, other than I guess cities are complicated. But I came across this essay by Illich called Hair and the History of the City. And we haven't talked about it yet, so I'm just curious what stood out to you?

[43:42] **Michael**: Right. And I had mentioned to you, I'll say it now, I have not read that before. So that was a new piece to me. And in very Illichian in a lot of respects, in the odd things that are ties together. To make this point in his talking about the skin as this, you know, in pre 20th century settings. I mean, he connects it to DDT, right. And the prevalence of DDT, which kind of makes bugs go away. But before that, it was very common for people to have kind of festering sores, resulting from bites and itches and, you know, it makes for a really awkward sort of discussion.

[44:28] **Michael**: But this way of thinking of tying the commons to the hair on one skin, right. So I think when I first saw the title, I was thinking initially of just a hair on your head, right. I think he uses the word fuzzy at one point, this fuzzy interface between the self and the world.

[44:45] **Michael**: And I guess his point is that, we think of it as a very.. It's a very fine line. It's impenetrable, right. And so there's me on the inside, and the world on the outside. And I think Illich's point is that traditionally that line would have been much more porous. Would have been understood in a much more porous way. Both literally, in the sense, right, that these bugs would have been a constant feature of my going about the day, you know?

[45:12] **Henry**: You just had to deal with it.

[45:13] **Michael**: You had to deal with it. Yes.

[45:15] **Henry**: Now, if like there's a mosquito, you get really annoyed, you get bug spray, all this stuff. But then, they didn't even bother to ask a doctor to fix something, because they didn't think it was possible. They live with it.

[45:26] **Michael**: Yeah, in a lot of cases, it wasn't. There was very little that could be done, right. And I think this is the part that probably just infuriates some people that read Illich. You know, because I think the immediate thing is what are you saying? Should we not treat our festering sores, right. You know?

[45:39] **Michael**: But I think that the point he's making here is that, as I read him and you can correct me as you've read this before, but the point is this distinction between the self and the other. In other words, the privatized individual. And then the human society being divided between the private and the public, with no room for the commons. Sometimes, I think when the word commons is used, I think that the temptation is to lump it into the public, right. When we think of like public spaces or public parks, right. But I think Illich thinks,these are three separate realities, right?

[46:13] **Michael**: And so on the one hand you have the very stark distinction, very clear distinction between self and the other with the skin, sort of a set boundary. And then what goes with that, that prepares us to think about the human experience being structured between a very clear difference between the public and the private. But I think the analogy is that, this fuzzier realm is the realm of the commons, right? It's not structured by somebody delineating it and saying these three acres are public space and it's constructed by legal fiat as it were, right. But it's constructed simply by the way that people use it. And I think he gives the example of a tree, right?

[47:06] **Michael**: In a public space, there are rules. You know, we're used to there being rules, right? You don't do this, don't do that. Don't walk on the grass, you know, keep it pristine. You know, there's still this deep regulation of the way that the space is being used. Which don't operate in the commons in the way that he at least understands them, right.

[47:24] **Michael**: So there's a tree. You know, the widows in the village may come to the tree for firewood, right? The children may come for twigs. The city council may use it for shade on a Sunday evening. It serves a variety of functions, right? It's nuts are reserved for the poor. And so everybody has a kind of autonomy in making use of it. And nobody owns it. So it's not private. It's not public in that it's not very heavily regulated in this sense.

[47:48] **Michael**: And so people relate to it simply by the accumulation of habit and tradition and use with a kind of relative freedom for everybody in the community to have their needs met by, as a space that's just freely available, right.

[48:06] **Michael**: And to get to that through skin and hair. And to connect that with a sort of understanding of the body is certainly a very unique path, right.

[48:19] **Henry**: Yeah. I just think it was.. And also he was pointing out like hair is simultaneously in you and outside of you.

[48:27] **Michael**: Exactly. It troubles the clean distinction between what is me and what is not me in the same way that his idea of the commons, I think, troubles the distinction between public and private.

[48:39] **Henry**: And a kind of got me thinking too.. He also does mention fur as well. How that used to be a symbol. Kings would wear like lots of fur to make them look a certain way. But it's like this weird dichotomy between who they actually are and what they're attempting to look like. And then also started thinking.. I guess modern people, we like to shave. We don't want hair. A lot of people actually don't like having hair, right. We only want it to be inside, I guess.

[49:07] **Michael**: Again, no, I think now you're really following Ilitch's paths, right? I mean, that's very interesting. I didn't even make that connection. But yeah, as you say it, I mean, I certainly have, anecdotal evidence of that being the case, you know, in terms of what we see as sort of cultural standards of beauty and attractiveness and products and services that are.. That's an interesting connection.

[49:26] **Henry**: I was just thinking you could take it down all the way, not that anything's wrong. What we put on our skin, and then the fur, and the clothes then also like, I guess plastic surgery and like those kinds of things too.

[49:36] **Michael**: And this is always a very interesting thing about Illich's approach to any of these questions. It's so idiosyncratic, but then kind of opens up all sorts of possibilities and creates connections that, you know, I don't, I don't know that I would have arrived at otherwise.

[49:49] **Henry**: Yeah.

[49:49] **Michael**: I have it open in front of me, that essay. It might be worth.. I'll just read this little quick part about it, towards the end.

[49:55] **Michael**: " The concept of the commons is not that of a resource. A commons comes from a totally different way of being in the world where it is not production which counts, but bodily physical use, according to rules that are established by custom."

[50:12] **Michael**: And I think there there are a lot of themes that pop up in the Illich's work during this time, you know, just in that short paragraph, that description he's trying to get at with the idea of the commons.

[50:24] **Henry**: And then I guess before that, "a commons is a space which is established by custom. It can not be regulated by law. The law would never be able to give sufficient details to regulate a commons."

[50:36] **Michael**: Yeah. That line stuck out to me as well. Recently, it was a reading group I was leading of measure for measure of all things by, you know, Shakespeare's play. And part of what struck me in that.. I won't.. How can I avoid giving a whole summary of the play?

[50:51] **Michael**: Basically it has this idea of following the letter of the law fastidiously, right? And so, it led to a conversation about how we relate to rules and the desire to make everything sort of rule based or to function.

[51:07] **Michael**: And there was somebody who was sort of arguing. Well, the problem isn't rules, you need enough of them, right. And I think the idea was almost that you could regulate human behavior. You can make bureaucracies function, you just need to keep adding rules to cover all of the exceptions that come out, right. Because the initial objection is that, if you apply the rule in certain cases, it becomes unjust, sort of obviously unjust.

[51:34] **Michael**: In the case of measure for measure, right? There's this totally disproportionate punishment for a crime, but it follows the letter of the law. And so can we.. One person in a group said well you just needed an exception for that. As if then, if you just generated enough exceptions, you would arrive at a legal code that covers all possible human circumstances, right. That eliminates human judgment.

[52:00] **Michael**: And this was what was really interesting to me because the advantage of bureaucracy, of course, is that you eliminate the need for human judgment. You automate. And before you even introduce an algorithm, right. Bureaucracy sort of automates human decision-making. And so you don't have to make a decision. And of course, there's this kind of classic, 20th century image of the bureaucrat. You know, you go into the DMV. You just want a simple thing done, but no, it can't because rule X, Y, and Z on the statute book.

[52:25] **Henry**: I was talking with another friend, Varun, and he was sharing with me. I think it was from a movie, but it was talking about an immigrant coming to New York of all places and trying to order a coffee. They want a coffee, but it's like, you have to say which one, like Americano. But then how much ice and sugar or whatever, all of these different things, they don't know. They're getting overwhelmed by all the different, not rules.

[52:47] **Michael**: The decision tree. Yeah.

[52:48] **Henry**: Right and it's like, I don't even know what I want. I just need to get out of here and then they just leave, right.

[52:54] **Michael**: Right. This is a person who doesn't know the language, the procedural structures. It's completely inhospitable, right? You can't make it serve your end, unless you've mastered the system as it were. But this line by Illich here in this particular essay, right? "Cannot be regulated by law? The law would never be able to give sufficient details to regulate a commons". Which is to say that all the human relationships that create the commons, you wouldn't be able to articulate all of those in a code, a code of law, not, a computer code. Because I think that the dream or whatever in some cases is to be able to do that right. To make human society perfectly legible and thus controllable and predictable.

[53:36] **Henry**: Right. And Illich is arguing that's exactly what we shouldn't do.

[53:40] **Michael**: Right. I mean, I think there's a you can't do it. And so the attempt to do it becomes destructive, but certainly I think normatively, you shouldn't do it, right?

[53:48] **Henry**: Yeah. That's the whole thing around algorithms and recommendation systems. Like these things that supposedly know us better than ourselves or we have these AIs that are gonna code better than us. But people have been talking about this for a while, like Michael Polanyi about tacit knowledge, right? There are things that we know that we can't say, will never be able to express, in speech to someone else or to a computer. That's why communication is so hard because otherwise we could literally transfer information to each other through like the Matrix, but like, that's not how anything works.

[54:21] **Michael**: Right. And how you.. this is forced, but to bring it all the way back to the beginning, something like silence, right? How does that the meaningfulness of silence get captured in that way right.

[54:32] **Henry**: And that's just like art and beauty. That whole thing about like, not everything that's good should be measured. This essay, programming as theory building, says that exact thing, why you shouldn't outsource your programmers is because what matters is the mental model that programmers create for their program, not the code. The code is just an artifact of the programmer. And once they leave, like everyone knows, like in a way that team that is lacking the person that made it in the first place, they don't know what to do, right. They don't know how it works. You can't just read the code and understand this is how it works.

[55:07] **Michael**: That's interesting.

[55:08] **Henry**: So that's how they call it archeology, right. It's like, you're literally digging remnants of what we call dead code. Because the person that made it, that understands how it works, isn't there anymore. And then you're trying to rebuild this like theory of what's really going on. And then you might come up with a new theory that sorta works, but that doesn't match the same thing. And dead code still works. It still runs. It'll still produce correct output. But because our requirements change, when you have to add new features, you're going to eventually introduce a bug or it won't work the same way.

#### Trustlessness and Codes of Law

[55:40] **Henry**: And so I think it's interesting tying all of this to crypto, where we're trying to program money. We're going to try to program legal stuff so that we don't need lawyers or middlemen. I think, generally, maybe that's a good thing, right? You don't have to charge for those things. You can automate things that seem like they don't need people.

[56:02] **Henry**: But I think that if you take that to the extreme, like what if we just make everything a program, I think we're gonna have the same problem. If crypto will be a convivial tool, it would have to be one where people are still in it, right?

[56:15] **Michael**: Right. You're better versed in this than I am. And so I always kind of hesitate to speak into this space, but I certainly have seen expressed at these sort of liberatory, emancipatory visions for what it could be. And you know, some pin their hopes on this as a way of sort of being able to generate a new society that doesn't depend upon certain existing structures. But then also, certainly been made aware of very different ways of seeing that, where the inequalities get, things we talked about earlier, sort of just replicated. And so, yeah. I can't say I'm doing much more than, than observing at this point to see how that plays out.

[56:52] **Henry**: Yeah, I'd be happy to hear more of your thoughts as time goes on, or happy to share more. I think it's easy to conflate that with like this thing about trustlessness within crypto, and then whether that trustless is just means less trust.

[57:09] **Henry**: So this guy Vitalik, he's the creator of Ethereum. I like what he has to say in a blog post. He says, "to me, the goal of crypto was never to remove the need for all trust." And all is emphasized. "Rather the goal of crypto is to give people access to building blocks that give people more choice in whom to trust. And then furthermore allow people to build more constrained forms of trust."

[57:33] **Henry**: So I think that's a more nuanced take. It doesn't mean we replace all people with machines, but that maybe they didn't have a choice and maybe this gives them more options. And this is still about trusting people. So I think that's a better view of what this should be about rather than like, oh, let's get rid of all the middlemen.

[57:53] **Michael**: Right. To do without trust, to create a system. And I honestly do need to take this more seriously than I have in kind of becoming better informed in this area.

[58:02] **Henry**: Yeah. It's a weird topic to end on, but I guess it's hard because there's so much noise in all of it. You don't even know where to begin.

[58:10] **Michael**: Somebody starting to try and make their way through it has a lot of work to kind of figure out where.. Who do I need to listen to? Who do I trust in these questions? No pun intended.

[58:19] **Henry**: It's funny though. They're talking about like removing trust. It's like, what about within this space?

[58:23] **Henry**: Yeah, I think that's all I had.

[58:25] **Michael**: Good to know that an unstructured conversation can carry on productively for a good while. Enjoyed it.

[58:30] **Henry**: Awesome. Appreciate chatting with you as always.

[58:33] **Michael**: Likewise, Henry.
