---
title: "Towards Shalom (Nicole Williams)"
season: 3
date: "2020-07-08"
time: "56"
description: What does flourishing look like? Nicole Williams joins Henry to chat about faith in a less reductive way (than many of us may of grown up with). On rationality, the Church as a body, education, liturgy, family, being productive, and simply doing things for it's own sake. Was rather hard to say what we were getting at until the very end, all tying back to a picture of shalom! (This was recorded in May)
episodeLink: "b04b21c0"
embedUrl: https://share.transistor.fm/e/b2b895b0
sidebar:
    order: 2
---

### Links

- The Machine Stops (E. M. Forster)
- Tools for Conviviality (Ivan Illich)
- Severance (Ling Ma)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/shalom.md)

#### Faith in Public

[00:00] **Nicole**: I think both of us found each other talking about religion and faith and that intersection with tech and our careers and our Twitter spheres. I think both of us share both Christian faith and also not having talked about that on Twitter for a long time and started to talk about that recently for a variety of reasons. Definitely interested in more about why that happened for you. But for me, it was normally.. These are not two popularly overlapping conversations that happen so.

> [Nicole's Twitter](https://twitter.com/nwilliams030) (you should follow her!)

[00:28] **Henry**: Oh, I didn't even introduce each other, but I have Nicole with me on this podcast. And I guess I'll just start by saying how I found you. I think it was when you did the thread about faith, right? What was the thing called? Threadpalooza or something.

[00:43] **Nicole**: VGR started Threadpalooza and you know, you like the tweet or whatever, and then he says, I'll give you one topic that he wants to hear you talk about or he thinks other people want to hear you talk about. And I got religion and you know, had never put all my views in one place, but had created a thread about just about everything else that I think about. So it was time.

> "OK 1 like = 1 hot take on religion." - [Thread on religion](https://twitter.com/nwilliams030/status/1206634214558486528?s=20)

[01:03] **Henry**: And I was just going through these, I was like, woah, this is really cool. And so that's why I reached out I think, initially.

[01:08] **Nicole**: Yeah. That was great. That was really exciting, that people reached out. Probably more good conversations from it than any other thread I've created. Honestly, I would say high returns there.

[01:18] **Henry**: Yeah. I think it's sort of like things that people are thinking on their own, but they're afraid or it's not normal to bring it up. And so when you do say what people are actually thinking, they're super motivated and want to talk to you.

[01:31] **Nicole**: Yeah, definitely. Do you follow Liz Brunig?

[01:33] **Henry**: I don't think so.

[01:34] **Nicole**: She's this Catholic, really interesting, lefty writer. She used to be an opinion editor for the Washington post and I think now she's at the New York Times maybe? But she definitely inspired me in this field because she's super insightful, has super non-traditional Twitter opinions and constantly just very honestly and humbly puts her views about her faith in Catholicism and how it overlaps with all of her work. And I think she definitely sort of set the stage in a way that few other people have on Twitter, which is cool.

[02:03] **Henry**: Yeah, and I guess even though Twitter is all about being public, yeah, what are you not just allowed to say, but what you comfortable with yourself right. And sometimes nothing's controversial, you just don't want to, I don't know if it's a privacy thing.

#### Apologetics and Rationality

[02:16] **Nicole**: Yeah, yeah. I just saw a few hours ago, Sonya Mann was asking about whether she should write an article about her, I think reconversion to Christianity? And it sort of made me think about that too. I think, for a long time my aversion to talking about it on Twitter was honestly having gone through a Christian K-12 school where you have apologetics classes, you know, literally learning about how to argue for your faith.

[02:39] **Nicole**: The biggest thing I realized coming out of that school was like nobody in the real world wants to just argue about the finer points of eschatology and you know theological doctrine. That's not how people really think about their faiths or like their lack of faith. So I think that that's why I'd always like shied away from that on Twitter. I just realized that well, I guessed very few people wanted to have a very public, but simultaneously very personal conversation in this space. But it turns out that wasn't true, so yeah.

[03:04] **Henry**: Yeah, I guess that's like a very specific way of, either you want to call it evangelism or arguing for your faith. I mean, arguing in itself is, that's like a way of thinking about it. Like instead of a conversation or a dialogue or having it be like super intellectual versus like personal, right. We try to be more objective, like, Oh, this is true because XYZ science, faith, that kind of thing.

[03:22] **Nicole**: I think you brought that up right after. I think the first time we talked face to face after sort of chatting via DMs for awhile, which is that like there's this interesting, very specific space discussion of faith is expected to occupy at this moment in time where often it's like specifically through the lens of rationality. People have sort of expected that to be the status quo and often that's not really both the place for it or a place where it's most powerful. I think we're seeing the window shift and throughout history the window has been very different. I don't really know why that is, but yeah.

[03:57] **Henry**: There's a slate star codex article about secularism and like new.. What's it called? New Atheists? I already forgot what it's called. Richard Dawkins and that whole thing.

[04:06] **Nicole**: Oh yes, yeah.

[04:07] **Henry**: He was mentioning something about how like that whole movement, if you want to call it that, died.

> "If I were to describe the power of New Atheism over online discourse to a teenager, they would never believe me." [New Atheism: The Godlessness That Failed](https://slatestarcodex.com/2019/10/30/new-atheism-the-godlessness-that-failed/)

[04:12] **Nicole**: Yeah, definitely. I think it's so true. There is totally an age where it was like the God delusion and the Dawkins delusion. And all these people, it was like, you either can have science or you can have faith, and these two, like they knock each other out, they cannot coexist. Yeah, I got really into that in high school too, which I think I got a little too into it and so retroactively, honestly, that probably, you know, jaded my view of talking about all this stuff on Twitter. Cause it's like never again.

[04:39] **Henry**: Right. They're saying that it's sort of shifted, that the people that were really concerned about that basically moved on to other things, It's almost like we're looking for a fight to win when we don't need that. It's like when I talk to people or faith comes up, I'm not trying to overtly bring it up out of nowhere. It has to have some kind of connection and when it does come up, that's not the first thing you were going to ask about right. It's actually more of a curiosity, like why do you even believe still? Or what keeps you going or not? You can talk more generally like what's the purpose of life? Like those kinds of things. And at least there it's not very combative. It's just kinda like they're curious and they might respect you cause you're your friends or they like you because of your work or something. That makes it more of just like talking instead of, I'm trying to convince you of something.

[05:23] **Nicole**: Right? Yeah. I think that's totally.. It's how it should be. I, it's so weird. Again, I was so afraid seeing, seeing my like very combative, argumentative self coming out of high school that was just like, this is the reality. It's going to be people wanting to argue with you or you wanting to argue with them and just like not the case. Like I think I also in that thread sort of said like conversions and losses of faith are not as rational as people talk about them being, and that's not a shameful thing either. I think there's such a lack of like awareness and discourse and sort of like belief around any shift in mental philosophy that you can't logically ration out step by step. And I think those things are often just as valid as the experiences you can fully verbalize and rationalize. And we're, we're seeing a shift towards that realization. But for a long time people took things that didn't follow rationality a lot less seriously.

[06:16] **Henry**: Okay. That's probably why people are spiritual in general, right? They feel like, maybe I feel this way too.. Rationality makes me feel less human in a way, even though reason helps me feel more human too, at the same time.

[06:30] **Nicole**: No, I totally get that. I think I've also just been thinking a lot about lately, the very specific niche that East coast, Protestant Christianity represents in the vast history of the church. And I really wish that, both now and retroactively, I had a lot better understanding of the church as a whole and its variety of tradition throughout history. I think the churches that I've been to and the Christian community I've been around the most was so predicated on a sort of east coast logical mentality. What is the framework for us working hard and what is the framework for success? And like all these different things. But there's like very little discussion of awe and beauty. And I was lucky to have a few Orthodox friends in high school, and I think they really, really, really understand that in a way that, I don't super instinctively, at least not related to my faith, yeah.

[07:25] **Henry**: Yeah. That's, that's really interesting cause that's the whole environment that we're a part of. And I guess if you're an atheist or a Christian, you have that usually singular view of what Christianity is about, right? That the people around you, they tell you what it's like. So then when someone else says, I believe in this too, they're like. But then you don't act like the people that I think that you are. I guess it's different, how we express our faith.

[07:46] **Nicole**: Yeah. Yeah. That's another one of those paradoxes that's really hard for me to get over. I think, where it's like in Hartford, I think people looking at Christianity externally to get over where it's like the Church's both strength and weakness lies in the body of believers like the church as like capital C lowercase C. What's the whole system there? Like the greater Christian population, not like your local church body? A lot of people sort of shy away from going to a church or like connecting with Christians who are truly super different from them in any way. And I think that's the greatest strength of all, but it's very hard to keep a cohesive body of people working for the same goal that are radically different. I think that's like one of those radical Christian tenants that we sort of like excuse ourselves from at least again, like East coast Protestant exposure to Christianity. That's another thing that I wish was taken a little more seriously.

#### The Church as Body

> Just as a body, though one, has many parts, but all its many parts form one body, so it is with Christ. For we were all baptized by one Spirit so as to form one body—whether Jews or Gentiles, slave or free—and we were all given the one Spirit to drink. Even so the body is not made up of one part but of many. [1 Corinthians 12:12-27 (NIV)](https://www.biblegateway.com/passage/?search=1+Corinthians+12%3A12-27&version=NIV)

[08:40] **Henry**: I think it's a great word, a great metaphor. The church as a body, maybe that is that rationalist part coming out of, most people just think the church is a building, right? It's not even the people. But now in a way that's tested, I'm going to bring up the present time. You know, we can't meet in the buildings anymore. So, what is the church then, you know, is that the people then, you know, the fact that we can all still worship together in our houses. Are we still the church? And I think most people would still say yes. But that challenges some assumptions about what it means to be a Christian, what it means even go to church.

[09:12] **Nicole**: Definitely. I remember this, one of my theology teachers in high school, had this great quote, which I can't remember the exact wording, but the idea was like, throughout history the church has always grown most in times of trials. Like that's when the church has flourished most, and I think that is something we're going to see now because it's like people are truly, you're forced to just both confront yourself and what you want because you really have to fight for like

[09:34] **Henry**: principles right.

[09:35] **Nicole**: Yeah, exactly. Like is a community of value to you and like what things that community are values. You can't just passively go to church, sit in the Pew, and walk home. I'm desperately missing human connection and I have to really actively pursue like that and taking care of the people around me even in a way that might not be as enjoyable as it has been historically. Even when my friends are like in mentally bad spaces or whatever,

[09:59] **Henry**: I get the extreme version of what you're saying, was it like the blood of martyrs is the seed of the church.

> "Plures efficimur, quitiens metimur a vobis: semen est sanguis Christianorum" - Tertullian ([Apologeticus](https://en.wikipedia.org/wiki/Apologeticus) L.13)

[10:04] **Nicole**: Hmm, Yeah, yeah, I think that was it.

[10:06] **Henry**: yeah, I think you're right though. Like in order to, it doesn't even have to be church, like any community. You have to be a lot more intentional now because you could just chill and do whatever you want, like watch TV all day, or whatever it is. you have to actively go to the zoom call or whatever it is to get community and you have to reach out to people. And I think because everyone's isolated and they're still working at home, like how many people are actually talking to people one on one or asking them how they doing instead of just going to meetings all day and then you go to sleep, you eat, and then every day is the same and they feel like time doesn't pass by.

[10:39] **Nicole**: Yeah. That's very true.

#### The Machine Stops and the Pandemic

> "It is lighted neither by window nor by lamp, yet it is filled with a soft radiance." - [The Machine Stops](https://en.wikipedia.org/wiki/The_Machine_Stops)

[10:40] **Henry**: So I mentioned this short story, The Machine Stops. And it was written in 1909, which is kind of amazing cause it's sort of talking about the internet, how people in this world all live in these cells. They could describe it like a beehive no one leaves their cell. There are buttons all over this room that you can push to give you whatever you want. So you could say like, I wanted the food and then it gives you a food. I want music, it'll give you music. So I started like Amazon or Spotify, right. Except this is a 1900. They figured out how to travel anywhere they want, but no one travels anymore cause you don't have to, cause you can like look at this plate, which you could say is Zoom or Skype. But in the story, the son of the mom wants to see her. And then she's like, I can see you. What more do you want? And he's like, I want to see you face to face. So he has to convince her to go to where he is and so they can talk. The first third of the story is just about her going on this Airship and then the, the trouble of physical movement.

> "Vashti watched his face in the blue plate. “But I can see you!” she exclaimed. “What more do you want”. “I want to see you not through the Machine,” said Kuno." - [The Machine Stops](https://en.wikipedia.org/wiki/The_Machine_Stops)

[11:39] **Nicole**: Hmm.

[11:40] **Henry**: There's talking about how back then which is now people like windows, they like seeing what's outside. And so the ship was designed with these huge windows you could see like the world and then they couldn't take it in. So they had to close all the blinds cause they don't want to see anything out there. Because they're in artificial light, they don't like actual sunlight. And she's like, the sunlight almost hit me, I was afraid.

> "Unless she was careful, it would strike her face. A spasm of horror shook her and she rangfor the attendant." - [The Machine Stops](https://en.wikipedia.org/wiki/The_Machine_Stops)

[12:00] **Nicole**: Wow. That's wild. That's so beautiful. I need to read it now.

[12:04] **Henry**: Yeah. it's the same as now in the sense that we are trapped. We do want to be out there, but that society is an exaggeration, what if we stay in this place where we ended up being okay with it. Maybe if you feel more introverted, you have different ways of social interaction, but this is the extreme where they don't even move anymore. The machine literally does everything for them. If you drop something on the ground, it'll pick it up for you. And so when they go on the Airship, it doesn't have the technology, so then everyone just looks at the book that was on the ground. And they just move on.

> "In the rooms, if the Bookwas dropped, the floor raised it mechanically, but the gangway to the air-ship was not soprepared, and the sacred volume lay motionless." - [The Machine Stops](https://en.wikipedia.org/wiki/The_Machine_Stops)

[12:33] **Nicole**: That's so crazy. reminds me of there's a black mirror episode that's pretty similar to that too. That's so interesting.

#### Remote Work and Education

[12:40] **Nicole**: I'm also interested in terms of remote work and this whole, like, I think like Google and Facebook and Twitter have all said that like for at least the next six months, if not until like 2021, people are at least allowed to work from home. I'm very interested to see, like, obviously there's already been this discussion around, schooling from home. If people don't have good situations or good internet connections and like how general like equity of access to resources will play out there. But I'm interested to see how people who might not be in as great of situations or not know that they instinctively value community as much might work from home because of external forces. Whether it's like monetary forces, push them to do that, and I don't know how far we'll go in terms of our ability to live quarantined in some sense before we realize that it can't work out for the long term

[13:31] **Henry**: Yeah. I don't even know. It's the seams. It's so weird. And I don't know if it's just the shock of everyone just trying to figure out how to even get, just to get a hold of yourself. Right. Cause I feel like half the time I'm just I just feel unmotivated to do anything.

[13:45] **Nicole**: Yeah, Have you read _Severance_ by Ling Ma by any chance? It's this really good book. It was written in 2018 which is kind of wild. It's fiction. It is about a pandemic and it's also about this girl who's living in New York, and it's supposed to be satirical. I'm fairly sure, like a satirical post-apocalyptic commentary on millennial working culture and all this type of stuff, and it is so surprisingly accurate to what is going on today. It's like she, this poor girl is sort of like in limbo for a variety of reasons. Partially like pressure from her family to work well and all this type of stuff that is so fully ingrained in our system that she stays working in New York for her company way, way past, like when anybody else is even still living in New York, let alone working. It's super interesting and it's like as the time goes on and quarantine more and more, am I like, wow, We are truly living out this book.

> "Leisure, the problem with the modern condition was the dearth of leisure. And finally, it took a force of nature to interrupt our routines. We just wanted to hit the reset button. We just wanted to feel flush with time to do things of no quantifiable value, our hopeful side pursuits like writing or drawing or something, something other than what we did for money." - [Severance](<https://en.wikipedia.org/wiki/Severance_(novel)>)

#### C.S. Lewis on Living and Dying

[14:38] **Henry**: And also makes me wonder like I really want to look into more, I'm sure people are doing this, of just the history of how people have dealt with the stuff in the past. I shared that C.S. Lewis article, where he mentions the nuclear age, you know, that everyone's afraid that we're all gonna die.

> "In other words, do not let us begin by exaggerating the novelty of our situation. Believe me, dear sir or madam, you and all whom you love were already sentenced to death before the atomic bomb was invented: and quite a high percentage of us were going to die in unpleasant ways." - [On Living in An Atomic Age](http://hebrew-streams.org/works/hayom/CSLewis-Living-in-an-Atomic-Age.pdf)

[14:53] **Henry**: And he was saying that death is a certainty, but maybe we forgot because of how comfortable we are. He was saying people have had wars or cancer and even pandemics. They said London had a pandemic every year. And he just casually mentioned that. How are they responding to that? The way they dealt with it was so different from us because maybe some of us can just sit in our homes.

[15:12] **Nicole**: that's true. I think this relates back almost to our beginning topic of Catholic commentary on sort of just how the situation being out of our hands more so than ever before is a really good reminder of both A, we're going to die eventually and B we have no control over our lives. And it's very much time to reconcile with what we value and how to spend our time. But also just quarantine is a reminder that God is a hundred percent in control of our faith. It is a trial to be valued essentially, which I think is something that Protestant doctrine teaches more distantly, but it's not my, it's not sort of like, people don't really talk about it super actively, so I appreciate that one.

> "If we are all going to be destroyed by an atomic bomb, let that bomb when it comes find us doing sensible and human things praying, working, teaching, reading, listening to music, bathing the children, playing tennis, chatting to our friends over a pint and a game of darts—not huddled together like frightened sheep and thinking about bombs. They may break our bodies (a microbe can do that) but they need not dominate our minds." - [On Living in An Atomic Age](http://hebrew-streams.org/works/hayom/CSLewis-Living-in-an-Atomic-Age.pdf) ([video](https://www.youtube.com/watch?v=oxFmkg5dcyk))

[15:52] **Henry**: And I guess sort of the fear that we had that in the nuclear age it would be annihilation of everything cause everything blows up and same here. Whereas like the sense of we talk about normal has gone. This kind of stuff can take over your mind in the sense he was saying that if we are to die, I wouldn't want us to be thinking about the bomb all the time, that he would want us I don't know what you want to call it, like dignity of being like, I'm going to like play games or listen to some music or whatever.

[16:19] **Henry**: I just like the normal things that people do in the day to day. And it doesn't mean that you should not think about a cure or any of that stuff. It's just saying that like a hundred percent of your time can't be focused on this pandemic. He talks about how like, what are you living for versus what are you dying for? So he's saying in the war case, if he thinks that, participating in the war was okay, just setting that aside. Dying for your country, he thinks it's okay because you are dying for the sake of other people. But he thinks living for the war, living for your country is not because he would say God is higher than that. Sorta like nationalism versus like what is needed.

> "The rescue of drowning men is, then a duty worth dying for, but not worth living for. It
> seems to me that all political duties (among which I include military duties) are of this kind. A man may have to die for our country: but no man must, in any exclusive sense, live for his country." - [Learning in War-Time](https://bradleyggreen.com/attachments/Lewis.Learning%20in%20War-Time.pdf)

[16:53] **Nicole**: Yeah. So that's a very interesting framework. I like it. C.S. Lewis was always incredibly knowledgeable about everything at all times. It's amazing.

#### The Secular, Spiritual Distinction (1 Cor 10:31)

[17:03] **Henry**: I think he was trying to talk about the secular, spiritual distinction? You know, what does it mean to be Christian or doing things in a Christian way versus like, if I want to be spiritual, then I should become a monk, or I should become a pastor instead of going into the workplace. And that's like the whole faith and work movement. I think he's saying a similar thing there where it's like, if you do it for the glory of God, then it's okay.

> So whether you eat or drink or whatever you do, do it all for the glory of God." - [1 Corinthians 10:31](https://www.biblegateway.com/passage/?search=1+Corinthians+10%3A31&version=NIV)

[17:24] **Nicole**: Right. Yeah, that idea for me has been so like, I don't know.. Transformative sounds very cheesy, but I remember one of our high school teachers.. I grew up in Northern Virginia, which is one of the most type A places in the world. Kids are super concerned with getting into their Ivy league schools and there's so much preparatory education and people are like stacking in their extracurriculars from middle school for their college applications. We were having this discussion in Bible class about career stuff. And one of my Old Testament survey teachers just said, you know, there's equal glory in you being a garbage woman that there is in you being like a pastor, a theologian, or like a great nonprofit worker and all these kids in the class just started arguing so strongly. They were like, no, that can't be true. Like whatever. And he was like, no, God's plan for you could 100% be you just being like a great garbage person or even like a mediocre garbage person. And it was like for weeks we were all discussing this. It's just so hard to wrap our heads around, but like it's totally true.

[18:27] **Nicole**: And like, C.S. Lewis has so many great quotes talking about this. They're like, if you have the framework of the greater context of your work, which is that glorifying God, to go back to the Westminister Catechism, "chief end of man is to glorify God and enjoy him forever."

> Q. What is the chief end of man? A. Man's chief end is to glorify God, and to enjoy him forever. - [Westminster Shorter Catechism, Question 1](https://en.wikipedia.org/wiki/Westminster_Shorter_Catechism)

[18:43] **Nicole**: God isn't like, Oh, if you glorify me in this societally accepted way, that's the best thing you can do. It's like if you were doing your work well in a way that is worshipful, no matter what it is at all, that is just as equal to any other form of working well. Which I think is great for contextualizing anything that feels like monotony or low skilled work or repetition. It's just extremely heartening.

[19:09] **Henry**: Yeah. And I think maybe part of it is just like learning to embrace our limitations as creatures, one way of putting it right versus God, and then being human, right? We make mistakes and we just don't want to show that we have flaws. To ourselves mostly not to other people too, but sometimes you have to realize it takes something on the outside that completely just changes your expectations of the future, right? To step back and be like, woah, I thought I was in control and that was just an illusion. And even talking about knowledge, we thought that I was certain about this, but then now I'm just like, wait, maybe that's not a hundred percent true and I need faith. Not necessarily a religious faith, but just trust that I can keep going. I have to make choices in my life.

[19:52] **Nicole**: Right, Yeah. That whole exercise of constantly giving up self. Interested in like control in your own life is so difficult. And it's something that I'm always like trying to work so hard on and yet it never feels like it gets any easier.

#### Reductionism in Disrupting Church

[20:09] **Nicole**: I also think it's so interesting cause there's so much discourse right now about Silicon Valley people being like, is the core power yoga like the modern worship. Or is this random thing, the modern replacement for church for people. And I think the one thing that, that basically always misses is it has to be the reason the Church, and the reason Christianity is so compelling is because you're not like doing some inwardly focused like, wow, I want to make myself better. It's like that is a second order effect of giving up self control basically to God, that was not a very great phrasing, but you get the intention.

> "Then Jesus told his disciples, “If anyone would come after me, let him deny himself and take up his cross and follow me." - [Matthew 16:24 ESV](https://www.biblegateway.com/passage/?search=Matthew+16%3A24&version=ESV)

[20:44] **Henry**: Yeah, denying yourself right. Picking up your cross, or even just caring about your neighbor, that sort of deal. And we could look to Christ as an example, right? Of him not only living his life, but then sacrificing his life for others. If that is our goal post or whatever, then that's different from just making yourself have better character or something. Improving myself, very stoic.

[21:10] **Nicole**: I think there's a lot of movements that get a little bit closer, people recognize sort of the innate good and not following your own interests and helping other people. But I think, people often react to that idea and are like, the people outside of me are no better than I am, and there's no context for helping people outside of you without God introduced to the equation. Like I've been thinking a lot about how you can't sort of like deconstruct the church and recreate it in other spaces, which is a popular idea. Some people are like, what if you just take worship, what if you just take the community aspects? How can you recreate just community without believing in God? And I think it's really hard to explain all of the parts, how they fit together perfectly, but you can't reverse engineer any of it. You can't pull out just helping everybody else forever without having the context of God.

> "If you are attempting to rebuild an institution that is over at least a century old and have no historical knowledge of the institutions successes & failures you are needlessly ignoring a history of people trying to solve the same problem as you" - https://twitter.com/nwilliams030/status/1208126575088197637?s=20

[22:00] **Henry**: Yeah, it's a system, that means it has interrelated parts. Like the phrase, a whole is greater than the parts, because that would mean that if you take apart the parts, it's not the same thing as adding them together. And if you just take apart one thing or you remove one part, the whole thing is completely different.

[22:13] **Nicole**: Right, right. Yeah. Like back to your point about the body of Christ as well, like that's the only context that it works is the whole is greater than pride. Like we help glorify God through helping each other in our challenges,

#### Unity and Humility in Family

[22:27] **Henry**: Yeah, in the secular point of view, we talk a lot about unity and diversity, right? That sort of initiative is related to that idea that like being the same and thinking the same, will just lead to the same answers, right? And I don't think it inherently means that just because people are different, everything's going to be okay. We catch each other's mistakes essentially. And, then the difference in the church is that there are people, you're not gonna like everyone. and we have to learn to love one another despite that. You may ask the question, why do we even join together? Right? Is it because we all want to help each other? No, it's because we all believe in Christ and Christ is the only way, the glue that sticks us together and will continue to stick together despite having disagreements. That's the idea. Obviously that's not true in reality but.

> "Just at this point Christian brotherhood is threatened most often at the very start by the greatest danger of all, the danger of being poisoned at its root, the danger of confusing Christian brotherhood with some wishful idea of religious fellowship, of confounding the natural desire of the devout heart for community with the spiritual reality of Christian brotherhood." - Bonhoeffer, [Life Together](https://static1.squarespace.com/static/518c65fee4b0887d9a39138d/t/5827e7aab3db2b0f3d311bf5/1479010229503/Life+Together_Eng.pdf)

[23:12] **Nicole**: Right? Like it's, it's super challenging, but if it weren't challenging, then it wouldn't serve the purpose, which is that, we're constantly learning very difficult lessons about loving people who are incredibly different from us and understanding their worldview and perspective and challenges that are like completely outside the realm of our own.

[23:30] **Henry**: I'm just reminded of like family again, you know, it can be really frustrating talking with them, but then their family, and I guess, I don't know, somehow you come back together. It's like, and that's another metaphor of the church too, right? That it's not really by blood, it's by the spirit.

[23:47] **Nicole**: Yeah, definitely. Has your perception of your family whether like literal blood family or sort of like really intensely close community and friends changed

[23:57] **Henry**: Because I'm at home now, yeah. I guess kind of going back to what we were saying about limitations, like I have to be honest with myself and see that, even though maybe a lot of people are like, wow, Henry, you're so nice and all these things. And I know that in a different situation, I'm not, and I realize with them, I do get frustrated and I get not just frustrated and get mad. I don't want to talk to them. You know? Like all these things come out and dang, I really need to step back and be like, why did I think that I was a certain way. You can be like, well, I can just ignore them. Once you leave the house, after you graduated or I happened to be in New York, I don't really have to think about it, right. Just like before the pandemic, all these things that were, I guess your own flaws, you don't see them until something happens.

[24:39] **Nicole**: Definitely. Yeah. I feel like I've been thinking about similar things, which is like a lot of my friends are in a space in their life where they're sort of hopping coast to coast, like pursuing whatever best option comes up to them, which is really exciting, and I think we live in a time where you can do that in an unprecedented way, but there's also a lot of realizations. It's honestly incredible, like so many of my friends are having this at the same time, including myself. Like nobody is immune to this, to not realizing this, but it's become so easy to sort of tend to relationships only when they're important to you. There's an unlimited amount of people that you can befriend who can provide that community aspect in your life, but being quarantined and being with people who are like a second family to me, it's just really, really magnifies the value of people that maybe you don't get along with like a good 50% of the time, but you know, no matter what, eventually you're going to reconcile on those people. You can be whatever you want in front of those people, which I get. Again, like the same thing as the church body, it can be incredibly hard to love those people, but it's like the strongest relationship type out of any, I think.

[25:48] **Henry**: Yeah like being able to be whatever, being able to be vulnerable, right. With what you're feeling. Especially in a church, they might be like, I feel like I don't believe anymore, or I feel like I don't want to go anymore, or I don't feel like I relate to anyone there. Those are all common feelings that people have. And I think maybe the rationalist view would say, either you can't say that or like, something's wrong with you. Or like not allowing people to express that.

[26:15] **Nicole**: Yeah, definitely.

#### Non-neutrality of Technology

[26:17] **Henry**: Yeah. How do you think that the church should think about community now? Cause we do focus so much about meeting together in person and now that we can't, we're struggling with the same thing. Maybe more specifically, I think a lot of people in the church view technology as like a thing, like a tool, right? That you just use. So if anything, they are less critical of tech than maybe a lot of other people. Everyone's using zoom. Let's just use zoom. And that's our thing. And we're not thinking about like, how is that changing our worship

[26:48] **Nicole**: Mm Hmm. Honestly, I don't know. It's so like. Everything still feels so new. I was even listening to this podcast about all the like law cases that are now taking place over video and they have like a very good in depth analysis of just broad statistics of how much less often people get asylum if it's over video, or different things like that. But that was really making me think about the nature of, like there's been a lot of good commentary about how exhausting zoom is and how, you know, it feels so close to human interaction yet you're not getting that actual satisfaction of being face to face with someone. I've been thinking a lot about how, if at all, liturgy should be different and how community can be restructured in the church. I don't know if I have a good answer, honestly. I think the actual structure matters a lot less than the intentions of people to be honest with each other and to be sort of there for people who might not have been perfectly there for them in quarantine.

[27:52] **Henry**: I would probably say the same. I don't really know either, but I mean, I don't know. The way we use technology is sort of like, Oh, this is how it was before. And it's like the same thing with church. Then it's like, let's just take God out of it, and then that's church. So maybe kind of reversing that, I'm just thinking out loud now. Church is like Oh, we can't be in person and let's just put tech in. And like, somehow it's going to work out, like that kind of feeling. And we know that it's not going to work. Then

[28:17] **Nicole**: Yeah, that's a good point. I feel very like sitting and watching a church service, like we live stream the church service that we normally go to, and I watched it with the family that I live with and it's just very odd, like where you do the passing the piece, and that's weird. It's less weird considering we have five people, but there's plenty of people who are just living by themselves and they finally like added a little addendum there to be like, if you don't have anyone around you, you can text someone, which just feels very sad.

[28:45] **Henry**: Do you want to explain what passing of the piece is?

[28:48] **Nicole**: Oh, the passing of the piece. Honestly, it is common in probably like Presbyterian, Anglican churches, which are, you know, Protestant denominations. And it is the idea that you basically want to remind people of like, wishing peace on them and their lives. Not only like, just hope them for it, but like working actively to like, work towards peace. Anything to add there?

[29:13] **Henry**: No, I just figured that, I mean, we didn't even do this for the previous stuff, but like, I'm sure there are a lot of people that have no idea for certain terms that we use. So maybe we should explain to, and just for ourselves to kind of.. no that was good.

#### Liturgy and the Senses

[29:26] **Nicole**: Yeah, and honestly, like broadly, I wouldn't consider myself Presbyterian personally, but I go to a Presbyterian church, which is pretty like high to medium, liturgy, which is basically just what is the structure of the church service that you run? Most of the time it's pretty informed by historical traditions and how people think you interpret Bible verses about like what God said is the best way to worship him is. And it's interesting cause for me. I don't know, I have very, For me when I'm in some sort of high church, like Catholic churches, liturgy feels much more meaningful to me than it does in Presbyterian church. Not sure why, but honestly, I could almost be much more moved by having worship, having a service or a message delivered, and then finishing it. Like, to me, that would be more compelling, but I'm not exactly sure why,

[30:13] **Henry**: Hmm. Yeah, I am not sure. It's sort of like what are we familiar with? Like if you know, like the words that people say, it just resonates in your heart and that will, that convicts me sometimes just people just talking. Right. But then for other people, like I haven't really been to a lot of, like high church services. I did, I guess, enter into a Greek Orthodox church and just hearing from my friend who's a professor and talking to him and he would say that incense is really important and smelling that. And he was saying like, if we're going to worship, we got our worship with all of our senses. From the abstract point of view, which is kind of ironic, I would say that cause we're talking about physical senses, it makes sense to me cause it's like. God wants us to worship with all of our mind, body, spirit. And so that would mean that, okay, then you should incorporate our hearing and our speaking and our sight and our smell. But in reality, I don't. I've never had that experience. Or maybe you think it's kind of weird. and so I think I'm more like you in the current moment, but I'm interested in how other people are going through their worship.

#### Habituation and Monotony

[31:12] **Nicole**: Yeah. I think it's like for me, I can't tell why. Cause I also have been on a big aesthetics kick on Twitter. I think partially just because I don't know, I like to be dramatic when people don't agree with me, but also because I think we are like lacking in aesthetic discussion about a lot of like major fields and how that plays into the compellingness of their ideology. And I do think it's exactly like you said, it makes it so much more compelling if you are. Fully preparing yourself and fully preparing your mind and your body and your senses to be in a different space, I think about this so much in quarantine when technically it could exist in the same room, in the same house, wearing the same clothes and not have all the parts of my day set apart. It means so much more when I'm able to have my phone and wifi off and go down for breakfast, silently and just think and, make sure to change and completely brush my teeth and put on my makeup and just do all of that silly stuff that makes a huge difference. I think honestly, maybe my issue with Protestant liturgy has a little bit to do with.. It feels more like rule following than it does something that's sort of like heart and soul That would probably is not a great excuse. I think that there's plenty of things that Christianity would say, even if you don't feel it with your heart, it's going to do it in practice. And then eventually, you know, it'll feel more compelling throughout time. So maybe, honestly, I just need to get over it, but that's my take.

[32:35] **Henry**: That's an interesting conclusion. I mean like I guess I don't disagree, it's so true because otherwise our faith is reduced to feeling, like only feeling and emotion. And that means that anytime I'm not feeling, that I believe in God or, or just depressed or whatever, then you're like, Oh. Then it becomes about you again. You're like, Hey, I didn't give enough willpower to believe when in the end it's about faith. So it's like I'm supposed to surrender that willpower to believe, not try to muster up some kind of courage or strength to like still believe when I actually, clearly I don't, and admitting that should be the first step of that process.

[33:11] **Nicole**: Yeah. It's interesting too, Aristotle kind of talks about this in Nicomachean Ethics with the whole idea of habituation, which is like, it's missing the God part, which is that ultimately God sort of sets the context for our mood and emotions throughout time. And I think habituation gets almost all the way there, which is if you just do something long enough, that faith will come, which is almost like a little bit more of a, I dunno, like more of an abstract thought without like that anchor of like why it will eventually come. Yeah. I find it, I find the idea that like anything through time and devotion, and even again, like whether it's work that you find very monotonous, becoming an act of worship, you can sort of set that apart as something sacred and something enjoyable and even beautiful. I think that's been saving my mind in quarantine more than anything else. Like if I can enjoy very like silly little tasks and make it something fun and beautiful and like a privilege to do. It just keeps me from going insane.

[34:10] **Henry**: Hmm. And just like being grateful for being able to do that. Maybe we were, we criticized it cause it feels mechanical. Like most people would criticize the idea of doing something over and over to feel it because they're like, aren't you just going through the motions? And that's usually negative, but, there is a sense that doing that can bring you back and especially in liturgy because you're doing it with others. The example would be that. You know, you show up at church anyway, even if you're not feeling it, but you see everyone around you, you hear everyone around you, they're all into it, and that will remind yourself Oh, this was me before. I think I can still be like this. Instead of just doing it by yourself, right.

[34:47] **Nicole**: Definitely. Yeah. one of my favorite writers, GK Chesterton has this quote about monotony and doing things over and over again and talking about how basically like what if God is more like young children that we realized in his love for doing things over and over again and his appreciation for just like the beauty of the process. And in the same way a kid will ask you to do the same thing, read the same thing over and over again. Maybe that's the way we should understand monotony in our daily life with this sort of joy for living and joy for experiencing things in and of itself.

[35:22] **Henry**: Monotony. I haven't really thought about that much, I guess I'm reminded of, Narnia talks about, like at the end the inside is bigger than the outside.

> “It seems, then,” said Tirian, smiling himself, “that the stable seen from within and the stable seen from without are two different places.” “Yes,” said the Lord Digory. “Its inside is bigger than its outside.” “Yes,” said Queen Lucy. “In our world too, a stable once had something inside it that was bigger than our whole world.” It was the first time she had spoken, and from the thrill in her voice, Tirian now knew why. She was drinking everything in even more deeply than the others. She had been too happy to speak - [The Last Battle, C.S. Lewis](https://en.wikipedia.org/wiki/The_Last_Battle) (102-103).

[35:30] **Henry**: Kind of tying that back to the whole doing things over and over. I think even in martial arts, they talk about how like, you know, swinging the sword a thousand times, the one stroke, right. And being really good at that versus like, doing a thousand different things.

[35:44] **Nicole**: yeah, definitely. Ballet too. You know, I love ballet and that's a huge. It honestly kept me from going insane, very much high, high school career where it's just the way you learn to enjoy the most silly repetition of tiny details as you chase this sort of, chasing endless perfection part, maybe less so ties in with Christianity, but again, like enjoying that process of just doing it over and over again. I found the Chesterton quote, which is,

> Because children have abounding vitality because they are in spirit, fierce and free. Therefore, they want things repeated in an unchanged. They always say do it again, and the grownup person does it again until he is nearly dead. For grown-up people are not strong enough to exalt in monotony, but perhaps God is strong enough to exalt in monotony. It is possible that God says every morning, do it again to the sun and every evening do it again to the moon. It may not be automatic necessity that God makes all daisies alike. It may be that God makes every daisy separately, but he has never gotten tired of making them. And maybe that He has an eternal appetite for infancy, for we have sinned and grown old and our Father is younger than we. - [Orthodoxy, G. K. Chesterton](<https://en.wikipedia.org/wiki/Orthodoxy_(book)>)

[36:46] **Henry**: Mm. Wow. That's really good, just like the theme of childlike faith in the Bible itself too. Cause you were saying how we do a lot of things that we think are silly. And I was just thinking about that, we already assume that that way of being is just wrong. Um, of monotony of, things that don't really matter because we're so focused on like work and efficiency and being, I would say like a robot, there's like this goal. I don't know why that we're just pursuing productivity so much that. Isn't that the aesthetic that we're going for and we're not questioning that there are other types of aesthetics out there.

#### Productivity and Fun

[37:21] **Nicole**: Yeah. Yeah, definitely. It's been good. I've enjoyed seeing more and more Twitter accounts pop up where it's like all these like, PMs or software engineers or like people who are typically at the center of like the productivity, maximizing discourse for totally understandable reasons. I have test out my fair share of productivity tools, but I've really enjoyed seeing people just like posting their flower garden or, you know, the new cooking trick they've learned, or some things silly like Celeste chia. I dunno if you follow her. but, salon she had just posting like, okay, give me doodle prompts and I will doodle what you give me. And just this massive thread of her doodling, silly, sweet little things, really enjoyed that evening at my feed.

[38:05] **Henry**: Yeah. That's really cool. it's funny cause I have an opposite example, my old roommate, he's more in the creative side, so he does like video and photography and audio Right. And then because of the pandemic and the quarantine, he basically convinced himself to start learning how to code. He doesn't want to like change his career. It's just that. you know, you're stuck inside and I want like some more control over my life in a way. That's what he was saying. And so the code, you know, like one plus one equals two and then provide this code. It does what I want. The machine only does what I code it. And so it's funny that he wants this sort of like control, but then all the tech people want the opposite. Not that it's also controlled, but it's like, I don't want to think about all this. You know, like these numbers. I want something where I can't even comprehend what is going on. I can't describe how to like do the cooking or the drawing or the gardening. It's just more magic, right?

[38:54] **Nicole**: Yeah, definitely. Balance is restoring nature is returning.

[38:59] **Henry**: I like that too though, cause I remember the conversation I had, I don't remember what it was about, but eventually they were saying like, it's like Henry, I don't think I've met another software engineer that, so didn't want to be like efficient and code anymore or something like that. I was like, Oh, okay.

[39:17] **Nicole**: But did you say that was what you wanted or they would just sort of assume it for you?

[39:22] **Henry**: I basically agree with them. So, yeah,

[39:24] **Nicole**: Okay. Okay.

[39:25] **Henry**: I've been trying hard to not be like that. realizing like, I was just. Thinking in a certain way. Obviously tech is a lot bigger than what we see online. Like reading other older books, right? like before I might've been like, Hey, I'm in JavaScript, so I'm going to learn about Java or Python or whatever. Like, just different, like the scope is way bigger than that.

[39:45] **Nicole**: Right, right, yes,

[39:47] **Henry**: I guess my other fear was like, I don't want to become so into philosophy and all that where people are like, what are you even talking about? Which I probably already am like, for sure, but it's still interesting to me.

[39:59] **Nicole**: Even if you have lots of esoteric interests, to have a good mix of them, you know, I think that's great. More people should maximize for that, not maximize, that's productivity.

[40:12] **Henry**: I actually, that's funny. I feel like in a way, I'm still approaching learning non tech stuff in a tech way. Like I just can't help myself from doing that. Um. another one would be like, people try really hard to look like they're lazy or they're not doing anything, but they're trying really hard to do it. Aren't we trying to not try it?

#### Learning is Autotelic

[40:33] **Nicole**: Yeah. This might be a whole nother can of worms, honestly, we'll see. Well, like Lambda school, there's that, but also like, I mean, even just what you were saying now, right, where like. Sometimes for some people, the thought of just reading a book that is not super current is like a detractor from productivity. Like why would you choose something that's less applicable or people perceive as being less applicable to like right now in time, I guess. I think. The need for like liberal arts education broadly is kind of become a meme at this point. And I think it's, it's tough because I'm also a super strong advocate for optionality somewhere between academia and like a technical certificate. But on the other hand, if I lived in an ideal universe, I feel like everybody needs a chance to go through sort of like a liberal arts education. I think the ideal way to gain like robust context in the world, not even from like, I think a lot of people view it as like, Oh, looking at philosophy, it makes you better at computer science. That's the worst way to view it. Like philosophy is its own thing. Philosophy helps you be better at thinking philosophically, which like if you apply it to computer science or STEM, like that's cool, but you're also kind of missing the point. It's not about gaining utility.

[41:51] **Henry**: I still think that way. It's like, if I learn about this topic, whether it's anthropology or cities or philosophy, then I can like be a better programmer. I mean, that's fine that I think that way maybe, but like you were saying, we should still remember that those subjects in and of themselves are their own pursuit too.

[42:08] **Nicole**: Yeah, exactly. I definitely don't think the first part of what you're saying is bad. I think like more people should be, again, this is another meme where people should be thinking at like the intersection of subjects. Super important, philosophy and like, reading for the sake of reading is good. It is virtuous to read for the sake of reading and understanding people's perspectives and emotions and just other ways of life that are more robust from yours is like super valuable removed from any direct application that it has on your life. Like if you were supposed to like live in a coal mine and not talk to anybody for like the next 20 years. I would still say like, read great books that would be a value to you.

[42:52] **Henry**: I feel this way now where, as someone doing software or even open source software, like we have a certain picture of what being a maintainer is. And so. I would like to say that part of my job is to just be a better maintainer. And that just means that I should study how other maintainers do things. And that's a very broad word. Being a maintainer could be maintaining a bridge, right? Or maintaining your garden. And, and someone might ask like, Henry, what are you reading about? I was like, well, I'm learning about how to be a gardener. And they're like, why does that have anything to do with coding? Um. I have to convince myself that it's worth doing that because I can't justify, like if I was at a company, I don't think I would be like, Oh yeah, I'm going to read about gardens. They're like, Oh yeah, now you're fired or something. Right? So, but here it's like, I should have the freedom to do that in pursuit of this goal. Of all kinds of people, if you're being supported by donations and people voluntarily giving you money. Obviously there's some sense of accountability, but you should have the freedom to explore that and it might not lead to anything and that should be okay. And I almost feel like every single thing I have to do has to be justified. Like it's like if that day and lead to, a faster code then that means you failed. and you're always scared of that

[44:03] **Nicole**: yeah, definitely. I think about that a lot in like, you know, the context of slightly different but like similar stuff, like even reading. I don't know, like I've been doing a lot of history reading about the history of science and how that was developed, and I catch myself being like, wait, how does this make me better at these things? Or like, how is this going to make me better at my job? Or whatever. And like, I'm sure it does. It probably does. Almost certainly does, but like, Yeah. It's valuable for the sake of itself in a robust sense that you can apply directly to any quantifying like maximization of these like vertical measurements of success.

[44:45] **Henry**: Right. It's like if it doesn't fit what I already know to work, then it's not worth doing this new thing. But then everything that is new has to be someone decided to do something random or like they're like, I wonder how this relates to this. Like my example is like with origami, right? In some sense that is just folding paper. It doesn't mean anything. But then you realize like people can use that to create machines in space, right? They use that to fold out like a solar panel or something. And that's like, if someone didn't make that connection and then we wouldn't have had that.

[45:13] **Nicole**: Yeah, definitely.

[45:17] **Henry**: I don't know. It's just being okay with doing things that are not productive on the outside But I guess there's a balance cause obviously not everyone can just do anything and then like nothing gets done. But like we're definitely on the other side of not doing it.

[45:32] **Nicole**: yeah. Personally, we're in this space where people are very obsessed with doing all the things all of the time.

[45:43] **Henry**: Right? As long as I can measure it like that, I was on zoom for eight hours, then I must you make yourself feel good.

[45:50] **Nicole**: right. When it's like an actuality, being on zoom for eight hours is just like zapping all mental functionality you have.

[45:56] **Henry**: Right. Until you actually have physical issues. We were talking about universities. Right? I think you were saying that you don't want them to exist? I don't know if it was that extreme but

[46:08] **Nicole**: Um, no. Well, I would definitely technically say I'm a little bit anti academia, which also comes so like. A little bit of background. I went to a Christian semi-classical semi-preparatory like K-12 school. Great experience. Loved it. Had a lot of friends who went to a Catholic school or something along those lines, they absolutely hated. But for me, we had like a pretty diverse theologically student population, which meant a lot of like Eastern Orthodox or like Russian Orthodox, or even just atheists, people who had very well informed opinions where they're like honestly discussing their thoughts in a way that a lot of people didn't seem to have a similar experience with in high school.

[46:49] **Nicole**: However, after that, I went to Liberty University, which is the largest evangelical university, at least in the US if not the world. Went there for one semester and dropped out for a variety of reasons. I was actually going to transfer to Wheaton, which is another Christian school, but I couldn't, both for financial and like family complication reasons. And so yeah, I think being at Liberty for a semester, paying like \$22,000 or whatever, really made me question what education was for, what I thought it was for, what I wanted it to be about. People there didn't enjoy learning, and it wasn't even a particularly great preparation for the real world anyways.

[47:28] **Nicole**: Like it's another thing if you are checking the boxes and extremely efficient way and you hate doing it, but like you're certifying yourself or something. In my opinion, that's not really happening at Liberty either. But I think broadly people get a very narrow educational experience at many schools today that have sort of strongly departed from the original purpose for education. And then after that they're also just disappointed they can't get a job immediately. and college is just ridiculously expensive. There's no reason college should be as expensive as it is, like administrative bloat is through the roof I wouldn't say I'm anti-academia. Like my boyfriend went to UChicago and I visited as much as possible, and I love that place. It's a great example of how academia should be in many senses. But, I think a lot of schools are going to die out in the next 10 years.

[48:18] **Henry**: Do you think because of now that's going to be accelerated then, right?

[48:21] **Nicole**: Yeah, definitely. Mostly cause so many people are like, well, I could pay $500 for online school. That's like Coursera. You know, you can get that class with Andrew Ng about machine learning and pay, I don't even know. It's probably like $200 for the certificate. My actual university, like UVA is like taking a bunch of classes online. And I'm going to continue paying whatever like tens of thousands of dollars for tuition is. There's just no reason to do that. And all sort of like, definitely accelerate that realization for a lot of people. Also, one of the lasting values of universities I think I would go with, the signaling idea, being around community and being around other people who can then signal into the future or clarify that you have signaled well is the highest value and you lose a ton of that, if you're not on campus. And so, again, it's like they're just losing value on every front possible on the face of COVID.

[49:15] **Henry**: Right. Because at that point, you might as well try to make your own community.

[49:20] **Nicole**: Yeah, yeah, exactly. Homeschooling. Homeschooling is the answer. Honestly, not to college. I mean maybe also to college The same principles could be applied, but I think homeschooling co-ops, we are going to definitely see a big rise in those and there's a lot of like really great value in the way those are structured in terms of sort of like a decentralized but still community based structure for super high-quality educational experiences.

[49:46] **Henry**: Right? I guess that's what the Protestant church is supposed to be too, right? Small churches that are all supposedly on the same goal.

[49:55] **Nicole**: True. Decentralization is the future in every sense.

[50:00] **Henry**: I know people have been telling me that Bitcoin has something called the Genesis block or something, and like how, maybe he was inspired by Luther, but the first decentralization was like the printing press and like all that stuff, the Reformation.

[50:13] **Nicole**: That's meta.

#### Professionalization

[50:14] **Henry**: I don't know if you've heard of Ivan Illich before.

[50:17] **Nicole**: Yes, The Deschooling Society?

[50:19] **Henry**: Oh yeah. Okay. Then you already know. But yeah, he's pretty anti school. Cause he was saying education was its own thing. And we now think that school equals education. I read his book, Tools for Conviviality, which is another book. It's about technology. It's the same view applied to that in a way. A lot of people that actually made the personal computer are influenced by it and a lot of his points were around this idea of conviviality, meaning allowing individual people the freedom and tools to be creative on their own.

> "I choose the term “conviviality” to designate the opposite of industrial productivity. I intend it to mean autonomous and creative intercourse among persons, and the intercourse of persons with their environment; and this in contrast with the conditioned response of persons to the demands made upon them by others, and by a man-made environment." - [Tools for Conviviality](https://en.wikipedia.org/wiki/Tools_for_Conviviality)

[50:53] **Henry**: And he thinks that things like professionalization, industrialization. These huge institutions prevent that from happening because you have to rely on, in the case of school, you have to go to school in order to learn. If you want to be a doctor, you have to go to the medical school. If you want to be a programmer right now, you got to learn how to do all this coding stuff instead of providing the simple tools for normal people to do things. Same with like our house or anything, right. Everything that gets, I would say outsourced to someone else, you don't know how it works at all. And that's like the whole point because then I can just use it, but then when something goes wrong, you could have figured out before, but now you just have to defer everything to everyone else.

[51:30] **Nicole**: Right? Yeah. And I feel like so much of everything is, you know, everything is connected to everything, but so much of this is connected to quarantine to where people are learning to sort of like these hyper specialized human beings where it's like you get to enjoy, like learning this process that like you're not going to become an official bread baker or like whatever it may be, but it's enjoyable. It's enjoyable to know things, work and explore the world on your own with very minimal education? Well, minimal formal education I would say. And just sort of like explore, I think it's so core to recognizing yourself as a human being is explorative play.

[52:06] **Henry**: Yeah. I think the quarantine is like the perfect time to realize that people are doing things maybe like in New York, they always go out to eat like me, and then now you're cooking every day and then either you learn how to click it or you remember how to cook. You're watching YouTube about all the most random things. People are like gardening again. They're like trying to find random hobbies like everyone is. Learning to do things on their own, and be creative about it. I don't, they're making things instead of only consuming, I mean, it goes both ways, but

[52:35] **Nicole**: And it's so satisfying. Like I don't have the science to back this up, but I think so often like there's a little bit of science to back up that people who make their own food, especially in childhood, like they highly advised that you involve your kid in cooking and like producing all the meals cause you're a lot less likely to have eating disorders. Maybe this is too meta and maybe I'm reaching here, but like a lot of life is that way. When you're involved, you're involved as a person sort of in the production of the things that directly affect you. You're interacting with life and you're forced to realize that life isn't just happening to you. And then like every minute measure of your actions. It's very humanizing to sort of do that. And honestly, I've had a lot of friends Who struggle in isolation or struggle with depression. I don't want to make it misunderstood, not find a cure in any way, but find a lot of peace in being able to do things that take them out of their mind. However small and sort of like re-recognize their own self-agency I guess.

[53:27] **Henry**: Right? I think this act of participation or you could say like creation, right? That's an interesting way to put it. We say creative, but like maybe going back to God creating things and then wanting us to do the same, you know? I think that's, maybe that's where a lot of the joy comes from.

#### On Shalom

[53:38] **Nicole**: Yeah, yeah. I wrote my high school thesis, about the idea of restoring Shalom, which is super interesting. I could go on for a long time, but one of the core tenants of that is that in the beginning in the garden of Eden, everything was in Shalom, which means a state of flourishing state of the world as it's intended to be. And in heaven we will also be in Shalom. And so a lot of the way we can frame our purpose as human beings is to be sub-creators and sub-restorers of Shalom. Which is also cool. Like I was saying earlier, puts everything in the context of worship and like doing small actions of sub-creations essentially, that bring things back to like a state of flourishing, which for me at least, I find very meaningful.

> "Fantasy remains a human right: we make in our measure and in our derivative mode, because we are made: and not only made, but made in the image and likeness of a Maker." - [On Fairy Stories, Tolkien](https://en.wikipedia.org/wiki/On_Fairy-Stories) [(pdf)](http://heritagepodcast.com/wp-content/uploads/Tolkien-On-Fairy-Stories-subcreation.pdf)

[54:19] **Henry**: Yeah. Even going back to like the passing of the piece, cause I think people usually define Shalom as peace, right? But then that might not describe exactly what that word means, right? It's a little bit more than that.

[54:32] **Nicole**: Right? Yeah. It's like a very lossy English translation where we're like, you know, people say like peace. literally, even at home worship has been translated to people specifically. So they say the time of the passing of the peace and people look across the living room and go peace and glancing, which is like the worst thing ever, honestly. But like peace in a very full, hearty, like the nature, the coordinator of things as they should be. Yeah,

[54:58] **Henry**: Yeah. that would be like peace with, I think normally would be contracted with like war or like conflict. And so that would mean the absence of that. But then I think in the word it talks about more Shalom is what you said wholeness and fullness and quote as it should be. And that's different from neutral right? Like nothing is happening.

[55:15] **Nicole**: Right? Like thriving could even be almost the opposite in some senses like the absence of something. Yeah, exactly.

[55:22] **Henry**: Thanks for doing this!

[55:24] **Nicole**: Yeah. This was great.

[55:25] **Henry**: If people actually listened to the end, they can suggest topics for us to talk about.

[55:29] **Nicole**: Questions, call into the hotline. Just kidding, we don't have a hotline.

**Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter, @left_pad or @nayafia, or on our website, hopeinsource.com.
