---
title: "Reconversion (Sonya Mann)"
season: 3
date: "2021-01-03"
time: "34"
description: "How does one come to faith, let alone come back to it? Sonya Mann graciously shares some raw thoughts on her relatively recent re-conversion to Christianity. We cover a lot of ground, going through doubt and spiritual malaise, the phenomenology of faith, fractal reality, happeningness. (Recorded in September)"
episodeLink: "49627e60"
embedUrl: https://share.transistor.fm/e/51b15944
sidebar:
    order: 12
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/reconversion.md)

[00:00] **Henry**: Hey, everyone! I'm talking with Sonya Mann, sonyasupposedly on social media. After my chat with Nicole Williams, she mentioned that Sonya had relatively recently reconverted to Christianity and it might be an interesting conversation. So please enjoy our chat, where we just talk out loud about how she sees the world with this new lens.  

[00:19] **Henry**: This is a huge question. What led you to think about the faith again, in that personal way? That's hard to do, because there's trauma and stuff, right?

[00:27] **Sonya**: Yeah, it took me at least a few months to kind of relearn how to believe? What it feels like, what it could mean.

#### Coming Back To The Faith

[00:36] **Sonya**: I'll circle back to the beginning. So as I was saying before you started recording, I grew up Christian, going to church. Not like super fundamentalist or super conservative or anything. Just kind of like.. I live in the Bay area, so nothing here is all that conservative. And I sorta believed in that kind of young way, where this is the default you've been taught, so you believe it. 

[00:58] **Sonya**: And then I hit my teens, or early adolescence. I don't remember exactly why I stopped believing. I think I may have just kind of run into all of the sort of naive atheism without really having anyone who would push back on it. And I dunno, maybe I had to go through an atheist phase. 

[01:17] **Sonya**: And it was pretty long; it was until at least last year. But I made more religious friends as an adult. I think I genuinely did not know that you could have any kind of like intellectually coherent theism. I had never been exposed to the good arguments for religion. So I was always like, Oh, well just intellectually, it doesn't make any sense. And had not on my own come up with reasons why it could make sense or ways at looking at things in which it could make sense.

[01:48] **Sonya**: And so I knew these religious friends. We talked about it a little bit. I guess it just made me more open-minded. And then I felt a kind of spiritual malaise that I think a lot of people feel, although they wouldn't all necessarily describe it that way. 

[02:03] **Sonya**: And I decided to try praying more. And I've always been kind of a prayer, even during my atheist phase, saying [Hail Marys](https://en.wikipedia.org/wiki/Hail_Mary) and the Lord's prayer. Almost like as a calming ritual. And then I leaned more into it. I was like, all right, well, what if I just do this more and see what happens?

[02:21] **Sonya**: And then I started reading the Bible. And I was reading first Corinthians actually. And I should memorize the actual verse, but I don't remember it word for word off the top of my head. But, you might recognize it. It's when Paul says that Christianity is unsensable to the Gentile. Unreasonable, maybe. But the ones who believe, it all makes sense. 

> "For the foolishness of God is wiser than human wisdom, and the weakness of God is stronger than human strength" - 1 Corinthians 1:25 NIV (Probably 18-25)

[02:42] **Sonya**: I don't know why that exact passage made it click. I guess I would chalk it up to God's will. I just felt like, Oh. I guess I had some sort of.. I had a spiritual experience. You know, I felt touched by God's love.

[02:56] **Sonya**: And after that I was like, wait, what, just happened? And so that's when I spent a few months just trying to figure out.. Because like you said, it really does shake your foundations. And I'm still kind of rebuilding my worldview around this very profoundly different ethos, orientation, set of obligations also?

[03:16] **Sonya**: I mean, Christianity calls you towards duty. Or at least that's how I feel about it right now. So that's kind of how it happened. It was definitely gradual. And there was an epiphany moment, but it was built up to. I dunno if it could have happened any other way. I guess there's no way to know that.

[03:33] **Sonya**: You have probably heard a lot more stories of people's experiences with that kind of thing than I have. And I'm curious, if there's a typical way that people come back to the faith or maybe not?

[03:45] **Henry**: I don't want to speculate on the way, but malaise is a good word. There's this book called [A Secular Age](https://en.wikipedia.org/wiki/A_Secular_Age) by Charles Taylor. Taylor is a Catholic and he was talking about the secularization thesis, which was kind of saying something like the more scientific a country is, they will become more atheist. And he was saying that that's not true. The way people express their spirituality is different, but the amount of spirituality might be actually the same as before.

[04:08] **Henry**: You can see this now where even in tech, people love meditation. People love their fan fiction. There's fan clubs. There's CrossFit, SoulCycle, all these things.. They're not really religion, but if you want to define religion more generally, they are. There's a community. There's a sense of purpose.

> "There are layers of meaning to calling a company a cult. Many successful companies are culty in one way or another—the Apple blog “Cult of Mac” was not named entirely tongue-in-cheek. Some companies are cultish with respect to customers, like Peloton, which literally sells access to a scheduled ritual that makes participants more virtuous." - [Palantir: On Business, Cults, and Politics](https://diff.substack.com/p/palantir-on-business-cults-and-politics)

[04:24] **Sonya**: The writer, Byrne Hobart, pointed out that Peloton is a weekly ritual that improves the people who do it, which is kind of.. Hmm.

[04:34] **Henry**: Yeah, ritual. And he has this cross nova effect, that believers experience doubt and that's normal. People that don't believe they also experience times where they want to believe. I think doubt leaves room for faith. And You need to have faith to doubt things because you believe in something else, right? It's not all an absence. 

#### God Encompasses Doubt

[04:53]  **Henry**: And faith means that there's an aspect of surrender and giving up. Faith is not about me and how certain I am, but rather what you put your faith in, having the faith of a mustard seed to move mountains.

[05:07] **Sonya**: You reminded me of what one of the lessons that is often drawn out of the book of Job. If you thank God for the blessings, will you not maintain your faith and keep the faith really during times of suffering? If you truly give yourself over to God's will then either of those things, you have to live through.

[05:25] **Sonya**: And I guess I sort of feel that way a little bit about doubt. You know, if I'm able to take refuge and to take joy in faith, there's something that sort of feels almost fair about, well, I'm also going to have to go through the doubt. And I don't know, maybe I can also dedicate my doubt to God and try to find a way to use doubt to come closer?

[05:48] **Henry**: If you ask people the question, when have you actually felt either grateful or learned something, it's usually because of some bad thing that happened to them. We might use the term like testing of faith, even though everything about it just sounds bad. That a theology of suffering or of comfort sounds weird. Most religions to have some reason for suffering, even if they might not make sense.

[06:09] **Sonya**: That was something that I really had a lot of trouble with and that I still struggle with. You know, the problem of suffering. And that there is pain and evil in the world. You know, it's very upsetting, right? Like I guess. I almost feel like I went through kind of like a grieving process that was sort of concurrent with growing up more. It's just like, there is suffering. Like it is here. So my kind of fantasy counterfactual of a world without suffering just like does not actually exist. 

[06:40] **Sonya**: And that's something that I had to grapple with as an atheist then that I think I have a better understanding of now. Of course I would feel that way. I'm sure that people who are still atheist would think that I understand it less now. But so it goes.

> ["The purpose of a system is what it does (POSIWID)"](https://en.wikipedia.org/wiki/The_purpose_of_a_system_is_what_it_does)

[06:53] **Sonya**: I think the purpose point is interesting. I'm a big fan of this phrase from the cybernetics movement, which is, "the purpose of a system is what it does". I mean, you mentioned a little earlier that we often learn things from suffering. It's not the only thing, but it's one of the things that suffering does. 

[07:11] **Sonya**: At least in the sort of standard Christian view, this world is temporary, and our inhabitance of this world is temporary. And I think of when I was a little kid.. Like, how do I feel about my memories of pain, of the stuff that I went through years and years ago? And how will I feel about my memories of pain now when I'm in the afterlife, whatever it may look like. I don't know? And sort of that like zooming out perspective helps me.

[07:38] **Sonya**: And I think also just the acceptance that I don't have to know everything. I mean like you said, God encompasses doubt or allows doubt. Will receive you back, regardless of doubt. And can even like help you get through periods of doubt. 

> "Immediately the boy’s father exclaimed, “I do believe; help me overcome my unbelief!" - Mark 9:24 (NIV)

[07:52] **Henry**: There's so much richness in the Bible. I believe help my unbelief. It's an acknowledgement that I desire to know God, but yet I don't feel that way. And not that emotions don't matter; they completely do. It's just saying that the really important thing about faith is that even if I don't feel that I love God, it's okay. And we talk about this a lot in the faith of salvation by works.

> "About three in the afternoon Jesus cried out in a loud voice, "Eli, Eli, lema sabachthani?" (which means "My God, my God, why have you forsaken me?")." - Matthew 27:46 (NIV)

[08:14] **Sonya**: One of the most poignant things in the Bible is when Jesus is on the cross and he says, father, why have you forsaken me? And I really love that, that admission of fear and insecurity and doubt from the savior. It's very powerful. I wouldn't say that I've felt, you know, the exact same way as Jesus, that seems pretty presumptuous, but I've definitely had that father, why have you forsaken me feeling? But it's still an appeal to God, right? I feel forsaken, but I'm turning to you to have to try and help deal with it.

> "Be imitators of me, as I am of Christ." - Paul in 1 Corinthians 11:1 (ESV)

[08:47] **Henry**: And he's still deciding to obey, cause he could just be like, I don't want to do this anymore. Imitate me.

#### Imitate me

[08:52] **Henry**: And we want to follow rules or we want to follow the outcome. And in this religion, it's about following a person, which means following their character. And I mean, you mentioned virtue ethics in your post, [Thriverism](https://www.sonyasupposedly.com/thriverism/), right?

> "The King will reply, 'Truly I tell you, whatever you did for one of the least of these brothers and sisters of mine, you did for me.'" - Matthew 25:40 (NIV)

[09:03] **Sonya**: That reminds me of another thing that comes up in the Bible, where Jesus says, do unto the least of these as you would do to me. I might be mangling the phrasing there, but I'm sure you know what I'm referencing. And I also thought of this, cause you mentioned good works. To me, that reads as a call to really do concretely good things. If you know, Jesus appeared and came to be in whatever scenario, how would I treat him? And what would be the sort of material concrete commitments that I would make?

[09:32] **Sonya**: I'm called or at least I feel that way. That there's this sort of duty to live up to that expectation, that I would have for myself as how I would engage with God. Something that I think is maybe under acknowledged about Christianity, is that it really.. What the faith asks of us is huge. It's huge. And at least I feel like I'm only able to try because it's okay that I fall short, you know? 

[09:59] **Henry**: That is grace, right. Which is so hard to, not just get across, but for you to understand. And that's why we can talk all day about like all these things, but ultimately it has to be lived out. And that's where you can see the hypocrisy. But that's why it's a lifelong process, right? We use the term like sainctification right. It's okay to mess up. We can live our life, but we also acknowledge that, yes, we can never be perfect. We're going to try to get there anyway, and not by our own strength, right. 

> "Master, which is the great commandment in the law? Jesus said unto him, Thou shalt love the Lord thy God with all thy heart, and with all thy soul, and with all thy mind. This is the first and great commandment. And the second is like unto it, Thou shalt love thy neighbour as thyself. On these two commandments hang all the law and the prophets." - Matthew 22:36-40 (KJV)

[10:26] **Sonya**: Generosity is such a big theme of Jesus's teachings, and of course, life also. And that's something that I feel like that I'm asked to emulate by the faith. And it's hard. It's really hard to be generous, especially, the treat thy neighbor as thyself part is really difficult.

#### Open (Source) Generosity

[10:44] **Sonya**: But it's worth the effort and this actually blends in with open source in my mind where open source is this sort of ethic of generosity.  And I know that's one of the themes that you've worked with over the course of this podcast series. Do you look at your open source work in a religious way or does it feel like a separate domain? And I apologize if you've already discussed this in depth at some point.

[11:05] **Henry**: No, no. That's a good question. I guess I would say yes. And I'm like, that's like the only answer. Otherwise it's like, yeah, why would I be wasting my time doing all this stuff? Cause it does look like a waste of time on the outside. And sometimes it feels like a waste of time on inside too.

[11:19] **Henry**: But I think ultimately, I had this conviction in my heart that one way of expressing my faith is through whatever we do. And there's something about open source to me that reminded me of this idea of giving away. The phrase I would use is freely given, freely received, right. And there's a lot of problems, right? There's a whole sustainability issue. If I can't afford to give, why am I giving? And they're not giving back. And it seems like companies are exploiting us.

> "For though I am free from all, I have made myself a servant to all, that I might win more of them." - 1 Corinthians 9:19 (ESV)

[11:44] **Henry**: But ultimately it's a choice. And another verse from first Corinthians says though I am free from all, made myself a servant to all. No one is literally forcing me. I'm choosing to be a servant. And then later Paul says, to the Greeks, I became a Greek. To the Jews, I became a Jew. I become all things to all peoples. And that's really interesting cause that's the phrase meet people where they're at. I'm not trying to impose certain things. I want to learn who they are, understand them, connect with them, and find out not just their issues, cause I'm going to fix them or anything, but just like be in relationship.

#### Desiring Duty

[12:18] **Henry**: And I think one good thing about Christianity that we emphasize is this idea of relationship with God. And you can go too far, I don't need to go to church, and it becomes very individualistic.

[12:27] **Sonya**: There's maybe a sort of danger of forgetting the duty part of it. Or I'm actually not sure if I'm confident enough to say that every Christian should feel a duty. You know, that's okay, I suppose. 

[12:37] **Henry**: I think it's hard cause we don't really want to impose any sort of value, because we think that's the ultimate value. Maybe something we've lost. And even in open source, we can't say like, Oh, we're not going to let you in, because it sounds like we're being not inclusive versus saying there are boundaries and rules in everything. Sometimes they're just implicit and wanting to make them explicit is not bad. It looks bad because people don't take you in good faith if you do it.

[13:02] **Sonya**: It's often taken as an aggressive act, to make things explicit. I mean, one of the things that Christianity emphasizes is that we're all sinners. We all are saved by Jesus, not by ourselves. I guess I've always kind of bought the idea of [original sin](https://en.wikipedia.org/wiki/Original_sin). Like I feel like people are very flawed, so it just always kind of made sense to me. I certainly feel very flawed. And we're even, I think, constrained the choices that we can make by our natures. Who we are and then our experiences.

[13:35] **Sonya**: You know, I think the part of Christianity that I have the most trouble with is the possibility of not being saved, I guess. It feels unfair to me, you know? But I don't, I guess something that's maybe changed about me now that I'm older is that.. I dunno, I can just kind of feel that way and let it be. Instead of feeling like, Oh, I don't fully understand it in every respect and it's not like perfectly laid out and consistent. Yeah, I'm able to deal better with uncertainty now. Maybe it's the same thing with like, if I seek certainty from God, I should also be able to accept uncertainty.

[14:12] **Henry**: There's so many unresolved questions and things that don't make sense. Even the core parts of the faith. The Trinity, like three people in one?

#### Reality as Fractal

[14:20] **Sonya**: I see reality overall as being kind of fractal, where you have patterns that repeat on every scale. And that's kind of how I think of the core symbolism of Christianity. I see it like repeating on every scale, like the idea of generous sacrifice being what enables good things, kind of. Good things is too simplistic. I don't even know the words. I guess grace, maybe.

[14:45] **Sonya**: Without someone being willing to sort of cooperate first, I think of the [prisoner's dilemma]https://en.wikipedia.org/wiki/Prisoner%27s_dilemma), right? Like Jesus, in his prisoner's dilemma with the Pharisees, et cetera, et cetera, decides to cooperate, even though he knows that he's going to be killed.

[15:00] **Sonya**: And then also the supreme generosity by God of allowing his son. His son and his self.. This is what you said about the Trinity. It's difficult to talk about. How can you be your own son, right? But that's the mystery. 

[15:14] **Henry**: And we only have so much to go off of. But metaphors are still powerful. God is our father. If you think about any religion, why would he want to have a relationship with us? It's like an impersonal force or someone that doesn't care, right. 

[15:26] **Sonya**: When I was still an atheist, I think I had a really hard time understanding some of those metaphors. Or they're not even necessarily metaphors. I guess it depends on one's conception of God, but my sort of standard one is, like you said, the all encompassing, all powerful.. Oh God, I've lost where I was going with the sentence. I'm sorry. I got distracted by the conception of God. I was like, wow.

[15:50] **Henry**: I mean, that's interesting in itself. I think recovering that sense of awe is a good thing. 

[15:55] **Sonya**: Oh, I know what I was going to say. So say someone says God is love. My atheist reaction to that would be like, okay. Yeah. You know, I've heard that before. And also to strictly interpret it as like figurative. Like, it didn't even occur to me until after I kind of came back to the faith that like, no, you could mean that literally. 

[16:14] **Sonya**: And you can sort of walk through, okay, what is love? You know, what is love instantiated in the concrete world? Maybe it's some chemicals in our brain. It's like relationships that we have with people. It's commitments that we make. And could those things literally be God?

[16:29] **Sonya**: It's almost difficult to talk about because the concept of these concrete, physical things, literally being part of the divine being. Maybe it's another one of those kinds of language breaking concepts. But it was difficult for me to even understand what people were talking about because I was coming from such different premises. There's just like a whole different orientation towards the world and framework of understanding how things work and what happens and why.

[16:55] **Henry**: Yeah. There's like Christian talk. We're saying were brother and sisters in Christ, spiritually. We have to be more careful about what we say. Communion is the act of taking the bread and the wine, which represents Christ's body and his blood. And back in the day people would say like, Oh, they're cannibals.

[17:11] **Sonya**: Yeah. I guess this is the sort of inherent difficulty of cross-cultural communication. And the more different your cultural or your even epistemological assumptions, the more difficult it is to communicate across that divide. But I think Christians kind of have to try to communicate across that divide.

[17:29] **Henry**: And I guess we have a sense of faith that God will help us be able to get that across. We ask the spirit to give us the words to be able to speak to people. There's the tower of Babel. And then also Pentecost where people are able to speak in their own language, but people can like hear what they said in their own language. And I think that's a good metaphor, even if it's not literally happening, of us being able to relate to anyone.

[17:53] **Sonya**: Out of curiosity, how literally versus metaphorically or whatever the right word would be, do you personally take the Bible? I'm not going to argue against whatever your answer is. I'm just curious where you're coming from there. 

[18:07] **Henry**: Well, I don't know what to say, honestly. There's a leaning towards wanting to be literal, even if I'm not. I grew up doing like engineering and liking science, so I would like it to all be symbolic. But our faith is, at least in Christianity, super embodied. A lot of old religions think that the spiritual is more real.

[18:26] **Sonya**: Or that it's a kind of separate realm.

[18:28] **Henry**: To the point where they want to escape the body. But God who was a spirit, became a person, the incarnation is that act. And so even though my natural thinking is very systematic, I have to kind of go back and be like, okay, that happened. It's not just a metaphor, some part of it has to be real?

[18:45] **Sonya**: I feel like I have a pretty similar stance to you. Maybe you kind of earlier in the evolution of that stance, because I think you've been thinking about these things for much longer than I have. But I think in particular, like the resurrection is really hard to struggle with, because it goes against, like you said, our scientific ways of understanding things. Like the idea that someone could literally rise from the dead.

[19:06] **Sonya**: I remember trying to think of like, okay, what are the ways in which this could make sense scientifically? And it just doesn't. But I think that's maybe kind of the point. I mean, any way that it could possibly make sense scientifically would not have been available back then.

#### Compassionate Judgement

[19:20] **Sonya**: I think of [Doubting Thomas](https://en.wikipedia.org/wiki/Doubting_Thomas) who asked to put his hands in the wounds. And that's another really poignant thing, he kinda feels bad about it afterwards, or at least that's my reading of things. But Jesus still lets him do it. He's like, okay, if that's what you need to do to believe, go for it. 

[19:37] **Sonya**: And I don't know why exactly that feels so meaningful to me. I guess it feels very generous, you know. Like you're God and you have this human who's like, Hmm, I'm not sure I buy it. And someone who knew you really well, who was one of your disciples. And still he meets Thomas where he is. But at the same time, I wouldn't call it like non-judgemental because I think there is judgment in it, but it's like a compassionate judgment. 

[20:02] **Henry**: Yeah, like a parent then, right. I know what's best for you, but I will meet you where you are and help you get there. 

[20:09] **Sonya**: One of the things that's so comforting about Christianity and about the sort of Christian memeplex, I don't know, is that it really accepts and grapples and deals with human fallibility. I mean, I guess every religion does that in one way or another.

[20:24] **Sonya**: But I think that "you are okay. I accept you" is something that we so profoundly long for. I think that's like a deep, psychological need. It seems to be rooted in childhood to some extent, but maybe it's just part of human nature. And I don't really think we can actually get that from each other, that like total acceptance. At least I feel like that comes from God. Or maybe it's like where we are enabled to approach each other that way, through God through grace. To whatever extent we're able.

[20:53] **Henry**: Right. God has shown to us that level of grace. In so much as we understand that grace that he's given to us, we reciprocate that back to other people. We are reflections of God. We are ambassadors of Christ. We represent him, through our life. Everything about us. And I think you quoted at the end, what is the point of life, to know God and to glorify him right.

[21:15] **Sonya**: Yeah, I quoted [Nicole](https://hopeinsource.com/shalom/#t=18:27). 

[21:17] **Henry**: The catechism, the chief end of man. We want to be free from people telling us what to do, but then we have to come up with what the purpose is ourselves. I guess that's existentialism. 

[21:27] **Sonya**: I like existentialist Christianity a lot. Maybe because it mirrors like my own experience? Where I had this kind of like, go down into nihilism and then come back up. And I liked the existentialism frame where it says like, no, this is your choice. Like you have to choose to accept this framework this way. And I see that as compatible with like this being the true way.

#### Truth and Fact

[21:51] **Sonya**: Truth as opposed to facts. That feels really important to me as an aspect of Christianity. It's like material reality is necessary, but not sufficient?

[22:00] **Henry**: How would you.. How do you see the difference?

[22:02] **Sonya**: I'm not totally sure, honestly. I do wonder. What is the integration point between say, quantum physics and then Christian conceptions of reality. I really don't know, but I am big on natural revelation. Like the concept of the way the world is revealing things about God's will. I don't think it's like foolproof. I would also call that I guess, necessary, but not sufficient. I kind of see the Bible as like the collective wisdom of ages in terms of like what the natural revelation means. This is all over the place, but I hope that's okay.

[22:35] **Henry**: No, that's what I want. 

[22:36] **Sonya**: I see a lot of the Bible is metaphorical. Or I read it that way. But it also feels like a little bit of a cop out though for me to do that. And I think maybe you're right, that like some of it's literal, some of it's metaphorical, maybe all of it is both.

[22:50] **Henry**: I would like to think that, yeah. The Bible is a collection of books and there are different genres, right? The psalms, letters, and there's history. Those are all different things and you should think of those things differently. Instead of just one story or something. If it is meant to be historical, then yeah, I would hope that that was literal. But the stories do point to things that might happen in the future or things that we can look back on and learn from. 

[23:14] **Sonya**: I mean, we can look at Christianity as something that like persists and grows through time also. So I see it as like, these are our sort of our ancestors in the faith. This is what they put together to help guide us. It's interesting, all the biblical background of the different authors and the different texts that all got combined and the different languages that were involved.

[23:37] **Sonya**: Just the Bible itself is awe inspiring. That this document was written and compiled. And then that it was able to be passed on over and over and over again and sustained. I can't remember if this is actually from the Bible itself or if this is a later idea, but the idea that God looks after his word, and I think, yeah, that does seem to have empircally happened. 

> "And the word of the Lord came to me, saying, “Jeremiah, what do you see?” And I said, “I see an almond branch.” Then the Lord said to me, “You have seen well, for I am watching over my word to perform it." - Jeremiah 1:11-12 (ESV)

[24:01] **Sonya**: There is historical evidence for Jesus being a person, if not, for like every single thing that happens in the Bible with respect to Jesus. You have Jesus who comes and dies and returns and starts Christianity. And then through that act, through that happening, Christianity keeps going. And all of that did empirically happen. People did decide to spread the faith. There were the early martyrs who died for it. And it's easy to interpret, like God looks after his word in the sort of wishy-washy, abstract way. But no, I think it can be pretty literal that through the grace and the passion, yeah, through people's choices. And maybe something that I keep circling back to.. Is this like tension between literal and symbolic and intertwine together. 

#### Socially Distant Liturgy

[24:48] **Henry**: Communion and baptism are sacraments, just thinking about the Protestant. Those acts, they're supposed to be in-person and physical. And now that we're quarantined or socially distancing, there is a theological issue now of like, what should we do? And so churches will say things like the blood can't be corrupted, and so they can't get the virus. And so there's a conflict. I mean, I wouldn't believe that, but like. 

[25:11] **Sonya**: It's an interesting concept. Yeah.

[25:13] **Sonya**: Or the opposite approach.Henry: Okay, we want to be safe. The virus is a real thing. Everything's going to be virtual. Is this really what we want? I saw there was a meme of like a priest squirting a water gun at someone for the baptism.

[25:23] **Sonya**: I saw that too. 

[25:25] **Henry**: And it's like, it still symbolically represents that thing. But then how much of it is literal that we needed to actually happen. And so that's where it's like, where is the power coming from. Is it within just because we thought of it in our minds or is it because there's actually something there. 

[25:41] **Henry**: So say I took communion. We're all on zoom and we're all eating our piece of bread and we all do it together. Some people would say that the wine is literally his body or something. So there's this spectrum of that thought. Because we could all just have virtual VR church and that's all we need.

[25:56] **Sonya**: Yeah. And that all, you know, that also brings up the theme of sacrifice. Sort of almost like how much trouble are we required to go to for this to work. I don't really have an answer to that question either. I think it's a very interesting one though. 

[26:10] **Henry**: I keep saying I was going to do this, but looking back at history of people have gone through pandemics before and what did they do?

[26:16] **Henry**: And this time helps us to kind of rethink everything. Like, what is church? What is it really?

[26:22] **Sonya**: What is church is a really great thing to think about. Like is it the people? Is it the gathering? Is it, 

[26:28] **Henry**: Place. The building, what is it? In the Bible, it talks a lot about how the church is the body of Christ, right? Christ is the head. So at least we have that to go off of. We want to make all these distinctions because it makes it easier to reason about, like mind and body. But it wants to be integrated somehow, just like the faith and practice, you need both..

[26:50] **Sonya**: Like you were saying, Christianity does concern itself with the body, with our physical instantiation. The beingness of something. And I mean, I see that as like a very foundational part of God also. The big question of like, why is there something rather than nothing? I think that's my intellectual answer for like, what is God in a literal sense? I would say like the unmoved mover.

[27:12] **Sonya**: This makes me think of meaning and how, like, say you read a word. And we would say the word has a meaning, right. And a meaning is distinct from like a definition, like the meaning is sort of your understanding of what it signifies. And where does the meaning exist? Like what is the physical form of the meaning? And I don't think you could say that it's solely in your head or solely in the word or solely in other people's ideas of the word. Like for there to be meaning, it needs to be all of those things in combination. So I think I kind of agree with you that maybe the church itself is kind of produced by all of these things happening together.

[27:51] **Henry**: And of that I even think, why does he use the metaphor of a body? And I think the body shows that it's a dynamic thing too. We also talk about how like the word is living, right. And the church is living. It's so funny cause these things supposedly are static.

#### Irreducibility of God

[28:06] **Henry**: That ties back to Christ where it's like in John, it's a pretty famous passage of like, in the beginning was the word and the word was God. And the word was with God. And so that's tying Christ as a person to the word, and he is the living being of the word. So he's the representation of that text. 

[28:25] **Henry**: And actually, I got this from Aaron Lewis. I was reading about Mcluhan. He was really critical of Protestant people. He said, faith is not just belief. It's not just a concept. He said it was a percept. And so faith is an awareness. It's like a muscle that you have to like learn that you embody.

[28:41] **Henry**: And so I was thinking about why he even came up with, the medium is the message. And it makes a lot of sense as a Christian that you would think that because literally Christ is the medium and he's also the message. He's bringing a message about himself through himself. And I was just like, wow, that's like mind blowing.

[28:58] **Sonya**: I love learning about that dimension to the phrase. I had no idea. That's super interesting. That really fits in with the Word was God and with God. There's this like irreducibility to it, where it's like it needs this complexity and fullness. 

[29:13] **Sonya**: And I want to like dissect everything and pull it apart. And it's that systematizing thing that you mentioned. But not everything like really.. You can't understand everything through that mode.

[29:25] **Sonya**: A not insignificant part of coming back to religion for me was feeling this like insufficiency of rationalism, where I felt like it really wasn't actually answering all of my questions or some of the answers felt really like incomplete, unsatisfying.

[29:40] **Sonya**: Thinking again about how language doesn't fully capture it. Like people talk about the like old man in the sky, conception of God. And the way I look at it is that like, I'm a human. My brain evolved to personify to like relate to things as sort of like intelligent agents as we interact with them, you know, here on earth in our physical lives. So it's more compatible with my brain and like psychology to have this sort of personified concept of God. But I don't think that God is like literally equivalent to like the mind of God who knows. I have no idea. But I know that relating to God in that way feels nice. Natural, I guess..

[30:21] **Henry**: I would hope that that instinct of wanting to personify him is actually the opposite. What does it mean to be a person? What is our identity?

[30:28] **Sonya**: So there are other mammals that are quite intelligent. And I mean, we have a pretty limited understanding of like what that feels like on their end. But they've demonstrated a fair amount of intelligence. Say like elephants and dolphins. And an interesting question is like, suppose it's possible to explain Christianity to them, which may or may not be true, but it's interesting to think about, should we convert them, you know, should we try to explain the gospels to elephants?

[30:55] **Sonya**: I'm open to the answer to that being, yes. I'm not really sure either way, but it's an interesting thing to think about in terms of like, what are the boundaries of personhood, right. And I mean, it runs into theological problems for sure about animals versus people.

[31:08] **Sonya**: Or like if we ever encounter extra terrestrial intelligence, should we try to convert them? I really don't know what they want to. I also don't know about that.

#### Happeningness

[31:19] **Sonya**: I think in addition to existentialism, I think that Buddhism actually has a fair bit of correspondence with Christianity. There are a lot of the same concepts. Oh the idea of the self being illusory. I thought of this because of your point about embodiedness, the idea of the self is like something that is produced by your whole being, but it's not your whole being. You know, it's the voice in your head or like a psychological construct. I mean, it doesn't encompass all of our decision making. It doesn't encompass all of our faculties, which is interesting and weird. I wonder how that meshes with the, in his image aspect.

[31:58] **Henry**: Our stance towards identity, I guess it is very existential. Everything's on you. And I guess my pushback is like, where does the created in his image part come in? Some part of it is not really something we choose. So I don't want to reduce that to biology cause like some people do that, right? You are this and you can't do anything about it or whatever. It's just like this tension between what I feel and want to believe and my free will, but also like some part of, a new word I liked was a givenness. Interesting word. I don't even know what it means. It's like something that's like already there. It's just part of me, right.

[32:33] **Sonya**: I really like phenomenology as a lens. Like givenness makes me think of happeningness. I feel like you might be into it. Like emergent things. That something can exist because of the interaction of various processes. And then it becomes sort of more than the sum of the parts.

[32:50] **Henry**: I have been reading one person in particular that talks about emergence, Michael Polanyi. I don't know if you're familiar.

[32:58] **Sonya**: Yeah, I haven't read him personally, but I have heard the name. 

[33:02] **Henry**: His famous book is called Personal Knowledge. He's the one that kind of popularized the term, tacit knowledge. We were talking about conversion, right. He actually said that knowledge in its true form, I guess, is a conversion. The eureka moment or the epiphany, right. When I really learn something new, it literally reshapes the whole world.  My reality is different because I interpret it differently. 

[33:23] **Sonya**: That's another more than the sum of its parts kind of thing. Where you think like, Oh, I'm just slotting in this additional fact, but it can reorder the entire whole.

[33:33] **Henry**: Yeah. Christians say they're born again. That's used to death.

[33:36] **Sonya**: Yeah. It's like this change in substance that you undergo.

[33:40] **Henry**: We use the word repentance, right. But that's a referring to like a turning away, a 180 degree right?

[33:46] **Sonya**: It's almost like a dance.

[33:47] **Henry**: Yeah. I like that metaphor too. Because that's a relationship as well. You're usually with somebody, right. 

[33:52] **Sonya**: And it's dynamic. If someone's doing a dance, we would say there is a dance. Like the dance is a thing in and of itself, but what does that mean? What does the dance physically consist of? The person doing these actions and maybe another person participating? Or there could be an audience. But would we say that the concept of a dance is a physical thing? Ah, it comes back to the symbol and the reality and the relationship between them. This has been an incredibly thought provoking conversation. I feel like I have a lot to keep pondering. 

[34:23] **Henry**: Thanks so much for listening to this episode of Hope in Source. To continue the conversation, you can find me on Twitter at left_pad. If you'd like to check out the transcript with links and references, please visit hopeinsource.com.  
