---
title: "Technology as Process (Maggie Appleton)"
season: 3
date: "2020-11-02"
time: "33"
description: "Is technology just of chips and gadgets? Maggie Appleton joins Henry again in a 2-part chat to discuss how tech isn't such a static thing, building off of Mcluhan's thought of media and Dan Wang's article, How Technology Grows. We cover how tech itself contains it's own process knowledge involving how it is used, built, and maintained as well as going into digital immortality and the protestant work ethic, and chat about how our cultures are intertwined with tech."
episodeLink: "983762e4"
embedUrl: https://share.transistor.fm/e/bb6e376b
sidebar:
    order: 10
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/process.md)

#### Technology is Dynamic

[00:00] **Henry**: We wanted to extend upon our last conversation into tech as a process, rather than tech as an artifact. So how it's like dynamic versus static.

[00:09] **Maggie**: Yeah. Cause we got quite big onto metaphors and Lakoff. And we had started to say that definitions of technology are always fascinating. Especially when you start really reading the people who have taken on the topic of really trying to define it. And then you look at how we use it in modern culture to say things, like "the tech industry" or "I'm in tech", that none of it matches up. Cause what does that mean?

[00:32] **Henry**: I kind of feel like tech is a very specific type of thing, it's like the computer or phone. And when we read the philosophers, I get the sense that it's a lot more broad. McLuhan talks this idea of technology as an extension of your body. It shows that any tool can be a technology, even writing itself. It's not just this literal, physical thing.

[00:53] **Maggie**: Right. The definition of tool is probably more contextual. I do wonder what people used to use the word for, before digital mediums came up? So if you used the word technology in the 1920s, before computation, cause now we use it interchangeably with that, right. Well, like anything that involves a digital microchip must be technology.

[01:15] **Maggie**: I mean, people call writing a technology or they'll call language a technology, but in the broader philosophical context, we don't really think of it that way. So to broaden it back out to what it may be used to mean.

[01:28] **Henry**: In the day to day life, you don't really recognize it as such. And that's the influence that it has on us.

#### Technology as Tools, Instructions, Process

[01:33] **Maggie**: Yeah, cause you had sent me.. Your friend [Dan Wang](https://danwang.co/) wrote about [How Technology Grows](https://danwang.co/how-technology-grows/). And he was talking a little bit about innovation and how different nations invest in manufacturing versus service economies.

> "The goal of both pieces is to broaden the terms in which we discuss “technology.”" - How Technology Grows

[01:46] **Maggie**: But he had this point in the beginning about technology as a process. Or like three different kinds, right. Technology as tools, technology as instructions, and technology as process knowledge. So tacit knowledge, you know, embodied knowledge, but sort of at a community scale, how do a whole group of people hold communal knowledge together.

[02:05] **Henry**: Right. Tools are like our pots and pans. I guess he's using a food analogy. So then the instructions are like your recipes, but then you can have the best tools, right, just like we talked about previously with code editors. If you don't know how to use the tools or understand what the documentation is about, then it doesn't really matter. And that's the embodied part of, we would say that you need experience or someone to help you through that.

> "You can give someone a well-equipped kitchen and an extraordinarily detailed recipe, but unless he already has some cooking experience, we shouldn’t expect him to prepare a great dish." - How Technology Grows

[02:33] **Maggie**: I love that idea. And maybe he had a line. I'm not gonna be able to say it as perfectly, but that a pot and a pan suggests how you should use it if it's designed well. So it has both embodied knowledge and external knowledge in it, right? So it's an artifact, but the artifact teaches you how to use itself in a certain way. Right, like the door knob asks to be turned by the way it's designed. And so our physical tools, compel us into certain performances or certain processes with them.

[03:03] **Maggie**: I was thinking about documents really on the web, and the affordances of using websites. So the physical affordance of a computer mouse, is that really different to the affordance of a documentation website. Cause I would want to assume that the physical object has more embodied knowledge in it. Easier to figure out how to use it, versus the web medium feels less like it has embodied knowledge in it, but I might be making assumptions.

[03:30] **Henry**: I was talking to my friend [Omar](https://omar.website) and he used to work at DynamicLand. And it's funny, [the podcast we did](hopeinsource.com/emotional) was about his tweets, I guess. With real life, everything can be drag and drop, cause you move them around, but in a website, you can't really do it in the same way. You have to learn like, Oh, I can Control A, Control C, Control V.

#### You can't hide the age of physical objects

[03:50] **Henry**: We were talking about earlier this idea that Aaron brought up about: how come like sites that are old, [you can't really tell that it's old](https://twitter.com/aaronzlewis/status/1290920665026039808?s=20), unless someone puts a date. Like the content literally says this is old, but then in a old book, you can tell it's been used, it has markings on it. There's a stain from like coffee or whatever, but we don't put that in our website because that's the medium. We'd rather just tell you.

[04:16] **Maggie**: Yeah. I do like that idea too. You can't hide the age of physical objects as well. Like if a book is old, it's difficult to make it look new. You'd have to really put effort in right. That's archival work.

[04:27] **Maggie**: Whereas a website, if it was built in 1995, unless they've kept the graphic design the same. And I do love the idea that.. I mean, the primary way we are able to tacitly tell the age of a website is through visual design. Like you can look at that in websites and go, okay, no one has touched this in 1994. It's wonderfully retro. But if, you know, they just threw bootstrap on it, suddenly all of that timeline knowledge would disappear.

[04:56] **Maggie**: And what if, I mean, this is so speculative, you know, if the web had been built where there were visual requirements for ages of websites, some sort of way you could confirm how old something was, because if you can't, I mean, I don't know if it really does matter that much, but it just gives us less information about it and gives us less context for where it came from and who wrote it in one.

[05:18] **Henry**: Yeah, I think not thinking about that makes the content that much more important. When you're reading, the only thing that matters is like what you're reading. And you can still infer based on like, Oh, they use certain words. We don't use it anymore, right.

[05:33] **Henry**: And then you can tell, but you still have to read it instead of just being able to kind of at a glance realize certain things. All this is related to like tacit knowledge of things that we think we understand, but we can't express them.

#### Dates on websites

[05:44] **Maggie**: Yeah. Cause we've also been talking a bit about this idea of dates on websites. I don't know if that used to be as prevalent or now there's a little bit of a movement towards not dating blog posts. Cause there's an argument that, well, what does it matter what day I wrote it on, if it's good content.

[06:02] **Maggie**: But maybe that is just me, you know, liking this idea of having more contextual knowledge around things. And it would be nice if it wasn't so explicit, right. Does it have to say, you know, August 20th, 2021 or whatever. And instead some design suggestion on the page that just tells you how old it is, even if it's not precise.

[06:24] **Henry**: Yeah, no, that makes sense. I wonder how much of it is that I want to write content that people will revisit including myself. Maybe before it was just kind of implied that when I write something, I'm never going to touch it again. And I have a date. And that's actually maybe more like print where you finished your book. We have this new medium, let's take advantage of the fact that people will revisit it because of search or recommendations. I might update my thoughts and I can actually do that. The other way would be with the book you do like the second edition, right?

[06:56] **Maggie**: Right. People have really caught on to using last updated as dates, which isn't like some enormous innovation. But in the digital gardening world, everyone's sort of cottoned onto that. It's like, Oh, wonderful. We can now just put last updated on our blog posts. Which is nice, cause then it gives that sense of this is an evolving piece of knowledge I'm constantly revising. But it's actually funny, that really gets into maintenance, you know, then it suddenly becomes a long term obligation to always be going back and revising and how you moving forward with knowledge.

[07:27] **Maggie**: If you're just trying to make sure you're this ever growing, you know, past self is getting caught up.

[07:35] **Henry**: Oh, that's so funny. Cause that is really making me think like, I mean, I guess it's based on the term digital gardening, it is a maintenance thing. And it's like, I wonder when we're going to start seeing burn out on digital gardening, because it's such a fun thing now, but are you responsible?

[07:52] **Henry**: Well, you wrote this on this day and that was recent, so you still think that. Makes you more accountable, which is good, but I think those are things that you didn't have to worry about.

[08:01] **Maggie**: Yeah. Cause now you have the affordance of being able to revise your opinion online, which has obviously been a struggle that we've been going through with the internet, you know, like with people being, you know, cancelled and publicly shamed. And this thing of that, if you say something once on Twitter, it'll get brought up again 10 years ago and that we'd have no room for, or not enough for him for forgiveness and revision and.

[08:24] **Maggie**: Revised identities, which is like, what is the process of being a human, right. It's learning new things, changing your mind. So that's a lovely affordance of this digital gardening idea, right? It's always a work in progress. But then even the metaphor, right? If we, if we take it a bit more seriously, In gardens, plants die, or you eat them, you know, and your blog posts notes never die, but wouldn't that be interesting if, if you don't touch it for five years, it like fades off. Or maybe if other people don't touch it. Cause there's something about if someone else's still getting value from it, through search engines or Twitter, maybe it stays alive, but the things that aren't picked up just fade away.

#### Immortality: Digital and Physical

[09:05] **Henry**: Trying to understand in this case mortality, even digitally, is very important. Cause that's happening here biologically, but that's just not a thing that happens digitally. Cause we don't want it to right. We try really hard to embrace this idea of limitless and maybe that is reflected in our pursuit of never dying.

[09:25] **Maggie**: Oh, that's funny. I hadn't thought of that connection before. Oh, no kidding. The singularity movement and like the trans humanist wanting to live forever and freeze their brains. What is it called, cryro something?

[09:37] **Henry**: Yeah, cryogenics.

[09:39] **Maggie**: Cryogenics. Mmm. I mean, they're a fascinating group because it's fulfilling this dream of we'll never die, and we'll just get to live. Yeah. Avoiding the fear of death. But I had never made that connection before, when I think about our obsession with saving everything and data centers and everything in the cloud forever and nothing being deleted. And that's funny, that could be some sort of extension of us wanting to live forever.

[10:03] **Maggie**: And now that there's this new movement of exploring different ways of being on the internet with personal blogs. Maybe that's striking too high of a chord with digital gardening. But that we have the chance to sort of reinvent our assumptions about how digital medium should work and that we can choose to have websites die.

#### The right to be forgotten

[10:20] **Henry**: It's interesting that we kind of pursue all sides, all the time. So we have Snapchat type stories right. Where it kind of goes away, or auto deleting tweets. But we still want to retain everything, cause we don't want to lose our memory. And it feels like if you don't remember, then did it really happen?

[10:38] **Maggie**: Right, right. I actually had just read something recently on this. And it was about the programmer who had written the [poignant guide to Ruby](https://poignant.guide/). Does that ring a bell?

[10:49] **Henry**: Yeah.

[10:50] **Maggie**: And he I'm going to forget his name, but he deleted all his articles and essays and websites at some point. And I think it was part of this thing of saying like a right to be forgotten. But people seem very upset over it. And it's funny, it gets into your right to delete your own creation in a way.

[11:07] **Henry**: This is _why_ I think. Yeah,

[11:09] **Maggie**: Yeah. That's actually something none of us probably think about enough. This thing of ownership online is so vague. Who even knows, I don't know if there's ever been that many court cases of having to determine who owns content that's posted somewhere like Twitter. I mean, well, Twitter owns it.

[11:24] **Maggie**: But how much, even if you go on someone else's podcast, then they then own the right to take it down or not. Or if your post on someone else's blog, whether you have the right of revision, like that's very unclear, cause it's not a governmental law. That's very much like the communal laws of the internet decide whether there are norms are that you have to take it down on that.

[11:43] **Henry**: I think it's interesting because in some sense it's hidden because if you're not looking for it, it just won't show up. Cause there's so many things being created all the time, but if you're looking for it, you might find it.

[11:57] **Maggie**: That's actually funny. The overwhelm of information, perhaps it has some unintended purpose that it buries everything else. The pure volume of medium posts being written.. push everything else down the content stack.

#### Creating a Disembodied God

[12:11] **Maggie**: I'm trying to think of how to tie it back in. I'm thinking specifically about this idea of people trying to invent their own gods through technology. And especially with the world of AI, I guess I've been watching this play out a lot in the language and a lot of the stories and narratives happening there.

[12:26] **Maggie**: This idea of the dream of generalized AI is in many ways that the language talks about it sounds like it's trying to recreate a kind of God for people who maybe are from a nonreligious background. And I've been curious about the whole thing because there's no sense of embodiment in any of the AI discussion.

[12:42] **Maggie**: It's just like, okay, we're going to build a brain in the machine. And it's really funny, like reading people like Polanyi, or everything we've been talking about about embodied knowledge. If you have a brain in a machine, how does it know what up and down is? And left and right, and front and back, and heavy and light? And the experience of having a body? If it doesn't have that, like it isn't capable of understanding human thought and rationality and cognition like on a fundamental level. That's a conversation that never happens in AI.

[13:13] **Maggie**: So I mean, now I'm appreciating so much this concept that in traditional Christian thought, like you're saying there's no escape from the body. That's not the dream. That there's still some form of body that is always assumed to be there. And yet that isn't carrying over into more modern forms of ideas of higher being.

[13:29] **Henry**: Yeah. And not just that it's important, but that the body is a good thing. And I think that's hard to remember. This is hard to talk about, but like a theology of suffering, a theology of a body. What is the point of disease, and going through all these struggles, and the fact that we're not perfect, and we decay and die. And I think in a non theistic view, how can those things be good? And so comfort is our greatest aspiration. And you know, and it's hard. I don't want to say suffering is all good. It's not. People that are suffering from a chronic disease, how do we think about these people? Why do we think that these people are important? And I think that if we're trying to get rid of the body, you're implicitly saying that they have less worth.

[14:12] **Maggie**: Right. Right. I don't want to have to say the efficacy of suffering, the practicality of it. There's so many traditions that have pointed out how there is a purpose to suffering, it can be good in lots of ways and has an important role to play.

[14:27] **Maggie**: I mean, all this is the entire Buddhism, right? Like life is suffering. Or, you know, stoicism, right. Goes on about this a lot, that you're supposed to do engage in certain degrees of suffering to teach yourself that it's inevitable and you can withstand it. And it's not the worst thing in the world to feel discomfort. And it has important things to teach you. I really love that line of thinking a lot.

[14:46] **Maggie**: But then maybe only because so much of dominant culture now denies that, that it is like the pursuit of comfort, the pursuit of escaping the body. You try to avoid pain, decay and, eventual death. Fear of sprinting away from death at all cost like the kind of MO of modern culture.

[15:01] **Henry**: Yeah. I was recently talking about this earlier too. We don't know how to die well. We spend so much money.. And for good reason. We want to stay around loved ones, but at what cost.

#### The Denial of Death

[15:14] **Maggie**: Yeah. Makes me think back to.. Have you ever heard of a book called [The Denial of Death](https://en.wikipedia.org/wiki/The_Denial_of_Death)? Oh, who wrote it? Ernest? I read it as, as like maybe an 18 year old. And it really was one of those books where it just sort of shifts your whole world view. One of those you sort of live with the book for awhile.

[15:29] **Maggie**: I think that the guy who wrote it might've been more of a psychologist, but really it's philosophy. He had this theory that what makes us uncomfortable is that we're both gods and worms. That we have this like physical body that we have to deal with. And he doesn't put it in those terms, but that's the implication. That this physicality that we will eventually rot and be eaten by worms.

[15:48] **Maggie**: But then in our heads, we're these gods who can like come up with intellectual theories and try to escape our bodies and invent technologies that extend them in different ways and renew them. And that we're unable to come to terms with these two contradictions.

[16:01] **Maggie**: And he has some really interesting theories. Gets maybe Freudian in places, but you know why we try to hide more animalistic sides of ourselves? Why we feel shame when we have to engage in bodily functions. That we want to deny that we have this animalistic body, and we're just trying to live in the mental God world.

[16:19] **Henry**: I think that's interesting. That even the mental is associated with the God world and the physical is associated with the animal side.

[16:27] **Maggie**: Yeah, Cartesian dualism is always to blame, whenever it comes down to these debates. Descartes ruined everything is like my line for everything.

[16:35] **Henry**: That's exactly what I was reading from McLuhan where he was saying Protestants ruined everything because their thinking is tied to that.

#### Protestant Work Ethic

[16:43] **Maggie**: Cause you were mentioning earlier a bit too. And this is maybe future conversations.. We're getting into like the P[rotestant work ethic](https://en.wikipedia.org/wiki/Protestant_work_ethic) and that Protestant legacy of dividing the mind from the body and this idea that you have to work the body to achieve the more transcendental.. I don't know what they would call it, but purity.

[17:02] **Henry**: Yeah, can you go into more detail?

[17:03] **Maggie**: Oh gosh. Now let's try and test my history knowledge of where the Protestant work ethic came from. What is it like, 16th century? Max actually, that's funny. I just heard a podcast, it would have been his hundredth birthday and he died in the last flu pandemic. Very like fitting. I think he must've been in his late thirties, early forties. Anyway, before his time. Max Weber was the famous sociologist who had written about the Protestant work ethic, where at some point in Protestant history, there started to be this association with working hard will help you achieve salvation.

[17:36] **Maggie**: So he had kind of brought in more of an economic side of looking at it where a group of Protestants who ended up doing very well under capitalism because they had this belief that you should both had an obligation to work for God and should also be very frugal and not indulge in bodily indulgences, you shouldn't overeat, you shouldn't have too much comfort, you should really sort of engage in life's suffering and in an embodied way more.

[18:02] **Maggie**: And he kind of looks at how, when you overlaid that with a capitalist economy, they did very well financially because they weren't willing to spend. And they had this belief that working hard would lead to salvation. And this Protestant work ethic really, it influenced the cultural beliefs of America and England as well, right.

[18:24] **Maggie**: Historically, up to the modern day, it's very present. There is lots of ethical, moral, our language we use around work and who should work and the obligation to work. That if you're not working, you're being immoral in some way and you need to get up and do your part. And also that we still of course talk about indulgence as being bad. You really need to control yourself and you really need to limit what you do. So these things show up all the time, just consistently through modern culture, and that you can trace it back to a certain belief system.

[18:56] **Henry**: That type of thinking is so, I guess, normal, like you don't even have to be Protestant. The American dream. And it's a hard demon to get rid of, I suppose, right?

[19:06] **Henry**: And historically this purity type of idea comes from the church itself, where if you want to live a godly life, you have to live in the monastery, right. Everything's about asceticism and making certain that your life is very disciplined. But then Luther is kind of saying, why do you think that you can choose to do whatever you want? We should all live virtuous lives. And so that caused everyone to be like, Oh, well we all need self control.

[19:28] **Henry**: Self-help goes against the idea of Christian religion where that means you are working for yourself, right. It's supposed to be.. Knowing that you are saved by grace will cause you to work hard because you appreciate what's been given. And you even know about this issue and still a problem of like, trying to save yourself, trying to work really hard, hoping that if I do all the right things, everything will be okay.

#### Capitalist cosmology and self-help

[19:50] **Maggie**: Yeah. I mean, I do love all the ways that it shows up in modern culture outside of any religious connotation. I mean, when you talk about the self help industry or especially the obsession around habit forming. You know, the behavioral sciences.

[20:04] **Henry**: Yeah, all the books that came out.

[20:06] **Maggie**: Yeah, right. Atomic habits, tiny habits.

[20:08] **Maggie**: And even right, like bootstrapping and hustle culture, it all just reeks of Protestant work ethic. All of it, right. Go into the incubator and you have to sleep three hours a night and just get your startup going. You know, what are people chasing except for some sense of salvation at the end where they think, well, if I do this, I'm gonna have been ethically in the right by the end of this.

[20:29] **Maggie**: And in the capitalist cosmology of this system, the reward is money instead of salvation. If we're going to call American capitalism a religious belief system in itself, which wouldn't be too difficult to argue, it is that your eternal salvation is you become a millionaire and buy a Ferrari. It's not a millionaire anymore. Now it has to be a billionaire, you know, inflation.

[20:48] **Maggie**: But it's interesting to see it evolve because I mean, that's a even dated understanding of what the salvation would be now. It's, it's even hard to put your finger on what that would really be. Perhaps internet celebrity. I'm not sure.

[20:59] **Henry**: Influencer.

[21:00] **Maggie**: Yeah. Tiktok influencer at the end of that long struggle.

[21:04] **Henry**: Yeah. I think this work ethic is related around just the idea of doing, instead of the idea of being. And I think it's so hard because like you said, the capitalist environment and thinking, how can you not be that way? We are people that buy things or do things for the sake of money, and it's hard to get out of that mindset.

[21:26] **Maggie**: This is probably more specific to maybe the culture we're part of. Part of quote, unquote, the tech industry, people thinking online, how even now, like money's being kind of flipped out.. like intellectual clout. Where now the thing that gains you status and value in certain online communities is having a really thoughtful blog and writing a lot and tweeting clever things. No one's as concerned about whether you display wealth, but you have to display like intellectual prowess as your currency.

#### Doing the One to Many for the One to One

[21:58] **Henry**: Social capital. And I see myself thinking that way, cause we're all doing it. But that's sort of why I like podcasting more than other things, not just simply like tweeting less. Cause at the end of the day, we're posting this online. And if there's part of you that hopes that someone will listen to it and that's not a bad thing. But in the end, how do we focus on the conversation at hand?

[22:20] **Henry**: We're having a conversation with each other and that's the most important thing, rather than trying to like be a certain way, right. Oh, I want to be authentic. And that is its own performance thing.

[22:31] **Maggie**: There is a authenticity to going in, you know, without a script or a plan for these because you know, podcasting of course was starting to develop certain patterns and norms around them. We expect podcasts to go a certain way. The hosts introduce the guests. They give their work spiel in 30 seconds. You then go and do a Q&A where people say the same thing they've said on other podcasts.

[22:57] **Maggie**: There's a very established form to it that we're all very used to and are coming to expect. And there are certainly podcasts around like yours where you can really tell to people just get on and they're like, okay, this is what we really would say in a coffee shop to each other, that it happens to be on recording.

[23:13] **Maggie**: And I always like to think of it as an invitation for other people, the idea of raising flags on the internet. Like you wave a tiny flag saying, I like Michael Polanyi, like, come over here if you do as well.

[23:23] **Maggie**: Cause then it becomes an invitation. And you know, I have met so many people that way, where they say like, Oh, you had this book on your digital bookshelf. And I love that person too. And you start DMing with them and it leads to a conversation that's totally worth the sort of weird performative bit you have to do.

[23:41] **Henry**: Yeah. And yeah, your relationship with that person is very different. It's not as, I don't know, parasocial. It's almost like I'm broadcasting one to many, so I can have one to one. right.

[23:52] **Maggie**: Yeah. Yeah. It's like seeking out the one to one's amidst the one to many. And that is interesting of how you balance that ratio. You almost need the many to be a very small many.

[24:03] **Henry**: I think it's a conflict that anyone has as a content creator. And this is true in open source or as a streamer. In order to get those people that really care about your work. Say they want to sponsor you, well you gotta put yourself out there somehow. And so it is this conflict where I don't want to write about certain things because they're too fortune cookie type. But if I go to niche, then probably no one's ever going to see it.

[24:30] **Maggie**: Yeah, cause that is interesting. Then when you get into scale, in terms of like economics with the internet. When we're talking about sustaining projects that require financial support, it does need to be the many, because how else do you get.. It's interesting where we're seeing the rise of sponsorships and the \$5 a month for everyone.

[24:51] **Maggie**: But in order for that to be sustainable, then you do need as much spread as possible. Kevin Kelly was the original with the thousand true fans to give you a hundred dollars a year, you have a living. But then all the variations of that of course.

#### Over-participation

[25:03] **Maggie**: I mean, Babel of course is like something you will thought about this so much. I mean, do you really feel the obligation to really like cast the net wider, like bring in a larger group of people, even though you're also struggling with what Nadia called [the stadium issue](https://twitter.com/Daniel_E_Davies/status/1289948204994158592?s=20) where you have too many people wanting to contribute? And you can't. It's the overwhelm of like, okay, not this many people can try to contribute one small thing. We need a smaller core group who have more context to do it.

[25:32] **Henry**: Yeah. So the desire for getting as many people as possible thing. That's always there and trying not to think that way, but it's hard not to, because that's just our culture. Her point about over participation is real.

[25:45] **Henry**: You know, if you invite a thousand people in, even not just to report issues, but to contribute, it's just it's time that you have to take. We already talked about this earlier of we have bodies, we have limited time. That's the currency.

[25:59] **Henry**: Like if you were just looking at someone else that was a maintainer that wanted to get a hundred volunteers, you're just like, what are you doing? But on the inside, you're like, well, I want to be helpful and welcoming and inclusive. We have a diversity problem. We have so many issues in terms of like who's involved and you're trying to solve all of them by yourself for your particular project. So same as many other things, we need systematic change there too.

[26:24] **Henry**: But I guess the burden is always on the maintainer to fix all the bugs, to get the people, to fundraise, to manage your own mental health and the mental health of your teammates. We always come back to this, but like how has everyone not burned down? How's it even work?

[26:39] **Maggie**: That is interesting, that of all the number of burdens on anyone maintaining one of these open source projects. And that could be taken in many ways in the current internet, not just software, there's lots of open source type communities. That you even have to solve the problem of like, okay, we need people who feel meaningful connection to this project, right? So they are engaged with it in some way, but not in the way where they're filing issues or trying to commit code with that they don't fully understand. So you need to give them a way to meaningfully engage and feel some embodied practice with it. Without that practice being code.

[27:15] **Henry**: Exactly. The way it works just as not allow for that. I just don't see how they foster that kind of environment, because everything is a list. Like the interface doesn't give you an opportunity to understand people. You have to go out of your way to Twitter, Slack, Discord to do a video call, which is not that great either. And I don't want to say the end all is like in person conversation, but clearly there's something there that helps bring a connection, creates a relationship that goes beyond simply like, Oh, I made a PR and now I feel connected to this project. And there's something there, like the whole "I stay for the community thing". Why do people stay?

#### Platform Support

[27:57] **Maggie**: I love that point that the affordances of GitHub are not solving the problem. Because all the actions you can take in GitHub are to file issues and commit code. Like that's what it's designed for. How would you do it? Encouraging something like video calls between people who are members of the community, or want to be members of the community in a very frictionless way.

[28:16] **Maggie**: Whereas, yeah, it is hilarious right now that if you do want to meaningfully connect with someone over video, you DM back and forth and so on and sets up a separate Zoom meeting and you have to make sure they have the password to the Zoom meeting and you have to send over a link at the right time. And you have to do the time difference calculations separately in your own calendar. And you end up involving four to five apps that are not integrated with one another to patch together a human connection over video, which isn't even like the ideal.

[28:44] **Maggie**: And that none of the affordances of the apps make that process any easier. And if what people really want is that meaningful embodied connection to a project. In what other ways could there be affordances on these platforms that like make that happen?

[28:59] **Henry**: Yeah. We had an episode on membership when I talked about church membership and we need a similar concept in open source where like every contribution you make doesn't mean that they want to become a maintainer and they don't have to be. And no one's trying to force them to.

[29:15] **Henry**: And it's more just that we don't have this transition of, if you do, how do we help them? Not just onboarding. There are people that do the drive by contributions. That's fine. Cause maybe they maintain their own project. They don't need to join your project. Or they're just getting started. And so there's all these different room for like various roles within open source. Not that we need to make the distinctions, but I think it's important to not pretend that we can substitute anyone just like we can't substitute maintainers.

[29:44] **Henry**: You can't just replace CEOs either. If we believe in embodied knowledge, that knowledge is in the minds of those people. And they're trying as hard as they can to document it. And still, even if it documented everything, that's still not going to show exactly what needs to be done, right. They haven't even thought of the things that they need to change.

[30:05] **Maggie**: Yeah, cause it's such an assumption that the code is the knowledge. I mean, that fits with like the historical cultural beliefs, right. That we just think if it's written down in text, it's the truth and it's all there is. And we don't need a human to explain it to us. It's encoded in the text.

#### Process Knowledge takes time

[30:21] **Henry**: I think that's what Dan was trying to say in his post about technology. I mean, he was specifically talking about semiconductors. And if I get his point that Western, or just countries in general, outsource that to China and different countries. So even though we're the ones benefiting from making the end product, we have no idea, in a way, how to make semiconductors.

[30:43] **Henry**: And maybe you can recover the documents and you have the tools and the machines and the factories, but the people that are working there, they know things. And it's in the minds of those people. And if that's true, if you decided today, like we're going to start making their own factories about all this stuff.

[31:01] **Henry**: Well, to build up that knowledge through people, it's going to take a really long time right. Years. And so in some sense, they're ahead in that way. And I think maybe that's why the concept of outsourcing is so interesting because that's thinking that you can replace people and that those people don't matter if, you can pay them less, that kind of thing.

[31:22] **Maggie**: Yeah, have you seen the documentary, [American Factory](https://en.wikipedia.org/wiki/American_Factory), on Netflix? Oh, it's really quite good. Cause it very much gets at this. It was about a factory in Detroit that used to make cars. I mean, it got bought by a Chinese company who made protective glass. And they had to bring in their Chinese team to train the American workers how to do whatever it is, the glass and the cleaning and shaping it. Because they had the institutional knowledge of how you do this efficiently and safely and fast and the Americans didn't.

[31:51] **Maggie**: And it was most of the documentaries is this very odd funny story of this factory in Detroit. People come in who have to redesign a whole buildings because the Feng Shui is off, cause it's going into the cultural differences and having like the American managers go to China. And there's some great scenes of even the Chinese workers who have to come over and being given lessons on what Americans are like. It's just great. Cause it's just like makes it very explicit what the culture looks like.

[32:15] **Maggie**: But this just reminds me of that so much. That there was all this tacit knowledge. The Americans didn't know how to handle the glass without breaking it. And they didn't know how to efficiently do it without it leading to injuries. And they couldn't just learn it, the factory was a mess for years and they had to like do all this cultural exchange work for it to finally like get up and running..

[32:34] **Henry**: Thanks for listening to this episode of Hope in Source. If you'd like to continue the conversation, you can join our discord, or find me on Twitter @left_pad. If you'd like to check out the transcript with links and references, please visit hopeinsource.com.
