---
title: "Managing Over-Participation (Working in Public)"
season: 3
date: "2020-08-04"
time: "47"
description: "Is more (information, people, code) always better? Nadia Asparouhova joins Henry to chat about her new book, Working in Public: The Making and Maintenance of Open Source Software, a deep-dive into the of open source community and how it may paint a picture of online communities in general. They talk about her 2x2 model of communities, the public web (Twitter) to private groups (group chat), the turn to individual creators, and the importance of moderation and boundaries."
episodeLink: "1735505a"
embedUrl: https://share.transistor.fm/e/bd3ffd63
sidebar:
    order: 4
---

### Links

- Buy the book, [Working in Public](https://www.amazon.com/dp/0578675862)!

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/overparticipation.md)

#### Five Years Looking At Open Source Communities

[00:00] **Henry**: It's actually been two years since we released Hope in Source. So yeah, I have Nadia again to talk about a new book that she's written, called Working In Public, about open source and community. I guess we could start off by just talking about what the thesis of the book is?

[00:17] **Nadia**: Yeah. To me, the book is sort of the combination of the last five years or so that I've spent looking at open source projects and communities. Some of which we explored even together on this podcast. But trying to make sense of an observation, I kind of been having over the course of that exploration.

#### Our Common Wisdom Encourages Participation But..

[00:36] **Nadia**: Just looking at the idea that we talk about open source being this thing where everyone is in.. anyone can participate, in an open source project. And I think the current wisdom right now is about encouraging more and more people to participate. And then I feel like we kind of hit this inflection point where we kind of had like too many people participating, or we just sort of need to like step back and re-examine some of the assumptions around what it means to build strong communities.

[01:05] **Nadia**: And so in the book, I try to explore what are different models for communities when we are talking about the scale that we're dealing at today. And for managing that kind of over participation and ensuring that everyone enjoys doing what they're doing for a really long time to come.

[01:21] **Henry**: Yeah. I guess in this podcast, we're not necessarily going to go over all that history. The summary might be that, before, when open source was small, we assumed that everyone was contributing and there is no issue of people demanding you for things. But now because of GitHub and all these different factors, it feels like there's a small amount of people that are maintaining things and their attention is being taken away from a lot of users, because of the scale of open source.

[01:51] **Nadia**: Yeah. Like, it's easy to imagine 10 people let's say, collaborating on a project together. You can kind of see how the typical community dynamics that we think about would play out in a group of 10 people. And then you think about like a hundred people and it's like, okay, well that probably looks a little bit different.

[02:05] **Nadia**: There probably a few leaders who emerge and are trying to like coordinate things, but then you try to imagine something at the scale of what a lot of open source projects are dealing with, which could be, you know, thousands, tens of thousands of people. And who knows how many people that are using your code, billions of people.

[02:20] **Nadia**: And then it's like really hard to think about, okay, that's probably not this big collaborative project. There's probably something different going on there. And that's part of what I'm trying to tease out in the book.

[02:31] **Henry**: Yeah, this is sort of part of our culture and even the platforms that we have are based on old assumptions around this idea of participating. I think you mentioned in the book that the default is that we want more contributors and we want more people to get involved. You're saying that people are already involved, and too much in a way.

#### Pushing Back on the Definition of Participation

[02:53] **Nadia**: Yeah. And I think like maybe part of it too, just comes from our definition of participation has changed or needs refinement. Where, for example, in open source, you can have someone who contributes once. And then you have someone who's contributing very regularly and those are like different kinds of contributors in my mind.

[03:13] **Nadia**: And we've talked about that too, you can imagine like a membership organization of any sort, not just open source. And there are people who might drop in occasionally. And then there are people who are like really active and organizing a lot of stuff together. But in open source, we just call all those people contributors.

[03:26] **Nadia**: And there isn't really any way to distinguish between someone who's just here to get their bug fix in and then leave versus someone who really wants to be active in taking on a role in that project's development. You know, it's not really about devaluing someone's contribution, but just saying, should you give as much attention to that one time contributor as you do to someone who shows up consistently and proves that they're willing to be there for a long period of time.

[03:52] **Nadia**: And I think it should be okay to kind of like push back on that a little bit and say, well, if you've just shown up once and you say you're interested, but you haven't done anything to show that you're really trying, then I can't really afford to spend as much attention on that person as I might on a long time trusted collaborator.

> "we’re glad you’re doing this once, but the level of maybe attention I’m gonna give you or level of commitment that I expect is just gonna be different" [#2 Membership, @11:31](https://hopeinsource.com/membership/#t=11:31)

[04:07] **Henry**: Yeah, I guess we talked about that on the membership episode.

[04:11] **Nadia**: Yeah, we were talking about like churches, I think. People might come once to church is fine, but it's different from people that are coming like every single time.

[04:18] **Henry**: Right. It doesn't mean they get to necessarily be a part of every single possible thing. Just like an open source. Maybe what we're getting at is that we treat every person that participates, as the same. And we were trying to just say that, if they're not committed to this thing.. If they have a issue that takes an hour to solve and there's a hundred people, then you can't just practically speakingdo that,right.

[04:43] **Nadia**: Right. And especially when there just aren't that many people available to do that kind of deep work with a new contributor.

#### 2x2 of Contributor/User Growth

[04:52] **Nadia**: Which was another thing I was trying to just untangle a little bit in the book. Maybe we need these different models of understanding different types of communities.

[05:01] **Nadia**: So that was this breakdown of looking at the emergence of stadium type models as a community in themselves where you might have a project community with just like one or a few maintainers and they're making things for a very big audience, but like that audience is not really that deeply engaged with their work.

[05:20] **Nadia**: Is really different from this like club type model that I talk about where the contributors and users overlap a lot more. It's a lot more like this beat up, hobbyist kind of vibe. So yeah, if you're in this stadium type model, where it's just one or a few people that are trying to manage a lot of these casual requests, what that person needs to do to manage their time is really different from say like a smaller group of users and more active contributing members who are available to actually socialize new people into the project.

[05:54] **Henry**: Yeah, I think in the book, you made a 2x2 grid based on growth, right?

[05:59] **Nadia**: Yeah. It was sort of looking at the difference between, for any given projects, they might have high or low user growth or higher or low contributor growth. So basically asking like how many people are using the product, is that growing really fast? How many people are actively, regularly contributing to the project and is that growing fast or slow and then came up with these different sorts of models and I think also different types of behavior that we might expect from different communities based on their answers to that.

[06:27] **Henry**: Right. So when people ask you like, what I should be doing. On Twitter, Divya was asking how to build and foster new communities. So it kind of depends on where you're at, at what point in time, because those things can change, right.

[06:41] **Nadia**: Yeah, like I think it's definitely possible for some projects at least to switch between those models. So you can imagine, and we've seen this happen with some products where there are just a few maintainers, but it's sort of artificially low because maybe they haven't made it really easy for other people to contribute. It's possible you could like change that behavior. So it is possible to move between those models.

[07:00] **Nadia**: But yeah, I mean, I get asked a lot about building healthy open source communities, or what do you do to sort of foster more contributions? And I feel like my first answer to that is still, it depends on what type of project you are.

[07:12] **Nadia**: And I think understanding what type of project you are can help maintainers figure out like, what is the right course of action? Cause sometimes you don't actually want to encourage, lots and lots of our contributions. Sometimes you just want to say, look, I'm the lead developer and I'm kind of like the only person doing this and I'm going to close most that have been issues or whatever.

#### Victims of Success

[07:33] **Henry**: Yeah. Especially in JavaScript, we overly want to be like welcoming and inclusive, which is a good thing. And then it kind of is the whole reason why we're dealing with this issue of over participation, right? Cause it almost feels like blasphemous to say no to something, right.

[07:49] **Nadia**: Yeah. And especially in JavaScript, which I examined for a little bit in the book, I think attracts a lot of new developers. And so people who aren't necessarily familiar with software development from elsewhere, or how open source works from elsewhere, are maybe less familiar with how it git or GitHub work.

[08:05] **Nadia**: So it's this mix of both like encouraging lots of people to participate, but then like a lot of people don't have prior experience. And so you're kind of encouraging this like flood of newcomers who don't have a lot of context and can't easily be socialized into that, which is challenging.

[08:19] **Henry**: Yeah. So I guess in a way it's like open source, based on the assumptions it had, "we need more people", it was really successful in that. And now we're kind of dealing with the fallback with being successful.

#### It's a Good Problem, Let's Adapt to Changing Circumstances

[08:30] **Nadia**: Yeah. I mean, I hope I paint an optimistic picture about it in the book. Cause I think like for a little while I was feeling kind of like, yeah, like it's a problem. And it is a problem or a challenge. But yeah, it's a good problem. And it just requires sorta like reframing how we think.

[08:43] **Nadia**: And I try to draw a lot of parallels to what's happening online more broadly with how we're all thinking about social media and the social web. Where maybe somehow over the past, let's say 15 years, I hit a point where I don't really want to share photos and updates on Facebook anymore. That doesn't necessarily mean that the entire social web is broken. It just means I found different places to go to do that. There are like new patterns of behavior that are emerging and it's just like interesting in the way that it's developing differently; it doesn't mean that everything is going to pieces.

[09:17] **Henry**: Right. So I guess what was the water that we swim in is changing. And then we feel like everything is failing or broken. But people are just adapting to different circumstances, right?

[09:30] **Nadia**: Yeah, exactly.

[09:31] **Henry**: I guess to get into that more, cause a lot of the book is about specifically open source, but at the end you're kind of pointing to like how this is true for anyone. So you don't really have to be an open source to kind of understand the book or take something from it.

[09:43] **Henry**: I liked your point about the whole post comment model of social media, every single website essentially has that. There's a certain assumption around why you would even create that feature, right. The idea of every user is the same and that every single thing that they say is a good thing, I guess that's why a lot of people are removing comments, right.

#### Liberalism and "Don't Read the Comments"

[10:06] **Nadia**: Yeah. I find myself like using the comment section, that example, to sort of illustrate why there is this issue of over participation in open source where. Like, if you were to publish something online or even if you're just like reading news articles or whatever. I mean, we're all familiar with this idea that, "don't read the comments section" and you see just sort of all sorts of people come out of the woodwork in the comment section. And you're just like, who are these people? Like, why are they so angry or whatever? And imagine trying to like have to collaborate with your comment section is kind of like at the heart of why this stuff is so challenging.

[10:41] **Henry**: Yeah, I guess going really broad. We're kind of facing the fact that being open kind of needs its own limits, that more is not always better. That was just kind of an unchallenged assumption that we've had and are struggling to deal with. It's like, don't have boundaries, everything is limitless, there's no friction to things. I guess it's hard not to think that way, why it's so difficult to kind of implement changes, right.

[11:05] **Nadia**: Yeah, it comes from a good place, I think. It feels very in line with this democratic ideal of, you know, we would just want to get more voices in the room and we want to hear from more people. The more that people can exercise that right, the better. And so it does come from this good place.

[11:20] **Nadia**: It's just like, I think that's why I like using open source as an example, to talk about these broader social themes, because it can be a little bit hard to just kind of walk into a room and be like, "we shouldn't let people participate". It's like, Ugh, you know, why are you saying that? For me, I mean the way I even sort of like arrived at that was by looking at what was happening in open source.

#### Questioning Hypotheses and Norms

[11:37] **Nadia**: And feeling like, okay, I started with this hypothesis, which you'll hear a lot in open source of, if you are a single maintainer, who's overburdened, it's kind of on you to get more people to contribute and turn them into regular active contributors and hopefully maintainers. It's like, you just need to work harder to recruit more people.

[11:55] **Nadia**: And early on, I think I kind of was like, okay, is that true? And trying to sort of go through how that was actually playing out in different projects and understand like, okay, that actually.. Like sometimes it's not the maintainer, it's just the nature of their project. Why is that? And then trying to like unwind that from the project. But yeah, I think open source is a really great example because it is a little bit more removed from, real world society, I guess. So it's a little bit easier to examine it, dispassionately.

[12:20] **Henry**: Right. And you were saying that we were dealing with the same issues before maybe a lot of this other stuff happened.

[12:27] **Nadia**: Yeah. I mean, even over the course of writing the book, it was interesting. Cause like I felt like I started writing it at the end of 2018. And I was nervous in the first few iterations of my draft, because I felt like I was saying something that I really shouldn't say or that.. But then I felt like over the course of 2018, 2019, and then now getting to the point of publishing the book, it feels almost like obvious now, or maybe not obvious, but it's way less controversial to talk about now. I mean, these are debates that people are having very openly right now in the public and political sphere. We're talking a lot about like censorship, cancel culture, and things like that.

[13:04] **Nadia**: And also just seeing like how much your social behavior has changed, where I think at least for people I know, group chats and group messaging have become so much more of a thing because people are kind of retreating from these very public spheres to find higher context communities.

[13:18] **Nadia**: And you can have that with a small group chat with your friends. And the rise of email and newsletters as a thing, which are also kind of like a place to go deeper with developing a relationship with your audience, away from the din and the chatter of very public platforms. So there are all these really interesting trends that are emerging now, that I think parallel a lot of what I explored in the book.

[13:40] **Henry**: Yeah, it's just such good timing.

#### Salvation By Maintanance

[13:42] **Henry**: Going back to your point about this assumption that it's kind of on the maintainer to get more contributors. Like, even though I know I should be thinking differently, I still act that way, which is interesting. It's sort of the difference between what you know in your head and how it plays out in reality.

[13:58] **Henry**: We're still trying really hard to get more contributors and not that that's bad, right. Doing like internship programs or mentorship, all that stuff, but honestly, it just makes me feel more guilty about the work you're already doing, right. It's sort of the equivalent in faith, like a salvation by works where you can never win, I guess? It's like an ever increasing battle of just more and more work and burden. Probably why it leads to burnout for so many people because our community is telling them, you know, you're not inclusive or welcoming, if you're not making it easier enough for more people to get involved and they all leave. And so it just kinda feels like it's your fault.

[14:37] **Nadia**: Right. Which I can imagine is just a lot of pressure. I mean, even after all these years of looking at open source projects, I'm like, man, I did not know how maintainers deal with this. Yeah. It seems like a lot of pressure to have to deal with, but it is hard to.. I mean, what do you do? It's hard to be like, "actually I've decided that I'm not going to invest in these things" and you know, it's just going to like upset people.

[15:01] **Nadia**: It can just be hard to find the right words to be both welcoming.. I guess like one of the issues I have is like, sometimes it seems like if you're not bending over backwards, welcoming to do stuff, then you're perceived as hostile. And I feel like there's just so much more of like a spectrum than it seems.

#### Welcoming Communities, Seeker Friendly Churches

[15:15] **Nadia**: I've talked to some folks who just even take issue with idea of this term, welcoming communities, because sometimes they're like, look, I'm not going to be rude to you. I'm not hostile, but I'm also not trying to welcome more people because I kind of don't want more people weighing in on these issues.

[15:31] **Nadia**: And so I also feel like even there, there are probably better terms we can use to say, like, we're very cordial. If you do submit a thoughtful, you know, pull request, I will respond to it and review it, but that's very different from me saying I'm going to like go way out of my way to be like overly welcoming to every single person that drops in.

[15:51] **Henry**: Right. That reminds me of when we talked about evangelism a lot, because it's sort of the whole seeker friendly church, right. That's sort of the same thing. And what does evangelism really mean? Are you trying to literally every single person you see off the street, you're going to try to get them to go to your church or the people that do decide to show up, are you going to help them? And same with open source? Like you can't help everyone. You're limited person.

#### The Importance of Moderation: Saying No

[16:15] **Henry**: I don't know, maybe the internet and computers, it makes us.. We kind of embody the properties of those things, right? We feel like we are limitless too. When we do face this burden, then we have to finally think to ourselves like, Hey, I can't do this anymore. I have to learn to say, no.

[16:31] **Henry**: Maybe it's sad, or maybe that's just reality. A lot of the issue, you know, disregarding money, just comes down to not feeling guilty about saying no. Which is funny because especially as open source maintainers, we have the freedom to say no, right. If it's not your job. Although you could say that has something to do with your reputation, that has a lot of social capital, but, yeah, you should be able to step away in theory, right. But then nobody does it. You don't see people doing it until they get to the breaking point, which is really unfortunate.

[17:04] **Nadia**: Yeah, I, in doing research for this book, I also went through sort of like some of the existing literature around how online communities are built and sustained. And if you go through that stuff, it's actually funny, cause like they kind of had no qualms and talking about this stuff early on, I guess before it became maybe a little bit more sensitive of a topic. But if you look at like very early online communities, and just sort of like the research that has been done about that. There's a lot of wisdom in there about the importance of moderators stepping into set the tone of a community and kicking out people that are hostile or newcomers that come in with zero context, but are just trying to like troll the group, all this behavior.

[17:44] **Nadia**: And so if you take it out of the context of open source and you just look at it like that. To me, one of the things that stands out is this idea that we need to have moderators or some sort of like authority or leadership in a community to be able to say like, Hey, these are the rules. Then you can kind of take them or leave them. But if you're gonna be disruptive in the way that you are, you just kinda can't be here. And then I kind of think about just like how this plays out in a lot of the open source drama that you see kind of flaring up here and there.

#### Inversion of Authority

[18:09] **Nadia**: And it feels like it's completely inverted, where a maintainer doesn't always have authority over their projects when something happens. And, you know, you can just get this flood of people from the outside who are coming in saying, I'm just thinking about kinda like the worst kind of like flame wars that come in, tons of people from the outside saying, "this is an open source project you're supposed to be welcoming all these people and, you know, what's wrong with you." And it just seems so backwards to me that even if you look at the earliest open source communities, like there's always this idea that existing members or whomever, like are there to set the tone of a community. And I don't feel like that authority is always like seen or respected in open source projects.

[18:50] **Nadia**: And I think like part of it is that, this isn't like a hobby or something for a lot of people. And so I can like understand the other side of it too, where if you have a meetup or something and no one likes this newcomer who came in and everyone was just like, kick them out. Maybe they really, really wanted to join, but otherwise there's like other groups they can find to join. But because so many of these open source projects are critical infrastructure or things that other developers feel like they have to use whether they like it or not. I think that's part of why there is more pressure to say "you can't just kick me out of this community, because I need to be part of this, because I use this all the time in my job." Right. It just makes the stakes even higher in an open source project than you might find in a say gaming community.

[19:33] **Henry**: Right. Yeah one of the big differences, the infrastructure part, the dependencies. You can't really just substitute it.

[19:38] **Henry**: And this whole thing about forking, like if someone, a maintainer does something you don't like, theoretically, you can just fork it, but it's not just the act of forking and the code, right. Are you really going to take on all of the work that they were going to do, to maintain it yourself when you could have just paid the maintainers to do it in the first place. And then it gets into this whole cycle of sustainability around everyone that's complaining about it because they use it at work and they're getting paid to work on it. But then none of that goes to the maintainers. And they don't have the time to look into every single possible thing.

#### Whose Responsibility? Platforms?

[20:10] **Henry**: I guess I've been thinking just a lot about mental health and psychology of just being in open source. It is kind of weird that you can feel so bad about making so little money. You can probably make money as a maintainer if you decide not to maintain that project and just work at the company that uses it. Everyone has this thought of, I'm just doing this in my free time. That does get into questions of privilege and who has the time in the first place. I dunno. I guess all these questions do turn into freedom, what is it for, who has it, like that kind of thing?

[20:45] **Nadia**: Yeah. I think like it's part ly to like why it is on GitHub or any other sort of infrastructure we can think about, supporting maintainers to help make this stuff easier to do. If you're a maintainer who does want to work more full time on a project and that understanding is not mutual between you and your users. And I don't know, people just don't necessarily understand those norms around, could a maintainer work on something full time.

[21:12] **Nadia**: And so that's something, I explore it a little bit as well in the book of, GitHub released Sponsors last year, which I think is like a really great step in that direction of saying if you are a developer, you can and should get paid full time for your work or part time or whatever, but making it easier for people to do that versus before that people would go to Patreon or something. And there were a couple.. I mean, you were on Patreon, right? There were like a few open source developers that were doing that, but it was just sort of strange. I imagined for a lot of developers to be like, there aren't that many software projects on Patreon and it's a weird kind of side coupled thing, versus GitHub being like Sponsors is a native feature of our product.

[21:52] **Nadia**: It just is like a little bit more of a stamp of approval, but I feel like there's still like so much more that GitHub could be doing besides just offering this like payments aspects of it. But it's like everything that gets you up to that point as well. Like, you know, just making it more visible who is working on a project. Like, if you click on someone's GitHub profile, it should be really clear what they do all day. And right now, I mean, yeah, there's a contribution graph, but sometimes it's not easy to see, what are the projects that this person is best known for? So I think just like cultivating that sort of like reputation system around the sort of payments aspect is also so really important and something that I know GitHub was definitely working on and hopefully we'll make more progress on in the coming years.

[22:30] **Henry**: I guess you talk about that a lot in your book around content, whether it's music or writing and code, to like creators, that we treat code as the commodity. That's where it gets into how it parallels other content around influencers and streamers and YouTubers.

#### GitHub Isn't a Creator Based Economy, Yet

[22:45] **Nadia**: Yeah. One of the arguments that I was making in the book. If you look, if GitHub is supposed to be the social platform for developers, which a lot of people say it is, then why doesn't it really compare to Twitch or Instagram or wherever, like other similar platforms for creators in terms of making someone's reputation, really visible and like encouraging that reputation system to flourish. It feels to me like GitHub is still more of a utility than a social platform.

[23:13] **Henry**: Right. I think there'd probably be a lot of programmers that dislike the idea of social, because they think that the code should speak for itself or something like that, right. Or they think that, how come this person can only make money because they're well known. I mean, that's a whole thing, but.

[23:28] **Nadia**: Yeah, no, I think that's a good, it's a very real criticism. And I think that push back is probably why a lot of this stuff hasn't happened in open source too, which I guess I kind of feel, I dunno. I mean, not everyone will agree with us, but I also feel like creator based economies are kind of like in our near future, everywhere.

[23:51] **Nadia**: And so we can't have it both ways where we're saying, why is there not more support for this type of dedicated work in open source, and then also say, well, we want to exempt ourselves from what, like literally every other type of creator is doing, because it seems unfair somehow. Like, yeah, I mean, it sucks for everyone.

[24:05] **Nadia**: It sucks for Instagram influencers that, you know, not everyone gets to be famous or some people make really great content, but aren't discovered yet like that's true. But I feel like pretending that we could just like completely opt out of that system then ends up punishing more people in other ways. Maybe just the only path forward, I guess, is my view.

[24:23] **Henry**: No. Yeah, I mostly agree with that too. I think one of the big reasons why we don't really have the funding for it is because.. I like to say that open source is successful because you don't know who made it. But that's also why you wouldn't pay for it, right? You don't know anything about that person.

[24:39] **Henry**: And that's exactly why these creator economies work, because they're in front of the screen, you're listening to them, all the time, right. And so you feel more connected even though it's sort of not a real relationship. With open source, you don't even know they exist, right. That's why we call open source a black box. But you don't have to know who the people are. But if you're trying to like, say fundraise or get money, your name has to be out there. They don't know who they give it to.

#### Open Source and Content Creation

[25:03] **Nadia**: Yeah, exactly. I just barely touch on this a little bit in the book, but it's something that I really hope that we do talk about collectively more is, that we keep talking about like open source developers, but then there's also kind of like this other thread that you can pull out of it. Educators, and basically just like content creators within the world of software. And that's kind of distinct from open source developers where you might have a developer, maybe they've done some opensource work, but maybe they're teaching open source technology, which is maybe the more common scenario, but they're really well known for the videos they make, and tutorials, and blog posts that they write.

[25:38] **Nadia**: To me that maybe feels like the closest inroad to how do we connect what's happening in the world of creators more broadly to the world of software. Yeah, like an open source developer is someone who is actively working on an open source project. Then you also have these open source adjacent developers who are building a public reputation around content that they create about an open source project.

[26:02] **Nadia**: And I feel like a lot of those are actually really primed to benefit from things like recurring sponsorships or subscription models. I don't exactly know whether that will ever.. How much that will really lead back to open source developers themselves, because they are kind of a different breed, but it would be nice to see that as normalizing the idea that there are people doing work in software and it's interesting and worth paying for. But they are a lot more visible than maybe some of the open source developers behind the scenes.

[26:30] **Henry**: Yeah, it is interesting. We'll pay for the content, but not necessarily the code. Not that we need to, but I mean that maybe there's an opportunity there to collaborate where the people that maintain the software work with people that can essentially better explain what they're doing. You can create all these features, right, which makes the thing a lot better, but no one knows about it. So it doesn't mean anything cause no one's using it. There's a potential for it to have a lot of impact.

#### Maintenance is Inherently Not Top of Mind?

[26:57] **Henry**: This is even true for our own project, right. Even though Babel is used by all these people. And because they don't know that they're using it, if we do like a blog post release, like we just did, right. There's not going to be a lot of traction around that because it's not the most interesting thing. And at the end, that kind of makes you feel even worse too. Well, I put all this time into this thing and we're not even a small project. And yet, it doesn't really matter. And so that really changes things.

[27:24] **Nadia**: It feels like that's sort of the problem with so much maintenance in general, right. It's like a unique problem to maintainers and to maintenance. A lot of that work when it's going well is just invisible. People just want the thing to continue working and not think about it. And that's kind of, that's kind of the point, but then it creates this like big challenge around like, well if making money through sponsorships, for example, is this matter of like being top of mind for people, it's almost at odds with this idea of like maintenance work.

[27:54] **Henry**: I think so. I mean, there's this focus on like virality. Here's an example. I don't really tweet that much anymore either. And for fun I wanted to explore this idea, and this is something people have been thinking about a long time. Why are all the keywords in programming languages in English, right. If you're not familiar with English or it's not your native language, you still have to code it. And it's only 20 words and you'll probably learn it just by googling it, but I just thought it'd be interesting as an experiment to allow you to essentially change all the statements. So if, and else, for, whatever can be Chinese or Spanish or something.

[28:26] **Henry**: So I tweeted that, you know, I had like a fun little picture to make it look all nice and stuff. It got a lot of traction. But then I tweet something about this podcast and then nothing. So that's the whole clickbait thing and that's not like all bad.

#### Modes of Production: Niche and Growth

[28:40] **Henry**: I think that's weird because to me, seems to be at odds with the whole small groups, dark forest sort of thing, where you want to create this whole niche thing because you're getting higher interaction, but then the way you sustain yourself is through this general, try to cater to the average person sort of thing.

[28:59] **Nadia**: Definitely. I see that tension in my day job now. Cause I work at Substack, which is a newsletter platform for independent writers, a place where you can write and then build your mailing list and your dedicated audience that you can speak to you directly. But growing that list still requires doing things in the broader public sphere. So you can think of like, my Substack work is like the quieter niche stuff that I'm doing in a corner with my true fans who are listening. But then in order to grow that smaller, true fan audience, I still have to do a lot of things that are.. I mean, every paid writer is also doing free public posts because those are the ones that can go viral and get shared around and serve as basically like a commercial for their paid work.

[29:43] **Nadia**: Not every writer, but a lot of writers that are doing well, came from say, building their audience on Twitter. And so it's not like they can just completely go dark and never do anything public again. They have to switch between these modes now where certain things are public and therefore growing your audience and getting a lot of like random new interests coming in. And then your newsletter can be a place to do things more quietly. Yeah, there's no way to really escape that if you are a creator of any sort, I think. And dealing with the idea that sometimes.. The things you care the most about are not the things that are going to go the most viral.

#### Beyond Zoom: Designing For Conversation

[30:17] **Henry**: Thinking about that, my friend has a newsletter too and one of the titles was called Friction is the Friend of Serendipity, based off a different post called engagement is the enemy of serendipity. So I think what we're talking about is essentially the whole neutral public square idea, right? There's this space where we can all go and say whatever you want. In theory, everything is good, but now we're realizing we need friction, we need boundaries. That those are good things. But because we live in a society that has been without those for so long, there's this transition period that's going to be really difficult to figure out. Because everything is just based off of that assumption all the way down.

[30:58] **Nadia**: Yeah, it feels like the kind of thing that we can't go out and architect from scratch, but people are already starting to find ways to adapt and we'll kind of see those as the new opportunities.

[31:11] **Nadia**: I was just talking to a friend yesterday about group chats. And he made this point that I guess I just had not really thought about before. So most group chats are taking place on the most popular messaging platform. So Facebook messenger, WhatsApp, whatever. So you kind of think, okay, it must be because they're really big companies that have somehow captured this, but actually, there's no good reason why we have to be doing that stuff on iMessage or WhatsApp or whatever. It kind of just like happened. And like his point was that, it was the first place people looked to flee from the most public square.

[31:45] **Nadia**: Of course, take it to your text, take it to DMs. But those features or apps have not actually really been designed for group chat behavior. He was saying, you use SMS to receive your verification codes when you've got like two factor enabled. You use SMS for the most utilitarian things. But then you also use SMS to have these really deep conversations with people.

[32:08] **Nadia**: And it just seems a little bit like strange. What would it look like if we had social products that were really designed for group type conversations. It might look a little bit different from just like straight up messaging. And so yeah, I feel like that's a good example of, the behavior is already happening. We can kind of look at it and be like, okay, everyone's fleeing to text for some reason. Suddenly I have all these group chats that I didn't have like three or four years ago. Why is that? But then see that as almost like the emerging nascent behavior that might lead to more interesting opportunities to build on top of.

[32:39] **Henry**: Yeah, that makes a lot of sense. That sort of reminds me of GitHub being transactional. Or just seems like everything's a box, right? Zoom is just a bunch of boxes. Maybe that's where a lot of programmer's interest in like architecture comes about? The medium matters, the space that you're in matters. We're not in buildings anymore because the pandemic, but digital spaces. How do we create them so it's more embodied, right? Involves more of our being.

[33:04] **Nadia**: Yeah, I mean this question is coming up a lot now because we're all working from home or stuck at home. Or at least a lot of us are due to the pandemic. And so, Zoom is another perfect example of that where it's like, okay, this was the most reliable video chat software that existed. And even Zoom had to put out at one point, they were like, guys, we're sorry, we're designed for businesses. And so the fact that we've now become like basically overnight, this critical social infrastructure for the world is unprecedented for us. And we designed this thing for something else, but we're doing our best to try to accommodate that.

[33:38] **Nadia**: So Zoom is similar to using messaging apps to me in that it's the step zero or step one behavior. And from there we might start to think, okay, well, how can we make a video chat app that is actually designed for these kinds of conversations that's not Zoom, which a lot of people are trying to figure out right now.

[33:56] **Henry**: At least in our space? Cause like I've tried to show people that are not in tech. They're like, why do I want to use another thing, you know?

[34:03] **Nadia**: Yeah. I mean, like, you know, that is the privilege of being in tech, right. Yes, what extent most people are not aware of these things, but we're also seeing the future being made right now, right. And so I expect in like a year or two years, some of those are going to catch on and become more widely known.

#### Cozyroom

[34:19] **Henry**: That's exciting. I tried one recently called cozyroom.

> https://cozyroom.xyz

[34:22] **Nadia**: Oh, yeah, I tried that too. Yeah.

[34:25] **Henry**: You're just a little circle and then like. I mean, even the name, right? It gives you a different attitude towards being in a space with someone, right.

[34:32] **Nadia**: Yeah that one is fun because you're not like in this terrible grid that so many video chat apps force you into. You're in this like blank space. And then you can add objects and literally create a room for yourself. Yeah, cause there's no video if I'm remembering it correctly, right? You're like a little blob and then like you talk to other little blobs and then, but it's actually kind of soothing cause.

[34:52] **Henry**: Your mouth moves.

[34:53] **Nadia**: Yeah. Your mouth moves! That was what was cool about it, right. Cause I remember trying online town, where you're this little avatar figure that's running around a map and there's also a video underneath of you, but then it felt almost disconnected or disjointed.

[35:06] **Nadia**: But I like that with cozyroom, when you're talking, your cartoon is talking, it's almost like I don't need the video to look like me, but I just want to see some representation when I'm saying something or whatever. Yeah, that was a fun one.

#### Tools Vs. Apps: The Tyranny of Grids

[35:16] **Henry**: It's like the tyranny of grids, I guess.

[35:19] **Nadia**: Yeah, it's just nice to not be in a grid all the time.

[35:23] **Henry**: It's funny that's like the default UI though. How we think about making things. Oh, just making a grid. But trying to kind of emulate what a conversation looks like with people in real life, right? I think the example that people bring up is like, say you're in a zoom meeting. You want people to go in the order. You can't, because they're all in different places, but at least with a space, right. You can actually do that.

[35:46] **Nadia**: Oh, like go around the room or something like that.

[35:48] **Henry**: Yeah. Like counterclockwise, cause you're literally in a digital space.

[35:52] **Nadia**: I still don't understand why, like my grid it does not look the same as everyone else's grid on the same Zoom call. It seems like they always put you in like the top middle or something like that. Whoever you are. I guess it just changes for everyone else, but it can get very confusing where you're like, I want the sensation of let's go around the room, but my room doesn't even look like your room.

[36:10] **Henry**: It's such a simple thing. It's funny that technology can do some such amazing things, but once you kind of veer off. Simple as like wanting to go in order, it doesn't work anymore. It does remind me of about Ivan Illich. He talks about Tools for Conviviality and this idea of tools versus apps. Apps are created by a designer that kind of forces you into their vision of what it is, I think that's similar to the grid thing. Versus a tool, where like you get to decide for yourself how you want to use it. You have the freedom to do that.

[36:42] **Nadia**: Yeah, I've talked about with friends, this issue with screen-sharing also where you show someone a presentation and then it's like me kind of pointing around with my mouse, but people sometimes understand your presentation better when they can poke around in it themselves. So there's a difference between, I have Google slides and then I put it on screen share on a zoom call. And then it's just you having to look at me go through the slides at my pace. Which is different from, I made my presentation and Figma and then I gave everyone a link to the Figma file. And if you do that, cause you can see people's cursors bouncing around in Figma, you can see like, everyone is kind of exploring the deck on their own while also listening to you explain it. And sometimes I think that can to better retention of what you're talking about because you're letting people touch the thing and play with the thing.

#### Simulating Walking Through a Park

[37:24] **Henry**: Yeah. I was kind of thinking too, if everyone's going into the group chat mode, there is also a desire to meet new people, right. Where does serendipity come from? I mentioned in a post before about being in New York and meeting random people on the street. Maybe potentially making friends with people, but now that we can't do that. How do we do that online, the whole go to the park or go to a bar and then you meet someone.

[37:47] **Nadia**: Yeah. And how do you simulate the things that you're doing in a park. I think one of the issues that I've talked about with friends about all these interesting new special software apps, and maybe this is just because they're still so novel. But sometimes the app itself becomes the experience that everyone is talking about.

[38:02] **Nadia**: And everyone's like, Oh, look at all these features or whatever. And then you play with all the features and you're like, okay, we're done. And in my mind that means the app did not do a good job of what supposed to do, which is like, it's supposed to just be the environment that enables you to have a better conversation with someone else.

[38:17] **Nadia**: And so I think about like getting a coffee with someone or going to the park with someone. It's not because we want to look at the park so badly that we're there. It's not because I need to drink a coffee that I'm there.

[38:28] **Nadia**: There's this line, and this is a random reference, but in Good Will Hunting, where they talk about like chewing caramels and the idea that like chewing caramels is just as arbitrary as drinking coffee. The whole point is I just want to like hang out with you. And so how do we create the ideal like software or environment. Something where all I want is for you to facilitate the conversation I have with the other person, I don't want the environment to be the thing.

[38:51] **Nadia**: Like if I were meeting with someone at a carnival, it would be a lot more distracting than meeting with someone at a park. And we might've had fun at the carnival, but then we never really went that deep with each other.

[39:01] **Henry**: Oh, I see. Cause the carnival would be the event, versus just walking. It's about the conversation

[39:08] **Nadia**: Yeah. Or like going to a movie or something. It's common to be like, let's go to the movies to hang out with someone, but you don't actually really hang out with them during the movie you got go like do something else, because the movie is the attraction.

[39:18] **Henry**: Hm. Yeah. It fades into the background, the environment. Yeah.

#### Digital Fidgeting Through Removing Video

[39:22] **Henry**: That reminds me, you had like a note that was about fidgeting, right. It's sort of similar.

[39:26] **Nadia**: Yeah. It kind of comes from the same thing of. Like people think better when they're able to do something. So I was like talking about the Figma file, for example, where I can like play around with the deck. But yeah, I mean, even as we're talking, I'm like playing with the cord on my headphones right now.

[39:41] **Nadia**: Cause it just like helps me kind of think as a.. So we need something to fidget with, but like in a Zoom call part of what makes it so awkward is like, you're just like staring at each other. We were talking about video for this conversation and I've actually found that I prefer doing non video things because it like, weirdly helps me feel more connected to the person, when I'm not forced to be in this stupid grid box thing, staring at each other.

[40:03] **Nadia**: And so questions of like, how can software itself provide that kind of fidgeting opportunity? One thing I'd kind of brainstormed with a friend.. Imagine if you had a YouTube video or something that was playing passively in your video chat app. And so it's like, I don't know, the way when you go to a bar and there's a movie playing silently in the background or something, and then everyone kinda ends up looking at it.

[40:21] **Nadia**: Cause it's just like a thing to look at and then it helps you feel less awkward talking to people around you. Imagine if on Zoom, we just had some video up that was not too distracting, but just something pleasant to look at while we're talking. Would that help improve conversation?

#### Focusing Through Distraction?

[40:35] **Henry**: It's weird, cause I feel like intuitively it wouldn't make sense. But I understand, even with this podcast.. Maybe the reason why is because our different senses. Audio is the only thing that we can communicate with, then I focus more on the audio. Maybe we overemphasize seeing over everything else, right.

[40:50] **Nadia**: Yeah. I mean, I definitely feel like that's the case. I think I generally just hate looking people in the eye and stuff anyways. So I'm probably like the worst person to ask about this, but my brain can just like wander more and I can listen better when I am not forced to stare someone in the eye.

[41:09] **Henry**: It's weird cause somehow not focusing helps you focus more. I was just talking with a friend the other day, how do people grow deeper with their family? And a lot of times it's through food, right? So say at the dinner table, but maybe people now, they don't eat at like a table. They are watching TV at the same time, or there's a TV in the background, but that's exactly the thing that distracts people from getting into deep conversation though.

[41:32] **Nadia**: That's true. He could make the argument, the movie playing silently in a bar, that it would actually just be a lot better if we didn't have that movie playing or when there's a sports game in a restaurant, I hate that because then the person I'm sitting with is just looking at the screen and it creates a less connected environment. So yeah, maybe it's not a good thing to have that kinda stuff.

[41:48] **Henry**: I understand completely, at least with the one on one. Cause if they're not responding at all, then they wouldn't even be having this conversation in the first place. So I can see why that could help. But maybe for the group setting, it's a lot harder, you know, where people are on their phones.

[42:02] **Nadia**: Yeah, right. When you're like actively engaging with someone else, then it feels like you're probably not paying attention to the conversation at hand. Doodling in a meeting is like another behavior like this, where people see someone doodling in a meeting and they assume that means the person is not paying attention. But I think for a lot of people doodling, it actually is helping them listen better by giving them something to do with their hands.

#### Shaping to Future of The Social Web

[42:22] **Henry**: I dono why we started talking about this.

[42:24] **Nadia**: That was a long side tangent. That those things are not covered in my book.

[42:28] **Henry**: I think it's related in the sense of like how do we engage with our environment and what's changing?

[42:35] **Nadia**: Yeah. I think the fact that all these interesting things are happening right now, it just points to a really fun renaissance for the next wave of the social web right now. People just always say it's over. And then it's like, never over. This time, people were like, no, it's really, really over.

[42:48] **Nadia**: Like, Facebook is huge. Twitter is huge. Like these things are just not going anywhere. And then what do you know? Like turns out there's a whole new set of behavior that is emerging. And yet some of that is still happening on those platforms. And, it's very likely some of these things will get acquired by those platforms.

[43:02] **Nadia**: But I just think it's so fun that we'll never be done building our social infrastructure because people just change and we need new tools to help us express ourselves. And so it's like everything we use, every messaging app, every social app, is actually really just a product of our collective tastes. And we do have the power to shape that if we want to.

[43:23] **Henry**: Yeah. And I guess that empowerment kind of speaks to this idea of things being global and open versus local and, not necessarily close, but more private. I think you mentioned in one of your posts, someone made like a group chat, custom made for their own group or something.

#### Creating the Suburbs of the Internet

[43:41] **Nadia**: Yeah, I'm not sure about a specific example, but I definitely have come across a number of friends who are just spinning up their own apps for fun, which is so cool because. Oh yeah, I do remember this. We were talking about, in one of my group chats earlier this year, before the pandemic happened, where we're like, Oh, wouldn't it be nice if we could make our own custom messaging app instead of using Facebook messenger to have this conversation. And in my mind, I was just like, Oh that's cute. It'd be fine. But like why would anyone use anything besides facebook messenger, WhatsApp, whatever. And then you fast forward six months, less than that, and suddenly you see this explosion of like new chat apps that are being created. And so, it is just like so cool to see that happen.

[44:19] **Henry**: Yeah. I guess it's natural for the bigger apps to be catered to the general person, then you have an incentive to make something that's for your group or allows you to express yourself in ways that are not just text or something.

[44:30] **Nadia**: Right. It feels like the new wave of cool stuff that's gonna emerge on the social web is going to be made for small groups and it's going to be made for quieter conversations. And it's just going to be this really cool.. I don't think like Facebook or Instagram or Twitter or whatever, they're not going anywhere, but it's like nice to have this parallel world crop up.

[44:48] **Nadia**: I think of it as, we've made all these really public town squares, and now we're kind of building like the suburbs or the private homes or something of the internet, just places for people to kind of like peel off and go somewhere quiet. Which is just really cool to see.

#### The Beautiful Dance of Norms

[45:02] **Henry**: Yeah. This has to do with the book Strange Rites. About institutions and how they failed. Tara's book was about how people were all a part of organized religions before, but now it's splintering because of the internet. She uses the word remixing where like we kind of mix and match what we want. And so this is kind of the same thing where we kind of get to choose what we like. The paradox is sort of, when it starts with you, you eventually want it to get bigger and then you become an institution, eventually.

[45:32] **Henry**: And you don't want to, because the whole point is you want to be more, she's uses the word intuitional. What you think is right over what someone else is telling you. I think that's just like an interesting phenomenon of wanting to become an institution to make it more real and authoritative, but then also you lose the personal aspect of it.

[45:50] **Nadia**: Right. And I think that's just the cycle that defines how we build and innovate and strengthen our norms over time, right? Like there's always going to be this cycle of some things becoming more institutionalized and then people kind of pushing again to the fringes and making new things. And I think that's just like a really beautiful dance that we all kind of go through.

[46:08] **Henry**: I guess we could just end it there.

[46:10] **Nadia**: Yeah, I enjoyed having this conversation.

[46:13] **Henry**: Yeah. Thanks! Please get Nadia's book!

[46:16] **Nadia**: Oh yeah. I should probably say that, buy my book.

[46:18] **Henry**: Working in Public.

[46:20] **Nadia**: Yes. Working in Public. It's available now.

[46:23] **Henry**: Alright, cool. Thanks for coming on this.

[46:25] **Nadia**: Thanks for having me.
