---
title: "Very Online (Strange Rites)"
season: 3
date: "2020-07-23"
time: "63"
description: "What happens to our religions when they meet the Internet? Tara Isabella Burton joins Henry to chat about her new book, Strange Rites: New Religions for a Godless World. They chat about our failing institutions, taking fandoms like Harry Potter seriously, how we all remix religion, how consumerism infects all of life, on embodiment and givenness, and most importantly, what is our freedom even for?"
episodeLink: "0f941cd6"
embedUrl: https://share.transistor.fm/e/40b0aef1
sidebar:
    order: 3
---

### Links

- The book, [Strange Rites](https://www.publicaffairsbooks.com/titles/tara-isabella-burton/strange-rites/9781541762510/)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/online.md)

#### Charles Taylor meets Marshall McLuhan

[00:00:00] **Henry**: I just read an awesome book and I figured maybe I'd reach out to the author to see if we could talk about it? So today I have with me Tara Isabella Burton. Thanks for joining today.

[00:00:09] **Tara**: Well, thank you so much for having me. I'm delighted to be here.

[00:00:12] **Henry**: So the book, it's called Strange Rites. I think you're trying to say that there's a certain view we have about religion. People think that everyone's becoming atheist, but you're saying that there's this swing between what you call intuitional versus institutional religion. One is about structures and one's about personal belief and it kind of goes back and forth.

[00:00:31] **Henry**: But because of the internet, maybe this intuitional version is going to stay. So the two books that I kind of see are A Secular Age by Charles Taylor, and that meets McLuhan, The Medium is the Message. I don't know if that makes sense.

[00:00:45] **Tara**: Well, man, that is high compliments indeed. I'm a big fan of both. So I'll take it.

[00:00:49] **Henry**: I kind of wanted to mention your intro at the end, a quote. It says, "It is also about the Americans who don't know if this is all there is or what all means, or there, or even is. It is about our quest for knowing, for belonging, and for meaning. The pilgrimage none of us can get out of."

#### Who is this written for?

[00:01:07] **Henry**: So my question is, who is your audience even?

[00:01:09] **Tara**: Sure. So I used to work as a religion reporter for vox.com, which tended to be a sort of stereotypical, progressive, younger left-wing reader. But I also write, in the course of writing about religion, for sort of more explicitly religious audiences.

[00:01:25] **Tara**: I felt this challenge to write this book that could be read and deemed sort of respectful and fair both by a lot of the people written about in the book, which is to say you're kind of younger, spiritual, but not religious, urban millennial who's involved in witchcraft or who's part of a polyamorous triad, or who's really into wellness culture, but also be read by people who are kind of used to thinking about religion in different terms, who sort of think a lot about it and put that as a priority.

#### Taking The Internet Seriously

[00:02:00] **Tara**: And the ideal book, I felt that the way to do that was to take these phenomenon seriously as religions. And I think that even when I'm perhaps critical, I tend to be more critical let's say the capitalist and manifestations of a lot of these phenomenons. So not witchcraft, but the way in which witch culture has been commodified.

[00:02:22] **Tara**: But my goal was to present these groups of people, both to people who could see themselves in that and be like, "Oh, you know, this religious element, this is how this is what I'm doing is also perhaps reflected by other phenomena."

[00:02:35] **Tara**: But also I think there are some of my readers, including more conservative readers who are accustomed to, for example, say things like, and this is sort of common right-wing trope, "Oh, the social justice warriors. They're a cult. They're a religion."

[00:02:50] **Tara**: To encourage them to step back and say like, What does that actually mean? What is a religion? What needs might this fulfill? What hungers might this be and also to kind of recognize a seriousness on the part.

[00:03:03] **Tara**: I think that there is a misconception often. And again, this is a more conservative talking point, although this is not exclusively, that millennials and younger, "the kids these days", are with their selfies and their apps. They're so narcissistic and they're doing everything just for their own desires. And I think that there's a kernel of truth to that.

#### Narcissistic Millennials vs. Institutional Failure

[00:03:26] **Tara**: But the way that I wanted to present that story was that in the era of institutional failure, which is to say our lack of public trust in universities, in the political system, and the journalistic establishment, the medical, everything. Yep. Pretty much everything.

[00:03:43] **Tara**: The sort of turn, which I think is phenomenologically true, towards a kind of intuitional model of understanding. Sort of trusting your gut, rejecting external, believing that your desires are kind of ontologically good. All of these things are kind of natural, normal, and even rational responses to a broader question, which is you can't trust anybody else.

[00:04:06] **Tara**: And that was, in a way, something that I wanted to subvert a lot of the narratives, either that, we're getting away from religion and religion doesn't exist anymore, or, well, all of these people are just worshiping themselves now because they're narcissistic millennials, and those were stances I wanted very much to write it against.

#### Not Dismissing the Strange

[00:04:26] **Henry**: Yeah, that's so good. It came across that you weren't necessarily trying to criticize anyone, but you're telling actual stories of people, and you even mentioned that you participated in some of these yourself. So it's not like you're like, ha ha. But like, I know what it's like. I understand why people aren't doing this.

[00:04:42] **Henry**: I guess it's so easy to dismiss things that we think, I guess you're using the word, strange or weird. I think it's good to take it seriously where you're saying that not just about the self, but they're trying to look for something that institutions have failed to give them. And there's that value of thinking through the underlying issues, instead of just saying they're wrong or something, right.

#### Becoming Religiously Unaffiliated

[00:05:04] **Tara**: Absolutely. You know, while I now very much identify as a Christian. That was definitely much more fluid, even in the time that I was writing the book. You know, and for a lot of my twenties, I definitely had, in many ways, I fit the profile of someone who might easily have become unaffiliated.

[00:05:21] **Tara**: I was raised kind of episcopalian, but we were not a particularly religious home. I was baptized. We went to church sometimes, but mostly it was a kind of Christmas and Easter thing, and this is particularly the case in members of mainline Protestant denominations.

[00:05:35] **Tara**: But I think it tracks more broadly as far as I know, is that you're more likely to become religiously unaffiliated, which is to say you tick no box on the form, if you are raised in a home where religion is not discussed very much, or actually if you're raised in an interfaith home, which makes sense because idea behind it is that if you're raised in a home where one set of ideas about God is not seen as so important that it should govern everything. If it's like, yeah. Like this might be true, but that might be true. And you know, what matters is that you're a good person.

[00:06:09] **Tara**: If that is sort of the environment you're growing up in, it makes total sense that if that's true, why should I be spending an hour a day going to church or sorry an hour a week, or go to synagogue? Why should I do things in that way, rather than volunteer at a soup kitchen or get involved in activist politics.

[00:06:27] **Tara**: I think somewhat counter-intuitively, and that I think we hear a lot more about people who are driven out of religion because it is oppressive in some way. And certainly that is true, 46% of LGBTQ Americans are unaffiliated compared to just 24% of the average. But by and large, there's a huge bunch of people who are just like, "Oh, traditional religion. You know, it's not that important to our parents. But they still check the box, but we don't even feel the need to check the box."

[00:06:53] **Tara**: So that's the profile of sort of what I grew up in and certainly I was one of those kids who was hungry and interested and was sort of involved at various points. You know, I did indeed have a relationship with witchcraft. I've written about that and various other phenomenon: book fandom, as I write myself in the book, a big fan of Sleep No More. Certainly others as well. And I think that while my path sort of took me, to sound all sort of little woo there, my path took me back to Christianity. That was not at all a given, especially not.. I'm in New York city, which is sort of a hotbed of pagan culture.

[00:07:28] **Tara**: And I sort of wanted to look at it a little bit personally, even though there's not that much of my personal voice in the book, but to thank some of my best friends, similar upbringings to me, they're intensely practicing witches. I have people I'm really close to who feel very strongly about polyamory and are very much involved in that.

#### Growing Up With Fandom Culture

[00:07:48] **Tara**: And so it was sort of in a weird way a journalistic book, but a bit of a, I won't say a memoir that's too strong, but I was approaching the book both as a journalist and as someone who had kind of seen and been through alongside others. That question of, and this is a question sort of more and more pertinent as, as the millennials and generation Z come of age, how do we think about spirituality today?

[00:08:14] **Tara**: And I do think that there's a big generational gap in this and that really millennials are the first generation to grow up in internet culture, especially internet fandom culture, which very much set the stage for how we as a culture, think about the self, how we interact with one another, what ownership we want to have over texts and ideas.

[00:08:36] **Tara**: And in the book I talk about Harry Potter fandom as a sort of canary in the coal mine for this, but the sort of new ways that people gathered on the internet started, you know, whether it was through fan fiction, or the creation of memes, or the existence of forums, this sort of new tribalism began around: you like something, you find other people who like it.

#### Change it, rewrite it, re-imagine it, make it yours

[00:08:55] **Tara**: You reimagine the texts and the idea so that it's really centered around the fan community, not the text. The sort of quasi exiling of JK Rowling from Hogwarts fandom, I think is a really telling example of how little the author has to be involved in this phenomenon.

[00:09:12] **Tara**: And I think even for people who didn't grow up writing fan fiction, although, you know, fair number of people did, I'd say that we are still the generation that grew up in that sort of wider mentality of you don't like this text, change it, rewrite it, re-imagine it, make it yours.

[00:09:33] **Tara**: And it stands to reason, and I certainly argue that it does, very much map onto our sense of, just to give you one last set of numbers. So I said before 24% of Americans overall are religiously unaffiliated. That goes up to 36% when, if you're born after 1985. So we're seeing a pretty distinctive shift here.

[00:09:53] **Henry**: Right. I guess I consider myself in that group. So yeah, I do feel like even as a Christian, I am drawn to these other things. I think we would like to say that those things might not be bad, but we talk about idolatry, meaning that we're just putting that above God. I think you even talked about this recently about good things that are being perverted, not just like bad, right?

#### We're All Remixers Now

[00:10:14] **Tara**: Yeah, absolutely. And I think that, you know, it's worth saying here that the sort of phenomenon that we see of this kind of mixing and matching, it's not just for the religiously unaffiliated.

[00:10:26] **Tara**: There's a 2018 Pew study of New Age beliefs. And they say it's psychic, reincarnation, astrology, spiritual energy in physical objects. And what they found was self identified Christians, about 60% of them believe that at least one, about 30% of self-identified Christians said they believe in reincarnation.

[00:10:44] **Tara**: Now you have to really stretch it to say that that was Orthodox by any definition. And so you do have this phenomenon, people who are like, yep, I'm Christian, but I still want to mix and match. I still wanna have a faith that's tailor made to me and my instincts and my intuitions rather than assenting to a set of dogmas. And unfortunately, or fortunately, you do have a creed, it's there. There are some things you gotta say you believe, and that's where I think attention can be.

[00:11:14] **Tara**: And I, on the one hand, don't want us to condemn my past self for saying, or let me put it this way. Whatever, for example, tarot cards might mean to someone. There's a question A, which is like, what does it mean to your average person who finds great benefit in that? But a second question is like, is that compatible with Christianity? And there's sort of different versions where someone might say yes, and someone might say no. We'll say it's not something I do anymore, and I made that choice for myself. But I think that I am very conscious of.. The culture of remixing as I call it in the book, is not just a phenomenon for the spiritual, but not religious or the unaffiliated, but rather a much broader phenomenon across American religiosity.

[00:11:59] **Henry**: Right. Just seems like so many questions come down to this. We are all affected by something, right? Like we're all affected by the internet. It's just like always pointing to other people and how they've messed up or failed. How they've changed, but like how have we've changed? And I think it's so hard to kind of have that self reflection on that.

#### Maybe not hexing Kavanaugh, but doing a meditation app

[00:12:17] **Tara**: It very much isn't here are these people doing this new thing, and I think some attention in the book is, you know, you want to give examples that are illustrative. So you want to talk about Soul Cycle or Peter Thiel, these like very extreme people, who are extreme in one direction or another. Harry Potter fans who think that they're literally having sex with Severus Snape, witches who want to hex Brett Kavanaugh at Catland bookstore in Brooklyn.

[00:12:41] **Tara**: All of those things, I won't say fringe in a weird way, but like perhaps extreme representations that are illustrative, yet so many more people, maybe they're not going to a pagan bookstore to cast a hex, but they're like Sage cleansing, they're lighting candles and doing a little ritual, they're doing a meditation app, doing yoga, and are still kind of caught up in the sort of broader cultural strokes, even if they're paradigmatic examples.

[00:13:09] **Tara**: And I think anyone who has internet access regularly in America, who is in late capitalist culture determined in part by this idea that we are defined by our consumptive choices, and that those choices are sort of increasingly presented to us as part of our brands. You know, the movies we watch on Netflix are given to us by the algorithm of, if you like that, then you'll like.

[00:13:36] **Tara**: Ditto the news we see, and the information we get from our social media feeds. This sort of sense our worlds are increasingly bespoke, to use a word those millennials, is something that I don't think we can get out of, or that we have to contend with. Whether or not we identify Orthodox Christians or nothing in particular, none of us can get out of these cultural trends.

#### On Escaping Our Givenness

[00:13:59] **Henry**: Right. It kind of reminds me of David Foster Wallace, we're in the water and we don't really understand that. We can't feel it. Maybe it's like disembodiment or trying to escape history or the space and be like, I am objective, I am neutral, everyone is not, right.

[00:14:13] **Tara**: I think that's something that people try to do. As I do in my piece recently for Comment magazine, this sort of late liberal, hyper liberal, you might say neoliberal, that one works too, that we are the possibility of the the neutral public square or the objective rational person.

[00:14:32] **Tara**: I think that this is sort of a pleasant fiction that any of us can be, however rational we might try to be, however many cognitive biases we can learn and correct, that there is some version of us that is both social and bodily givenness. That there's even some truth that we could possibly apprehend.

[00:14:58] **Tara**: And, you know, the fact that even we think in language and language itself is received and given to us even as we dynamically create it. And so like, the very categories we have available to us to, to make sense of the world are not just imperfect, but socially embedded.

[00:15:15] **Tara**: And I think that there's a growing sense, I think, that neutrality, liberal neutrality, and this sort of vision of ourselves or a hypothetical human being as a rational observer is insufficient.

#### Resisting The Neutral Public Square

[00:15:30] **Tara**: And I think many of these groups that I profile, they're not all, are marked by a resistance to it in different ways. Which is to say, you know, the social justice movement, which I think has often been kind of maligned in certain ways, something that they do get at, which is actually not so different than some of the kind of more right wing groups that I profile, including those from modern atavists get at, is that: this idea of neutrality seems to be a sham. This liberal, neutral public square stuff. You know, it's not working. And that's something that the concepts of lived experience and concepts of the situatedness that comes from intersectionality are getting at.

[00:16:11] **Tara**: But I think to the real fascination on the part of like, Jordan Peterson fans and those sort of more extreme to the right, are also talking about, you know, there is something about Nature, about what it means to be a man. Whether that's from an evo-psych perspective that shapes us in a certain way, and this is part of who we are. And we need to recognize that because capital N nature, in this almost as I argue, quasi pagan way is a force and, you know, I don't necessarily mean that pejoratively either. But I do think, it is its own ideology. and I think that, you know, it's worth paying attention to the fact that so many young political cultural movements are allied, however they might differ, wherever they might differ, in placing the problems of the world in a sense that the neoliberal world is a failed institution.

#### Struggling Against While Embodying Neoliberalism

[00:17:11] **Henry**: Um, I guess I've learned about neoliberalism recently, and it's so hard to define what that is. Is one way of what you said it essentially meaning that people are free rational agents? Is that the reduction..

[00:17:25] **Tara**: Yeah, the sort of neo version of it, I'd say, is sort of a real alliance between the kind of classical liberal faith, that we are rational self-interested beings who can sort of by virtue of reference to those qualities, build a society characterized by the creation of sort of neutral mechanisms that allow us to pursue our rational self-interest over and against a kind of society that has a robust vision of the common good that might put limitations on those freedoms. And that's sort of a slight of hand there because I would argue that the pursuit of individual freedom is the common good in the liberal model.

[00:18:09] **Tara**: The sort of neoliberal gloss on that, as I understand it is, is sort of the alliance of that with consumer capitalism, such that it becomes a kind of joint political economic project that takes the idea that we are rational, self interested and then sort of makes a certain vision of human freedom, often human consumptive choice, the kind of prevailing constitutive element of understanding human organizations. So that's my very rough version of it.

[00:18:42] **Tara**: But those at least are the qualities and the models that I see my subjects as struggling with and against and often simultaneously struggling with, but also very much embodying. It's a love, hate relationship. Like you said, we can't get out of the water. You know, do you buy a fuck capitalism t-shirt, you know, the sort of (laughs) . It's a thing, people do stuff like that.

[00:19:04] **Henry**: Yeah, that makes sense.

[00:19:05] **Tara**: I think it's so difficult even when you want to get out of that model. And for me, you know, for all that it's true that I may look someone who says, well, I am a Christian, but I believe in reincarnation. It's also true, this is sort of important knowledge, I am a queer affirming Christian and there are people who would look at me and say like, she's doing the same thing. I'd argue, I have my own theological reasons for my stance. But I think that it's fair to say that I too might be open to that accusation.

#### Consumerist Christianity

[00:19:36] **Henry**: Hmm. Yeah. It is interesting that consumerism can, I guess infect anything, right? Just Christianity, right. We have the mega church model or even online church, right. Now because of the pandemic, you can maybe not go to church anymore, just tune into whatever stream you want, maybe worship whatever you want.

[00:19:55] **Tara**: Absolutely. I mean, that's something that I've been thinking about specifically in the context of this time. I think already there's a question which is, you know, this is obviously sort of more visible in the mega church model of like Hillsong and entertainment and the kind of cool Instagram influencer pastor. But I think it's true more broadly, which is that there is a sort of personal branding element too.

[00:20:19] **Tara**: What church do you go to? No, you could say that's been always been true, you know, in 1954 your sort of powerful men in DC are probably having a conversation of like, well, what parish do you attend? And that being a kind of social Shibboleth. But I think that the idea now that because those choices can be constituent of a kind of sense of self. I say this to myself too. I go to a church in my neighborhood, but it is a distinctly Anglio-Catholic, high church, you know, very liturgy heavy.

[00:20:47] **Tara**: And I made the choice to go to that church and not the one physically closest to me. In pandemic time, when you can go to any church, I do know of people who are like, yeah I dial into however many church services a day and I pick the one I liked best. And this one has the best music. And when the limitation of can we get there in time for 11 o'clock on a Sunday morning is removed, there is a potential tendency and a dangerous one to say like, all right, what church fits exactly with what I want, what church should I consume?

[00:21:18] **Tara**: I think that that is a danger and it is worth thinking about that our identities as Christians, whether we are high church, Anglo Catholics, or megachurch evangelicals, members of the Bruderhof community, or what have you, that we don't kind of start to think of it the way we would think of what tote bag you wear. And if you're a new Yorker tote bag, what that says about you. And that's a very real danger, I think.

[00:21:43] **Henry**: Yeah. It's like shopping for church or something or actually, what is that phrase, church hopping?

[00:21:47] **Tara**: Church hopping, exactly.

#### Personal Brand as Religion

[00:21:49] **Henry**: I think it's really hard because it's so subtle. Well, I'm still going to church, right. I'm still listening to things. And I think that is the medium is the message, saying that the content is what matters. And we're saying that the medium, the environment, the way you decide to get that content matters a lot. That could be the form and function or aesthetics, right?

[00:22:07] **Tara**: Yeah, absolutely. I completely agree. I think the very models of how we exist, how we worship and how we self def-. Even I have been using the word, identify, as a Christian in part because I think it's useful. You know, I don't want to make the claim like this person's Christian, this person's not, when I'm looking for polling data, but even that sort of way in which we are constructing our identities and we use that language is I think very much wedded to a contemporary notion of how we build ourselves and models of ourselves in our head and share those with others.

[00:22:43] **Tara**: I do think there is a very dynamic and perhaps unsettling relationship between the advertisement branding and personal branding and the notion of the personal brand as something that is kind of at once influencing and influenced by the other brands that we participate in.

[00:23:03] **Tara**: I think it's a sort of open question. What does it mean to construct fashion, a self in an era where the personal brand is such a huge part of our economic and social lives. You know, online dating, 40% of couples who got together in the past year did so online. You build a personal brand on that site too.

[00:23:23] **Tara**: If you're in the gig economy say, and whether you're trying to get editors to notice you on Twitter, or you're on LinkedIn, or you're bidding for work on, I don't remember what e-lance is now, Upwork. Even like something like TaskRabbit, where you build your profile and hope that you're selected for a job.

[00:23:38] **Tara**: You're constantly building versions of yourself for economic consumption and for social consumption, but in a structured way. How can we disassociate our religious identities from part of it?

[00:23:54] **Tara**: I think it's really telling too that, you know, our religious identities, which often sort of go with certain set of political shibboleths. Like what does it mean to be, for example, a white evangelical in this country. Probably means a host of political commitments, including a fondness for Donald Trump. 81% of white evangelicals voted for him in 2016 and his numbers may remain comparable in 2020, he's held strong with his white evangelical base. I would motion that there's a lot in the gospels that would be pretty antithetical to a sort of MAGA support, but there's a pattern there, there's an identity there that is more than just the content of creedal Christian faith.

#### Illusions of Intimacy

[00:24:33] **Henry**: I guess going back to your point about, I would even use the word, like influencers, streamers, right? I feel like one of the ways to combat it is to not play in the sense of not being online anymore, but then you don't want to turn into, you know, someone that isn't engaged and isn't understanding what's going on. Maybe something I've learned about recently, this idea of parasocial relationship, where you feel like you understand someone because you kind of watch them. But then if it's like a YouTube or Twitch streamer, you can communicate with them, right. You can talk to them. I guess there's the only fan thing too. And that goes beyond just one way, but it feels like it's two way, but it's fake, right?

[00:25:09] **Tara**: Yeah. Yeah. And actually, I think only fans is a great example, too. This idea that what is selling more and more, illusions of a kind of intimacy. You know, we are less, I think it's it tell-, the way in which a lot of work, including sex work, has been democratized in a certain. Or rendered kind of culturally visible and accessible.

[00:25:31] **Tara**: There being a lot of these sort of gray area, someone who sells photos on only fan, but doesn't do kind of other work, you know, where do they fit in the sort of wider sex worker economy? It does seem that there's a sort of strong desire for a kind of brief burst of intimacy. You might pay someone for a photograph or for a text exchange and it's I think ubiquitous in part because our whole culture and society does run on similar senses of branding, of the exchange of money for attention or attention being conceived of as money.

[00:26:09] **Tara**: What's the word? The personal essay, industrial complex, which was a sort of phenomenon that became big in the early two thousands, which is when a lot of websites really wanted to get a lot of clicks. These were often women's interests website and they realized the best way to do that was get these kind of viral, personal essays, often written by young women who wanted to get a foot in the door as a writer and everything from like, I slept with my father to I found a cat hair in my vagina, like really weird, but kind of provocative essays, often written by people who would either accept no money or like a hundred in the hopes of getting into the industry. And then these stories would go viral and get a bunch of clicks and they were making a lot of money for Jezebel or xoJane or Hello Giggles.

#### Commodifying, Contentifying Your Life

[00:26:53] **Tara**: And it really wasn a sort of commodification of particularly young women's personal lives for collective public consumption and corporate profit. And I think models like this are actually extremely normal within 2020 society. You know, how do we commodify our lives?

[00:27:16] **Tara**: And the same way, you know, you have a spare bedroom. Maybe you rent that out in Airbnb. You have a spare five hours of your day, maybe you drive for Uber or pick up gigs on TaskRabbit. You have this thing that happened to you. Maybe you write a personal essay about it. And you know, so much of our lives is now configured as content. And of course I recognize that in my industry, that's particularly true, you know, as a writer, it is true that sometimes I write about my personal life sometimes not.

[00:27:46] **Tara**: And all elements of intellectual inner life are things that might well make themselves into something that I which often, almost always at this point means something I'm paid for. And what does that mean? And I think that's more visible in the case of a writer, but I think it's much broader than that. I think we are all kind of participants in both the gig economy and the attention economy.

[00:28:15] **Henry**: Yeah. Some news article was talking about, what people want to be when they grow up. And I don't even know this is accurate, but you could just assume that it was true that whatever percentage of kids want to be YouTube based when they grow up. And say 70% or something instead of like an astronaut or something. And so by watching these things, it's like a self fulfilling thing where now I want to be an influencer too. And so then it changes my attitude towards.. I see this in myself too, it's like, Oh, that could be a good podcast. Like I want everything to be efficient.

#### If You Didn't Tweet It, Did It Really Happen?

[00:28:43] **Henry**: I guess the last episode, I mentioned this idea of doing things for its own sake. And I think that might be a way of kind of fighting, resisting against that where it's like, say in my work in open source and coding. If I spend my time reading your book, Strange Rites, or something about anthropology. It just seems like it has nothing to do with coding. And to myself, I feel guilty and I have to justify to myself, is this worth my time? Instead of just saying just be okay with the fact that, I am enjoying this and maybe it leads to something. I don't know, I'm not sure I don't want to be efficient.

[00:29:14] **Tara**: Yeah, no, I think that's absolutely right. It's something that I've been thinking about too. How do I, as a Christian, as a human being, take time to read books, not to tweet about them, or write about them? To write work that is not conceived of as like, well, where's this going to put my brand next? What is it going to do for my career and you know, how do I act in a way that is authentic, again, to use a very hipster popular word, but I think it's a it's popular because we have such a sort of hunger for it.

[00:29:48] **Tara**: I've drastically cut back a lot of my social media usage. I used to be always on Facebook, always on Instagram, always on Twitter. Twitter I'm still on professionally. But the other two, I locked my Instagram account a few months ago. That was a great idea. I post like once every couple of months. It's better. And same way, I use mostly use Facebook at most to post an article or two.

[00:30:11] **Tara**: And it has been healthy, although at the same time, in an era where so much of the way we connect is on social media, especially now when I can't see people in person the same way. I'm also very conscious of wanting those sources of connection, even as a imperfect next best thing.

[00:30:28] **Henry**: Yeah, it kind of feels like you have to. And I don't work at a company anymore. I actually left my job to kind of do this open source thing. So if we're giving away the code for free, we're essentially just asking for donations. Then I feel like I am like a YouTuber or streamer. I'm doing the same thing. So you feel if I don't say that I need money, then who's going to give it to me sort of thing. And I think it goes against my instinct of not wanting to be a marketing person, even though I know that everything I do, if you look in that view, it's marketing,

[00:30:58] **Tara**: Yeah. I think that, again, that's something none of us can get out of especially now, and there is nothing that a particular kind of late capitalism does not touch and that I think is extremely alienating.

[00:31:10] **Tara**: So many of the new religions I talk about in my book are trying to deal with that and trying to contend with this sort of love, hate relationship of like, it's very easy to make fun of the wellness culture of goop and Gwyneth Paltrow and Soul Cycle, like they're the easiest targets in the book, I would say in some ways.

#### Corporations Seeking Authenticity

[00:31:28] **Tara**: But what are they hungering for? Authenticity, for pure food that is fresh and from a farm and maybe by the time it gets.. Like sweetgreen, it's a giant corporate chain, but the way that it kind of separates itself is that it's chalkboard says, here are the local farms that your food is coming from and we're going to update these daily and yes, you can order it through an app and customize it all you want.

[00:31:50] **Tara**: But also the buzzwords around it are purity, freshness, local. Like how the hell is this like national chain making it's branding local. Localism. There is such a hunger for.. Well, before I even make fun of sweetgreen, I love sweet green salad. So, you know, if you working in an office and you have an hour for lunch.

[00:32:11] **Tara**: Maybe you have 15 minutes for lunch, you have only enough time to go to your nearest sweet green chain, pick up something, which you've been able to order online and take it back to work. Like within those conditions, you're not going to be going to the farmer's market to like, make your own vegetable salad because you don't have the time. And I think that it would be disingenuous to mock even corporations like the sweet greens of the world without recognizing that they too are working within a system where we want authenticity, meaning connection, but can't really achieve that.

[00:32:49] **Henry**: Hmm. Yeah. I guess that's very true in the city, especially in New York, that's just normal. That's how people do things. And I also think of like, there's climate change, black lives matter, companies trying to show that they care, right?

[00:33:01] **Tara**: Absolutely. There's a study done in 2018 by Vice's corporate branding arm, which is called Virtue, which I think is hilarious. And it said something like about 54% give or take, a millennial said they want to shop for a brand that feeds their soul and 72% or so said they want to shop for brand that like expresses their values. These places don't have values. They want to make money. That's that's their value. At the same time, or maybe they have other interests, their primary job is to sell things to you.

[00:33:32] **Tara**: But there's such a hunger for which brand you choose. Do you choose a brand that affirms your values? Do you buy Goya because of, or in spite of, what its founder said positively about Trump. Do you shop from a place that has vocally supported black lives matter? These calculations are a part of how people think of themselves while shopping.

[00:33:56] **Tara**: One might say, good that these companies are.. Or let's say companies that come out and support a black lives matter. Like it is good that they are taking a stand, but like, who is they? They are not people. They are, they are sort of entities whose job it is to make money. And it may well be that they have calculated that they will get more sales from a social justice coated campaign than they will lose from people who decided that makes them "too woke". These are business decisions that we seem sort of too quick to hold up as moral decisions on the part of human agents. When they're not human agents.

#### A Complicated Life, Mediated Through Brands

[00:34:34] **Henry**: Yeah, it's just complicated and maybe reducing our identity to just the places we shop is kind of weird. I guess I'm even reminded that the good place talks about how maybe before it seemed like it was easy to make decisions where it was obvious something was good or bad based on your morals. But now it's complicated where it's like, I do something that seems to be good, but then second order effect, it's actually bad. So then you ended up just not doing anything.

[00:34:57] **Tara**: Yeah. I found that in a good place affecting cause at a certain point, how do you even act in the world? It feels like every single way that you could interact with the world is so mediated through brands, that each brand has its own kind of corporate history and ideology.

[00:35:14] **Tara**: You say, all right, I am not going to go to sweet green anymore. I'm going to go home and I'm going to make my own salads but I needed some beans, but Oh look, these Goya beans now have this political meaning. So I need to find these different beans and then you find out that the owner of a different bean company might've been, you know, accused of.. this is speculative. I'm not making any comments on owners of bean companies, but there are certainly many brands where, for example, the #metoo movement has made people wary of certain brands, affiliated with certain powerful men who have behaved badly.

[00:35:42] **Tara**: And at a certain point it's like, how does one live authentically in part by how does one divorce themselves from this kind of corporate creation of other narratives, images, stories that are so far beyond like pure use? Like you want some beans, just eat some beans and suddenly what's on the tin has all of these emotional, cultural, sociological, spiritual valences that are divorced from the actual use of beans, which are to be eaten. So yeah. How do you go back to, as you said a little while ago, doing things for their own sake?

#### Individual Change and Privilege

[00:36:25] **Henry**: Hmm. Yeah, how do we do that? How do we fight against that commercialization? I guess? I guess you didn't maybe talk about it in the book, but curious what your thoughts are.

[00:36:35] **Tara**: I don't. Well, the thing is I struggle with this because there are things that I have done in my own life to try and resist that. For example, I do make a point of, I try to shop at farmer's markets as much as possible. But the reason I'm able to do that is I work from home. So I have a very flexible schedule. My husband and I live somewhere where three days a week there's a farmer's market within five minutes walk of us.

[00:37:00] **Tara**: And there are certain economic privileges. It is a little more expensive and simultaneously, in attempting to be like, all right, I want to more ethically and more intentionally, also means like there's a certain branding too, to be like the sort of person who shops at the farmer's market.

[00:37:17] **Tara**: That is itself a kind of brand, like maybe if I hadn't told you that it would be pure in some sense. I don't know. You did ask. But yeah, you know, there is that negotiation too. I think it is true, and this is as true of actual wellness culture as it is kind of attempts at purity that they are a function of privileges of time and money.

[00:37:40] **Tara**: I was a member of boutique exercise classes at various points. And I will say that that was a very conscious choice that I made was even before the pandemic. I was like, you know what? I can't ethically justify going to expensive workout classes. I am feeding into a machine that I don't believe in and started doing things at home where I bike a lot.

[00:37:57] **Tara**: But again, those are things that. I live in an apartment. I have space in my living room. I used to live at 225 square foot studio, did not have space to like lift weights at home because you couldn't there. So I think that again, you know, you can try to divorce yourself as much as possible from institutions.

[00:38:17] **Tara**: So I guess the thing I would say is that what we would need is broader systemic, structural change. There's only so much that individual action can do. And I think maybe that a better way of framing the situation is like, how do we create a society, through voting, through advocating certain political candidates, through calling our representatives, that allows for people to not be so at the whims of a kind of capitalist branding machine.

[00:38:49] **Henry**: There's relationship between how much you're able to do things for its own sake and privilege then. You almost feel like the only reason why I can do that is because I have the privilege to do so. But then, I don't know, you're just analyzing everything and then it gets overwhelming. I don't even, you just give up, you're like, okay, I'm done.

[00:39:05] **Tara**: I mean, I sometimes I feel that way too. I think I feel that way a lot of the time. I don't know, the good place posits that life has become more complicated. I don't know if that is true, perhaps it was always this way and it just more visible in a way.

#### What Is Our Freedom For?

[00:39:19] **Tara**: But I think it is through that, a question we have not satisfactorily, culturally answered is like. In a world where many of us have so much more free time. We are not subsistence farming. And yet that itself is sort of predicated on the fact that there are subsistence farming. It is sort of an illusion that we all globally have tons more free time.

[00:39:42] **Tara**: But I think that the sort the prevalence of those who have a lot of free time, let's say, it means like, what do we do with it? What do we do with our freedom? What do we do with these hours in the day? This is something that's becoming even more visible as a question in pandemic time. When many people, so many specifically nonessential workers or workers who can work from home, let's say, are going like, what do I do with all of these hours? And this is kind of so tied into questions of capitalism even beforehand, which is like if you are one of the privileged people to be able to live in the networked world and work remotely, so on and so forth.

[00:40:23] **Tara**: You start to think, what is it all for? What is time for like, we're supposed to spend this like getting food, you know, if there's an evolutionary sort of model of us as just merely animals, we're not supposed to be doing all this stuff, we're not supposed to be free in this way.

[00:40:38] **Tara**: And then from a Christian perspective, I've been thinking about this a lot. Like what is free time, which is also freedom. What is it for? Are we supposed to be spending this all in contemplation and prayer? That seems like that's kind of the philosophical tradition of our answers. It's the contemplation of God, that's what we should be doing. How do we do that? I'm being a bit flippant here, but I do think that question is that so much at the heart of many of capitalism's uncertainties, is this consciousness and I think that's the hunger you get in this book. It's like, what is it for? And again, that is a question born of a certain privilege to have that time, but it is a sort of feature of those who whom capitalism has allowed that time.

[00:41:21] **Henry**: Yeah. It's like the concept of negative and positive freedom, right. We usually think freedom allows us to do whatever we want, but it's so funny that during this time of the pandemic, when people say they have free time, they don't know what they want anymore. And so maybe we never really knew, we're just so busy. My old roommate just randomly messaged me and he was like, Hey, I've been thinking about heaven. I was like, Whoa, okay, out of nowhere. And I was like, Oh, because of the pandemic. And he was saying, what is the point of all this? Why am I here for? I was like, wow, so it's true for all of us. And I think that question of for, even as Christians, we kind of forgot we're doing this for a certain reason that we have reasons for it, right.

#### Where's a Theology of the Internet?

[00:41:56] **Tara**: Yeah, absolutely. I think that's something that we need to get back to and have a conversation about. I would love to see more Christian conversations about the theology of the internet, the theology of this age, sort of Charles Taylor plus however many years.

[00:42:12] **Tara**: But I think that these are conversations, often Christian discourse, I have found, unfortunately does seem to be along culture war lines and particularly more that questions of certain political shibboleths, but would love there to be more robust Christian theological discussion about like, sacraments and the internet, or how we think about branding and leisure.

[00:42:35] **Tara**: And these are questions that I think sometimes get lost, in part, because in this brand siloed tribalist media landscape where we're also fractured, there have been these kind of branded alliances for reactionary kind of what I call pagan atavists and right traditionalist because they're fighting together to own the "social justice" which is how they would often a treat that alliance. I mean, I think there's certainly versions of that, you know, on the left as well.

[00:43:07] **Tara**: And I think that these kinds of culture, war online conversations, which are themselves ways of kind of self identity and framing and self branding. Are you here or are you there, what magazines do you read or subscribe to? What thinkers do you like and dislike? The kind of branding impulse makes categories kind of reductionist, and I'd be very interested in a kind of Christian discourse that didn't position itself on like, what do you think about those people on Twitter?

[00:43:43] **Tara**: And to be clear, I'm very glad that my church is extremely social justice focused in a particular way. I believe that my church very much sees that in the context of its Christian mission and that sort of being sort of actively anti-racist as part of the gospels But that said, there's a difference between kind of acting in a certain way and positioning yourself as like, we're this church, we're this brand and come here if you want this kind of church and go there if you want that kind of church and sort of turning itself into a kind of church shopping or alliance with sort of secular shibboleths. And that's something that I'm more wary of.

#### On Bad Traditionalism: Choice, Will to Power, EvoPsych

[00:44:24] **Henry**: So, is that what you mean by bad traditionalism?

[00:44:27] **Tara**: When I talk about bad traditionalism in my piece of Commonweal, I don't mean all traditionalism. I don't actually even mean pure conservatives, conservative Christianity. I think that there are certainly people that I know that have more conservative views than I do. Who are Christians, who I absolutely do not think fall into this.

[00:44:45] **Tara**: What I see as bad traditionalism is a kind of alliance between Christian traditionalists who want to win the culture war and the kind of people I describe in my book as reactionary. Jordan Peterson being the first and most middle of the road example. But then the sort of like Deus vult, Which way, western man? meme posting crowd where Christian ideas of natural law are kind of perverted into evo psych tinged, survival of the fittest.

[00:45:15] **Tara**: I think that this manifests itself specifically in the idea that there's a sort of innate hierarchy and innate distinctions among people. And I grant that, this is again, a bit reductionist, but men and women are evolutionarily different and different groups of people are evolutionary different. And that is why the neoliberal queers are destroying America. And that is sort of roughly the rhetoric.

[00:45:36] **Tara**: And it's something where I think that there's a focus on gender and sexuality, particularly as this kind of a flash point for these discussions. Because it becomes these, usually queer or gender nonconforming, aren't acting according to how their biology quote, unquote should. And they're doing that because they think that their choices are more important than like nature. And because we don't like liberal capitalism's focus on choice, we see these people as exercising choice in a way that is divorced from nature as bad, perverse, and like a sign of the times.

[00:46:16] **Tara**: And often I would argue what that mentality does is confuse kind of very arbitrary, themselves socially coded, gender roles. Often like very 1950s-y, you know, the man's the provider and the woman wears skirts and has like lots of bread. And these are often very white family images in terms of the memes that are posted, like blonde woman in a field with her five grandchildren.

[00:46:42] **Tara**: And that basically is an alliance that I think of as dangerous. Not because I think marriage is bad, or family is bad, or any Christian who has a more conservative view of sexuality than I do is bad. But because I think that a Christian understanding of the importance of understanding our facticity, our givenness, who we as shaped by our communities in relation to other people, with this very like masculinist to version of like the will to power and natural law misunderstood as something that puts the strong over the weak, which is very much not what's in the gospels.

[00:47:28] **Tara**: And what I want to preserve in my critique of that is that for me, Christianity is about the confusion of hierarchies, the subversion of binaries. There's plenty of medieval literature that describes Christ as a mother. That we, you know, suck the breasts of the mother Christ. There is the whole beatitudes, the veneration of the meek and the poor.

[00:47:52] **Tara**: And I think the danger that what I call bad traditionalism falls into. It's not that I'm personally offended by the wearing of skirts, but rather that in order to win the culture wars, they're so focused on stamping out and specifically in seeing liberal choiciness gender things that don't conform to a certain model, that they're willing to basically make a kind of Nietzschean Christianity. And what I think is really worth pointing out here is that if you look at Nietzsche's criticisms of Christianity. Yeah the weak victim, obsessed with being victims, they just want to be oppressed. The kind of right-wing atavist critique of social justice culture.

[00:48:38] **Tara**: Like I want to do a Buzzfeed quiz, who said it, Nietzschean Christians or some men's rights activist on SJWs. And again, how they would call SJW, being a word they would use that as often not the preferred word by those in the movement, but the rhetoric is very, very similar.

#### On Valid Criticisms and First Principles

[00:48:53] **Tara**: And I think it is certainly possible to have many criticisms of the social justice movement. It is possible to have those criticisms as a Christian to ask. One could criticize, for example, a focus on inward purification that is too individualistic. One could talk you know, so many things, but I think that is bad faith to do this kind of like, well let's own those wokes by being hardcore Christians in a way that gives up some of the most important tents of the faith.

[00:49:22] **Henry**: Yeah, I guess that speaks to your book in general, of acknowledging where people can be right. Or at least pointing out issues, if they don't have the right solutions.

[00:49:32] **Tara**: Yeah, I think that's true. I mean I think there's a difference between sort of fair, thoughtful criticism. And this is something that applies to any group I might be talking about here. And kind of a sort of identity politic, writ much more broadly in like I'm a member of this political Twitter faction. I just want to own the other faction. No matter how and make them a strawman and mock their positions. And I think that's something that is dangerous. I think that in order to understand either, whether we're talking about the atavists or we're talking about the social justice culture.

[00:50:06] **Tara**: It's important to be like, alright, what are the first principles we're working with? You know, if we were actually understanding them as religions, we'd say like, what's the sense of meaning? What's the sense of purpose? Where is evil located? And we would think seriously about parts of what we're seeing are coming from a sort of primordial, first principle place.

[00:50:24] **Tara**: And I think having those conversations and being like, well, what is their notion of the good? What is their notion of the evil? Asking these questions and having debates about that is much more useful than being like, well, this sounds dumb.

#### On Neutral Epistemology, Polanyi's Personal Knowledge

[00:50:39] **Tara**: For example, I think as I wrote in this piece for Comment, having questions about, is a neutral epistemology in this sort of liberal sense possible? Is a question that takes a lot of the language of lived experience, for example, which often can be more easily dismissed by those who are unsympathetic to it and been alright, what are we actually talking about? Is there such a thing as objective, disembodied knowledge, let's sort of work on this question a bit and then we can move on to like the specifics.

[00:51:12] **Henry**: Yeah. On that particular note, I discovered this philosopher called Michael Polanyi. I don't know if you've heard of him before, but I feel like he's speaks to this directly in a way. He wrote this book, Personal Knowledge, and the subtitle's, post-critical philosophy. And critical meaning modernism. To me he was saying that modernism is about objectivity because of scientific method and technology. And postmodernism is admitting that we can't have truth. So he was trying to figure out how can we say that there is objective truth, but also acknowledge that individually, we see things from a certain perspective. And you can't necessarily be neutral because we all live in our own little world, essentially. He wasn't like a Christian, but he brought up Christianity a lot, in terms of thinking about how everything we do is an act of trust, act of faith, not necessarily in God, but he was pointing to that. That's how I kinda got into this epistemology stuff. You brought up in your article, Imago Dei and incarnation, right.

#### Embodied Knowledge, Embodied Hope

[00:52:09] **Henry**: That was reminding me that in Christianity, we do think that the body is important because we are embodied. God became a person and he even resurrected. And so it shows that knowledge should be contained within people. And then Jesus is the Word, right.

[00:52:24] **Tara**: Absolutely. I think that's where my understanding comes from, which is to say I think that a faith were God became man, and where the sort of particularity of the incarnation is at the heart of kind of how we understand the world. How could we not see knowledge as embodied and contingent within that incarnational framework? And I think that's sort of a point where the quote unquote bad trads, miss out on that, or else reduce it to a kind of embodiment that is reduced to almost evo psyche gloss on that understanding.

[00:53:05] **Henry**: Yeah. I never really thought about that word, particularity and situatedness, it makes so much more sense now. We had this idea that there are facts out there, right. And it has nothing to do with people. Knowledge is disembodied. Form doesn't matter. If you don't have any sort of liturgy or you reduce it all down, that's just medium is the message again, right? And I guess we're saying that through these practices that shape our loves, Augustine, it does change us to that common good, right?

#### Institutions Being Intuitional, "Be a Good Person"

[00:53:32] **Henry**: I guess one other thing I was gonna bring up. How are ways that institutions, or the Church has tried to be intuitional itself? Cause one thing I see is, it's failing in the sense of how we have like seeker friendly churches? And that has good intentions. We want to get more people in, you know? But we kind of do the whole, let's turn worship into a concert because people like that stuff. And then we then we'll like do a bait and switch and be like, hey let's talk about God.

[00:53:55] **Tara**: absolutely. The sort of Hillsongy model. That is I think very much falling into church as consumption in a way that I think is dangerous. Though there's a sort of other kind of intuitionalism that I think is just as prevalent. Some sort of more conservative thinkers have called it moral therapeutic deism.

[00:54:13] **Tara**: And I think that's actually fair, that there's a sort of version of Christianity, worship, or Christian churches that basically were like, it's about community. So like, believe what you want. It doesn't really matter, like, be a good person.

[00:54:25] **Tara**: I mean, I remember, Christmas Eve service at a church I no longer attend. I went and the rector was giving a sermon about poverty, but in this very like, Oh my God, did you know, there were poor people in New York way. It's not a very good sermon. And he said, I had to take the subway from Queens and he said, well, I don't want to make you uncomfortable.I know, I know, like we shouldn't be uncomfortable in church. And he was saying like, okay, but I'll make you a little uncomfortable. No, no, you should be uncomfortable in church. Like what do you mean we shouldn't be uncomfortable in church, excuse me? And I think that that sort of desire to kind of make..

[00:54:56] **Tara**: I think everyone should feel welcome in. Sure, absolutely. But I think that a sort of unwillingness to put forward the more uncomfortable as I've said before, the weird aspects of our faith. Be it. Yeah, that dude who died, he came back like not metaphorically, not in a like, Oh, everyone comes back because no, one's really dead if you love them.

[00:55:19] **Tara**: Wait, no, no, he was dead, then he wasn't way or that bit about the rich man and the eye of the needle. Yep. Yep. Don't be rich. Don't don't do that. Don't do the rich thing. Both of those things are things we need to be strong on, I think. Again to go back to where we were at the start of the conversation, once you water that down, it's like, well, why go to church? If you're just telling me like, be a good give money to homeless people sometimes, and like, don't kill anyone. And maybe, you know, I could just do a meditation app. And get the same quote unquote result.

#### Beneficial Participation

[00:55:53] **Henry**: Yeah, I guess it does come back down to that consumerism question of, what does this give for me? And then turning that into, what does this ask of me? And I think that's not happening, right? I guess that's where we move on to the idea of participation.

[00:56:07] **Tara**: But then I guess to extreme level ,participation leads to like agency and freedom, and putting your identity on yourself is very burdensome. Right. And then feeling like you have to be good and then you feel guilty about it and all that. How do we make participation more like meaningful and actually good for everyone. I think that's the question.

[00:56:28] **Tara**: Yeah, you want to make sure everyone is welcome, but at the same time, I think just being willing to, you know, say things from the pulpit and be very clear what churches stand for. And even if that's sort of political. I don't think churches should be apolitical and even as I decry a certain kind of jingoism that I see in the churches of the white evangelical right, I don't think that the solution to that is that churches shouldn't talk about politics. We are political creatures seeking a common good. that means taking stances on how we live as human beings in the world.

[00:57:06] **Tara**: Doesn't mean be a policy wonk for the pulpit, but pretending that the church is a separate space from the world. I think means that the Church is ceding its moral authority to speak out on issues that affect human beings in community together, because what is a church and what is a polity, but human beings living and acting together. Those things are not only sort of separate in theory.

[00:57:32] **Henry**: Right, so that's the separation of church and state.

[00:57:35] **Tara**: Oh gosh, did I just meme myself into arguing against the separation of church and state? And on that note. Well, I'm not an integralist. Let's just leave that there. I'm not an integralist. However, I do believe in a common good, and I believe a good faith pursuit of the common good is something that should be born out politically and not just in like think tanks or in sermons.

#### A Vision of the Common Good

[00:58:00] **Henry**: Looking forward, what does that look like, the common good?

[00:58:02] **Tara**: I obviously have a leftist perspective on this. But I think that a society that is set up to first of all ensure that people have what they need in terms of food, in terms of shelter, in terms of time, such that they are taken care of one another, whether that means, accessible daycare options for childcare, whether that ensuring public schools that are well-funded and good that all people go to.

[00:58:32] **Tara**: And we don't have a kind of separation between people who can afford to opt out of our civic institutions. A world in which, we don't have food deserts on where people can afford and access the time that they do have. Healthy food and enough food, and then are able to go to work. That there is an infrastructure that allows them to do so, so that we don't have going on a three hour multi bus commute you know, the parts of the Bronx that are poorly served by public transport to Midtown.

[00:59:03] **Tara**: I think a society that has a infrastructure designed towards maximizing everyone's ability to participate fully. And if that comes at the expense of the wealthy, which is to say, if that means I pay really. I mean, I'm a writer, but if I'm able to shop at farmer's markets, I should be paying a fuck ton in taxes, and I'm very happy to do that. That's sort of where I'm at, an extremely politically progressive vision or leftist vision, a society that might work like that. But I recognize that there might be other ways of achieving that that I haven't thought of.

#### We Are As Gods

[00:59:41] **Henry**: I'm just thinking even of my industry in tech. If they agree that it's not enough to get individuals to change themselves, the system needs to change. Then that's where like technology comes in. We'll say we need to create tech that will help us produce more food or algorithms that decide all these things, and robots will figure that out for us.

[01:00:01] **Tara**: I mean, I get the sense of the tech world is sort of much more libertarian, by and large than I am. But I think I'm certainly open to and interested in ways that technology might help us create the sort of the society that I want to see. And I don't think that those two things necessarily need to be at odds.

[01:00:22] **Tara**: I think my weariness, and I've written about this in is Strange Rites, of the kind of the industry more broadly is a kind of a focus, perhaps a valorization of a certain kind of human freedom on the part of a certain kind of smart person, that I think can be blinding.

[01:00:43] **Tara**: But I also think that sort of tech revolutions may allow us to kind of, when paired with a concern for one another, create a more functional society. Like I said, my intuitions, are pretty leftist, but I'm also it works, if more people are getting fed, then great. And I'm kind of open to updating on that.

[01:01:07] **Henry**: Yeah, I guess I've been thinking about how technology and technique leads to this feeling of wanting to control everything. I was reading from Michael Sacasas and he was writing about parenting. And how one way of looking at it is being a carpenter where you see the child like this object, right. To make them efficient, like a machine. And the other is like a gardener. And I think the analogy is interesting, cause we talked about this in terms of relationships with God, with evangelism. Right. We can't really control., We can't make them believe things or change them, but we can create an environment.

[01:01:40] **Henry**: With technology, if everything is an object, then we can do something to it. There's this thing called the Whole Earth Catalog and the first thing in it says "we are as gods and might as well get good at it." And this happened before the internet, and influenced Steve jobs. There's this term called cybernetics about like loops and feedback. I think that speaks to a lot of like how we want to change the world.

[01:02:03] **Tara**: Interesting. Generally, I think when we talk about ourselves as god's, my hackles get up. I think there might have been something in Genesis about that, that we avoid. But I think potential philosophy aside, one of the things that I think is an interesting point that comes up.

#### End: Again, what do we do with our freedom?

[01:02:18] **Tara**: I imagine certainly in the tech industry, but more broadly is, what do we do with our freedom? I think that is sort of the biggest question of 2020. And it's something that I'm continuing to be interested in exploring. How do we, in an era where human creative powers are so visible, where we are more and more divorced from givenness, facticity, and Nature, how do we manage that? And I think those are really at the heart of the questions of Strange Rites, hopefully the heart of the questions that I'm going to continue to work on.

[01:02:51] **Henry**: Yeah. We're in this whole you do you thing where some of our thoughts are like, we want you to be like this, but at the same time, we don't really want to impose anything on people. Cause we don't want to claim the common ground. I think that's a good place to end.

[01:03:06] **Tara**: This was fantastic. I really enjoyed it.
