---
title: "Natural Limits (Michael Sacasas)"
season: 3
date: "2020-10-12"
time: "30"
description: "Can we consider limits as a gift? Michael Sacasas and Henry discuss an understated concept in our modern times, namely limited nature as creatures in the context of parenting, social media, and health. We pass through a mix of (sometimes heavy) topics: violent games and virtue ethics, parents as gardeners rather than carpenters, the issues of unprecedented scale, modernity as the application of technique, our inclination to believe more is better, and the art of dying."
episodeLink: "1c4ba146"
embedUrl: https://share.transistor.fm/e/be085bf0
sidebar:
    order: 7
---

### Links

- Michael's [Twitter](https://twitter.com/lmsacasas)
- Michael's Newsletter: [The Convivial Society](https://theconvivialsociety.substack.com/about?utm_source=menu-dropdown)
- Newsletter: [Fortnite and the Good Life](https://theconvivialsociety.substack.com/p/the-convivial-society-no-15)
- Newsletter: [Children and Technology](https://theconvivialsociety.substack.com/p/children-and-technology)
- Newsletter: [Care, Friendship, Hospitality](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections)
- Video version on [Youtube](https://www.youtube.com/watch?v=fojoWc1oCeQ)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/limits.md)

[00:00] **Henry**: So I have with me, [Michael Sacasas](https://thefrailestthing.com). He's been writing about philosophy of technology and ethics for over 10 years, right. And right now you have a newsletter, [The Convivial Society](https://theconvivialsociety.substack.com).

#### Games and Virtue

[00:12] **Henry**: But the thing that caught my attention was when you wrote [Fortnite and the Good Life](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life).

> "Naturally, then, such public debates, and consequently are own habits of moral reasoning, get locked into matters of measurable—which is to say supposedly objective, scientifically verifiable—harm." - [Michael](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life)

[00:16] **Michael**: As I said in that little newsletter, gaming is not my beat. So I wrote that with a little bit of trepidation, making a very specific point, but yeah.

> "I'm not entirely sure what my beat is, but it's not gaming" - [Michael](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life)

[00:24] **Henry**: Maybe a common view of gaming, especially for people that don't necessarily play games, is something like: a lot of video games are violent and that's not good for you, so video games are bad. And it's very like a simple view of gaming, right?

> "When parents and other concerned adults—recall Hillary Clinton's mid-2000s criticism of Grand Theft Auto—worry about games they are usually worried about violent or sexualized content."

[00:40] **Henry**: But I guess you were trying to get across the point that maybe "Fortnite is bad" isn't really what you should be thinking. But rather the opposite question of: is Fortnite not just good, but does it promote a certain type of character in people when they're playing?

> "So, I'd suggest re-framing the question. "Will playing Fortnite cause my child (or me) quantifiable harm?" is not the only question we should be asking. Given what is usually meant by that question, the answer is almost always "no." But, in addition to that question, we might also ask how playing Fortnite figures into our pursuit of the good life, individually and as members of distinct moral communities." - [Michael](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life)

[00:53] **Michael**: Right. So that was generally the idea, right. That instead of focusing..

[00:57] **Michael**: So I'm of the age where when I was gaming, Super Nintendo was the platform that was really popular, and Mortal Kombat had just come out. A lot of the same type of stuff was in the air about Mortal Kombat. it's violence, how graphic it was. And, you know, I played a good bit of it with my friends at the time. I never really felt tempted by violence.

[01:16] **Michael**: So I kind of get that idea that there's a tenuous connection here, and know there's a good bit of debate in the literature about whether there's any kind of causal relationship or not. But right, whether that can be established or not.

[01:29] **Michael**: My default here is to kind of think about these things through a kind of virtue ethic lens. We're kind of asking the question constantly, right? Not as is this one thing right or wrong necessarily, although that's an important question to ask, but what kind of person am I becoming? What kind of habits am I inculcating? What will those habits make of me in the long run?

> "(I don't know that I've made my assumptions on these matters explicit in writing anywhere, but much of what I do write about technology tends to draw on the tradition of virtue ethics. The idea is simple: we are always becoming who we will be and that becoming is correlated to our practices and the technologies or material realities that sustain them.)" - [Michael](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life)

[01:49] **Michael**: And then we're also sort of asking, not just am I avoiding bad things, but am I pursuing good things, virtuous things. So that's a frame that doesn't offer a simplistic answer. You don't just sort of insert Fortnite into that and come out with a yes, play it; no, don't play it, kind of response, right.

[02:07] **Michael**: But I think it helps fill out.. give more thickness to the moral reflection that might be involved, right. So it complicates it and highlights some ways about thinking about the problem, which are not, you know, again, easily reducible to a set of rules: just play for 20 minutes a day and you'll be okay.

> "..with regards to both gaming and other forms of technology, I'm chiefly struck by the limited scope of our moral reasoning. As with so many discussions about the moral or ethical status of technology, we are focused on questions of harm Indeed, we might even say that we are focused on questions of measurable harm. In this way, debates of this sort already play out on ground circumscribed by a certain technocratic vision."

#### Social Gaming

[02:21] **Henry**: Yeah, I think I appreciate that sort of thinking where gaming has become so important in our culture.

[02:28] **Henry**: Actually, this is something I was talking about with my friend the other day. From the programmer point of view, if you're the quote unquote expert, when you see how people use your software, one obvious reaction is like, Oh, they're doing it wrong. I should prevent them from doing that in the first place.

[02:44] **Henry**: One example is how on your desktop, you have all these icons, right? You can drag them around. And some people have a very specific layout for where all their icons are. Some people might be like, well, why don't you just use alphabetical order? Or why don't you just have no icons? There's something important about an attitude of understanding, what leads someone to do a certain behavior? Instead of saying, Oh, gaming is bad, why is that happening?

[03:08] **Michael**: Yeah. And even sort of what desires is it fulfilling? What role is it playing in a social life? One of the interesting dynamics about gaming today is the kind of sociality that it inculcates.. I was about to say that it has a social dimension, but I corrected myself because when I played with my friends, it had a social dimension.

> "Let us quickly acknowledge that playing Fortnite is not a disembodied experience." - [Michael](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life)

[03:24] **Michael**: You know, we were all there in a room playing together and it was a kind of artifact around which a certain kind of social interaction formed.

[03:31] **Michael**: Now that social interaction is happening in a different mode and a different shape. And I think asking the question, what are the outcomes of this? What are the differences? And paying close attention to, as you say, how this is being used, I think is always important.

> "We're left needing to pay close attention to how playing Fornite is a differently embodied experience than gathering at the mall or attending a church service or dropping in at a cocktail party, and then determining the significance of that difference." - [Michael](https://tinyletter.com/lmsacasas/letters/the-convivial-society-no-15-fortnite-and-the-good-life)

[03:46] **Henry**: There was a trend of like this idea of couch play. Oh, actually before that would have been like arcades, right? And that was a certain experience where you had to go somewhere and actually a place to meet people. And eventually, we had home consoles where you would have LAN parties where you bring your computers. That was a communal experience.

[04:03] **Henry**: And eventually we had the internet. Everyone has their own console. You don't have to go to everyone's house. And now we have quarantine where like, even more so right? You are together, but in some sense you're not together.

[04:14] **Henry**: Another point, there's been a resurgence in board games too, at least in the Western sphere. _Catan_ is super big. And that's replaced video games with board games.

[04:26] **Michael**: Right. The first trajectory outlined from the arcade, to the home with others, to being in the home, sort of physically isolated, but still connected online. Yeah, exploring what are the ramifications of those different modes of sociality, I think are valuable.

[04:42] **Michael**: And yeah, you know, that's funny. I have Catan on my shelf somewhere. It's been a little while now where we played with friends, before kids, as you know, people may age want to say.

[04:49] **Michael**: So that space and that kind of activity reverts to an analog medium, in that context. Yeah. I don't have any more thoughts on that at the moment, except maybe to connect with the trend towards vinyl records as a medium of choice for some people. Just interesting ways in which, you know, analog kind of reappears, yeah.

#### Gardeners and Carpenters

> Newsletter: ["Children and Technology"](https://theconvivialsociety.substack.com/p/children-and-technology)

[05:07] **Henry**: Yeah. You brought up kids. I think you had an interesting [post](https://theconvivialsociety.substack.com/p/children-and-technology) recently about your thoughts as a parent. So I went home for a while, so I got to live with my parents for a few months. And I was just thinking about how they're still gonna treat you like a kid, even though you're an adult. And I even showed them the article. I really appreciated the metaphor of the carpenter and the gardener.

[05:29] **Henry**: I think it speaks a lot to the idea of relationship. Going back to a video game analogy, is treating people like they're NPCs in a game where they have this set, rote thing, where if you say X and they say Y.

[05:40] **Michael**: Right. Alison Gopnik wrote a book kind of developing that metaphor, and it struck me as a useful one. Because yeah, the difference is whether you see your child as something that you can fabricate, essentially to design in whatever shape or form you want them to come out as. And that's sort of the carpenter model where you have a piece of raw material and then you just apply your carpeting, you know, your parenting tools in this case. And out comes this product in the shape that you desire.

> "In the carpenter model, parents tend to view raising children as an engineering problem in which the trick is to apply the right techniques in order to achieve the optimal results. In this view, “parenting” is something you do. It is work." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[06:08] **Michael**: But the gardening metaphor suggests that you don't have that kind of power over the object, right, in this case, the child. If you're tending watermelon seeds, the watermelon seeds are going to become watermelon, right? You can't make them be tomatoes.

> "The focus isn’t on “parenting” as an activity, but on being a parent as a relationship structured by love." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[06:22] **Michael**: So there's a limit to your ability to generate the product that you desire here. Even using that language, I think, betrays the temptation. And so understanding that, you know, you can care for and provide an environment conducive to their flourishing, speaking of children now, just as you would for a plant. That's a very different kind of way of thinking about the child.

[06:43] **Michael**: It goes back to the division that's really fundamental. I think we talked about this last time we talked. This fundamental sort of division between what you receive as a gift and what you only experience as something that you made, that you control, that you master. That divide, I think, runs through those two kinds of modes of parenting as well. Yeah.

> "Of course, any discussion that starts with “There are two kinds of x” will undoubtedly have its limitations, but I think it’s useful to remember that we do not make our children, we receive them as gifts." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

#### Technocratic Parenting

[07:07] **Henry**: I think that relates a lot to the views of Illich, we're talking about treating people as commodities. In our computer age, you know, we like to think of everything as a machine.

[07:17] **Michael**: Yeah. And I will say that sort of machine metaphor goes back much further. There's a rather well known French text from the 1700s called [Man as Machine](https://en.wikipedia.org/wiki/Man_a_Machine). And that metaphor is persistent to today and, you know, sort of changed in some respects under the old days we might have called cybernetic conditions.

> "The human body is a machine which winds its own springs." - [Man a Machine](http://bactra.org/LaMettrie/Machine/)

[07:35] **Michael**: That's one of the subtle ways in which our material environment kind of shapes how we think about ourselves and society. It's not by the direct effect of the tools necessarily. But it's what happens when they become metaphors from the human person for how society works, and then they become very powerful because these metaphors shape our imagination, our way of perceiving reality, or even of perceiving our own selves.

[07:58] **Michael**: So I think I actually took a little detour there. So what did you ask initially there in that?

[08:03] **Henry**: I think we can just go with that. I was thinking of that phrase, was it, ["We shape our tools, and our tools shape us"](https://quoteinvestigator.com/2016/06/26/shape)?

[08:09] **Michael**: Right, some variation. And that happens then through our use of those tools, which is perhaps the most obvious ways in which that happens. So then what I'm suggesting is that it may happen in even more subtle ways when the tools become metaphors.

[08:21] **Michael**: And to go back to the parenting question, right? So I wrote that newsletter in part, because, you know, as I mentioned in there, I get asked this question a lot and for a while, I didn't like to answer it because I didn't have kids. And, and I thought, well, you know, I'm not about to lecture parents about something I have very little experience with, or no experience with. But I felt a little bit of liberty now that I've got two of my own.

> "Having now been a parent for nearly five years... of course, the questions have also taken on a more personal and urgent quality." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[08:41] **Michael**: But often what people want to know are very straightforward things. This goes back to the gaming question, even right. Just should I do it or not? You know, should I ban this game from my child's life? If I let them play, how many hours a day do I let them play right.

> "“Too much” implies a relative standard. Relative to what, then? Is there also “too little”? What would “just right” look like? I don’t believe it’s possible to answer those questions, or questions like them, in the abstract." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[08:54] **Michael**: They're all very sort of pragmatic, rule oriented questions. And that's fine. You know, I understand the need for practical considerations of that sort.

[09:04] **Michael**: But the deeper stuff is often going on at another level and another dimension. So when we think about children and technology, the screen time question now really dominates that discourse.

[09:16] **Michael**: So what I tried to do in the newsletter is start at a much different place, which is to say that technology as a kind of metaphor that underlies our thinking about human beings and how we become the sorts of people that we are, that's already sort of operating at the level of how we even conceive of the task of parenting, right. Apart from whatever individual choices or specific choices we make about this, that, or the other device in our child's life.

[09:43] **Michael**: Are we approaching the task of raising children from a technocratic mindset, right. From a technocratic frame. And so that's a level at which I think, you know, most parents aren't often thinking, but I think it's an important one as well.

#### Capability and Responsibility

[09:57] **Henry**: Right. We care so much about the content, before people are like, don't read Harry Potter, that kind of thing.

[10:04] **Henry**: We're afraid of exposing people to different things because it's going to change them. And I actually had the same fear. Me being a parent to my own parents. In the sense of a lot of these, conspiracy theory type things, right. Especially because of social media.

[10:23] **Henry**: So in that case, I'm basically being the same person. I'm trying to be the controlling person. Don't watch this. Don't look at this sort of thing. And I have to learn to let go. Well, they're going to do it anyway, if I tell them, right. And it's like, how do I really engage in that?

[10:37] **Michael**: Yeah. That is interesting. And the impulse in cases like that is to make that very bright line, right. Just don't watch this, right. Don't look at this. And I think there's a place for that, you know, especially with young children. A lot of it I think comes down to this question of responsibility and capability, right?

[10:56] **Michael**: What are young children capable of processing? And again, note the technological metaphor there for an essentially emotional work. So with older parents, obviously it's different to some degree, you know, they're not children per se, right. Although, I mean, I don't know here, I feel like, ugh, it's hard to even talk about this in a generic abstract way. Every case is different, but all that to say that, yeah, I see the similarity there.

[11:21] **Michael**: And ideally you want to, at least the way I think about, it is to help them mature into the kind of person that can wisely adjudicate these questions of what is good. How should I spend my time?

> "Infants and toddlers won’t be able to deliberate about such matters with you, but my sense is that the sooner you’re able to bring children into some meaningful conversation about this kind of thing the better. Invite them to pursue the good and teach them by example to subject their use of any tool or device to that higher end." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[11:33] **Michael**: To be able to encounter material that we don't just have to say is taboo, but we can say here are some of the issues with it and allow them to think responsibly through that. And that's obviously, you know, it has its own challenges.

[11:48] **Michael**: And then there's a question about whether that kind of approach is adequate in the conditions of digital media, right? Where there is just this overwhelming flood of information. We're just sort of swimming in it. It's disorienting.

> "To whatever degree the use of a certain technology amounts to participation in a liturgy of endless consumption, I would think twice about adopting it. This one is tough, I admit." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[12:02] **Michael**: So yeah, these are challenging questions, both for the child and as you say even maybe for older adults, who are to some degree, apparently quite susceptible to some of the more prominent kinds of conspiracy theorizing that's capturing our political sphere.

[12:18] **Henry**: Yeah, I guess it's a problem for all of us, I guess, because none of us have really figured out how to manage our attention and just what is going on. You've talked about this a lot, this impulse to want to be online and for me, even to be informed and to say something. And not being able to step away from it all, especially now, right? Yeah.

[12:45] **Michael**: Right. And I'm glad you made that point right, because I'm here talking about young children and adults, as if they are the ones with the problems, right. But no that's absolutely right. All of this.. As a human being you're in this world. At different stages of life, maybe the challenge presents itself differently, right. But we all struggle with this in one way, shape, or form.

> "Consequently, I hope to both demonstrate and convey to my own children a way of being with technology which resists the temptations of a self-defeating pursuit of limitlessness and a willingness to receive time as a gift rather than an enemy to be defeated." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

#### Natural Scales and Limits

> Newsletter: [Care, Friendship, Hospitality](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections)

[13:03] **Michael**: And the connection to Ilich, just to kind of sneak him in at the moment. I think, you know, Illich was preoccupied, especially, through the seventies with the question of [limits](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections) and scale and threshold, right.

[13:14] **Michael**: And I think this is really an essential point. It's one that I think is critical, the question of scale. Where the approach that you might take to consider the information ecosystem, Right? So in a pre-modern setting without the printing press site, right.

[13:30] **Michael**: You're likely to encounter, you know, very discrete amounts of textual information, right. Or coded information, right. You encounter information all the time in reading, you know, where the wind is blowing or the cloud formations to determine whether it's going to rain right there. We live in an information rich environment.

[13:47] **Michael**: And so even in a pre-modern context, right. You're deciphering information of a sort. But thinking about kind of symbolic, human made information that's encoded in some way, shape or form in alphabetic symbols. And so a simple book is a precious commodity, right? Most people wouldn't necessarily even own a single book.

[14:08] **Michael**: Yet then when you enter into the modern age and the printing press makes the printed word much more widely available, there are all sorts of complaints from the era that sound very familiar to us because they're essentially about what we think of as information overload, right? An overabundance of books, an overabundance of information, much of it being of little value. It overwhelms people's ability to make sense of their world.

[14:34] **Michael**: And that all makes a fair amount of sense given where you've been and where you are now. And so we then develop a certain set of literacy skills, that help us cope with that information environment.

[14:48] **Michael**: But it's essentially a function of scale that's what's made the difference at that juncture. And so here we've entered then into another ratcheting up of the scale at which we encounter media information.

[15:01] **Michael**: Because then the advice that people give is, well, you just need to develop a new set of tools, right. A new set of cognitive tools. And I suppose at one level you have to at least make that effort, of course.

#### Two Thresholds, Accelerating Harms

[15:10] **Michael**: But there is a question of whether you've not passed through a certain threshold, right. So, you know, Illich talks about how there are these two thresholds in medicine, for example. He begins [Tools for Conviviality](https://en.wikipedia.org/wiki/Tools_for_Conviviality) with this.

> "... opens with a discussion of what Illich called “two watersheds” in medicine" - [Michael](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections)

[15:23] **Michael**: Where through the first threshold, you have genuine gains in the ability to care for people, to improve people's general health. And what happens at those moments can be relatively simple. It's learning how important clean drinking water is. Or being able to treat some basic infections.

[15:40] **Michael**: But then there's another threshold where the institution of medicine, when it kind of becomes institutionalized, begins now to reverse its gains in some respects, right.

[15:51] **Michael**: And this is contested territory. I think a lot of people would have various opinions about how we think about these gains, right. But for Illich the prospects, for example, of having his life extended by a couple of years, but at the great cost to his quality of life or to his mobility or to his ability to be with friends and family. To be sort of, as we sometimes say, kind of "hooked up to a machine" just for a few more months of life. To him, that was an anathema.

> ".. I do not think any weighing-up of risks entered into Illich's thinking. Indeed, he believed that the ever-growing emphasis on risk calculation in medicine constitues the ultimate disembodiment, because it invites people to think of thmselves not as unique persons but as members of an abstract class for which probilities can be calculated." - [Rivers North of the Future, pg 39](https://www.goodreads.com/book/show/253075.The_Rivers_North_of_the_Future)

[16:19] **Michael**: And he lived that right. You may know that he had undiagnosed cancer for the latter part of his life and never had it treated. So this question of where you pass a threshold where the goods begin diminishing and harms begin accelerating, and how passed that threshold, it's not like you can just develop better coping mechanisms. You just can't.

> "Illich lived what he believed: that each person is given a story to tell, and that nothing could be worse than to allow that unique story to be shrunk to a “survival rate” of reduced to an assigned “role”." - [Rivers North of the Future, pg 39](https://www.goodreads.com/book/show/253075.The_Rivers_North_of_the_Future)

[16:45] **Michael**: I think this was Illich's point, the Vietnam war looming large in his imagination. He uses that as a metaphor for what then becomes a default posture. Well, past this threshold, the only thing we know to do is escalate. More money, more resources, more bombs.

> ".. Deschooling Society especially makes frequent use of an analogy to the American war effort in Vietnam. Illich refers to escalation as “the American way of doing things,” and he hardly means it as a compliment. " - [Michael](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections))

#### Escalation as Default

[16:59] **Michael**: You know, more of the same as a way of curing what is being caused by the thing you're applying, right? The application of the thing is the problem. And the only thing you know, to do is apply more of it. And so that dynamic, that principle that there's a point through which you cross a threshold and there is no adequate solution beyond that. Or at least nothing that sort of solves the problem you're facing, right.

> "Solving a crisis by escalation seems not to have gone out of fashion. It signals, of course, a failure of imagination, but also an institutional imperative. What can an institution possibly offer you except more of itself?" - [Michael](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections))

[17:25] **Michael**: And I think of maybe even social media as being a part of this our debates about how to moderate it, who should control it, whether or not the platforms should censor this kind of speech or that kind of speech where the politician should be given special considera-. All of those questions.

[17:43] **Michael**: I'm sure they're important to ask, and maybe there are better and worse ways of answering them, but they're not going to solve the problem, right, that is a function of the scale at which we have connected people and the immediacy as well, right. The pace as well as the scale together.

[18:01] **Michael**: These just maybe things that don't have solutions, we don't get to a communication utopia with social media tools as they exist, simply by tweaking functionality or applying certain rules of conduct, codes of speech to it, right. Does that make sense?

[18:20] **Henry**: Yeah, no for sure. The idea of limits, it seems like such a basic idea, but because of the internet, all of these things don't really have limits, right. There's supposedly unlimited space and it's instant time and all these things. And it makes us think, we have no limits.

[18:36] **Henry**: This is definitely the case in tech. Like our culture is around, tech will solve everything. The joke is like, fix it with an app, right.

> Apple in 2009: "There's An App For That"

[18:43] **Michael**: Right, right. The question is, who's the joke on?

[18:46] **Henry**: That's true because startup culture is scale. Getting as many users as possible. Engagement. And I think we're all slowly realizing that, yeah, we are hitting this threshold of a lot of things.

[18:58] **Henry**: You know, like Facebook's goal is to connect everyone. It just seemed weird to say something like, maybe we shouldn't connect everyone. Maybe you shouldn't have Twitter. Even open source. It shouldn't be as open.

> "For example, the one remedy for the problems it has unleashed that Facebook cannot contemplate is suspending operations. What is never questioned is the underlying ideology that connection is an unalloyed good and we always need more of it." - [Michael](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections))

#### Limits as Heresy

> Also had a convo with Nadia on her book, [Managing Over-Participation](https://hopeinsource.com/overparticipation)

[19:10] **Henry**: And I talked about this in [Nadia's book](https://www.amazon.com/Working-Public-Making-Maintenance-Software/dp/0578675862). Her book goes about open source, and how it's the same problems showing up there and how it reflects in our greater society. Of a neutral public square. Commenting on YouTube videos, anyone can do it, the same problem. Maybe we have too many people involved.

[19:28] **Michael**: Yeah. The proposition that there should be limits is a kind of modern heresy. It goes against something I think, deeply ingrained in Western modernity. Not only with regards to its technological aspects. Although, again, increasingly these two things are so deeply intertwined. It's hard to pull them apart.

[19:48] **Michael**: So you see it reflected in tech, but you see it reflected in other areas as well. But yeah, it's one of those taken for granted assumptions that I think a lot of modern Western culture, assumes, right. That limits are just fundamentally bad, right.

> "In the modern world, of course, we tend to experience limits as taunts inviting their own transgression. This is, in my view, a destructive dead end." - [Michael](https://theconvivialsociety.substack.com/p/children-and-technology)

[20:03] **Michael**: They're there to be transgressed. To be overcome. They tempt us to push beyond them, right. And so I recognize, right? So there's a measure of caution I think that we should employ here, right. Because well, what kind of limits are you talking about, right?

[20:17] **Michael**: Are you talking about the limits that society places on the capacity of women to participate in the civic square, for example, or the public square, or are you talking about limits that essentially become prejudicial with respect to certain people. Also the question of who gets to pick these limits? What are they, how are they imposed, et cetera?

[20:37] **Michael**: So it's a thorny question. To simply say, you know, we should recognize that limits are good. I think that's true. But obviously that doesn't solve the matter, because a lot of debate needs to follow from that.

[20:50] **Michael**: But this refusal.. I tend to come back to, our limits are sort of a given part of our humanity, right. That I am only body in one place. That I inhabit one moment in time as it were, right. That these temporal and spatial limits, they are fundamentally good.

#### Attractive Limits

[21:11] **Michael**: And **Wendell Berry**, who, you know, obviously has written a great deal about the temptation of limitlessness and it's ills, but he has this wonderful passage where he talks about whether we see limits as an inducement to elaboration.

> "… our human and earthly limits, properly understood, are not confinements but rather inducements to formal elaboration and elegance, to fullness of relationship and meaning. Perhaps our most serious cultural loss in recent centuries is the knowledge that some things, though limited, are inexhaustible … A small place, as I know from my own experience, can provide opportunities of work and learning, and a fund of beauty, solace, and pleasure—in addition to its difficulties—that cannot be exhausted in a lifetime or in generations." - Wendell Berry

[21:23] **Michael**: You know, he says as a farmer, right, that one plot of land worked well and carefully and responsibly can be sustained for generations, right. It will provide it's fund of riches. But you have to recognize its own unique limits and work within those limits.

[21:41] **Michael**: Any artist or anybody who works within the constraints of a genre or a particular tradition of dance, or even an athlete, you excel it at these differently. In their own ways beautiful human activities. By working within the limits that are imposed, right?

[21:59] **Michael**: And so there's a way of framing limits that I think most of us would recognize as being more attractive, I guess, than just a way of saying no to what you want to do, right. But then involved in this is also this idea of personal autonomy, a particular view of freedom.

[22:16] **Michael**: And freedom sort of being essentially defined down to doing whatever the hell I want to do at any given moment, right. Regardless of consequences.

[22:26] **Michael**: So I'd say that the idea of technologically enabled limitlessness, a particular kind of conceiving of individual freedom and liberty, also immeshed within the powers of technology makes possible for us. All of these are really deeply embedded in the Western psyche.

[22:44] **Michael**: And so they pop up in all of our discussions about what tech should be, what it can do for us, how we should use it, the kinds of technologies that we imagined, et cetera, et cetera. Yeah.

#### Iatrogenesis: The Cure is the Problem

[22:56] **Henry**: Yeah. I was just thinking. We use this term like diminishing returns, but the threshold is saying that there's a point where it's not just diminishing returns, where it's negative returns, right.

[23:05] **Michael**: Right, right, exactly. You know, and I'm obviously not a medical doctor. So I'll just offer this as what Illich argues, that passed the second threshold, he places that somewhere in the mid 20th century, we then begin to get the generation.. I forget the technical term for this, but of diseases that are caused by the medical profession, right.

> Thanks to a comment on [YouTube](https://www.youtube.com/watch?v=fojoWc1oCeQ&lc=UgyfXEtjjz2kI9Ad7114AaABAg) for pointing out the word, [iatrogenesis](https://en.wikipedia.org/wiki/Iatrogenesis), as a negative condition resulting from further medical intervention. (aka when the cure becomes it's own problem)

[23:24] **Michael**: One example that he gives is the radiation that frequent x-rays would have generated, until that got figured out. It is just not a question of diminishing returns, it is a question of harms caused by the application of that technique past a certain threshold. Yeah.

[23:41] **Henry**: Right. I know that the term he was using was like counterproductivity or something.

[23:45] **Michael**: Yes. In terms of the general principle, right. I was trying to remember the term for when the application of medicine becomes harmful, right. The work of doctors itself becomes harmful.

#### Being Mortal

[23:53] **Henry**: I think your point about extending life, I think is really interesting. There was a book I also didn't finish reading, called [Being Mortal](http://atulgawande.com/book/being-mortal/). And it talks about the same issue, essentially we are really good at extending life and like letting people live longer, but we don't know how to die well.

[24:11] **Michael**: Yes. This is Atul Gawande right?

[24:14] **Henry**: Yeah, it was interesting. The way we treat people that are dying is like, we just want quantity, which I guess is related to limitless. It's not really about quality. More of the same, right.

> We’ve been wrong about what our job is in medicine. We think our job is to ensure health and survival. But really it is larger than that. It is to enable well-being." - [Atul Gawande](https://www.goodreads.com/quotes/6943479-we-ve-been-wrong-about-what-our-job-is-in-medicine)

[24:23] **Michael**: Right, exactly. And, you know, again, I always try to make sure to strike a reasonable and nonjudgmental note of this, right. So I get it, right. If I have a loved one who is ill. Or I myself am ill, right. Life is precious, right. Life is good. And so to want to extend it, to want to try everything possible to extend it.

[24:47] **Michael**: I understand, you know, I think I understand where that comes from. And so it's not as if I just want to say, you know, look, dude, sorry, you're gonna die. So just give it up at this point and make it seem as this sort of easy move to make psychologically, emotionally whatnot.

[25:01] **Michael**: But that idea. There used to be, right, this tradition, the art of dying, right? It was a way of.. you live in such a way so that you're prepared to die well. That whole way of thinking about mortality, and I've only read some bits of Gawande's book, but that whole way of thinking about mortality is lost to us.

[25:22] **Michael**: And I wonder to what degree, to reflect on this from a theological perspective, if that is a function of just coming to see that this is sort of it, right? This is the one shot you get at life. And so the only thing to do is to extend it indefinitely. And I don't know if that's part of the picture as well. Although I will say this attitude isn't just limited to secular society, right. I think you're as likely to see it within the churches without, and then we get into all sorts of other questions there.

[25:52] **Henry**: Yeah. I think you were the one that pointed me to like, see us C.S. Lewis' thinking. I forgot the title of what he wrote.

[25:58] **Michael**: Is it [Learning in Wartime](https://bradleyggreen.com/attachments/Lewis.Learning%20in%20War-Time.pdf)?

[25:59] **Henry**: Yeah, cause there's two of them actually.

[26:01] **Michael**: That's right. There was the other one about [Living in A Nuclear Age](https://static1.squarespace.com/static/5ae75f34e74940380c1926c3/t/5e7d10d2e673e149c64d162f/1585254611117/C.S.+Lewis+-+Living+in+a+Nuclear+Age.pdf). Yeah. I think that towards the end of that essay, which is part of what I quoted in the newsletter, this past summer. There's this realization that yes, you're, you're going to die.

> "In other words, do not let us begin by exaggerating the novelty of our situation. Believe me, dear sir or madam, you and all whom you love were already sentenced to death before the atomic bomb was invented: and quite a high percentage of us were going to die in unpleasant ways." - C.S. Lewis

#### Death as a Technical Problem

[26:14] **Michael**: Maybe it's some war, maybe it's, you know, in a hospital bed. Death is a reality that we face. And so, you know, the desire to extend our lives indefinitely tends to.. It comes at a cost, right? It comes at a cost, psychologically and emotionally.

[26:35] **Michael**: And it's interesting because there is this increasingly non fringe movement around radical [life extension](https://en.wikipedia.org/wiki/Life_extension), and even the language or the idea of approaching death as a technical problem, right? It's an engineering problem. We just have to apply the appropriate technique and we can overcome death.

[26:55] **Michael**: You know, needless to say, I tend to think this is a fundamentally mistaken way of perceiving it, but it is wrapped up with this modern technological project, right. It's something you find the seeds of even in Descartes and Bacon.

[27:08] **Henry**: Right. And I guess, modern society helps us forget that we are mortal, I guess. In this pandemic time, it's like a reminder that, Hey, this is possible and this will happen. And I think it's a good thing in the sense to realize that maybe we haven't thought about these greater questions of life.

[27:25] **Henry**: I keep pointing this out, but my old roommate just randomly messaged me in the pandemic. And he was like, Hey, I've been thinking about heaven and just like what that means. And I was like, well, it's, it felt like, kind of out of nowhere.

[27:38] **Michael**: Right. Yeah. I mean, there was this little school of art, the [vanitas](https://en.wikipedia.org/wiki/Vanitas) tradition, right? So it draws on the idea of vanity, right. Vanities of vanities, all is vanity, which is the old rendering of that famous passage in Ecclesiastes. And so you have this tradition of painting in, I think it's in the Baroque period where it's especially popular, where it's just a scene of things like, an hourglass, a skull, other symbolic representations of your mortality, right.

> "Vanity of vanities, says the Preacher, vanity of vanities! All is vanity." - [Ecclesiastes 1:2](https://www.biblegateway.com/passage/?search=ecclesiastes+1&version=ESV)

[28:07] **Michael**: Or the keeping of a [memento mori](https://en.wikipedia.org/wiki/Memento_mori) right, a remembrance of death. That you will die, right. This was I think, part and parcel of human existence. This kind of recognition, even this focusing of your attention on the fact that you will die, was intended to sort of reap a certain moral reward, right.

[28:25] **Michael**: In the sense that by being mindful of that, you live well, right? In light of your mortality. But I think you're right to say that much of modern society is meant to keep death out of sight, right.

[28:41] **Michael**: Illich wrote in the 1970s, and he was living in Mexico in Cuernavaca at the time, he talks about how in a prior generation, most people would die at home. And they would be buried by their loved ones. One of the professions that he's kind of coming up as an example of people losing their capacity to just care for themselves, was the sort of professionalization of burial and the disposal of the human body.

> "The control of undertakers over burial shows how radical monopoly functions and how it differs from other forms of culturally defined behavior. A generation ago, in Mexico, only the Opening of the grave and the blessing of the dead body were performed by professionals: the gravedigger and the priest... Now legislation is being passed to make the mortician’s ministrations compulsory. Once he gets hold of the body, the funeral director will have established aradical monopoly over burial" - Tools for Conviviality

[29:06] **Michael**: And so you saw death, right? This is the point, right. Death was amongst you, right? Now we cordon it off, right? It happens out of sight. There's a kind of taboo to it, and we have, I think, a difficult time reckoning with its presence emotionally, psychologically in our lives.

[29:27] **Michael**: And Hannah Arendt talks about this too, how in the modern world, biological life becomes the highest value. And it basically trumps everything, every other value. So there are a lot of different theoretical strands that kind of land at the same place, which is, you know, that we now view biological life as this thing to be preserved at all costs, right. And that this is a, in some respects, a uniquely modern attitude.

> "We saw before that in the rise of society it was ultimately the life of the species which asserted itself." - Hannah Arendt, The Human Condition pg 321

> "Society" is a technical term in the book, but it arises only in modern world. By "life of the species" she is referring to mere biological life - Michael

[29:58] **Henry**: Yeah. I was thinking about how you said we don't really see it. And I was thinking, we don't really see it coming too in a way, because. People live in different places, the way you find out is like through a phone call or something. Whereas before if you were living together..

[30:10] **Michael**: Right, right. Or even John Donne's famous poem, right, [For Whom the Bell Tolls](http://www.yourdailypoem.com/listpoem.jsp?poem_id=2118). The idea that in your community, there'll be a public announcement of the death of a member that everybody would sort of know that this had transpired.

> No man is an island,
> Entire of itself.
> Each is a piece of the continent,
> A part of the main.
> If a clod be washed away by the sea,
> Europe is the less.
> As well as if a promontory were.
> As well as if a manor of thine own
> Or of thine friend's were.
> Each man's death diminishes me,
> For I am involved in mankind.
> Therefore, send not to know
> For whom the bell tolls,
> It tolls for thee.
>
> For Whom the Bell Tolls

[30:22] **Henry**: Oh, that's interesting. So this sort of reminds me of when people leave their job or they leave the city. It's not always announced. People just kind of like leave and then you find out a few months later, like, Oh, what happened to this person? And they're like, Oh yeah, they left.

[30:33] **Henry**: But at the same time we have the opposite thing. Well, I know exactly what someone's tweeting or taking an Instagram photo of their food, but like not these things.

[30:43] **Michael**: Yeah, it would be interesting to explore. I'm not thought about that. What is it that we highlight with our new tools and what gets foregrounded, what gets backgrounded right. Yeah, that is an interesting dichotomy..
