---
title: "Ivan Illich (Michael Sacasas)"
season: 3
date: "2021-06-18"
time: "50"
description: "Why read Ivan Illich today? In this episode, Madhu Suri Prakash and Dana L. Stuchul of Penn State University interview Michael Sacasas on his work as being a sort of bridge or interlocutor of Illich's thoughts. They talk about schooling and inequality in COVID, ways of thinking about technology, a life of planning vs. gift, convivial tools, redemption of work, and more. (Recorded in December 2020)"
episodeLink: "0efed081"
embedUrl: https://share.transistor.fm/e/0efed081
sidebar:
    order: 17
---

### Links

- [The International Journal of Illich Studies](https://journals.psu.edu/illichstudies)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/illich.md)

[00:00] **Henry**: I know it's been a while since the last podcast, but I've been reading a lot of Ivan Illich over the last few years. And I figured it was worth hosting a guest podcast about his work. And so on this next episode, I have Michael Sacasas. But he's being interviewed by Madhu and Dana of Penn State University. They're also the editors of [The International Journal of Illich Studies](https://journals.psu.edu/illichstudies). You had a really fascinating conversation with Michael about his work in trying to bring to light Illich's thoughts around the pandemic, institutions and modern life. I hope you enjoy the conversation.

[00:33] **Dana**: Michael, would you remind me what your work is and is about?

#### Working within the Christian tradition

[00:38] **Michael**: My official title is associate director for educational programming at *The Christian Studies Center* in Gainesville. So we are not a part of the University of Florida, but we're right across the street. I find it helpful to think of this as a para-academic institution.

[00:54] **Michael**: So there are other religious groups on campus that are more explicitly geared towards the spiritual life. Our direction is geared on the intellectual life. And part of the mission statement of the institution is to support the university by bringing the resources of the Christian tradition to bear on the life of the university. And my work is generally to get our program up and running. And I do a lot of the teaching here and leading of the small groups and whatnot.

[01:17] **Dana**: Michael, are you a Christian?

[01:19] **Michael**: I am. Yes.

[01:20] **Dana**: Is that important for doing the work that you do?

[01:22] **Michael**: At the institution here specifically? Yes. So the institution is non-denominational, so it's not affiliated with any particular official religious body, but it does operate out of the Christian tradition broadly speaking. We also host a lot of sort of interfaith dialogues and events. So it's an important part of who we are, but does not limit the kind of voices that we hope to host and to promote.

[01:44] **Dana**: Would you consider this work to be a perfect place for you to be, knowing yourself and your interests?

[01:51] **Michael**: It was a really nice fit. I've only been here for a year and a half. And it definitely gave me an opportunity, having not ever completed a PhD. And so not having that more traditional academic path open to me. And frankly, at this later stage of my life, not entirely sure that I would've wanted it.

[02:08] **Michael**: This setting gives me a great deal of freedom to explore my own interests: to teach, but not grade, to not have any administrative labors except of course administrating our program. But were a relatively small institution, so it's not a great deal of bureaucratic red tape that we have to go through. All that to say, yes, I'm actually quite delighted to be here and it was really fantastic to land here.

[02:29] **Madhu**: For us, [*The Convivial Society*](https://theconvivialsociety.substack.com/) has worked out very beautifully. You came into our lives in a very good moment. And we have loved everything you've shared.

[02:42] **Michael**: I'm so glad to hear that. Thank you. I should report too that part of the freedom I get here now is I will be teaching a class on Ivan's work next semester doing three lectures. So we sometimes have public lectures. These will be zoom based under the present circumstances, but we hope to sort of advertise to the university community here. And so hopefully expand the base of those who are reappointed with Ivan's work.

#### Why start the newsletter?

[03:04] **Madhu**: I want to ask two questions and they may seem unrelated. I just want to juxtapose them.

[03:11] **Madhu**: The first question is, of course, what led you to starting this Convivial Society Substack newsletter? It's a labor of love and must require a lot of time when you're a father, husband, with this job, and do the mountain of research you're doing. So we would love to hear what got you moving on this fabulous initiative.

[03:37] **Madhu**: And then leaping to the present moment of the pandemic, every day on the radio I hear one repeated statement, which is, Oh, this is the lost year of schooling in this COVID era. And I have my own reactions to hearing that. As a friend of Ivan's, I would love to know, as a father of young girls, what your thoughts are.

[04:08] **Michael**: With regards to *The Convival Society*, the newsletter. It was a new iteration of something that I had started when I began my grad program around 2009 which was at the University of Central Florida.

[04:20] **Michael**: As I began my coursework, I found myself wanting some sort of outlet. I don't think I would have put it like this at the time, but it was a way of reaching for an intellectual community in the absence of one. I was working while I was doing my grad work. It was a kind of go into class, leave class. And so there's not much opportunity to cultivate that community there. And so I turned to writing online. And in essence, I thought of it as an effort to think out loud or write out loud through the work that I was doing.

[04:48] **Michael**: And so I continued to do that even after I was unable to complete the dissertation after I finished ABD. And in that time period, I had cultivated a little bit of an audience. I never had any great audience, but enough of an audience in a sense of community with readers over a period of time to keep me motivated to do that. And honestly, even absent to that, I probably would have kept doing it because I enjoyed the process of clarifying thoughts with the work of writing.

[05:16] **Michael**: And so I did have some frustrations with the ways in which one tries to sustain an audience in an era of social media and was not really happy with any of the options. Right now, I think we're sort of in a boom of newsletters. And so I'd like to say a little prior to that boom, the newsletter option became something that some writers were turning towards.

[05:36] **Michael**: I described it as a rather convivial tool in the sense that it liberated one from the temporal patterns of social media, right? So if something is delivered to one's inbox it, it doesn't exist in a kind of temporal horizon where you have to sort of catch it or else we find yourself as the producer having to repeat yourself all the time on social media in order to capture somebody's attention.

[05:58] **Michael**: And so it also gave the reader complete freedom to discard, to delete, to read again, to open when they want. And so I thought that there was something attractive about that particular medium. And to know that I wasn't just sort of writing into the ether of the internet, but to a neatly circumscribed community of people.

[06:17] **Michael**: I didn't know everybody on the list of course, but it still gave me a sense of writing to an audience that I had, in Walter Ong's phrase, less trouble fictionalizing. So it was a slightly more concrete audience. And it was a self-regulating audience; you might get a couple of issues and decide this isn't for me, then you just sort of unsubscribe. And so the relationship between the reader and the audience gets calibrated over time in a way that I thought was interesting and good. I enjoyed that.

[06:45] **Michael**: So I've continued to write it. The pace has slackened a little bit of late, because as you mentioned I sometimes find myself writing at 1:00 AM in the morning, which is not greatly conducive to a clarity of thought and expression. There's been a lot going on, but I continue to do it because I do enjoy it. And have enjoyed the responses I get from readers, whether that's email exchanges or even this conversation we're having now, which I could not have predicted going into this year. And so it's one great fruit, I think, in my own life. And I found it very enriching for me personally.

#### Lost year of schooling

[07:16] **Michael**: As to the lost year of schooling. Yeah. I should say my own girls are still at a preschooling age by ordinary standards. My youngest is three. My oldest turned five after the beginning of the school year. But, likewise, when I have heard that phrase, my response I think has been, "well, that kind of depends on how you define schooling."

[07:40] **Michael**: And in some respects I think some people have found the opportunity to maybe think again and more largely about what it means to learn, or how one learns, with whom one learns. And so that has been, I think, refreshing. And I think at the same time, it's probably important to acknowledge that there are a lot of people who may not have found the freedom to enjoy that discovery because they may be, you know, single mom without the resources that would liberate their time in order to enter into that process. Or other limitations, often financial and emotional, perhaps even, that would hinder somebody from taking what I would see is advantage of an opportunity to think again about how learning can happen and under what circumstances.

[08:30] **Michael**: And I know that those who have had, you hear stories of people sort of rediscovering community co-ops for learning and teaching involving the parents more deeply into that process. And asking again what ought to be learned. What is vital? What is important? That opportunity to rethink those things. And certainly, I would say with Ivan as a conversation partner in that rediscovery, that would certainly be a very fruitful undertaking.

[08:54] **Michael**: I'm not sure if that sort of answers either of those questions perfectly, and I'm happy to kind of follow up on either of those.

#### Inequality in COVID

[09:00] **Madhu**: It's actually a reiteration of something COVID has brought to everyone's attention. That is the horrific inequalities in our society in terms of death rates, sickness rates. I mean, as you know, medicine and schooling are supposed to be the great contemporary panaceas right. And so there is a sense that people like you and others of our ilk have access to technology. And there are young children of all ages who do not have that access to Zoom classes and technological help of other kinds.

[09:45] **Madhu**: And so they are the ones being starved of learning opportunities. And then you compound that with handicap people with just different disorders, ADHD, and so on and so forth who are suffering. Just as there's immense suffering amongst people of color in terms of infection and death. So in that spirit, it's dragged in as one more horrible inequality in our society. Thoughts on that as a lover of Illich or a friend of Illich.

[10:24] **Michael**: Yeah. No, I think that's absolutely right. And it's interesting, because the idea that we might be presented with an opportunity in a sense may also sort of naively presuppose that a great deal of damage hasn't been done already over the years, that was in large measure ignored or papered over or not attended to in a way that it ought to have been. So opportunity for some, but others are reinforced in their lack of opportunity, their lack of resources available to them.

[10:52] **Michael**: And so that now we're beginning to see all of these fractures and inequalities in our society for what they are, they're exposed and heightened. And so this has been a revelatory experience. And that we also have lost certain capacities along the way.

[11:10] **Michael**: And this is I think at least part of what I have taken from Illich's work, which is that we've been deskilled in important ways, to the degree that we have depended upon institutions and have outsourced the care of one another and the care of our communities to institutions. It seems as if the way in which our society has atomized us and rendered us as sort of bare individuals or single family units that have little regard for our neighbors or for our communities..

[11:40] **Madhu**: All the things that have been rendered naked by COVID horrors, that were masked over. And one of them is this rabid inequality, that's actually no secret, right?

[11:53] **Michael**: Right. And even with something so basic as who can afford to stay home, or who can afford to quarantine appropriately or protect themselves, and who's forced into unhealthy situations. So Yeah, it's been devastating and tragic.

[12:09] **Michael**: I was thinking of deskilling in terms of our inability to appropriately care for one another, or even with regards to where we began here, the task of education. If we are placed in a position where we have our children at home, do any of us even know any longer what it means to teach our children? Not formally necessarily by the curricular standards of the institutional school, but by simply introducing them to to the skills that they need as human beings to flourish.

[12:43] **Michael**: The fact that so many parents feel inadequate to that task is both a reflection of the inequalities on the one hand, but then also I think a reflection of what schooling has become. Which I think Illich's work can help us at least imagine some alternatives or some other ways of thinking about what schooling and education can be that would be liberating in our context.

[13:04] **Dana**: It's sparked an Illich idea, seen in a new way. His idea of institutional inversion. We've put all our learning eggs in the schooling basket. And we've put all our health eggs in the medical allopathic basket. And we've put all our community security and safety eggs in the police basket. So that defund the police, which one could argue is kind of tragic language.

[13:34] **Dana**: But it is to say, if we were taking the pool of eggs, resources, dollars, skills, capacities, and we distributed them around in the community, lots of benefits would occur. So I dunno this notion of institutional inversion, taking the pyramid that is the school and the medical system and we invert it and we bring it out into the community. Thanks to your response, a new thought for a little Dana.

#### What's Compelling about Illich?

[14:03] **Dana**: I'm always so curious in my teaching, formal teaching, but just in all of my relationships to know something of the questions that animates people. What are the questions that bring you to Ivan's work? Compel you to bring Ivan's work to others?

[14:22] **Michael**: I think in one way, the very broad question that has animated my thinking about technology is simply the question of how do we live well, which is obviously a very ancient question that I think most of us ask at some level or another and may articulate it in different ways. But with specific reference to our tools and our technologies and the technological infrastructure.

[14:46] **Michael**: I sometimes refer to technology as sort of the material infrastructure of our moral lives or alternatively the infrastructure of our social lives. This may be changing to some degree, but in the popular imagination tools are just sort of neutral things that we can use for good or you use for ill.

[15:04] **Michael**: They don't necessarily have a very great bearing on our our moral or communal or social lives. And so recognizing through the work of Ivan and others, that this is not the case. That the tools that we use have a profound impact on how we conduct our lives, how we imagine the social sphere, then then to ask questions of those systems and tools and artifacts, and try to understand how they impact our efforts to live the kinds of lives that we want to live.

[15:40] **Michael**: And those ends may be very diverse. They may depend upon one's you know, sort of cultural or religious background and upbringing and assumptions. But regardless of what those happened to be the tools in a modern society are still kind of intersecting with those desires and aspirations.

[15:55] **Michael**: And so to try to understand the nature of that intersection, especially where that material technological infrastructure is actually undermining our desires and our efforts to be the sorts of people we want to be, to have the kind of communities we aspire to have. Those are the kinds of questions that are very usefully illuminated by the work of the Ivan and Jaques Ellul, who I've been writing again a little bit about recently.

[16:22] **Michael**: I think of my own influences as sort of having two separate traditions of technological criticism that come to bear on it. One is sort of the media ecological tradition where Marshall McLuhan and Walter Ong and Neil Postman have been very prominent.

[16:35] **Michael**: And where I think Ivan, especially towards the 1980s and then even the nineties within The Vineyard of the Text is in conversation with that tradition. And then what I think of as sort of the more traditional, especially the mid 20th century technology criticism that Ellul and Illich in that phase represent. And Lewis Mumford comes to mind as well.

[16:58] **Michael**: And then there are more academically traditional philosophers of technology like Carl and Albert Borgmann as well. So in some respects, these are sort of three traditions through the lens of which I try to perceive the role that technology plays in our lives with a view to this larger question of how we live well. How we live lives that we can think of as flourishing lives and how we sustain communities that empower human flourishing. And I feel like that's very long winded answer to the question.

#### Resisting the frame of control and embracing gift

[17:28] **Dana**: I do wanna beg your indulgence in a follow-up question that is just a bit more personal. Can you say more about questions that fall out of the big question, how do we live well in the world of tools and technology that are so evidently not neutral, so evidently have ethical implications? What other questions are you asking yourself that are kind of a subset of how do we live well?

[17:54] **Madhu**: It's about Michael in conversation with others, two women, including us, who are daily asking? Are we living the good life? What's deficient in our lives? How could Illich in his wisdom guidance towards our next steps?

[18:12] **Dana**: And if I can give an example very quickly of what I mean. Ever since I lived in Southwestern Ohio, where I passed the tallest mountain in Ohio, which happened to be a landfill, I've asked myself everything I put in the trash is there in that mountain. That's an ethical issue and waste. Very generally, I ask myself all the time, how do I judge my living, my decisions, my actions, my relationship to my daughter and what she's learning by living with me. So these are very real personal questions. I can't say that I've achieved any enlightenment on them, but those are my active questions. And I suspect you have similar.

[18:56] **Michael**: Yeah. One of the things that comes to my mind along these lines. Let me back up a little bit. At the end of *Deschooling Society*, Illich draws upon the myth of Prometheus and that opposition between a life that seeks to plan and control, as opposed to receiving as a gift, right? So that frame of mind that the reality that we experience is a gift and is given and for which we have responsibilities which does not belong to us as it were.

[19:25] **Michael**: Especially as I think about this in a distinctively theological vein with people like Illich or even Wendell Berry who has this wonderful line about how we live the given life, not the planned in one of his Sabbath poems. And that succinctly captures something that is very important to me.

[19:42] **Michael**: How do I refuse the framing that modern technological culture offers to me, of being the one who will master and control the world. The one who sees the world as raw material for my own projects. And rather see the world and other living things, right?

[20:02] **Michael**: So Berry describes the lowest denominator of health is the community, not the individual. And the community he defines as the all living things and the world that they inhabit, right? So that there's this rich network of communities in which I am but one member. And not even necessarily by myself, the most important member.

[20:24] **Michael**: And I find that the, the affordances of modern technology, particularly as they are sort of coupled with a consumer economy, encouraged me to see the world in precisely the opposite fashion as sort of disposable reality that is subject to my whim. And for which there are no consequences however I treat the world. There are ultimately no consequences to pay. I just keep on consuming as it were.

[20:48] **Michael**: So resisting that frame in order to see the world as a gift that invites my wonder and my gratitude and my care and my celebration. And again, in speaking of this, the work of Ivan and of Albert Borgmann, the work with Wendell Berry, all neatly form a package for me. And helping me to articulate this and express this desire to have a certain way of being in the world.

[21:14] **Michael**: So that ultimately, as I think about the ethical ramifications of technology. It involves certainly what this one artifact or this one algorithm may or may not do or empower, but more broadly it's about a way of being in the world.

[21:28] **Michael**: The little gestures to this with the idea of technique, which is not just any one thing, but rather a whole way of approaching life and thinking about the world. So to resist that framing and to experience the world as a gift, I guess maybe one of the most fundamental things that I desire or ways that I would sort of narrow that question a little bit more further.

[21:50] **Michael**: So this idea of the good life, living well, involves maybe foundationally experiencing reality as a giftedness of the world. I don't know that I often articulate that very clearly. And then to help my children do likewise.

#### Tesla as a "solution"

[22:03] **Dana**: Yeah, it's beautiful. I don't know why, but it stops me a little short only because I'm now in an active conversation with a very cherished neighbor who I think sees promise for addressing climate disruption and climate change in the Tesla. So the Tesla is become kind of both solution and symbol of how to respond. And as an ethical direction, I... I'm stuck.

[22:36] **Dana**: Because I see that response as a problem. But that example is illustrative of an approach to technology and technological solutions to the many crises that I think Illich has something to say about.

[22:53] **Michael**: No. Yeah. That gesture that there is this one still future or still developing technology that will be the solution to all of the problems with the prior configuration of technology has caused.

[23:03] **Michael**: On the one hand, I don't want to suggest that it is impossible. You know, one of the things I've been thinking of late is that when one sort of writes in this vein it, it's very common to sort of hear the rejoinder. Well are you just anti-technology? And I think one of the wonderful things about Illich, especially in *Tools for Conviviality*, it's not about, anti-technology about finding the right technology, the technology that is conducive towards human flourishing right. There are no illusions in Illich's work about a return to some sort of state of nature or anything of that sort, but it is about finding tools that are appropriate.

[23:40] **Michael**: One way of thinking about this is, you know, tools are appropriate to a human scale. I just saw someone comment yesterday about Facebook and asking whether the problem with Facebook was at scale, to which of course in my mind with Illich on the question of scale and limits very much in view, answered yes, obviously. And if you applied sort of the institutional critique to something like Facebook, the only thing Facebook can ever offer you is more Facebook. And so the idea that the answer may be limits is something that never occurs to us, right. This is something that both Berry and Illich are so good on, that maybe the answer is not more, but less. Or differently configured.

[24:23] **Michael**: There's a beautiful passage in *Tools for Conviviality* where Illich writes the possibility of a convivial society sort of requires that our consolations and satisfactions don't lie in simply the accumulation of goods or in the products of industrial society but rather in the pleasures of human interaction, human community. And that we discovered we don't actually need very much for that.

[24:47] **Michael**: And so there's a way of construing the necessity of limits in a way that hopefully clothes them in their proper beauty so that they become attractive to us again. I think a lot of people would acknowledge that we don't find satisfaction in our way of life for all of our material abundance.

[25:06] **Michael**: The way I've thought of it lately is, you know, Simone Weil talks about the need for roots. She talks about the needs of the soul and distinguishes between material and material needs. And certainly from a certain perspective for a certain class of people, industrial society has provided for material needs by certain measures, but perhaps at the cost of ignoring the non-material needs that are often as important for human flourishing as the material needs.

[25:33] **Michael**: And so instead of imagining that the answer is always more of something, but rather to consider that perhaps the answer is less. A different way of life. A smaller scale, a more humane scale for our technologies, for our communities. And that there are satisfactions in that, that we have lost sight of. And that might more readily provide us with joy and and a sense of meaning that we encounter these limits, not as something to be transcended, but rather as essential to, I think Berry puts it as "invitations to elaboration" within those limits that provide a wonderful fund of endless satisfactions. That's I think also an important part of this.

[26:19] **Dana**: That was a beautiful response, Micheal.

[26:22] **Michael**: Well, I always say nothing original. I've just always channeling these wonderful thinkers again and again. Just synthesizing and channeling their work.

#### The challenge of needs

[26:29] **Dana**: Can I ask a question about Ivan's ideas that challenge you or to live them out or to imagine them manifest in the world or other interpretations too?

[26:43] **Michael**: Yeah. It is challenging to think about, what is a need? What do I consider a need? What do I feel that I need? What has fabricated that sense of need in me? And that exploration, that is in part generated from Ivan's work, I think is something that I think all of us would find relatively challenging. What do I feel that I need? And what do I sacrifice in order to meet these needs? And are they in fact needs in the way that we think that they are? And so to constantly sort of think about that and examine my own life, my own practices, the allocation of my time. I wouldn't say that that's troubling, but it is challenging to live with that question in view.

[27:20] **Michael**: Again, to imagine that there is a kind of austerity that.. And austerity now has become such a politically loaded word. But I think Ivan doesn't use it with regards to what at least since 2008 been seen as especially sort of neo-liberal approach to finance, but rather of personal austerity and an aesthetic practice that is aimed not simply at saying no, but having the capacity to say yes to the things that we truly value and would be truly satisfying in own lives and so that, that, that idea of, of re-examining needs of recognizing the importance of a certain form of austerity or aesthetism in our own lives, these are things that I want to allow to constantly sort of challenge how I live in my assumptions.

#### Progeny

[28:12] **Michael**: I confess that I don't know enough about how Ivan thought about these lines, but there are a couple of places where Ivan, along with challenging our dependence on material goods, also includes sort of our progeny, the size of our family. Maybe those are some of the places where I want to quibble a little bit. And I'm not an economist, but, again a child is a gift in the same way that our experience is a gift. And different people will value that differently with regards to this. But I think those are one of the few places where I feel like I would want to argue a little bit more.

[28:41] **Dana**: I don't think I understood. Do you think Ivan is talking about population control or is that what you're implying or no?

[28:48] **Michael**: Not population control necessarily in the heavy handed sense, but rather than one of the things that we should be prepared to relinquish is a large family. That may be a misreading. I don't know how Ivan's thoughts on that evolved over time or whether they been or not. And this is not a such best that I think everyone ought to have very large families, but that might be a column for some. And that in its own way, it would be something good that that ought to be you know, celebrated.

[29:17] **Michael**: There's again I think a lot of agonizing, even of late, about bringing children into this sort of world. You know, that kind of language. I don't want to come off as suggesting that I have very definitive answers or even convictions in this regard, except that I think generally speaking, I see children as a gift. And in these couple of paragraphs that I have in mind, that in reading them gave me a bit of pause. Just because my underlying assumption might be a little bit different in that one regard.

[29:48] **Dana**: Thank you for that clarity.

[29:49] **Madhu**: I want to highly recommend Population, the entry in The Development Dictionary? Yeah, that's so important because it was for him, anything to do with a national program of one child per family is for him horrific. By grownup is a Jew. and she's a really good friend as you know, who sat at the table with Ivan exploring really difficult questions.

#### Redeeming work

[30:24] **Madhu**: I have two questions. If we were lucky face to face with Ivan, to be able to ask him questions, what questions would you ask him? And related to that since he was a guy who celebrated eutrapelia, playfulness, how are you bringing those into your life as a really serious dedicated student of Ivan?

[30:52] **Michael**: That idea of the questions that we bring. I try to think of the places where I find that Ivan's work would be especially valuable in ongoing conversations. And I think we've had a lot of discussions and debates about the role of work in a society that is increasingly automated. So wanting Ivan to speak to those questions is how I'm sort of getting to that right.

[31:14] **Michael**: To think about the challenges posed by the automation of labor, not only what we would think of as sort of industrial labor, but now even increasingly white collar jobs. And that the options that are often considered along those lines are the introduction of something like a universal basic income because there will inevitably people who are sort of chased out of the labor market. Kind of the reality of technological unemployment and its scope and scale.

[31:40] **Michael**: But it seems relatively evident to me that there are those whose work will be displaced. So the solution is either UBI in some circles or learn to code and others which seems to me incredibly inadequate in both cases in part, because it treats work as something that as long as we sort of got the wages, but lost the work, everything would be okay.

[32:05] **Michael**: And it seems to me that, that, you know, you bond sees that, that there's an important problem with that. And that is that there is something about doing work, work that is humane, work that is dictated to some degree by the individual that is satisfying and important. And this trend towards, obviously a kind of a sufficient lack of satisfaction with life as we're living it, that drives up suicide rates and places that have been devastated by a lack of useful work or meaningful work.

[32:41] **Michael**: So that sort of nexus of questions around the role of work in an individual's life and what dignified the labor might look like. Or how we might find that or how we might navigate the kinds of, challenges posed by automated automation technology with regards to labor and work.

[33:06] **Michael**: I see his work as a source that helps us sort of navigate some of the dangers that lie in the problem itself and then our proposed solutions to the problem.

#### The body and senses

[33:16] **Michael**: And then I would be especially interested too in talking about the body and the role of the senses which seemed to have become especially important to Ivan maybe later in life. And you two may know better than I when this became important, but seeing some papers recently that do come from the late nineties with regards to the history of sight and the history of how we think about touch and smell. I remember the little anecdote in Ivan's talk about the friend who tells him he can't really be friends with somebody unless you can smell them, right.

[33:51] **Michael**: And how the human sensorium as it were, is limited by especially the digital tools that we so often use now to mediate our human relationships. And again, it's wonderful that we have the opportunity to communicate in this way right now at a great distance. But when this becomes our default mode of communication, when it replaces the gathering around the table, what are the costs and consequences of that?

[34:16] **Michael**: So this focus on how we outsource our embodied experience of the world through tools that then interrupt our senses' direct contact with the world or displace it. I've been very curious about that. And I've been reading with interest along those lines, to kind of draw his insights into our contemporary milieu, and especially with the rise of digital platforms. And I think it's evident he sees this as a trend already unfolding in the mid and late nineties.

#### Playfulness

[34:50] **Madhu**: .. I have not even hugged.. But that's just a metaphor for our times that we have taken this enemy, the virus, as another way of cutting ourselves off from playfulness and friendship.

[35:08] **Michael**: Yeah. What comes to my mind right now, and this is undeveloped thoughts, but the regimentation of life that does not allow for playfulness and I think of this even with regards to our children. This is painting with a very broad stroke, but that there's one way in which we might say that we have infantilized adulthood and that we have simultaneously professionalized childhood and the loss of playfulness even for children. And some of this is connected with what schooling has become, especially in more well-to-do families where even the choice of the right preschool becomes so fraught with anxiety about future prospects and that there is this very regimented way that we want to construct our children's lives.

[35:56] **Michael**: Often, you know, I grant that it often is motivated by well-meaning parents who want the best for their children. I have a picture of what that looks like, however limited it may be Or very concerned, especially maybe with the safety of children so that we have excised this playfulness this more liberated encounter with the world, risky as it may sometimes be.

[36:21] **Michael**: It's obviously not specific to our COVID season, but that again has sort of been accented by or made worse or more severe by the kind of restrictions that we now live or try to negotiate.

#### Why read Illich today?

[36:34] **Dana**: Michael, we're conscious that we're probably getting to the end of our time. So why read Ivan today? Why turn to Ivan today?

[36:42] **Michael**: So I confess I do spend some time on Twitter. And I never think of myself well when I do, but nonetheless a while ago around actually election time, four years ago, I took to using a hashtag, #NeilPostmanWasRight. And I joked recently not a day goes by that I couldn't envision saying Ivan Illich was right. Or Jacques Ellul was right.

[37:04] **Michael**: So many opportunities presented by contemporary circumstances that I think validate their analysis. So why read Illich? I think of Illich as a radical critic and in that literal sense of getting to the root of things in a way that a lot of is thinking about technology doesn't today.

[37:24] **Michael**: And I think Illich writes about so much more than just technology. I came to him with a special interest in the question of tools and industrial society and its consequences. And it's obviously evident that Illich works with a much larger frame, which is part of what is so appealing to me that there's kind of a moral seriousness to his writing.

[37:43] **Michael**: And that it is for the sake of something more than simply thinking about this particular tool, this particularly technology. But in any case that he raises the kinds of questions that we need to raise.

[37:55] **Michael**: That we again go back to the idea of limits as a way of thinking about technology. I think there are two ways of thinking about limits. One is thinking about them as sort of arbitrary impositions that we could throw away and do away with,. But rather in Illich, we see limits are essential to a well lived life, if we understand what a well of life ought to look like, right, in his particular framing of it.

[38:22] **Michael**: And so that he invites us to think at that level about our tools and our devices. That he gives us so many great analytic categories to think about these thresholds, that institutions cross when they become counterproductive.

[38:37] **Michael**: Or this idea of a threshold and counterproductivity. I think it would be such a useful analytic tool for so many who, when imagining for example that this new development within a trajectory of innovation might be problematic, the only reaction is then, well, would you have said everything else prior to this is negative.

[39:02] **Michael**: But instead, if we think that innovation is good, but that there is a threshold in that once that threshold was crossed, then the benefits begin inverting. That's simple insight which seems to be again, generally lacking, I think it was so valuable.

[39:17] **Michael**: Illich's thinking about hospitality and friendship, so much of what derives from his analysis of the Parable of the Good Samaritan, I think is so life-giving and vital. And what I think of as sort of the connected ideas of a kind of independence in the service of our interdependence and so that I do not outsource this capacity for care or for learning and teaching to institutions. Not simply so that I become a paragon of self-sufficiency, but rather so that I am then able to support my neighbor and care for my neighbor and my family and new ways and better ways. I think that that's also so useful and so important. And this past year has sort of made that all the more evident and apparent.

[40:06] **Michael**: So those are some of the things that come to mind when I think of why read Illich. At so many points, whether it's the health of our political communities, whether it's our local community's ability to care for itself and one another, to go back to this idea of posture towards reality and experience that is prepared to receive it as a gift and relinquish the desire to control, that views the future with hope rather than optimism, there are so many strands of his thought that I think would be so again life-giving in our contemporary moment, our contemporary situation.

#### Making Illich accessible

[40:43] **Madhu**: Much as we love Ilich, much as I have labored hard to include him in my classes. I have to contend with the fact that many of our friends and kindred spirits, scholars, non scholars, poets, and others find Illich hard to study and read. Inaccessible, not because that's what he intended. But he had his own skillset and is accessible to a very, very small studious group of people. Is your initiative and attempt to make him more accessible? His ideas, whether it's counter-productivity, friendship, or conviviality. More available to people who are not textual?

[41:37] **Dana**: And I'll just add. Our beloved friend Gustavo Esteva tells story after story of the aha effect experienced by indigenous peoples who upon conversing about an Illich derived idea, say, Oh, of course. That's true. We know that. So the juxtaposition of people you might say of our class or of our education, who find Illich out of reach, or even more troubling conclusion, in contrast to people among the so-called grassroots.

[42:12] **Michael**: No, right. One of the most joy giving messages that I receive is when somebody says, I've been reading your newsletter for a while, and so I finally picked up *Tools for Conviviality* or Deschooling Society or whatever it may be. And I actually have often framed, especially when I began writing online, part of what I was doing at least to myself as an effort to translate. I certainly hope it was never a question of simplifying, but translating and interpreting the work that is happening in more sort of academic circles, whether that's in the philosophy of technology.

[42:46] **Michael**: I mean, I think Illich is sort of his own genre in some respects. You know, as this question suggests, it doesn't sit neatly within our academic discourse. But to introduce people to that work in a way that is inviting, I certainly hope that's part of what I've done and what the newsletter does. And actually, I tend to find Illich's work stimulating and provocative. But I can see how even sort of the idea of questioning the institutions of medicine and schooling just run so against the grain of the assumptions of modernity's blessings to us and what we take for granted.

[43:22] **Michael**: So when people in in the grassroots, or indigenous people who don't have access to these same services or institutions, or don't take the same things for granted find that aha moment, that I think that is a testament to the fact that part of the problem with the quote unquote educated class is that we have been so schooled by modernity as it were that we don't see the truth that is contained in the wisdom that I think Illich channels in his own way.

[43:53] **Michael**: All of that to say that, that I there's a little work to do there sometimes. And maybe it is just in making that application, right? Where look, here's this problem that we face and I I've got this wonderful insight from Illich that helps us understand this.

[44:09] **Michael**: And maybe if they had come to Illich in a different way, it might've been different. But yeah, hopefully that's work that I feel very much.. called maybe is too freighted away, but I certainly experience it as part of what I want to accomplish through some of my writing.

#### Starting point to his work?

[44:24] **Madhu**: Continue this question about accessibility because colleagues of mine whose graduate students are developing an interest in Illich, will often ask me, what would you suggest as a starting point to enter Illich's unreadable work.

[44:42] **Madhu**: I'm going to juxtapose two essays. My most favorite is *To Hell With Good Intentions*. It's one of my favorite essays, because my daughter-in-law was given that when she was going off to Latin America and she cannot forget that and neither can do gooders.

[45:02] **Madhu**: My other favorite essay, *Declaration on Soil*, which for me is pure poetry. The latter is you have to know so much Illich to understand that. Not only so much, Illich so much Wendell Berry, so much guns, understand that Illich whereas *To Hell With Good Intentions* gives the ordinary do gooder on the street a real punch in the stomach.

[45:29] **Dana**: Then slap.

[45:31] **Madhu**: If you were challenged to bring something of Ivan's writing as a doorway, as a portal that is not daunting, but seductive, attractive, simple, just as when he buries poems. What could you choose to offer your readers of convivial society?

[45:55] **Michael**: When I've been asked that question, I've often actually, and maybe this has been too ambitious, but I've thought about *Tools for Conviviality*. But I've been asked that question by the sorts of people that I, generally think, yeah, you can pick this up and you're going to be okay.

[46:08] **Michael**: This is actually kind of derived from another conversation about the relative clarity and obscurity of the writing of Walter Ong and Marshall McLuhan who are often saying similar things, but many who found McLuhan impenetrable and Ong very clear and then in that conversation, I sort of suggested, well McLuhan's interviews are really accessible.

[46:30] **Michael**: And so this leads me to think of the interview that Carl and Ivan did with Jerry Brown on his radio show, which I think is a wonderful little text. For one thing, Brown does a really nice job of encapsulating Ivan's earlier work. And then there's such a personal style in that interview that even would translate into writing. It works really nicely. The other thing that comes to mind is David Cayley's interviews with Ivan. And that maybe it is in that sort of conversational context, as opposed to the textual context, that a lot of that work becomes accessible and inviting and provocative in the best sense.

[47:09] **Michael**: So I guess my answer is in transcriptions of conversations. I mean, you all know better than I do. And honestly, I have to confess to being somewhat sheepish to having you all sort of interview me about Illich's work, who have had so much time with Illich personally. But I'm honored, I should say, but also sheepish.

#### Illich in Conversation

[47:27] **Michael**: And so that seems to actually be rather fitting, right, so much Ivan's labor involved gathering people together face to face around the table in conversation. So that it ends up being that when we get a glimpse of that, when we get a little taste of that, even if it's in the transcribed format, that we really see the passion, the energy. The vibrant quality of his thought come across in a way that's very compelling. Where I grant that the pros can sometimes be very dense and difficult at times now.

[48:01] **Madhu**: Yes. I love that interview too. And it's in Jerry Brown's book, *Dialogues*, I think.

[48:09] **Michael**: Okay. Yeah. I found that online, David Apple or something, he has a kind of a archive and I think that's where I first encountered him.

[48:16] **Madhu**: Oh, that book is a joy. It's Jerry Brown interviewing a whole spectrum of people and that many interviews that he had on the radio and he's put it beautifully.

[48:25] **Michael**: I had no idea that book existed. I'll have to look for that.

[48:27] **Dana**: Hearing the both of you, I'm reminded of only for two or three years, did I attend Illich's lectures in the fall at Penn State, but always, always. I don't know if I knew in the moment or I knew through going to Lee Hoinacki's informal lecture, dialogue, conversation about the lecture, dialogue, conversation.

[48:50] **Madhu**: The tutorials.

[48:51] **Dana**: Tutorial. But the point is, I became aware that Ivan was actually having a conversation with people dead and with people in the room. That every lecture attendee was simply listening in on a conversation. And unless you understood that, you were even more lost.

[49:10] **Michael**: Yeah. That's that's really well put.

[49:13] **Dana**: I was saying.. So that you use conversation and sitting around the table to suggest that that be the way to invite people in is so perfect. Is so apt.

[49:24] **Michael**: Good, good. Excellent.

[49:25] **Dana**: Well, I had hoped to learn something and I learned so much. So my hope has not only realized, but exceeded. And I'm so grateful for your time and indulgence of our questions and curiosities.

[49:39] **Michael**: Oh, yeah, no happy, flattered, honored to do it. I should say, I'd love to turn the tables at some point, and maybe record you all for what I come to think of as sort of this oral history project on the newsletter. This year has been such a challenge, but getting to know you all, and Carl, and Gustavo, and this warm hospitable entry into this world has been truly a joy and I'm so thankful for it.

[50:04] **Dana**: And I just conclude by saying, I think your hope or I dunno if you use the word goal, of serving as a translator, or maybe a bridge, certainly an interlocutor, to and of Illich is such a gift to us, but I think the cosmos too. So thank you.

[50:23] **Michael**: Yeah, my pleasure. So glad to do it.
