---
title: "Inhabiting Heritage (Bernardo Hidalgo, Marianita Palumbo)"
season: 3
date: "2020-08-28"
time: "43"
description: "Do we think about how the places in which we live are passed down? Both Bernardo Robles Hidalgo (architect) and Marianita Palumbo (anthropologist) join Henry to chat about living as maintenance. We discuss Bosch, responsibility of taking care of the places we live in, on our desire for comfort, the right to repair, the aesthetic of maintenance, and communal living. (recorded in February)"
episodeLink: "841541a0"
embedUrl: https://share.transistor.fm/e/5c511f38
sidebar:
    order: 5
---

### Links

- [MAMA](http://mama.brussels/)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/overparticipation.md)

#### An Architect and Anthropologist

[00:00] **Bernardo**: My name is Bernardo Robles.

[00:02] **Bernardo**: Time 9:51 in Brussels. 4th of February, 2020.

[00:07] **Bernardo**: Raining outside.

[00:08] **Bernardo**: I find myself with Henry and Marianita. Henry, please.

[00:13] **Henry**: Oh, thanks for introing!

[00:16] **Henry**: At first I thought it would be interesting to interview software maintainers, but there are a lot of other podcasts already doing that. It might be cool to be more interdisciplinary.

[00:25] **Henry**: I think this is the first one where, I don't know if we're going to talk about code per se, but we want to talk about maintenance.

[00:31] **Henry**: How do we maintain our lives: where we live, how do we think about homes, our dwelling place.

[00:37] **Bernardo**: And I have to say that I am an architect. I am a project manager for construction.

[00:41] **Bernardo**: I've been living in several co housing projects, as well as constructing and conceiving a public space.

[00:51] **Bernardo**: But Marianita, who is here, is a cohabitant of this house. She's an anthropologist, Marianita?

[00:59] **Marianita**: Hello and yes, I'm an anthropologist, specialized in the urban field. And, I'm also, interested in listening and talking about dwelling and maintenance.

[01:12] **Marianita**: And maybe we can start by where we are, here.

[01:16] **Marianita**: Henry, where are we?

[01:17] **Henry**: Where you guys live! Yeah, I've been staying here for a week now.

[01:22] **Henry**: I guess we could talk about how we got here.

#### Meeting at the Interdisciplinary Maintainers III Conference

[01:24] **Bernardo**: How do we know each other?

[01:25] **Bernardo**: So we met, we met in October, in a conference that took place in Washington. And we were invited to support the Maintainers III, which is a network of people trying to promote different fields to change.

[01:40] **Bernardo**: I was invited because I am co founder of MAMA, which is a practice that's trying to put the maintenance as a major point in the conception, production, and caring off buildings.

[01:53] **Bernardo**: And you, why were you there?

[01:55] **Henry**: I guess someone invited me. I wasn't a speaker though, so I just attended.

[01:58] **Henry**: I mean, we call ourselves maintainers in software, and then there's a conference called the maintainers. Like, why wouldn't I want to go to that?

[02:05] **Henry**: When we were there, I met up with people that were librarians, archivists, people that manage buildings, civil engineer's, like all these different people, right?

[02:16] **Henry**: It was just good to be able to hear from people, even though I didn't understand a lot of what they're saying. I mean, I'm sure it's the same for them in our talks.

[02:26] **Henry**: It was good to start that conversation. I don't know how we ended up meeting, but we hung out after the conference.

[02:32] **Bernardo**: So we had the chance to walk around Washington together, probably the only museums we had to pay for. And I said to you, let's keep in touch.

[02:41] **Bernardo**: And I invited you to come to to Brussels because I knew there were some interesting conference going on and you came, it was great.

[02:50] **Henry**: Yeah. I went to Sustain Open Source. And then FOSDEM.

#### Bosch, a Co-housing project in Brussels

[02:55] **Bernardo**: And then you find yourself in Bosch.

[02:58] **Henry**: In Bosch! Yeah, what is..

[02:59] **Bernardo**: Bosch is a house situated in the center of Brussels, in quite popular area called Marolles. In 116 tanneurs street, Rue des Tanneurs.

[03:12] **Bernardo**: We've been living here it will be a year in. It's a building shared by five adults, three kids. We have in the ground floor, it's basically 170 meters. We have installed a kitchen and we use it daily and we open to others to develop their own activities.

[03:31] **Bernardo**: Always looking for people that are close to Brussels or close to our habitat and non-for-profit, basically.

[03:41] **Bernardo**: So for example, we have people offering sewing courses or people doing yoga or people doing cooking or just small events. They come from the neighbors or friends or people living nearby.

[03:55] **Marianita**: And upstairs we have two floors, five adults and three children, plus a guestroom where Henry was invited to stay and there's office space.

[04:07] **Marianita**: So we're living here. And what's interesting connected to the topic of maintenance is that we've been.

[04:15] **Marianita**: We were looking for a place like this, where we could share common spaces between different adults. So this space had been used and lived by a couple that was having the shop in the ground floor.

[04:31] **Marianita**: Three-generation have been living upstairs and working downstairs. And downstairs was a Bosch store. And we got access to this place by negotiating with the new owner.

[04:44] **Marianita**: We've been inherit, let's say, we've been getting access to this place when it was still full of object that didn't belong to us, but to the old family. And the first step was to kind of, wait them to empty it and then start to live in.

#### Inhabiting as the Best Form of Maintenance

[05:01] **Marianita**: And that's maybe one of the starting points, of not only this way of living in a community, but also the idea of trying to invest spaces that otherwise maybe left empty for a certain amount of time.

[05:16] **Marianita**: And it is one of the basic actions to maintain this building, the fact of living in them.

[05:24] **Marianita**: Maybe one of the arguments that is at stake when you address maintenance, and architecture, and dwelling is the fact that inhabiting is the best way to maintain a building alive.

[05:37] **Henry**: One way of living would be just make a new building..

[05:40] **Marianita**: Exactly.

[05:41] **Henry**: And live there, especially if you're moving in. Yet you're not from that area. And I guess what you're saying is that this place maybe would've been abandoned or maybe the whole thing would've got destroyed and then you make a whole new building.

[05:52] **Henry**: But instead you're saying ok, we want this to still be here and we want to transform this space into a place where we can maintain it.

[06:00] **Marianita**: And it's even important when you link the effect of maintaining in with the environment. For example, nowadays, when you're concerned with environment, the building process is one of the most polluting processes.

#### Learning to Better Inhabit What is Already Built

[06:12] **Marianita**: So on the planet, we don't need to build more because we already have enough space. Or at least the space we have, we're not using it fully.

[06:24] **Marianita**: So one of the first steps that has to be done is to claim the fact we should inhabit better what is already built, instead of building other things. Maybe give up some of your standards, some of your comfort.

[06:42] **Marianita**: It's connected with the fact of claiming that maintenance is an engaging practice with the environment.

[06:49] **Henry**: Right. And it's a practice because we're not just saying that we care about maintenance but actually you are living in there is one way of..

[06:59] **Marianita**: maintaining.

[07:01] **Bernardo**: Well, it's a building that has around 70 years old. The life expectancy of buildings today, how they are designed, is around 50 years. But we are a far bypassing that age.

[07:15] **Marianita**: The building that we expected to not be livable anymore, they still are. So we are going beyond the life expectancy of the constructed buildings.

[07:26] **Bernardo**: So we build up the buildings to last 50 years, and in reality they live 100. So this is the case of this building, probably when it was conceived and built, they didn't have these in mind.

[07:37] **Bernardo**: But the buildings that are installations are working, of course, there have been maintenance going on, but there's not the structural problems. The windows are single pane.

[07:46] **Bernardo**: I mean they're updates that they can come with them, but basically it's like a baby because you will need more, more attention. More attentive to eat.

#### Proactive, Responsible Relationships with a Space

[07:55] **Bernardo**: I think as as an inhabitant, we start to develop a different relationship. The contract that we have with the owner is that we are looking after it.

[08:04] **Bernardo**: So we are responsible of it. It's not like every time there is a problem, we just call him and he come and he will fix it. So we, as the people responsible, it just makes us aware and attentive of issues. That they can take place and we have to resolve them.

[08:20] **Marianita**: Also is putting us in a very different relationship with what is already there. For sure I'd say the color of the wall is not what exactly what we wanted, or maybe the the kind of pavement is not what we expected, but you learn how actually you can deal with all elements.

[08:40] **Marianita**: Also the classical configuration of the house. Not nowadays, but the ability that you have as a dweller to update, to change, to transform, to take care. It's a big freedom that we're giving to ourself because this is not what is happening in most cases in which people are renting spaces.

[09:00] **Marianita**: So our special condition here, is also that we agreed on the fact that we would have a proactive interaction with the building space. We can't transform it completely.

[09:14] **Marianita**: It wouldn't make sense for us because it would be an investment that is out of our pocket. We're not going to stay here forever, but we are asked and we're free to interact in a more direct way than we are normally able to do with the rented space.

[09:32] **Henry**: You could say you're giving up freedom or comfort, but maybe you're learning to adapt to the current building, but that's not necessarily a bad thing.

[09:40] **Henry**: I think a lot of our modern lives is about, we always get what we want. Oh, I want this to look like this, you can just buy it or you can get a new thing.

[09:49] **Henry**: But here, okay, let's deal with what we have. And at the same time, because you are empowered to care about the house, then you're willing to change things.

[09:59] **Henry**: Maybe other people, they only think of their house in that way. You might need certain skills to take care of it, but also like the mindset change, right? Of like, Oh, I can actually do something.

[10:10] **Marianita**: Exactly.

[10:11] **Henry**: We were saying that like, a lot of people, they don't even touch the house. Maybe a lot of us treat our houses like a hotel. It's like you just go there and you sleep, and you go to work or something. You're saying it's like a baby, feels like a personal relationship, right?

[10:26] **Marianita**: At least in the last fifty years, we're not used to be asked to have an active relationship with the environment and with our home. We are more asked to respect what is there and so we're asked not to interact with our home.

[10:44] **Marianita**: That was happening in Europe in the majority of social housing. And the owner is asked to have standard houses that he can put in the market of renting. So this kind of situation are completely at the margin of what we can see nowadays.

#### 7 Floors, 70 People

[11:00] **Marianita**: But how did we arrive here Bernardo? What came before?

[11:05] **Bernardo**: It was a bigger house, not so far away, but it was a house built after a particular political and social movement here. And they managed to open a seven office building with an indeterminate contract with a small group of militant immigrants in the city center of Brussels. 11 years where 70 people live.

[11:29] **Henry**: A lot of people! 7 floors, 70 people.

[11:33] **Bernardo**: Very open to many others to passby, stay and profit from that sort of a common ground.

[11:42] **Marianita**: It was a bit like if we would replay our situation here, but in seven floors, because each floor had it's bathroom, kitchen. We were not allowed to have, for example, private kitchen. And then at the ground floor, there was a big, big common space.

[11:59] **Marianita**: And it was not only the inhabiting way, but it was the whole structure. This community of 70 people that has to work somehow and has to be maintained every day. And so we have a lot of meetings, a lot of discussion.

[12:13] **Bernardo**: Yeah weekly.

[12:14] **Marianita**: And in that case, the diversity of people was incredible. I think it would be difficult for us to experience another situation in which we would live with so many different people at the same time.

[12:26] **Bernardo**: Yeah, because half of them, you will never even talk to them in your daily life. Like we have people with mental issues and with drug problems but as well elderly people and families, a few people coming in from the upper class, educated. It was extremely mixed. It was a great..

[12:45] **Bernardo**: Well, again, it's very strange to have meetings when you have such a spectrum of people coming together to talk about, we have to clean up the staircase, you know, and you have all the people that are going to express themself when, how things are going but at the same level.

[13:02] **Henry**: Kind of reminded of like a school or a college dorm, but completely that's not the same at all. Because you might not even talk to the people next door, even in just a normal apartment, right. You don't even know who your neighbors are. But in here, you got to work together to do these mundane tasks.

[13:17] **Henry**: But I think that even with the roommate situation, you have to figure out like who's going to wash the dishes and take out the trash. Cleaning the bathroom. Like those are all things where you do have to set up some kind of governance structure that might not be so explicit as an actual government.

[13:34] **Henry**: But it's like, certain kinds of rules or norms or some way of coordinating, like who's going to do what? Without it turning into like, you need someone else to tell you how to do it or you need to pay someone to do it, everyone just volunteering to do this together.

[13:46] **Bernardo**: It takes time that you could be using for work or to look after your family.

#### What is Comfort?

[13:52] **Bernardo**: I think that's when Marianita was mentioning us about the comfort, no?

[13:55] **Bernardo**: What is comfort? Because all of these interactions seems to be pushing us away of what is considered as comfort in our society. I hear like sugar and fat. They are two things that the body never gets enough of it. And I think comfort is a bit the same. Many people, I don't know, when would we have enough?

[14:14] **Bernardo**: I mean, my father sits in front of the sofa watching TV and I think that's for him, like the ultimate comfort. When I see him and I.. that's not really what I want to do with my life.

[14:25] **Bernardo**: So I think the home unit.. We had constructed housing around two persons, a father and mother and two kids. And that's the nuclear family unit. And every nuclear family needs to reproduce. Like it needs to be autonomous in the system, they have to clean in the house. They have their own washing machine.

[14:44] **Bernardo**: And they have their own ways of transport. But now we have cab sharing. But I think that maybe that's a good example to how we are reconfiguring, redefining comfort. That maybe there are more important things than having our own cars.

[14:58] **Henry**: You can say like, what is the purpose of a home? And most of us would say like some level of comfort. When I go home, I want to feel that, unlike at work or outside in a public space, having a private space.

[15:09] **Marianita**: What experience taught us. The fact that actually we are maybe in a moment of society in which this idea of comfort is changing, changing because we understand that comfort made us isolated.

[15:23] **Marianita**: There is something lacking in this community. I mean, it's always complicated to share. It's always complicated to get organized. It's always complicated to coordinate. But is what makes us human, social animals. I guess that's one aspect of it.

[15:43] **Marianita**: This kind collective housing, which is maybe better than community. Because collective housing are giving you another kind of comfort, which is the effect of being part of a group. And the group can be very energy taking, but it is definitely something that is connected with giving you the comfort of knowing where you.

[16:05] **Henry**: Belong.

[16:06] **Marianita**: Maybe not belonging in a certain sense of identity, but the fact of existing with others.

#### Outsourcing Dampens our Sense of Curiosity

[16:11] **Bernardo**: When we have people that clean our house, make our garden, look after our children, come to fix the leaking in our tap. Those are things that they're pushing us towards the definition of comfort that we have today, but it's pushing us away from layers of understanding our close environment. That's a bit strange, no?

[16:32] **Henry**: We're paying people, which is good in some ways, but then you kind of take everything for granted. So you kind of don't appreciate even how hard it is to do these things cause you don't do it yourself, right. I think a lot of times you learn through experience.

[16:46] **Henry**: That kind of makes me think, it almost like kills your sense of curiosity maybe. You know, when you're learning, if you like it, you'll want to learn about it more. If you did learn how to cook and you started watching YouTube or reading books and actually experimenting in terms of cooking, then go out to eat, that's like something you turn off on your brain. Or like how do the systems in your house work? Like the plumbing or electricity.

[17:07] **Bernardo**: The materials that you are using. Like what happened when you get tomatoes?

[17:11] **Henry**: If I want to tie it back to coding... Just one point about that.

[17:15] **Bernardo**: Oh naw, come on, not again.

[17:18] **Henry**: I love it. This is related to using open source and not understanding how it works or not giving back. It's good to have a level of abstraction where it's like, I don't need to know how it works. But at some point, it kind of prevents you from understanding the world better.

[17:35] **Henry**: It's kind of like knowing how to drive a car and versus knowing how to fix a car or understand how it works. I mean for majority of people, yeah, you don't have to know. But then once it breaks, now you're reliant on it. And not that we have to do everything ourselves, but I think there's a certain sense of freedom when you do know.

#### Right to Repair: Freedom vs. Independence

[17:51] **Marianita**: I think that there is a difference between freedom and independency. And modernity have, as an ideology of progress and of definitely comfort, have been pushing us to think that the best is to get rid of problems, cooking. Yeah, outsource whatever you can outsource.

[18:15] **Marianita**: And actually this is definitely the opposite. This makes you so depending on resources with which you can pay these outsourcing process, that actually, you become much more dependent. So I think that's another empowering process connected with the idea of being able to maintain things that you need, or just understand what's behind and learn again to take care directly of certain things.

[18:46] **Bernardo**: Recently we had the "right to repair" approving in Europe. I know in Canada and the States, it's already there. This is meant to change the way we produce electronics and the way users interact with electronics. So I think it's something like, they have to provide the manuals that allow you to understand the objects and have the elements that allow you to replace during 10 years, those objects.

[19:12] **Bernardo**: Which is funny that they do that now, but giving you like guidelines to the inside of something that you own basically, but that then they are helping you to understanding better. And that is something that they didn't allow you to do before.

#### "First of all, do not touch"

[19:24] **Bernardo**: I have these, quotes from our friend. Well many, many people go through this situation. They call an a specialist, and the first thing that the specialist said, first of all, do not touch it. I think with homes, it's a bit the same, no? You have all these elements and we have very little knowledge to interact with it.

[19:47] **Bernardo**: It's funny how architects, we are so focused in the penny sash. How do you say that?

[19:53] **Marianita**: In the opening? The opening of a new building?

[19:56] **Bernardo**: Yeah, when you see images of buildings, you know, they don't show you the building in 30 years. They show you the buildings brand new, shiny..

[20:04] **Marianita**: That will last for one day. If it will exist, it will exist only for one day.

[20:10] **Bernardo**: So an architect now, they focus on much in that early age of the building and that condition, how the buildings are conceived. So we will be looking more for buildings that actually need to be cared of. And we had this in consideration during the conception process, making more easily those building to last.

#### To Live it is to Understand How it Works

[20:29] **Marianita**: Yeah. In the practice and belief of talking about the professional part of the story. I think one aim is to empower the dwellers actually, in order to make them understanding the system in which they're living and to give them the tools and the knowledge to interact with it. And this is what is happening in other fields, with technology.

[20:57] **Marianita**: But is it is not happening with the built environment. It's paradoxical, but you have some starting experience that in public space with the help of people. But it would be even more evident if we were talking about housing because you own or you rent a space. To live it is to understand how it works. And we're completely passive at the moment about that.

[21:22] **Marianita**: And to go back to coding, which I'm learning so many things on a topic that. It's completely unknown for me, but I think it is exactly the same. We don't know how much maintenance there is behind it. And that's exactly the same for architecture and housing.

[21:45] **Marianita**: We deny completely the dimension of taking care the space we live. In a daily scale, we don't make it visible. We don't look for it. Depending on if they are a planner or if we are just citizen. So it's this blurry part of life on which we all depend. And so I guess it's exactly like coding. That idea of making clear that there are maintainers behind all that.

[22:14] **Marianita**: We should all acknowledge this. That we produce things. We produce different goods. We produce different, tools that are part of our everyday life. But actually they need to be maintained. And there are people doing this everyday and we don't know that.

#### Code as Archeology: Who wrote this? Oh I did..

[22:33] **Henry**: We just pretend that time's like still, I guess, right. The coding thing is interesting because I think digital makes you feel like it will last forever.

[22:45] **Henry**: But we had this concept of bit rot. You know, I'm talking about bits, binary. Code can rot too.

[22:52] **Henry**: Obviously the code is still there, but it's more metaphorical where it's like, the people that work on that code will over time, not know how it works.

[23:03] **Henry**: The typical example is you look at this code, and "who wrote this, this is really weird?" And then you look at it as like, Oh, I wrote it like a year ago.

[23:12] **Henry**: Or they change your job or are they retired and they weren't able to pass down the knowledge to other people. And that's why I kind of say that code becomes archeology; you're trying to figure out, like the bones of the code and trying to figure out like why did they write this?

[23:26] **Henry**: And so I think as our society becomes more technological, we still think that the code's going to save us, that it's all timeless.

[23:35] **Henry**: But we need to look to the physical and be like, okay, everything will decay. Everything will die and maybe we just need to acknowledge that lifecycle, like life, death, and this process of restoring.

[23:47] **Marianita**: So I have a question for you because this idea of restoring. I mean, I think the code question can learn from the architectural one, in this aspect of knowledge that is lost. So that's what we face with buildings that have been constructed, hundreds and thousands of years ago.

[24:10] **Marianita**: And then we have this ecological approach, definitely because we don't have anymore, even buildings constructed 100 years ago, which is nothing for a generation. We lost the knowledge, but we want to preserve the building. So we have this process of heritage. We want to value the heritage, but we forgot to conserve and maintain the practice.

[24:36] **Marianita**: So now in architecture you have somehow a renewal of this kind of old practice of construction. So I think maybe coding can look at what's happening there, and I don't know, a parallel can be..

#### Was Code Better in the Old Days?

[24:52] **Marianita**: But my question is for you, Henry, do you have in the field of coding, do you have sometimes this impression that before it was better? Are you already there?

[25:06] **Marianita**: I mean, did you already get at the moment in which you say, ah, but actually the old way of coding had something that now we were losing?

[25:15] **Marianita**: And that the reverse, the opposite. Are you in a progress mind frame? Are you always improving, this idea that what is coming after is going to be better or more perform?

[25:26] **Henry**: That is a really good question. I don't know.

[25:30] **Henry**: I wonder if it's controversial to think it's no, but I mean, you could say, maybe this is true of a lot of things.

[25:37] **Henry**: Yes, it's better in certain ways and worse in other ways. I even remember, there was a talk that I saw.. People are discovering papers that people have written from a long time ago and seeing how they were doing programming.

[25:51] **Henry**: Oh, we went in this other direction and we need to go back to this other thing. People are making new programming languages all the time. It's kinda hard to say.

[26:03] **Henry**: And also there are more and more people becoming programmers, but that doesn't mean those new programmers are thinking about programming itself as much. They might be just the practitioners where they're writing the code and they don't really think about why, I mean it's true for anything, right?

[26:18] **Henry**: It's like when you get started, you're just doing it and then eventually you're like, Oh, why am I doing it this way? Maybe we start questioning, you start thinking. Of course there's that momentum to where it's kind of hard to get everybody to just be like, let's stop and go back. All the other people are trying to push the edges.

[26:34] **Henry**: I feel like I could go in and a lot of different directions for this. Yeah, in some ways we are making it more complicated and you could say that's a bad thing because it's making it harder for new people to get involved.

[26:46] **Henry**: We keep.. Going back to this idea of abstraction, it's a term of adding layers, so like abstraction can be a good thing because it allows you to focus on the thing that you care about without caring about the other things.

[27:00] **Henry**: Of course, that's just a lens on which to view things. So kind of like, Oh, I don't need to know how to the car works. I can just know how to drive it.

[27:09] **Henry**: Perfect example with code is, every dependency I add, I don't need to know how this thing works because someone else wrote the code to do it. And then that person wrote some code that depends on that, that said, I don't even know how to do that.

[27:22] **Henry**: And now you have this giant tree, we call it a tree of dependencies that goes all the way down. You don't even know all the things are you're using. You just know one level down, right. Maybe you don't even know that.

#### House of Dependencies

[27:34] **Henry**: You could say that is like a house of cards kind of thing. I mean, that's the cynical view.

[27:39] **Henry**: The other view would be, well, isn't it great that I don't have to rewrite everything?

[27:43] **Henry**: Lego blocks, I can just use what other people have done and I can just focus on what I think is important. Maybe I just want to make a website or make an app. I don't want to learn how to make all this other stuff that was there so that it would be like positive way of looking at it.

[27:56] **Henry**: All these people have made important things that I can use, especially if it's open source, I don't have to make it myself. I don't have to start over from scratch. But the tradeoff is that you don't understand it. So then if there's a problem, how are you going to figure it out? And you're can ask that person.

[28:13] **Henry**: If you have to do everything from scratch, then you're going to understand everything. But you might not be able to quote unquote go as far. But what does it mean to like go as far? So I think it's a complicated question. I don't know if that answers that.

[28:28] **Bernardo**: I have another question, actually. For Henry too. Yeah, sorry Henry.

#### Invisible Labor is Perceived as Unaesthetic

[28:33] **Bernardo**: When we were talking about the sort of invisible labor, seen in more domestic contexts or architecture, they come from aesthetic perception.

[28:41] **Bernardo**: That means when you are, for instance, renovating a building, you will cover this renovation with a textile, with a fabric, instead of maybe putting in front the work that has been done to keep this healthy.

[28:55] **Bernardo**: This happened with historical buildings. And in home is related to the tasks that they are like clean-. People are not proud of cleaning your house, you know, or things that can have like social negative perception.

[29:09] **Bernardo**: And I think that's partially why we have this certain shame that comes with it. And we tried to keep it hidden as if those things are not really taking place. So this social perception, I think greatly has a lot of responsibility in how we approach the subject.

[29:25] **Bernardo**: And I wonder, because the cleaning ladies, they have low wages, no? But software people, they have big players. So there's both of them, they're invisible, but they find themselves in completely different sides of the economical spectrum.

[29:38] **Bernardo**: So I wonder, do you think that there is a part of the world of coding that comes with shame? What is responsible of not valorizing those processes, basically?

[29:50] **Henry**: So you're saying that like, when you're making buildings, you put a picture of what the building will look like?

[29:57] **Bernardo**: Afterwards. I'm talking about a historical building. I've been in that's been there for 200 years. So today you have been to the Grand Place, the major touristic attraction here in Brussels.

[30:08] **Bernardo**: And one of the buildings, it was covering with scaffolding and in front of this scaffolding, they sell the printed version of the building that is behind. So this is basically to sort of camouflage that there's a process of looking after this building.

[30:23] **Bernardo**: We don't want the tourist to understand that this approach is a human process. We don't want to make the picture disturbed. Instead of saying, this is actually part of the building itself. It's architecture, it's part of the architecture too.

[30:37] **Henry**: Right. We want to make it look like it's always clean.

[30:40] **Bernardo**: Always new. Forever new. Yeah. It doesn't age. This is timeless. This is related to like more of the how a building look like.

[30:50] **Henry**: How a building learns.

[30:51] **Bernardo**: Yeah. And the other one is more related to how we hide.

[30:56] **Henry**: Everyone puts all their stuff in like a closet or something, right.

[30:59] **Bernardo**: Yeah. Whenever we have guests coming, we will arrange the house. Very quickly. Because there are things that we are not proud of. I don't know if we have to be proud or not. But this sort of hiding. What it says about us, hiding these mundane tasks. And I wonder if coding, there are things like that.

[31:17] **Henry**: Yeah, that's good to think about. Are there things like that? I mean, there are definitely tasks that you might consider like cleaning. We have a term called refactoring, which is where you want to change the code. That it's more easily understood.

[31:33] **Henry**: One example is like, when you're writing your code, you have names for your code. And so you could name every name, we call them variables, ABC or something.

[31:41] **Henry**: Or you could describe like, Oh, this is the number of wheels on a car. Something like that would be more descriptive than just saying it's A. Like, I don't know what is a right.

[31:51] **Henry**: So refactoring is a process of structuring your code, essentially cleaning your room. So it's more organized, but the code doesn't do anything different.

[31:59] **Henry**: So we execute the code again, it's supposed to do the same thing, so it's literally just cleaning your room. So that's a task where it doesn't make you any more money. It was working before, right? You didn't change the output of the code. All you did was organize it.

[32:13] **Henry**: So it's like a long term task. In the long run, if you don't do that, then it's just going to be messy. You have this deadlines. Every time you add a feature, it's like a Frankenstein. You're like adding more and more parts to it that probably don't interact with each other in a way that makes sense. And so refactoring tasks help you to kind of clean up stuff.

[32:33] **Henry**: I think that depending on your personality though, some people like doing those things. I like doing stuff like that, fixing bugs, just like cleaning up stuff rather than having the features. Some people like writing new code from scratch, other people like modifying existing code.

[32:52] **Henry**: But if you're talking about open source and like covering up stuff or we're doing everything in the open. So I guess in some sense, part of the whole point is I want people to know that we are working on it in progress, in the open.

[33:05] **Henry**: And you're trying to overcome, I guess the sort of shame that you might get when you're first getting involved in open source. You're really scared cause you're like, well hundreds of people can see it. It's all in the open.

[33:16] **Henry**: And then once you're the maintainer and you're like, I want everyone to see it. Cause I want them to know that we're figuring it out too. Even though we're the expert, we're still figuring out as well. I want that to be learning in public sort of thing.

[33:29] **Bernardo**: Yeah. I guess open source is actually making the opposite, making the maintenance of it the front line, by exposing all of this.

[33:37] **Henry**: I think that's where we have to talk about like boundaries and stuff, but yeah, we don't allow anyone to contribute whatever they want.

[33:44] **Henry**: You know, when someone hasn't been approved that anyone can make a change, like a request to make a change, but someone has to kind of supervise.

[33:52] **Henry**: If everyone just was allowed to do whatever they want, then you kind of need someone to understand the whole system and be like, Oh, does this fit into the way that this thing works?

[34:01] **Henry**: Like the philosophy or the mental model, or the theory behind this thing. Maybe we ask them to change their change so that it fits better with how we're thinking about it. Or maybe we need to think it that differently.

[34:14] **Henry**: Everyone's coming in with their own view on how things work. Maybe they don't have a lot of experience. But talking about it does help all of us to better think about how do we think about these things?

[34:26] **Bernardo**: It's like a cohousing.

#### Future of Bosch: A Space Dedicated to Collective Domestic Activities

[34:28] **Henry**: I question I was going to ask, what was your vision for the future of this space? And how long did you stay in the other..

[34:35] **Marianita**: So it means, you might be like three, three and a half. And for me a little bit less. That experience lasted for 11 years and it's exceptional in Brussels, this kind of autonomous self, organized community in a occupying a building and claiming the legality of it. So it was, a very, very interesting and exceptional experience.

[34:58] **Marianita**: But before coming here, we didn't want to go again to such a big, big community organization, but we were thinking about more around like 20 people and it didn't happen. We didn't manage to convince mainly public owners that we could occupy some available buildings.

[35:18] **Marianita**: So we went to see this private owner that we knew, and we propose him what we're doing now here at Bosch, so we have an agreement for two years.

[35:33] **Marianita**: We hope we will manage to extend a little bit because we didn't talk about time, but time is what replace money in all this, story. So you'd take the time to do things yourself, which means that you invest time instead of investing money, outsourcing, as we said before.

[35:53] **Marianita**: So time is an important element. We can't do all these efforts for, let's say, a few months, occupation of a building, you know. What we can say is that for the next year, we want this to be running in a more, smooth way. Cause it will be the second year.

[36:10] **Marianita**: We have this ground floor that we want to be available for the neighborhood to be used. We prioritized the idea of a neighborhood space, and it takes time. It takes time to be known, it takes time to be identifying, takes time to get in contact with people. So it's all a matter of time actually. It's not a question of big struggle. It's a question of being patient.

[36:35] **Marianita**: We've been targeting activities that we wanted to be Intergenerational because we have children and this is, something very, very important for us. It goes in the same direction on things we said before, but we wanted this space to be a space dedicated to domestic action and practices, of which we forget the collective dimension.

[37:01] **Marianita**: You know when you clean your room, as you said, when you wash your cloth, or when you clean up, or when you have some holes in your socks or whatever, when you have to clean your shoes, these are actions to which we maintain our own goods and our environment and things that surround us.

[37:20] **Marianita**: And we forget to do them or we forget that they can be collectively done. And it's much more fun. And it's much more interesting because each of us as his own techniques and we can learn from each other. This was one of the main aim of what we wanted to propose downstairs.

#### Valorizing Repair as Moments of Learning

[37:38] **Marianita**: There was also the idea that, of course, other people could come with their own needs and their own ideas to use the space downstairs. But there was this idea of putting energy into re valorize, give a new value to this kind of action that we tend to marginalize in our own life, you know.

[37:57] **Marianita**: Nobody's happy about having to repair socks or to clean up, but they can be moment of talk, moment of exchange, moment of celebration, moment of being together, moment of learning.

[38:10] **Marianita**: So that's, again, something connected with maintenance, with empowering, with re establishing relationships, and kin somehow. So we can just hope that all this is going to be running maybe with a little bit less of our efforts. But just because we also want to maybe diversify things.

[38:32] **Marianita**: Now we start to be able to count on other people doing yoga, doing sewing classes, doing parties. People come and proposes, Oh, let's do crepes, let's do pancakes, because it's the day of the pancake. So that's, I think what we hope for the future.

#### Self-Managed, Informal, Shared Spaces

[38:50] **Marianita**: And maybe the next step would be.. When we will have to move, maybe that should be a more, stable move. I don't know. I don't know. Do you want to make a stable move?

[39:02] **Bernardo**: I think for me, be a good example of a practice. How this habitat, how this shared domestic space is an added value to the cities. And make strides to make sure that public figures as well as private, they see the value on it and they make more easy to other initiatives to take place around the city.

[39:23] **Bernardo**: I think there are already things going on, but the, normally this is a, it's a lot focus, semi-professional environments. Is not so much of people self managing themselves.

[39:35] **Marianita**: Cultural center, or a sports centers, or arts activities. It's less about self managing spaces that are also open to the public.

[39:46] **Henry**: Kind of just go in and come out, like a club.

[39:48] **Bernardo**: Replace a bit the owner, things are far more formalized. So for us, again, this informal aspect is important.

[39:55] **Henry**: We were talking about before this, but I was gonna ask about like, how do you fund the space? So this is free for people to use. They can sign up to do like, you know, sewing. They don't have to pay, you're not asking for anything. Right?

[40:09] **Bernardo**: They have not asked for any money. We have workshops where they suggest a payment, for example, yoga. And yoga says you have to pay minimum one euro.

[40:20] **Henry**: So it's like pay what you want then?

[40:22] **Marianita**: Yeah.

[40:23] **Bernardo**: And we've had self defense courses that was two different days in two weeks. They suggested euros.

[40:30] **Henry**: You're not trying to like grow this thing into like..

[40:32] **Marianita**: No, I mean this is definitely not for profit, right.

[40:35] **Bernardo**: For us, the objective is more like, okay, we want people to benefit from it, but there is not a business model.

[40:43] **Marianita**: And we are the.. The dwellers are paying the rent. So we do pay a rent to the owner. And in this rent, we negotiate the fact that it had to be the lowest we can. I mean, the lowest he can (laughs) .

[41:01] **Marianita**: Because we knew we were going to invest a lot of time in the management of the downstairs space. So this was the idea. So we said, okay, we want to live in the first and second floor. We want to do a community neighborhood space downstairs. This will take us time.

[41:22] **Marianita**: We want that to be for free, so our rent must be the lowest we can. And that's also way to involve the owner as a partner somehow in this vision of a common space that is open to the neighborhood. And then the activities that we host can suggest a small price.

#### The Shared Interests of All

[41:45] **Marianita**: And that's the other important thing that maybe is very different from the US, but we managed to have some little budget from the municipality because we propose our idea or project for the downstairs, and they found it interesting.

[42:01] **Marianita**: And there was a call for citizen initiatives that are promoting the neighborhood life. So we apply and they gave us a small budget that we can use for the different activity and the different workshop.

[42:16] **Marianita**: So you can see that there are some kind of work with them in converging interests. Somehow the interest of the owner in maintaining this place, the interest of neighbors in having this place, our own interest in renting a space with a small rent and having these activities downstairs, and also the interest of this city hall that is looking for initiatives of this kind. So we can see the things are moving that sense.

[42:49] **Marianita**: But we were the only dwellers proposing a domestic space, for example. The other initiatives were more like sports or arts or culture or whatever. We were doing only one proposing to share our own. They were NGOs or other form of officialized group. So we were the only one not having this kind of structure.

#### A Message to the Neighborhood

[43:15] **Henry**: Yeah. I like how on the windows outside, you're writing down what are the activities, it's like for local people that live here and they can just see it. You don't have to post on social media.

[43:28] **Marianita**: That is maybe interesting for the podcast. This decision that we made, it was very spontaneous. But at the end, we claim it somehow the fact that we would not use. So the idea was that we would promote our activities only using the windows of the space, because this for us was a way to be more or less sure that we would address people of the neighborhoods. Of course, we also sometimes sends emails.

[43:56] **Bernardo**: Thanks for coming, Henry. Super nice to have you around.

[44:00] **Henry**: Yeah, thanks for inviting me. I mean, I stayed for a whole week. Everyone's like, Oh, you could go to some other city or live in a hotel. I saw a lot of activities that were being done: the sewing, people walking in, people just looking at the windows.

[44:14] **Henry**: And also just like when we were walking on the street and you just met like 5 different people that you knew. You just actually are a part of the community. So it's making a big impact.

[44:23] **Marianita**: So when, when are you coming back?

[44:28] **Henry**: Next year?
