---
title: "Essence (Sonya Mann)"
season: 3
date: "2021-02-18"
time: "44"
description: "How do we think about ourselves and the communities we move into? Sonya Mann and Henry continue a chat about the nature of conversion: about using jargon within a community, individuation, and transformation. Topics include the tools of a worldview, flavors of faith, the good of questions, essence and discovering yourself, hierarchies of reality, interwoven histories. (Recorded in September)"
episodeLink: "5f70514f"
embedUrl: https://share.transistor.fm/e/fbe0cd82
sidebar:
    order: 13
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/essence.md)

#### Microsoft Word as Worldview

[0:00] **Henry**: So the context is if I want to join some kind of group and they're a lot older.. It's sort of a stereotype that they might not understand technology. They're used to a certain workflow that everyone is accustomed to. This example was that using PDFs are better than just having a website and using search in Word is better than using a search in the browser.

[0:20] **Sonya**: It's like they've been using Word for presumably decades. Word has been around for decades at this point, right?

[0:25] **Henry**: I guess so, yeah. 

[0:27] **Sonya**: Which is kind of a wild thing to think about on its own. It's a familiar tool. And, you know, I think this does actually have some echoes in.. Like the concepts that we use to understand the world. And I somewhat recently went through this big shift in what my like default concepts that I was reaching for were. And it almost like changes the shape of how you see the world.

[0:52] **Sonya**: And it's sort of like if you're using a Word document, or you're using a PDF, or you're using a website, the underlying text may still be the same. But your way of engaging with it, the tools that are readily available to you.. Like you were talking about how it was an unselectable PDF, so you couldn't like copy paste a sentence easily. And once that capability is available, you have a new way of interacting. You could like easily put together, like here are my favorite quotes or something. And that is not necessarily possible before. 

[1:24] **Sonya**: And I guess I see a parallel there in going from my atheist worldview to kind of not fully worked out Christian worldview. It's like I have different mental tools available or mental constructs or something. Do you feel that way, that the concepts kind of shape how you see things?

[1:44] **Henry**: Yeah, for sure. You bring up the atheist worldview. I don't know what that is anymore, because there's a difference between knowing what it looks like on the outside, like as a third party. Even if I did feel that way in the past, I haven't been immersed in it. The inside experience and outside experience, they have different lenses into reality. And even the same words have different definitions, right? When we say like, Oh, you're my brother or sister, you don't literally mean that. You just mean like spiritually and you have to know that within the context. 

[2:15] **Sonya**: I think I brought up last time that.. I've always been kind of immersed in like the vocabulary of Christianity, just because it almost like suffuses through Western culture. And, you know, I've read a lot of books. And it's funny, I mentioned on Twitter, not that long ago, that the Bible is the most important book in the Canon of Western literature.

[2:37] **Sonya**: And I like that statement because it is maybe kind of a microcosm of this, that like when I say that, I both mean it in the kind of secular way that like this is the most influential book. This book almost like sets the conditions for all of the works that come after it in a number of different ways. And there's a sense in which this is completely accepted by secular people as well. 

[3:01] **Sonya**: But then I also mean it in a more literal way. Like this book, it's not just influential, but like it has the wisdom in it or something. You know, this is the *Good Book* as it used to be called. Maybe we should bring that back, we should talk about the *Good Book* more. 

[3:16] **Sonya**: I've always liked the good news as a way of talking about the gospel. So I mean, like this book is the priority, as well as this book  had all this influence, et cetera. And I mean, I could explain to a secular person I mean it this way, but there's the experience gap or like the assumption gap.

[3:35] **Sonya**: I don't know, it's your vantage point or something. You can only see certain things from certain vantage points. Kind of scary also. Like, what am I not seeing because of where I am, but that's actually one of the advantages of Christianity. It's kind of like one of the things that I want from it. And one of the things that Jesus talks about and comes up in other parts of the Bible as well, is like, yes, it shapes you and it's supposed to.

[3:57] **Henry**: Right. It's one thing to say, it's a bunch of like wisdom and you can learn some stuff.  It's like, we are becoming *born again*, right? The idea of transformation. But if you think about it more deeply, talking about baptism, going into the water and coming out, dying and becoming literally another person because you are a Christian now. It shows that it's not like just the quantity, you added some plus ones to some attributes if you're like a RPG character. The idea of like being holy, set apart, isn't just like times two, right?

[4:29] **Sonya**: Born again.. It has all these cultural connotations and I think that's one of the reasons why people shy away from it, but it's almost like.. It's so sincere. And I mean, we live in an age of irony, right? Like maybe every age is an age of irony in its own way, but I definitely feel like there's a kind of fear of earnestness of just like owning something. It's almost like being willing to be made fun of really, and I wonder if that's another reason why people shy away from the notion of being born again. 

[4:56] **Sonya**: You know, what it made me think of is, *washed in the blood*. Like that's a very visceral.. Makes me think of like Buddhist traditions. I'm not going to remember the name of the specific thing, but like where you meditate on the carnage of the hell realms sort of, but in a way that's meant to be kind of transcendent, like, yes, this is an aspect of the universe and I want to understand it want to dissolve into it in a way. And, I mean, there's some aspects of that Christianity too. Like some of the old Jesus on the cross images that really like try to go deep on the suffering and, you know, the angst and like the torture, cause I mean, being crucified is torture. 

[5:37] **Henry**: The passion, right? 

[5:38] **Sonya**: There are lots of different kind of flavors of Christianity or like focuses in how it's presented.

[5:44] **Henry**: The reason why we like talking to people is because we can hear from their perspective and maybe adapt or change our perspective. I think that's exactly what the church is supposed to be about, even though sometimes groups tend to emphasize the mental aspects of it more. How do we combine those two together?

> 12 Jesus entered the temple courts and drove out all who were buying and selling there. He overturned the tables of the money changers and the benches of those selling doves. 13 “It is written,” he said to them, “‘My house will be called a house of prayer,’ but you are making it ‘a den of robbers.’” - Matthew 21:12-13 (NIV)

[6:03] **Sonya**: Christianity has an almost inherent communal aspect to it. Like there's so much of what Jesus does is like engaging with his community in multiple ways. Going into [the temple and tossing out the money changers](https://en.wikipedia.org/wiki/Cleansing_of_the_Temple) is a pretty antagonistic way to interact with the community, but then you also have the gathering of the flock. And, I mean, that's something kind of interesting on its own. It's like these different modes.

[6:28] **Henry**: Yeah, that essentially God meets us where we are kind of thing. And I think that's really good to point out. He interacts with the crowds. He does miracles. But he also.. He'll meet the woman at the well. No one else was there, right. Or he'll go by himself to meditate. It's like all the range of you would say human emotions that he has, but he's also God, which should be mind blowing, but we kind of just take that as this random statement.

> kenosis: (in Christian theology) the renunciation of the divine nature, at least in part, by Christ in the Incarnation.

[6:51] **Sonya**: Was it you who mentioned kenosis? Like the emptying of godhead so that he can become a man and die? I frankly don't know what I think happens. Does Jesus empty himself of Godhead? Does that even make sense? Like I'm not sure, but I'd say it's at least an interesting notion. The idea that you'd have to like drain away all your power in order to physically die. I wonder about that.

#### The Legitimacy of Questioning

[7:16] **Henry**: Yeah, no, that's like an interesting theological issue that no one else cares about. I mean like, you know, that gets into stuff like the Trinity and there's been debates over many centuries right.

[7:26] **Sonya**: I guess it sort of exceeds my, I want to call it like my mechanistic thinking. If there are two entities, they're distinct and they can't be the same thing. But that sort of imposes.. For listeners, I'm holding up two objects. You know, these, in the physical realm, I can't make these be the same thing, but I don't think that God is necessarily restricted, at least not by that kind of physics. I sort of think that God is physics or that God like manifests physics. But I don't know if that means that God is like bound by the rules of it. 

[7:58] **Sonya**: See, this is what I mean when I say that like becoming a Christian again really like reordered my entire understanding of things. It's not like it's really important for me to settle this question of like what is God's relationship to physics precisely. But it's the kind of thing that now I have uncertainty about that I didn't before, because like, just this way of understanding the nature of the universe wasn't part of what I was thinking about. And now this kind of question is in my head. I don't know.

[8:29] **Henry**: I liked that. It doesn't have to be Christianity, but any view that's significant to you, it asks you to ask different questions. The pandemic has caused us to ask different questions that we did not have before. Or assumptions are challenged. Well, I guess one thing is that definitely increases the mystery of the world, right. And that could be a bad thing, but it could be good if you feel like it makes you want to learn more about it.

[8:50] **Henry**: And it's a hard balance of like, how far are we going to go to try to explain everything away? I think people would say something like, it's possible to know God truly, but we can't know him exhaustively. It doesn't mean we're grasping at straws.

> I was seeing the beam, not seeing things by it. Then I moved, so that the beam fell on m yeyes. Instantly the whole previous picture vanished. I saw no toolshed, and (above all) no beam. [Meditation in a Toolshed](https://thecultivatingproject.com/wp-content/uploads/2018/07/Meditation-in-a-Toolshed.pdf)

[9:04] **Sonya**: Yeah. That makes me think of the story about the elephant and all the blind men, like feeling the elephant. It kind of also works with CS Lewis. You mentioned the beam of light coming into the shed, you know, what do you think that light is? It's it depends on how you engage with it. 

[9:23] **Henry**: You're always looking at something and then looking from something at the same time, you can't pretend that you're going to find this objective, observer view. We're always within some framework, I guess. And that's the thing with the elephant. The only person that can claim it's an elephant is the person that is the objective view, but none of us have that. So there is truth, but I can only see it through my personal lens. 

[9:47] **Sonya**: That's what I believe also. 

[9:48] **Henry**: Which requires faith, right? That's the problem.

[9:50] **Sonya**: Yeah, that's another thing. There's a lot of hidden faith in lots of different worldviews. I don't want to single any of them out. I think it's almost inherent. I mean, a lot of philosophy in fact is like, where's the faith? Let's find the faith and try to figure out what it's doing.

[10:05]  **Sonya**: This is back a little bit. But the New Testament postdates Christianity, like the new Testament gets written and compiled after Christianity starts spreading and kind of because Christianity was taking off. I'm sure they were having like wide ranging, philosophical debates. Heresies get born. And the word heresy kind of assumes a lot. But hopefully, you know what I mean? Ideas that were declared to be heresies by the Catholic church eventually. You have early schisms. I'm not sure why I find this so interesting. Maybe because it makes me feel like it's legitimate to question.

[10:42] **Henry**: Yeah.  

[10:43] **Sonya**: I don't know, like you have those really early Christians who are just converted by like a friend of a friend telling a story. That's both wild to think about, like what kind of proof did they need or like, what was their epistemic threshold, I guess, for conversion?

[10:57] **Sonya**: What did it even mean to them? I don't know. And I wish I could know. But I wonder, you know, what kind of worldview reordering did they go through? And  we have some evidence of this from the documents that survived and from the Bible itself. 

[11:12] **Sonya**: I don't think that they were less legitimate Christians. You mentioned all these like theological disputes. I don't think that really like disagreements over theology necessarily are that important. I feel like someone's going to come for me for saying that, but I don't feel like Jesus would have cared a lot about people.. But I don't know.. Very presumptuous for me to say, right? I don't know what it, what are your thoughts on this? 

[11:37] **Henry**: Well, I don't think you would say either that nothing in theology matters. 

[11:40] **Sonya**: No, I wouldn't. 

[11:41] **Henry**: There are things that you think are straight up wrong or right. And I would say that you could probably say that about theology. If you said Jesus wasn't the son of God, then it's more of like, what is the core belief? And I would hope that would be one of them because I don't see how the religion makes any sense.

[11:57] **Sonya**: I agree, sort of not Christianity anymore. If you strip out that part.

[12:02] **Henry**: Right. But there are probably other things, like how do we do baptism or something?

[12:06] **Sonya**: Where the threshold lies.. This is a source of a huge amount of conflict. This is where you get.. [The Nicene Creed](https://en.wikipedia.org/wiki/Nicene_Creed) is kind of trying to establish like, okay, here are the ground rules.

#### More Porous Than We Think

[12:16] **Henry**: I think I mentioned a secular age last conversation. Back then, it was a lot easier to believe in God without a lot of evidence. But in some ways we've probably lost a lot of things that they knew. People considered themselves as porous people. You have holes in you and that there are spirits and demons, external forces that can affect who I am. But now he says that we're buffered selves. We kind of have this almost  armor against external forces. How I get to choose who I want to be, what I want to do. 

[12:48] **Sonya**: So you mentioned we may have lost knowledge that the ancients had. And I personally think that this porous selves notion like is more accurate than the idea of the buffered self. I think we are more permeable than we tend to conceive of ourselves.

[13:04] **Sonya**: Culture gets into people's heads. It gets into their minds. This has certainly happened to me. It sort of circles back to the theme of transformation. 

[13:11] **Sonya**: Like when I was kind of early in my starting to convert, I guess. One of my friends told me, like, you should just try going to church. But I warn you, if you go, you may find that it changes you.

[13:26] **Sonya**: And that.. I mean, it's kind of scary also. You know, the idea that you can be affected by things without deciding, I guess. Or, I mean, in the case of going to church, the decision would be going to church. But who you hang out with or what you choose to do with your life, those things ends up changing you in ways that you can't necessarily know ahead.

[13:51] **Henry**: Yeah. I liked that a lot. You're saying I need to like be okay with being vulnerable, not just showing yourself, but the other part of vulnerability of like allowing people to affect you. And it's like, otherwise, what are we doing in this world? We are going to change.

[14:06] **Henry**: And as much as I'd like think the same or want everything to be in control, when you talk to someone, whatever they say, it's subtlely affecting you in some way. And they're not trying to manipulate you, it's just what happens, right. That is pretty interesting, that someone told you like, Hey, like almost warning you that you might change. 

#### Individuation

[14:23] **Sonya**: I'm just interested in this idea right now so it always pops up whenever I'm talking about something, is the Jungian idea of [individuation](https://en.wikipedia.org/wiki/Individuation)? Did I mention this before? 

[14:33] **Sonya**: So Jung is all about these archetypes. Or this is like one aspect of Jung, I shouldn't overstate things. There's the like wise old person. And then there's the male aspect of that and the female aspect. And there's the young seeker. And there are all these different archetypes that manifest. And actually this is to a large extent, true. Like you see different archetypes that come up in culture after culture after culture. 

[14:56] **Sonya**: Although of course the notion of the archetype is its own.. It's like this own projected concept that then reorders how you see all these different other cultures. Like you see this generality in their specificness. It's like projecting a certain shape onto the data. And then maybe the data actually does kind of fit that shape, but it also has its own like distinct deviations from the shape. Anyway, it's kind of a tangent. 

[15:23] **Sonya**: So the idea of Jungian individual psychology, you have this individuation, which is kind of like becoming more and more yourself, like whatever the essence is of you, you grow in kind of expressing that essence. And the idea of like going through change in how you express your essencenesss, whatever the intrinsic part of you is. And of course this also is the idea that there is an intrinsic part of you. It's kind of hard not to see the soul in that notion. 

[15:54] **Sonya**: Although this is another kind of theological question. Do we have different souls? Or in what ways and degrees are our souls different if they are? I don't know, this is a question that only just occurred to me. 

[16:06] **Henry**: Yeah, I guess people might be like, Oh, I don't have one self, I have different selves and they're expressed like having alt accounts. Saying soul in the general sense seems like there's just one thing, but yeah. I don't know either. 

[16:20] **Sonya**: Could a soul have different faces? I don't know.

[16:23] **Henry**: And you could say there's also stages or it's still the same.. Then you can get into the ship of Theseus, right. You're changing over time, are you still the same thing? What is identity? All that. I guess a Christian point of view would say it's from God, it's a gift. It also doesn't change. And that's also why we can have hope because if our identity is chosen by you and you change your mind then are you not the same person anymore? Like, how does it affect you, your circumstance? 

[16:46] **Henry**: And so we would like to say God has chosen me and then my identity is rooted in that and that hasn't changed. How do we realize that and understand that fact, if that is reality, how do I live it out so that I can remember that when I go through suffering.

[17:03] **Sonya**: It almost becomes.. Yeah. I'm wondering, like, does adopting.. and like sincerely believing it, does that change what you are in itself? At what part? You know what.. I do think there is an unchanged part. Some sort of.. I would envision it as like a core, or a seed almost. I don't know. I liked the idea of the seed. Well, you know, this has echoes in stories from the Bible of course.

[17:28] **Henry**: I should probably look into farming and gardening because so many metaphors are from that. I was just thinking, like, if the normal way we eat food is by ordering it online. Or going into a grocery store is a weird thing too. Cause like it's just there for you and you buy it and we don't appreciate where it all comes from. Maybe that's why a lot of people have been trying to do that during this quarantine time.

#### The Grafting of our Identity

> [Youtube video on tree grafting technique](https://www.youtube.com/watch?v=Ryf0248Od60&t=302s)

[17:49] **Henry**: But I did watch a video about grafting. I don't know if you are familiar with tree grafting. A few verses in the Bible talk about this. Specifically about how Gentiles, not the Jewish people, they are grafted into the tree. But watching the video is really interesting because it gets a little bit deeper. Okay, you have this branch, you cut it off the trunk of the tree. And then you get rid of the outside light bark, I guess. And he literally just stick it in so the insides of both the trunk and the branch are touching each other literally, and eventually they fuse together. And it looks like it's a part of the tree. And from the theological point of view, the Gentiles are grafted in. And then eventually it looks like they are of the same, even though they were from a different tree, right.

[18:31] **Sonya**: It's especially interesting because then like if you graft on.. Doesn't the way it work is it'll still bear the kind of fruit that it bore before.

[18:40] **Henry**: Right. So say it was an Apple tree. Like different kinds of apples, they would all produce different fruit. Assuming it's compatible.

[18:46] **Sonya**: This also reminds me of the body metaphor that we talked about a little bit before that all the limbs are different. And even on the interior, you know, the organs all do different things and have like different  functions, but they are all part of the same overall entity, you know, working together in tandem.

[19:06] **Henry**: Honestly, it's a beautiful metaphor because they all produce their own different fruit. I think that says a lot about calling. We don't need to copy someone else. Like you said, every part has its own function. And then talking about maintenance, cause it's a body, it's a dynamic living thing. It also says like, if one part hurts, we feel it right. And we want to help them. I think that's awesome. 

[19:27] **Sonya**: Yeah. The empathy is a sort of natural response. 

[19:31] **Henry**: I mean, we use the family metaphor. We're all in the same family but I guess obviously you care about your body. 

[19:37] **Sonya**: Yeah. I mean Paul says that specifically, if part of your body is sick, you're going to be upset about that. This also makes me think of.. In the sermon on the Mount, Jesus says, you shall know them by their fruits. This actually puts an interesting spin on that, which is that there are different fruits. But you can still tell whether a plum is rotten and you can tell whether an apple is rotten, but they don't have to be the same thing. 

#### Interwoven Stories

[20:03] **Sonya**: And I don't know, you know, this is me sort of imposing my own interpretation and like looking for resonance between different passages. But I mean, I think that's one of the really beautiful things about the Bible personally, that it has this symbolic resonance throughout, and like Jesus is constantly pulling on the Old Testament. And it feels very dense to me. Like it's all interwoven, interconnected and there like multiple layers to it. And something about that as like inherently pleasing to me, like, it just feels beautiful.

[20:34] **Henry**: Yeah, it internally coherent and full of meaning. There's depth. I think the rational view makes everything flat, like everything's one-to-one. We talked about this earlier with like things that Jesus talks about reference to the past, and also refers to the future and to the present, all at the same time. 

[20:54] **Sonya**: Yes, I, there are sometimes the way I think of it is that there are like multiple scales happening. Going back to the body. Like we all have gut bacteria and the gut bacteria does a lot of really important stuff. It actually seems to even be linked to cognition. There's emerging evidence and experimentation showing this, which I can't cite in detail, I'm not a biologist. But it's really wild the degree to which it can affect people. And it affects from digestion to mood to your mental faculties, which is wild.

[21:26] **Sonya**: But the gut bacteria are distinct organisms from us in at least some sense, but we can't really exist without them, or at least we don't exist without them. And I don't know, are they part of me, the human? I don't know. I'm assuming they have different DNA. But we're still part of the same system. Like they live inside of me and because of the rest of me, they are able to flourish. I hope. And I hope my gut bacteria are doing well. I don't really know. I try to treat them well. 

[21:56] **Sonya**: You know, there's this symbiosis. And the gut bacteria are real, they're alive, they're individual creatures. But they are within the system that is me. And the system that is me, it's like taking place on a scale on top of them. The gut bacteria are sort of on the scale of cells, you know? I actually kind of think of them as just like genetically distinct cells. Again, assuming they're genetically distinct, I feel like they must be, otherwise why would we talk about them this way? 

[22:23] **Sonya**: But you can layer another scale on top of that, where I'm just one unit in the society or like in the community, which is part of the society. And it's like, the community exists, the community is its own entity. And I think it's a real entity, you know, like it's made up of things. But its boundaries are less distinct maybe, but I also wonder if that's because we're on the sub unit scale with respect to the community. So it looks more porous to us. 

#### Emergent Bodies

[22:51] **Sonya**: But then if you go up again, another scale, like looking at the society versus the community. I don't know. I'm kind of losing track of my thread here, but I guess the concept is that they're like nested entities. 

[23:04] **Henry**: Cause I mentioned Polanyi, he would call it like a hierarchy of reality, And his analogy at first was actually language. So you have characters, and then words, and then sentences, paragraphs. And like the rules within one affect the other one, but in a different way. So meaning that we have the rules of grammar, but that's different from like the rules of creating a story. Maybe we want to reduce everything to the lowest level. But say with the clock, you knew all the physics behind it, but that doesn't tell you if it is working or not. That's a whole different thing. 

[23:34] **Sonya**: So like trying to tell the time by entropy. I mean, there is like some sense in which you can do that, but there are all these interpretive layers too. It almost feels like these different scales like communicate with each other through transmutation or something. I don't know.

[23:54] **Sonya**: It feels really important, like the nestedness, the like fractalness of reality feels really important to me. It shows up everywhere. There are all these patterns that have the small and the big. It's almost like they radiate.

[24:06] **Henry**: Yeah. This is like in a lot of different places. So like urban planning. Jane Jacobs talks about like complexity theory in the death and life of great American cities. The way she thinks of a city is that it's an organism, right?

[24:19] **Henry**: And her whole issue with the high modernist people that were trying to plan a city was because they thought of the city as  just the land or the buildings, right. It's not the whole ecosystem of people and the wildlife and the environment and all these things. And so we would want to see that in our society, in church. Is the church the people? Is it the building? Is it the land? We can't meet in person. What is it now?

[24:43] **Sonya**: I guess maybe the church is the whole, you know, like the system in motion. I mean, maybe that's another thing. We want things to hold still so that we can examine them. 

[24:54] **Henry**: Static, right.

[24:56] **Sonya**: But they won't, they won't do that for us. You can capture a snapshot. 

#### The Language of Discovery

[25:01] **Henry**: Right. That's true of observation in general, right. Those are all snapshots and you can get into like the whole quantum stuff. What was it? You can't know the speed and the position at the same time. 

[25:10] **Sonya**: I've been reading more about Quantum stuff and about number theory and it's just absolutely wild. I guess for a long time I had this kind of like scientism orientation toward the world where I was like, Oh, we kind of have most stuff worked out. Absolutely not. Like, no, we don't. Our physics is probably wrong and we just haven't figured out how yet. You know, it's like how there was this jump from Newtonian physics, and then Einstein comes along then like broke apart.. That's gonna happen again, although we don't know how yet. I mean, that kind of like the fundamental unknowability of the things that we don't know yet. I mean, there's almost.. You can discover things, but not yet know them in a way. It's like knowing as sort of having undergone the process of transformation of integrating something.

[25:56] **Henry**: That's so funny, you bring this up because that's literally what Polanyi talks about. His word is tacit knowledge, right? You know more than you can say, exactly what you said. He likes to use the word discovery and clues. You're pursuing clues in a certain direction. You're not arbitrarily just like trying all possibilities. There's a reason. There's something in you that's like, I think there's some truth about reality. That I don't know, I'm not certain, but I want to go in this direction. I'm going to choose to do that. And that's a very personal, he would say active commitment.

[26:25] **Henry**: He was saying that like a certain view of science thinks that people are going to abandon what is what they think is already true, just because someone gave them that different evidence. He's like, no, you live through a certain lens. You're going to argue your way, even if they give you evidence to the contrary, because you have a commitment to it. And that's like skin in the game. You need to embody that before you even decide I need to believe this thing.

[26:50] **Sonya**: I think that's very.. He's really capturing something that's very essential there. And it frustrates me to a degree. Like, I wish you could all like interface more directly. But, I don't know. It's just not how it works. Although I wonder like what is going to happen with say like [Neuralink](https://en.wikipedia.org/wiki/Neuralink) or something along those lines takes off and we develop telepathy. Okay. 

[27:12] **Sonya**: Bear me for a second. Let's say telepathy exists. How are we even.. How the fuck is that going to work? How could you get across these conceptual divides? Like when people's worldviews are not really interchangeable. It's like, you can directly communicate to whatever degree you share assumptions or axioms or something. But even then, like personal perspective, it's embodied, like it's physical, right? I have no idea. Like, is there a realm of pure thought? I don't really think so. Or maybe there is some realm of pure thought, but we can only access it subjectively and through our own thoughts. Yeah, I don't know.

[27:45] **Henry**: No, that's good. I'm kind of bought into his view of these things. Beyond tacit knowledge is personal knowledge. If we were to take someone's brain or extract data from it and just inject it into you, matrix style, would that even work? I don't see how that would like help much for things that are not as specific.

[28:03] **Sonya**: I suspect.. With zero evidence, well not zero evidence, but not with unscientific evidence.. That it might work in some way, but it will be transformed by being passed through. You know, if you were to sort of.. I'm imagining a big syringe, like you suck out the data and you inject it into the other brain, I think it would be transformed by going through the personal filter.

[28:27] **Henry**: Okay. Cause if you think about communication, that's basically what we're already doing right. By talking we're already transforming every time. So it's just like a more direct way of doing that. 

[28:37] **Sonya**: I mean, what if language is more mutually intelligible than a direct brain to brain? It certainly seems possible to me cause language is a tool for kind of like condensing concepts into some sort of like standardized form so that we can then look at them together.

[28:56] **Sonya**: When language was evolving, it's not like someone sat down and thought like, okay, I'm going to design a form so that we can, you know, talk about things. Like all of these like notions of what language is and what it does and what it's for and how it transforms us and how we transform it, all of this comes after language. 

[29:15] **Sonya**: At first it just turns out to be useful, you know, like someone's just like messing around and making noises and eventually you get these connections developing. Sign language probably came first, but it transforms us. It being there unlocks new capabilities. And just kind of like everything about evolution is like that. Where you develop some level of capability, right? That sets the new conditions for what, like future levels of capability can evolve. It's path dependent, I guess. There's like there's [hysteresis](https://en.wikipedia.org/wiki/Hysteresis), like the system changes and the changes of the system dependent on the past of the system.

[29:49] **Sonya**: Makes me think again of what you said about Jesus is speaking to the past, the present, and the future all at once. Almost like the present itself is speaking to both the past and the future. This is also, I guess, the ship of Theseus thing, like.. All of these systems that exist now, are they different? Are they the same? Like, cause we came from there. But we've transformed so much along the way. That's what I had to say. 

#### Extensions of the Body

[30:13] **Henry**: Yeah, that reminds me of technology is an extension of our body kind of idea. It's not just the device, right. When you first learn how to use a hammer, you're very aware of the grip, but then once you're used to it, you start thinking from the the tip of the hammer. So it becomes almost like you.

[30:29] **Sonya**: Or like driving. When you first learned to drive, it's super overwhelming because you have to think about like all these different things at once. You have to like coordinate, your hands with what your feet are doing. Or like learning piano where you have to coordinate your fingers. In the beginning you haven't chunked the patterns, and the instincts, and the feeling of it. It's like the muscle memory. But once you have, like you said, it changes your perspective.

[30:53] **Sonya**: Like you almost.. When I'm driving, when I'm parking, I almost feel the boundaries of the car. Like it's not, I'm actually, I'm like remarkably bad at spatial.. Like my brain does not think well, spatially. But because I've driven so much, like it's just, I lack words for it. I'm just like making hand gestures. Do I think in my fingers? I don't know. Maybe I do to some extent.

[31:19] **Henry**: I think the point is like, you're not like triangulating where the box of the car is. Just like say basketball, you're not like calculating. You just feel it. You just know your body has somehow absorbed that information.

[31:31] **Henry**: I think it's interesting to think of these physical things, but then turning that mentally as well through knowledge. And we were talking about the whole PDF thing at the very beginning, right. 

[31:40] **Henry**: We were talking about like focusing, right? The proximal is the thing that's tacit, the thing that's like in the periphery. And the thing you're focusing on is the distal. And when you talked about integrating things, he actually uses that exact word. Knowledge is essentially integrating proximal things into what is focused. Like understanding the clues around you to create coherency.

[32:00] **Sonya**: I actually think of it as like.. I dunno, let's say there's an orb and like, I mean, there is a sort of a way in which the human is orb-like, because my sphere of motion is sort of orbit. Maybe more like a kind of lopsided, elliptical kind of thing. Anyway, you know what I mean? And it's like something starts on the edges and then it sort of comes inward.

[32:21] **Sonya**: I don't know. That's just like instantly how I think of it, it's almost like I just brush it on the edges at first. Like just feeling it with your fingertips and then it sort of comes. Like the knowledge comes in. And then once it's in, it can go out again.

[32:36] **Henry**: Yeah. So I think what you're saying is like good definition of his word indwelling. And I think it's such a good physical word. From a theological point of view, like indwelling in the Holy spirit. We say that in Christianity, like the spirit is in us. Like I want to indwell this idea until it becomes like second nature in another way, right. And I think that is what life is about, indwelling in Christ to become like him.

[33:06] **Henry**: That's one way of looking at it. But again, that's not a mental thing. It's mental plus physical, right. Cause it's through the body as well. So it's not just like I assent all these things, but like I'm figuring out in my own way. Maybe that's the fruit, right. By embodying it, we produce fruit that shows that we actually understand. 

[33:25] **Sonya**: It's active. It's doing as well as thinking. And yeah, thinking is its own kind of doing in some sense, but physical doing matters too. Oh, you know, fruit goes through evolutions, right? Like it starts as, I mean, seed is like a kind of fruit. But it goes through like a whole cycle, you know, it starts small, it grows it ripens. And then eventually it does rot and fall apart. Or it gets eaten, I guess. Fruit has different destinies that it can end up in.

> Jesus said to the servants, “Fill the jars with water”; so they filled them to the brim. 8 Then he told them, “Now draw some out and take it to the master of the banquet.” They did so, 9 and the master of the banquet tasted the water that had been turned into wine. He did not realize where it had come from, though the servants who had drawn the water knew. Then he called the bridegroom aside - John 2:7-9 (NIVV)

[33:54] **Henry**: It reminds me of metamorphosis then, with the butterfly. But actually, cause you you're talking about the process of fruit. Sunday, one of my friends was talking about John 2 and the first miracle that Jesus did, turning water into wine. Where does wine comes from? It comes from fruit. That's another thing of pointing to the future, meaning when he comes back, is a wedding feast. And the first miracle was at the wedding. The fruit is processed, and it becomes something better than fruit, because people like wine, right. The ultimate fruit would be wine.

[34:25] **Sonya**: There's also an interesting dimension there where when you go back to the era when Jesus was alive, water is more of a like fraught endeavor. You know, it's not necessarily clean. Could be little beasties in there that'll make you sick. I don't know whether that was actually really applicable like in that specific time and place. What kind of water filter, like how good was the water available to the wedding? I have no idea. But it occurs to me as sort of an additional theme. Oh my little dog says hello, by the way.  Like the wine is more kind of trustworthy, I guess, in a way.

[34:59] **Sonya**: Although now I'm curious. This is not an empirical question that I would have expected to be brought up by like contemplating the Bible. But the boundaries between these things, again, are permeable. The historical knowledge and religious knowledge or the, I don't know, symbolic resonance or something end up kind of bleeding into each other.

[35:21] **Henry**: I think that instinct of wanting to keep them combined is a good thing. The more you want to separate, the more it becomes abstract. And the more, is this even real at all? Or is everything just like a story? It is, but I believe this not just because it's a fun story that I'm going to tell myself makes me feel better. I think a big part of is I actually think is real, right?

[35:42] **Sonya**: Yeah me too.

[35:44] **Henry**: Within history. 

[35:44] **Sonya**: Within history, but also in other ways. And I guess as you were saying, they can't really be separated out. Maybe that is part of the truth of it. Think again of density or like richness or something. It's true because it is like that. Or like that is the truth of it being manifested or like in action.

[36:05] **Henry**: Yeah, that goes into this whole theme. Because if it was true apart from the history or the actual reality of it happening, then it gets back into that scientific ideal, of it being abstracted from reality. It's just like these statements in the world and those just happened to me true. I think that ties back to God becoming a person. God could be real, but he actually is real within the person of Jesus. 

[36:29] **Sonya**: This makes me think again of our earlier conversation about how all of these things that I thought of as being like symbolic, I now think of as like.. It's not that they're no longer symbolic. It's like symbolic and literal. 

[36:43] **Sonya**: An example is that Christianity really changes the trajectory of history. It changes human cultures, especially in the West, but it diffuses out in other ways also. I'm most familiar with the West because it's like the cultural lineage that I am part of. So Christianity changes how people think and Christianity changes people's assumptions, et cetera, et cetera. Polanyi as an example of this actually.

[37:09] **Sonya**: And before I thought of that as just like confined to the intellectual realm. Oh it just changes how people think about stuff, write about stuff. It changes their metaphors, you know? And now I think of it as like, no, actually Jesus brings about this material ontological transforming. You know, like before we weren't saved. And now being saved is possible or like it is a state that we are now able to attain that we weren't before. Cause like, if I literally believe, you know, that Jesus comes to earth as a historical figure, embodying God, that is what that means. Like that's what happened.

[37:43] **Sonya**: And it's kind of, it feels radical. It feels like weird to say that, to me. To say that History and theology are inextricable from each other. It's almost like it's inappropriate, in a way. Like if I went to a history conference or something and brought this up, it will be like, you're crazy.

[37:59] **Sonya**: What are you talking about? Even like Christian historians would not necessarily talk about it in this way as like, this is the transformative work of Jesus. Like this is it happening. I'm not even sure that this really makes sense as I'm saying it, because again I should mention this at least twice that like, I'm still working all of this out, for sure. And I don't think that ever really ends. It doesn't seem to end. The working stuff out part or the like, trying to figure out like how systems function and where I am in the systems. And what is the relationship between past states of the systems and current states.

[38:38] **Henry**: Totally agree. Yeah, we're all working on it. I guess I think there's a difference between not wanting to be biased, but then also knowing that you are a biased regardless. I kind of want to embrace the fact that if that is such an important part of your life, it would be weird to say like, I'm trying to be neutral and it's like, well, I am Christian. So then that's how I see the world. It's not just a belief. It literally affects all things. I might not need to like say that explicitly, but it's going to come out in some way, and acknowledging that it's personal versus like this fake neutrality, I guess.

[39:11] **Sonya**: It's probably, you know, a result of like where I am in my personal journey and my personal evolution, that I keep coming back to this theme of like the atheist conception of religion as being like a realm of make-believe kind of. Or at least this is how I thought of it when I was still an atheist. I thought of it as like a, sort of a realm of the imagination.

[39:33] **Sonya**: And now that I'm inside this new worldview, I'm like, Oh wait, no, it's not like that at all. You know, it's not a separate sphere, I don't think of a material reality as being like distinct from religious reality. It's just all the same thing. It's new and exciting to me. It's this holistic.. Maybe that's one of the things that is so.. I almost want to say like intoxicating about Christianity and about faith is like becoming part of this integrated whole. I don't know, indwelling. 

[40:04] **Henry**: Yeah indwelling. That must be something that we instinctively need. Like the desire to become whole. And I think that any religion has answers to the big questions that people will have. I might not believe in a different religion, but I can understand why if you do, they have some internal coherence.

#### Agreeing to Disagree

[40:22] **Henry**: This is probably why people believe things that just don't make sense to anyone else, but it still works for them, I guess. My concern is more of conspiracy theory things where that is its own worldview and literally shapes how they see the world. And I guess obviously I don't believe it, so it makes me wonder how to engage with those people. 

[40:41] **Sonya**: Interesting. It's like the conspiracies are sort of divergent along different axes or something. Yeah, everyone is kind of interested in QAnon at the moment. And I looked into it a little bit and I was like, yeah, I don't really understand where you guys are coming from. Or it's like, I understand the aspects of it. Some of their concerns I even share. I don't think that they're happening in the way that they think that it is happening.

[41:06] **Henry**: I think that's part of the issue of like there, everything in it is rooted in some truth, but they take it to an extreme or they extrapolate all these things. And then when you dialogue, well, you want it to acknowledge that those things were true, but then how do you also like say that I don't believe the whole thing. And this maybe relates to heresy too. How do you engage without dismissal? Because that would turn them away entirely. Or if you acknowledge part of it, they're like, Oh, then you believe the whole thing. And how do you kind of navigate that?

[41:36] **Sonya**: Especially since in conversation, I've found that people will assume that you agree with them. If you don't articulate that you don't, which is a weird and interesting. Like why is that the assumption, that if I listen to you, it means I agree with you. Why do we think that? I don't know, but I've had this happen to me a number of times where I thought that I was just like hearing somebody out. And then I find out later that they thought that by listening and asking questions, they thought I was agreeing with them. And that's not what I meant at all. I was just interested in where they were coming from.

[42:12] **Sonya**: And actually, I had a friendship end over this, where I found out kind of abruptly that how this person thought our relationship had worked was that they thought that whenever they said something to me and I didn't argue with them, that meant that I was assenting. That was not how I thought things worked. So I figured out from their own pattern of behavior, which is whenever I said something that they disagree with, they jumped in with the like combative no, we have to argue about this. Eventually I realized, Oh, the way that I wanted to engage was where we both heard each other out and just kind of agreed to disagree.

[42:49] **Sonya**: They were not on board with that. They thought, no, we need to hash out every disagreement. It ended up that our approaches to the friendship we're just incompatible and it kind of fell apart. Yeah, which is sad. But it was educational also in terms of.. It's the assumptions, right? Like the assumptions you bring to the table change what you see. You know, we had different experiences of that friendship. Like what we thought it was, was different. I don't know. 

[43:17] **Henry**: Yeah. I'm thinking about like my parents. I felt.. I actually experienced this, but I was feeling that when I went home for the quarantine for a few months, actually, and I like couldn't take it anymore.  and learning the hard way of how to continue the lines of communication, right. Dialoguing and not having judgment on them. And same with them.

[43:37] **Henry**: None of us can change their thinking by arguing it, right. Saying they're just absurd or something.. If someone told that to us, we're not going to change. Like, of course. So why do we feel like that's okay. It's just because it's a reaction we haven't learned how to..

[43:52] **Sonya**: Patience. Patience can be painful. Yeah, this is something that I like about our conversations, that the same themes pop up in these different forms. But we didn't even talk about the rationalism to religion pipeline at all. Well, we did in an oblique way. Which is that I think people are seeking this transformation, to become something different. It's scary, but it has its benefits also. People want it, some of us anyway. 

[44:20] **Henry**: It's a leap of faith.

[44:21] **Sonya**: And yeah, there's a way in which it's a little bit dangerous to start because once you start changing, it's hard to reverse the process. Like if you decided, Oh no, actually I want to go back. I'm not sure that you could.
