---
title: "Emotional Programming (Omar Rizwan)"
season: 3
date: "2020-10-05"
time: "40"
description: "What can we learn from someone's last tweets? Omar Rizwan joins Henry to chat about the Dynamicland way of thinking: communal, involving the whole person, user agency. We discuss user control, the problem of lists, industrial open source, materiality and embodiment, knowing through doing, and being aware of your emotions when programming. Also (of course) screenshots. (recorded in August)"
episodeLink: "ca3e9f6c"
embedUrl: https://share.transistor.fm/e/3120d5ff
sidebar:
    order: 6
---

### Links

- [Omar's Twitter](https://twitter.com/rsnous)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/emotional.md)

#### That's a Dynamicland sort of thought

[00:00] **Henry**: So I have Omar with me. I was like, Oh, I think your tweets are interesting and it maybe interesting to almost like analyze them. Cause I think you said you were planning on doing that for yourself to see what comes up, right?

> [Omar's Twitter, @rsnous](https://twitter.com/rsnous)

[00:12] **Omar**: Yeah. I just left my job at Dynamicland. So I'm kind of been collecting my thoughts and it could be fun to go through some of what I've been thinking about.

> [Dynamicland](https://dynamicland.org) may be difficult to describe, as it's not just a program, it's also the building itself! I had a [chance](https://twitter.com/left_pad/status/1192511538541690880?s=20) to experience it thanks to Omar, but I recommend reading Carl Tashian's [post](https://tashian.com/articles/dynamicland/) on it! You can also check out Omar's [writeup of Geokit](https://omar.website/posts/notes-from-dynamicland-geokit/), a map project he did at Dynamicland.

[00:21] **Omar**: You know, I think one thing that's kinda unique that I do is use Twitter and screenshots that I take and chats with other people as my equivalent kind of note taking system. So there's a lot of just weird thoughts that I have floating around that I want to collate and see if there are any themes.

> A screenshot of a chat bubble saying: "imagining growing a router. you like get this blob of clay and stick an Ethernet cable from your laptop into it, and stick another Ethernet cable from your modem into it on other side. and then you try to browse the Web on your laptop and like tune the blob of cluy until it's a working router." - [Omar](https://twitter.com/rsnous/status/1312546643426775041?s=20)

[![A screenshot of a chat bubble](https://user-images.githubusercontent.com/588473/95118854-fa9af180-0718-11eb-9b58-7a9c341ff98a.png)](https://twitter.com/rsnous/status/1312546643426775041?s=20)

[00:38] **Henry**: And how long were you at Dynamicland anyway?

[00:40] **Omar**: Little bit under two years.

[00:42] **Henry**: Okay. Maybe how has that shaped the things that you're tweeting too, right? Cause I think you mentioned like, Oh, that's kind of like a Dynamicland sort of thought.

[00:50] **Omar**: Yeah, I think it's had a pretty deep influence on me. I don't actually usually talk that much about Dynamicland concretely. There are a lot of those little kinds of tricks that I often apply when I see something that I kind of learned.

[01:02] **Omar**: It's more like whenever I see a list of things on my computer, I'm always like how can this instead be a spatial thing? How can I physicalize something? Or if there's some system where there's a bunch of configuration, how can I instead just make that something where people could reprogram it directly?

> "I like the idea of getting a separate Raspberry Pi to host each website I make, so there ends up being like a shelf in my apartment with a bunch of websites sitting on it" - [Omar](https://twitter.com/rsnous/status/1262140583755132929?s=20)

> "I wonder if I could have an email inbox that's like a desktop, where each email is an icon or something. spatial. so I can drag & cluster emails about an upcoming conference together in one corner, newsletters I want to read at the bottom edge, work emails in another corner, etc" - [Omar](https://twitter.com/rsnous/status/1251249279718420481)

> "thinking about how the Apple Lisa let you have multiple files with the same name in the same folder. because why not? you can distinguish them by putting them in different spots in the folder!" - [Omar](https://twitter.com/rsnous/status/1215391056667299841)

#### What's Wrong with Lists?

[01:17] **Henry**: Right, because you tweeted that recently too, tyranny of lists.

[![A screenshot with a Google search of "the tyranny of lists" with 320k results](https://user-images.githubusercontent.com/588473/95119801-90834c00-071a-11eb-9cc8-de45195a7073.png)](https://twitter.com/rsnous/status/1290668662949462016?s=20)

[01:20] **Omar**: Yeah. And these are the things where hopefully, it turns out a lot simpler if you apply this way of thinking to the problem?

[01:28] **Henry**: To get into them more, I guess what's wrong with lists?

[01:31] **Omar**: I mean, whenever I kind of say these things, like the tyranny of lists or whatever. I don't want people to think that I'm making some generalization, like I think all lists are bad all the time or anything like that.

[01:41] **Omar**: But I think people probably lean too much on the side of lists. Like it's sort of an easy out like, Oh, I have a bunch of stuff. I'm going to make a list of it. And often, you know, I'm going to tell the computer to sort it or whatever. I often say these things because I want to push back and like get people to think about more radical ways of presenting information.

[01:58] **Omar**: But I think that the problem with lists is that you're basically giving up a lot of control over how the stuff is organized.

[02:06] **Omar**: Often if you have a list of emails, you know, you can't put emails that belong together, together. You can't space them different distances from each other. Because everything is the same, it is uniform with space. If it's sorted, then you don't even have control of what order they’re in.

![picture of a list of emails in gmail](https://lh3.googleusercontent.com/wlf842vsNrbW70WRloE0LzJVOJfoL4lYMbqOEebLudfLr91bLou7Sb6Hu7f5C_uP9femGOjfLdns4B9q5rdzVBHx9NIGvOayPqbvRQ=w790)

[02:21] **Omar**: And I think often the reason people use a list is like, it's not a great reason. It's that a list of something that's easy to do on the computer. Because like iOS gives you a list control or like you can make a HTML list element, or like your Mac finder uses lists by default. Or, you know, a list is easy to type in your word processor or a note taking app.

[02:40] **Omar**: ike, if you were trying to pick the best way to represent the information, maybe you wouldn't pick a list. If you actually kind of had a choice, you had other options that were equally straightforward.

[02:49] **Henry**: Hmm, I guess even applying that, cause we were trying to make a list, I guess, of your tweets. And then I was already saying, why can't I drag these around and like kinda create categories and space? So that's kind of funny.

> We were using [HackMD](https://hackmd.io) and Markdown to make a list of tweets, but I really wanted to be able to spatially drag in order to categorize them!

![screenshot of our HackMD list of tweets](https://user-images.githubusercontent.com/588473/95120290-536b8980-071b-11eb-8fef-bde27e712c98.png)

[03:02] **Omar**: Yeah. Sometimes now when I'm looking at my email, I see like an email from a week ago and an email from a month ago. They're kind of about the same thing and yet I'm like, why can't I drag these to be together?

[03:10] **Henry**: I was noticing that too, instead of lists like tyranny of boxes with every chat app just a square of the person's face. And then you see a bunch of new apps that are trying to introduce space into that as well.

#### Dictating Terms to You

[03:24] **Omar**: Yeah. It's also like emotionally, it ends up being like the software is dictating terms to you about how your stuff is organized. Where it's like, your stuff is this stuff in the website or the app, but the app is telling you how it should be laid out. And you don't actually have a choice. You can't pick things up and move them around.

[03:41] **Omar**: Whereas if you know, things are pieces of paper on your desk, or even in the old kind of personal computer files, at least you can drag them around and arrange them. Cause it's your stuff.

[03:50] **Henry**: Right. So it almost like limits what you can, not even do, but like think right? You wouldn't even think to do certain things unless you knew like, Oh, they added in drag and drop functionality versus like that it's built in as a core feature or something.

[04:04] **Omar**: Right, right. And, you know, I don't blame people making these apps, cause it is a lot of work for them. They have to add in functionality explicitly, and it's hard to think about this stuff. I think it's totally understandable.

[04:21] **Henry**: So it's more that it's kind of ubiquitous and it's just the default way of thinking. And it's hard not to think that way. So you're just kind of saying that we should maybe look in this other direction as well.

[04:33] **Omar**: Yeah. And that's kind of what I'm trying to do whenever I tweet about things like that. It's just pushed people to think in some of these ways that I kind of learned from Dynamicland, that I now apply what I'm looking at software.

[04:47] **Henry**: Was that one of the core principles of Dynamicland, just the idea of space. I guess that makes sense in that Dynamicland itself is a space, right. And you're trying to make computing like physical.

#### Giving the User Control

[04:59] **Omar**: Yeah. Yeah. I mean, I think it's almost deeper than space because you can make software that uses space while still not giving the user control over how the space is used.

[05:09] **Omar**: Whereas I think what we were doing at Dynamicland, once you have a bunch of actual pieces of paper, you can move them around however you want. It's also like the user actually has control over how things are organized.

[05:19] **Henry**: So a lot of it is the whole point app versus tool distinction.

[05:23] **Omar**: I mean, I think that these things all kind of come out of this cohesive ideology of how maybe software should work.

[05:30] **Henry**: Right. A lot of your other tweets are around either expression or freedom. There's a few that are around like, you know, the library author didn't let you do certain things and you know that you want to do it. And then that's frustrating, right?

[05:45] **Omar**: Yeah. And I'm very attuned to the way that the system is constructed affects how you think. And it also affects how you feel.

[05:52] **Omar**: You know, often one of the problems I have with a lot of discussion of programming languages or libraries or whatever, is this idea that we're just trying to find the right answer to do things.

[06:02] **Omar**: And I think often there are these aesthetic choices or there are these like emotional choices or they're different goals people have. You know, I think emotions are a big deal in programming. Like I think most of the work in programming is managing your own feelings about it.

#### Industrial Open Source

[06:15] **Henry**: Yeah. So it kinda makes me think of how in tech, I guess maybe the dominant thinking is sort of assumed to be the right way or the neutral thing. Like say we all think, well, obviously you're supposed to use a list, right.

[06:29] **Omar**: Yeah. And I think like these kinds of dominant ways of thinking, they often make sense in a specific context. Where there's like technology companies and they're doing software engineering and they're making these big systems. So, you know, they want their software to be well tested and correct. And they want it to scale a lot.

[06:47] **Omar**: And I think, you know, there are a lot of solutions to those kinds of problems that don't necessarily apply if I'm just playing around with software or if I'm making a little hobby project. Or even if I'm like a scientist and I'm trying to do data analysis, I think like there should be a different set of solutions for that.

[07:04] **Omar**: But I think often what people end up talking about and what gets, you know, all the investment are these tools that, you know, maybe make sense in one context, which shouldn't necessarily get generalized to other places.

[07:14] **Henry**: I guess that also makes me think of open source itself. A lot of times, it could be a hobby project that someone's doing on their own, but it gets almost taken over by people that work at companies. And it turns into this thing that you might not envision at first.

[07:28] **Omar**: Yeah. And it feels like that's like almost the central story or problem of open source. Just like people mean different things when they say programming and programming is a lot of different stuff. Open source is also a lot of different stuff and it kind of evolves from one kind of thing to another.

[07:42] **Omar**: One other example that I always think about other than the lists thing is, you know, I'm like, this is, I think a lot of what the discussion in the front end world is about is that there are these big tools for packaging managing packages and compiling other languages to JavaScript and testing and type checking and stuff.

[08:00] **Omar**: And I think like a lot of those tools make sense if you're Facebook, but maybe they don't make sense if you just want to throw a webpage together. But I think that because of the way the culture works, everybody wants to learn and talk about the tools that will get them a job or are culturally prestigious. So that can kind of crowd out other ways of doing things.

[08:19] **Henry**: Right. I guess it's all related because, say you want to get funding. Then if it's just like this thing that isn't scalable or is more like for fun, who's going to pay you for that, right. And it's like, it makes everyone incentivized to care about things they might even not care about it at first, right.

[08:38] **Omar**: Right. I think once you start working on something, you know, a lot of the time you kind of end up caring about it. So I sometimes think it's kind of dangerous to start working on something where you're lukewarm on it. Not because you might hate it, but because he might love it, and then you kind of turn into a different person.

[08:51] **Henry**: Yeah, that's an interesting fear.

#### A Project You Identify With

[08:54] **Omar**: Yeah. So I have this screenshot app that I wrote, and that I kind of sell as kind of a side project. Because I use it like all the time, it's basically guaranteed to be maintained as long as I use a Mac or whatever. There's something really powerful about a project that you identify with, that you use regularly.

> [Screenotate](https://screenotate.com) saves the screenshot (and other metadata) as well as the text via OCR for easier search. Here's a metadata example below:

![screenshot of screenotate's output for the text above](https://user-images.githubusercontent.com/588473/95122652-d3dfb980-071e-11eb-88fa-0b9bb5a964fd.png)

[09:14] **Henry**: I think you had a tweet about that too, right? It was designing for yourself, like Apple.

> "I think this is an underrated take. that you can be like Apple and design good things, but you can't just have good taste; you also have to be working on things, like the iPhone or Mac, /for which your taste is valid/ (because you're a target user yourself)" - [Omar](https://twitter.com/rsnous/status/1290671620982370305?s=20)

[09:19] **Omar**: Yeah, yeah. We were talking about this on Twitter I think last week. Where there's this idea that Apple is really brilliant at design and the way to do great design is to learn from what Apple does.

[09:30] **Omar**: And I mean, there's certainly some truth to that. But I think an aspect of Apple's success that is really underrated is that Apple makes products that anybody can use, including the people who work at Apple. If you're working on the iPhone or you're working on the Mac, like an iPhone is something that you can actually use every day.

[09:50] **Omar**: You're not making a product for other people who are not like you to use. And that means you don't need to go do user testing, or any of these kind of traditional design processes where you're trying to figure out what to put in the product, you can kind of just like introspect.

[10:04] **Omar**: And I think that's a really powerful advantage. And it's an advantage that doesn't really port that well to a lot of things people try to make where they're often trying to make something for some other audience.

[10:14] **Henry**: Right. I guess it just shows how hard it is to design if you're not the target user.

[10:21] **Omar**: And even if you're going out to users and trying to learn from them, it's like a way slower feedback loop, I think. Whereas if you're using it yourself, your feedback loop can be down to seconds.

[10:32] **Henry**: And people are really bad at describing how they use or think about things, right.

[10:37] **Omar**: You need all these really intense kinds of anthropological skills to even figure out what people are thinking when they use it, if they are people who aren't you.

#### End User Programming

[10:45] **Omar**: And this is part of my argument for a sort of Dynamicland style, end user programming, where the people using the software are actually reprogramming it, or they made part of the software.

[10:58] **Omar**: In the kind of dream world where everybody programs their own software, you don't really have this problem because everybody knows what their own needs are. You don't need to go out and learn from people.

[11:06] **Henry**: I guess in the early days of computing, when there's less people, that was probably true because the only people that used it were people making it. But I guess the problem is how do you scale that to people that are not familiar. They don't have to have a degree or take all these classes, right.

[11:23] **Omar**: Yeah. There was certainly a time when you could say the same thing about reading and writing, right? Where 95% of the population couldn't do these things, but you know, we've been able to solve that problem for the most part with education. And also just the fact that you need to read and write to function in our society. Puts a lot more pressure on people to learn those things.

[11:43] **Omar**: And we don't, I think, live in a society where programming is useful in the same way. So I think there's not that social motivation.

[11:49] **Henry**: A lot of people want to go into tech, but I was just thinking about it almost like a way of thinking that programmers have, where when you see it, you feel like you have the opportunity to change something right?

[12:01] **Omar**: Yeah. And I feel like you can always get more of that energy. Even in the last few years, as I've like learned more about the computer. Like whenever I learned more about how my operating system works or about how my browser works or whatever, that then kind of opens up a new way of seeing problems that are happening to me where I'm like, Oh, I can just go and dig into this and see what the problem is.

[12:21] **Henry**: It's like a level of curiosity that you build, but I think that's hard to build sometimes right.

[12:26] **Omar**: Yeah. It's almost like a kind of confidence or like an emotional, like, Oh, if I look into this, I can probably figure it out or I have some kind of lead, so it's not just the scary thing.

[12:36] **Henry**: Yeah, I guess you even build that as a programmer because like a lot of things that we do, you've never done before in programming yourself. And learning how to like Google things and use stack overflow.

#### A Personal Warehouse

[12:47] **Henry**: I guess related, you had a tweet I thought was interesting about how the term personal computer, people take it for granted. And that's just how people think of it now.

> 'something that would have been fresh and /strange/ and radical just about hearing the phrase "personal computer" or "desktop publishing"' - [Omar](https://twitter.com/rsnous/status/1291919881961521152?s=20)

[12:56] **Omar**: Yeah, like it would have been, I mean, I wasn't around in the seventies, but I like to think that it would have been a really weird phrase to hear, personal computer. Because you would think of a computer as being this thing that fills the whole room. It's like if I told you about a personal factory or a personal warehouse, like some really expensive, capital intensive thing that is now like shrunk down to your desk.

[13:18] **Henry**: I was thinking, then it's not a matter of scale. Because if we say personal warehouse, I could imagine a warehouse shrunken down, but it just wouldn't make sense, right.

> 'that bracing element of it. like, "personal computer"?? a computer is this massive system that costs millions of dollars, takes up a whole floor, is operated by big tech companies for business. you might as well have a personal factory while you're at it' - [Omar](https://twitter.com/rsnous/status/1291919883316289536?s=20)

[13:27] **Omar**: Right. I think the scale is part of why it's shocking, but it's also the ownership. Like a computer is not just something that's huge, it's also something where like IBM makes it and they sell it to airlines manage their payroll.

[13:38] **Omar**: So there's this reversal of like, Oh, what would I do with something like that? Like that's so that's such a weird concept. I like kind of trying to highlight that these things were actually strange at some point. And should maybe be strange again.

[13:51] **Omar**: I mean, it kind of reminds me actually of like religious scriptures in some ways, where you know, a lot of these things that are in the Bible or the Quran or whatever would have been radical at the time. And you know, people have repeated them and so they sound like just something you say. But I think it's always worth thinking about them in the context of their time and trying to bring back that freshness and that radicalism.

[14:11] **Henry**: That's a really good point, honestly. It's sort of like the idea where like, if you say the same thing over and over. Sometimes it feels like it becomes meaningless, but if you truly believe in it, then every time you repeat it, it makes you feel a positive way.

[14:25] **Henry**: And if you think about the Bible, like that first verse, that God created the universe. That should be such an impactful statement. But when we hear that, it's just kind of like, Oh, whatever, you know. It's like if you thought about it. It's like, wow, that's huge, right?

> "In the beginning God created the heavens and the earth." - [Genesis 1 (NIV)](https://www.biblegateway.com/passage/?search=Genesis+1&version=NIV)

#### The Materiality of Books

[14:40] **Henry**: Cause you mentioned religious texts. You have a lot of tweets around like books. One of them was a picture of the Quran and there was gold and when you see it in real life, it glimmers. But in a 2D environment, you lose that information because it's just the picture.

![quran with glimmering gold lettering](https://user-images.githubusercontent.com/588473/95123250-a6474000-071f-11eb-9ebf-a10847be83bd.png)

> "I bet that the power of the gold lettering is much diminished when you view it as flat images on your screen. I bet it'd be far more striking in person. like, the gold would catch the light more than everything else on the page, and it'd shine differently from different angles…" - [Omar](https://twitter.com/rsnous/status/1254406794174009344?s=20)

[14:55] **Omar**: Yeah. A lot of my interest in books is like the materiality of books. I follow a lot of these accounts that kind of tweet pictures of medieval manuscripts. And so I'm always interested more in these physical things. The material, the texture, the way it looks as you walk around, rather than the text per se. Especially in the medium.

> "I was in this big cathedral just after sunrise a few months ago and was looking at the murals. this is a crappy photo but see how much the halos stick out because of their gold texture and the light conditions!!" - [Omar](https://twitter.com/rsnous/status/1254557768834363392)

![cathedral painting with gold halos](https://user-images.githubusercontent.com/588473/95123390-e1497380-071f-11eb-8402-25c55e6d2a31.png)

[15:12] **Omar**: I think in tech especially, it's always very tempting to set up this binary between the content and the presentation. Right now we're going to just work on the content and the presentation lives somewhere else and they're totally independent.

[15:23] **Omar**: But I don't believe that, I think that sort of nonsense. I think that content or presentation are always inseparable. And often when you do this naive translation of stuff, that's in a physical medium into your computer screen, you lose a lot of important parts of the presentation. And so I want to go back and highlight those things so people notice them.

[15:43] **Henry**: Yeah, paying attention to the medium in the context of religious texts I think is interesting, because now people read the Bible on their phone, right. Instead of actual physical copy. That changes how we experience the text itself. And in negative ways, right, you get a notification or all these other things related to it that distract you from what's there.

> Reminded of [Bibliotheca](https://www.bibliotheca.co/) and "reader's bibles", as many Bible's are many associated with the intention of references and encycliopedia's versus reading. I would bring up the two column page, small text, footnotes, references, chapter/verse markers.

[16:08] **Omar**: Yeah. And there's this sort of physical interactions that you can do when you're reading a physical book. I had one tweet, there's no equivalent on your computer, on your phone of being able to hold the finger somewhere while you go to somewhere else. And that has all kinds of consequences for the way that you read the book. You'll be a lot more reluctant to move around, if you feel like you're going to lose your place.

> "wish I could plug a second mouse into my computer so I could leave my current mouse on what I was doing before, like using one finger to hold a place in a book while I'm flipping to somewhere else" - [Omar](https://twitter.com/rsnous/status/1262234001571381254?s=20)

[16:27] **Omar**: I think also there's all these traditions of reading that are kind of attenuated when you switch to a phone because they don't apply anymore.

[16:36] **Omar**: You know, to be clear, I think there is a place for reading on your phone and I don't think there's necessarily anything wrong with it, but I think it would be good if we paid attention to like, what things are we losing and are there ways to kind of bring them back or to do new and better things? Rather than just thinking that we've accurately translated this experience.

[16:52] **Henry**: Maybe we think of technology as always replacing the old, rather than adding on to, right.

#### Practical solutions that turn into rituals

> '❤️ "the sacred texts are brought out into the open, and their pages are turned at a slow pace, giving each some time to dry out in the sunshine"' - [Omar](https://twitter.com/rsnous/status/1290664383882964997?s=20)

[16:58] **Henry**: You had a tweet talking about Buddhist texts and how back then, the pages would get damp. And so they would have this festival every summer where they would turn the pages really slowly, to dry them out. But then that turned into its own like ritual, because they enjoyed doing them. That's cool.

[17:17] **Omar**: I thought that was a really nice bit of history. I'm sort of interested in these rituals and like the way that solving a problem in a particular context can kind of turn into this cultural thing.

[17:28] **Omar**: This is actually a kind of relevant to current events. There are these famous modernists, Le Corbusier and others, who in the early 20th century proposed all these new apartment complexes with the sort of towers in the park, if you've seen public housing like that, where there has to be a certain amount of light and open space and stuff.

[17:47] **Omar**: So people go back and kind of criticize that architectural history, or they say it's like weird that he calculated the exact amount of light and space that somebody would need. But it turns out that a big part of the reason that they designed the buildings this way was so that there would be ventilation, because they didn't have antibiotics at the time. So it was kind of an anti disease thing.

[18:05] **Omar**: And, you know, often we kind of go back and we look at that as this purely cultural thing, when actually it's also solving a specific problem that they have that, you know, for a while, we didn't have any more, I guess now we have the problem again.

[18:15] **Henry**: Yeah, I guess we don't realize how many, I guess, multiple uses there are for whatever ritual or idea.

#### Optional Daycare Surveillance

[18:22] **Omar**: Yeah. The other thing I was going to say about reading on the phone. One of the things that is always tempting to do is, to think of software in terms of discrete features, where you're like adding this feature to the next version, or this is the button that you use to access that feature.

> "increasingly skeptical that 'features' is a good way to think about software" - [Omar](https://twitter.com/rsnous/status/1263212491808534528)

[18:39] **Omar**: And I mean, I do this too, like in my own software, I often like fall into thinking of it in terms of features, but I think that's often too reductive. Like adding a feature, often changes what all the other features mean because it changed the whole user experience.

[18:56] **Henry**: Right, that's like trying to apply like the whole is greater than the sum of its parts to the software development.

[19:03] **Omar**: I remember hearing a story a few months ago. Somebody I met was talking about the daycare where he put his kid in. And how the daycare introduced this capability where you could check in during the day and watch your kids at the daycare because they have this camera.

[19:20] **Omar**: And we were talking about how the daycare is like, well, if you don't want to watch your kids, you can just not look at the camera. But like, to me, there's like a fundamental.. Like you've changed the whole dynamic by having this monitoring thing in place and by people knowing that you can use it. It's not like you can just add these things linearly and it has a linear effect and you can just opt out. It's like once it's there, it, it changes everything around it.

[19:42] **Henry**: Yeah, exactly. We tend to give everything on machine like quality, we don't think about the effect that essentially a surveillance has on daycare.

[19:51] **Omar**: Yeah. And I was wondering if part of the reason for this is that this sort of structure of the technology or the software is actually additive, right? Like to add a feature like, because you can add code, you kind of think of the effect of the code is also being additive.

> "I also wonder if code encourages thinking in features: because 'adding' a 'feature' mostly involves adding extra code onto your program, you assume the resulting experience is also additive (but it isn't! you're changing the whole program's experience, not only the new piece)" - [Omar](https://twitter.com/rsnous/status/1287275307200688128)

[20:06] **Henry**: Yeah, I think so. Something I was thinking about was like how religious institutions see technology. I was reading about Marshall McLuhan, and he had a lot of warnings about technology and how a lot of church people would just embrace it wholeheartedly, rather than kind of analyzing how that changes the experience of being in a building.

[20:26] **Omar**: Right, almost even like treating technology as like this separate category from rituals, or art, or culture. Like almost that alone, there's already something there where you can feel like you either have to adopt it wholeheartedly or reject it wholeheartedly.

[20:41] **Omar**: I think you should treat technology like anything else where you kind of take the things that you think are valuable and maybe don't take the things that you don't think are valuable. Instead of treating it as this like autonomous force.

#### Skeuomorphism to Flat: Building Off of Digital Literacy

[20:52] **Omar**: I have a friend \[[John Backus](https://twitter.com/backus)\] who talks about how using BitTorrent to pirate movies or music or whatever, it was only practical after people had already used Napster and Kazaa and these other services to pirate stuff. Because the audience had to learn these interactions and these way of doing things before you could introduce this BitTorrent way, which builds on the knowledge of the existing way.

[21:15] **Omar**: Another example, is if you remember computers in like the late 1990s, early two thousands, all the buttons were like 3d. They like stuck out of the toolbar, right. And then, you know, once people learned what things you could click on, they didn't have to be 3d anymore. Like now most of the buttons on your computer, they don't have those bezels.

[21:33] **Omar**: So there's always also this time dimension, of like people people learn and then that makes new kinds of interactions possible, or it means you can throw away some of the scaffolding that you had in the beginning.

[21:44] **Omar**: A corollary of this is also kind of like that. If there's a successful product like the iPod, it might not actually be that you could go back 10 years and they would be a success, or it might not actually be that like Google could have made the iPod instead of Apple.

[21:57] **Omar**: I think these things only work in that specific context where people are ready for it. And Apple has this cultural cachet that makes people want to buy in and all this other stuff. This is also a part of the theory of Dynamicland was to try to build a concrete community and culture in a specific place and do that right. And then grow out of that instead of trying to make something that's like a general product.

[22:39] **Henry**: Okay. Kind of the idea the way to go general is to go very specific, right?

#### A way of knowing by name (vs A/B test)

[22:45] **Omar**: And I think that's related to the idea of like testing things on yourself. I feel like there's a way of knowing where you have yourself, or you have people you know by name and you kind of are able to work that way.

[22:57] **Omar**: And then there's a way of knowing that's more like, Oh, let's try and scale things really big and then know things by statistical means A/B testing. And obviously I'm a lot more sympathetic to the former.

[23:10] **Henry**: It's funny cause the book I'm reading from McLuhan, he's saying that faith is a way of knowing. And I'm still trying to wrap my head around, but it's not a concept. And he actually uses the word percept, which I was like, I didn't even know that was a word, but I guess that's from perception.

[23:27] **Henry**: And I guess he's saying that faith is like a muscle or a sense like vision or hearing, where you have to be aware of something rather than a general abstract idea. And I think that's something that makes faith very embodied and personal, right. So there's that intuitional side and the idea that knowledge is through people. And same with faith, right? It's like something you have to experience.

[23:54] **Omar**: I mean, I like that because it suggests you can build up faith or you can build up these other forms of knowledge.

[24:01] **Omar**: There's the kind of logical notion of faith, which is that like, you know, I believe this, or I don't. And I think this is like a more true way of dealing with knowing things where often you have some relationship with the thing.

[24:11] **Henry**: At least in Christianity we talk about like faith being a relationship with God, meaning that it's like a dynamic thing. It's changing. Your sense of knowing increases over time. You might not really feel that, and that's why there's this push against the idea of "faith is only belief.

[24:29] **Omar**: Right. It's just like logical predicates. And I think that's like more accurate to like most things that are actually worth knowing, right? Like programming, or playing a musical instrument, or playing sports or whatever. These things are not like some set of facts.

#### Tacit knowing, constructivist education

[24:44] **Henry**: Yeah, I think that speaks to Michael Polanyi's thinking around tacit knowledge. He's basically saying knowing is an act of trust. You learn to be able to express, but even when you don't have no words for it, there's something that you know, right.

[24:58] **Omar**: Yeah. A lot of the original work on smalltalk sort of came out of this idea of constructivist education. Where the idea is, to learn something, you kind of have to build it yourself in your head. You know, making programming tools so that people can build the stuff they're learning about.

[25:13] **Omar**: And I think it's a similar idea. Even if you're writing down a tutorial or a textbook, and that's the way you're communicating it, it's not like the knowledge is being transferred through that. People are using that to build their own version of the knowledge of their own heads.

[25:26] **Henry**: Right, right. It's not directly transmitted to them. They still have to use that to figure out on their own somehow.

[25:33] **Henry**: Kind of amazing in a way, right? It's like communication. Everyone has to interpret in their own way and somehow hopefully the same concepts.

[25:41] **Omar**: Similar enough, at least. You can teach somebody to program and they can program things that work. So there's something going on that works.

[25:47] **Henry**: Yeah, it makes it feel like it's more magical, but in a positive way.

[25:51] **Omar**: It's like this sort of creative spark that can be shared.

[26:00] **Henry**: Yeah. Actually this is similar to when you're talking about how people think technology is just something you add onto. So Polanyi says that knowledge isn't just like another piece of data that you add to your brain, but it sometimes may change how you see the whole world, right.

[26:16] **Henry**: What was the other term? Like desire lines. Right? Once you learn how to ride a bike, you'll actually notice in your mind, bike paths. But if you didn't, you might not see them. Cause you're just used to walking or taking a car.

[26:30] **Omar**: That's a really good analogy. And that also gets to what we were talking about earlier about like the more you kind of know about computers,

[26:36] **Henry**: Yeah, right. And that's an expansive view of knowledge rather than the reductive one.

#### Tractability

[26:48] **Omar**: I have a thread somewhere on Twitter where I was looking at this idea of tractability. There was a blog post that a economic historian \[sic: should be 'historian of economics'\] \[[Beatrice Cherrier](https://twitter.com/undercoverhist)\] wrote a year or two ago, where she is talking about, over the last hundred years, how have computers affected economics and how have they constrained economics?

> "👍 the hidden influence of tools & materials on practice. (in this case, the hidden influence of availability & nature of compute on the practice of economics + subsequent path dependence)" - [Omar](https://twitter.com/rsnous/status/1163105743148421121?s=20)

[27:06] **Omar**: Because, you know, if you're an economist, you often are doing a lot of calculations on data. You're trying to like figure things out. And you're often using computers to do that, right? Like for the last 50 years or so, that's been one of the uses of computers. So how has the tractability of, things like what things are easy to calculate, how has that affected the field of economics?

[27:25] **Omar**: And then in my thread, I'm kind of trying to find other examples of this effect of tractability on the field of geography or on other fields. Cause this is often something people don't notice or talk about explicitly, right?

[27:36] **Omar**: It's not something that you'll read in the paper that we we didn't think about doing this other thing because we instinctively knew it wouldn't be tractable. You only see the things that people thought to do. And so it's just sort of hidden hand that's shaping a lot of things.

[27:47] **Omar**: Or the other example that I often bring up is that like deep learning was only possible once you had a GPUs that could like actually do the computations. And once you had like enough data. Those are kind of hidden forces that. It's not part of anybody's research to like make a GPU. And then suddenly that opened the flood gates, you could do all kinds of research.

[28:06] **Henry**: I see. So like this other functionality that seemed random at the time we can look back.

[28:12] **Omar**: Yeah. And nobody's said before that, Oh, we need GPUs to be able to do this. It was just not work that that was worth working on.

[28:20] **Henry**: Yeah. Opens up possibilities once someone notices something that happens. And it just happens to match up with something else they were thinking about.

[28:27] **Omar**: I think that technology often has a lot of these kinds of effects of limiting or expanding what people can do in seemingly unrelated fields.

[28:44] **Omar**: Maybe it's not in the incentives, cause you're working in a specific field where there's specific questions that you want to address and you don't want to go around talking about computers.

#### Respecting User Behavior

[28:52] **Henry**: I guess another theme I saw. You were saying like a respect for how people feel or how they use computers. Cause I think, whoever it is, can be dismissive of anyone's actions or reactions to certain things. Oh, this is supposed to be the right way of doing things.

[29:08] **Omar**: Yeah. I think one of the examples that I had was if somebody's making an HTML page and then just using bold tags or just like putting in-line CSS everywhere. And like, that's not what you're supposed to do, right? Like if you go on any tutorial, they'll tell you, you should make a separate CSS file or you should put everything in a style tag at the top and use classes.

> "i love this -- the energy of using screenshots and camera roll for everything, or making your Web page with HTML tables / b and font tags / inline CSS instead of 'the way you're supposed to'" - [Omar](https://twitter.com/rsnous/status/1285565425376301058)

> "So this was a big lesson to me. Of course doing it by hand on a computer may not be, you know, the perfection that computers are capable of, but it's much better than doing it by hand in hot metal. So it was a big improvement step for him, and I completely ignored that intermediate possibility in my wish to have the perfection, and I didn't even recognize that it would be exploited, and it was just a big lesson to me that less than perfect is still valuable, and in fact perfection sometimes, it delays things so much that meanwhile people keep suffering under the kind of the old methods" - [Simonyi, page 26](https://archive.computerhistory.org/resources/access/text/2015/06/102702232-05-01-acc.pdf)

[![screenshot of text from Simonyi on printers](https://pbs.twimg.com/media/Edc-UXiVAAECZ38?format=png&name=large)](https://twitter.com/rsnous/status/1285565425376301058)

[29:25] **Omar**: But the fact that people want to do that. Like, there's something to learn from that. About what kinds of things people want to do, and how those aren't suited to the prescription.

[29:37] **Omar**: Whenever you see people doing things like that, where it's like you kind of want to guilt them into being like, don't do that. But I think the reaction should be opposite. Like we should be trying to learn from that. Or people taking tons of screenshots and covering their desktop with screenshots. Why is that? I think it's because there's something better about screenshots.

[29:56] **Henry**: Right, the impulse would be like, Oh, we should find a way to prevent them from even doing that in the first place.

[30:01] **Omar**: Or we should like educate them to not do that.

[30:03] **Henry**: Right. Because it's a lot easier to just say that then to really maybe even talk to them and be like, Hey, why are you doing that? Like a clue to link how we could design something better.

#### Help people do what they want to do

[30:12] **Omar**: Yeah, exactly. And you know, like the point of computers is to help people do what they want to do. And so if we can change the computer instead of changing what people are doing, I always feel that's a better option.

[30:25] **Omar**: The other example that I always have in mind is spreadsheets, which are used for so many things. And sometimes you see this impulse, especially in kind of tech startup circles that every time you see a spreadsheet, that's like a potential business. Cause you could replace it with custom software.

[30:40] **Omar**: But, I mean, I think there are a lot of good things about spreadsheets. And there are a lot of things to learn from them. And we shouldn't be so quick to interpose ourselves.

[30:48] **Omar**: When people are using them, if there are problems with spreadsheets, maybe we should fix those problems instead of throwing the whole thing out because we have some kind of aesthetic objection to them or for whatever cultural reasons we have.

[31:04] **Henry**: Yeah. I think that related, you had a desire to star a line of a code, like favoriting a tweet, right?

> "i just had the impulse to star a line of code like it was a tweet or something" - [Omar](https://twitter.com/rsnous/status/1292046169871245313?s=20)

[31:11] **Omar**: And that's kind of like, In the same way that I think we should learn from spreadsheets or taking screenshots or barfing inline CSS everywhere. I think we should learn what we can from social media. Like why are all these interactions like so satisfying? Like can we take that and kind of apply it in other contexts like programming?

> "i think when you star a line of code, the person who wrote it should get a notification" - [Omar](https://twitter.com/rsnous/status/1294172471080361984?s=20)

[31:35] **Henry**: Yeah. Coding itself isn't that social from line of code point of view, even though all of open source of supposedly social.

#### Really Fine Grain Open Source

[31:47] **Omar**: Yeah. I mean, I was complaining earlier about how.. We talked about this earlier today. If you're using an open source library and it doesn't do something that you need, it's really hard to, even if it's totally open source and you have all the freedom to fork it and modify the code.

> "I have a lot of problems with open source as-is as a solution to this -- I think it's hugely more difficult and takes a lot more willpower to fork a library or send a pull request than to change something in your own code. you really have to go out of your way" - [Omar](https://twitter.com/rsnous/status/1292639339730542593)

[32:01] **Omar**: It's like still a lot harder than if you're just changing something in your own project. I think in some sense, the grain of opensource is too coarse or too big. I think I want to play around more with like really fine grain open source. That's where it is sort of at the line of code level or the cell level with a spreadsheet. And that's the level that you're working with people at.

[32:26] **Henry**: Is it because the thing that you're looking at is too big of a codebase?

[32:31] **Omar**: That's part of it, but I think whenever people have to switch between what feel like different tasks, that's always a huge barrier. And I think switching from like, I'm working on my project, didn't you max, to like, Oh, I have to go on GitHub and fork this project and then re-clone it and change it in my package manager configuration, like that's a huge task switch and that's why people dread doing that.

[32:54] **Omar**: And you know, one thing I bring up sometimes. This is also the reason I think people often don't want to use a debugger. Yeah. It's, it's like a huge task switch from just like, and running your program to, Oh, now I have to use this different debugger interface that I maybe don't use that often. I have to go out of my way to like click the debugger button.

[33:10] **Omar**: But I think once you start looking for these, they're kind of everywhere. And it's like maybe rationally you've given people all the tools that they needed. But emotionally, people are not going to be eager to use them if it takes them out of their flow.

[33:19] **Henry**: Right. They think of it as different modes and writing a console.log feels like writing code.

[33:26] **Omar**: And it doesn't give you a chance to, while you're switching tasks, go do something else and get distracted. I think a lot of the problems I have with multitasking or being distracted by social media or whatever, you can almost think of these as maybe they're just interface problems where we have interfaces that like almost encourage you to get distracted. And I don't just mean notifications. I mean like the actual task work of like programming and debugging and compiling, I think has all kinds of opportunities for you to just fall off a cliff.

[33:50] **Henry**: Yeah. it feels like there's like a whole interface when you only want to look at one thing.

[33:55] **Omar**: Yeah. I mean, it's like if you're biking around and suddenly you have to get off the bike. Like you don't want to get off the bike, if you could avoid it, and park it somewhere.

[34:04] **Henry**: Right. We know that it's better in every situation, but it's like, I just want to know the value of this thing. I'm just going to log it right.

[34:11] **Omar**: Right. I mean one solution that people have occasionally used, is like, you just do all the programming in the debugger. And I think that's maybe something that's worth looking at.

[34:19] **Omar**: People often talk about visualization, like data visualization of what your code is doing. This is a lot often how people see like Bret Victor's work is that it's visualizing your code. But I'm always uncomfortable with the framing of visualization, because to me that implies that like the visualization is something you have to go out of your way to make, like you have to click a button or you have to like insert visualization hooks.

[34:43] **Omar**: And to me, like that introduces the potential again, to like fall off this cliff or to like dread doing that because it's a mode switch.

[34:53] **Henry**: Okay. That seems similar to what we were talking about with like form and function, about how we separate them. Cause it assumes that we just have to change the UI and the structure is the same thing. But you're saying maybe the reason why it's that way is the structure itself needs to be different.

#### Emotion-aware Programming

[35:13] **Omar**: Yeah. Like it's not sufficient to just give people a tool that theoretically does the thing. It has to be integrated in the experience in a way that works emotionally.

[35:22] **Henry**: Yeah. I like that, emotional programming. I guess I never thought about how dread is such an important feature of thinking about how to design, yeah.

[35:31] **Omar**: Yeah. Once I kind of started introspecting about like, what am I thinking and feeling when I'm programming and why am I not doing things? I noticed that there were all these weird emotional forces that are really determinative of what I'm doing at any given time.

> "when I used to TA intro systems programming, kids similarly dreaded using gdb -- they would do almost anything, even if it took way longer and they were completely stuck, to avoid breaking it out" - [Omar](https://twitter.com/rsnous/status/1257165574032879616)

[35:45] **Omar**: And I originally noticed the debugger thing, I tweeted about this, because I was TAing a class in college with freshmen and sophomores who were learning how to program in C and they hated using the debugger. Like they would do almost anything to avoid, to avoid having to pull up the debugger. And again, it's always tempting to tell them. we did usually tell them, like, why don't you open the debugger? But I think at the same time, there's something to learn from that. Like, why don't people want to use the debugger?

[36:14] **Henry**: Yeah. I mean, I think about this for any tool in JavaScript, like nobody ever wants to open their Babel config. I know the answer is that there shouldn't even be one. I don't know how to implement that, but.

[36:25] **Omar**: Right. That would be my radical, you should just reprogram Babel if you want to. But it is true that when I'm programming my thing, every bit of code that I write actually has a visible effect on the thing that I care about. But if I have to switch into configuring something, number one, it's a switch and number two, I've lost that direct connection to my actual domain.

[36:42] **Henry**: I understand that because it's like, there's no time where anyone would ever want to even think about configuring Babel. Like I wouldn't ever either.

[36:50] **Omar**: Yeah. I don't know. I never blame people.. Or I don't pretend necessarily that I have alternatives for these things, but I just want to point them out.

#### Being Immediately Useful

[36:57] **Omar**: It also reminds me, you know, there's a great book \[A Small Matter of Programming\] by Bonnie Nardi, who's an anthropologist on end-user programming. And she points out that this is kind of the genius of spreadsheets.

![cover art of the book, A Small Matter of Programming](https://user-images.githubusercontent.com/588473/95124439-6f722980-0721-11eb-9472-07be9d8e1f48.png)

[37:05] **Omar**: Like you open up your spreadsheet. You start typing your data, your list of things, and like it's immediately useful. You don't have to initialize a new project. You don't have to write a bunch of code so that things will appear on the screen. Things are on the screen from the beginning. From the beginning, you're already working in your domain, you already have your stuff that you actually care about in the system.

[37:24] **Omar**: Whereas if you were making a react project or something, you know, you need to write a bunch. If you want to get your data on the screen, you have to like load your data from a JSON file. And you have to write a bunch of loops to make elements for all your data. There's a lot of upfront stuff you have to do, that's not related to what you care about.

[37:41] **Henry**: Yeah. Programming just feels so far removed from Excel.

[37:45] **Omar**: Yeah. Well there was an interesting demo by Yoshiki Schmitz, who's one of these kinds of people in our Twitter community. It's a prototype of a way to turn JSON data into an interface. Maybe you have data of a bunch of apartments and you want to turn it into an Airbnb type of interface.

> "I've been jamming on this concept for making data-driven designs. Given some JSON, this app will provide you with an interface to describe how you want each entry styled, allowing you to gradually create a more complicated design. Here I create an airbnb-ish app." - [Yoshiki](https://twitter.com/yoshikischmitz/status/1176642448077967362?s=20)

[![tweet of Yoshiki's demo](https://user-images.githubusercontent.com/588473/95124614-ad6f4d80-0721-11eb-8667-989bc4f69506.png)](https://twitter.com/yoshikischmitz/status/1176642448077967362?s=20)

[38:06] **Omar**: I don't know if you've seen this, and the way it works is like, His prototype, basically you import the JSON and then it immediately renders all of it on the screen. It's like a list of stuff. And then you can incrementally tweak the way that list looks into the interface you actually want. So you never have to write that loop of making all the elements. You start out with all the elements.

[38:28] **Henry**: Yeah, that sounds cool.

#### "Open input" spaces

[38:30] **Omar**: I don't know if this fits anywhere, but I'm really interested in stuff where there's this kind of open input space.

> "really interested in these kinds of open-input-space 'hacks' (sort of like how Screenotate builds up from screenshots instead of structured notes, or how acme lets you use plain text to generate behavior)" - [Omar](https://twitter.com/rsnous/status/1128558357256650752?s=20)

[38:35] **Omar**: And the three things I think of are like screenshots, where you can take a screenshot of anything on your screen. Like I make a screenshot app, but I don't need to know what kinds of stuff can be valid screenshots.

[38:46] **Omar**: The real world. And this is kind of what dynamic land did, where like, you know, if you have a program that's printed out, you can put post it notes on it, or you can scribble on it or whatever. The system doesn't prescribe what kinds of things you can do.

[38:58] **Omar**: And then the third example is actually file systems on your computer, where you actually have all these operations you can do to files and you can move them around and put them in different places. And like, if you have a Word file, Word doesn't prescribe where you can put that file.

[39:13] **Omar**: If it's in your computer's file system, you can put it in Dropbox, or you can organize it so it's near all your other up to you. There's this kind of pretty open space of things you can do and operations, you can do that don't come from the software.

[39:29] **Henry**: Hmm, it doesn't make assumptions about the input.

[39:32] **Omar**: Yeah. And this is more true for screenshots and for the real world, you can attach things to the input and even if it doesn't know what they are, they kind of make it through. So I'm interested in those ways of like, how can we make software that has this nature to it, where the engineers don't need to implement features for everything that users want to do. I had an example, I think a year or two ago about like, what if Twitter let you just attach other fields to your tweets. But even if Twitter didn't understand them, you can just attach your own metadata to a tweet and have it go out to their database.

[40:04] **Henry**: That was interesting. A lot of stuff to cover, honestly. Well, hopefully it was helpful for you to just think about stuff you've been thinking about.

[40:12] **Omar**: No, this is a lot of fun, and I think it’ll be good.
