---
title: "Embodied Knowledge (Maggie Appleton)"
season: 3
date: "2020-11-02"
time: "25"
description: "Can there be knowledge without a knower? Maggie Appleton joins Henry again in a 2-part chat to discuss how knowledge is personal, through the work of Michael Polanyi. We cover how knowing is an activity, ambient technology, dualism, Bruno Latour, knowing as faith, learning through liturgy, Jesus as the embodiment of God. We end by asking how we should navigate the post-truth world."
episodeLink: "8960d710"
embedUrl: https://share.transistor.fm/e/e272736d
sidebar:
    order: 9
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/embodied.md)

#### Indwelling

> I've mentioned Polanyi many times throughout this podcast, so maybe it's either annoying or it's like, what are you even talking about? So it's good to do a whole episode around his thinking.

[00:00] **Maggie**: So I know you'd been reading more about (Michael) Polanyi, but I haven't fully read his book, [Personal Knowledge](https://press.uchicago.edu/ucp/books/book/chicago/P/bo19722848.html) as much. I was curious to hear what you'd been thinking about around him.

> "Hence the wide scope of this book and hence also the coining of the new term I have used for my title: Personal Knowledge. The two words may seem to contradict each other: for true knowledge is deemed impersonal, universally established, objective. But the seeming contradiction is resolved by modifying the conception of knowing." - Personal Knowledge, preface

[00:10] **Henry**: So Polanyi has this idea called indwelling. He's saying indwelling is an active process that we all partake in. As people, as knowers, when we integrate the clues in the world to determine certain ideas about reality. It's related to a lot of embodied terms like, filling ourselves up. These are all like bodily ideas about knowledge, right?

> The Oxford definition of indwelling (within a theological context): "be permanently present in (someone's soul or mind); possess spiritually."

[00:33] **Henry**: And I think that is an aspect of perception and awareness. There's a sense that we are blind because like we can see things with our eyes, but if our minds don't see the pattern that's there, they won't show up. And so he was saying the body is actually something we always indwell, meaning we always are relying on our body. We can't focus on our body, cause we live through our body. We are, like we said, embodied beings.

> "And our body is the only aggregate of things of which we are aware almost exclusively in such a subsidiary manner." - [Polanyi, The Structure of Consciousness](http://www.polanyisociety.org/mp-structure.htm)

[00:57] **Maggie**: Yeah. Did we talk last time about directionality in cultures and intuitively knowing what direction you're facing.

[01:05] **Henry**: Yeah, I think you mentioned like the whole behind and forward in terms of time, yeah.

> "They talk about the past as being in front of them because they can see what's happened and the future is behind them because they can't see it." [Maggie, metaphor episode](https://hopeinsource.com/metaphor/#t=14:44)

[01:09] **Maggie**: Yeah. And then there's also one where depending on the language you speak, it will affect your ability to perceive directions. So in Papa new Guinea, there's a couple of places too, if you say good morning to someone, you see it in a way that's like, good morning, I'm walking Northeast. And they might say, good morning, I'm walking Southwest. So in every single interaction and exchange you have, you are stating your positionality in the world and it makes it so that children of these cultures, if you ask them what direction Southwest is, they can point and it's dead on. It's correct.

[01:42] **Maggie**: They just know because the technology of their language has given them this bodily understanding of directionality in a way that we don't have, right. If someone asks us where Northwest is and we're inside the house, most of us who speak English would just have no clue.

[01:59] **Henry**: It's not something that people ask, so you wouldn't even have an answer. You just like Google it or something. Yeah.

#### Ambient Technology

[02:05] **Maggie**: Yeah. And I love this idea of indwelling, of like ambient technology that takes more advantage or is more entwined with our bodily experience in the world. I know that Google is doing work on trying to put [wearables into clothing](https://atap.google.com/jacquard/), but we use very little haptic feedback in our current technical systems. I always think of fitness trackers, especially.

[02:25] **Maggie**: So vibrating certain parts of the body to give information. It doesn't take a lot of cognitive ability to clock something like that. And we rely so much on visuals right now. So if you get a notification, right, it's some popup in your sidebar, or it's on your phone and it has to make a noise and it interrupts your cognitive flow in a more explicit way.

[02:44] **Maggie**: And I don't understand why or what the barriers are to us having something like, you know, if I got a certain message that my right shoulder would vibrate, and if I got a different kind of message, you know, like something like my left leg would vibrate.

[02:57] **Maggie**: Cause to get back to the directionality one a bit. I had heard from one of my other friends, a story of someone who had built themselves a belt that would always vibrate in the direction of North when they were facing it. And think of how quickly you would learn which direction North was, if just there was this very tacit nudge that gives you like, Oh, okay, that's North. And even if you were in a house, you would suddenly learn to understand the direction so fast.

[03:23] **Henry**: Wow. I guess it really is just the assumptions that we have about how things work.

#### Digital Affordances

[03:28] **Maggie**: I mean, it gets us back to the technology as tools with like the affordances baked in, that because we've all been handed the web and our digital mediums from this historical legacy of being visual first and text first. That we don't have the design patents for embodiment or using light or sound in different ways with them, even if we now have more of the material infrastructure to be able to do that.. Or kind of, I mean, most of us can't actually hack together a raspberry PI system that has like cool led lights that communicate things to us or haptic feedback stuff, right.

[04:05] **Maggie**: We can build an app in React, but you know, we can't build things into our house that are more just like inventive technology processes. Or it takes a lot of work to, or at least I've tried Googling it and it's harder than I can figure out.

[04:19] **Henry**: It might be just, we kind of reflect the kind of programming that we do. When we're writing code, we're using like lists and maps. Basically we see all these lists, so we just assume that it's going to be like a feed or in Zoom it's a box. We don't know how to think spatially, so it's just not what we turn to.

#### Paperclip Thought Experiment

[04:43] **Maggie**: Yeah. That's funny. I had done a talk recently. Do you know the paperclip machine thought experiment, from AI?

[04:50] **Henry**: I dunno if it's the same.

[04:52] **Maggie**: It's from Nicholas Bostrom and [Superintelligence](https://en.wikipedia.org/wiki/Superintelligence:_Paths,_Dangers,_Strategies), which I haven't fully read of course. He first proposed this thought experiment that we build an AI and we don't correctly have it understand the value of human life. And we tell it to make paperclips. So it starts making paperclips and then it realizes that if it kills all the humans, it would get much more efficient at making paperclips because we get in the way and we take resources. So then it kills all the humans and it just makes paperclips forever, and that's the parable of why AI is dangerous.

> [Paperclip maximizer](https://en.wikipedia.org/wiki/Instrumental_convergence#Paperclip_maximizer)

[05:22] **Maggie**: And I was being a bit maybe coy with it, but I'm relating it to.. Sometimes in the React world, it feels like we have this runaway todo app machine, where every single app that gets made as a todo app. People see that everyone else is building todo apps, every tutorial teaches you to build a todo app.

[05:38] **Maggie**: And todo apps, right, they do the create, read, update, delete which like these essential functions. So it is a great example, but what happens when everyone in the community is looking inwards at themselves, or when I say themselves at other members of community and what they're building and they build what they see, because it's just this self reinforcing loop.

[05:58] **Henry**: Yeah, I guess we'd like to think we can be more creative, but that's just what you turn to. It's the same with a Hacker News clone.

[06:06] **Maggie**: It requires a balance, right? Cause we can't check out all previous norms. Cause our users won't know what they're looking at or what to do with it. I imagine this is where the Dynamicland stuff would relate a lot. Like whatever they're doing there sounds really cool. Of course it's all very mysterious and we're not quite sure what they're doing. But it seems like, we can't even fathom what they're making, because it seems like it's going to be so different from what we're used to using.

[06:32] **Henry**: Actually that's a good point. I think that might be a reason why it's hard to fund that or because they are going for something so out there, thinking years ahead, then practically speaking, it is research and it might not be as practical. Maybe there are people that are inspired by things that they do, and they try to make it very practical. But then in a way, they're just kind of doing the same thing as before with a different like skin, like the same list idea.

[06:59] **Henry**: And I think maybe some people might even think we need to start over. I tend to not want to do that in general. Because of the idea of tradition. There's all these things that were encoded in what we do that have benefits. Yeah, that's just the whole tension between like revolution and incremental change. And how do we handle both of these things?

[07:21] **Maggie**: Right. Yeah. The answer is rarely burn it all down. You know, that's rarely the right move.

[07:27] **Henry**: Right, we don't understand the second order effects of whatever is happening right.

[07:33] **Maggie**: Yeah. And it always just bounces back. There's always a reaction to any extreme action.

#### Knowing is Subjective

[07:39] **Henry**: Some more on Polanyi. In knowing itself, if there's a knower at all, which is us, it means that knowledge has to be inherently subjective, right. And that would imply that there's no such thing as a purely objective knowing.

> "Such is the personal participation of the knower in all acts of understanding." - Personal Knowledge

[07:54] **Henry**: And that doesn't say that there isn't objective knowledge. It just means that when we pursue science, it's through subjective means, which is personal. Cause I think it's too easy to be like, well, everything is just whatever you make it of it. There's no actual reality.

> "But this does not make our understanding subjective. Comprehension is neither an arbitrary act nor a passive experience, but a responsible act claiming universal validity. Such knowing is indeed objective in the sense of establishing contact with a hidden reality" - Personal Knowledge

[08:10] **Henry**: He's trying to combine these two ideas, there shouldn't be a distinction between the subjective and objective. And this indwelling, makes those things make sense. It's a process of integration between these two.

[08:23] **Maggie**: Yeah, I was reading a bit of Polanyi's.. The very beginning of his book, where he was going into this subjective knowledge thing. And it was so strange to read it, cause what field did he come from? I confused him with his brother for a minute, but he was in science.

> It seems to be very common to mix the two, as Karl Polanyi is also well known for his book, [The Great Transformation](<https://en.wikipedia.org/wiki/The_Great_Transformation_(book)>), and people just refer to either by their last name.

[08:36] **Henry**: He was a physical chemist. He was super into like the actual practice of science until he decided to essentially switch.

[08:44] **Maggie**: Because I found him fascinating that he had come from this more hard science background and everything he was writing to me read just like a postmodern anthropological take.

#### Bruno Latour: hybrid objects

[08:55] **Maggie**: So in anthropology, that was this big postmodern movement and it just was reading word for word like another thinker called [Bruno Latour](https://en.wikipedia.org/wiki/Bruno_Latour), who's a French philosopher and anthropologist, who went in and studied scientists in their labs and then did an anthropological study of scientists as a culture, which the scientists, some of them found quite offensive, which is quite funny as if they're saying, you know, Oh, well, we don't have culture. You know, we're just doing science and labs.

[09:24] **Maggie**: And Bruno was quite innovative doing this throughout the seventies and eighties saying no, no, you know, you have culture just like everyone else. Anthropologists don't just study people on islands and claim they're the only ones with culture, you know.

[09:36] **Maggie**: It's like everyone has cultural beliefs and biases and blind spots. And pointing that out was quite an innovative thing. But him with Polanyi was so strange because Bruno Latour has this theory about what he calls hybrid objects, which says, you know, how do we explain that everything is cultural and subjective and yet also hold that the physical world has what he calls like a robustness to it that you can't deny.

> "facts remain robust only when they are supported by a common culture, by institutions that can be trusted, by a more or less decent public life, by more or less reliable media." - [nytimes](https://www.nytimes.com/2018/10/25/magazine/bruno-latour-post-truth-philosopher-science.html)

[09:59] **Maggie**: Like I can't deny this table is solid and I can't put my hand through it. I don't have the subjective opinion that I'm able to put my hand through the table. Or that how do we understand that everything is a hybrid of both social, cultural beliefs and physical reality.

[10:16] **Maggie**: He's uses the example of quarks, that if we didn't have any conception of what a quark was. That's a cultural concept. We've given it a name and we've studied it in like a very cultural space where we said, okay, this is how we're going to study that quarks exist. And we're going to use all these special instruments to study them.

[10:33] **Maggie**: And then we're gonna tell ourselves stories about what quarks are and who they're important to and why they're important. Those are all social, cultural layers to it. But at the core, if we hadn't told any of those things, they would still be quarks in the universe. So like, how do we blend those, but I liked his idea of that there's like this layer around them.

[10:50] **Maggie**: So you have the physical thing and there's the social cultural layer on the outside. And we can't see the quark without looking through that layer, right. We built the layer and we're inside of it. And there is no way for us to step outside of it, into this objective, idealist, modernist viewpoint, and be like, no, no, I know what quarks really are because the numbers on my graph that I have also invented, you know, say this quark exists. It fails to recognize that the graph itself and your measurement devices are cultural artifacts.

[11:21] **Henry**: That makes sense. This makes me think about Aaron's post, [Metaphors We Believe By](https://aaronzlewis.com/blog/2019/07/25/metaphors-we-believe-by/), and how the God that we kill might just be a certain conception of it. That doesn't mean it's not there. Or that we create our own machines and they turn into our idols.

#### Understanding Someone in Bits and Pieces

[11:37] **Maggie**: So yeah, Polanyi was quite impressive. I agree with you, this thing of coming to people slowly and sort of like edging around them and taking in their work in bits and pieces as you need it. Actually it's quite a nice embodied metaphor.

[11:50] **Henry**: It makes sense you could do that with him or anyone, that's kind of the whole point.

[11:55] **Maggie**: And I do like that approach too, cause it's different to what I would maybe think of as the popular understanding of how your quote unquote supposed to study or consume someone's.. consume even oh that word.. but read someone's work currently, right.

[12:11] **Maggie**: You're supposed to like sit down and you're like super focused mode and take really great notes into your digital Zettelkasten system. And take out all the highlights and automate the process and tweet about it. It's a very specific way of interacting with knowledge, as opposed to coming to it in bits and pieces and revisiting it in small chunks over time, and not turning it into some sort of information filtering system.

[12:36] **Henry**: We said this before, but that is the whole reductionist view of information, that you can just download it.

#### Knowing as Worship

[12:42] **Henry**: I think that's why he kept going back to these metaphors about faith. He was trying to compare it to worship, which you could say is just simply singing, but it could be the fulfillment of what knowledge really means. It's like to truly understand somebody or something and to give it the honor that it deserves.

> "Religion, considered as an act of worship, is an indwelling rather than an affirmation" - Personal Knowledge, pg 279

[13:03] **Henry**: If we want to know somebody, you're not going to do all your research on someone before you get to know them. It's good to have some kind of context, but wouldn't you rather just actually talk to them?

[13:14] **Henry**: And you could say the same thing about God, it's like, I can read a bunch of stuff about him or what other people said about him. I think communion is a good word to describe what the relationship is supposed to be like? What is prayer really about? Not thoughts and prayers, but like actually communication. And communication is a relationship. And I think that's why in this sense faith is a relationship.

[13:37] **Henry**: And I think that represents a good way of thinking about how we might want to relate to knowledge too, even though it's not a real person, we personify. And that's why it's personal, right? Any topic that you care a lot about, you're obviously gonna put your whole body, mind, and soul into this thing.

[13:56] **Maggie**: Yeah. I liked that so much, that idea of yeah putting like the embodied action investment into, when you care about something to try and be part of it. I'm now thinking about when someone gets really into a theory or an author, and they want to go do something like a pilgrimage to where that person maybe used to live or they, or they'll buy a really nice copy of the hardback edition of one of their books, right.

[14:22] **Maggie**: And what they're seeking is some sort of meaningful embodied experience with what so far has just being more of a detached mental experience. Maybe just text on a page. I was thinking of this because all around London, we're sort of getting allowed to go around a bit more again, with locked down lifting.

[14:41] **Maggie**: And I always love all around London, they're these blue plaques on houses that you see where the famous people used to live in the house or not. So there's hundreds of them, but you can be walking around London and be like, Oh, like Friedrich Engels used to live in this house. Or like, Led Zeppelin or whatever visited here in this year, or here's the old Beatles recording studio.

[14:59] **Maggie**: So you can kind of go to these locations and see it. And you go, what's the point of having these? But it gives you so much more of this, like, Oh, for some reason, this feels now like I'm more embodied with my relationship with this person, that was before just an intellectual one. And now I'm standing where they stood. It does have meaning to us.

[15:16] **Henry**: Yeah, because otherwise in the end, what makes a single place distinctive from any other? I like the word particularity right? There's something that's concrete, it's not abstract.

#### Truth through Ritual

[15:27] **Henry**: Because we were talking about how knowledge is subjective, but leading towards something objective, the question might you might be asking is how do you know something is true then?

[15:38] **Henry**: And he's saying that you can't ever know for certain what the truth is, meaning that we're all fallible, right? You can't be a hundred percent certain; you could say that's very postmodernist. He's trying to say that the way we showcase that to ourselves and other people is through commitment. Meaning that you will stake something on the things that you believe. The same idea of skin in the game, right? So it is not an intellectual thing. Right? And we could say in faith, we devote our life to this thing, right?

> "Every act of personal assimilation by which we make a thing form an extension of ourselves through our subsidiary awareness of it, is a commitment of ourselves; a manner of disposing of ourselves." - Personal Knowledge, page 63

[16:12] **Maggie**: Interesting. So is it the theory of skin in the game and saying, okay, no, I believe this thing, so I'm going to put material time and effort into it. Is there something if lots and lots of people believe something's true, that that's where they start to build physical artifacts to demonstrate commitment to it. Would that add up?

[16:31] **Henry**: Yeah, I think so. I think I might emphasize more of the practices. So like liturgy, ritual, right? Not just you actually, it becomes a part of the community and that would be like a church setting or a science as a general community, right.

[16:46] **Henry**: Those artifacts become the liturgies. And liturgies are in a way practices that are embodied through people doing them, because if no one does them anymore.. If people wrote down how to pray or worship, and you have the instruments for it, and the setting like the cathedral, but no one actually does it, then you probably won't be able to pass that down anymore.

[17:10] **Maggie**: Right. I mean, yeah, that is very like a live belief and knowledge that have, you know, thousands of people engaging in a certain practice. Is there any greater signal of it, you know, if something being true for lots and lots of people then actively there being enormous numbers of people living out a long tradition of ritual and a practice.

[17:32] **Henry**: And I think that's why modern American worship are a lot more almost like pop culture-ish and other people are like, no, we need to be more traditional like hymns. And I understand the appeal of that because like the whole, I've still where other people stood or I'm saying the same things that other people have been saying for the last thousands of years. There's something special about that, and we shouldn't get rid of it just because we thought it sounds weird.

[17:57] **Maggie**: Right. Cause we probably receive it as a little bit of arrogance, right. When people say they're going to throw out history. It's to say, I don't think that anything that has come before.. You give up the idea that it could have something you don't understand. Singing a hymn that has been sung for thousands of years and you think, Oh, well, you know, it has no meaning to me, let's just not do it anymore. You're not making space for what maybe it can like teach you that you aren't consciously aware of.

[18:23] **Henry**: Yeah. Cause it means that the focus is on the content again, because the medium is different, right. Hymns in itself is a different medium than just the normal song.

#### The Incarnation as Skin in the Game

> "The Word became flesh and made his dwelling among us. We have seen his glory, the glory of the one and only Son, who came from the Father, full of grace and truth." - [John 1:14 NIV](https://www.biblegateway.com/passage/?search=John%201&version=NIV)

[18:31] **Henry**: And actually, skin in the game, specifically in Christianity, is really interesting. And I didn't really put the two together. The story of Christianity itself is God becoming a person, right. That is it's own skin in the game of like, assuming you believe in any of this and that it's a positive thing, God becoming a person and representing us, is saying I care about you. I will actually become incarnate, like an actual embodied being. And then also the whole death and resurrection part too. That to me is a reminder that Christianity should be very anti-modern and it should embrace this idea of embodiment more.

> "So it appears that the church founders really wanted Christ to have skin in the game; he did actually suffer on the cross, sacrifice himself, and experience death. He was a risk taker. More crucially to our story, he sacrificed himself for the sake of others." - Skin in the Game, pg 120

[19:10] **Henry**: And this pursuit of absolute knowledge. It's funny because isn't the whole point of our faith, faith. It's not as black and white. And so you can still believe that God is in control, but we aren't the ones in control and we aren't the ones that never have doubt.

[19:28] **Maggie**: Hmm. I like that. I hadn't thought of that before. That embodiment clearly being so symbolically critical. And then God coming into human form and the resurrection, clearly yeah it's a signal that embodiment is important.

[19:41] **Maggie**: And in my head, I'm just finding it an interesting contrast to what I would maybe think of as I want to call it like the digital religion, but, you know, the transhumanist ideal that is a little bit religious in many ways. It's ideal is to escape embodiment, right?

[19:55] **Maggie**: Like all the rhetoric around, well, not just living in the cloud, but not caring as much about your body or it being a burden or weight. You have to like upkeep it. It's talked about as this inconvenient thing. Yeah, it doesn't allow you to just like fly through cyberspace, right?

[20:12] **Maggie**: Like is like the VR dream of everyone wanting to just put on headsets and not have to deal with like that physicality. That's funny. I hadn't ever thought of, of the contrast between those two. And I wonder if then transhumanism is some sort of reaction to maybe some of the more traditional religious beliefs.

[20:30] **Henry**: Yeah. Actually, even in revelation, when Christ comes back, we talk about this idea of new heavens and new earth. And we will all have new bodies. And so whatever that means, there is a belief that we will still have a body, we're not just a spirit, right.

> "Then I saw “a new heaven and a new earth,” for the first heaven and the first earth had passed away, and there was no longer any sea." - [Revelation 21:1 NIV](https://www.biblegateway.com/passage/?search=Revelation+21&version=NIV)

[20:46] **Henry**: Typically you think that you go to heaven and you leave your body. We're all like little spirits floating around, but in this case, no. It's actually saying that that that's a vital part of the end, if you want to call it that. And I think the end for transhumanism is like you said, it's an escape of the body because we see the limitations of it and we want to get rid of that.

> "But our citizenship is in heaven, and from it we await a Savior, the Lord Jesus Christ, who will transform our lowly body to be like his glorious body, by the power that enables him even ito subject all things to himself. " - [Philippians 3:20–21 ESV](https://biblia.com/bible/esv/philippians/3/20-21)

[21:06] **Henry**: And I think being a person in the context of faith here is understanding our limits. And I think idolatry is saying that we are God. And this is not something that is fun to hear, you know, like we want to become God, of course, we want to be the one in control.

[21:24] **Henry**: And here, this is the idea of surrender. It's the idea of letting go, that I am not in control. And I'm gonna have the faith that hopefully something positive will happen. And it's because I believe in someone that has those interests in mind, right.

#### The Stability of Beliefs

[21:40] **Henry**: So Polanyi had an essay called [Stability of Beliefs](http://www.polanyisociety.org/mp-stability.htm). It was just talking about various beliefs of even indigenous cultures. And how especially Western people think that what they do is just absurd or just weird. It doesn't make sense, but in some sense it, maybe it doesn't, but those things work for them. And there's something about it that works, that is true. It sort of supports the idea of conspiracy theory in a way, and not being so judgemental over that. It's hard not to, obviously I get extremely frustrated.

[22:15] **Henry**: And I think Aaron [tweeted](https://twitter.com/aaronzlewis/status/1293367838762250241?s=20) about how the president of TED made a video about how the people that believe Bill Gates is doing this, they're crazy. And I think people that listen to that, it only reinforces their belief that they are right. And so Polanyi is saying the same thing where if you have a different way you see the world, it is literally a different language, a different world. Different concepts and meanings for the same words. And you have to understand from within that view, because on the outside, it's always going to look strange.

[22:46] **Maggie**: I definitely struggle with that as well, right. That if we take seriously post-modern subjective truth. Then anyone else's decision of what is true for them and their cultural context, we have to take as valid. Which is interesting if we tie it back to Bruno Latour's robustness thing where at some point there's a material reality to it.

[23:07] **Maggie**: So, I mean, especially in the context of, right, maybe COVID and facemasks. There's a point in which the infection rate, human bodies get the disease. That's like a very hard to deny reality of a situation. But there's such disjuncture, right? In like all large scale media landscape between the actual infection numbers, and maybe one person individual's behavior and their location, and their cultural beliefs around whether it's real or not.

[23:33] **Maggie**: And whether, what was it, Bill Gates' vaccine is going to inject us all with mind controlling.. Yeah. Like at some point, you know, there's like a robustness to some form of reality that having a strong connection to is probably important in whatever our understanding of truth is.

[23:49] **Henry**: Yeah, it's so fascinating to me to read this. It validates my thinking, but then I was like, Oh, validates, all of us. It's just like learning to empathize with people, just like other people are doing with me.

[24:02] **Maggie**: Yeah. Yeah. Cause yeah, I mean I'm in the same boat. Telling someone they're wrong is like the worst possible way to convince anyone of anything, right. And yet, yeah, to be able to make space for like multiple truths and ways of seeing the world and not just shutting people down because there's a different to yours. Yeah. I don't know if there's as much validity to just, you know, anyone's saying like, okay, like this is, this is my truth and I get to believe it.

[24:27] **Henry**: I guess it's just, we can say that abstractly, but when, when we find something that we think is just completely right or completely wrong.. And like we said before, there's nothing we can be certain about. I say that. But yet we all believe in certain things that we think are just, that's just how it is.

[24:43] **Maggie**: Yeah. So I am curious to dive into Polanyi more. I don't know if he's really going to have the answers for this sort of thing, but I do have more faith in books that have been around for longer. And you go like, okay, we know this is like a very modern thing we're struggling with, right?

[24:56] **Maggie**: Like this post-truth world quote unquote. How do you manage multiple truths or having to interact with each other in a close internet space? But yeah, hopefully going back to people like Polanyi, you're going to be more insightful and useful than whatever medium post was written this week on it..

[25:10] **Henry**: Thanks for listening to this episode of Hope in Source. If you'd like to continue the conversation, you can join our discord, or find me on Twitter @left_pad. If you'd like to check out the transcript with links and references, please visit hopeinsource.com.

I'll end with Polanyi's last paragraph in Personal Knowledge:

> "So far as we know, the tiny fragments of the universe embodied in man are the only centres of thought and responsibility in the visible world. If that be so, the appearance of the human mind has been so far the ultimate stage in the awakening of the world; and all that has gone before, the strivings of a myriad centres that have taken the risks of living and believing, seem to have all been pursuing, along rival lines, the aim now achieved by us up to this point. They are all akin to us. For all these centres—those which led up to our own existence and the far more numerous others which produced different lines of which many are extinct—may be seen engaged in the same endeavour towards ultimate liberation. We may envisage then a cosmic field which called forth all these centres by offering them a short-lived, limited, hazardous opportunity for making some progress of their own towards an unthinkable consummation. And that is also, I believe, how a Christian is placed when worshipping God."
