---
title: "Digital Disembodiment (Maggie Appleton)"
season: 3
date: "2021-04-05"
time: "26"
description: "How does the digital life shape our perceptions of ourselves? Maggie Appleton starts us off on a discussion of school in pandemic times which lead to a discussion of the disembodiment that technology can create, somehow bringing us further towards our thoughts on time and space? (Recorded in November 2020)"
episodeLink: "c9c2824b"
embedUrl: https://share.transistor.fm/e/f125250b
sidebar:
    order: 16
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/disembodiment.md)

[00:00] **Henry**: You were telling me earlier about going back to..

[00:02] **Maggie**: School. Kind of. I wanted to do this MSC, a master's of science in digital anthropology, that I had my eye on for like the last six or seven years being like, okay, at one point I'll like take time off work and do that. And finally last December was like, okay, I'm going to finally do it in 2020 and like applied and got in January and was super excited. And then was like in denial about the COVID situation until like June being like, it'll be fine. We'll be back in person by then. 

[00:32] **Maggie**: But yeah, the course started at the end of September and I did the first five weeks and it was all online. Cause we've been in lockdown ever since then. So anyway, they banned all in person research and most of the degree was around ethnography. So going and being with people in places and studying culture through embodied, you know, in-person rich, highly detailed experiences. So yeah, I decided it was better to defer until next year. And I don't know if we'll be back in person by then, but you know, wasn't the year for it.

[01:08] **Henry**: I feel like the only way that will work is if you switched to digital ethnography or something.

[01:12] **Maggie**: Well, the funny thing is, is it's a degree in digital anthropology, but every, all the researchers who lead the program are very much obsessed with like studying the digital through in-person interactions, because there are so many people trying to study digital culture just by like scraping forums and like scraping Twitter.

[01:32] **Maggie**: And considering that like truth and data about what our culture is. And this program took the approach of like, it's impossible for us to understand how digital culture works unless we go and be with people. In their homes or in their workplaces while they're using digital devices, seeing the rich context around it, seeing all the things that we don't put online, the blended bits. Which is why I was drawn to the program. 

[02:00] **Henry**: Yeah, I'd be wondering if they would even purposely cancel everything, given the nature of what it is.

[02:07] **Maggie**: I think a lot of the people running the course probably would have agreed with that, but given the economics of higher education institutions, they sort of needed all the tuition money, so they just kind of kept the course running. That's my interpretation of it. a lot of them were saying it's, you know, it's not quite the academic experience we would have gotten otherwise. 

#### Deschooling Society

[02:28] **Henry**: To bring in all the Illich stuff that we talked about..

[02:30] **Maggie**: I skimmed Deschooling Society, even when I was debating to go in, right. Like, is it even a good idea to go into institutional education versus crafting your own path?

[02:40] **Henry**: I feel like the main benefit would have been in person because then like content wise, everything is there and it's probably even free, right. If you just watch YouTube, but having connections and all that.

[02:52] **Maggie**: Yeah, that was very much my feeling about it. But the technical literacy of academia is.. We hear about that it's not very high, but to see it, it was like, wow, we forget how immensely literate we are in the software world and being able to.. Not just like use, you know, the internet and machines efficiently and like explore new apps and systems when they come out. But just having the control to like design all systems and like make them do whatever we need to cause we'll literate enough in them. And seeing people so unable to like, do what they wanted to do was very curious and interesting.

[03:30] **Henry**: Yeah. That's interesting. So I haven't even read Deschooling myself, but I've read he also didn't pick the title for the book? I mean, this is apparently true for like almost any book. But it sounded like he would have rather use the term like dis-establishing school. Cause the first chapter of the book is something like why we must this established school. Kind of like when we talk about separation of church and state. His main issue before was what he called compulsory education people are forced to learn certain things instead of by voluntarily doing that.

[04:06] **Maggie**: Yeah. 

[04:07] **Henry**: And that's different from like saying we shouldn't have school I think.

[04:10] **Maggie**: Like from the bits of it, I had skimmed over, it seemed like he had problems with like the existing institution versus the idea of the institution. And it seemed like he was critiquing a lot of things about the existing American institution of schools. He was like looking at it in a particular context versus the idea of like organized education in general didn't seem to be like his issue.

[04:32] **Henry**: So later he said something like I was largely barking up the wrong tree or something like that.  The critique was important, it doesn't mean we need to get rid of everything. But I mean, I think he uses an extreme position to get us to even consider the fact that we should like kind of scale down, if that makes sense.

> [Unschooling](https://en.wikipedia.org/wiki/Unschooling) is another related concept

[04:52] **Henry**: A big part of his thinking is like de-escalation right. Less, not more. The default answer is more and he's telling us the counter productivity of like, when we increase, there's a point at which there's negative returns. Whatever it is. It could be spending money. It could be education, it could be technology.

[05:12] **Maggie**: I forget because I had read it now a couple months ago. Does he make the point that my interpretation of institutionalized schools, at least in countries like America is it's primarily just childcare. In order to have parents be able to go to work, you need to put the children somewhere sort of situation.

[05:30] **Henry**: Right, right. From what I'm reading, it's not just that. One thing that stood out to me was he was saying that we quantize our learning, meaning the quantize, meaning like quantify. He's saying that like, we know when you have failed. That's like the dropout. If you dropped out in first grade, then you're like even worse then if you're a drop out at second grade. It's almost like not going to school is better than dropping out, which is kind of weird. Because it shows that you decided not to, and it's like an obvious thing for you to continue.

[06:02] **Henry**: I guess when he means by compulsory. It's so important to not just like individuals or a society, but like how we think about learning as a concept, where the only way we know how to learn now is because we tell people, Oh, you have to go to school for that.

[06:20] **Henry**: He doesn't like how that has changed us. That you can't choose to just learn because you want to, or talk to someone. That it changes society such that you have to go through this thing. And that's what he calls the concept of a radical monopoly, where the monopoly is not the product, like a product that is taking over everything. That institutions are a monopoly over the concept of education or medicine or transportation or even religion. Which is like a broad statement, but yeah.

[06:52] **Maggie**: But yeah. It's a good one though. I mean, it makes me wonder how much, cause he died in the nineties, right?

[06:59] **Henry**: I think 2000 something,

[07:01] **Maggie**: Oh, okay. Not that long ago.

[07:03] **Henry**: Not that long ago. 2002.

[07:05] **Maggie**: Okay. I mean, it is a bit sad though. Cause I'm thinking, he would like the current moment, at least of what I'm seeing of. I mean, in some respects, it's not a great year for anyone to come back from the death scene.

[07:20] **Henry**: I don't know if what you mean by that.. His thinking is probably more important than ever now in terms of like everyone doesn't like institutions, everything is not going well. He's not going to say, I told you so, but it's important to kind of think differently.

> Maggie had a few suggestions in mind: [On Deck](https://www.beondeck.com/), [Hyperlink Academy](https://hyperlink.academy/), [School for Poetic Computation](https://sfpc.io/), [Recurse Center](https://www.recurse.com/), [The Black School](https://theblack.school/about-us/), [Enrol Yourself](https://www.enrolyourself.com/)

[07:33] **Maggie**: Maybe it is just my corner of the internet and Twitter, but there does seem to be more of a rise right now of independent educational people crafting their own educational plans. Very anti-institutional very go your own way, autodidactic. 

[07:48] **Maggie**: Which I think might be a double-edged sword in, in ways. I think there's a lot of narrative around, like we can just teach ourselves anything. And like the independent learner that maybe doesn't give as much credit to the fact that still all, some things where like the information is behind the walls of the Academy and like, that's not great. Like there's still paywalls on every major academic journal site, right. To be able to read good research, which is like a whole different problem. 

[08:16] **Maggie**: But I feel like he maybe would like appreciate a lot of the stuff we're seeing of, especially I think about it in terms of the whole like lifelong learner narrative of what happens after you graduate university. And a lot of us still want to be researching and learning and digging into things deeply. And how do we create structures for that, where we're able to do that regularly, socially, whether the people develop deep ideas and mostly blogging has become some sort of medium for self-education of the last decade.

[08:44] **Henry**: Yeah. Without the institution, it doesn't mean that you're on your own. It's not like a autonomous self, but that you are interdependent with other people in your local community. So he really fostered friendships. Relying on one another. Those two almost feel as separate, but like they're interrelated in his word, conviviality. Which is like such a interesting word because Polanyi uses it too; I'm trying to figure out like how they relate. 

[09:12] **Henry**: But this relates a lot to institutions. In this case, if you have an institution, like say school, you are relying on school in order to get learning and eventually depend on school, almost like an  addiction kind of thing, but not at an individual level, almost like a societal level. We have to have school. Not that you shouldn't do these things, but that's just kind of our default thinking. And then the other way around, by depending on institutions, we also don't depend on our fellow peers, our neighbor.

#### Disembodied By Technology

[09:42] **Henry**: And that relates a lot to tools, which he talks about and tools for conviviality. This idea of like services and products and consumerism. So whether it's the nonprofit or it's the government or company, we're not relying on people, relying on services. Or we are relying on apps and algorithms. 

[10:05] **Henry**: I was thinking about that quantified self thing again, cause we talked about it before and I was like, wow, this is really related because a friend was just mentioning they had like this app that tells them how much water they should drink. And this is not like bad on its own, right. You know, it's good to just know. Or even like what levels of vitamins or all that stuff. But if you think about it.. Is it a good thing in the long run if we rely on these apps to tell us how much food we should have, or when we should go to sleep. Cause you could see that could turned into a dependency to where there's a little virtual avatar that tells you it's like sad when you don't have water and then it's like happy when you do.

[10:46] **Henry**: But it's like another form of disembodiment, right? Ideally, we would know ourselves, like when we feel anything. When I feel emotions, when I feel like my body needs food or whatever, right. And then you could see a moment where like the app will tell me everything and then I won't need to rely on my own sense of feeling. There's a good way to do it. It augments my own ability, but I feel like the way we go about it.. Kind of doesn't do that.

[11:13] **Maggie**: Yeah. I probably have too many thoughts on the quantified self stuff, cause that was like my undergraduate degree. I studied them for my thesis. But I hadn't read Illich and conviviality and his ideas of not relying on institutional stuff.

[11:26] **Maggie**: Cause I'm now seeing that  there's a lot in the quantified self movement that's about personal agency. Like there's the personal medicine movement, which it sounds like he would have been really into where rather than relying on some generic doctor to try and help figure out what's wrong with you. You can have more agency in coding and designing apps and tracking your own system and like improving it. Like it helps people who have specific things like diabetes or asthma or IBS, like something where small changes can make a big difference to quality of life. So that he'd be really into.

[11:57] **Maggie**: But it's definitely true that the quantified self movement, it kind can go good or bad with the way people approach it. And so it's very much like the narrative people come to it with, because there's like a sort of a strain to it that is the people who want the phone to tell them how to feel, right? To have the phone be like, you need to now eat 400 calories and drink a liter of water. And you need to like go to sleep at 7:22 PM. And this idea that like the magical technological system will help them optimize themselves. 

[12:31] **Maggie**: And a lot of the stuff I ended up reading about it, there was a strong thread of like being the optimal capitalist. How do I become the most productive, right? Make the most money. Optimize every minute of my day. And then there's another group in the community that are really interesting, cause they're the like more squishy self-reflective ones who were there  collecting data, just to look at it and just be like, okay, I'm tracking moods or I'm tracking how my sleep correlates with the number of hours I work. And just using it as a way to do a lot of them. We use the word personal science and just kind of look at numbers and be like, Oh, that's interesting. What does that make me think about how I'm I'm acting? So I think it's like, you can use the raw tools to do it in two very different ways.

[13:17] **Henry**: Yeah. If you want to bring up like affordances or incentives. Maybe we start off feeling really having a lot of agency and ownership over our body. But any tool that replaces.. Essentially a slave will make us slaves to the tool. He said something to that effect. In tools for conviviality, he says we don't want energy slaves. We don't want things that just save us time for the sake of it, because we will end up relying on it and it will cause problems for everyone.

[13:45] **Henry**: I think he has some certain extremes to that. We shouldn't have transportation that's faster than a bike. Like we already, we have the cars and planes, and I think we're trying to figure out how to cut back on that. But yeah, I think that the critique itself is interesting of thinking about where the tools can go wrong. When he talks about convivial tools, he means tools that are purposely limited in what they're allowed to do.

[14:10] **Henry**: And he might argue more that there is no good actor that we should give the tools to. We shouldn't have those tools in the first place versus we're arguing about who should be the people that have access to these powerful tools.

[14:24] **Maggie**: Interesting. Does he make any distinction about the designers of tool? Because one fundamental distinction I would think to make is.. The difference between you building yourself a tool. I mean, which gets back into like the agency of being technologically literate enough, to be able to do that versus using tools other people have built where you are inherently putting yourself at risk, especially if it is something that has control and affords and influence over you, right. At the moment it's incredibly likely your data's just being sold out the back door or it's gonna be hacked at some point.

[14:56] **Henry**: It's almost like the idea of a designer is a bad thing, if I want to take his thinking to the extreme, in some sense. Because the convivial tool is a tool where the design can't be imposed on people and it is completely up to the person using it, to use it in the way that they should.

[15:14] **Henry**: Something that would be simple would be like a hammer, where like it is designed in a certain way, but it's not the same as like an app where you can only click on certain things. No one can prevent you from doing anything you want with the hammer, right. You could use it in whatever way you want, even if it wasn't intended, and that's fine. But if you think about a digital app, you can only click on things that they tell you to or you're allowed to do. Maybe the API is not open.

[15:42] **Maggie**: Yeah. Or even like getting your data out of any app. You usually can't right. That's usually the point is like, if you can get your data out in some reasonable format, you could go to some other app. And all your data is stored on their database. Either way you don't necessarily own it. Like probably in the terms and service you haven't read, you don't own it.

[16:03] **Henry**: I guess it's not really a devil's advocate, but it's just like thinking the opposite.. Most people, they don't want to be able to customize, they just want it to work or be efficient. And I think maybe the response to that would actually be that that's not a good thing that we've gone to the point where we do want to outsource all our decisions to the apps. That is like a loss of almost like confidence in yourself in some sense, right? Like I can't even make a decision on all these basic things in life. Eating or talking or whatever, because supposedly this algorithm or app knows better about me than I do.

[16:41] **Henry**: And I don't want to say even if it was true, it's not true. We don't believe that within our mind, but we slowly believe it through our actions, right. Given the fact that we are continually coming back to these things habitually, right.

[16:55] **Maggie**: Yeah. I don't know why that's not more of a narrative in mainstream discussions about this stuff, because I'm thinking so much about how, right, any app where we outsource agency and permission to it to sort of manage whatever it is. Like, let's say our sleep, right.

[17:11] **Maggie**: It's going to use whatever is our best scientific evidence right now for like the most generic data for how many hours a human should sleep, right. It's going to be like, here's the mass average, we've decided it's eight hours. This app is going to help you get exactly eight hours sleep, which says nothing for like the exact particularities of different human bodies. 

[17:31] **Maggie**: I love like there's lots of historical records. We used to sleep in two different times. You'd do like a four hour sleep and then you'd get up and read for two hours and hang out and like chill and then you'd sleep for another four hours. Because it was dark for longer. Cause they didn't have artificial light. This is like pre-electricity. It's pretty well recorded that was a fairly typical sleep pattern for most humans. And now no one really does that I know of. And they don't think any scientific papers have studied, whether that's optimal or not. But yeah any app is just going to use the generic human body, some like amalgamated massive data points that it's not your particular system and your particular needs.

[18:07] **Henry**: Right. And why does that represent the person, I guess? And also they are only looking at certain things. Like legibility and how they're optimizing for a certain value, but that discounts every other. Maybe there's other effects that aren't accounted for that we don't know about.

[18:24] **Henry**: I guess it's like, if you say stuff like this, they're like, well, how do we know anything? Why are you even try anything anymore? But if you think about all of the things we've done to be more efficient, like one simple example would be like, when you take the subway, which I guess people aren't doing as much now, but like, you know where to stand, like which door to go to so that when you get to your stop, it's closer to the exit. You don't have to walk as far. And you know, that's like a simple thing you do. But does it really save you that much time. And then also this assumes that all the time you spend was going to be used productively in the first place. And I'm not going to argue that is inefficient, but I'm just saying like all the time we save it gets filled up again. It's sort of like when your house is like empty, you just fill it up. Or like when you have light, you're just going to stay up late.

[19:10] **Maggie**: Yeah. I know that is interesting. That it's hard to get out of it. I mean, I connect so much to that idea of like critiquing it, but also critiquing it from the place of like, only because you see it in yourself. So you're like trying to think it through, because I do that so much, like with the quantified self stuff, right? Like I love tracking apps and I love time-tracking, apps as experiments, as seeing data, as just figuring out different patterns of what I'm doing. But at the same time, feel weirdness and discomfort around trying to use machines to like understand myself and my patterns. And it's like, why aren't we able to just do that from more tacit, I don't want to use the word natural, cause that's not a thing, way of going about it.

[19:49] **Henry**: Cause those tools end up becoming parts of ourselves in the sense of extensions. How are they more liberating or that you could use them such that you don't need them anymore. That would be a great goal, right? If you could just know, you wouldn't need this tool, but if the tools goal is such that, like I can understand how much water I have without having to measure it, that would be great.

#### Perceiving Time

> There was a recent Vsauce on time, [Illusions of Time](https://www.youtube.com/watch?v=zHL9GP_B30E) 

[20:11] **Henry**: Another one I was thinking about was the passage of time and like knowing how long something takes. I don't think most people have any sense of that anymore. We have a watch, or you look at the time, and then you're like, Oh wow, X time has passed. 

[20:25] **Henry**: I gave a talk at like a student hackathon and I don't know why we ended up doing this, but we just really, Hey, what if we like tried the time how long one minute is? And so we all like close our eyes and then you like open them when you think it's a minute. And then also doing that without counting, right, but just trying to just sit there.

[20:40] **Maggie**: Yeah. I mean, I do love that idea of playing with that to get different feels for it. Like, my friend Brian, actually he's in the Interintellect too, he had just done an experiment where when we went into lockdown two weeks ago here. He was like, well, I want to like get through lockdown or something a bit more interesting to do an experiment. So he went [five days](https://clerestory.netlify.app/fast/) without looking at any screens, without eating any food, without talking to anyone out loud, like a meditation, sort of retreat, just reading and writing for five days. I think he walked around London too with a paper map. So at the little bit of like outdoor time, but he said that time just like slowed down immensely. Time was a completely different beast. It was like the longest five days. And you could imagine, right, that it would be a very extreme experiment because not just getting rid of screens. I would think like the hunger would have done me in, but even just the idea of not speaking to people and not using digital systems would severely alter your sense of how long a day takes or how long an hour takes.

#### Space And Silence

[21:43] **Henry**: Yeah. These are all what we would consider like spiritual disciplines in some sense, that a lot of Western religious people don't really do much. Illich actually wrote this essay called silence is a commons. But like how even now, there's no way to know that someone is being silent on social media, because if you told someone that you were leaving social media, it's kind of defeats the purpose in a way. It only gets louder, right? The only way to be silent, is just not to play right. Not to be on it. And that's weird cause like the only action that encourages is more of itself. And I think that maybe that relates to like, if you want to call it social media, its own institution, it's kind of the same problem.

[22:27] **Maggie**: Yeah. Like it doesn't have any affordance for co-presence without explicitly people saying something, right? Like you can't just like be in a space like Twitter in the same way we would if we were in a room, right, with a bunch of people. Being present and visible, but not saying things or exerting opinions or trying to like make more noise.

[22:48] **Maggie**: I'm trying to even think back to like IRC chat rooms, you would at least have your name pop up in the user list, but wouldn't be saying anything. And like discord kind of has this. Like, you can be online and not be speaking, but it's not visible. You would really have to go looking for who was online at that moment, but we have no affordances that suggest presence without noise.

[23:09] **Maggie**: I mean, I'm seeing a few spaces or internet platforms. There was one that came up called gather. I think it's [gather.town](https://gather.town/) and you're like a little RPG character and you can do zoom calls with people where if you move further and closer away from the video comes in and out. So it mimics spatial presence. So you can at least be present in a room there as a tiny figure without speaking, or writing comments. But it's still like be in the room with people, which I think is a really nice concept that you could like sit in a room with a bunch of people going to be reading or something at the same time and feel co-presence without speaking.

[23:45] **Henry**: I'm excited for whatever the future of that is. Yeah, spatial audio.

[23:49] **Maggie**: Yeah. It still seems quite young though, which seems incredible in 2020, how long it's taking us to figure this stuff out.

[23:57] **Henry**: I guess we were forced to, in some sense. A lot of things are kind of reactions to whatever.

[24:02] **Maggie**: Do you remember second life, right? Well, it was more that you were 3d avatar in it, but it had spatial dimension and co-presence and being able to be with people in a space and interact in a way that had physical movement in a way that zoom doesn't and it died off in like the mid two thousands. And I feel like nothing replaced it and nothing built off it. I don't know what was wrong with second life in particular, but it didn't go anywhere. We just sort of fell backwards into Google Hangouts and Skype back then. It's very strange.

[24:33] **Henry**: It does feel like video games are that equivalent at this point, for a lot of people. Fortnite, animal crossing, Minecraft, a lot of games that have a lot of downtime. It doesn't mean nothing's going on. It's just that you don't have to be like super focused on like what's happening in real time. And so in that time, if you're playing with their friends, it becomes a time where like, you know, if there's silence, but then someone's just like, Oh, how's your day going? It becomes its own like community. That's why a lot of people say that the future of the community is some kind of video game, however you want to define that. I don't consider that to be like, we take existing applications. It's more of like, how do we bring that sense of being in a space.

[25:14] **Maggie**: Cause it is such a shame that there's so much cultural baggage around games and like the, even the politics around like online gaming worlds is like too much to like go into. But the affordances of the platform are really the valuable thing, right? Like being in world of Warcraft, it requires people being willing to get over the weirdness of being into like elves and dwarves and fairies. I don't know, I've never played it. But clearly like there's, there's actually been some good ethnography, so people writing about World of Warcraft communities that are  genuinely like tight knit cultures. People come best friends and get married to partners out their World of Warcraft clans, like genuine human connections culture, like through and through unquestionable. And it's like, why can't we just have that in different forms that don't involve orcs or all this other weird cultural narrative layered on it.

[26:03] **Henry**: Right. I play games, and it's like I don't normally consider myself the person, even though I guess, that's supposed to be the point, like you're immersing yourself in this world, but I mean, people like superheroes. So it's like not that different. Maybe it's easier for people because it's not really me. Maybe it being too real is even more weird, but it's like, you almost want it to be different on purpose so that you remember it's just like a representation of yourself or something. 

[26:29]People want to be able to like express themselves, right. That's one of the problems with stuff like zoom, where the only way you can express yourself is like your background, right. Or your clothes, I guess. And there, I could do whatever the platform allows me to do which might be more fun for people. 

[26:45] **Maggie**: And also provides activities and goals. Just like things to go do together in the way the real world does, right. Whereas like zoom, you're just presented with the screens of each other. And there's no like subtle background distraction or subtle things. Like as if you're going to get coffee with someone, there's this whole process of getting the coffee and chatting about the quality of the coffee and commenting on the person at the table next to you and petting the dog next to you.

[27:09] **Maggie**: And there's all this like tangential action happening for you to make conversation around. And I assume the games are the same, right. It sort of like you're going on a quest together, but then like if you're running, getting ready for the quest, there's like chitchat that's happening. And there's just like ambient activity to do. Whereas in zoom, you're just dropped into like, okay, make conversation. If you don't have anything to talk about, it's just like,

[27:33] **Henry**: You're looking at your face, which is weird, cause you never look at yourself normally. I tried this before, too, where like you just, instead of the video chat, you just do audio only, right. In some weird way, having the distraction somehow makes you more focused.

[27:46] **Maggie**: Some level of it. That's where like platforms like gather aren't quite there yet, but having that sort of ambient activity. You could like step off to the side and have a side conversation and then come back to some group activity. Like if we could figure that out, that would just make it so much better.
