---
title: "The Convivial Society (Michael Sacasas)"
season: 3
date: "2020-10-13"
time: "24"
description: "What does a convivial society entail? Michael Sacasas joins Henry in the second part of a conversation about Illich and his views of the common good. We speak about Illich's critique against institutions, autonomy and interdependence, the story of the Good Samaritan, learning through apprenticeship and intimate participation, and outsourcing our choices"
episodeLink: "65de5f7d"
embedUrl: https://share.transistor.fm/e/34d485c0
sidebar:
    order: 8
---

### Links

- Video version on [Youtube](https://www.youtube.com/watch?v=fojoWc1oCeQ)
- Part 1: [Natural Limits](https://hopeinsource.com/limits/)
- Michael's [Twitter](https://twitter.com/lmsacasas)
- Michael's Newsletter: [The Convivial Society](https://theconvivialsociety.substack.com/about?utm_source=menu-dropdown)
- Newsletter: [A Theory of Zoom Fatigue](https://theconvivialsociety.substack.com/p/a-theory-of-zoom-fatigue)
- Newsletter: [Care, Friendship, Hospitality](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/convivial.md)

#### Conviviality as Autonomy

[00:00] **Henry**: I was thinking we could just talk about Illich, which is funny. I didn't even know how to say his name. I thought it was like Illich or something. I heard you say that in your conversation with Carl Micham, right?

[00:10] **Michael**: Yeah and that's funny because I usually would say Ivan and then heard Carl then subsequently talked to a few other folks and Yvonne is the preferred rendering of that. So yeah, understood.

[00:23] **Henry**: I figured we should talk about just the word conviviality. Because we've been talking about living within bounds and what that means to Illich.

[00:31] **Michael**: Right. And I think one of the things that I've appreciated reading through, Tools for Conviviality, and I skimmed it just again this morning, you know, getting ready to talk to you about Illich, are these two sides of one coin for him.

[00:44] **Michael**: And this sort of gets at the level of the ultimate values that I think are sort of driving.. Although I don't think he would have liked the language of values necessarily right, but these ultimate goods that are driving his writing, his theorizing.

> "He moved away from the language of “values”, which he had used in earlier writings, and began to speak simply of the good. The good, as he came to understand it, is what is uniquely and incomparably appropriate in a given setting. It observes a certain scale, displays a certain proportion. It fits, and the sense can recognize this fit, just as they can recognize what is out of tune. Values, on the other hand, are a universal coin without a proper place or an inherent limit. They rank and compare all things according to their utility or their relative scarcity." - David Cayley, The Rivers North of the Future, page 25

[00:55] **Michael**: And how much of it ends up being about on the one hand a kind of freedom for the individual, a kind of autonomy. And I think if we just left it at that, right. So there's snippets of Illich's writing, I think, which someone with libertarian tendencies might sort of pick up and say, ah yeah, this makes sense to me, this is what I'm talking about. And I don't want to caricature libertarian mindset necessarily here, but that there's passages that highlight our ability to just care for ourselves, right. To assume responsibility for ourselves.

[01:26] **Michael**: This is part of Illich's critique of the medical profession, is that we lost sight of how to just be responsible for our own health right. Or even to be able to declare ourselves sick. But now are you really sick, right? Do you have the doctor's note? Do you have the diagnosis? So we lose control over aspects of our own living and that control is handed over to different professions or institutions.

[01:53] **Henry**: It's outsourced.

[01:54] **Michael**: Yeah, right. We're deskilled, as it were. I don't think that is a word that Illich uses, but we are deskilled. Not in a particular kind of technical skill, making widgets for the factory or whatever, but in some aspect of being human, right. Of living as a human being in the fullness of our sort of moral integrity. And so that's one aspect.

#### Conviviality as Interdependence

[02:15] **Michael**: But the other side of that coin that I think Illich always joins together, is living also in mutual interdependence, right?

[02:24] **Michael**: So it's not just that I learned to take care of myself, in this radically individual manner. It's that I do so in the context of social interdependence, right? So that there are friends and family and neighbors that I rely on.

[02:41] **Michael**: I think it's in either Tools or Deschooling that he talks about how one of the threats of modern tools and modern institutions is that they teach us to depend upon the products that they offer or the services they render, instead of our neighbor. Instead of another person, right, another human being. So we lose the capacity, to not just take responsibility for ourselves, but to care for one another, in this context.

> People with rediscover the value of joyful sobriety and liberating austerity only if they relearn to depend on each other rather than on energy slaves. - Tools for Conviviality

[03:10] **Michael**: And so I think at one level, you know, the convivial society is a society that enables individuals to have a degree of freedom and autonomy. To be self directed, we might say, especially in their work. But then also to learn to depend upon one another, to learn, to turn towards each other, rather than towards an institution or a professional for support in the work of living, right. In the caring of our lives together.

[03:44] **Henry**: So that's why he has a critique against like experts. Also, I guess, related to industrialization, commodifying everything into products. And then everything's about products.

[03:57] **Michael**: And yeah. And services. I think Illich, in the seventies, when the talk of postindustrial society is ramping up. And we're moving to what we think of as a service economy.

#### Schooling and Credentialism

[04:07] **Michael**: And the critique of schooling. You know what I love about Illich, you know, there are lots of critics of modernity, but very few of them sort of take on schooling and medicine, which, you know, I think the majority of people would sort of agree these are the great boons of Western society. And Illich says, no, not exactly, at least not past a certain threshold, right.

[04:27] **Michael**: And I should say too, most of my professional life has been teaching in schools, right. So I am not by any means, you know, anti teachers.

[04:35] **Michael**: But I think that Illich's point about what he would think of as schooling, not just learning. Because of course he understands, we have to learn. The question is, whether the institution of schooling empowers us in the way that it claims to. And then he also begins to note the diminishing returns in universal education, not just in public schools, but in the ideal of universal education and the diminishing returns that begin to be perceived in the 1970s.

[05:03] **Michael**: And he talks about the various remedies, which sound very familiar, right? On one hand sort of independent or free schools, or the deployment of technology. And so these, the public schools, independent schools, and then the arrival of technology to facilitate learning.

[05:21] **Michael**: For him, all three of them still take for granted the basic institutional structure of education that is professionalized. Where you are put through a sort of an age based curriculum. And part of Illich's critique is that you are made dependent upon a need that is created by the institution for its own sake.

[05:46] **Michael**: So before the institution of K through 12 schooling, there was no such thing as a high school dropout, right? Your social station was not going to be determined by whether you completed 12 consecutive years of professionalized schooling, right. Illich says in Tools, you know, that one thing that schooling does for you is it tells you exactly where you fail to complete the program.

> "Our present tools are engineered to deliver professional energies. Such energies come in quanta. Less than a quantum cannot be delivered. Less than four years of schooling is worse than none. It only defines the former pupil as a dropout." - Tools for Conviviality

[06:08] **Michael**: You know exactly at which point you fail to go on to the next step. I know I'm ABD, right? That's my status, right. That's where I fell out. I dropped out, right. And so someone who may be perfectly capable for a job, back when a high school degree was sort of the basic requirement, right now, it's not even an undergraduate, right? Now in some places, the default is that you have an MBA. It just extends forever, right?

[06:31] **Michael**: You just keep adding because the value of having a high school diploma is less relevant when everybody has one. And the value of having an undergrad is less relevant et cetera, et cetera. So it perpetuates itself indefinitely. Again you create a need for something that only the institution can provide for you and you become dependent on that institution, right.

[06:51] **Michael**: So there are various ways to become capable, right? There are various ways to learn. Illich also says that most learning doesn't happen through teaching. I don't know if there's any way to quantify this. Right. But I think he's onto something, right. If we think about how we learned to do most things in life.

[07:08] **Michael**: We may not necessarily have been taught those things and we also tend to recognize that most of the things we were taught as far as content anyway, we tend to forget, you know, a day after the test, right. You know? And so he's onto something, he recognizes that there are various ways in which we can facilitate learning that don't require the institution of the modern Western school. Which for his part generally just created dependencies that were unnecessary and counterproductive.

[07:39] **Henry**: Was it credentialism?

[07:41] **Michael**: Right. Yeah, exactly.

[07:43] **Henry**: And I guess that is its own escalation.

[07:45] **Michael**: Right. So yes, I forgot where we started down this trail, but that is also one of the targets that Illich has an in view here. Is that we learn to depend on institutions instead of our neighbor, right? Just as a collective word for those around us, our friends, our family, our community.

> The hypothesis was that machines can replace slaves. The evidence shows that, used for this purpose, machines enslave men. Neither a dictatorial proletariat nor a leisure mass can escape the dominion of constantly expanding industrial tools. The crisis can be solved only if we give people tools that guarantee their right to work with high, independent efficiency, thus simultaneously eliminating the need for either slaves or masters and enhancing each person’s range of freedom. People need new tools to work with rather than tools that “work” for them. - Tools For Conviviality

[08:04] **Henry**: So how do you merge like the individual thing and the community aspect?

[08:08] **Michael**: Right. And I think Illich holds those two together, right. And we do a bad job of that.

[08:13] **Michael**: You know, we tend to either swerve towards a kind of radical individualism where we just sort of take care of ourselves and we were self-made or pull ourselves up by our bootstraps and we have that kind of strand. And then maybe we have a kind of collectivist strand where the individual that exists for the sake of the collective, right. And I think Illich manages to recognize that they exist in their best form only to the degree that they exist together, right.

#### The Good Samaritan

> The Good Samaritan is a famous parable told by Jesus in the Gospel of Luke in the New Testament. Check out [Luke 10:25-37](https://www.biblegateway.com/passage/?search=Lk+10%3A25%E2%80%9337&version=NIV)!

[08:39] **Michael**: So that's I think a really valuable strand in Illich's work and a lot of that, I think towards the end of his career, increasingly gets tied up with the idea of friendship and hospitality.

[08:52] **Michael**: And one of the things I've been reading lately is about the crucial role that a certain interpretation of the [Parable of The Good Samaritan](https://en.wikipedia.org/wiki/Parable_of_the_Good_Samaritan) played in his thinking. Maybe we should mention it for those that don't know, Illich was a Roman Catholic priest.

[09:05] **Michael**: And he fell.. he got into a bit of trouble with a hierarchy in the late sixties and he never ceased being a priest, but he did cease practicing the office of a priest in an official capacity. And it was sort of his obedience as it were to the Church at the end of the day. So there is a theological strand of religious thinking, although it's not immediately evident in a lot of his best known work.

[09:29] **Michael**: But the parable of the good Samaritan was extremely important to him and it kind of capture this notion of the importance of recognizing in the other, a neighbor to be cared for, right.

[09:41] **Michael**: And he makes the point that we tend to think about the parable as being about, you know, what we ought to do. When it really is an answer to the question who is my neighbor, right? And for him, it's just that moment of grace in which you recognize that even your enemy can be your neighbor, right?

> "But he wanted to justify himself, so he asked Jesus, “And who is my neighbor?”" - Luke 10:29. Jesus responds to the lawyer with the parable.

[09:57] **Michael**: The person who your society defines as somebody that is entirely other. And in fact, an enemy to you in that moment of humane encounter, right. We can recognize them as our neighbor and be hospitable to them and recognize their humanity, et cetera, et cetera. And that can only happen on a certain scale, you know, I would add, right. The scale of the face to face encounter, as it were.

[10:26] **Henry**: Right. If everything is distanced, you wouldn't even notice that person at all. And in this time..

[10:33] **Michael**: If it's just an avatar that I'm engaging with.. I don't see it as an excuse, right. This is a human being that you're harassing or threatening or being vile towards. But I think that the distance in some respects may make it easier. It invites that behavior right, in a unique way.

[10:52] **Henry**: It's a loss of intimacy.

[10:54] **Michael**: That's right. And it's back to this question of respecting our embodiment essentially, right? I mean, this is great. I'm glad that we're talking at a distance. We wouldn't have this ability to do this, right, apart from the tools that we're using. And like I mentioned, I think that even though I've kind of [written about](https://theconvivialsociety.substack.com/p/a-theory-of-zoom-fatigue) how, you know, Zoom is inadequate and put some of the problems with it, you know, the fact that I can see you as I'm talking here, that's valuable.

> "The problem with video-conferencing is that the body is but isn’t there." - [Michael](https://theconvivialsociety.substack.com/p/a-theory-of-zoom-fatigue)

[11:16] **Michael**: Now if there were 50 little screens, obviously, to keep track of, we lose that, but at the scale this works. And that's fine, but at the same time. You know, I'd love to be sitting across the table from you, right. That would be a closer approximation of an ideal, right?

[11:32] **Michael**: And that I think was very important to Illich. Spent a lot of his life convening groups of friends that would spend time just talking, discussing, conversing, eating, drinking together. And that was a foundational practice.

#### The Master-Practitioner Relationship

[11:48] **Henry**: I was thinking about how Polanyi's thought kind of correlates. At the outset, the importance of tradition, meaning of the importance of authority, kind of seems like it's opposed to this idea of less institutions, no experts.

[12:01] **Henry**: But he was critiquing a specific part of it. Polanyi emphasizes the importance of mentorship, the martial arts aspect. And I don't think that's the same thing as teaching, where you say a bunch of stuff and they get it. You have to live with them. That is a lot more communal. So that's where I feel like they could be complimentary.

[12:18] **Michael**: They definitely are. In fact, towards the tail end of Deschooling, Illich writes explicitly about that master teacher relationship, right? He recognizes that that is essential. But that those things should be entered into.. You don't require an institution to enter into that. And that you pursue that relationship and it does certainly involve, as you say, a kind of submission to authority, right?

[12:43] **Michael**: The master practitioner invites you into a relationship where you can't just sit down and say, well, no, that's not the way it's done, right. There's a sense in which you're submitting to them. And that relationship was very special, that kind of master pupil relationship, I think the language that he uses.

[12:58] **Michael**: So I think on that score, you would find a great affinity. So I think Illich would recognize as Polanyi does that some of the most important kinds of learning, especially with regards to certain skills, can only happen in the context of that relationship. And then that relationship itself becomes a kind of friendship in mutual pursuit towards some greater good.

[13:19] **Michael**: I was listening to [Makoto Fujimura](https://www.makotofujimura.com), I think I pronounced his last name correctly, the visual artist, talking about this very specific kind of art that he has learned through long hours of apprenticeship to a Japanese master. And how they now have this, you know, very close relationship, right. There's a bond that has been formed there. And so you're back at this ideal of friendship undergirding so much of our human relationships.

[13:44] **Henry**: A lot of times, creating something with a friend builds a very specific kind of relationship versus just like just chatting or something, right?

[13:52] **Michael**: Right. There's a depth of experience. And it's hard to articulate some of this stuff, right. But it's a sort of thing where if you've been through that, you understand it, right. It is tacit right, it's a kind of tacit knowledge. It's experiential, difficult to articulate, but you know that it's there and it's substantial and it has added up a depth to your relationship that you wouldn't have had otherwise.

[14:15] **Henry**: I think Polanyi would describe that as, it's real. Which is an interesting way of putting it. That indescribable feeling. What I would say is like, there's like potential, right? It's so funny. He uses this fancy phrase, indeterminate future possibilities or something, which to me, all that means is like, When you learn something new and expands how you think about the world, in a positive way. I don't know, it's a hopeful view of knowledge and learning right.

#### Learning to Name the World

[14:42] **Michael**: Yeah, it opens up more of the world to you, right. You can tell me if this tracks with this line of thought, but I think of listening to the late [Richard Wilbur](https://en.wikipedia.org/wiki/Richard_Wilbur), American poet who was talking about the value of language in terms of naming and recognizing reality, right.

[15:00] **Michael**: So, you know, I grew up in the city. I grew up in Miami, and there were trees, right? That's it. That was my category, right? For tall green things, they were trees. I couldn't distinguish between an Oak and a maple or any other number of trees that we might encounter. They were simply trees, right.

[15:21] **Michael**: And birds were a category, right? The Cardinals stood out, but beyond that, right, I couldn't identify the Robin and the Mockingbird and all of that. But once you learn to name those aspects, it's not just that you, you know, can show off and say, Oh look, you know, that's a Sparrow and that's this particular kind of tree.

[15:42] **Michael**: It's actually that you see them. In a new way, right. Or see them period, right. This is a remarkable thing, right. That I think appears to you, in a way that they wouldn't have simply because you have learned to name them and to recognize them. And so in that sense, you know, they become real to you. You have access to reality. Of course it was always there before you. But the kind of creatures that we are, to simply look at the world is not to see it. And so we need to learn to see, and part of that I think involves the learning to name the world.

[16:17] **Henry**: I think that's exactly his thinking. Knowing itself is a skill that you have to develop. And this relates to this idea of personal knowledge, right? If that's true, then the person is so important to the act of knowledge. And not trying to distance ourselves. And we've been talking a lot about distance, right.

[16:34] **Michael**: Yeah. You know, when I think of that idea of the personal dimension of knowledge, part of where my mind goes this Augustinian view that you have to be prepared for to receive certain kinds of knowledge.

#### Capacity for Attention

[16:47] **Michael**: Right. To come back to the idea of attention, right? Your capacity for attention, your willingness in humility to attend to the world, right? To see what is there, right. To acknowledge your ignorance in order to be prepared to receive the knowledge that that is there for you.

[17:04] **Michael**: These are all sort of traits of the human being. Even in the question of seeing, when I talk about the difference between just looking and seeing. Maybe even in which technological practices shape the way we think about these things. Our minds are not cameras, right, that just kind of click the world, right. And sort of everything that is there to be seen as is perceived by our minds, right. Our perception is intended, right. We direct it.

[17:28] **Michael**: We have to be trained to perceive certain facets of reality. We have to submit ourselves to the patient work of attending to certain realities in order to allow them to emerge fully before our intellect. And these all, I think, do reflect this question of the person, right? Have we become the sort of person that is able to receive? the particular kind of knowledge that we're, that that is in view here?

[17:53] **Henry**: I think that gets into this fancy term he uses to explain knowledge, subsidiary focal integration. I mean, there's a lot of fancy words, but subsidiary is the environment. It's the things in your periphery. And then focal is the thing that you're putting your attention on. So I thought that tacit knowledge would mean like implicit versus explicit. But it's the integration of both of those things together.

[18:17] **Henry**: So piano is like a really simple example of like, I'm playing the notes. My body has learned to play the piano, right. And I can focus on the piece, the actual music itself. The subsidiary is like the notes that we're playing. But if I started focusing on the notes, then I won't be able to concentrate on the music itself and then probably start playing badly.

[18:37] **Michael**: Right, right. It seems to me like a common feature of most kinds of what we might think of as an embodied knowledge, right. So if you're touch typing, this is the thing about being in the flow, right? You can enter a certain state where you're expertly typing, you're almost not thinking. To think about the keys would be to interrupt the process, right.

[18:58] **Michael**: Even as an athlete, right. If you become too conscious of your free-throw technique, it throws it off, right. There's this balance to be struck there that I think is a balance you're describing between kind of using those clues as it were to suspend the activity, right. But if you focus too much on them, then kind of derails the work itself.

[19:22] **Henry**: I guess his point is that we're always doing both. Anytime you shift your focus, you're always relying on other clues. And so it's always going back and forth. And you were the one that pointed me to C.S. Lewis' essay, right, [Meditation in a Toolshed](http://ktf.cuni.cz/~linhb7ak/Meditation-in-a-Toolshed.pdf).

[19:35] **Michael**: Right. There are two different ways of perceiving. As the outside observer or the participant within. And I think Lewis would say both are legitimate, both have their place. All of them kind of all these different concepts get at that same notion of balancing our attention. Attending that is both active and receptive simultaneously.

> "You get one experience of a thing when you look along it and another when you look at it. Which is the “true” or “valid” experience?" - [Meditation in a Toolshed](http://ktf.cuni.cz/~linhb7ak/Meditation-in-a-Toolshed.pdf)

[19:59] **Henry**: Yeah. In order to learn, you have to surrender to something. Like what you said when you're learning from a master, every time they tell you to do something you can't tell yourself, I have to question every single thing he says.

[20:10] **Henry**: But in order to evaluate something, to be critical, you do have to just go through it. And so you are doing both at the same time. Even if I test a product, I have to evaluate, Oh, was this even good?

[20:22] **Henry**: I guess you could say services, products, institutions, algorithms, they make us not willing to make that choice anymore. It's a personal choice of some kind of discernment into like, whether something is good because someone else is telling us that it is good objectively.

#### On Surrendering Our Experience

[20:40] **Michael**: Yes, that's really good. Actually, that was one of the things I was going to draw on in the newsletter was the novelist, [Walker Percy](https://en.wikipedia.org/wiki/Walker_Percy). Has an essay called the surrender of our experience; I think is the title of it. But that's sort of the theme. We surrender our experience to another class of people. Experts in large part, I think, come in to do this work for us.

> "The highest role he can conceive himself as playing is to be able to recognize the title of the object, to return it to the appropriate expert and have it certified as a genuine find." - [The Loss of the Creature, Walker Percy](http://www.thinkingtogether.org/120/percy.pdf)

[21:02] **Michael**: Or even pervasive media images. And so the illustration Percy uses in this little essay is how it's very hard to see the Grand Canyon today, right. And what he means by that is that if you go to the Grand Canyon, you don't just go to see the Grand Canyon. You go to see the Grand Canyon in light of all of the images you've already perceived about it.

[21:24] **Michael**: All of the things you've been told about what you will feel when you see the Grand Canyon, right? It's all been kind of scripted in a sense for you. And he ends up saying, you know, really the only way to see the Grand Canyon is to just stumble upon it. You know, if you happen to get off of the prescribed tourist path to the Grand Canyon and are surprised by it, he says, then you'll see it.

[21:45] **Michael**: But until then, you're not going to see it. You see it in air quotes, perceive it for what it is, because it's already been pre-packaged for you in this case, by all of the, you know, the image and the tourist paraphernalia and all of that.

[21:59] **Michael**: But he would say experts would do the same thing for us. We've surrendered our ability to independently experience the world to various classes of experts and to the media writ large, in a sense, that have overdetermined, right, what the reality is going to be or what it is.

[22:18] **Henry**: I guess you could argue that there was never a time you could really experience it for yourself because you're always influenced by other people. But I think the keyword is over where it's like so much. So you don't even feel like you have any sense of self thinking around that idea.

[22:35] **Michael**: Yeah, I guess the word I'm thinking of is like serendipity then, right? It's like stumbling upon something that you weren't intending to. You have a goal of certain things, but you weren't thinking of that specific thing.

[22:48] **Michael**: Right, right. And I think that that kind of describes Percy's description of how you kind of actually get to see the Canyon. Are you serendipitously sorta come upon it before you realize it?

[22:57] **Michael**: It reminds me of being in Florence and knowing that I'm working my way towards [El Duomo](https://en.wikipedia.org/wiki/Florence_Cathedral), the famous orange brick building that you see in all the pictures of Florence, right. It's the cathedral and has a tower next to it. But the streets are so narrow. And it's a huge building, but you don't see it, until you.. Well in my case, turn a corner, and there it is, you know, right before you. And it does, it catches you off guard. And at least it was a great experience for me, right. That kind of, I know I'm going here to see this, but at that moment I wasn't ready to see it. And so it struck me in a unique way.

[23:33] **Henry**: Okay. Awesome, everyone should check out the [newsletter](https://theconvivialsociety.substack.com/p/care-friendship-hospitality-reflections)! Whenever that comes out.

[23:37] **Michael**: Yeah. It was good talking to you, Henry.
