---
title: "Approaching Advent (Alex Kim)"
season: 3
date: "2020-12-09"
time: "35"
description: "What is Advent anyway? Alex Kim joins Henry to chat about the season of waiting, memory, our loss and discovery of tradition, teaching ritual as meaningful, a Christian conception of time, and opening ourselves up to hope."
episodeLink: "06856b2b"
embedUrl: https://share.transistor.fm/e/6b7a7fee
sidebar:
    order: 11
---

### Links

- Music: Gabriels Message (via [Open Hymnal](http://openhymnal.org/Lyrics/Gabriels_Message-Gabriel.html))

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-3/advent.md)

[00:00] **Henry**: Many of us in the tech world and love [Advent of Code](https://adventofcode.com), a calendar of yearly coding puzzles, started in order to save Christmas. But some of us may also wonder about what Advent itself is for. Well, Alex, my pastor friend, asked me if I wanted to have a Christmas episode, so I suggested we talk about this current season of Advent. 

[00:18] **Henry**: That it's a time of preparation and waiting, as is Lent. It's common to just go to church or just go through the motions of any ritual. Even as such liturgy is meaningful in its action alone, it can be just as important to understand why we do what we do.  

[00:33] **Henry**: So we found ourselves in a discussion about the struggles of maintaining, as well as adapting, our traditions and rituals, whether in the faith or in any community. Is it inevitable to lose our collective memory, even as we participate in these rites? Do we stop or continue something just because it's always been this way? Or if it's never been done before? These are all good questions to explore as we continue old traditions and start new ones in this difficult year. Here's our chat.

[01:08] **Alex**: Talking about the current season and advent.. It's funny because I think a lot of people don't really know what advent is.

[01:16] **Henry**: What's the word, even?

[01:17] **Alex**: Right, the word advent actually comes from Latin. Excuse my Latin, but it comes from the word *adventus*. Which means one's coming or arrival, right. So advent is a fascinating season because it's really about preparation and waiting.

[01:38] **Henry**: For in this case Christ.

[01:40] **Alex**: Right, for Christ. But it's funny because I think a lot of times, people have this misunderstanding that advent is about waiting for Jesus's first coming or really just waiting and preparing to celebrate Christmas day with baby Jesus, you know, in the manger.

[01:57] **Alex**: I'm forgetting what the movie was, but I think it was [Talladega Nights](https://en.wikipedia.org/wiki/Talladega_Nights:_The_Ballad_of_Ricky_Bobby).

> "Dear Lord Baby Jesus.." - Ricky Bobby ([video](https://www.youtube.com/watch?v=i1Nh_3JCFj8))

[02:01] **Henry**: Yeah. I know you're talking about.

[02:02] **Alex**: Pray to baby Jesus. But I think that's unfortunate because it really misses out on kind of the broader themes that the church is trying to instill during the season.

#### A Season of Double Vision

[02:13] **Alex**: So I read an article recently. I forgot where it was, but it was talking about how advent is a season of double vision, where you're seeing like two different time periods at once. You're looking at the past and you're also looking into the future. And one could even sort of argue that Christmas is kind of the ultimate expression of God's arrival and coming. 

[02:40] **Alex**: Which, in another sense, is almost like a foretaste of Christ coming in full glory to judge the living and the dead, as you know our creed says. Many of the youth at my church recite every Sunday morning, to the extent that I think a lot of them are starting to remember it. But the question is like, did they really understand the full import of those words?

[03:04] **Henry**: Wait, which creed?

[03:05] **Alex**: The [Apostle's Creed](https://en.wikipedia.org/wiki/Apostles%27_Creed), yeah, for clarification. So I think Advent is really a great time for that and hopefully we can sort of celebrate it in light of that.

[03:15] **Henry**: I just had a conversation thinking about how the Bible speaks to the past and the present and the future at the same time. My friend was talking about the idea of a wedding, right. So like Adam and Eve, that was sort of a wedding, right, in the beginning. And then Christ's first miracle was at a wedding, turning the water into wine. And then when he comes back, it's going to be a wedding feast with the Church and the groom. So that's another idea of parallels in all these different places.

#### Reenacting Our Memory

[03:43] **Alex**: Right. We had previous conversations of Augustine's understanding of time and memory and just how, you know, unbelievably difficult it is to even capture with our own words, right? What exactly is time? What exactly is memory? But I think overall, the church is fascinated with time or at least when it comes to the church calendar, right.

[04:10] **Henry**: Hmm, and that relates to Advent right.

[04:12] **Alex**: Right, because in our doctrine, we believe God is eternal, but not in the sense that he lives in the same kind of space time that we do. It's almost like an infinite amount of time as we would perceive it as just an analogy for how God exists. And there is some debate on it, but you can almost argue that God is timeless. That would be a better presentation. 

[04:40] **Henry**: Outside of time, not in time. 

[04:43] **Alex**: Not in time, but outside of time. But the question then would be like, what does that even mean, right? But yeah we have like a fascination with time, especially since we see time itself as a created thing, right. So if creation is all of an analogy to who God is, it's almost like a point of contact where we can describe God. But at the same time, we can't fully capture God. That's why a lot of people say that God is both unknowable and made known. That sort of the paradox. And it's almost like our concentration on time, especially throughout the church year helps us to reorient ourselves to God, in this kind of timeless fashion.

[05:32] **Alex**: Which is exactly why the church calendar is cyclical. I think there's an idea of participation that we're not just remembering Jesus's baptism or Jesus's presentation at the temple or Jesus's birth or Pentecost or any of these things merely as ideas, but by participating in the rituals and liturgies and the worship of the season, we are in fact almost.. Reliving.

[06:00] **Henry**: Reenacting.

[06:02] **Alex**: Yeah, Reenacting. There's kind of that visceral component. I think that's the one word that we have come to really like using 

[06:12] **Henry**: Yeah.  I think we might've said like liturgy and ritual is the embodiment of those ideas. It helps us to remember that it's not an idea. It's not a concept.

[06:24] **Alex**: Yeah. It's interesting because these rituals again, they're not things that we just do alongside our active remembrance. They themselves are the remembrance. It's a memorial that causes us to remember. 

[06:40] **Alex**: We already talked about this in prior conversations, but about the idea that you can remember something that you've never experienced. But it is such a part of who you are that you can even say that you remember it collectively as a people. And I think that's partially what memorials are for, to kind of perpetuate a collective memory and to pass it down through tradition, which is essentially what the church calendar is. It's helpful tradition.

[07:16] **Henry**: So why don't a lot American churches participate in the calendar or not even participate, but like don't even know about it? A lot of people don't know what liturgy even means. Why do I need a calendar for it? 

[07:27] **Alex**: Hmm. Yeah. And that's mostly because of the Protestant history in the US. So what you have to remember is a lot of these church calendar activities, especially as they grew out of the budding Christian movements in the West and also in the East. These feasts start to become more elaborate, more complex, especially with meaning. 

[07:57] **Alex**: Even if the priests or bishops who would conduct these activities try to teach the meaning behind it.. I think you may know a couple of friends, not just in Roman Catholic or Eastern Orthodox circles, but also a lot of Protestant circles as well, who just kind of go to church. Oftentimes the people who participated in them, they go through to liturgy and they're not really cognizant of what they're doing. So a lot of the meaning, I think was lost to the average person. Imagine also the religious language of the West being Latin and your average person would not have necessarily been educated with that language.

[08:39] **Alex**: So along come the Protestant reformers. And they look at all of this stuff. And you also have to remember that, I think a lot of these festivities were also rites of obligation. So it's something that you would kind of have to do. As a Christian, as a member of the church. And I think with the Protestant ideas, starting with Martin Luther and all of the others who came later, and their reaction to a works based approach to the faith, sort of made them really skeptical and suspicious of these festivities. Now what's interesting is that it wasn't a wholesale rejection of it. That sort of develops later as more and more people started to reject these ideas, especially within Puritan circles. 

[09:34] **Alex**: And interesting enough, the two major Holy days that were really difficult to get rid of entirely were Easter and Christmas. America, still stayed relatively Protestant. So when they did keep these holidays, they didn't have the sense of obligation to it. It became more of something nice to do in commemoration. 

[09:58] **Alex**: And interesting enough in later Protestant history, the celebration of Christmas would become almost like your act of martyrdom. And I say this almost tongue in cheek, because if you remember, talking about the theme of remembering again, there's the whole idea of war on Christmas. For whatever reason in the history of Protestantism where a lot of the earlier guys were suspicious of these Roman Catholic Holy days are now almost seeing Christmas as a litmus test for whether or not you stand within Protestant, Bible believing, church stuff, right. 

[10:39] **Alex**: So it's fascinating how over time, where you stand on these issues kind of change depending on how you see it. I don't think it necessarily that means that the Puritans were wrong to be suspicious. I do think that it's always good, no matter what you do, to form or check or understand why you're doing what you're doing. And as a pastor, like that's the biggest issue, is that a lot of people just do things without really understanding why they're doing it.

#### Being Cognizantly Ritualistic

[11:13] **Henry**: I guess that's just like a general thing, how do we go about teaching people? You kinda need to say what's there, but they can't take it at face value. You should go through the motions, but eventually that's not enough. You have to move on to know like why are you doing this thing? Eventually you'll remove it later, because you're like, I don't actually know why I'm doing this.

[11:32] **Alex**: Right. And I think that's actually part of the problem with a lot of our church Sunday schools: is simply that we never move past just teaching kids the answers, right. 

[11:44] **Henry**: Catechism, right.

[11:44] **Alex**: Quote, unquote answers. Through catechism, through books that you would buy off of like Crossway, any kind of VBS material. You know, that's why in the church we sort of make fun of that, what we call like a Sunday school answer, right. It's like, it's just so cookie cutter. There's no depth. There's no complexity. There's no like real thought behind it. Is it wrong? No, not necessarily, right. But we don't prepare our students to actually think through complicated world issues,

[12:16] **Henry**: Exactly. It's all theoretical then, because it doesn't apply to your life and to the current moment. True understanding lets you to think different questions and answer other questions because of what you really know.

[12:29] **Alex**: Yeah. And it's interesting that you say theoretical. Because in my mind, and this may be just how I'm looking at it, but theoretical almost assumes you understand, at least at a minimum, the abstract. But I think for most of the people who go through church Sunday school, they don't even understand theory, right. It's more like they're just being taught data points. Like just memorize these. And if someone asks you this question, just spit out this line of data or whatever. They still don't understand why all of this is kind of all encompassing. Like forget about practical application, you know, like we're not even there.

[13:11] **Henry**: It's not even shallow. Each thing should kind of build on itself. You should be able to kind of make the connections in your mind.

[13:17] **Alex**: Right. You know, I don't want to steer our conversation too much into the philosophy of church education, but if we were to steer it back, when it comes to liturgy, it's exactly the same thing. The problem is we have a more high church liturgy, so it's more ritualistic. But the way that I want to approach it is: every Sunday I will pick intentionally one or two things, or maybe three or four if I feel like the kids may not understand, but I'll explain why we're doing it. 

[13:49] **Alex**: Because I don't want us to just be ritualistic. I want us to be cognizantly ritualistic. Right, I want us to be able to engage our minds, and through our minds and with our hearts, forget the antiquated physiology there. But we want to kind of enter into this sort of experience with God that he promises us when we meet together. And the liturgy is, what was the exact phrase again? The ["medium is the message"](https://en.wikipedia.org/wiki/The_medium_is_the_message). So the same sort of applies  to the liturgy as well.

[14:26] **Henry**: Okay, so liturgy. What is difficult about getting someone to understand? Is it harder to get someone to understand why they do it or even to get them to do it?

[14:38] **Alex**: Yeah. As a youth pastor, it's not that hard to get the youth to do stuff, because one, the parents just sort of.. There's that parental pressure, right. So that sort of alleviates the need to do that. But even then, we are really focused on not trying to force anyone to do anything. Right, if you don't want to do it, we can't force you to do it.

[15:01] **Alex**: And we're not going to try to baby you, we're not going to try to strike fear into you, to kind of force you to do something.  But we are going to try what we can to encourage you because we think it's helpful. We think it's beneficial. And we want to act as.. Living signs or guideposts. 

#### Living as Portals

[15:28] **Alex**: Or rather the analogy that I like, we're living portals to kind of seeing and experiencing the divine, right. 

[15:36] **Henry**: Why do you use portal?

[15:38] **Alex**: Yeah, because I think if we use words such as signs and guide posts, it still falls into this trap, that I am sort of a outside thing where I'm just kind of pointing you somewhere else.

[15:53] **Alex**: But if we really believe that the spirit indwells and lives inside the church, then in a real sense, when we are being remade into the image of God, through the image of Christ, we become sort of these portals where, by entering and sharing and participating in each other's lives, we're able to actually participate in the life of God himself.

[16:16] **Alex**: I just think that portal, as we conceive of it, especially with the Advent, there you go that word, with the advent of the video game [Portal](https://en.wikipedia.org/wiki/Portal_(series)), is an analogy that the church hasn't really had resources to use because it's kind of like new tech. So, for me, I think portal almost presents a better analogy of what might be going on.

> "Now You're Thinking With Portals" - [Portal](https://knowyourmeme.com/memes/thinking-with-portals)

[16:38] **Henry**: Cause you can look inside of it. Not just..  

[16:41] **Alex**: Or better than look inside. You can go..

[16:43] **Henry**: Through it.

[16:44] **Alex**: Right. This idea of participating in relationships with the actual people, tangible people that are in your life. And then we sort of talked about this earlier too, how in this world, God becomes more and more transcendent. And transcendence is a bad thing, because the further away something is from us and our reality, the less likely we are to actually believe that is a possibility. So tangibility is key here. And going back, you know, everything circles back to Christmas and the coming of..

[17:16] **Henry**: John 1. Yeah. The word became flesh. 

[17:18] **Alex**: Right, the word became flesh. The tangibility of this to us in our minds.. This is a very abstract concept of the word.

> Check out: ["On Fairy-stories"](https://en.wikipedia.org/wiki/On_Fairy-Stories) by Tolkien and ["Myth Became Fact"](http://judithwolfe.wp.st-andrews.ac.uk/files/2017/08/Myth-Became-Fact.pdf) by C.S. Lewis

> "Now the story of Christ is simply a true myth: a myth working on us in the same way as the others, but with this tremendous difference that it really happened." - C.S. Lewis Letter to Greeves after speaking with Tolkien

[17:26] **Henry**: I like Tolkien's "Christ is the true myth". Where God used to be an abstract thing, but in Christ he has become.. He's dwelt among us.

[17:35] **Alex**: Right. This idea of indwelling, Immanuel. It's the spirit of Christmas. I mean, that's what Christmas is about. This kind of ultimate arrival.

[17:46] **Henry**: the hope that we have in Christ. That God is a person now.

[17:49] **Alex**: Right. Well, just to be more like technical, right. God has always existed in three persons, according to our confessions and creeds and all of that. It's just that the second person of the Trinity has now become flesh.

[18:03] **Henry**: [Incarnation](https://en.wikipedia.org/wiki/Incarnation_(Christianity)).

[18:04] **Alex**: Incarnation itself is from the Latin in and then the other word, like carnal, right? The idea of flesh,  this stuff that's on me. The divine God is taking on my human nature. 

#### History as Both Cyclical and Linear

[18:26] **Alex**: But again, I mean, circling back to Advent. This is only the beginning, right? The incarnation is the beginning of God breaking our cycles of sin, right. So at least Christian history and Christian conceptions of time is both cyclical and linear. It's a spiral. 

[18:47] **Henry**: Spiraling up.  

[18:48] **Alex**: And.. Well, it wasn't always spiraling up, right. It was.. With the arrival of sin. With the advent of sin into the world, we were spiraling down. That's why God had to send in Christ to break us from that cycle and to bring us back up into the the new cycle.

[19:07] **Alex**: And that's exactly what the Christian calendar is about. This repetition and flow that allows us to relive and to participate in a way that I would even argue is impossible, if we just kind of had a posture where we're like, forget rituals entirely.

[19:24] **Alex**: But this kind of posture actually makes the Christian life more difficult. Because it's basically saying like, don't use any of the resources that God has given you. Don't use any of the resources that the church has found to be helpful. It's the bootstrap mentality applied to the Christian spiritual life. 

[19:45] **Henry**: Even the notion of removing ritual doesn't seem possible. All we're going to do is end up making our own rituals.

[19:52] **Alex**: It's almost that sense that you have, right, people deep down.. I think God just designed us for certain kinds of habits and ritual that can help us. And to guide our souls to things that have much more meaning. And when we try to have a posture of stripping all that away, we find things to be really lacking. 

[20:17] **Alex**: So what ends up happening, like you say, it's not that ritual actually disappears. It's replaced by other things. And in my opinion, when we start individualizing our traditions and stripping it away from a larger collective memory, it starts becoming less meaningful overall.

[20:37] **Alex**: Yeah, it just degrades, like the reason why the collective church was doing it in the first place, right.  People are like, Oh, we don't do that for Christmas, but instead we're going to do this. It's almost like you've taken a collective body.. Rather than try to understand it as a whole and to realize the benefits and the helpfulness of it, you've just rejected it wholesale and replaced it with something that's not nearly as grand.

#### Meaning-"full" Ritual

[21:06] **Alex**: So while we're on the topic of meaningful liturgy. It's also really important to do certain kinds of liturgies the right way. So you can't just hodgepodge things together and be like, Oh, well that's meaningful. One example would be singing traditionally Christmas songs during Advent or a singing traditionally Advent songs on Christmas. I was talking to someone at my church recently and they didn't know that there was even sort of this difference in posture, right? Christmas is about joy, you know, being happy for the coming of Christ. 

[21:46] **Henry**: because it happened then.

[21:48] **Alex**: Right, with the incarnation.

[21:50] **Henry**: Versus Advent is like, we're still waiting for it.

[21:53] **Alex**: There's posturing of preparation and waiting, which are much more like solemn acts, right? You're not really necessarily like joyfully prepared. I mean, you can, but preparation, it really depends what you're preparing for. You know, the coming of Christ can either be a really scary thing for you, or it can be a really happy thing for you, depending on what side of the, you know, judgment you're on. But that's a whole different topic.

[22:21] **Alex**: But regardless, one of the biggest things that I guess one example that we could talk about is singing the song. Oh, camo come Emmanuel. Right. That song is sung for Christmas. A lot of times it's sung during Christmas Eve service, which is not necessarily bad. But that's an advent song, right. You're asking for arrival, of Christ himself.

[22:44] **Henry**: So for people that are like, what's the big deal, I guess you're just saying that if you even. Think a little bit about the content of what that's even about. They're kind of doing a disservice to the whole point of it, right?

[22:56] **Alex**: Yeah, it goes back to this idea of being cognizant surgical, right? It's like if you're just doing things for a sake of doing it,  you're gonna build habits by, you're not really going to know why. Right. And it's the same thing. Like if you're singing these songs and you can be like, Oh, that's so nitpicky, but, but that's the point is like, the reason why Christmas is so joyful is because you spent essentially four weeks in Advent contemplating your standing before God, the meaning of Jesus returning. You know, how have you conducted your life or are you prepared?

[23:35] **Alex**: Have you repented and also maybe just some of the ways your life hasn't been the way that you wanted it to be and you see your own failures and you really hope for the second coming, right? That's what makes Christmas so meaningful as a kind of a way to end the advent season. Right because now your hope has been materialized and incarnation.

[24:01] **Alex**: It hasn't been fulfilled completely because there is a second coming, but man, the incarnation is the beginning of the breaking of that cycle.

[24:10] **Henry**: Tolkien has this concept of eucatastrophe. Have you talked about this before? But a good catastrophe and he's saying exactly what you're saying, that the incarnation is the catastrophe of man's history. But then later the resurrection is the eucatastrophe of the incarnation. think it's similar concept.

[24:31] **Alex**: Right. I think, The church needs to do better.. We have this rich history, the question is can we tap into it and not go back to Baroque, so high church that it just seems too intangible for me, not that kind, but to tap into the rich tradition and to present it in a contemporaneous way. And that's the struggle. 

[24:57] **Henry**: I'm reminded of a book I read a while back, Strange Rites, talking about all of the rituals that we have online. The struggle is of this institutional wisdom and intuition realism, the participation of people and being able to have a say in things. And how does that relate to the past and the history and not forgetting that? 

[25:19] **Alex**: Yeah. I mean, to give one example of learning from tradition, from people who have lived long before us.. And also just thinking about the rise of technology, I would say that even though technology has changed, human nature hasn't really changed as much as we would like to think, right. 

#### Augustine Has Gone Before Us

> Would recommend James K.A. Smith's [On the Road with Saint Augustine](http://bakerpublishinggroup.com/books/on-the-road-with-saint-augustine/380893) here!

[25:43] **Alex**: This is just a funny example and then that'll be the end of my tangent here, but in Augustine's [Confessions](https://en.wikipedia.org/wiki/Confessions_(Augustine)), right, when he's talking about himself growing up as a boy.. I mean, listen to this section from [Book One, Chapter 10](https://www.ourladyswarriors.org/saints/augcon1.htm#chap10) and he goes:

[25:59] **Alex**: And yet I erred, Oh Lord my God in doing contrary to the wishes of my parents and of those masters. For this learning, which they, no matter what the motive may have been wished to acquire, I might have put to good account afterwards.

[26:14] **Alex**: This part, I think is really interesting. He says for, I disobeyed them, not because I had chosen a better way, but from a fondness of play, loving the honor of victory in the matches and to have my ears tickled with lying fables in order that they might itch the more furiously.

[26:32] **Alex**: And I just listened to that and I'm just like, man, part of that is me going up, right. I didn't want to do what my parents wanted me to do. Part of them probably wanted to live vicariously through me, but I look back and I'm like, man, I actually kind of wish I learned my violin better, right. It'll be a nice skill to have, regardless of what my intention or what my parents intentions might've been. 

[26:56] **Alex**: But what I think is hilarious is that he says that he liked the honor of the victory of matches, right. And I look at that and I go, yeah, me too. I'd rather play video games and make sure my enemies were destroyed and they bow and worship my APM on StarCraft. 

[27:13] **Alex**: But I think it's so true. Part of the thing is like, as long as we don't tap into the traditions that we have, we isolate ourselves and we start to get this sort of, not necessarily arrogance, but we sort of get this understanding that we are just experiencing everything new, detached from the corporate human experience.

[27:37] **Henry**: The memory of others. 

[27:39] **Alex**: Right. How many times have we asked ourselves in our deepest and darkest, most emotional states, right? Think high school here. Oh man, no one can understand me. No one has gone through what I've gone through, right. There might be some extraordinary cases. But in general, I think most humans go through very analogous or similar experiences where tradition can help. 

[28:04] **Alex**: So I think that's why things like the church calendar and also the Advent season and Christmas season in general, do really help to guide us, especially when we come to realize like, we're not the only ones living in this world.

[28:19] **Henry**: We're in community. We found a place to belong. People that understand. Or at least if we don't understand, God understands, right?

[28:29] **Alex**: Right. And I think that's also, you know, a re-application of Augustine's words, you know, I believe in order to understand.

> [Credo ut intelligam](https://en.wikipedia.org/wiki/Credo_ut_intelligam) is Latin for "I believe so that I may understand"

[28:35] **Henry**: I love that.

[28:36] **Alex**: If we were to demystify it. Make it less religious. We can just think of it as him saying, I enter into relationships, I trust other people. And that begins my journey of knowledge with the other.

[28:52] **Henry**: He's saying that knowledge requires faith, but in order to know a person you have to trust them, first.

[28:59] **Alex**: Yeah, you have to open. You have to do the risky act of opening up your life to them. 

[29:04] **Henry**: And you can apply that to not just people, but everything. And we're doing that in this season then, right? I'm thinking of like Charles Taylor again, being porous, right. Being able to be affected, by the external world instead of putting up a shield, right. 

[29:19] **Alex**: Right. Yeah. I mean, you can try to put a shield up all you want. But I think the reality is much closer to the fact that an arrow or two will find its way around your shield. I think that's just how we are. You can't completely isolate yourself. You will inevitably be affected by something. 

[29:39] **Henry**: Right, we are not that strong.

[29:41] **Alex**: Yeah. And even in like an almost interesting sense, I'm really going to not let anyone influence me is, in a way, letting other people influence you, right. Because you're still conceptualizing the other in how you determine your life.

[29:57] **Henry**: Maybe you're being affected the most by doing that.

[30:00] **Alex**: You'd have to be completely ignorant of the existence of other people or things, and then just be placed somewhere where you're just kind of breathing? I wouldn't even know.. How you would go about testing that social experiment. I couldn't imagine that it would be a very pleasant thing to undergo.

#### For Whom Should We Open Up To?

[30:20] **Alex**: And this is not.. I'll put this out there as a minister and as a pastor, I know like asking someone to open up their lives to others.. I'm not saying that it's super beautiful with no negative things. Like, no, it's a risk. Like we all know it's a risk.

[30:42] **Alex**: And the question is always going to be is, is it worth taking that risk? And there's always the other question for who should we take that risk? Definitely would not advise opening up your life to serial abusers if you know them. 

[30:57] **Alex**: It's being able to know. But the trick here is that you can't know unless you participate, right. And maybe you have some viewers out there who are super anxious about social relationships. And my advice is not like, you have to go a hundred percent, like open your life up to everything. But that's the one good thing about the internet, it helps a lot of people who have social anxiety. 

[31:26] **Alex**: And my advice, if anyone is wanting to take it, is like, look, you don't have to go out and try to meet people if you are super anxious about that. But try, in whatever safe space you're able to. May it be the Internet, anonymity might be helpful to you. But use that as an opportunity to help yourself gain trust, to also be trustworthy.

[31:52] **Alex**: But yeah, step out. The life has so much. The life that we have, you know, for me, from God, from Christ, there's just so much to experience. But like I said, it's just an advice that I have, take it or leave it. But I think it's a good encouragement, because that's what Jesus teaches me, is that life is wonderful. 

[32:18] **Alex**: And yes, there's a lot of really crappy stuff that happens to life. And I don't want to minimalize just how brutal life can be. But I still do think, based on who Christ is, what he's done and is going to do, as we see in Christmas, life is.. Life is worth it, especially life that we find in him.

[32:47] **Henry**: That's hope, right. It's not guaranteed, and we have to take steps to, like you said, put ourselves in that story, but I guess that's what this remembering is all about. 

[32:57] **Alex**: Yeah. Advent is about putting ourselves into the story of preparation waiting that happened way before we were even born. Advent is a story of Israel preparing and waiting for the coming of Jesus, whom they may not have known until he actually came. But they were waiting for God to come. 

> [Divinization](https://en.wikipedia.org/wiki/Divinization_(Christian)): "For the Son of God became man so that we might become God" - Athanasius 

[33:18] **Alex**: God just chose to come in this way. And it was necessary that he did. And Christmas is definitely a story that we can all participate. Because Christ himself participates in our humanity so that we are able to participate in the Triune God in divinity. I think it's mostly attributed to St. Athanasius, but he says something along the lines of God became man so that men might become God, right. We would need another podcast to parse out what exactly that means, but God came to live with us so that we can have this divine loving relationship with the source of all goodness, beauty and truth. 

[34:05] **Henry**: We reciprocate that.

[34:06] **Alex**: We participate in it. I do want to break one, not really myth, but one misconception I think it might be fun for the listeners. But Christmas, I was looking, I think it was Google search or something online. And they were talking about how like there's 25 days of Christmas. No, they're not 25 days of Christmas. There are four weeks of advent, which ends with Christmas. And Christmas is not one day. Christmas is 12 days. We have a song for this. It's called the 12 days of Christmas.

[34:44] **Alex**: And it ends with epiphany really. The introduction of the epiphany tide or to season of epiphany. And then we have a few days in between, and then we hit Lent. And start entering into the holiest part of the a Christian year. Yeah, good Friday and resurrection Sunday, but no one cares about the Saturday in between, which is like, just as important. Yeah. But we'll get there. We'll talk about that in a few months. All right. Thank you, Henry. 

[35:15] **Henry**: Thanks Alex.
